; $	HT	QT(F)		AF(F)		P(EZ)
; $ 	AT	QT(F)		AF(K)		P(E)
; $	AE	V(-)		H(90)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-help-uz_an_stzFlansch")
)

; INITIALISIERUNGSMETHODE (START)
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun init-connection ()

	(connect.showattributes CastaData)
	
	(setq LB_DEBUG 0)
	
  (init-traegerenden)				

  (calcUzStzFlanschAbst)
    	
  (setq blKpl 	(blech.create))
  (setq lchbKpl (lochbild.create))
	(Connect.storeAnschlObjs CastaData blKpl lchbKpl)
	
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
  		
  		; Kopfplatte
			(calcAndSetBlechdaten blKpl TrRechts)
			(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplatterechts_)

			; Lochbild
			(calcFlanschLochbildDaten lchbKpl blKpl)
			(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildrechts_)

			(createFlanschLochb lchbKpl blKpl)	
  	)
  )
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
  		
			; Kopfplatte
			(calcAndSetBlechdaten blKpl TrLinks)
			(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplattelinks_)
			; Lochbild
			(calcFlanschLochbildDaten lchbKpl blKpl)
			(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildlinks_)
			
			(createFlanschLochb lchbKpl blKpl)			
  	)
  )
  
  (korrigiereKpl blKpl lchbKpl)
  
	(if (= (Connect.get CastaData anz_weitere_anschl) 0) 
  	(if (= (Connect.get CastaData anschlZwHtEnden) 0)
				(eckeBegradigen)
		)
  )
  (print "*clear*")  
  (schiebeHTrLochbild)
;  (Lochbild_Fit4Rohr)
;  (Kopfplatte_Fit4Rohr)
  (Lochbild_Fit4Flachstahl)
  (Traeger_HT_Anpassen)


  (if (= LB_DEBUG 1) (progn
	(Lochbild.set  lchbKpl (e1 50) (e2 100))
	(Lochbild.copy lbdummy lchbKpl)
	(setq abtl_LB_AT (Traeger.get Tr_ID ABTeil lchbKpl))
	(setq abtl_LB_HT (Traeger.get HTrg  ABTeil lchbKpl))
	
	(Anbauteil.set abtl_LB_AT (Master 0))
	(Anbauteil.set abtl_LB_HT (Master 1))
  ))


  ; CALLBACK
  (Blech.set blKpl (formFkt "cb_KplBlech"))

)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_KplBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lchbKpl Klemml))
	       (setq altesDxS		(Lochbild.get lchbKpl dxsKopf))
	       
	       ; Da Lochbild an Kopfplatte gekoppelt, braucht dxSKopf nicht
	       ; angepasst werden
	       (Lochbild.set lchbKpl 	(Klemml (+ alteKlemml dpDiff))
	       			;	(DxSKopf (+ altesDxS dpDiff))
	       )
	       
	      
	    ))
	))
	
)

; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */

; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD
; ----------------------------------------------------------------------------------------
(defun	createFlanschLochb (flLochbild BLECH_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
  
	; allg. Daten
	; ----------------------------------------------
  (setq xPos 					(Connect.get CastaData xPos_HT)
  			afl_vwinkel 	(Connect.get CastaData afl_vwinkel)
  			htrg_vwinkel	(Connect.get CastaData hpttrg_vwinkel)
  )
  	
  (setq hProf					(Traeger.get Htrg h)
        delta_v_ht		(Traeger.get Htrg delta_v)      
  )
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
				r_winkel_at (Traeger.get Tr_ID r_winkel)
	)
	
	(setq dp_blech		(Blech.get BLECH_ID dp)
				dok_blech		(Blech.get BLECH_ID dok)
	)
	
	(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
	(setq sinAW (sin (/ (* PI afl_vwinkel) 180.0)))
	(print tanAW)
	(print sinAW)
	
	(if (= (connect.get CastaData amHtOberFlansch) 1) 	(setq Flansch _flanschlochbild_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) 	(setq Flansch _flanschlochbild_uf_))
  
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde (Traeger.get Tr_ID rechts)))
  
	
  (setq delta_lr_lb_abtl 0.0)
	(setq delta_v_lb_abtl 0.0)
	
	
  ; Winkel des Lochbildes festlegen
	; (abhngig von HT-Orientierung)
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
		(print "Winkel des LB berechnen")
		(setq wAbtl 0.0)
		
		(setq r_flansch (Connect.get CastaData r-atrgewnkl_flansch))
		(print r_flansch)
		
		; Die folgende Unterscheidung ist provisorisch, bis die Unterscheidung mglich ist
		(setq vwnkl_ht	(Connect.get CastaData hpttrg_vwinkel))
		(print vwnkl_ht)
		
		(if (<= vwnkl_ht 90.0)	
			(setq von_Unten_nach_Oben 1)
			(setq von_Unten_nach_Oben 0)
		)
		(print von_Unten_nach_Oben)
		(print r_winkel_at)
		
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	
			(progn
				(if (= (Connect.get CastaData linkesEnde) 1)
					(progn
						(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl (+ 180.0 r_flansch)))
						(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl (- 180.0 r_flansch)))
							
						(if (= (Connect.get CastaData vatr-lhtr) 0)	
							(progn
								(if (= von_Unten_nach_Oben 1)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (- r_winkel_at 180.0)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (+ 180.0 r_winkel_at)))
									)
								)
								(if (= von_Unten_nach_Oben 0)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (+ 360.0 r_winkel_at)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (- 180.0 r_winkel_at)))
									)
								)
							)
						)
					)
				)
				(if (= (Connect.get CastaData rechtesEnde) 1)
					(progn
						(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl r_flansch))
						(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl r_flansch))
							
						(if (= (Connect.get CastaData vatr-lhtr) 0)	
							(progn
								(if (= von_Unten_nach_Oben 1)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (+ 360.0 r_winkel_at)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (- 180.0 r_winkel_at)))
									)
								)
								(if (= von_Unten_nach_Oben 0)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (- r_winkel_at 180.0)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (+ 180.0 r_winkel_at)))
									)
								)
							)
						)
					)
				)
			)
		)
		(if (= (Connect.get CastaData amHtOberflansch) 1)	
			(progn
				(if (= (Connect.get CastaData linkesEnde) 1)
					(progn
						(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl r_flansch))
						(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl r_flansch))
							
						(if (= (Connect.get CastaData vatr-lhtr) 0)	
							(progn
								(if (= von_Unten_nach_Oben 1)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (+ 360.0 r_winkel_at)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (- 180.0 r_winkel_at)))
									)
								)
								(if (= von_Unten_nach_Oben 0)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (- r_winkel_at 180.0)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (+ 180.0 r_winkel_at)))
									)
								)
							)
						)
					)
				)
				(if (= (Connect.get CastaData rechtesEnde) 1)
					(progn
						(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl (+ 180.0 r_flansch)))
						(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl (- 180.0 r_flansch)))
							
						(if (= (Connect.get CastaData vatr-lhtr) 0)	
							(progn
								(if (= von_Unten_nach_Oben 1)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (- r_winkel_at 180.0)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (+ 180.0 r_winkel_at)))
									)
								)
								(if (= von_Unten_nach_Oben 0)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (+ 360.0 r_winkel_at)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (- 180.0 r_winkel_at)))
									)
								)
							)
						)			
					)
				)
			)
		)
		(print wAbtl)
		
			
		(print wAbtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	(print xPos)
	
	
	; Positionierung und Ausrichtung zum AT
	; Verschiebung auf die Hhe der AT-Oberkante
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
		(setq scherl_at (TrEnde.get TrgEnde vscherl))
		(setq delta_xPos (* 0.5 scherl_at))
		(print delta_xPos)
		
		(if (= (Connect.get CastaData linkesEnde) 1)
			(progn
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos (- xPos delta_xPos)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos (+ xPos delta_xPos)))
			)
		)
		(if (= (Connect.get CastaData rechtesEnde) 1)
			(progn
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos (+ xPos delta_xPos)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos (- xPos delta_xPos)))
			)
		)	
	; ----------------------------------------------
	))
	; ----------------------------------------------
  (print xPos)
  
	
	; Bercksichtigung der AT_Rotation
	; ----------------------------------------------
	(if (= 1 1)	(progn
	(print "ROTATION")
	; ----------------------------------------------
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq vscherl_at (TrEnde.get AtEnde vscherl))
	(print vscherl_at)
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(print vscherl_at_halb)
	
	(setq r_flansch (Connect.get CastaData r-atrgewnkl_flansch))
	
	(setq hilfsWnkl r_flansch)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq hilfsWnkl (- 360.0 r_flansch)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq hilfsWnkl r_flansch))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq hilfsWnkl r_flansch))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq hilfsWnkl (- 360.0 r_flansch)))
		)
	)
	
	(print r_flansch)
	(print hilfsWnkl)
	
	(print delta_lr_lb_abtl)
	(print delta_v_lb_abtl)
	
	(setq cosRW (cos (/ (* PI hilfsWnkl) 180.0)))
	(setq sinRW (sin (/ (* PI hilfsWnkl) 180.0)))
	
	
	(setq ankathete (* vscherl_at_halb cosRW))
	(setq gegenkathete (* vscherl_at_halb sinRW))
	(print ankathete)
	(print gegenkathete)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl 0.0))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (+ vscherl_at_halb ankathete )))
						)
					)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl 0.0))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (+ vscherl_at_halb ankathete )))
						)
					)
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (+ vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl 0.0))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete )))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete )))
						)
					)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (+ vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl 0.0))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete )))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete )))
						)
					)
				)
			)
		)
	)
	
	(print delta_lr_lb_abtl)
	(print delta_v_lb_abtl)
	
	
	; ----------------------------------------------
	))
	; ----------------------------------------------
  
	
	; die restlichen Korrekturen aus Trgerverschiebungen zusammenfassen
	(setq xPos_korr_ges 0) ; default
	; ----------------------------------------------
	(if (= 1 1) (progn
	(print "ANTEIL DER VERTIKALEN NEIGUNG")
	; ----------------------------------------------
	
		(setq einbauWinkel (Connect.get CastaData v-atrgewnkl_flansch))
		(print einbauWinkel)
		
		(setq tanEW (tan (/ (* PI einbauWinkel) 180.0)))
		(print tanEW)
		
		(setq h_ht_halb (* 0.5 hProf))
		(print h_ht_halb)
		(setq anteil_ht (+ h_ht_halb delta_v_ht))
		
		(setq anteil_vert_neigung (/ anteil_ht tanEW))
				
		(if (= (Connect.get CastaData linkesEnde) 1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_vert_neigung)))
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_vert_neigung)))
			
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Bercksichtigung der horizontalen Neigung
	; ----------------------------------------------
	(if (= 1 1)	(progn
	(print "ANTEIL DER HORIZONTALEN NEIGUNG")
	; ----------------------------------------------
		(setq h_ht 				(Traeger.get Htrg h)
					delta_v_ht	(Traeger.get Htrg delta_v)
		)
		
		(setq dp_kpl (Blech.get BLECH_ID dp))
		
		(setq hwnkl_at_flansch (Connect.get CastaData h-atrgewnkl_flansch))
		(print hwnkl_at_flansch)
		
		(setq h_ht_halb (* 0.5 h_ht))
		(setq anteil_ht (+ h_ht_halb delta_v_ht dp_kpl)) 
		(print anteil_ht)
		
		(setq tanHW (tan (/ (* PI hwnkl_at_flansch) 180.0)))
		(print tanHW)
		
		(setq anteil_horiz_neigung (/ anteil_ht tanHW))
		(print anteil_horiz_neigung)
		
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	
			(progn
				(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_horiz_neigung))
			)
		)
		(if (= (Connect.get CastaData amHtOberflansch)  1)	
			(progn
				(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_horiz_neigung))
			)
		)
		
		(print delta_lr_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	
	; VERSCHIEBUNGEN
	; --------------------------------------------------------------------------------------
	(if (= 1 1)	(progn
	
	; Verschiebung delta_v AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "Verschiebung delta_v AT")
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v))
	(print delta_v_at)
	(print delta_v_lb_abtl)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr)  0)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr)  0)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr)  0)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr)  0)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
				)
			)
		)
	)
	(print delta_v_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------

  ; Verschiebung delta_v HT
	; ----------------------------------------------
	(if (= 1 2) 	(progn
	; ----------------------------------------------
  (setq xPos_korr (/ delta_v_ht tanAW))
	(print xPos_korr)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq xPos_korr_ges (- xPos_korr_ges xPos_korr))
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq xPos_korr_ges (+ xPos_korr_ges xPos_korr))
	) 
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	(setq xPos (+ xPos xPos_korr_ges))
	(print xPos)
	(print wAbtl)
	
	
	
	
	
	; Verschiebung delta_lr AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "Verschiebung delta_lr AT")
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_lr_at)
	
	
	(print delta_lr_lb_abtl)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTOberflansch) 1) 	
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
				)
			)
			(if (= (Connect.get CastaData amHTUnterflansch) 1) 	
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTOberflansch) 1) 	
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
				)
			)
			(if (= (Connect.get CastaData amHTUnterflansch) 1) 	
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
				)
			)
		)
	)
	(print delta_lr_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; Verschiebung delta_lr HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "Verschiebung delta_lr HT")
	(setq delta_lr_ht	(Traeger.get Htrg delta_lr))
	(print delta_lr_ht)
	
	(setq anteil_an_delta_v_ht	(* sinRW delta_lr_ht))
	(print anteil_an_delta_v_ht)
	(setq anteil_an_delta_lr_ht	(* cosRW delta_lr_ht))
	(print anteil_an_delta_lr_ht)
	
	(print delta_lr_lb_abtl)
	(print delta_v_lb_abtl)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht)))
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht)))
						)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht)))
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht)))
						)
					)
				)
			)
		)
	)
	
	(print delta_lr_lb_abtl)
	(print delta_v_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	))
	
	; hinzufgen
	; ----------------------------------------------
  (Traeger.addabtl Htrg flLochbild xPos wAbtl Flansch)
  (print delta_lr_at)
  
  (setq abteil 	  (Traeger.get Htrg abteil flLochbild))
  (setq abteil_at (Traeger.get Tr_ID abteil flLochbild))
  
  
  
  (if (= 1 1) (progn
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht 1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)	(Anbauteil.set abteil (SeitRicht 1)))
		)
	)
	))
	
	
	(Anbauteil.set abteil 	(Master 	0)
				(delta_lr delta_lr_lb_abtl)
				(delta_v 	delta_v_lb_abtl)
	)
	(Anbauteil.set abteil_at 	(Master 1))
	
	(if (= LB_DEBUG 1)
		(progn
			; (Lochbild.set flLochbild (e2 400))
			
			(setq lbDummy (Lochbild.create))
			(Lochbild.copy lbdummy flLochbild)
			
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildrechts_)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildlinks_)
			)
			
			(setq abteil_dummy (Traeger.get Tr_ID abteil lbdummy))
			(Anbauteil.set abteil_dummy 		(Master 1))
		)
	)
	(print "------------------------------------------------------------")
	
	
)


; --------------------------------------------------------------------
; Begradigt die Rahmenecke wieder
; --------------------------------------------------------------------
(defun eckeBegradigen ()
	(print ">-------------------------------------------------------------------------------")
	(print "Begradige Sttzenecke")
	(setq HtEnde nil)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)  (setq HtEnde (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HtEnde (Traeger.get Htrg rechts)))
	(if HtEnde (progn
		(TrEnde.set HtEnde (v_winkel 90.0))
		
		; Verlngern und an AT anpassen
		(setq h_ht				(Traeger.get Htrg h))
		(setq afl_vwinkel (Connect.get CastaData afl_vwinkel))
		(setq delta_l			(TrEnde.get HtEnde delta_l))
		
		(setq h_ht_halb (* 0.5 h_ht))
		
		(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
		
		(setq delta_l_korr (/ h_ht_halb tanAW))
		(print delta_l)
		(print delta_l_korr)
		
		
		(if (= (Connect.get CastaData anHtLinkesEnde) 1)
			(setq delta_l (+ delta_l delta_l_korr))
		)
		(if (= (Connect.get CastaData anHtRechtesEnde) 1)
			(setq delta_l (- delta_l delta_l_korr))
		)	
			
		(TrEnde.set HtEnde (delta_l delta_l))
	))
	(print "<-------------------------------------------------------------------------------")
)
(defun schiebeHTrLochbild ()

    ; Anbauteile ermitteln -----------------------
    (setq abtl_Lchb_Htrg (Traeger.get Htrg abteil lchbKpl))

    (setq SeitRicht (Anbauteil.get abtl_Lchb_Htrg SeitRicht))
    (print SeitRicht)
    (Anbauteil.set abtl_Lchb_Htrg (SeitRicht 1))

    ; ---------------------------------------------
    (setq delta_Lr_HT (Traeger.get HTrg  delta_LR)
	  t_HTrg      (Traeger.get HTrg  t)
    )

    (setq delta_Lr_AT (Traeger.get Tr_ID delta_LR)
          delta_V_AT  (Traeger.get Tr_ID delta_V)
          h_Atrg      (Traeger.get Tr_ID h)
    	  s_Atrg      (Traeger.get Tr_ID s)
    )
    ; ---------------------------------------------
    (setq delta_LR_Ges delta_Lr_HT)

    (setq Winkel_Lchb_HTrg (Connect.get CastaData r-atrgewnkl_flansch))
    (setq cosRWnkl (cos (/ (* PI Winkel_Lchb_HTrg) 180.0))
          sinRWnkl (sin (/ (* PI Winkel_Lchb_HTrg) 180.0))
    )
    (setq Wnkl_Ges  (- Winkel_Lchb_HTrg))

	(connect.showattributes CastaData)


    (if (= (Connect.get CastaData linkesEnde) 1) (progn
        (setq lchb_RWinkel Wnkl_Ges)
        (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
    	    (if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
                (setq lchb_RWinkel (- Wnkl_Ges))
                (if (< lchb_RWinkel 0) (setq lchb_RWinkel (+ lchb_RWinkel 360.0)))
            ))
    	    (if (= (Connect.get CastaData vAtr-sHtr) 1) (progn
                (setq lchb_RWinkel Wnkl_Ges)
                (print Wnkl_Ges)
            ))
        ))
        (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
            (setq lchb_RWinkel (- Wnkl_Ges 180.0))
    	    (if (= (Connect.get CastaData vAtr-sHtr) 1) (progn
                 (setq lchb_RWinkel (- (- Wnkl_Ges 180.0)))
            ))
        ))
        ; (setq TrgEnde (Traeger.get Tr_ID links))
        ; (TrEnde.ptrim TrgEnde (* 0.5 t_HTrg))
    ))
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
        (setq lchb_RWinkel (- Wnkl_Ges 180.0))
        (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
    	    (if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
                (setq lchb_RWinkel (- Wnkl_Ges 180.0))
            ))
    	    (if (= (Connect.get CastaData vAtr-sHtr) 1) (progn
                (setq lchb_RWinkel (- (- Wnkl_Ges 180.0)))
            ))
        ))
        (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
            (setq lchb_RWinkel Wnkl_Ges)
    	    (if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
                (setq lchb_RWinkel (- Wnkl_Ges 180.0))
            ))
    	    (if (= (Connect.get CastaData vAtr-sHtr) 1) (progn
                (setq lchb_RWinkel (- (- Wnkl_Ges 180.0)))
            ))
        ))
        ; (setq TrgEnde (Traeger.get Tr_ID rechts))
        ; (TrEnde.ptrim TrgEnde (* 0.5 t_HTrg))
    ))

    (print lchb_RWinkel)
    (Anbauteil.set abtl_Lchb_Htrg
    		(winkel   lchb_RWinkel)
    )

    ; Master getauscht - damit Schrauben an Kopfplatte gekoppelt.
    ; Da Lochbild an Kopfplatte gekoppelt, braucht dxSKopf nicht
    ; angepasst werden
    (Lochbild.set lchbKpl (dxSKopf 0))

)
(defun XXXX ()

    (if (= (Connect.get CastaData satr-lhtr) 1) (progn
        (setq Wnkl_Ges (- Wnkl_Ges))
        (setq sinRWnkl (- sinRWnkl))
    ))
    
    (setq dp     (Blech.get   bFahnenbl dp)) 
    (setq v_Lchb_ges (/ h_Atrg -2.0))
    (setq v_Lchb_ges (+ v_Lchb_ges delta_V_AT))


    (setq Schrb_DX 0.0)		;; sicherheitshalber initialisieren ...
    (setq qsform_at	(Traeger.get Tr_ID qsform))

    
    ; lokale Verschiebungen des AT werden zum Schluss erst aufgebracht ...
    ; da diese vom Rotationswinkel vllig unabhngig sind.
    ; Beim Blech ist es nicht an den Winkel des Blechs auf dem Trger
    ; gebunden. Deswegen wird die seitliche Verschiebung
    ; direkt am Blech angebracht und nicht am Anbauteil.
   
    (if (= (Connect.get CastaData linkesEnde) 1) (progn

        (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
            (setq v_Lchb_ges (+ v_Lchb_ges (* sinRWnkl delta_Lr_HT)))
            (setq delta_SX_Ges (- (* cosRWnkl delta_LR_Ges)))
            (setq lchb_RWinkel Wnkl_Ges)
    	    (setq delta_SX_Ges (+ delta_SX_Ges delta_Lr_AT))
    	    (setq delta_V_AT (- delta_V_AT))
            (setq Schrb_DX  (* 0.5 s_ATrg))
            (if (= qsform_at "U") 
                (setq Schrb_DX  0)
            )
        ))
        (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
            (setq v_Lchb_ges (- v_Lchb_ges (* sinRWnkl delta_Lr_HT)))
            (setq delta_SX_Ges (* cosRWnkl delta_LR_Ges))
            (setq lchb_RWinkel (- Wnkl_Ges 180))
            (setq delta_SX_Ges (- delta_SX_Ges delta_Lr_AT))
            (setq Schrb_DX (+ (* 0.5 s_ATrg) dp))
            (if (= qsform_at "U") 
                (setq Schrb_DX (+ s_ATrg dp))
            )
        ))
    ))
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn

        (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
            (setq v_Lchb_ges (- v_Lchb_ges (* sinRWnkl delta_Lr_HT)))
            (setq delta_SX_Ges (* cosRWnkl delta_LR_Ges))
            (setq lchb_RWinkel (- Wnkl_Ges 180))
            (setq delta_SX_Ges (- delta_SX_Ges delta_Lr_AT))
            (setq Schrb_DX (+ (* 0.5 s_ATrg) dp))
            (if (= qsform_at "U") 
                (setq Schrb_DX (+ s_ATrg dp))
            )
        ))
        (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
            (setq v_Lchb_ges (+ v_Lchb_ges (* sinRWnkl delta_Lr_HT)))
            (setq delta_SX_Ges (- (* cosRWnkl delta_LR_Ges)))
            (setq lchb_RWinkel Wnkl_Ges)
    	    (setq delta_SX_Ges (+ delta_SX_Ges delta_Lr_AT))
    	    (setq delta_V_AT (- delta_V_AT))
            (setq Schrb_DX  (* 0.5 s_ATrg))
            (if (= qsform_at "U") 
                (setq Schrb_DX  0)
            )
        ))
    ))

    (Lochbild.set lchbAtrgSteg (dxskopf Schrb_DX))
   
    (Anbauteil.set abtl_Fahne
    		(delta_v  0)
    		(delta_lr delta_LR_Ges)
    		(winkel   Wnkl_Ges)
    )
    (Anbauteil.set abtl_Lchb_Htrg
    		(delta_v  v_Lchb_ges)
    		(delta_lr 0)
    		(delta_sx delta_SX_Ges)
    		(winkel   lchb_RWinkel)
    )
    
    (setq lokal_Blech_LR (* 0.5 (+ s_ATrg dp)))
    (if (= qsform_at "U") 
        (setq lokal_Blech_LR (+ (* 0.5 s_ATrg) dp))
    )

    (setq lokal_Blech_LR (+ lokal_Blech_LR delta_Lr_AT))
    
    
    
    (Blech.set bFahnenbl
    		(dOK      (- delta_V_AT))
    		(delta_lr lokal_Blech_LR)
    )
)
; ----------------------------------------------------------
(defun Lochbild_Fit4Rohr ()
  (setq QTyp (Traeger.get Tr_ID QsForm))
  (if (= QTyp "R") (progn
     (setq bProf (Traeger.get Tr_ID b))
     (setq w0    (Lochbild.get lchbKpl w0)
           sD    (Lochbild.get lchbKpl SDurchm)
     )
     (if  (> (+ bProf (* 3.0 sD)) w0) (progn
         (print "SBild anpassen, weil es mit Rohrprofil kollidiert ....")
         (setq w0Neu (+ bProf (* 3.0 sD)))
         (Lochbild.set lchbKpl (w0 w0Neu))
         (setq bp (Blech.get blKpl bp))
         (if (< bp (+ w0Neu (* 3.0 sD))) (Blech.set blKpl (bp (+ w0Neu (* 3.0 sD)))))
     ))
     
     (if (/= (Connect.get CastaData sAtr-sHTr) 0) (progn
	(setq w0    (Lochbild.get lchbKpl w0))
	(if (< bProf (+ w0 (* 3.0 sD))) (alertBox "Achtung - Breite des Haupttrgers reicht nicht aus!"  "HT_MinWidth"))
     ))
     
     (setq e0 (Lochbild.get lchbKpl e0)
     	   e1 (Lochbild.get lchbKpl e1)
     )
     (if (= e1 0) (progn
         (setq hProf (Traeger.get Tr_ID h))
         (setq e0Neu (/ hProf 2.0))
         (Lochbild.set lchbKpl (e0 e0Neu))
     ))
  ))
)
(defun Kopfplatte_Fit4Rohr ()
  (setq QTyp (Traeger.get Tr_ID QsForm))
  (if (= QTyp "R") (progn
     (setq hProf (Traeger.get Tr_ID h))
     (setq hp (Blech.get blKpl hp))
     (if (< hp hProf) (progn
         (setq hpNeu   (runde (+ hProf 20.0) auf 10))
         (setq dOKNeu  (- (/ (- hpNeu hProf) 2.0)))
         
         (Blech.set blKpl (hp hpNeu) (dOK dOKNeu))
     ))
  
  ))
)
(defun Lochbild_Fit4Flachstahl ()
  (setq QTyp (Traeger.get Tr_ID QsForm))
  (if (= QTyp "F") (progn
     (setq hp_Bl 	(Blech.get blKpl hp)
     	   dOK_Bl	(Blech.get blKpl dOK)
     	   bp_Bl	(Blech.get blKpl bp)
     )
     (setq t_AT		(Traeger.get Tr_ID t))
     (setq b_HT		(Traeger.get HTrg b))

     (setq AbstOben (* 0.5 (- dOK)))
     (setq AbstOben (runde AbstOben auf 5))
     
     (setq e0 (- (* 0.5 hp_Bl) (* 0.5 t_AT)))
     (setq e0 (* 0.5 (- hp_Bl AbstOben AbstOben t_AT)))
     (setq e1 (+ e0 e0 t_AT))
     (Lochbild.set lchbKpl (S_Bez "M16") (e0 (- e0)) (e1 e1))
     
     (if (< b_HT 80) (Lochbild.set lchbKpl (S_Bez "M12")))
     
     (setq w0 (Lochbild.get lchbKpl w0))
     (if (> (+ w0 30) b_HT) (progn 
     	(Lochbild.set lchbKpl (w0 0))
        (Blech.set blKpl (bp b_HT))
     ))

     
  ))
)
(defun Traeger_HT_Anpassen ()

  (setq Tre_HT nil)
  (if (= (Connect.get CastaData AnHtLinkesEnde)  1) (setq Tre_HT (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData AnHtRechtesEnde) 1) (setq Tre_HT (Traeger.get HTrg rechts)))
  
  (if Tre_HT (progn
	  (setq dlEnde (TrEnde.get Tre_HT delta_L))
  	(setq hp_Bl (Blech.get blKpl hp))
  
  	(if (> dlEnde (* -0.5 hp_Bl)) (progn
		(setq dlEndeNeu (* 0.5 hp_BL))
		(TrEnde.set Tre_HT (delta_L (- dlEndeNeu)))
  	))
  ))

)