; $		HT	QT(IUK)		AF(S)		P(EZ)
; $ 		AT	QT(K)		AF(K)		P(E)
; $		AE	V(90)		H(90)		R(-)

; ------------------------------------------------
; externe Module einbinden
; ------------------------------------------------
(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
   (load "mod-lochbild")
)
; ------------------------------------------------


(defun init-connection ()

   (setq AnschlussErstellen 1)
   (setq qsform_Ht (Traeger.get HTrg qsform))

   (if (= AnschlussErstellen 1) (progn

  	(print "INITIALISIERE: uz_a_uzStegFahne.lsp");
	(print "================================================================================")
	
	; Debug-Informationen fr Lochbild anzeigen
	; ----------------------------------------------
	(setq LB_DEBUG 0)
        (print "*clear*")
	(Connect.showAttributes CastaData)
	
	
	; Zurechtschneiden der Trgerenden
	; ----------------------------------------------
	(init-traegerenden)

	; Setzen der Verbindung
	; ----------------------------------------------
	(setConnection)

	; (print "*clear*")

  
	(if (= 1 2) (progn
	     (setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
	     (setq dlr_Abtl_Lchb_AT (Anbauteil.get Abtl_Lchb_AT delta_lr))
	
	     (setq Abtl_Lchb_HT (Traeger.get HTrg ABTeil lchbAtrgSteg))
	     (setq dlr_Abtl_Lchb_HT (Anbauteil.get Abtl_Lchb_HT delta_lr))
	     (print dlr_Abtl_Lchb_AT)
	     (print dlr_Abtl_Lchb_HT)
	
	))

	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
	   (setq tLinks (Traeger.get Tr_ID links))
	   (TrEnde.ptrim tLinks 5.0)
	   (setq delta_L_Trg (TrEnde.get tLinks delta_L))
	   (print delta_L_Trg)
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
	   (setq tRechts (Traeger.get Tr_ID rechts))
	   (TrEnde.ptrim tRechts 5.0)
	   (setq delta_L_Trg (TrEnde.get tRechts delta_L))
	   (print delta_L_Trg)
	))

	(if (= 1 2) (progn
	    (setq dxSK_Test (Lochbild.get lchbAtrgSteg dxSKopf))
	    (print dxSK_Test)
	))

        (korrigiereAblaengung)
    ))
	
	(setq Abtl_Fahne (Traeger.get HTrg ABTeil  FahnenBl_1))
	(setq xPos_Abtl (Anbauteil.get  Abtl_Fahne xPos))
	(setq xPos_HT (Connect.get CastaData xPos_HT))


	(if (= 1 2) (progn
		(Lochbild.set lchbAtrgSteg (e "0 20 80 0 0 0"))
	))
	(if (= 2 2) (progn
		; (Anbauteil.set Abtl_Fahne (delta_V 0.0))
		(setq dxSKopf_Curr (Lochbild.get lchbAtrgSteg dxSKopf))
		; (AlertBox dxSKopf_Curr)
		; (Lochbild.set lchbAtrgSteg (dxSKopf 20))
	))
	
	(if (= 2 1) (progn
		(debugBlechDaten "Abschluss")
	))
	
)

(defun debugBlechDaten_1 (Text)
	(print "empty function")
)

(defun debugBlechDaten (Text)
		(setq dOK_1 (Blech.get FahnenBl_1 dOK))
		(setq dOK_2 (Blech.get FahnenBl_2 dOK))
		(setq dLR_1 (Blech.get FahnenBl_1 delta_LR))
		(setq dLR_2 (Blech.get FahnenBl_2 delta_LR))
		
		(setq ablt_FBl_1 (Traeger.get HTrg ABTeil FahnenBl_1))
		(setq ablt_FBl_2 (Traeger.get HTrg ABTeil FahnenBl_2))
		
		(setq dv_Abtl_1 (Anbauteil.get ablt_FBl_1 delta_V))
		(setq dv_Abtl_2 (Anbauteil.get ablt_FBl_2 delta_V))
		(setq dlr_Abtl_1 (Anbauteil.get ablt_FBl_1 delta_LR))
		(setq dlr_Abtl_2 (Anbauteil.get ablt_FBl_2 delta_LR))

		(AlertBox Text)
;		(AlertBox dOK_1) (AlertBox dOK_2)
;		(AlertBox dv_Abtl_1) (AlertBox dv_Abtl_2)
;		(AlertBox dlr_Abtl_1) (AlertBox dlr_Abtl_2)
		(AlertBox dLR_1) (AlertBox dLR_2)

)

; ----------------------------------------------------------------------------------------
; Erzeugt und setzt die Anbauteile der Verbindung
; ----------------------------------------------------------------------------------------
(defun setConnection ()

	(setq abstZumSteg 10) 
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  (setq FahnenBl_1 (blech.create))
  (setq lchbAtrgSteg (Lochbild.create))

  (setq Fahnenbl_2 (blech.create))

  (Connect.storeAnschlObjs CastaData FahnenBl_1 lchbAtrgSteg)
  (Connect.storeAnschlObjs CastaData Fahnenbl_2)
  
	(print "Fahnenblech erzeugt")
  (Blech.set FahnenBl_1  (dp 10) (hp 200) (bp 100) (dOK 0))
  (Blech.set Fahnenbl_2 (dp 10) (hp 200) (bp 100) (dOK 0))
  
  
	(print "Default Blechdaten")
  (setq XPos (Connect.get CastaData XPos_HT))
  (print XPos)
	
	;(calcXPosFahne)
	
	; Berechnet den Winkel des Fahnenblech-Anbauteils
	; ----------------------------------------------
	(calcRotationFahne) ; -> abtl_fahne_winkel

	(setq LB_XPos_Offset 0.0)
  ; Anschlsse am Steg des Haupttrgers
	(if (= (Connect.get CastaData amHtStegLinks) 1) 	(progn
	
		; (setq abtl_fahne_winkel 90)
		; (AlertBox  abtl_fahne_winkel)
  		(print "Anschluss am Steg links")
  		(traeger.addabtl hTrg FahnenBl_1   XPos abtl_fahne_winkel _fahnenblech_steg_li_)
  		(traeger.addabtl hTrg Fahnenbl_2   XPos abtl_fahne_winkel _fahnenblech_steg_li_)
	
		    (setq	dp_Blech (Blech.get  FahnenBl_1 dp))
			(setq	b_AT		(Traeger.get Tr_ID b)
					dlr_AT	(Traeger.get Tr_ID delta_LR)
			)
			(setq	xPos_Offset (+ (* 0.5 b_AT) (* 0.5 dp_Blech)))
			
			(if (= (Connect.get CastaData LinkesEnde) 1) 	(progn		
					(print  "Fall 1")
					(calcAndSetBlechdaten FahnenBl_1 TrLinks 	xPos_Offset)
					
					(calcAndSetLochbildDaten lchbAtrgSteg FahnenBl_1 TrLinks 2)
					(copyBlechDaten  FahnenBl_1  FahnenBl_2)

					(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)

					(calcAndSetBlechdaten Fahnenbl_2 TrLinks (- xPos_Offset))
					
					(setq LB_XPos_Offset (+ (* -0.5 b_AT) (*  -1.0 dp_Blech)))
					(setq LB_XPos_Offset (+ LB_XPos_Offset dlr_AT))

			))
			(if (= (Connect.get CastaData RechtesEnde) 1) (progn			
					(print "Fall 2")
					(calcAndSetBlechdaten FahnenBl_1 TrRechts 	xPos_Offset)

					(calcAndSetLochbildDaten lchbAtrgSteg FahnenBl_1 TrRechts -2)
					(copyBlechDaten  FahnenBl_1  FahnenBl_2)

					(setq trgLaenge (Traeger.get Tr_ID syslng))
					(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)

					(calcAndSetBlechdaten Fahnenbl_2 TrRechts (- xPos_Offset))

					(setq LB_XPos_Offset (+ (* -0.5 b_AT) (*  -1.0 dp_Blech)))
					(setq LB_XPos_Offset (- LB_XPos_Offset dlr_AT))
			))
   	))
	(if (= (Connect.get CastaData amHtStegRechts) 1)  (progn
			(print "Anschluss am Steg rechts")
			(traeger.addabtl hTrg FahnenBl_1    XPos abtl_fahne_winkel _fahnenblech_steg_re_)
			(traeger.addabtl hTrg Fahnenbl_2  XPos abtl_fahne_winkel _fahnenblech_steg_re_)

		    (setq	dp_Blech	(Blech.get  FahnenBl_1 dp))
			(setq	b_AT		(Traeger.get Tr_ID b)
					dlr_AT		(Traeger.get Tr_ID delta_LR)
			)
			(setq xPos_Offset (+ (* 0.5 b_AT) (* 0.5 dp_Blech)))
			
			(if (= (Connect.get CastaData LinkesEnde) 1)	(progn	
					(print "Fall 3")
					(calcAndSetBlechdaten FahnenBl_1 TrLinks xPos_Offset)

					(calcAndSetLochbildDaten lchbAtrgSteg FahnenBl_1 TrLinks 2)
					(copyBlechDaten  FahnenBl_1  FahnenBl_2)
					
					(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)

					(calcAndSetBlechdaten Fahnenbl_2 TrLinks (- xPos_Offset))
					
					(setq LB_XPos_Offset (+ (* -0.5 b_AT) (*  -1.0 dp_Blech)))
					(setq LB_XPos_Offset (- LB_XPos_Offset dlr_AT))

			))
			(if (= (Connect.get CastaData RechtesEnde) 1) (progn			
					(print  "Fall 4")
					(calcAndSetBlechdaten FahnenBl_1 TrRechts 		xPos_Offset)
					(calcAndSetLochbildDaten lchbAtrgSteg FahnenBl_1 TrRechts -2)
					(copyBlechDaten  FahnenBl_1  FahnenBl_2)
					
					(setq trgLaenge (Traeger.get Tr_ID syslng))
					(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
					(calcAndSetBlechdaten Fahnenbl_2 TrRechts	(- xPos_Offset))

					(setq LB_XPos_Offset (+ (* -0.5 b_AT) (*  -1.0 dp_Blech)))
					(setq LB_XPos_Offset (+ LB_XPos_Offset dlr_AT))
	

			))
   	))

	; Anbauteil des Fahnenbleches
	; ----------------------------------------------
	
	(calcPositionFahne FahnenBl_1   1)
	(calcPositionFahne Fahnenbl_2  -1)
	;(berechneFahnenblechNeigung abtl_fahne)

	; neu .... Fahne um halbe Profilbreite verschieben
	; andere Fahne dann in Gegenrichtung
	
	
  ; Lochbild HT
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil FahnenBl_1))
;	(Traeger.addabtl Htrg lchbAtrgSteg XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
	(Traeger.addabtl Htrg lchbAtrgSteg XPos   0.0 _fahnblLochbild_ AbtlFahnenBl)
	
	; Check ...
	; (setq AbtlLchb_HT (Traeger.get HTrg ABTeil lchbAtrgSteg))
	; (setq rWinkel (Anbauteil.get AbtlLchb_HT Winkel))
	; (AlertBox rWinkel)

	(setLochbild lchbAtrgSteg LB_XPos_Offset)
  
	  (if (= 2 3) (progn
		;; Testen - AF-20090610
		; (Lochbild.set lchbAtrgSteg (LB_Art   2))		; AF-20090512
		; (Lochbild.set lchbAtrgSteg (delta_w  50))		; AF-20090512
		(Lochbild.set lchbAtrgSteg (e    "0 30 100 0 0 0"))	; AF-20090512
		; (Lochbild.set lchbAtrgSteg (w    "23 40"))		; AF-20090512
	  ))
  
	
  ; CALLBACKS
	(Blech.set FahnenBl_1 (formFkt "cb_FahnenBl_1"))
	(Blech.set FahnenBl_2 (formFkt "cb_FahnenBl_2"))
	


	
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_FahnenBl_1 (zp)
	(print "in Callback-Funktion cb_FahnenBl_1")
	(print zp)
;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get FahnenBl_1 dp))
		(setq  lb_ht_abtl (Traeger.get HTrg ABTeil  lchbAtrgSteg))
		(setq lb_Delta_SX_alt (Anbauteil.get  lb_ht_abtl delta_SX))
		(setq bl_LR_alt (Blech.get  FahnenBl_1 delta_LR))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.


	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get FahnenBl_1 dp))
		(setq  lb_ht_abtl (Traeger.get HTrg ABTeil  lchbAtrgSteg))
		(Anbauteil.set  lb_ht_abtl (delta_SX  lb_Delta_SX_alt))
	    
		(setq bl_LR_neu (Blech.get  FahnenBl_1 delta_LR))

	    (if (/= bl_LR_alt bl_LR_neu) (progn
			(if (/= dpAlt dpNeu) (progn
				(AlertBox "Bitte Blechdicke und seitlich Verschiebung des Blechs einzeln ndern, da es sich gegenseitig beeinflusst. Seiltiche Verschiebung wird  hier automatisch gendert.")
			))
			(if (= dpAlt dpNeu) (progn
				(setq alteKlemml (Lochbild.get lchbAtrgSteg Klemml))
				(setq dlr_Diff (- bl_LR_neu bl_LR_alt))
				
				(setq klemml_neu	(+ alteKlemml dlr_Diff))
				(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu))

			))
		))
	    
	    (if (/= dpAlt dpNeu) (progn
				(setq dpDiff (- dpNeu dpAlt))
				(setq alteKlemml (Lochbild.get lchbAtrgSteg Klemml))
				(setq dxsKopf_alt	(Lochbild.get lchbAtrgSteg dxskopf))
				
				(setq klemml_neu	(+ alteKlemml dpDiff))
			 
				(print alteKlemml)
				(print klemml_neu)


			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu))
			   
			
			(setq delta_lr_lasche_alt	(Blech.get FahnenBl_1 delta_lr))
			   
			(setq delta_lr_lasche_neu (+ delta_lr_lasche_alt (* 0.5 dpDiff)))
			(print delta_lr_lasche_neu)
			
			; Problem war, dass durch das Kopieren die seitliche Verschiebung
			; schon korrekt bernommen war. Also soll hier beim seitlichen
			; Verschieben diese nderung nicht nocheinmal durchgefhrt werden.
			(if _CopyAction_ (setq delta_lr_lasche_neu delta_lr_lasche_alt))
			
			(Blech.set FahnenBl_1 (delta_lr delta_lr_lasche_neu))
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu))
			   
	    ))
	))
)
; ====================================================================== 
(defun cb_FahnenBl_2 (zp)
	(print  "in Callback-Funktion cb_FahnenBl_2")
	(print zp)
;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get FahnenBl_2 dp))
		(setq  lb_ht_abtl (Traeger.get HTrg ABTeil  lchbAtrgSteg))
		(setq lb_Delta_SX_alt (Anbauteil.get  lb_ht_abtl delta_SX))
		(setq bl_LR_alt (Blech.get  FahnenBl_2 delta_LR))
		;; Schrauben delta_SX des Anbauteils wird von Formular-Funktion umgesetzt. Ist gltig
		;; fr alle Fahnenanschlsse, hier aber passt es nicht. Daher alte Verschiebung merken und
		;; auf jeden Fall nach der Formularfunktionsausfhrung wieder drauf setzen.
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get FahnenBl_2 dp))
		(setq  lb_ht_abtl (Traeger.get HTrg ABTeil  lchbAtrgSteg))
		(Anbauteil.set  lb_ht_abtl (delta_SX  lb_Delta_SX_alt))
	    
		(setq bl_LR_neu (Blech.get  FahnenBl_2 delta_LR))

	    (if (/= bl_LR_alt bl_LR_neu) (progn
			(if (/= dpAlt dpNeu) (progn
				(AlertBox "Bitte Blechdicke und seitlich Verschiebung des Blechs einzeln ndern, da es sich gegenseitig beeinflusst. Seiltiche Verschiebung wird  hier automatisch gendert.")
			))
			(if (= dpAlt dpNeu) (progn
				(setq alteKlemml (Lochbild.get lchbAtrgSteg Klemml))
				(setq dlr_Diff (- bl_LR_neu bl_LR_alt))
				
				(setq klemml_neu	(- alteKlemml dlr_Diff))
				(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu))

				(setq lb_Delta_SX_neu (+ lb_Delta_SX_alt  dlr_Diff))
				(Anbauteil.set  lb_ht_abtl (delta_SX  lb_Delta_SX_neu))

			))
		))
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lchbAtrgSteg Klemml))
	       (setq klemml_neu	(+ alteKlemml dpDiff))

		   (setq lb_Delta_SX_neu (- lb_Delta_SX_alt (* 1.0 dpDiff)))
			(Anbauteil.set  lb_ht_abtl (delta_SX  lb_Delta_SX_neu))
	     
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu))
			   
			
			(setq delta_lr_lasche_alt	(Blech.get FahnenBl_2 delta_lr))
			(setq delta_lr_lasche_neu (- delta_lr_lasche_alt (* 0.5 dpDiff)))
		
			; Problem war, dass durch das Kopieren die seitliche Verschiebung
			; schon korrekt bernommen war. Also soll hier beim seitlichen
			; Verschieben diese nderung nicht nocheinmal durchgefhrt werden.
			(if _CopyAction_ (setq delta_lr_lasche_neu delta_lr_lasche_alt))
		
			 (Blech.set FahnenBl_2 (delta_lr delta_lr_lasche_neu))
	       
	    ))
	))
)
; ====================================================================== 






; ----------------------------------------------------------------------------------------
; Whlt anhand des AT-Profils wie die Blechdaten berechnet werden
; ----------------------------------------------------------------------------------------
(defun calcAndSetBlechdaten (fahnenblech TrgEnde dpDiff)
	(setq qsform_at (Traeger.get Tr_ID qsform))

	(if (= qsform_at "I")
		(calcAndSetBlechdaten_IProfil fahnenblech TrgEnde)
	)
	(if (= qsform_at "K") (progn
		(calcAndSetBlechdaten_IProfil fahnenblech TrgEnde)
		(setq dlr (Blech.get  fahnenblech delta_LR))
		(Blech.set  fahnenblech (delta_LR (+  dlr  dpDiff)))
	))
	
	(if (= qsform_at "U")
		(calcAndSetBlechdaten_UProfil fahnenblech TrgEnde)
	)
	(Blech.set fahnenblech (dOK 0))

	(if (= (Connect.get CastaData satr-vhtr) 0) (progn
		(setq dv_AT (Traeger.get Tr_ID delta_V))
		(setq dv_HT (Traeger.get HTrg  delta_V))
		(setq curr_dOK 0)
	
		(if (= (Connect.get CastaData vatr-vhtr) -1) (setq curr_dOK (- (+ dv_HT dv_AT))))
		(if (= (Connect.get CastaData vatr-vhtr)  1) (setq curr_dOK (- dv_AT dv_HT)))
	
		(Blech.set fahnenblech (dOK curr_dOK))
	))

;	(setq abtl_FahBl (Traeger.get HTrg ABTeil fahnenblech))
;	(setq rWinkel    (Anbauteil.get abtl_FahBl Winkel))
;	(setq dv_Abtl_HT (Anbauteil.get abtl_FahBl delta_V))
	
	
)

; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech fr ein I-Profil
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten_IProfil (fahnenblech TrgEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN I-PROFIL")
	

	(setq 	hc_trg 				(Traeger.get Tr_ID hc)
				delta_v_trg 	(Traeger.get Tr_ID delta_v)
				delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
				rwnkl_trg			(Traeger.get Tr_ID r_winkel)
				hProf  				(Traeger.get Tr_ID h)
				tSteg 				(Traeger.get Tr_ID s)
				t_trg					(Traeger.get Tr_ID t)
				r_trg					(Traeger.get Tr_ID r)
				qsform_AT		(Traeger.get Tr_ID qsform)
	)
	(setq delta_v_htrg	(Traeger.get Htrg delta_v)
				qsform				(Traeger.get Htrg qsform)
	)
	
	(if (= qsform_AT "K") (progn 
			; Kastenprofile haben kein hc-Ma - das also auf Profilhhe setzen
			(setq  hc_trg 	hProf)
			; An Kastenprofilen wird nicht ausgeklinkt, daher die Ausklinkung sicherheitshalber
			; entfernen.
			(if (= qsform "K") (TrEnde.set   TrgEnde (zAkl 0) (xAkl 0)  (hsteg 0)))
	))
	
	
	(setq	zAkl   (trEnde.get TrgEnde zakl)
				hSteg  (trEnde.get TrgEnde hsteg)
	)
	
	
	(setq vwinkel_uz (Connect.get CastaData hpttrg_vwinkel))

	(if (< okAusr_htprof okAusr_anprof)
		(setq diff_dok (* 0.5 (- okAusr_htprof okAusr_anprof)))
		(setq diff_dok 0)
	)
	
	(setq hp hc_trg)
	(setq dp	(runde tSteg auf 5))
	
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq diffWinkel (+ vwinkel_uz rwnkl_trg)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq diffWinkel (- vwinkel_uz rwnkl_trg )))
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq diffWinkel (- vwinkel_uz rwnkl_trg)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq diffWinkel (+ vwinkel_uz rwnkl_trg )))
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	
	(setq dv (- (* delta_v_htrg cosW) delta_v_trg))
	
	(if (= 1 1) (progn
	(if (> zAkl 0) 
		(progn
	    (if (> hSteg 0)
	    	(progn 															; Doppelausklinkung
	        (setq dOK (- diff_dok);0;delta_v_trg 
	        			hp  hSteg 
	        )
	      )
	      (progn															; nur obere Ausklinkung										
	        (setq hRest (- hProf zAkl))
	      	(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg))))
	        (setq dOK (+ (- dv) helpVar) 
	        			hp (- hRest t_trg r_trg)
	        )
	      )													
	    )
	  ) ; progn
	  (progn
	    (if (> hSteg 0)
	    	(progn															; nur untere Ausklinkung
	    		(setq zAkl_u	(- hProf hsteg))
				(setq helpVar	(- zAkl_u (+ t_trg r_trg))) 
				(print helpVar)
				(setq dOK (- (- dv) (* 0.5 helpVar))
	        			hp (- hSteg t_trg r_trg)
				)			
	      )
	      (progn															; keine Ausklinkung
	        (setq dOK 0 hp hc_trg)		
	      )
	    )
	  ) ; progn
	)
))

	
	
	(if (= rwnkl_trg 180.0) 
		(progn
			(setq delta_v_trg (- delta_v_trg))
			(setq delta_lr_trg (- delta_lr_trg))
		)
	)
	
	
	(print tSteg)
	(print dp)

	; Bei i-Profilen halbe Stegdicke Blech verschieben
	(setq delta_lr_soll (* 0.5 (+ tSteg dp)))
	(setq	qsform_AT		(Traeger.get Tr_ID qsform))
	(if (= qsform_AT "K") (setq  delta_lr_soll 0))
		
	(print delta_lr_soll)
	(setq s_htrg (Traeger.get Htrg s))
	
	; Anteil delta_lr AT
	(if (= (Connect.get CastaData vatr-lhtr)  1)	
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)	
	(if (= (Connect.get CastaData vatr-lhtr) -1)	
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr)  0)
		(progn
			(setq delta_v_htrg 0.0)
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)
	
	; Anteil delta_v HT
	
	; (debugBlechDaten "Fahnenblech-Check")

	; Blech in delta_lr
	(setq anteil_dlr_an_dvht (* delta_v_htrg sinW))
	
	(setq delta_lr_soll (- delta_lr_soll anteil_dlr_an_dvht))

	; BLECHDATEN:
	; -----------
	(Blech.set fahnenblech 	(dp 				dp) 
							(hp 				hp) 
							(dok 				dOK) 
							(delta_lr 	delta_lr_soll)
	)
)

; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech fr ein U-Profil
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten_UProfil (fahnenblech TrgEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE FAHNENBLECH U-PROFIL")
	
	(setq hc_trg 				(Traeger.get Tr_ID hc)
				delta_v_trg 	(Traeger.get Tr_ID delta_v)
				delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
				rwnkl_trg			(Traeger.get Tr_ID r_winkel)
				hProf  				(Traeger.get Tr_ID h)
				tSteg 				(Traeger.get Tr_ID s)
				t_trg					(Traeger.get Tr_ID t)
				r_trg					(Traeger.get Tr_ID r)
	)
	(setq delta_v_htrg	(Traeger.get Htrg delta_v)
				qsform				(Traeger.get Htrg qsform)
	)
	
	(setq zAkl   (trEnde.get TrgEnde zakl)
	      hSteg  (trEnde.get TrgEnde hsteg)
	)
	(print "---------")
	(print zAkl)
	(print hSteg)
	(print hProf)
	(print "---------")
	(print hc_trg)
	(print delta_v_trg)
	(print delta_lr_trg)
	(setq hp hc_trg)
	
	(setq dp	(runde tSteg auf 5))
	
	(setq dv (- delta_v_htrg delta_v_trg))
	
(if (= 1 1) (progn
	(if (> zAkl 0) 
		(progn
	    (if (> hSteg 0)
	    	(progn 															; Doppelausklinkung
	        (setq dOK 0;delta_v_trg 
	        			hp (- hSteg 10)
	        )
	      )
	      (progn															; nur obere Ausklinkung										
	        (setq hRest (- hProf zAkl))
	      	(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg))))
	        (setq dOK (+ (- dv) helpVar) 
	        			hp (- hRest t_trg r_trg 10)
	        )
	      )													
	    )
	  ) ; progn
	  (progn
	    (if (> hSteg 0)
	    	(progn															; nur untere Ausklinkung
	    		(setq hRest (- hProf zAkl))
	      	(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg)))) 
	        (setq dOK (+ (- dv) helpVar)
	        			hp (- hSteg t_trg r_trg 10)
	        )			
	      )
	      (progn															; keine Ausklinkung
	        (setq dOK 0 hp hc_trg)		
	      )
	    )
	  ) ; progn
	)
))

	
	
	(if (= rwnkl_trg 180.0) 
		(progn
			(setq delta_v_trg (- delta_v_trg))
			(setq delta_lr_trg (- delta_lr_trg))
		)
	)
	
	
	(if (= (Connect.get CastaData amHTStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq delta_lr_soll (+ (* 0.5 dp) tSteg))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq delta_lr_soll (- (- (* 0.5 dp)) tSteg))
			)
		)
	)
	(if (= (Connect.get CastaData amHTStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq delta_lr_soll (- (- (* 0.5 dp)) tSteg))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq delta_lr_soll (+ (* 0.5 dp) tSteg ))
			)
		)
	)
			
	
	(print delta_lr_soll)
	(setq s_htrg (Traeger.get Htrg s))
	
	; Anteil delta_lr AT
	(if (= (Connect.get CastaData vatr-lhtr)  1)	
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)	
	(if (= (Connect.get CastaData vatr-lhtr) -1)	
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr)  0)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)
	
	; Anteil delta_v HT
	
	
	; Blech in delta_lr
	;(setq anteil_dlr_an_dvht (* delta_v_htrg sinW))
	
	;(setq delta_lr_soll (- delta_lr_soll anteil_dlr_an_dvht))
	
	(print delta_lr_soll)
	
	; BLECHDATEN:
	; -----------
	; dp : Standardmig auf Dicke des Steges des Haupttrgers
	; hp : Standardmig auf hc des Anschlusstrgers
	(Blech.set fahnenblech 	(dp dp) 
													(hp hp) 
													(dok dOk) 
													(delta_lr delta_lr_soll)
	)
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------
; Berechnet die Lochbild Daten (wird hier dem AT hinzugefgt)
; ----------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde LbArt)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID	;(lb_art  LbArt)
												(Anz_S    2)
												(Guete   "4.6")
	)
	
	(setq	h_trg 			(Traeger.get Tr_ID h)
				delta_v_at		(Traeger.get Tr_ID delta_v)
				t_at				(Traeger.get Tr_ID t)
				r_at				(Traeger.get Tr_ID r)
				b_at				(Traeger.get Tr_ID  b)
				qsform_At		(Traeger.get Tr_ID	qsform)
	)
	
	(setq	s_htrg			(Traeger.get Htrg s)
				delta_lr_htrg	(Traeger.get Htrg delta_lr)
				delta_v_ht		(Traeger.get Htrg delta_v)
				qsform_ht		(Traeger.get Htrg	qsform)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l)
				trg_zakl		(TrEnde.get TrgEnde zakl)
	)
		
	; Schraubenbezeichnung
	(set_S_Bez Tr_ID Lchb_ID)
	
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	
	(print e_min)
	(print abstZumSteg)
	(print s_htrg)
	(setq abst_lchb_steg (+ abstZumSteg  e_min (* 0.5 s_htrg)))
	(print abst_lchb_steg)
	(print delta_lr_htrg)
	
	;(if (= (Connect.get CastaData amHtStegLinks) 1)
	;	(progn
	;		(setq w0 (- abst_lchb_steg delta_lr_htrg))
	;		(if (< delta_lr_htrg abst_lchb_steg)
	;			(setq w0_rund (runde w0 auf 5))
	;			(setq w0_rund (runde w0 ab 5))
	;		)
	;	)
	;)
	;(if (= (Connect.get CastaData amHtStegRechts) 1)
	;	(progn
	;		(setq w0 (+ abst_lchb_steg delta_lr_htrg))
	;		(if (< delta_lr_htrg abst_lchb_steg)
	;			(setq w0_rund (runde w0 ab 5))
	;			(setq w0_rund (runde w0 auf 5))
	;		)
	;	)
	;)
	(setq w0 abst_lchb_steg)
	(setq w0_rund (runde w0 auf 5))
	(print w0)
	(print w0_rund)
	
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq w0_rund (- w0_rund (* 0.5 s_htrg)))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq w0_rund (+ w0_rund (* 0.5 s_htrg)))
			)
		)
	)
	;(setq w0_rund (runde w0 auf 5))
	
	(setq hp_blech 	(Blech.get BlechID hp)
				dok_blech	(Blech.get BlechID dok)
	)

	(print hp_blech)
	(print dok_blech)
	
	(calcUnterschied)
		
	(print hsteg)
	(print zakl)
	(print diff_oben)
	; e0 berechnen
	
	(if (<= min_h hp_blech)
		(progn	
			(if (> zakl 0.0)
				(progn
					(setq e0 (+ (* 0.25 hp_blech) zakl))
				)
				(progn
					(setq e0 (+ (* 0.25 hp_blech) r_at t_at))
				)
			)	
			
			(print e0)
			(setq e1 (* 0.5 hp_blech))
			
			; Klemmlnge
			(setq dp_blech 	(Blech.get BlechID dp))
			(setq s_trg			(Traeger.get Tr_ID s))
			
			(setq Schrb_KlemmL (+ dp_blech s_trg))
			(if (= qsform_At "K")  (setq Schrb_KlemmL (+ (* 2 dp) b_AT)))
			
			; Schraubenkopf
			(calcDxSKopf dp_blech s_trg)
			
			(print w0_rund)
			(Lochbild.set Lchb_ID (e0 		e0)
														(e1 		e1)
														(w0 		w0_rund)
														(klemml  Schrb_KlemmL)
														; (dxSKopf dxSKopf)
			)
			(setq testW0 (Lochbild.get Lchb_ID w0))
			(print testw0)
		)
		(progn
			(if (> zakl 0.0)
				(progn
					(setq e0 (+ (* 0.5 hp_blech) zakl))
				)
				(progn
					(setq e0 (+ (* 0.5 hp_blech) r_at t_at))
				)
			)	
			
			(setq qsform_at (Traeger.get Tr_ID qsform))
			(if (= qsform_at "K") (progn
				(setq h_AT (Traeger.get Tr_ID h))
				(setq e0 (* 1 (* 0.5 h_AT)))
			))

			(print e0)
			
			
			; Klemmlnge
			(setq dp_blech 	(Blech.get BlechID dp))
			(setq s_trg			(Traeger.get Tr_ID s))
			
			; Schraubenkopf
			(calcDxSKopf dp_blech s_trg)

			(setq Schrb_KlemmL (+ dp_blech s_trg))
			(if (= qsform_At "K")  (setq Schrb_KlemmL (+ (* 2 dp) b_AT)))

			(print w0_rund)
			(Lochbild.set Lchb_ID (e0 		e0)
														(e1 		0)
														(w0 		w0_rund)
														(klemml 	Schrb_KlemmL)
														(dxSKopf 	dxSKopf)
			)
			
			(setq testW0 (Lochbild.get Lchb_ID w0))
			(print testw0)
		)
	) 
	
	(print e_min)
	(print w0_rund)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lchb_ID (e2 300))
	)
	; Korregiere Fahnenblech
	(Blech.set BlechID (bp (+ (* 2.0 e_min_rund) abstZumSteg))) 

	
	
)


; ----------------------------------------------------------------------------------------
; Berechnet dxsKopf fr verschiedene Profile
; ----------------------------------------------------------------------------------------
(defun calcDxSKopf (DP_BLECH S_TRG)
	(print "------------------------------------------------------------")
	(print "BERECHNE DXSKOPF")
	
	; Querschnittsform holen
	(setq qsform_at (Traeger.get Tr_ID qsform))
	
	(setq dxSKopf 0)
	; I-PROFIL
	(if (= qsform_at "I")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde)	1)	(setq dxSKopf (* 0.5 S_TRG) ))
					(if (= (Connect.get CastaData RechtesEnde)	1)	(setq dxSKopf (+ (* 0.5 DP_BLECH) S_TRG)))
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde)	1)	(setq dxSKopf (+ (* 0.5 DP_BLECH) S_TRG)))
					(if (= (Connect.get CastaData RechtesEnde)	1)	(setq dxSKopf (* 0.5 S_TRG) ))
				)
			)
		)
	)

	(if (= qsform_at "K")		(progn
			(setq dxSKopf DP_BLECH)
			(setq dxSKopf 0)
	))

	
	; U-Profil
	(if (= qsform_at "U")
		(progn
			(setq dxSKopf 0)
		)
	)
	(print "------------------------------------------------------------")
)


; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	
	(setq h_ht				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_v_ht h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))							(print uKante_ht)
	(setq oKante_at	(- delta_v_at h_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))							(print uKante_at)
	
	
		
	(setq diff_oben (- oKante_at oKante_ht))
	
	
	
	(print diff_oben)
	
)



; ****************************************************************************************
; Berechnet die XPos des Fahnenbleches am HT
; ****************************************************************************************
(defun calcXPosFahne ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE XPOS DES FAHNENBLECHES") 
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht)
				vwinkel_uz	(Connect.get CastaData hpttrg_vwinkel)
	)
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	
	
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_uz rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_uz rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_uz rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_uz rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	(print cosW)
	
	(print delta_lr_at)
	
	(if (/= cosW 0.0)
		(setq anteil_delta_lr (/ delta_lr_at cosW))
		(setq anteil_delta_lr 0.0)
	)
	(print anteil_delta_lr)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq xPos (- xPos_ht anteil_delta_lr))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq xPos (+ xPos_ht anteil_delta_lr))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq xPos (+ xPos_ht anteil_delta_lr))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq xPos (- xPos_ht anteil_delta_lr))
			)
		)
	)
	
	; Anteil delta_v HT
	(setq anteil_delta_v_ht (* (* 1.0 delta_v_ht) tanW))
	(setq xPos (- xPos anteil_delta_v_ht))
	
	(print xPos)
	(print "<-------------------------------------------------------------------------------")
)



; ------------------------------------------------------------------------
; Passt die Lochbild-Anbauteile an.
; ------------------------------------------------------------------------
(defun setLochbild (LOCHB_ID  LB_xPosOffset)
	
	(setq	h_ht				(Traeger.get Htrg h)
				s_ht				(Traeger.get Htrg s)
				b_ht				(Traeger.get Htrg b)
				delta_v_ht 	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				qsform_ht		(Traeger.get Htrg qsform)
	)
	
	(setq	delta_v_at	(Traeger.get Tr_ID delta_v)
				h_At				(Traeger.get Tr_ID h)
				b_At				(Traeger.get Tr_ID b)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht)
				vwinkel_ht	(connect.get CastaData hpttrg_vwinkel)
	)
	
	(setq lb_ht_abtl (Traeger.get Htrg Abteil LOCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil LOCHB_ID))
	

	
	; s_ht bei Rund- und Kastenprofilen ndern!!!
	(if (= qsform_ht "K")
		(setq s_ht b_ht)
	)
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_ht)
	(print r_winkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	(if (/= (Connect.get CastaData satr-lhtr) 0) (progn
		(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
			(setq cosW -1.0)
		))
		(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(setq cosW 1.0)
		))
	))
	
	; Anbauteil AT
	; ----------------------------------------------
	(setq e_diff (- (* 0.5 h_trg) (* 0.5 hp_blech)))
	
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 h_ht) delta_v_ht)))
	(if (= (Connect.get CastaData amHtOberFlansch) 1) 	(setq delta_lr_abtl_at (- (* 0.5 h_ht) delta_v_ht)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_lr_abtl_at (- (* 0.5 s_ht) delta_lr_ht)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 s_ht) delta_lr_ht)))
	
	(setq qsform_Ht (Traeger.get HTrg qsform))
	(if (= qsform_Ht "U") (progn
		(if (= (Connect.get CastaData amHtStegLinks)  1) 	(setq delta_lr_abtl_at (- (* 0.0 s_ht) delta_lr_ht)))
		(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 1.0 s_ht) delta_lr_ht)))
	))
	
	(Anbauteil.set lb_at_abtl (delta_lr 	delta_lr_abtl_at))
	
	; Anbauteil HT
	; ----------------------------------------------
	(setq delta_v_abtl_ht 0.0)
	
	; Anteil delta_v AT 
	(setq anteil_delta_v_at delta_v_at)
	(print anteil_delta_v_at)
	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))
	(setq delta_v_abtl_ht (- delta_v_abtl_ht (* 0.5 h_at)))
	
	
	; Anteil delta_v HT
	(if (/= cosW  0.0)
		(setq anteil_dvHT_an_dv	(* (* 1.0 delta_v_ht) cosW))
		(setq anteil_dvHT_an_dv delta_v_ht)
	)
	
	(if (/= (Connect.get CastaData satr-lhtr) 0) (progn
		(setq ablt_FBl_1 (Traeger.get HTrg ABTeil FahnenBl_1))
		(setq sAtrlHtr (Connect.get CastaData satr-lhtr))
		(setq rWinkel (Anbauteil.get lb_ht_abtl Winkel))

		(setq rWinkelBl (Anbauteil.get ablt_FBl_1 Winkel))
		
		(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
;			(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_dvHT_an_dv))
			(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_dvHT_an_dv))
		))
		(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(setq newRWinkel (- rWinkel 180.0))
			(if (< newRWinkel -180.0) (setq newRWinkel (+ newRWinkel 360.0)))
			(Anbauteil.set lb_ht_abtl (Winkel newRWinkel)) 
			(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_dvHT_an_dv))
		))
	))
	
	; -x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-x-
	; hier muss noch korrigiert werden - Winkel des Lochbild und delta_V
	(Anbauteil.set lb_ht_abtl (delta_v 	delta_v_abtl_ht))
	
	; Korrektur der X-Pos, weil alles auf die Mittelachse des AT bezogen wird
	(Anbauteil.set lb_ht_abtl (delta_sx  LB_xPosOffset))
	
	; Master setzen
	; ----------------------------------------------
	(Anbauteil.set lb_ht_abtl (Master 1))
	(Anbauteil.set lb_at_abtl (Master 0))
	
	; ---- dxSKopf setzen
	(setq rWinkel (Anbauteil.get lb_ht_abtl Winkel))
	(setq deltaSX (Anbauteil.get lb_ht_abtl delta_SX))
	
	(setq sinRW (sin (/ (* PI rWinkel) 180.0)))
	(setq cosRW (cos (/ (* PI rWinkel) 180.0)))
	(setq tanRW (tan (/ (* PI rWinkel) 180.0)))

	(setq dv_HT (Traeger.get HTrg delta_V))
	(setq dxs_Corr (* (* 1.0 dv_HT) cosRW))
	(setq delta_SX_Corr (- deltaSX dxs_Corr))
	(Anbauteil.set lb_ht_abtl (delta_SX delta_SX_Corr))
	
;	(Anbauteil.set lb_ht_abtl (SeitRicht -1))
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy LOCHB_ID)
						
	
	
			(if (= (connect.get CastaData amHtStegLinks) 1) 
				(Traeger.addabtl Htrg dummy XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
    	)
	    (if (= (connect.get CastaData amHtStegRechts) 1) 
				(Traeger.addabtl Htrg dummy XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
	    )
			
			(setq dummy_abtl (Traeger.get Htrg Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)
				;(delta_lr delta_lr_abtl_ht)
				(delta_v 	delta_v_abtl_ht)
			)
		)
	)
	;===================================================================
	
)

(defun calcRotationFahne ()
	(setq rwk_rst		(Connect.get CastaData r-atrgewnkl_steg))

	(setq vwinkel_ht	(Connect.get CastaData hpttrg_vwinkel))

	(setq abtl_fahne_winkel 0.0)

	(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
		(if (= (Connect.get CastaData linkesEnde)  1)	(setq abtl_fahne_winkel rwk_rst))
		(if (= (Connect.get CastaData rechtesEnde) 1)	(setq abtl_fahne_winkel (- 180.0 rwk_rst)))
	))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
		(if (= (Connect.get CastaData rechtesEnde) 1)	(setq abtl_fahne_winkel rwk_rst))
		(if (= (Connect.get CastaData linkesEnde)  1)	(setq abtl_fahne_winkel (- 180.0 rwk_rst)))
	))
)


(defun calcPositionFahne (FahnenBlech li_re)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE DIE POSITION DES FAHNENBLECHES")
	
	(setq ABTL (Traeger.get Htrg AbTeil FahnenBlech))

	
	(setq	delta_v_ht	(Traeger.get Htrg delta_v))
	
	(setq	vwinkel_uz (Connect.get CastaData hpttrg_vwinkel))
	
	(setq	rwinkel_at	(Traeger.get Tr_ID r_winkel)
			delta_lr_at	(Traeger.get Tr_ID delta_lr)
			delta_v_at	(Traeger.get Tr_ID delta_V)
	)
	
	
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	
	(setq verschiebung_delta_v 0.0)
	(setq verschiebung_delta_lr 0.0)
	
	; HT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* delta_v_ht cosW)))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; AT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* delta_v_ht cosW)))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	

    (if (= (Connect.get CastaData vatr-shtr) 0) (progn
		(setq  verschiebung_delta_v 0)
		(if (= (Connect.get CastaData vAtr-lHtr) 1) (progn
			(setq verschiebung_delta_v (+ verschiebung_delta_v (* 1.0 delta_v_at)))
		))
		(if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
			(setq verschiebung_delta_v (+ verschiebung_delta_v (* 1.0 delta_v_at)))
		))
	  )
	  (progn
			(AlertBox "Winkel passt nicht" "ERR_Angle_Not_Possible")
	))
	

	; ----------------------------------------------
	; Kontrollen
	; ----------------------------------------------
	
	; Anbauteil Fahne Werte setzen
	(Anbauteil.set ABTL (delta_v 	verschiebung_delta_v))	
	(print "<-------------------------------------------------------------------------------")
	
	(setq xPos_Abtl (Anbauteil.get  ABTL  xPos))
	(setq b_AT (Traeger.get Tr_ID b))
	(if (= li_re  1) (setq xPos_Abtl (+ xPos_Abtl (* 0.5 b_AT))))
	(if (= li_re -1) (setq xPos_Abtl (- xPos_Abtl (* 0.5 b_AT))))


	
)
; ----------------------------------------------------------------------------------------
; Berechnet die seitl. Neigung des Fahnenbleches
; ----------------------------------------------------------------------------------------
(defun berechneFahnenblechNeigung (ABTL)
	(print "BERECHNET DIE BLECHNEIGUNG")
	(print ">-----------------------------------------------------------")
	
	(setq horiz_winkel (Connect.get CastaData at_laengswinkel))
	(print horiz_winkel)
	
	
	;(Anbauteil.set ABTL (neigwnkl_d 45.0))
	
	(print "<-----------------------------------------------------------")
)
; ----------------------------------------------------------------------------------------
; Etwas mehr Abstand zwischen Steg und Trgerende bringen
; ----------------------------------------------------------------------------------------
(defun korrigiereAblaengung ()
    (if (= (Connect.get CastaData LinkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData RechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
    
    (setq at_DeltaL (TrEnde.get TrgEnde Delta_L))
    (setq nWert (runde at_DeltaL auf 5))
    (if (< (- nWert at_DeltaL) 1.0) (progn
        (setq at_DeltaL (+ 1.0 at_DeltaL))
        (setq nWert (runde at_DeltaL auf 5))
    ))
    (TrEnde.set TrgEnde (Delta_L nWert))
)
(defun 	copyBlechDaten  (Bl_1  Bl_2)
	(setq val (Blech.get Bl_1 bp))    (Blech.set Bl_2 (bp val))
	(setq val (Blech.get Bl_1 dp))    (Blech.set Bl_2 (dp val))
	(setq val (Blech.get Bl_1 hp))    (Blech.set Bl_2 (hp val))
	(setq val (Blech.get Bl_1 dOK))   (Blech.set Bl_2 (dOK val))
)
