; $	HT	QT(IU)		AF(F)		P(EZ)
; $ AT	QT(IU)	AF(K)		P(E)
; $	AE	V(-)			H(90)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; letzte nderung:	13.04.2006
; letzte Prfung:		13.04.2006
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-multiconnect-stz-flansch")
)

(defun init-connection ()

	;(connect.showattributes CastaData)
	(setq HoeheVoutenAbschn  (Traeger.get Tr_ID h))	; wird einfach auf h-Trger initialisiert
	(setq LaengeVoutenAbschn 500)
	(loadConfig "uzVouteStzGeschw_defaults.lsp")	; hier fr Makro oder letzte Werte

	;  knnte auch in eine Config-Datei
	(setq min_Blech_Abstand 40)			; Mindest Abstand zu vorhandenen Steifen

	(print "in init-connection uz_an_Stz-Flansch");
 	(init-traegerenden)				

 	; ******************************************
	; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
	; ******************************************
	(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	(print anzAnschl)
	  
	(if (/= anzAnschl 0)
	    (progn
	  	(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden. Fgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."   "ERR_OrderOfConnections")
	    )
	    (progn
	  	(createStuetzenSteifen 10)
	    )
	)
	(erzeugeVoute)
	
	(Traeger.set Tr_ID (formFkt "cb_AnschlTraeger"))


)
; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */
; ----------------------------------------------------------------------
; Erzeugt die Sttzensteifen
; ----------------------------------------------------------------------
(defun createStuetzenSteifen (dp)
	(print "")
	(print "BEGIN createStuetzenSteifen")
	(print "---------------------------")
	; allgemeine Daten holen
	(setq	h_at    	(Traeger.get	Tr_Id h)
		t_at    	(Traeger.get	Tr_Id t)
		delta_v_at	(Traeger.get	Tr_Id delta_V)
		h_ht     	(Traeger.get	HTrg  h)
		delta_v_ht	(Traeger.get	Htrg delta_v)
		VWnkl    	(Connect.get 	CastaData at_laengswinkel)
	)
	
	(setq	at_vwinkel 	(Connect.get CastaData at_laengswinkel)
		xPos_ht		(Connect.get CastaData xPos_ht)
	)
	(print delta_v_at)
	(setq dp_steife 10)

	; Winkel noch anpassen, je nach Orientierung	
	; Winkel wird nur fr das obere Steifenblech bentigt.
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq VWnkl (- VWnkl 90.0)))
			(if (= (Connect.get CastaData amHtUnterFlansch) 1)	(setq VWnkl (- 90.0 VWnkl)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq VWnkl (- VWnkl 90.0)))
			(if (= (Connect.get CastaData amHtUnterFlansch) 1)	(setq VWnkl (- 90.0 VWnkl)))
		)
	)
	; Emde Winkel anpassen
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	(setq vscherl_at (TrEnde.get AT_Ende vscherl))
	(setq vscherl_at_halb	(* 0.5 vscherl_at))
	
	(setq xPosOben 	(- (+ xPos_ht vscherl_at_halb) (* 0.5 dp_steife)))
	(setq xPosUnten (+ (- xPos_ht vscherl_at_halb) (* 0.5 dp_steife)))
	
	(setq tanW (tan (/ (* PI at_vwinkel) 180.0)))
	(setq sinW (sin (/ (* PI at_vwinkel) 180.0)))
	
	; Korrektur aus Neigung
	
	(setq xPos_korr_neig (/ (* 0.5 h_ht) tanW))
	
	(setq xPosOben 	(+ xPosOben xPos_korr_neig))
	(setq xPosUnten (+ xPosUnten xPos_korr_neig))
	
	
	; Anteil aus delta_v Verschiebung HT
	(setq anteil_delta_v_ht (/ delta_v_ht tanW))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(setq xPosOben 	(- xPosOben anteil_delta_v_ht))
			(setq xPosUnten (- xPosUnten anteil_delta_v_ht))
		)
	)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(setq xPosOben 	(+ xPosOben anteil_delta_v_ht))
			(setq xPosUnten (+ xPosUnten anteil_delta_v_ht))
		)
	)
	; untere Steife entsprechend Voutenabschnitt verschieben
	(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq xPosUnten (- xPosUnten HoeheVoutenAbschn)))
	(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq xPosOben  (+ xPosOben HoeheVoutenAbschn)))
	
	; Anteil aus delta_v Verschiebung AT
	
	(setq anteil_delta_v_at (/ delta_v_at sinW))
	(print anteil_delta_v_at)
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(setq xPosOben 	(+ xPosOben anteil_delta_v_at))
			(setq xPosUnten (+ xPosUnten anteil_delta_v_at))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq xPosOben 	(- xPosOben anteil_delta_v_at))
			(setq xPosUnten (- xPosUnten anteil_delta_v_at))
		)
	)
	
	
	; Erstellen der Steifen
	; ---------------------
	
	; Auf Steifen am HT prfen
	(checkForSteifeAtPosition xPosOben min_Blech_Abstand Htrg)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosOben min_Blech_Abstand Htrg)
	)
	
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeOben (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeOben)
			(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_)	;1539
			(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeOben))
			(Anbauteil.set  AbtlSteife (xpos xPosOben))
			; (Anbauteil.set  AbtlSteife (Winkel 0.0))

			(Blech.set blSteifeOben (dp dp_steife))

			(if (= (Connect.get CastaData vatr-lhtr) -1) (progn
				(setq hBl2 (Blech.get blSteifeOben hp))
				(setq hBl2 (* 0.5 hBl2))
				
				(setq sinVW (sin (/ (* PI VWnkl) 180.0)))
				(setq tanVW (tan (/ (* PI VWnkl) 180.0)))
				(setq dlXPos (+ (* tanVW hBl2) (* sinVW dp_steife)))
	
				(if (= (Connect.get CastaData amHTOberflansch) 1) (setq dlXPos (- dlXPos)))
				
				(Anbauteil.set  AbtlSteife (xpos (- xPosOben dlXPos))  (Winkel VWnkl))
			))
		)
	)
	
	
	(checkForSteifeAtPosition xPosUnten min_Blech_Abstand Htrg)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosUnten min_Blech_Abstand Htrg)
	)
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeUnten (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeUnten)
			(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)   ;1539
			(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
			(Anbauteil.set  AbtlSteife (xpos xPosUnten))
			(Blech.set blSteifeUnten (dp dp_steife))

			(if (= (Connect.get CastaData vatr-lhtr) 1) (progn
				(setq hBl2 (Blech.get blSteifeUnten hp))
				(setq hBl2 (* 0.5 hBl2))
				
				(setq sinVW (sin (/ (* PI VWnkl) 180.0)))
				(setq tanVW (tan (/ (* PI VWnkl) 180.0)))
				(setq dlXPos (+ (* tanVW hBl2) (* sinVW dp_steife)))
	
				(if (= (Connect.get CastaData amHTOberflansch) 1) (setq dlXPos (- dlXPos)))
				
				(Anbauteil.set  AbtlSteife (xpos (- xPosUnten dlXPos))  (Winkel VWnkl))
			))
		)
	)
	
	
	
	(Traeger.updvollstf Htrg)
	(print "---------------------------")
	(print "END createStuetzenSteifen")
	(print "")
)
; ------------------------------------------------------------------------------------
(defun erzeugeVoute ()
	(print "erzeuge  Voute")

	(setq TEnde (Traeger.get Tr_ID links))  (setq EWnkl_L (TrEnde.get TEnde V_Winkel))
	(setq TEnde (Traeger.get Tr_ID rechts)) (setq EWnkl_R (TrEnde.get TEnde V_Winkel))
	(setq EWnkl_L (- EWnkl_L 90.0))
	(setq EWnkl_R (- EWnkl_R 90.0))
	(setq tanW_EL   (tan (/ (* PI EWnkl_L) 180.0))
	      tanW_ER   (tan (/ (* PI EWnkl_R) 180.0))
	)
	(setq 
		h_AT  	(Traeger.get Tr_ID h)
		AchsLng	(Traeger.get Tr_ID AchsLaenge)
	)
	(setq dl_Links  (* -0.5 tanW_El h_AT))
	(setq dl_Rechts (*  0.5 tanW_ER h_AT))

	(if (= (Connect.get CastaData linkesEnde)  1) (setq TEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq TEnde (Traeger.get Tr_ID rechts)))
	    
	    
	    
	    (print "------------")
	    (print tanW_El)
	    (print tanW_ER)
	    (print dl_Links)
	    (print dl_Rechts)
	    (print "------------")
	    (print AchsLng)
	    (print EWnkl_L)
	    (print EWnkl_R)
	    (print "-----------")
	    

	    (setq LaengeVoutenAbschn (+ AchsLng dl_Links dl_Rechts))


	    (print LaengeVoutenAbschn)
	    (TrEnde.set TEnde
	    	(l_Voute_Unten LaengeVoutenAbschn) 
	    	(h_Voute_Unten HoeheVoutenAbschn)
	    )


;	(Connect.ShowAttributes CastaData)

)
(defun cb_AnschlTraeger (zp)

    (if (= zp 0) (progn
 	(if (= (Connect.get CastaData linkesEnde)  1) (setq TEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq TEnde (Traeger.get Tr_ID rechts)))
	(setq hVoute_Alt (TrEnde.get TEnde h_Voute_Unten))
	
    ))
    (if (= zp 1) (progn
 	(if (= (Connect.get CastaData linkesEnde)  1) (setq TEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq TEnde (Traeger.get Tr_ID rechts)))
	(setq hVoute_Neu (TrEnde.get TEnde h_Voute_Unten))
	
	(setq hVout_Diff (- hVoute_Neu hVoute_Alt))
	(if (/= hVout_Diff 0.0) (progn
	    (if (= (Connect.get CastaData vAtr-lHtr) -1) (progn
		(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
		(setq xPosUnten (Anbauteil.get AbtlSteife xPos))
	        (setq xPosUnten (- xPosUnten hVout_Diff))
	        
	        (Anbauteil.set AbtlSteife (xPos xPosUnten))
	    ))
	    (if (= (Connect.get CastaData vAtr-lHtr)  1) (progn
		(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeOben))
		(setq xPosOben (Anbauteil.get AbtlSteife xPos))
	        (setq xPosOben (+ xPosOben hVout_Diff))
	        
	        (Anbauteil.set AbtlSteife (xPos xPosOben))
	    ))

	
	))

    ))

)
; ------------------
