; $	HT	QT(IUKR)		AF(K)		P(E)
; $	AT	QT(IUKR)		AF(K)		P(E)
; $ AE	V(-)				H(-)		R(-)

; ---------------------------------------------------------------------- */
(defun load-modules ()
   (load "mod-endinit-uz-stzgehrung")
)
; ---------------------------------------------------------------------- */
(defun init-connection ()

  (print "*clear*")
  (print "in init-connection - Gehrung an Stz-Ende");

;   (Move)
   (Berechne)

)
(defun Berechne ()

  ; Berechnen des horizontalen Winkels
  (setq hWinkel_Steg    (Connect.get CastaData h-atrgewnkl_steg))
  (setq vWinkel_Flansch (Connect.get CastaData v-atrgewnkl_flansch))
  (print hWinkel_Steg)
  
  (setq FlanschAnschluss 0)
  (if (= hWinkel_Steg 180.0) (setq FlanschAnschluss 1))
  (if (= hWinkel_Steg   0.0) (setq FlanschAnschluss 1))
  
  (if (= FlanschAnschluss 1) (progn 		; Anschluss an Stegseite nicht mglich - Flansch einsetzen
    		(setq GehrungsWinkel (/ vWinkel_Flansch 2.0))
  		(calcEndWinkel GehrungsWinkel)
  		(print GehrungsWinkel) (print Alfa_H) (print Alfa_V)
  		(setEndWinkel_FlanschAnschl GehrungsWinkel Alfa_H Alfa_V)
	); progn-Ende
	(progn
    		(setq GehrungsWinkel (/ hWinkel_Steg 2.0))
    		
  		 (calcEndWinkel_Neu GehrungsWinkel)

  		; (calcEndWinkel GehrungsWinkel)
  		; (setEndWinkel_StegAnschl GehrungsWinkel Alfa_H Alfa_V)
  ))

  (Connect.ShowAttributes CastaData)

;  (Move)
)
(defun calcEndWinkel (wGehrung)
  
  (setq VWinkel_Steg (Connect.get CastaData v-atrgewnkl_steg))
  (setq wVertikal    (- 90.0 VWinkel_Steg))
  
  (setq hProf  (Traeger.get HTrg h)
  	hProf2 (* 0.5 hProf)
  )
  
  (setq sinW_V  (sin (* PI (/ wVertikal 180.0))))
  (setq cosW_V  (cos (* PI (/ wVertikal 180.0))))
  (setq tanW_G  (tan (* PI (/ wGehrung  180.0))))

  
  (if (> cosW_V (- 0.0001)) (if (< cosW_V 0.0001) (setq cosW_V 0.0)))
  (if (> sinW_V (- 0.0001)) (if (< sinW_V 0.0001) (setq sinW_V 0.0)))

  (setq Alfa_H 90.0 Alfa_V 90.0)

  (print "Zwischenwerte: ........................")
  (print cosW_V) (print sinW_V)
  (print wGehrung)

  (if (= cosW_V 0.0) (progn
        (setq Alfa_V  (- 90.0 wGehrung)			; normalerweile 45.0
              Alfa_H  90.0
        )
     )
     (progn
        (if (= sinW_V 0.0) (progn
            (setq Alfa_H wGehrung		; normalerweise 45.0
                  Alfa_V 90.0
            )
          )
          (progn
		  (setq L1 (/ (* hProf2 tanW_G) cosW_V))
		  (setq L2 (/ (* hProf2 tanW_G) sinW_V))
		  
		  (print L1)
		  (print L2)
		  
		  (setq tan_Alfa_H (/ L1 hProf2))
		  (setq Alfa_H_rad (atan tan_Alfa_H))
		  (setq Alfa_H (/ (* 180.0 Alfa_H_rad) PI))
		
		  (setq tan_Alfa_V (/ L2 hProf2))
		  (setq Alfa_V_rad (atan tan_Alfa_V))
		  (setq Alfa_V (/ (* 180.0 Alfa_V_rad) PI))
		
		  (print "--------------- Ergebnisse : -----------------")
		  (print wGehrung)
		  (print wVertikal)
		  
		  (print Alfa_H_rad)
		  (print Alfa_H)
		
		  (print Alfa_V_rad)
		  (print Alfa_V)
          )
        )
     )
  )
)
(defun setEndWinkel_StegAnschl (wGehrung Alfa_H Alfa_V)
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  (setq GFall 0)

  (if (= (Connect.get CastaData anHtLinkesEnde)      1) (progn
      (if (= (Connect.get CastaData LinkesEnde)      1) (progn
	  (if (= (Connect.get CastaData sAtr-lHtr)       1) (setq GFall 1))
	  (if (= (Connect.get CastaData sAtr-lHtr)      -1) (setq GFall 2))
      ))
      (if (= (Connect.get CastaData RechtesEnde)      1) (progn
	  (if (= (Connect.get CastaData sAtr-lHtr)       1) (setq GFall 4))
	  (if (= (Connect.get CastaData sAtr-lHtr)      -1) (setq GFall 3))
      ))
  ))
  (if (= (Connect.get CastaData anHtRechtesEnde)      1) (progn
      (if (= (Connect.get CastaData LinkesEnde)      1) (progn
	  (if (= (Connect.get CastaData sAtr-lHtr)      -1) (setq GFall 1))
	  (if (= (Connect.get CastaData sAtr-lHtr)       1) (setq GFall 2))
      ))
      (if (= (Connect.get CastaData RechtesEnde)      1) (progn
	  (if (= (Connect.get CastaData sAtr-lHtr)      -1) (setq GFall 4))
	  (if (= (Connect.get CastaData sAtr-lHtr)       1) (setq GFall 3))
      ))
  ))

  (print GFall)
;  (setq GFall 4)

  (setq  HT_HWinkel 90.0)
  (setq  HT_VWinkel 90.0)

  (if (= (Connect.get CastaData amHTStegLinks)      1) (progn
	  (if (= GFall 1) (progn
	      (setq  HT_VWinkel (+ 180.0 Alfa_V))
	      ;(setq  HT_VWinkel (- 90.0 Alfa_V))
	      (setq  HT_HWinkel  (- 90.0 Alfa_H))
	      ; (setq  HT_VWinkel 90.0)
	      (print Alfa_V)
	      (print HT_VWinkel)
	      (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
	  ))
	  (if (= GFall 2) (progn
	      (setq  HT_VWinkel    (- Alfa_V))
	      (print Alfa_V)
	      (setq  HT_HWinkel (- 180.0 Alfa_H))
	      (TrEnde.set ATrg_Ende (H_Winkel wGehrung))
	  ))
  ))
  (if (= (Connect.get CastaData amHTStegRechts)      1) (progn
	  (if (= GFall 1) (progn
	      (setq  HT_VWinkel (- 180.0 Alfa_V))
	      (setq  HT_HWinkel Alfa_H)
	      (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
	  ))
	  (if (= GFall 2) (progn
	      (setq  HT_VWinkel    Alfa_V)
	      (setq  HT_HWinkel (- 180.0 Alfa_H))
	      (TrEnde.set ATrg_Ende (H_Winkel wGehrung))
	  ))
  ))
  (if (= (Connect.get CastaData amHTFlansch)      1) (progn
     (if (= GFall 3) (progn
       ; (print "amHTFlansch - Fall 3")
       (setq  HT_VWinkel Alfa_V)
       (setq  HT_HWinkel Alfa_H)
       (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
     ))
     (if (= GFall 4) (progn
       ; (print "amHTFlansch - Fall 4")
       (setq  HT_VWinkel   (- 180.0 Alfa_V))
       (setq  HT_HWinkel   (- 180.0 Alfa_H))
       (TrEnde.set ATrg_Ende (H_Winkel wGehrung))
    ))
  ))
  (if (= (Connect.get CastaData amHTSteg)      1) (progn
     (if (= GFall 3) (progn
       ; (print "amHTSteg - Fall 3")
       (setq  HT_VWinkel (- 180.0 Alfa_V))
       (setq  HT_HWinkel Alfa_H)
       (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
     ))
     (if (= GFall 4) (progn
       ; (print "amHTSteg - Fall 4")
       (print Alfa_V)
       (setq  HT_VWinkel   (- 180.0 Alfa_V))
       (setq  HT_HWinkel   (- 180.0 Alfa_H))
       (TrEnde.set ATrg_Ende (H_Winkel wGehrung))
     ))
  ))

  (if (= 1 2) (progn
	  (if (= GFall 1) (progn
	      (setq  HT_VWinkel (- 180.0 Alfa_V))
	      (setq  HT_HWinkel (- 90.0 Alfa_H))
	      (TrEnde.set ATrg_Ende (H_Winkel (+ 90.0 wGehrung)))
	  ))
  ))




  (TrEnde.set HTrg_Ende (H_Winkel  HT_HWinkel))
  (TrEnde.set HTrg_Ende (V_Winkel  HT_VWinkel))

  

)
(defun setEndWinkel_FlanschAnschl (wGehrung Alfa_H Alfa_V)
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  (setq AT_VWinkel 90.0)
  (setq HT_VWinkel 90.0)

  (setq GFall 0)
 
  (if (= (Connect.get CastaData anHtLinkesEnde) 1) (progn
     (if (= (Connect.get CastaData LinkesEnde)     1) (progn
	(if (= (Connect.get CastaData vAtr-lHtr)      -1) (setq GFall 3))
	(if (= (Connect.get CastaData vAtr-lHtr)       1) (setq GFall 4))
     ))
     (if (= (Connect.get CastaData RechtesEnde)     1) (progn
	(if (= (Connect.get CastaData vAtr-lHtr)      -1) (setq GFall 4))
	(if (= (Connect.get CastaData vAtr-lHtr)       1) (setq GFall 3))
     ))
  ))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (progn
     (if (= (Connect.get CastaData LinkesEnde)     1) (progn
	(if (= (Connect.get CastaData vAtr-lHtr)      -1) (setq GFall 1))
	(if (= (Connect.get CastaData vAtr-lHtr)       1) (setq GFall 2))
     ))
     (if (= (Connect.get CastaData RechtesEnde)     1) (progn
	(if (= (Connect.get CastaData vAtr-lHtr)      -1) (setq GFall 2))
	(if (= (Connect.get CastaData vAtr-lHtr)       1) (setq GFall 1))
     ))
  ))

  (print ".") (print GFall) (print "___________")
  (print wGehrung)
  (if (= GFall 1) (progn
	(setq AT_VWinkel (+  90.0 wGehrung))
	(setq HT_VWinkel (+  90.0 wGehrung))
  ))
  (if (= GFall 2) (progn
	(setq AT_VWinkel wGehrung)
	(setq HT_VWinkel (- 180.0 wGehrung))
  ))
  (if (= GFall 3) (progn
	(setq AT_VWinkel wGehrung)
	(setq HT_VWinkel wGehrung)
  ))
  (if (= GFall 4) (progn
	(setq AT_VWinkel (+  90.0 wGehrung))
	(setq HT_VWinkel (-  90.0 wGehrung))
  ))

  (TrEnde.set ATrg_Ende (V_Winkel  AT_VWinkel)	(H_Winkel  90.0))
  (TrEnde.set HTrg_Ende (V_Winkel  HT_VWinkel)  (H_Winkel  90.0))


)

(defun Move ()
	; Traegerende bestimmen
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

	; Vertikalwinkel verschieben
  (setq EVWinkel (TrEnde.get HTrg_Ende H_Winkel))
  (TrEnde.set HTrg_Ende (H_Winkel (+ EVWinkel 1.0)))

;  (setq EVWinkel (TrEnde.get ATrg_Ende V_Winkel))
;  (TrEnde.set ATrg_Ende (V_Winkel (+ EVWinkel 1.0)))

	; Horizontalwinkel verschieben
;	 (setq EHWinkel (TrEnde.get ATrg_Ende H_Winkel))
;	 (TrEnde.set ATrg_Ende (H_Winkel (+ EHWinkel 2.0)))
	


  
)

(defun calcEndWinkel_Neu (wGehrung)
  
  (print "in Funktion calcEndWinkel_Neu ....................")
  
  (setq VWinkel_Steg (Connect.get CastaData v-atrgewnkl_steg))
  (setq HWinkel_Steg (Connect.get CastaData h-atrgewnkl_steg))
  (setq wVertikal    (- 90.0 VWinkel_Steg))
  (setq wHorizontal  (- 90.0 hWinkel_Steg))
  
  (setq  wHorizontal  HWinkel_Steg)
  (if (> HWinkel_Steg 90.0) (setq wHorizontal (- 180.0 HWinkel_Steg)))

  (setq  wVertikal  VWinkel_Steg)
  (if (> VWinkel_Steg 90.0) (setq wVertikal (- VWinkel_Steg 90.0)))
  
  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  (TrEnde.set ATrg_Ende (H_Winkel  (+ 90.0 (/ wHorizontal 2.0))) (V_Winkel 90.0))
  (TrEnde.set HTrg_Ende (H_Winkel  (- 90.0 (/ wHorizontal 2.0))) (V_Winkel 90.0))

)
(defun Dummy2 ()  
  
  (setq hProf  (Traeger.get HTrg h)
  	hProf2 (* 0.5 hProf)
  )

  (setq sinW_H  (sin (* PI (/ wHorizontal 180.0))))
  (setq cosW_H  (cos (* PI (/ wHorizontal 180.0))))
  (setq tanW_H  (tan (* PI (/ wHorizontal 180.0))))
  
  (setq sinW_V  (sin (* PI (/ wVertikal 180.0))))
  (setq cosW_V  (cos (* PI (/ wVertikal 180.0))))
  (setq tanW_V  (tan (* PI (/ wVertikal 180.0))))
  (setq tanW_G  (tan (* PI (/ wGehrung  180.0))))

  
  (if (> cosW_V (- 0.0001)) (if (< cosW_V 0.0001) (setq cosW_V 0.0)))
  (if (> sinW_V (- 0.0001)) (if (< sinW_V 0.0001) (setq sinW_V 0.0)))

  (setq Alfa_H 90.0 Alfa_V 90.0)

  (print "Zwischenwerte: ........................")
  (print HWinkel_Steg)
  (print VWinkel_Steg)
  (print " ")
  (print wHorizontal)
  (print wVertikal)
  
  
  (print cosW_H) (print sinW_H)
  (print cosW_V) (print sinW_V)
  (print wGehrung)
  
  (setq RLng (* hProf2 (- 1.0 sinW_H)))
  (print hProf2)
  (print RLng)
  (setq LFS1      (/ RLng cosW_H))
  (setq hSchnitt  (* LFS1 tanW_V))
  (setq LFS2      (/ LFS1 cosW_V))
  
  (print LFS1)
  (print LFS2)
  (print hSchnitt)
  
  (setq x_HT_Ges  (* hProf2 cosW_H))
  (setq Rx_HT     (* RLng tanW_H))
  (setq x_HT (-   x_HT_Ges Rx_HT))
  (print x_HT)
  
  (setq tan_Gehr_Hori (/ x_HT hProf2))
  (setq horWnk_Rad (atan tan_Gehr_Hori))
  (setq horWnk     (/ (* 180.0 horWnk_Rad) PI))
  (print horWnk)

  (if (= (Connect.get CastaData anHtLinkesEnde)  1) (setq HTrg_Ende (Traeger.get HTrg links)))
  (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq HTrg_Ende (Traeger.get HTrg rechts)))
  
  (if (= (Connect.get CastaData LinkesEnde)      1) (setq ATrg_Ende (Traeger.get Tr_ID links)))
  (if (= (Connect.get CastaData RechtesEnde)     1) (setq ATrg_Ende (Traeger.get Tr_ID rechts)))

  (TrEnde.set ATrg_Ende (H_Winkel  (- 90.0 horWnk)) (V_Winkel 90.0))
  (TrEnde.set HTrg_Ende (H_Winkel  (+ 90.0 horWnk)) (V_Winkel 90.0))

  
)
