; $	HT	QT(IURK)		AF(K)		P(E)
; $	AT	QT(IURK)		AF(K)		P(E)
; $ AE	V(-)				H(-)		R(-)

; ---------------------------------------------------------------------- */
(defun load-modules ()
	(load "mod-endinit-uz-stzgehrung")
	(load "mod-lochbild")
)
; ---------------------------------------------------------------------- */
(defun init-connection ()

  (print "in init-connection - Gehrung an Stz-Ende");
	
	(print "*clear*")
	; LOCHBILD KONTROLLE
	(setq LB_DEBUG 0)
	(Connect.showAttributes CastaData)
			
	(if (/= (Connect.get CastaData satr-vhtr) 0)
		(progn
			(alertBox "Der Anschluss kann nicht ausgefhrt werden. Winkel passen nicht fr Gehrung." "Mitre_not_fitting")
		)
		(progn
			(setConnection)


;			  (print "*clear*")
;			  (connect.showAttributes CastaData)
;			  (print "*clear*")
;			  (setq abtlLchb_AT (Traeger.get Tr_ID AbTeil kplLochbild))
;			  (setq SeitRicht_AT (Anbauteil.get abtlLchb_AT SeitRicht))
;			  (print SeitRicht_AT)
;			  (setq abtlLchb_HT (Traeger.get HTrg AbTeil kplLochbild))
;			  (setq SeitRicht_HT (Anbauteil.get abtlLchb_HT SeitRicht))
;			  (print SeitRicht_HT)

		)
	)
  
)

; ---------------------------------------------------------------------- */
(defun setConnection ()
	; Anschluss nur initialisieren, wenn kein anderer Anschluss vorhanden ist
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(progn
			
			
			
			; Trgerenden zurechtschneiden
			(init-traegerenden)				
	
    
		   ; Kopfplatten und Lochbild hinzufgen
		  (setq kplLochbild (Lochbild.create))
		  (setq kplHtrg     (Blech.create))
		  (setq kplTrg      (Blech.create))
		  
		  (Connect.storeAnschlObjs CastaData kplLochbild kplHtrg kplTrg)
		  
		  (setq ueb 5.0)
		  
		  (setq bl_breite (Traeger.get Tr_ID b))
		  (setq bl_breite (+ bl_breite 10.0))
		  
			(calcBlech_dp) ; => dp_kpl
			
			(calcSchraube dp_kpl) ; => S_Bez
			
			; Schraubengre festlegen
			; ------------------------------------------ 
			(Lochbild.set kplLochbild (S_Bez S_Bez))
			
			(calcMinRandLochAbst kplLochbild) ; e_min, e1_min, e_min_rund, e1_min_rund, min_h
			
		  ; Kopfplatte am AT erzeugen
			; ------------------------------------------
			(if (= (connect.get CastaData linkesEnde) 1)
		    (createKpl_AT kplTrg kplLochbild bl_breite dp_kpl 0)
		  )
		  (if (= (connect.get CastaData rechtesEnde) 1)
		    (createKpl_AT kplTrg kplLochbild bl_breite dp_kpl 0)
		  )
		
			(korrBlechBreite_AT kplTrg)
					
			; Kopfplatte am HT erzeugen
			; ------------------------------------------
		  (createKpl_HT kplHtrg kplTrg kplLochbild dp_kpl)
		  
		  
		  ; Lochbilddaten berechnen
			; ------------------------------------------
		  (calcAndSetLochbildDaten kplLochbild kplHtrg kplTrg)
		  
		  
		  (calcLB_Abtl kplLochbild)
		  			
		  ; AF 13052009 - Korrektur	
		  (calcHVerschLochbild kplLochbild)

		  (if (= 2 3) (progn
		      (setq Abtl_KplLchb_ht (Traeger.get HTrg  ABTeil kplLochbild))
		      (setq Abtl_KplLchb_at (Traeger.get Tr_ID ABTeil kplLochbild))
		      (Lochbild.set kplLochbild (e "0 50 150 0 0 0"))
		      (Lochbild.set kplLochbild (w "10 100"))
		      (Lochbild.set kplLochbild (LB_Art 2) (delta_w 50))
		      (Anbauteil.set Abtl_KplLchb_ht 		(Master 0))
		      (Anbauteil.set Abtl_KplLchb_at 		(Master 1))
		  ))

			
			; CALLBACKS
			(Blech.set kplTrg 	(formFkt "cb_kplTrg"))
			(Blech.set kplHtrg 	(formFkt "cb_kplHtrg"))
		)
		(progn
			(alertBox "An diesem Knoten ist bereits ein Anschluss vorhanden. Der gewhlte Anschluss kann daher nicht eingefgt werden."  "SameNodeConnection_NotPossible")
		)
	)
)

; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kplTrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplTrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplTrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       (setq altesDxS		(Lochbild.get kplLochbild dxsKopf))
	       
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														;(DxSKopf (+ altesDxS dpDiff))
	       )
	       
	       
	       (if (= (Connect.get CastaData linkesEnde) 1)
	      	 (setq AT_Ende (Traeger.get Tr_ID links))
	       )
	       (if (= (Connect.get CastaData rechtesEnde) 1)
	      	 (setq AT_Ende (Traeger.get Tr_ID rechts))
	       )
	       
	      (setq dp (* 0.5 dpDiff))
	      (print dpDiff)
	      (print dp)
	      
	      ; Wird irgendwie falsch berechnet !!!!!!!!!!!!!!!!!!!
	       ;(TrEnde.pTrim AT_Ende dpDiff)
	       
	       ;Alternative: manuell ausrechnen!
	       ; siehe (*)
	       
	       ; dok frs Blech anpassen
	       (setq AT_Ende_Wnkl (TrEnde.get AT_Ende v_winkel))
	       (print AT_Ende_Wnkl)
	       
	       (if (= (Connect.get CastaData linkesEnde) 1)
	       	 (setq wnkl (- 180.0 AT_Ende_Wnkl))
	       )
	       (if (= (Connect.get CastaData rechtesEnde) 1)
	       	 (setq wnkl AT_Ende_Wnkl)
	       )
	       (print wnkl)
	       
	       (setq tanWnkl (tan (/ (* PI wnkl) 180.0)))
	       (setq sinWnkl (sin (/ (* PI wnkl) 180.0)))
	       (print tanWnkl)
	       (print sinWnkl)
	       
	       ; (*)
	       (setq delta_l_neu (/ dpNeu sinWnkl))
	       (print delta_l_neu)
	       
;	       (TrEnde.set AT_Ende (delta_l delta_l_neu))
	       
	       
	       	
	       (setq dok_diff (/ (* 1.0 dpDiff) tanWnkl))
	       (print dok_diff)
	       
	       (setq dok_kpl_alt (Blech.get kplTrg dok))
	       (print dok_kpl_alt)
	       
	       (setq dok_kpl_neu (- dok_kpl_alt dok_diff))
	       (print dok_kpl_neu)
	       
	       (Blech.set kplTrg (dok dok_kpl_neu))
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kplHtrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplHtrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplHtrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       ;(setq altesDxS		(Lochbild.get kplLochbild dxsKopf))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														;(DxSKopf (+ altesDxS dpDiff))
	       )
	       
	       (if (= (Connect.get CastaData anHtLinkesEnde) 1)
	      	 (setq HT_Ende (Traeger.get Htrg links))
	       )
	       (if (= (Connect.get CastaData anHtRechtesEnde) 1)
	      	 (setq HT_Ende (Traeger.get Htrg rechts))
	       )
	       
	       (setq dp (* 0.5 dpDiff))
	       (print dpDiff)
	       (print dp)
	       
	       ; dok frs Blech anpassen
	       (setq HT_Ende_Wnkl (TrEnde.get HT_Ende v_winkel))
	       (print HT_Ende_Wnkl)
	       
	       (if (= (Connect.get CastaData anHtLinkesEnde) 1)
	       	 (setq wnkl (- 180.0 HT_Ende_Wnkl))
	       )
	       (if (= (Connect.get CastaData anHtRechtesEnde) 1)
	       	 (setq wnkl HT_Ende_Wnkl)
	       )
	       (print wnkl)
	       
	       (setq tanWnkl (tan (/ (* PI wnkl) 180.0)))
	       (setq sinWnkl (sin (/ (* PI wnkl) 180.0)))
	       (print tanWnkl)
	       (print sinWnkl)
	       
	       
	       (setq delta_l_neu (/ dpNeu sinWnkl))
	       (print delta_l_neu)
	       
;	       (TrEnde.set HT_Ende (delta_l delta_l_neu))
	       
	       (setq dok_diff (/ (* 1.0 dpDiff) tanWnkl))
	       (print dok_diff)
	       
	       (setq dok_kpl_alt (Blech.get kplHtrg dok))
	       (print dok_kpl_alt)
	       
	       (setq dok_kpl_neu (- dok_kpl_alt dok_diff))
	       (print dok_kpl_neu)
	       
	       (Blech.set kplHtrg (dok dok_kpl_neu))
	    ))
	))
)


;*************************************************************************************************
; HILFSFUNKTIONEN
;*************************************************************************************************

; ---------------------------------------------------------------------- 
(defun createKpl_AT (blKopfpl lchbKpl bp_kpl dp_kpl ueb)
	;(print "*clear*")
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE KOPFPLATTE")
    (if (= (Connect.get CastaData linkesEnde) 1) 	(setq TrgEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData rechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
    
    (setq ueb 0)	;; nur zum Testen - Kopfplattenposition zum Traeger
    
		(setq h_ht (Traeger.get Htrg h))
		(setq h_at (Traeger.get Tr_ID h))
		
		(if (>= h_ht h_at)
			(setq h_mass h_ht)
			(setq h_mass h_at)
		)
		
    ;(setq d_u 50.0)
		(setq d_u (* 0.2 h_mass))
    (print d_u)
		
    (setq EWnkl  (TrEnde.get TrgEnde V_Winkel)
          alfa   (- EWnkl 90.0)
          hProf  (Traeger.get Tr_ID h)
          bProf  (Traeger.get Tr_ID b)
          cosW   (cos (* PI (/ alfa 180.0)))
          hNetto hProf
    )
    (if (/= cosW 0.0) (setq hNetto (/ hProf cosW)))

		; Hhe
		; ---------------------------------------------------------------
    (setq  hp_kpl  (+ hNetto d_u))
    (print hp_kpl)
		
		(setq bp_kpl bp_kpl)
		
	
		; ueb
		; ---------------------------------------------------------------
    ; Rechtes Trgerende
		(if (= (Connect.get CastaData rechtesEnde) 1)
      (progn
      	
        (setq tanW (tan (* PI (/ EWnkl 180.0))))
		    (setq ueb (/ (* 1.0 dp_kpl) tanW))
		    (print "rechtes Trgerende")
        (print ueb)
						
        (if (= (connect.get CastaData amHtOberFlansch) 1)
    	  	(progn
    	  		(print "Anschluss am HT Oberflansch")
								(if (>= EWnkl 90.0)		(setq ueb (+ ueb d_u)))
   	      	)
          )
		    (if (= (connect.get CastaData amHtUnterFlansch) 1)
					(progn
    	  		(print "Anschluss am HT Unterflansch")
								(if (>= EWnkl 90.0)		(setq ueb (+ ueb d_u)))
								;(print ueb)
   	      		)
   	      	)
		    (if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(print "Anschluss am HT Steg links")
								
          )
        )
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(print "Anschluss am HT Steg rechts")
        
      )
    )
		  )
		)
    ; Linkes Trgerende
		(if (= (Connect.get CastaData linkesEnde) 1)
      (progn
      	(print EWnkl)
		    (print dp_kpl)
        (setq tanW (tan (* PI (/ (- 180.0 EWnkl) 180.0))))
        (print tanW)
		    (setq ueb (/ (* 1.0 dp_kpl) tanW))
		    (print "linkes Trgerende")
        (print ueb)
        
        (if (= (connect.get CastaData amHtOberFlansch) 1)
					(progn
						(print "Anschluss am HT Oberflansch")
						(if (<= EWnkl 90.0)		(setq ueb (+ ueb d_u)))
								(print ueb)
									
							)
							(progn
						(print "Anschluss am HT Unterflansch")
								(if (<= EWnkl 90.0)		(setq ueb (+ ueb d_u)))
								(print ueb)
									
					)
							)
						)
          )
		    
		(print ueb)
		    
				
				
		(Blech.set blKopfpl	(dp    dp_kpl)
		         						(bp    bp_kpl)
										    (hp    hp_kpl)
										    (dOK   (- ueb))
		)
		    
		(if (= (Connect.get CastaData linkesEnde) 1) 	(traeger.addabtl Tr_ID blKopfpl 0.0 0.0 _kopfplattelinks_))
		(if (= (Connect.get CastaData rechtesEnde) 1) (traeger.addabtl Tr_ID blKopfpl 0.0 0.0 _kopfplatterechts_))

		(if (= (Connect.get CastaData linkesEnde) 1) 	(traeger.addabtl Tr_ID lchbKpl 0.0 0.0 _kpllochbildlinks_))
		(if (= (Connect.get CastaData rechtesEnde) 1) (traeger.addabtl Tr_ID lchbKpl 0.0 0.0 _kpllochbildrechts_))
			
       	
    (TrEnde.pTrim TrgEnde dp_kpl)
	(print "<-----------------------------------------------------------")
)


(defun createKpl_HT (KPL_HT KPL_AT KPL_LB DP_KPL)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE HT-KOPFPLATTE")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq Ht_Ende (Traeger.get Htrg links)))
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq Ht_Ende (Traeger.get Htrg rechts)))
	
	(setq bp_kpl_at 	(Blech.get KPL_AT bp)
				hp_kpl_at		(Blech.get KPL_AT hp)
				dok_kpl_at	(Blech.get KPL_AT dok)
	)
	(print bp_kpl_at)
	(print hp_kpl_at)
	
	(setq bp_kpl_ht 			0.0)
	(setq hp_kpl_ht 			0.0)
	(setq dok_kpl_ht 			0.0)
	(setq delta_lr_kpl_ht 0.0)
		
	(if (/= (Connect.get CastaData satr-vhtr) 0)
		; Trger AT FLANSCH an HT STEG
					(progn
			(setq bp_kpl_ht (* 1.0 hp_kpl_at))
			(setq hp_kpl_ht (* 1.0 bp_kpl_at))
		)
		; Trger AT FLANSCH an HT FLANSCH (Standard)
							(progn
			(setq bp_kpl_ht (* 1.0 bp_kpl_at))
			(setq hp_kpl_ht (* 1.0 hp_kpl_at))
		)
							)
	
	; dok
	; ---------------------------------------------
	(if (/= (Connect.get CastaData satr-vhtr) 0)
		; Trger AT FLANSCH an HT STEG
							(progn
			(setq h_ht 	(Traeger.get Htrg h))
			
			(setq dok_kpl_ht (* -0.5 (- hp_kpl_ht h_ht)))
							)
		(progn
			(setq vscherl_ht (TrEnde.get Ht_Ende vscherl))
			(print vscherl_ht)
			(print hp_kpl_ht)
			(print dok_kpl_at)
			
			(if (= (Connect.get CastaData amHtOberflansch)  1)
				(progn
					(print "am OBERFLANSCH")
					(if (< dok_kpl_at 0.0)	(setq dok_kpl_at (- dok_kpl_at)))
					
					(setq dok_kpl_ht (- (- hp_kpl_ht dok_kpl_at vscherl_ht)))
					(print dok_kpl_ht)
						)
					)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)	
				(progn
					(print "am UNTERFLANSCH")
					(setq dok_kpl_ht dok_kpl_at)
				)
        )
      )
    )
	(print dok_kpl_ht)
	
    
	; delta_lr
	; ---------------------------------------------
	(if (/= (Connect.get CastaData satr-vhtr) 0)
		; Trger AT FLANSCH an HT STEG
		(progn
			(setq hscherl_ht 	(TrEnde.get Ht_Ende hscherl))
			(print hscherl_ht)
			(print bp_kpl_ht)
    
			(setq diff_seite (* 0.5 (- bp_kpl_ht hscherl_ht)))
			(print diff_seite)
			(print dok_kpl_at)
    
			; Betrag von "dok_kpl_at"
			(if (< dok_kpl_at 0.0)	(setq dok_kpl_at (- dok_kpl_at)))
			(print dok_kpl_at)
    
			(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_kpl_ht (- dok_kpl_at diff_seite)))
			(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_kpl_ht (- diff_seite dok_kpl_at)))
			(print delta_lr_kpl_ht)
		)
	)
    
	; KPL_HT Daten setzen
	; ---------------------------------------------
	(Blech.set KPL_HT	(dp    			DP_KPL)
		         				(bp    			bp_kpl_ht)
										(hp    			hp_kpl_ht)
										(dOK   			dok_kpl_ht)
										(delta_lr 	delta_lr_kpl_ht)
    )
    

	(if (= (Connect.get CastaData anHtlinkesEnde) 1) 	(traeger.addabtl Htrg KPL_HT 0.0 0.0 _kopfplattelinks_))
	(if (= (Connect.get CastaData anHtrechtesEnde) 1) (traeger.addabtl Htrg KPL_HT 0.0 0.0 _kopfplatterechts_))
    
	(if (= (Connect.get CastaData anHtlinkesEnde) 1) 	(traeger.addabtl Htrg KPL_LB 0.0 0.0 _kpllochbildlinks_))
	(if (= (Connect.get CastaData anHtrechtesEnde) 1) (traeger.addabtl Htrg KPL_LB 0.0 0.0 _kpllochbildrechts_))

       	
	(TrEnde.pTrim Ht_Ende DP_KPL)
	(print "<-------------------------------------------------------------------------------")
)

; ---------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten (Lchb_ID BlechHT_ID BlechAT_ID)
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID (Guete   "4.6")
												(e       "1 120 0 0 0 0")
												(w       "120  0")
	)
	
	(setq h_trg 		(Traeger.get Tr_ID h)
				s_trg			(Traeger.get Tr_ID s)
				qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq t_ht			(Traeger.get Htrg t)
				qsform_ht	(Traeger.get Htrg qsform)
				h_ht			(Traeger.get Htrg h)
	)
	
	(setq hp_kpl_ht 	(Blech.get BlechHT_ID hp)
				bp_kpl_ht		(Blech.get BlechHT_ID bp)
				dok_kpl_ht	(Blech.get BlechHT_ID dok)
	)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq TrgEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq TrgEnde (Traeger.get Htrg rechts))
	)
	(if (= (Connect.get CastaData LinkesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData RechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
	
	(setq vWinkel_ht	(TrEnde.get TrgEnde v_winkel))
	(print vWinkel_ht)
	
	(setq tanW (tan (/ (* PI vWinkel_ht) 180.0)))
	(setq sinW (sin (/ (* PI vWinkel_ht) 180.0)))
	(print tanW)
	(print sinW)
	
	(if (< tanW 0) (setq tanW (- tanW)))
	
	
	
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq min_hp (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	
	; Klemmlnge und dxSKopf setzen
	(setq dp_blechHT (Blech.get BlechHT_ID dp))
	(setq dp_blechAT (Blech.get BlechAT_ID dp))
	(print dp_blechHT)
	(print dp_blechAT)
	
	(Lochbild.set Lchb_ID (klemml (+ dp_blechHT dp_blechAT))
												(dxSKopf  0)
	)
	
	
	(setq schr_l (Lochbild.get Lchb_ID laenge))
	(print schr_l)
	
	(setq e_HT (/ schr_l tanW))
	(print e_HT)
	(setq anteil_flansch (/ t_ht sinW))
	(print anteil_flansch)
	
	
	; e0 berechnen
	; ----------------------------------------------
	(setq vscherl_ht (TrEnde.get TrgEnde vscherl))
	(setq vscherl_at (TrEnde.get At_Ende vscherl))
	(print vscherl_ht)
	(print vscherl_at)
	
	(if (>= vscherl_ht vscherl_at)
		(setq mass_scherl vscherl_at)
		(setq mass_scherl vscherl_ht)
	)
	(print mass_scherl)
	
	(setq vwnkl_at (Connect.get CastaData v-atrgewnkl_kopf))
	
	(if (>= vwnkl_at 90.0)	
		(setq e0 (+ (* 0.25 mass_scherl) dp_blechHT))
		(setq e0 (- (* 0.25 mass_scherl) dp_blechHT))
	)
	
	(setq e1 (* 0.5 mass_scherl))
	;(setq e0 (* 0.25 hp_kpl_ht))
	;(setq e1 (- hp_kpl_ht (+ (* 2.0 e0) (* 0.5 d_u))))
	(print e0)
	(print e1)
	
	
	
		
	(setq w0 (+ (/ (- bp_kpl_ht s_trg) 2) s_trg))
	
	(setq b_at	(Traeger.get Tr_ID b))
	
	;(if (= (Connect.get CastaData satr-shtr) 0)
			
	;)
	
	(if (= qsform_at "K")
		(setq w0 (+ (* 1.5 e_blech) b_at))
	)	
	(if (= qsform_at "R")
		(progn
			
			(setq w0 (+ (* 1.0 e_blech) b_at))
		)
	)
	
	(Lochbild.set Lchb_ID (e0 e0)
												(e1 e1)
												(w0 w0)
	)
	
	
	(print "--------------------------------------------------------------------------------")
)
; ---------------------------------------------------------------------- 

; ---------------------------------------------------------------------- */
(defun schiebeAnschlussFlaechen ()

  (print "------------------------------------------------------------")
  (print "SCHIEBE ANSCHLUSSFLCHEN")

  (if (= (connect.get CastaData anHtLinkesEnde)  1) (setq HTrgEnde   (traeger.get HTrg links)))
  (if (= (connect.get CastaData anHtRechtesEnde) 1) (setq HTrgEnde   (traeger.get HTrg rechts)))

  ; Anschluss am linken Anschlusstrger
  (if (= (connect.get CastaData LinkesEnde) 1) 
  (progn
      (setq TrLinks   (traeger.get tr_id links))
      (setq EWnkl     (TrEnde.get  TrLinks V_Winkel))
      (setq deltaV (Traeger.get Tr_ID delta_V))

      (setq alfa  (- 180.0 EWnkl))
      (setq dlTrg (/ (* 1.0 deltaV) (sin (* PI (/ alfa 180.0)))))

      (setq deltaV (Traeger.get HTrg delta_V))
      (setq EWnkl  (TrEnde.get  HTrgEnde V_Winkel))
      
      (if (= (connect.get CastaData anhtRechtesEnde) 1) 
      (progn
          (if (= (connect.get CastaData amHtOberflansch) 1) 
          (progn
             (setq beta           (- 180.0 EWnkl))
             (setq deltaV         (- deltaV))
          ))
          (if (= (connect.get CastaData amHtUnterflansch) 1) 
          (progn
             (setq beta           EWnkl)
          ))
          (setq dlHTrg (/ (* 1.0 deltaV) (sin (* PI (/ beta 180.0)))))
      ))

      (if (= (connect.get CastaData anhtLinkesEnde) 1) (progn
;          (setq HTrgEnde   (traeger.get HTrg links))
;          (setq EWnkl     (TrEnde.get  HTrgEnde V_Winkel))
          (if (= (connect.get CastaData amHtOberflansch) 1) (progn
             (setq beta           EWnkl)
             (setq deltaV         (- deltaV))
          ))
          (if (= (connect.get CastaData amHtUnterflansch) 1) (progn
             (setq beta           (- 180.0 EWnkl))
          ))
          (setq dlHTrg (/ (* 1.0 deltaV) (sin (* PI (/ beta 180.0)))))
      ))
							          (print "....................Eingangsdaten")
							          (print deltaV)
							          (print dlTrg)
							          (print dlHTrg)
  ))
  
  ; Anschluss am rechten Anschlusstrger
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrRechts  (traeger.get tr_id rechts))
      (setq EWnkl     (TrEnde.get  TrRechts V_Winkel))
      (setq deltaV (Traeger.get Tr_ID delta_V))

      (setq alfa  EWnkl)
      (setq dlTrg (/ (* 1.0 deltaV) (sin (* PI (/ alfa 180.0)))))

      (setq deltaV (Traeger.get HTrg delta_V))
      (setq EWnkl  (TrEnde.get  HTrgEnde V_Winkel))
      (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
;          (setq HTrgEnde   (traeger.get HTrg rechts))
;          (setq EWnkl     (TrEnde.get  HTrgEnde V_Winkel))
          (if (= (connect.get CastaData amHtOberflansch) 1) (progn
             (setq beta           (- 180.0 EWnkl))
             (setq deltaV         (- deltaV))
          ))
          (if (= (connect.get CastaData amHtUnterflansch) 1) (progn
             (setq beta           EWnkl)
          ))
          (setq dlHTrg (/ (* 1.0 deltaV) (sin (* PI (/ beta 180.0)))))
      ))
      ; ------------ neu
      (if (= (connect.get CastaData anhtLinkesEnde) 1) (progn
;         (setq HTrgEnde   (traeger.get HTrg links))
;         (setq EWnkl     (TrEnde.get  HTrgEnde V_Winkel))
          (if (= (connect.get CastaData amHtOberflansch) 1) (progn
             (setq deltaV         (- deltaV))
             (setq beta           EWnkl)
          ))
          (if (= (connect.get CastaData amHtUnterflansch) 1) (progn
             (setq beta           (- 180.0 EWnkl))
          ))
          (setq dlHTrg (/ (* 1.0 deltaV) (sin (* PI (/ beta 180.0)))))
      ))
							          (print "....................Eingangsdaten")
							          (print deltaV)
							          (print dlTrg)
							          (print dlHTrg)

  ))



  
  (setq vDiff (- dlHTrg dlTrg))
  (print vDiff)
  (print alfa)
  (print beta)
  
  ; --- a, alfa vom Trger, b, beta vom Haupttrger (der Sttze)
  (setq tanAlfa (tan (* PI (/ alfa 180.0))))
  (setq tanBeta (tan (* PI (/ beta 180.0))))
  (print tanAlfa)
  (print tanBeta)
  
  (if (< tanAlfa 0.0) (setq tanAlfa (- tanAlfa)))
  
  (setq a (/ vDiff (+ (/ tanAlfa tanBeta) 1.0)))
  (setq b (- vDiff a))
  (print a)
  (print b)
  
  (setq dlTrgEnde  (/ a (cos (* PI (/ alfa 180.0)))))
  (setq dlHTrgEnde (/ b (cos (* PI (/ beta 180.0)))))
  
  (print dlTrgEnde)
  (print dlHTrgEnde)

  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq dlLinks     (TrEnde.get  TrLinks delta_L)
      	    dlGesamt    (+ dlLinks dlTrgEnde)
      )
     (TrEnde.set TrLinks (delta_L dlGesamt))
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
     (setq dlRechts  (TrEnde.get  TrRechts delta_L))
     (setq dlGesamt  (+ dlRechts dlTrgEnde))
     (TrEnde.set TrRechts (delta_L dlGesamt))
  ))

  (setq deltaV (Traeger.get HTrg delta_V))
  (setq dlRechts    (TrEnde.get  HTrgEnde delta_L)
	dlGesamt    (- dlRechts dlHTrgEnde)
  )
  (TrEnde.set HTrgEnde (delta_L dlGesamt))

  
)
; ---------------------------------------------------------------------- */


; ----------------------------------------------------------------------------------------
; Berechnet die Verschiebungen der Anbauteile
; ----------------------------------------------------------------------------------------
(defun calcLB_Abtl (LCHB_ID)
	(print ">-------------------------------------------------------------------------------")
	
	(if (/= (Connect.get CastaData satr-vhtr) 1)
		(progn
			(setq wnkl 0.0) 
		)
		(progn
			(setq wnkl 90.0) 
		)
	)
	(print wnkl)
	
	(setq lb_abtl_ht (traeger.get Htrg ABTeil LCHB_ID))
	(Anbauteil.set lb_abtl_ht (Master 1)
														(winkel 45.0)
	)
														
		  
	(setq lb_abtl_at (traeger.get Tr_ID ABTeil LCHB_ID))
	(Anbauteil.set lb_abtl_at (Master 0))

   ;; AF - 2009 - Kombination der Flanschkontakte untersuchen um
   ;; Lochbildorientierung festzulegen
   (if (= 1 1) (progn	
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
	    (if (= (Connect.get CastaData amHtOberflansch) 1)
		(Anbauteil.set lb_abtl_ht (switch_on _unterflansch_))
	    )
	)
	(if (= (Connect.get CastaData amAtOberflansch) 1)
	    (if (= (Connect.get CastaData amHtUnterflansch) 1)
		(Anbauteil.set lb_abtl_ht (switch_on _unterflansch_))
	    )
	)
   ))
			
			
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			;(setq XPos_at (Connect.get CastaData XPos_AT))
			(Lochbild.set LCHB_ID (e2 200))
					
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy LCHB_ID)
								
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(traeger.addabtl tr_id dummy 0.0 0.0 _kpllochbildrechts_)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(traeger.addabtl tr_id dummy 0.0 0.0 _kpllochbildlinks_)
			)
			
					
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1) )
		)
	)
	;===================================================================
	
	(print "<-------------------------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Korrigiert die Blechbreite, wenn es sich um Rohrprofile handelt, da die Schrauben dann
; weiter auseinander liegen.
; ----------------------------------------------------------------------------------------
(defun korrBlechBreite_AT (BLECH_AT)
	
	(setq qsform_at (Traeger.get Tr_ID qsform))

	(setq b_at (Traeger.get Tr_ID b))
	
	(setq vorh_bp_blech (Blech.get BLECH_AT bp))
	
	(setq bp_korr vorh_bp_blech)
	
	(if (= qsform_at "K")	(setq bp_korr (+ (* 3.0 e_min) b_at))) 
	(if (= qsform_at "R")	(setq bp_korr (+ (* 3.0 e_min) b_at))) 
	
	(Blech.set BLECH_AT (bp bp_korr))
)

; ----------------------------------------------------------------------------------------
; Berechnet die Dicke der Kopfplatten
; ----------------------------------------------------------------------------------------
(defun calcBlech_dp ()
	(setq t_ht (Traeger.get Htrg t))

	(setq t_at (Traeger.get Tr_ID t))
	
	(if (>= t_at t_ht)
		(setq mass_dp t_at)
		(setq mass_dp t_ht)
	)
	
	(setq dp_kpl (runde mass_dp auf 5.0))
	(if (< dp_kpl 10.0)
		(setq dp_kpl 10.0)
	)
)
; --------------------
; getestet 19.05.2009 alle Mglichkeiten
; derzeit nicht allgemeingltig, da 90 zwischen HT-Flansch und AT-Endflche vorausgesetzt
; werden.
(defun	calcHVerschLochbild (kplLochbild)

	(setq abteilHT (Traeger.get HTrg  ABTeil kplLochbild))
        (setq ABTeilAT (Traeger.get Tr_ID ABTeil kplLochbild))

	(setq 
		delta_lr_at 	(Traeger.get Tr_ID delta_LR)
		delta_lr_ht 	(Traeger.get HTrg  delta_LR)
		delta_lr_abt_ht 0.0
	)

	(setq delta_lr_at (- delta_lr_at))

	; Mai 2009 - komplett neu programmiert
	; Verschiebung delta_lr AT
	; Verschiebung delta_lr HT
    (if (= 1 1) (progn
      (if (= (Connect.get CastaData vATr-LHTr)  1) (progn
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
	    (if (= (Connect.get CastaData sATr-SHTr) -1) (setq delta_lr_abt_ht    (- delta_lr_ht  delta_lr_at)))
	    (if (= (Connect.get CastaData sATr-SHTr)  1) (setq delta_lr_abt_ht    (+ delta_lr_ht  delta_lr_at)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    (if (= (Connect.get CastaData sATr-SHTr)  1) (setq delta_lr_abt_ht    (+ delta_lr_at  delta_lr_ht)))
	    (if (= (Connect.get CastaData sATr-SHTr) -1) (setq delta_lr_abt_ht (- (- delta_lr_at  delta_lr_ht))))
	))
      ))
      (if (= (Connect.get CastaData vATr-LHTr) -1) (progn
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
	    (if (= (Connect.get CastaData sATr-SHTr) -1) (setq delta_lr_abt_ht    (- delta_lr_ht  delta_lr_at)))
	    (if (= (Connect.get CastaData sATr-SHTr)  1) (setq delta_lr_abt_ht    (+ delta_lr_ht  delta_lr_at)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    (if (= (Connect.get CastaData sATr-SHTr) -1) (setq delta_lr_abt_ht (- delta_lr_ht  delta_lr_at)))
	    (if (= (Connect.get CastaData sATr-SHTr)  1) (setq delta_lr_abt_ht (+ delta_lr_at  delta_lr_ht)))
	))
      ))

      (if (= (Connect.get CastaData anhtlinkesende  ) 1) (progn
           (setq    HT_OF_K 1       AT_OF_K 1)
	   (if (= (Connect.get CastaData amHTunterflansch ) 1) (setq  HT_OF_K -1))
	   (if (= (Connect.get CastaData amATunterflansch ) 1) (setq  AT_OF_K -1))
	   (setq AFlag (* HT_OF_K AT_OF_K))
	   (if (< AFlag 0)    (setq delta_lr_abt_ht (- delta_lr_abt_ht)))
      ))
    ))


  (if (= 1 1) (progn
        (setq ABTeil (Traeger.get HTrg ABTeil kplLochbild))
        (Anbauteil.set ABTeil (delta_lr delta_lr_abt_ht))
  ))


  (if (= 1 1) (progn
     (if (= (Connect.get CastaData vATr-LHTr)  1) (progn
	 (if (= (Connect.get CastaData linkesEnde) 1)  (progn
	    (if (= (Connect.get CastaData anhtrechtesende ) 1)  (Anbauteil.set abteilHT (SeitRicht  1)))
	    (if (= (Connect.get CastaData anhtlinkesende  ) 1)  (Anbauteil.set abteilHT (SeitRicht -1)))
	 ))
	 (if (= (Connect.get CastaData rechtesEnde) 1)  (progn
	    (if (= (Connect.get CastaData anhtrechtesende ) 1)  (Anbauteil.set abteilHT (SeitRicht -1)))
	    (if (= (Connect.get CastaData anhtlinkesende  ) 1)  (Anbauteil.set abteilHT (SeitRicht  1)))
	 ))
     ))
     (if (= (Connect.get CastaData vATr-LHTr) -1) (progn
	 (if (= (Connect.get CastaData linkesEnde) 1)  (progn
	    (if (= (Connect.get CastaData anhtrechtesende ) 1)  (Anbauteil.set abteilHT (SeitRicht  1)))
	    (if (= (Connect.get CastaData anhtlinkesende  ) 1)  (Anbauteil.set abteilHT (SeitRicht -1)))
	 ))
	 (if (= (Connect.get CastaData rechtesEnde) 1)  (progn
	    (if (= (Connect.get CastaData anhtrechtesende ) 1)  (Anbauteil.set abteilHT (SeitRicht -1)))
	    (if (= (Connect.get CastaData anhtlinkesende  ) 1)  (Anbauteil.set abteilHT (SeitRicht  1)))
	 ))
     ))
  ))

  (if (= 2 3) (progn
	;; Testen - AF-20090513
	(Lochbild.set kplLochbild (LB_Art   2))			; AF-20090512
	(Lochbild.set kplLochbild (delta_w  50))		; AF-20090512
	(Lochbild.set kplLochbild (e    "0 30 100 0 0 0"))	; AF-20090512
	(Lochbild.set kplLochbild (w    "23 0"))		; AF-20090512

  ))

	(Anbauteil.set abteilHT   (Master 0))
	(Anbauteil.set abteilAT   (Master 1))


)