; ---------------------------------------------------------------------- */
(defun load-modules ()
   (load "mod-endinit-uz-stzgehrung")
)
; ---------------------------------------------------------------------- */
(defun init-connection ()

  (print "in init-connection - Gehrung an Stz-Ende");

  (init-traegerenden)				
	
  ;(schiebeAnschlussFlaechen)
  
  
   ;---------- Kopfplatten und Lochbild hinzufgen
  (setq kplLochbild (Lochbild.create))
  (setq kplHtrg     (Blech.create))
  (setq kplTrg      (Blech.create))
  
  (Connect.storeAnschlObjs CastaData kplLochbild kplHtrg kplTrg)
  
  (setq ueb 5)
  
  (setq bl_breite (Traeger.get Tr_ID b))
  (setq bl_breite (+ bl_breite 10))
  
  (setq HtrEnde (Traeger.get HTrg links))
    
    (if (= (connect.get CastaData linkesEnde) 1)
        (createKpl Tr_ID 0 kplTrg kplLochbild bl_breite 20 0 1)
    )
    (if (= (connect.get CastaData rechtesEnde) 1)
        (createKpl Tr_ID 0 kplTrg kplLochbild bl_breite 20 0 -1)
    )

    (if (= (connect.get CastaData anHtLinkesEnde) 1) 
        (createKpl HTrg 1 kplHTrg kplLochbild bl_breite 20 0  1)
    )
    (if (= (connect.get CastaData anHtRechtesEnde) 1) 
        (createKpl HTrg 1 kplHTrg kplLochbild bl_breite 20 0 -1)
    )
  
  
  
  (calcAndSetLochbildDaten kplLochbild kplHtrg kplTrg)
  
  (setq dok_kpl_ht (Blech.get kplHtrg dok))
  (setq dok_kpl_at (Blech.get kplTrg dok))
  (print dok_kpl_ht)
  (print dok_kpl_at)
  
  (if (< dok_kpl_ht dok_kpl_at)
  	(setq diff_dok (- dok_kpl_ht dok_kpl_at))
  	(setq diff_dok (- dok_kpl_at dok_kpl_ht))
  )
  (print diff_dok)
  
  (setq Abtl_KplLchb (traeger.get Htrg ABTeil kplLochbild))
  (Anbauteil.set Abtl_KplLchb (Master 1))
  (setq Abtl_KplLchb2 (traeger.get Tr_ID ABTeil kplLochbild))
  (Anbauteil.set Abtl_KplLchb2 (Master 0))
  (Anbauteil.set Abtl_KplLchb2 (delta_v 0))
  
	
	(if (= (Connect.get CastaData amHtOberflansch) 1) (Anbauteil.set Abtl_KplLchb (switch_on _unterflansch_)))
	
	; CALLBACKS
	(Blech.set kplTrg 	(formFkt "cb_kplTrg"))
	(Blech.set kplHtrg 	(formFkt "cb_kplHtrg"))

)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kplTrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplTrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplTrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       (setq altesDxS		(Lochbild.get kplLochbild dxsKopf))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														;(DxSKopf (+ altesDxS dpDiff))
	       )
	       
	       (if (= (Connect.get CastaData linkesEnde) 1)
	      	 (setq AT_Ende (Traeger.get Tr_ID links))
	       )
	       (if (= (Connect.get CastaData rechtesEnde) 1)
	      	 (setq AT_Ende (Traeger.get Tr_ID rechts))
	       )
	       (TrEnde.set AT_Ende (delta_l 0))
	       (TrEnde.pTrim AT_Ende dpNeu)
	       
	       ; dok frs Blech anpassen
	       (setq AT_Ende_Wnkl (TrEnde.get AT_Ende v_winkel))
	       (print AT_Ende_Wnkl)
	       
	       (if (= (Connect.get CastaData linkesEnde) 1)
	       	 (setq wnkl (- 180.0 AT_Ende_Wnkl))
	       )
	       (if (= (Connect.get CastaData rechtesEnde) 1)
	       	 (setq wnkl AT_Ende_Wnkl)
	       )
	       (print wnkl)
	       
	       (setq tanWnkl (tan (/ (* PI wnkl) 180.0)))
	       (print tanWnkl)
	       
	       (setq dok_diff (/ dpDiff tanWnkl))
	       (print dok_diff)
	       
	       (setq dok_kpl_alt (Blech.get kplTrg dok))
	       (print dok_kpl_alt)
	       
	       (setq dok_kpl_neu (- dok_kpl_alt dok_diff))
	       (print dok_kpl_neu)
	       
	       (Blech.set kplTrg (dok dok_kpl_neu))
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am HT
; ----------------------------------------------------------------------------------------
(defun cb_kplHtrg (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kplHtrg dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kplHtrg dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       ;(setq altesDxS		(Lochbild.get kplLochbild dxsKopf))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														;(DxSKopf (+ altesDxS dpDiff))
	       )
	       
	       (if (= (Connect.get CastaData anHtLinkesEnde) 1)
	      	 (setq HT_Ende (Traeger.get Htrg links))
	       )
	       (if (= (Connect.get CastaData anHtRechtesEnde) 1)
	      	 (setq HT_Ende (Traeger.get Htrg rechts))
	       )
	       (TrEnde.set HT_Ende (delta_l 0))
	       (TrEnde.pTrim HT_Ende dpNeu)
	       
	       ; dok frs Blech anpassen
	       (setq HT_Ende_Wnkl (TrEnde.get HT_Ende v_winkel))
	       (print HT_Ende_Wnkl)
	       
	       (if (= (Connect.get CastaData anHtLinkesEnde) 1)
	       	 (setq wnkl (- 180.0 HT_Ende_Wnkl))
	       )
	       (if (= (Connect.get CastaData anHtRechtesEnde) 1)
	       	 (setq wnkl HT_Ende_Wnkl)
	       )
	       (print wnkl)
	       
	       (setq tanWnkl (tan (/ (* PI wnkl) 180.0)))
	       (print tanWnkl)
	       
	       (setq dok_diff (/ dpDiff tanWnkl))
	       (print dok_diff)
	       
	       (setq dok_kpl_alt (Blech.get kplHtrg dok))
	       (print dok_kpl_alt)
	       
	       (setq dok_kpl_neu (- dok_kpl_alt dok_diff))
	       (print dok_kpl_neu)
	       
	       (Blech.set kplHtrg (dok dok_kpl_neu))
	    ))
	))
)


;*************************************************************************************************
; HILFSFUNKTIONEN
;*************************************************************************************************

; ---------------------------------------------------------------------- 
(defun createKpl (Trg isHT blKopfpl lchbKpl bp dp ueb li_re)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE KOPFPLATTE")
    (if (= li_re  1) (setq TrgEnde (Traeger.get Trg links)))
    (if (= li_re -1) (setq TrgEnde (Traeger.get Trg rechts)))
    
    (setq ueb 0)	;; nur zum Testen - Kopfplattenposition zum Traeger
    

    (setq d_u 50)
    (print d_u)
    (setq EWnkl  (TrEnde.get TrgEnde V_Winkel)
          alfa   (- EWnkl 90.0)
          hProf  (Traeger.get Trg h)
          bProf  (Traeger.get Trg b)
          cosW   (cos (* PI (/ alfa 180.0)))
          hNetto hProf
    )
    (if (/= cosW 0) (setq hNetto (/ hProf cosW)))

		; magebende Kopfplatte bestimmen
		
		
    ; Rechtes Trgerende
    (if (= li_re -1)
      (progn
      	
        (setq tanW (tan (* PI (/ EWnkl 180.0))))
        (setq ueb (/ dp tanW))
        (print "rechts")
        (print ueb)
        (if (= (connect.get CastaData amHtOberFlansch) 1)
    	  	(progn
    	  		(print "Anschluss am HT Oberflansch")
    	    	(if (= isHT 1)
    	      	(progn
    	      		(print "Ist HT")
   	        		(setq ueb (+ ueb d_u))
   	        		(print ueb)
   	      		)
   	      		(progn
   	      			(print "Ist AT")
   	      		)
   	      	)
          )
        )
        
      )
    )
    ; Linkess Trgerende
    (if (= li_re 1)
      (progn
        (setq tanW (tan (* PI (/ (- 180.0 EWnkl) 180.0))))
        (setq ueb (/ dp tanW))
        (print "links")
        (print ueb)
        
        (if (= (connect.get CastaData amHtOberFlansch) 1)
    	  (progn
    	  (print "Anschluss am HT Oberflansch")
    	    (if (= isHT 1)
    	      (progn
    	      (print "Ist HT")
   	        (setq ueb (+ ueb d_u))
   	        (print ueb)
   	      )
   	      (progn
   	      (print "Ist AT")
   	      )
   	      )
          )
        )
      )
    )
    
    (print ueb)
    
    (setq  hp  (+ hNetto d_u))
    
    
    
    (Blech.set blKopfpl	(dp    dp)
         								(bp    bp)
								        (hp    hp)
								        (dOK   (- ueb))
    )
    
    (if (= li_re  1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplattelinks_))
    (if (= li_re -1) (traeger.addabtl Trg blKopfpl 0.0 0.0 _kopfplatterechts_))

    (if (= li_re  1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildlinks_))
    (if (= li_re -1) (traeger.addabtl Trg lchbKpl 0.0 0.0 _kpllochbildrechts_))
    
       	
    (TrEnde.pTrim TrgEnde dp)
	(print "<-----------------------------------------------------------")
)



; ---------------------------------------------------------------------- 
(defun calcAndSetLochbildDaten (Lchb_ID BlechHT_ID BlechAT_ID)
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID (Guete   "4.6")
												(e       "1 120 0 0 0 0")
												(w       "120  0")
	)
	
	(setq h_trg (Traeger.get Tr_ID h)
				s_trg	(Traeger.get Tr_ID s)
	)
	
	(setq t_ht	(Traeger.get Htrg t))
	
	(setq hp_kpl_ht (Blech.get BlechHT_ID hp)
				bp_kpl_ht	(Blech.get BlechHT_ID bp)
	)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq TrgEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq TrgEnde (Traeger.get Htrg rechts))
	)
	
	(setq vWinkel_ht	(TrEnde.get TrgEnde v_winkel))
	(print vWinkel_ht)
	
	(setq tanW (tan (/ (* PI vWinkel_ht) 180.0)))
	(setq sinW (sin (/ (* PI vWinkel_ht) 180.0)))
	(print tanW)
	(print sinW)
	
	(if (< tanW 0) (setq tanW (- tanW)))
	
	; Schaube anhand der Anschlusstrgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq min_hp (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	
	; Klemmlnge und dxSKopf setzen
	(setq dp_blechHT (Blech.get BlechHT_ID dp))
	(setq dp_blechAT (Blech.get BlechAT_ID dp))
	(print dp_blechHT)
	(print dp_blechAT)
	
	(Lochbild.set Lchb_ID (klemml (+ dp_blechHT dp_blechAT))
												(dxSKopf  0)
	)
	
	
	(setq schr_l (Lochbild.get Lchb_ID laenge))
	(print schr_l)
	
	(setq e_HT (/ schr_l tanW))
	(print e_HT)
	(setq anteil_flansch (/ t_ht sinW))
	(print anteil_flansch)
	
	;(setq e0 (+ e_HT anteil_flansch 30 10))
	(setq e0 (* 0.25 hp_kpl_ht))
	(setq e1 (- hp_kpl_ht (* 2.0 e0)))
	(print e0)
	(print hp_kpl_ht)
	;(if (= (Connect.get CastaData amHtOberflansch) 1)
	;	(progn
	;		(print "HT-Oberflansch")
	;		;(setq vWinkel_ht (- 180.0 vWinkel_ht))
	;		(setq scherlaenge (TrEnde.get TrgEnde vscherl))
			
	;		(setq e0_korr (- scherlaenge e1 e0))
	;		(setq e0 e0_korr)
	;	)
	;)
	
	
		
	(setq w0 (+ (/ (- bp_kpl_ht s_trg) 2) s_trg))
	
	(Lochbild.set Lchb_ID (e0 e0)
												(e1 e1)
												(w0 w0)
	)
	
	(print "--------------------------------------------------------------------------------")
)
; ---------------------------------------------------------------------- 

; ---------------------------------------------------------------------- */
(defun schiebeAnschlussFlaechen ()

  (print "------------------------------------------------------------")
  (print "SCHIEBE ANSCHLUSSFLCHEN")

  (if (= (connect.get CastaData anHtLinkesEnde)  1) (setq HTrgEnde   (traeger.get HTrg links)))
  (if (= (connect.get CastaData anHtRechtesEnde) 1) (setq HTrgEnde   (traeger.get HTrg rechts)))

  ; Anschluss am linken Anschlusstrger
  (if (= (connect.get CastaData LinkesEnde) 1) 
  (progn
      (setq TrLinks   (traeger.get tr_id links))
      (setq EWnkl     (TrEnde.get  TrLinks V_Winkel))
      (setq deltaV (Traeger.get Tr_ID delta_V))

      (setq alfa  (- 180.0 EWnkl))
      (setq dlTrg (/ (* 1.0 deltaV) (sin (* PI (/ alfa 180.0)))))

      (setq deltaV (Traeger.get HTrg delta_V))
      (setq EWnkl  (TrEnde.get  HTrgEnde V_Winkel))
      
      (if (= (connect.get CastaData anhtRechtesEnde) 1) 
      (progn
          (if (= (connect.get CastaData amHtOberflansch) 1) 
          (progn
             (setq beta           (- 180.0 EWnkl))
             (setq deltaV         (- deltaV))
          ))
          (if (= (connect.get CastaData amHtUnterflansch) 1) 
          (progn
             (setq beta           EWnkl)
          ))
          (setq dlHTrg (/ (* 1.0 deltaV) (sin (* PI (/ beta 180.0)))))
      ))

      (if (= (connect.get CastaData anhtLinkesEnde) 1) (progn
;          (setq HTrgEnde   (traeger.get HTrg links))
;          (setq EWnkl     (TrEnde.get  HTrgEnde V_Winkel))
          (if (= (connect.get CastaData amHtOberflansch) 1) (progn
             (setq beta           EWnkl)
             (setq deltaV         (- deltaV))
          ))
          (if (= (connect.get CastaData amHtUnterflansch) 1) (progn
             (setq beta           (- 180.0 EWnkl))
          ))
          (setq dlHTrg (/ (* 1.0 deltaV) (sin (* PI (/ beta 180.0)))))
      ))
							          (print "....................Eingangsdaten")
							          (print deltaV)
							          (print dlTrg)
							          (print dlHTrg)
  ))
  
  ; Anschluss am rechten Anschlusstrger
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrRechts  (traeger.get tr_id rechts))
      (setq EWnkl     (TrEnde.get  TrRechts V_Winkel))
      (setq deltaV (Traeger.get Tr_ID delta_V))

      (setq alfa  EWnkl)
      (setq dlTrg (/ (* 1.0 deltaV) (sin (* PI (/ alfa 180.0)))))

      (setq deltaV (Traeger.get HTrg delta_V))
      (setq EWnkl  (TrEnde.get  HTrgEnde V_Winkel))
      (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
;          (setq HTrgEnde   (traeger.get HTrg rechts))
;          (setq EWnkl     (TrEnde.get  HTrgEnde V_Winkel))
          (if (= (connect.get CastaData amHtOberflansch) 1) (progn
             (setq beta           (- 180.0 EWnkl))
             (setq deltaV         (- deltaV))
          ))
          (if (= (connect.get CastaData amHtUnterflansch) 1) (progn
             (setq beta           EWnkl)
          ))
          (setq dlHTrg (/ (* 1.0 deltaV) (sin (* PI (/ beta 180.0)))))
      ))
      ; ------------ neu
      (if (= (connect.get CastaData anhtLinkesEnde) 1) (progn
;         (setq HTrgEnde   (traeger.get HTrg links))
;         (setq EWnkl     (TrEnde.get  HTrgEnde V_Winkel))
          (if (= (connect.get CastaData amHtOberflansch) 1) (progn
             (setq deltaV         (- deltaV))
             (setq beta           EWnkl)
          ))
          (if (= (connect.get CastaData amHtUnterflansch) 1) (progn
             (setq beta           (- 180.0 EWnkl))
          ))
          (setq dlHTrg (/ (* 1.0 deltaV) (sin (* PI (/ beta 180.0)))))
      ))
							          (print "....................Eingangsdaten")
							          (print deltaV)
							          (print dlTrg)
							          (print dlHTrg)

  ))



  
  (setq vDiff (- dlHTrg dlTrg))
  (print vDiff)
  (print alfa)
  (print beta)
  
  ; --- a, alfa vom Trger, b, beta vom Haupttrger (der Sttze)
  (setq tanAlfa (tan (* PI (/ alfa 180.0))))
  (setq tanBeta (tan (* PI (/ beta 180.0))))
  (print tanAlfa)
  (print tanBeta)
  
  (if (< tanAlfa 0.0) (setq tanAlfa (- tanAlfa)))
  
  (setq a (/ vDiff (+ (/ tanAlfa tanBeta) 1.0)))
  (setq b (- vDiff a))
  (print a)
  (print b)
  
  (setq dlTrgEnde  (/ a (cos (* PI (/ alfa 180.0)))))
  (setq dlHTrgEnde (/ b (cos (* PI (/ beta 180.0)))))
  
  (print dlTrgEnde)
  (print dlHTrgEnde)

  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq dlLinks     (TrEnde.get  TrLinks delta_L)
      	    dlGesamt    (+ dlLinks dlTrgEnde)
      )
     (TrEnde.set TrLinks (delta_L dlGesamt))
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
     (setq dlRechts  (TrEnde.get  TrRechts delta_L))
     (setq dlGesamt  (+ dlRechts dlTrgEnde))
     (TrEnde.set TrRechts (delta_L dlGesamt))
  ))

  (setq deltaV (Traeger.get HTrg delta_V))
  (setq dlRechts    (TrEnde.get  HTrgEnde delta_L)
	dlGesamt    (- dlRechts dlHTrgEnde)
  )
  (TrEnde.set HTrgEnde (delta_L dlGesamt))

  
)
; ---------------------------------------------------------------------- */


