; $	HT	QT(IUKR)	AF(FS)	P(EZ)
; $	AT	QT(LFRKS)	AF(K)		P(E)
; $	AE	V(-)			H(-)		R(-)

(defun load-modules ()
  ; Profil prfen
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
  (if (= qsform_at "L")	(load "mod-calc-kwindverband_L"))
  (if (= qsform_at "F")	(load "mod-calc-kwindverband_F"))
  (if (= qsform_at "U") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "I") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "R") (load "mod-calc-kwindverband_R_V2"))
  (if (= qsform_at "K") (load "mod-calc-kwindverband_R_V2"))
  
  (load "mod-lochbild")
)

(defun init-connection ()
  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - uz_Windverb_1");
   
  (connect.ShowAttributes CastaData)

  (setq AT_Rotation_OK 1)
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (if (= qsform_at "L") (progn
	(setq AT_Rotation_OK 0)
	(setq RWnkl_AT (Connect.get CastaData R-ATrGeWnkl_Steg))
	(if (= RWnkl_AT   0.0) (setq AT_Rotation_OK 1))
	(if (= RWnkl_AT  90.0) (setq AT_Rotation_OK 1))
	(if (= RWnkl_AT 180.0) (setq AT_Rotation_OK 1))
	(if (= RWnkl_AT 270.0) (setq AT_Rotation_OK 1))
	
	 ; Reserve-Fall - soll aber abgelst werden durch Ebenen-Check (senkrecht zu Flansch oder Stegebene)
	 (if (= AT_Rotation_OK 0) (progn
		(setq hAtrFlWnkl (Connect.get CastaData h-atrgewnkl_flansch))
		(if (=  hAtrFlWnkl    0.0) (setq  AT_Rotation_OK 1))
		(if (=  hAtrFlWnkl   90.0) (setq  AT_Rotation_OK 1))
		(if (=  hAtrFlWnkl 180.0) (setq  AT_Rotation_OK 1))
		(if (=  hAtrFlWnkl 270.0) (setq  AT_Rotation_OK 1))
	  ))
	 (if (= AT_Rotation_OK 0) (progn
		(setq vAtrFlWnkl (Connect.get CastaData v-atrgewnkl_flansch))
		(if (=  vAtrFlWnkl    0.0) (setq  AT_Rotation_OK 1))
		(if (=  vAtrFlWnkl   90.0) (setq  AT_Rotation_OK 1))
		(if (=  vAtrFlWnkl 180.0) (setq  AT_Rotation_OK 1))
		(if (=  vAtrFlWnkl 270.0) (setq  AT_Rotation_OK 1))
	  ))
	))
  
  (if (= AT_Rotation_OK 1) (progn
		(setq K-Verband 0)
		(sucheKnotenBlech 1)
		
		(Continue_Connection)
		(Connect.ShowAttributes CastaData)
    )
    (progn
	(alertBox "Der Rotations-Winkel des Windverbandstabs passt nicht zum Anschluss!"  "ERR_Rotation_Angle_Bracing")
	
    )
  ); if


)
(defun Continue_Connection ()    
  (setq l_schr 200)
  (setq parallel_abstand_stz 30)
  (setq rand_abst 10)


  ; neu eingebaut - Sept 2011 
  (setq AnschlussAusfuehren 1)
  (setq qsform_Ht (Traeger.get HTrg qsform))
  (if (= qsform_Ht "R") (Untersuchung_AnschlMoegl))

  
  (if (= AnschlussAusfuehren 1) (progn
	(setq STD 0)
	; Berechnung der Rotation des Windverbandes
	;(if (= (Connect.get CastaData anschl_anderesende) 0)
	;	(setRWinkelVerband)
	;)
			
	(if (= qsform_at "F")
		(fProf)
	)
	
	(if (= qsform_at "R")
		(rProf)
	)

	(if (= qsform_at "K")
		(rProf)
	)

	(if (= qsform_at "L") (progn
		(lProf)
		(if (= K-Verband 1) (Blech.KnotenblechOptimieren   knotenBlech))
	))
	(if (= qsform_Ht "R") (Untersuchung_Knbl_Aussmitte))

  ))	
  
)
; --- ergnzt Sept. 2011 fr Anschlsse an Rohre als Haupttrger
(defun Untersuchung_AnschlMoegl ()
    (if (= (Connect.get CastaData amHtSteg) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_VWinkel))
	(setq EbenenWinkel (runde EbenenWinkel auf 0))

	(setq AnschlussAusfuehren 0)
	(if (= EbenenWinkel  90.0) (setq AnschlussAusfuehren 1))
	(if (= EbenenWinkel 180.0) (setq AnschlussAusfuehren 1))
    ))
    (if (= (Connect.get CastaData amHtFlansch) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_HWinkel))
	(setq EbenenWinkel (runde EbenenWinkel auf 0))

	(setq AnschlussAusfuehren 0)
	(if (= EbenenWinkel   0.0) (setq AnschlussAusfuehren 1))
	(if (= EbenenWinkel 180.0) (setq AnschlussAusfuehren 1))
    ))
    (if (= AnschlussAusfuehren 0) (AlertBox "Anschluss wird nicht erstellt!\nDer Winkel in der Windverbandsebene ist unpassend." "ERR_AngleInPlaneProblem"))
)
(defun Untersuchung_Knbl_Aussmitte ()
  (if (objExist knotenBlech) (progn
      (setq	h_HT	(Traeger.get HTrg h)
		r	(/ h_HT 2.0)
		a	(Blech.get knotenBlech delta_LR)
		dp	(Blech.get knotenBlech dp)
		a1	(- a (* 0.5 dp))
		a2	(+ a (* 0.5 dp))
      )
      (setq	x1	(- r (sqrt (- (* r r) (* a1 a1)))))
      (setq	x2	(- r (sqrt (- (* r r) (* a2 a2)))))
      
      (if (< x1 x2) (progn
          (if (>= x1 1.0) (WarnMeldung_Ausmitte x2))
      ))
      (if (< x2 x1) (progn
          (if (>= x2 1.0) (WarnMeldung_Ausmitte x1))
      ))
   ))
)
(defun WarnMeldung_Ausmitte (klaffende_Fuge)
  (alertBox "Achtung!!\n\nDurch die ausmittige Lage des Knotenblechs ist ein Spalt von 1mm der nahen Kante zu verzeichnen!\nBitte beachten Sie die klaffende Fuge - durch Schweinaht zu verschlieen." "NOTE_GapToClose")
  (alertBox klaffende_Fuge)
)


; ----------------------------------------------------------------------------------------
(defun rProf ()
	
	(if (= (Connect.get CastaData satr-lhtr) 0)
		(progn
			(Traeger.set Tr_ID (r_winkel 90.0))
			(alertBox "Die Orientierung des Anschlusstrgers wird durch das Programm angepasst. Bitte wiederholen Sie nun Ihre Eingabe." "NOTE_BracingBeamRotationCorrection")
		)
		(progn
			(if (= (Connect.get CastaData amHtFlansch) 1) (progn
				(init-windverband)
				; CALLBACKS
				(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
			
			))
			(if (= (Connect.get CastaData amHtSteg) 1) (progn
				(if (/= (Connect.get CastaData vatr-vhtr) 0)	
					(progn
						(init-windverband)
						; CALLBACKS
						(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
						(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
					)
					; else
					(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
				)
			))
			;  (if (=  K-Verband 1) (KnotenblechAnpassen))
			(KnotenblechAnpassen)
		)
	)
	
	
)

; ----------------------------------------------------------------------------------------
(defun lProf ()
	
	(setq CreateAnschluss 0)
	
	(if (= (Connect.get CastaData vatr-vhtr) 0)
		(if (= (Connect.get CastaData vatr-shtr) 0)
			(if (= (Connect.get CastaData satr-shtr) 0)
				(if (= (Connect.get CastaData satr-vhtr) 0)
					(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
					(setq CreateAnschluss 1)
				)
				(setq CreateAnschluss 1)
			)
			(setq CreateAnschluss 1)
		)
		(setq CreateAnschluss 1)
	)


	(if (= CreateAnschluss 1) (progn
		(init-windverband)
		(KnotenblechAnpassen)
		; CALLBACKS
		(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
	))
	

)


; ----------------------------------------------------------------------------------------
(defun fProf ()
	
	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
		(if (/= (Connect.get CastaData satr-shtr) 0) (progn
			(alertBox "Anschluss nicht mglich! Bitte rotieren Sie den Anschlusstrger um 90."  "ERR_Rotate_AT_90")
		  )
		  (progn
			(init-windverband)
			; CALLBACKS
			(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
			(KnotenblechAnpassen)
		))
	))
			
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
		(if (/= (Connect.get CastaData satr-vhtr) 0) (progn
			(alertBox "Anschluss nicht mglich! Bitte rotieren Sie den Anschlusstrger um 90." "ERR_Rotate_AT_90")
		  )
		  (progn
			(init-windverband)
			; CALLBACKS
			(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
			(KnotenblechAnpassen)
		))
	))
			
)





; ----------------------------------------------------------------------------------------
; Testweise Implementierung der Formel fr die Rotation der Windverbnde
; ----------------------------------------------------------------------------------------
(defun setRWinkelVerband ()
	(print "------------------------------------------------------------")
	(print "AUTOMATISCHE BERECHNUNG DES AT-ROTATIONSWINKEL")
	
	; abhngige Gren
	(setq vwinkel_ht 	(Connect.get CastaData hpttrg_vwinkel))		(print vwinkel_ht) 
	(setq vwinkel_at 	(Connect.get CastaData trg_vwinkel))		(print vwinkel_at) 
	(setq afl_winkel 	(Connect.get CastaData afl_hwinkel))		(print afl_winkel)
	(setq at_lwinkel	(Connect.get CastaData at_laengswinkel)) 	(print at_lwinkel)
	
	(setq r_winkel_at	(Traeger.get Tr_ID r_winkel))							(print r_winkel_at)
	
	;(if (>= afl_winkel 90.0)
	;	(setq afl_winkel (- afl_winkel 90.0))
	;) 
	(print afl_winkel)
	
	; Winkel in Bogenmae umrechnen
	(setq cos_v_ht (cos (/ (* PI vwinkel_ht) 180.0)))
	(setq cos_v_at (cos (/ (* PI vwinkel_at) 180.0)))
	(setq cos_afl (cos (/ (* PI afl_winkel) 180.0)))
	(setq sin_v_ht (sin (/ (* PI vwinkel_ht) 180.0)))
	(setq sin_v_at (sin (/ (* PI vwinkel_at) 180.0)))
	
	(print cos_v_ht)
	(print cos_v_at)
	(print cos_afl)
	(print sin_v_ht)
	(print sin_v_at)
	
	(setq w_arg (+ (* cos_v_ht cos_v_at) (* sin_v_ht sin_v_at cos_afl) ))
	(print w_arg)
	
	(setq rwinkel_at (acos w_arg))
	(print rwinkel_at)
	
	(setq rwinkel_at (/ (* rwinkel_at 180.0) PI))
	(print rwinkel_at)
	
	
	(setq rwinkel_at_ToSet 0)
	; Unterscheidung fr Profile
	(if (= qsform_at "L")	(berechneWinkel_L))
	(if (= qsform_at "R")	(berechneWinkel_R))
	
	
	(print rwinkel_at_ToSet)
	
	; Rotationswinkel setzen
	(Traeger.set Tr_ID (r_winkel rwinkel_at_ToSet))
)

; ----------------------------------------------------------------------------------------
; berechnet den zu setzenden Winkel fr Winkelprofile
; ----------------------------------------------------------------------------------------
(defun berechneWinkel_L ()
	(print "L-----------------------------------------------------------")
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= vwinkel_ht 0.0)
				(progn
					(rwinkel_at_ToSet r_winkel_at)
				)
				(progn
					(if (< vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr)  1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
							(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
						)
					)
				)
			)
		)
	)
		
)

; ----------------------------------------------------------------------------------------
; berechnet den zu setzenden Winkel fr Rundstahlprofile
; ----------------------------------------------------------------------------------------
(defun berechneWinkel_R ()
	(print "R-----------------------------------------------------------")
	; Wenn der Anschluss am Flansch stattfindet ...
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= vwinkel_ht 0.0) 
				(progn
					(setq rwinkel_at_ToSet 90.0)
				)
				(progn
					(if (>= vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData amHtUnterFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtOberFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData amHtUnterFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtOberFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
					)
				)
			)
		)
	)
	
	; Wenn der Anschluss am Steg stattfindet ...
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; Wenn der HT NICHT geneigt ist ...
			(if (= vwinkel_ht 0.0) 
				(progn
					(setq rwinkel_at_ToSet 0.0)
				)
				; Wenn der HT geneigt ist ...
				(progn
					(if (>= vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData amHtStegLinks) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtStegRechts) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData amHtStegLinks) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtStegRechts) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
					)
				)
			)
		)
	)
	
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Knotenblech am HT
; ----------------------------------------------------------------------------------------
(defun cb_knotenBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)

	(setq KeinKVerband 0)
	(if (objExist knotenBlech)
	       (setq KeinKVerband 1)
	       (sucheKnotenBlech 0)
	)


	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get knotenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get knotenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 		(Lochbild.get knblLochbild Klemml)
								altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					; Flachstahl
					; --------------------------------------
					(if (= qsform_at "F")
						(progn
							(print "Flachstahl-Profil")
							; braucht nicht mehr gesetzt zu werden, weil das in  updateschrblng schon erfolgt.
							; (Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff)))

							(if (objExist knotenBlech) (progn
							    (print "Knotenblech existiert")
							    (setq AbTeilKBlch (Traeger.get HTrg abTeil knotenBlech))
							    (Traeger.updateschrblng HTrg AbTeilKBlch dpDiff)
							))
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
								)
							)
						)
					)
					
					; Winkelprofil
					; --------------------------------------
					(if (= qsform_at "L")
						(progn
							(print "Winkel-Profil")
							(if (objExist knotenBlech) (progn
							    (print "Knotenblech existiert")
							    (setq AbTeilKBlch (Traeger.get HTrg abTeil knotenBlech))
							    (Traeger.updateschrblng HTrg AbTeilKBlch dpDiff)
							))

							; (Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
							;				(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							; )
							
							(Connect.showAttributes CastaData)
							
							; HT STEG
							; ----------------------------------
							(if (= (Connect.get CastaData amHtSteg) 1)
								(progn
									(if (= (Connect.get CastaData vatr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
			
							
							; HT FLANSCH
							; ----------------------------------
							(if (= (Connect.get CastaData amHtFlansch) 1)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
							
						)
					)
							
					; Rundstahl
					; --------------------------------------
					(if (= qsform_at "R")
						(progn
						   (print "Rundstahl-Profil")
						   (if (objExist knotenBlech) (progn
						     (setq AbTeilKBlch (Traeger.get HTrg abTeil knotenBlech))
						     (Traeger.updateschrblng HTrg AbTeilKBlch dpDiff)
						     ; (Traeger.updateschrblng Tr_ID knotenBlech dpDiff)
						     (if (= 1 2) (progn
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
											;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
						      ))
						      (if (= KeinKVerband 1) (progn
						          (if (= (Connect.get CastaData satr-lhtr)  1) (progn
								(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
						          ))
						          (if (= (Connect.get CastaData satr-lhtr) -1) (progn
								(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
								; (Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
						          ))
						      )) ; Kein K-Verband
						    )) ; if Bknotenblech vorhanden
						)
					)
					
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr die Augenlasche bei Rundprofilen
; ----------------------------------------------------------------------------------------
(defun cb_augenBlech (zp)
	(print "in Callback-Funktion cb_augenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get augenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	  (if (= 2 2) (progn

	    (setq KnBlechVorhanden  0)
	    (if (objExist knotenBlech)
	       (setq KnBlechVorhanden 1)
	       (sucheKnotenBlech 0)
	    )

	  ))  
	    (setq dpNeu (Blech.get augenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    (if (/= dpAlt dpNeu) (progn
	        (if (= 1 1) (progn
			(setq	dpDiff (- dpNeu dpAlt))
			(setq	alteKlemml 	(Lochbild.get knblLochbild Klemml)
				altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
			)
			(print altesDxSKopf)
					
			(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
				
			(setq qsform_at (Traeger.get Tr_ID qsform))
					
					
			(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
							(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
			)
			(if (= KnBlechVorhanden 1) (progn
			    (if (= (Connect.get CastaData satr-lhtr)  1)  (progn
					(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
			    ))
			    (if (= (Connect.get CastaData satr-lhtr) -1)   (progn
					(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
			    ))
			))
		))
	    ))
	))
)

(defun CalcXPosTrgAchse ()
	(setq xPos_HT_TrgAchse xPos_HT_Org)

	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
	  (setq Kont_Winkel (Connect.get CastaData h-atrgewnkl_kopf))
	  (setq tanW (tan (/ (* PI Kont_Winkel) 180.0)))
	  (setq dv_HT (Traeger.get HTrg delta_V) dv_HT (* 1.0 dv_HT))
	  (setq diff_XP (* tanW dv_HT))
	  (setq xPos_HT_TrgAchse (+ xPos_HT_Org diff_XP))
	))

)



(defun sucheKnotenBlech (WinkelSetzen)

  (setq xPos_HT_Org (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp _knotenblech_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp _knotenblech_uf_))
  (if (= (connect.get CastaData amHtStegLinks)    1)  (setq gesKnoBlTyp _knotenblech_steg_li_))
  (if (= (connect.get CastaData amHtStegRechts)   1)  (setq gesKnoBlTyp _knotenblech_steg_re_))

  (CalcXPosTrgAchse)
  (setq xPos_HT xPos_HT_TrgAchse)
 
  (setq abtl_KnoBl (Traeger.get Htrg firstAbtl knotenblech (- xPos_HT 1.5) (+ xPos_HT 1.5)))
  (while abtl_KnoBl
  	(setq sType     (Anbauteil.get abtl_KnoBl is_type gesKnoBlTyp))
  	(if (= sType 1) (progn
	    (print "Knotenblech gefunden -----------------------------------------------------")
	    (print sType)

	    (showAbtlDaten abtl_KnoBl)	;; nur zu Entwicklungszwecken

	    (setq afl_wnkl (Connect.get CastaData at_laengswinkel))
	    (if (= WinkelSetzen 1) (Anbauteil.set abtl_KnoBl (winkel afl_wnkl)))

	    (setq knotenBlech (Anbauteil.get abtl_KnoBl Objekt Blech))
	    (setq xPosVorh (Anbauteil.get abtl_KnoBl xPos))
	    (setq K-Verband 1)
	))
  	(setq abtl_KnoBl (Traeger.get Htrg nextAbtl knotenblech))
  )
  (setq abtl_KnoBl_T (Traeger.get Htrg firstAbtl knotenblech (- xPos_HT 0.1) (+ xPos_HT 0.1)))
  (if (objExist knotenBlech) (progn
	  (if (objExist abtl_KnoBl_T)
	      (print  "OK - Objekt gefunden und passt");
	      (alertBox "Das Blech wurde mit einer greren Toleranz eingesetzt!\nBitte die Schraubenlngen nach nderung der Blechdicke berprfen!"  "NOTE_PlateThickness_BoltLength");
	  )
	  (if (objExist abtl_KnoBl_T) (setq xPos_HT_TrgAchse xPosVorh))
  ))

)
(defun KnotenblechAnpassen_no ()
    (setq abtl_KnoBl (Traeger.get HTrg ABTeil knotenBlech))

    (if (= K-Verband 1) (progn

      (setq abtl_KnoBlLchb (Traeger.get HTrg ABTeil knblLochbild))
      (setq xPos_KB (Anbauteil.get abtl_KnoBl      xPos)
			xPos_LB (Anbauteil.get abtl_KnoBlLchb  xPos)
      )

      (if (/= xPos_LB xPosVorh) (progn
        (Anbauteil.set abtl_KnoBl      (xPos xPosVorh))
		(Anbauteil.set abtl_KnoBlLchb  (xPos xPosVorh)) 
      ))
    ))
	;; Danach war eh Ausstieg, da Funktion nicht gefunden wurde
)
(defun KnotenblechAnpassen ()

;    (setq CopyMode (Connect.get  CastaData CopyMode))

	(if (=  (Connect.get  CastaData CopyMode) 0) (progn
	
		(setq abtl_KnoBl (Traeger.get HTrg ABTeil knotenBlech))

		(if (= K-Verband 1) (progn

		  (setq abtl_KnoBlLchb (Traeger.get HTrg ABTeil knblLochbild))
		  (setq xPos_KB (Anbauteil.get abtl_KnoBl      xPos)
		  xPos_LB (Anbauteil.get abtl_KnoBlLchb  xPos)
		  )

		  (if (/= xPos_LB xPosVorh) (progn
			(Anbauteil.set abtl_KnoBl      (xPos xPosVorh))
			(Anbauteil.set abtl_KnoBlLchb  (xPos xPosVorh)) 
		  ))
		))

	;   (print "Boltfit wird aufgerufen")
		(Anbauteil.BoltFit abtl_KnoBl)			; 2018 - Juli, wurde vom Interpreter nicht aufgerufen

	;;  Mrz 2010 - Windverbandsstab im Bereich der Flansche.
		(setq blch_dlr (Blech.get Knotenblech delta_lr))
		(if (< blch_dlr 0) (setq blch_dlr (- blch_dlr)))	; sozusagen absolut setzen
	  
		(setq h_HT	(Traeger.get HTrg h)
			  t_HT	(Traeger.get HTrg t)
			  b_HT	(Traeger.get HTrg b)
		)
	  
		(if (> blch_dlr (- (* 0.5 h_Ht) t_Ht)) (progn
			(setq qsform_HT (Traeger.get HTrg qsForm))
			(setq b_Blech (Blech.get knotenBlech bp))
	;        (if (= qsform_HT "U") (setq a 100))
			(if (= qsform_HT "I") (Blech.set knotenBlech (bp (- b_Blech (* 0.5 b_HT)))))
		))
	))

)


(defun showAbtlDaten (abtlObjekt)
	(print "Beginn Anbauteildaten -------------------------------------------")
  	(setq xPos_abtl		(Anbauteil.get abtlObjekt xPos))
  	(setq winkel_abtl	(Anbauteil.get abtlObjekt winkel))
  	(setq neigwnkl_d_abtl	(Anbauteil.get abtlObjekt neigwnkl_d))
  	(setq neigwnkl_q_abtl	(Anbauteil.get abtlObjekt neigwnkl_q))
  	(setq kplrwnkl_abtl	(Anbauteil.get abtlObjekt kplrwnkl))
  	
  	(setq delta_v_abtl	(Anbauteil.get abtlObjekt delta_v))
  	(setq delta_lrs_abtl	(Anbauteil.get abtlObjekt delta_lr))
  	(setq delta_sx_abtl	(Anbauteil.get abtlObjekt delta_sx))
  	(setq seitricht_abtl	(Anbauteil.get abtlObjekt seitricht))
  	(print xPos_abtl)
  	(print winkel_abtl)
  	(print neigwnkl_d_abtl)
  	(print neigwnkl_q_abtl)
  	(print kplrwnkl_abtl)
  	
  	(print delta_v_abtl)
  	(print delta_lrs_abtl)
  	(print delta_sx_abtl)
  	(print seitricht_abtl)
	(print "Ende Anbauteildaten -------------------------------------------")
)