; $ G(20)	HT	QT(IUKR)	AF(FS)		P(EZ)
; $ G(20)	AT	QT(L)		AF(FS)		P(E)
; $ G(20)	AE	V(-)		H(-)		R(-)
; $		HT	QT(IUKR)	AF(FS)		P(EZ)
; $		AT	QT(LFRS)	AF(K)		P(E)
; $		AE	V(-)		H(-)		R(-)

(defun load-modules ()
  ; Profil prfen
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
  
  (if (= (Connect.get CastaData Anschlusstyp) 20) (progn
	  (if (= qsform_at "L")	(load "mod-calc-windverband_krz_L"))
	)
	(progn
	  (if (= qsform_at "L")	(load "mod-calc-windverband_L_GTC"))
	  ; (if (= qsform_at "L")	(load "mod-calc-windverband_L"))
	  (if (= qsform_at "F")	(load "mod-calc-windverband_F"))
	  (if (= qsform_at "U") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
	  (if (= qsform_at "I") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
	  (if (= qsform_at "R") (load "mod-calc-windverband_R"))
	  (if (= qsform_at "K") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
	)
  )  
  (load "mod-lochbild")
)

(defun init-connection ()
  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - uz_Windverb_1");
   
  ;(connect.ShowAttributes CastaData)

  (setq K-Verband 0)
  (sucheKnotenBlech 1)

  (Continue_Connection)
  
  (if (=  K-Verband 1) (KnotenblechAnpassen))

)
(defun Continue_Connection ()
  (print "Continue_Connection")    
  (setq l_schr 200)
  (setq parallel_abstand_stz 30)
  (setq rand_abst 10)
	
  ; neu eingebaut - Sept 2011 
  (setq AnschlussAusfuehren 1)
  (setq qsform_Ht (Traeger.get HTrg qsform))
  (if (= qsform_Ht "R") (Untersuchung_AnschlMoegl))
  (if (= qsform_At "L") (Untersuchung_AnschlMoegl_L))
  
  (print qsform_Ht) (print qsform_At)
  
  (setq STD 0)
  (if (= AnschlussAusfuehren 1) (progn

	; Berechnung der Rotation des Windverbandes
	;(if (= (Connect.get CastaData anschl_anderesende) 0)
	;	(setRWinkelVerband)
	;)
			
	(if (= qsform_at "F")
		(fProf)
	)
	
	(if (= qsform_at "R")
		(rProf)
	)
	
	(if (= qsform_at "L")
		(lProf)
	)
	(if (= qsform_Ht "R") (Untersuchung_Knbl_Aussmitte))

	(print "Abschnitt 2, STD = 0")
	
	(if (= 1 2) (progn
	  	(setq AbtlKnoBlLchbAT    (Traeger.get Tr_ID AbTeil knblLochbild))
	  	(setq AbtlKnoBlLchbHT    (Traeger.get HTrg  AbTeil knblLochbild))
	  	
	  	(Anbauteil.set AbtlKnoBlLchbAT (Master 0))
	  	(Anbauteil.set AbtlKnoBlLchbHT (Master 1))
	 	
	  	(Lochbild.set knblLochbild (delta_w    20))
	 	(Lochbild.set knblLochbild (w0         10))
	 	(Lochbild.set knblLochbild (e1         100) (e2 20))
	  	; (Lochbild.set knblLochbild (lb_art 0))
	
		(print "Check-Seitenrichtungen")  	
	  	(setq SeitRichtung_AT (Anbauteil.get AbtlKnoBlLchbAT SeitRicht))
	  	(print SeitRichtung_AT)
	  	(setq SeitRichtung_HT (Anbauteil.get AbtlKnoBlLchbHT SeitRicht))
	  	(print SeitRichtung_HT)
	  	
	 ; 	(Anbauteil.set AbtlKnoBlLchbHT (SeitRicht  -1))
	
		(setq LB_Art (Lochbild.get knblLochbild LB_Art))
		(print LB_Art)
	))	  


   ))	
)
; --- ergnzt Sept. 2011 fr Anschlsse an Rohre als Haupttrger
(defun Untersuchung_AnschlMoegl ()
    (if (= (Connect.get CastaData amHtSteg) 1) (progn
		(setq EbenenWinkel (Connect.get CastaData afl_VWinkel))
		(if (> EbenenWinkel -1.0) (if (< EbenenWinkel 1.0) (setq EbenenWinkel 0.0)))
		(setq EbenenWinkel (runde EbenenWinkel auf 0))

		(setq AnschlussAusfuehren 0)
		(if (= EbenenWinkel 180.0) (setq AnschlussAusfuehren 1))
		(if (= EbenenWinkel  90.0) (setq AnschlussAusfuehren 1))
		(if (= EbenenWinkel   0.0) (setq AnschlussAusfuehren 1))
    ))
    (if (= (Connect.get CastaData amHtFlansch) 1) (progn
		(setq EbenenWinkel (Connect.get CastaData afl_HWinkel))
		(setq EbenenWinkel (runde EbenenWinkel auf 0))

		(setq AnschlussAusfuehren 0)
		(if (= EbenenWinkel 180.0) (setq AnschlussAusfuehren 1))
		(if (= EbenenWinkel  90.0) (setq AnschlussAusfuehren 1))
		(if (= EbenenWinkel   0.0) (setq AnschlussAusfuehren 1))
    ))
    (if (= AnschlussAusfuehren 0) (AlertBox "Anschluss wird nicht erstellt!\nDer Winkel in der Windverbandsebene ist unpassend." "ERR_AngleInPlaneProblem"))
)

(defun Untersuchung_AnschlMoegl_L ()
    (setq AnschlussAusfuehren 0)
    (if (= (Connect.get CastaData amHtFlansch) 1) (setq AnschlussAusfuehren 1))
    (if (= (Connect.get CastaData amHtSteg) 1)    (setq AnschlussAusfuehren 1))

    (if (= AnschlussAusfuehren 0) (AlertBox "Anschluss wird nicht erstellt!\nDer Winkel luft am Haupttrger vorbei."  "ERR_BeamPassingBy"))
)    

(defun Untersuchung_Knbl_Aussmitte ()
  (if (objExist knotenBlech) (progn
     (setq	h_HT	(Traeger.get HTrg h)
		r	(/ h_HT 2.0)
		a	(Blech.get knotenBlech delta_LR)
		dp	(Blech.get knotenBlech dp)
		a1	(- a (* 0.5 dp))
		a2	(+ a (* 0.5 dp))
      )
      (setq	x1	(- r (sqrt (- (* r r) (* a1 a1)))))
      (setq	x2	(- r (sqrt (- (* r r) (* a2 a2)))))
      
      (if (< x1 x2) (progn
          (if (>= x1 1.0) (WarnMeldung_Ausmitte x2))
      ))
      (if (< x2 x1) (progn
          (if (>= x2 1.0) (WarnMeldung_Ausmitte x1))
      ))
  ))
)
(defun WarnMeldung_Ausmitte (klaffende_Fuge)
  (alertBox "Achtung!!\n\nDurch die ausmittige Lage des Knotenblechs ist ein Spalt von 1mm der nahen Kante zu verzeichnen!\nBitte beachten Sie die klaffende Fuge - durch Schweinaht zu verschlieen." "NOTE_GapToClose")
  (alertBox klaffende_Fuge)
)


; ----------------------------------------------------------------------------------------
(defun rProf ()
	
	(if (= (Connect.get CastaData satr-lhtr) 0)
		(progn
			(Traeger.set Tr_ID (r_winkel 90.0))
			(alertBox "Die Orientierung des Anschlusstrgers wird durch das Programm angepasst. Bitte wiederholen Sie nun Ihre Eingabe." "NOTE_BracingBeamRotationCorrection")
		)
		(progn
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					
								(init-windverband)
								; CALLBACKS
								(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
								(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
							
						
				)
			)
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (/= (Connect.get CastaData vatr-vhtr) 0)
						
							(progn
								(init-windverband)
								; CALLBACKS
								(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
								(Blech.set augenBlech 	(formFkt "cb_augenBlech"))
							)
							(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
						
					)
				)
			)
		)
	)
	
	
)

; ----------------------------------------------------------------------------------------
(defun lProf ()
	
	(if (= (Connect.get CastaData vatr-vhtr) 0)
		(if (= (Connect.get CastaData vatr-shtr) 0)
			(if (= (Connect.get CastaData satr-shtr) 0)
				(if (= (Connect.get CastaData satr-vhtr) 0)
					(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
					(progn
						(init-windverband)
						; CALLBACKS
						(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
					)
				)
				(progn
					(init-windverband)
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				)
			)
			(progn
				(init-windverband)
				; CALLBACKS
				(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
			)
		)
		(progn
			(init-windverband)
			; CALLBACKS
			(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
		)
	)
			
)


; ----------------------------------------------------------------------------------------
(defun fProf ()
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (/= (Connect.get CastaData satr-shtr) 0)
				(progn
					(alertBox "Anschluss nicht mglich! Bitte rotieren Sie den Anschlusstrger um 90."  "ERR_Rotate_AT_90")
				)
				(progn
					(init-windverband)
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				)
			)
		)
	)
			
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (/= (Connect.get CastaData satr-vhtr) 0)
				(progn
					(alertBox "Anschluss nicht mglich! Bitte rotieren Sie den Anschlusstrger um 90."  "ERR_Rotate_AT_90")
				)
				(progn
					(init-windverband)
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
				)
			)
		)
	)
			
)





; ----------------------------------------------------------------------------------------
; Testweise Implementierung der Formel fr die Rotation der Windverbnde
; ----------------------------------------------------------------------------------------
(defun setRWinkelVerband ()
	(print "------------------------------------------------------------")
	(print "AUTOMATISCHE BERECHNUNG DES AT-ROTATIONSWINKEL")
	
	; abhngige Gren
	(setq vwinkel_ht 	(Connect.get CastaData hpttrg_vwinkel))		(print vwinkel_ht) 
	(setq vwinkel_at 	(Connect.get CastaData trg_vwinkel))		(print vwinkel_at) 
	(setq afl_winkel 	(Connect.get CastaData afl_hwinkel))		(print afl_winkel)
	(setq at_lwinkel	(Connect.get CastaData at_laengswinkel)) 	(print at_lwinkel)
	
	(setq r_winkel_at	(Traeger.get Tr_ID r_winkel))							(print r_winkel_at)
	
	;(if (>= afl_winkel 90.0)
	;	(setq afl_winkel (- afl_winkel 90.0))
	;) 
	(print afl_winkel)
	
	; Winkel in Bogenmae umrechnen
	(setq cos_v_ht (cos (/ (* PI vwinkel_ht) 180.0)))
	(setq cos_v_at (cos (/ (* PI vwinkel_at) 180.0)))
	(setq cos_afl (cos (/ (* PI afl_winkel) 180.0)))
	(setq sin_v_ht (sin (/ (* PI vwinkel_ht) 180.0)))
	(setq sin_v_at (sin (/ (* PI vwinkel_at) 180.0)))
	
	(print cos_v_ht)
	(print cos_v_at)
	(print cos_afl)
	(print sin_v_ht)
	(print sin_v_at)
	
	(setq w_arg (+ (* cos_v_ht cos_v_at) (* sin_v_ht sin_v_at cos_afl) ))
	(print w_arg)
	
	(setq rwinkel_at (acos w_arg))
	(print rwinkel_at)
	
	(setq rwinkel_at (/ (* rwinkel_at 180.0) PI))
	(print rwinkel_at)
	
	
	(setq rwinkel_at_ToSet 0)
	; Unterscheidung fr Profile
	(if (= qsform_at "L")	(berechneWinkel_L))
	(if (= qsform_at "R")	(berechneWinkel_R))
	
	
	(print rwinkel_at_ToSet)
	
	; Rotationswinkel setzen
	(Traeger.set Tr_ID (r_winkel rwinkel_at_ToSet))
)

; ----------------------------------------------------------------------------------------
; berechnet den zu setzenden Winkel fr Winkelprofile
; ----------------------------------------------------------------------------------------
(defun berechneWinkel_L ()
	(print "L-----------------------------------------------------------")
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= vwinkel_ht 0.0)
				(progn
					(rwinkel_at_ToSet r_winkel_at)
				)
				(progn
					(if (< vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr)  1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
							(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
						)
					)
				)
			)
		)
	)
		
)

; ----------------------------------------------------------------------------------------
; berechnet den zu setzenden Winkel fr Rundstahlprofile
; ----------------------------------------------------------------------------------------
(defun berechneWinkel_R ()
	(print "R-----------------------------------------------------------")
	; Wenn der Anschluss am Flansch stattfindet ...
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= vwinkel_ht 0.0) 
				(progn
					(setq rwinkel_at_ToSet 90.0)
				)
				(progn
					(if (>= vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData amHtUnterFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtOberFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData amHtUnterFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtOberFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
					)
				)
			)
		)
	)
	
	; Wenn der Anschluss am Steg stattfindet ...
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; Wenn der HT NICHT geneigt ist ...
			(if (= vwinkel_ht 0.0) 
				(progn
					(setq rwinkel_at_ToSet 0.0)
				)
				; Wenn der HT geneigt ist ...
				(progn
					(if (>= vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData amHtStegLinks) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtStegRechts) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData amHtStegLinks) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtStegRechts) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
					)
				)
			)
		)
	)
	
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Knotenblech am HT
; ----------------------------------------------------------------------------------------
(defun cb_knotenBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)

	(setq KeinKVerband 0)
	(if (objExist knotenBlech)
	       (setq KeinKVerband 1)
	       (sucheKnotenBlech 0)
	)

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get knotenBlech dp))
	    (setq hpAlt (Blech.get knotenBlech hp))
	    (setq dOK_Alt (Blech.get knotenBlech dOK))
		 (setq abtl_Blech	(Traeger.get HTrg AbTeil  knotenBlech))

		 (setq dlv_Blech_Alt (Anbauteil.get  abtl_Blech delta_V))
		 ; (AlertBox dOK_Alt)
	    ; (print altesDxSKopf)
	    (Connect.Showattributes CastaData)
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get knotenBlech dp))
	    (setq hpNeu (Blech.get knotenBlech hp))
	    (setq dOK_Neu (Blech.get knotenBlech dOK))
		
		; (AlertBox hpNeu)

	    (print dpAlt) (print dpNeu)

	    (if (/= hpAlt hpNeu) (progn
		))

	    
	    (if (/= dpAlt dpNeu) (progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 		(Lochbild.get knblLochbild Klemml)
								altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					
					; Flachstahl
					; --------------------------------------
					(if (= qsform_at "F")
						(progn
							(print "Flachstahl-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff)))
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
								)
							)
						)
					)
					
					; Winkelprofil
					; --------------------------------------
					(if (= qsform_at "L")
						(progn
							(print "Winkel-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
																					;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
							
							(Connect.showAttributes CastaData)
							
							; HT STEG
							; ----------------------------------
							(if (= (Connect.get CastaData amHtSteg) 1)
								(progn
									(if (= (Connect.get CastaData vatr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
			
							
							; HT FLANSCH
							; ----------------------------------
							(if (= (Connect.get CastaData amHtFlansch) 1)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
							
						)
					)
							
					; Rundstahl
					; --------------------------------------
					(if (= qsform_at "R")
						(progn
						   (print "Rundstahl-Profil")
						   (if (objExist knotenBlech) (progn
						     (setq AbTeilKBlch (Traeger.get HTrg abTeil knotenBlech))
						     (Traeger.updateschrblng HTrg AbTeilKBlch dpDiff)
						     ; (Traeger.updateschrblng Tr_ID knotenBlech dpDiff)
						     (if (= 1 2) (progn
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
											;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
						      ))
						      (if (= KeinKVerband 1) (progn
						          (calc_Rundr_delta_LR dpDiff)
						          (calc_Rundr_DxsKopf dpDiff)
						      )) ; Kein K-Verband
						    )) ; if Bknotenblech vorhanden
						)
					)
					
	    ))
	))
)


; ----------------------------------------------------------------------------------------
; Callback fr die Augenlasche bei Rundprofilen
; ----------------------------------------------------------------------------------------
(defun cb_augenBlech (zp)
	(print "in Callback-Funktion cb_augenBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get augenBlech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	  (if (= 2 2) (progn

	    (setq KnBlechVorhanden  0)
	    (if (objExist knotenBlech)
	       (setq KnBlechVorhanden 1)
	       (sucheKnotenBlech 0)
	    )

	  ))  
	    (setq dpNeu (Blech.get augenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    (if (/= dpAlt dpNeu) (progn
	        (if (= 1 1) (progn
			(setq	dpDiff (- dpNeu dpAlt))
			(setq	alteKlemml 	(Lochbild.get knblLochbild Klemml)
				altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
			)
			(print altesDxSKopf)
					
			(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
				
			(setq qsform_at (Traeger.get Tr_ID qsform))
					
					
			(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
							(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
			)
			(if (= KnBlechVorhanden 1) (progn
			    (calc_Rundr_delta_LR dpDiff)
			))
		))
	    ))
	))
)



(defun sucheKnotenBlech (WinkelSetzen)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp _knotenblech_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp _knotenblech_uf_))
  (if (= (connect.get CastaData amHtStegLinks)    1)  (setq gesKnoBlTyp _knotenblech_steg_li_))
  (if (= (connect.get CastaData amHtStegRechts)   1)  (setq gesKnoBlTyp _knotenblech_steg_re_))

  (if (= 1 2) (progn
    (setq abtl_KnoBl (Traeger.get Htrg firstAbtl knotenblech (- xPos_HT 0.1) (+ xPos_HT 0.1)))
    (while abtl_KnoBl
  	(setq sType     (Anbauteil.get abtl_KnoBl is_type gesKnoBlTyp))
	(print "Knotenblech gefunden -----------------------------------------------------")
  	(print sType)

	(showAbtlDaten abtl_KnoBl)	;; nur zu Entwicklungszwecken

	(setq afl_wnkl (Connect.get CastaData at_laengswinkel))
	(if (= WinkelSetzen 1) (Anbauteil.set abtl_KnoBl (winkel afl_wnkl)))

	(setq knotenBlech (Anbauteil.get abtl_KnoBl Objekt Blech))
        (setq K-Verband 1)

  	(setq abtl_KnoBl (Traeger.get Htrg nextAbtl knotenblech))
    )
  ))
  (setq K-Verband 0)


)
(defun KnotenblechAnpassen ()
    (setq abtl_KnoBl (Traeger.get HTrg ABTeil knotenBlech))
    (Anbauteil.BoltFit abtl_KnoBl)
)


(defun showAbtlDaten (abtlObjekt)
	(print "Beginn Anbauteildaten -------------------------------------------")
  	(setq xPos_abtl		(Anbauteil.get abtlObjekt xPos))
  	(setq winkel_abtl	(Anbauteil.get abtlObjekt winkel))
  	(setq neigwnkl_d_abtl	(Anbauteil.get abtlObjekt neigwnkl_d))
  	(setq neigwnkl_q_abtl	(Anbauteil.get abtlObjekt neigwnkl_q))
  	(setq kplrwnkl_abtl	(Anbauteil.get abtlObjekt kplrwnkl))
  	
  	(setq delta_v_abtl	(Anbauteil.get abtlObjekt delta_v))
  	(setq delta_lrs_abtl	(Anbauteil.get abtlObjekt delta_lr))
  	(setq delta_sx_abtl	(Anbauteil.get abtlObjekt delta_sx))
  	(setq seitricht_abtl	(Anbauteil.get abtlObjekt seitricht))
  	(print xPos_abtl)
  	(print winkel_abtl)
  	(print neigwnkl_d_abtl)
  	(print neigwnkl_q_abtl)
  	(print kplrwnkl_abtl)
  	
  	(print delta_v_abtl)
  	(print delta_lrs_abtl)
  	(print delta_sx_abtl)
  	(print seitricht_abtl)
	(print "Ende Anbauteildaten -------------------------------------------")
)
(defun calc_Rundr_DxsKopf (dpDiff)
    (if (= (Connect.get CastaData amHtFlansch)  1) (progn
	(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
	(if (= (Connect.get CastaData amHtOberFlansch)  1) (progn
	      (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-shtr) 1) (progn
		    	(Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
		))
	      ))
	      (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-shtr) -1) (progn
		    	(Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
		))
	      ))
	))
	(if (= (Connect.get CastaData amHtUnterFlansch)  1) (progn
	      (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-shtr)-1) (progn
		    	(Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
		))
	      ))
	      (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-shtr) 1) (progn
		    	(Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
		))
	      ))
	))
    ))
    (if (= (Connect.get CastaData amHtSteg)  1) (progn
      (if (= (Connect.get CastaData linkesEnde) 1) (progn
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
		(if (= (Connect.get CastaData amHtStegRechts)  1)
	    	   (Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
	    	)
	))
	(if (= (Connect.get CastaData vatr-vhtr)  1) (progn
		(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
		(if (= (Connect.get CastaData amHtStegLinks)  1)
	    	   (Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
	    	)
	))
      ))
      (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
		(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
		(if (= (Connect.get CastaData amHtStegRechts)  1)
	    	    (Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
	    	)
	))
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
		(if (= (Connect.get CastaData amHtStegLinks)  1)
	    	    (Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
	    	)
	))
      ))
    ))
)

(defun calc_Rundr_delta_LR (dpDiff)

    (if (= (Connect.get CastaData amHtFlansch)  1) (progn
        (if (= (Connect.get CastaData satr-lhtr)  1) (progn
		(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
	))
	(if (= (Connect.get CastaData satr-lhtr) -1) (progn
		(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
	))
    ))
    (if (= (Connect.get CastaData amHtSteg)  1) (progn
	(if (= (Connect.get CastaData amHtStegLinks)  1) (progn
            (if (= (Connect.get CastaData linkesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
            ))
            (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
	    ))
	))
	(if (= (Connect.get CastaData amHtStegRechts)  1) (progn
            (if (= (Connect.get CastaData linkesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
            ))
            (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
	    ))
	))

    ))
)
