(defun init-connection ()

  (print "in init-connection - uz_Windverb_1");
 
;  (Traeger.set Tr_ID (delta_V 200))
 
  
;  (connect.ShowAttributes CastaData)
 
  ; Tr_ID ist der Verbandsstab
  ; HTrg  ist die Sttze, an die angeschlossen wird
  
  (createKnotenBlech)

  ; Entweder Anschlussauswahl fr Profiltypen auch noch erstellen
  ; oder hier eine Fallunterscheidung machen, falls es sich nicht um ein
  ; Winkelprofil handelt
  (kuerzeWinkelProfil)

)
; ====================================================================== 
(defun kuerzeWinkelProfil_Alt ()

  ; Winkelprofil krzen ...
  ; korrekten Wert noch aus Sttzenprofil und Winkel berechnen
  (setq kuerzLng     0
        h_Ht     (Traeger.get HTrg h)
        s_Ht     (Traeger.get HTrg s)
        deltaV   (Traeger.get HTrg delta_V)
        deltaLR  (Traeger.get HTrg delta_LR)
        b_Trg    (Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    (Traeger.get Tr_ID h)			; ob Breite oder Hhe entscheidend sind.
  )
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (setq kuerzLng (- (* 0.5 h_Ht) deltaV))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (setq kuerzLng (+ (* 0.5 h_Ht) deltaV))
  ))

  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (setq kuerzLng (- (* 0.5 s_Ht) deltaLR))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (setq kuerzLng (+ (* 0.5 s_Ht) deltaLR))
  ))

  (setq AFl_Winkel (connect.get CastaData AFl_VWinkel)
        AFl_Winkel (- AFl_Winkel 90.0) 
  )
  
  (setq sinAWnkl (sin (/ (* PI AFl_Winkel) 180.0))
  	cosAWnkl (cos (/ (* PI AFl_Winkel) 180.0))
  	tanAWnkl (tan (/ (* PI AFl_Winkel) 180.0))
  )
  (if (= cosAWnkl 0.0) (setq cosAWnkl 1.0))
  (setq deltaLNeu (+ (/ kuerzLng cosAWnkl) (* 0.5 b_Trg tanAWnkl)))
  
  (print kuerzLng)
  (print b_Trg)
  (print deltaLNeu)
  

  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq TrE_Links (Traeger.get Tr_ID links))
      (TrEnde.set TrE_Links (delta_L 0))
      (TrEnde.pTrim TrE_Links deltaLNeu)
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrE_Rechts (Traeger.get Tr_ID rechts))
      (TrEnde.set TrE_Rechts (delta_L 0))			; erst einmal zurcksetzen
      (TrEnde.pTrim TrE_Rechts deltaLNeu)			; dann krzen
  ))


  (setq RWinkel (Traeger.get Tr_ID R_Winkel)
        dp      (Blech.get   knotenBlech  dp)
  )
  (if (= RWinkel   0.0) (Traeger.set Tr_ID (delta_V (*  0.5 h_Trg) (delta_LR (*  0.5    dp)))))
  (if (= RWinkel  90.0) (Traeger.set Tr_ID (delta_V (* -0.5    dp) (delta_LR (* -0.5 b_Trg)))))
  (if (= RWinkel 180.0) (Traeger.set Tr_ID (delta_V (*  0.5 h_Trg) (delta_LR (*  0.5    dp)))))
  (if (= RWinkel 270.0) (Traeger.set Tr_ID (delta_V (* -0.5    dp) (delta_LR (* -0.5 b_Trg)))))


)
; ====================================================================== 
(defun createKnotenBlech ()
  (setq knotenBlech (Blech.create))
  (Blech.set knotenBlech 
      (dp 10)
      (hp 200)
      (bp 120)
  )


  (setq xPosStz (connect.get CastaData xPos_HT))

  (setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  
  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech 0.0 0.0 _knotenblech_of_)  ;
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech 0.0 0.0 _knotenblech_uf_)  ;
      (if (= (connect.get CastaData RechtesEnde) 1) (progn
;      	(setq WnklAnschlFl (- 180.0 WnklAnschlFl))
      ))
  ))

  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (traeger.addabtl Htrg knotenBlech 0.0 0.0 _knotenblech_steg_li_)  ;
;     (setq WnklAnschlFl (- WnklAnschlFl 180.0))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (traeger.addabtl Htrg knotenBlech 0.0 0.0 _knotenblech_steg_re_)  ;
;      (setq WnklAnschlFl (- 180.0 WnklAnschlFl))
  ))

  (setq AbtlKnBlech (traeger.get Htrg ABTeil knotenBlech))
  (Anbauteil.set  AbtlKnBlech (xpos xPosStz))

  (print "... setze WnklAnschlFl ein ...")
  (print WnklAnschlFl)


	(setq b_Trg   (Traeger.get Tr_ID b)
				h_Trg	  (Traeger.get Tr_ID h)
				RWinkel (Traeger.get Tr_ID R_Winkel)
	)
	(print b_Trg)
	(print h_Trg)
	
	(if (= RWinkel   0.0) (setq d_schr (+ (* 0.5 b_Trg) 10)))
	(if (= RWinkel  90.0) (setq d_schr (+ (* 0.5 h_Trg) 10)))
	(if (= RWinkel 180.0) (setq d_schr (+ (* 0.5 b_Trg) 10)))
	(if (= RWinkel 270.0) (setq d_schr (+ (* 0.5 h_Trg) 10)))
	;(setq d_schr (+ (* 0.5 b_Trg) 10))
	(print d_schr)
  ; Objekt.Methode          Variable     d_Schr   l_Schrb  SchrAchsWnkl
  (Blech.knotenblechschraeg knotenBlech   d_schr      300       WnklAnschlFl)
 
 
)

; ====================================================================== 
(defun kuerzeWinkelProfil ()

  ; Winkelprofil krzen ...
  ; korrekten Wert noch aus Sttzenprofil und Winkel berechnen
  (setq kuerzLng     0
        h_Ht     (Traeger.get HTrg h)
        s_Ht     (Traeger.get HTrg s)
        deltaV   (Traeger.get HTrg delta_V)
        deltaLR  (Traeger.get HTrg delta_LR)
        b_Trg    (Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    (Traeger.get Tr_ID h)			; ob Breite oder Hhe entscheidend sind.
  )
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (setq kuerzLng (- (* 0.5 h_Ht) deltaV))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (setq kuerzLng (+ (* 0.5 h_Ht) deltaV))
  ))

  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (setq kuerzLng (- (* 0.5 s_Ht) deltaLR))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (setq kuerzLng (+ (* 0.5 s_Ht) deltaLR))
  ))

  (setq AFl_Winkel (connect.get CastaData AFl_VWinkel))
  (print AFl_Winkel)
  
  
  (setq sinAWnkl (sin (/ (* PI AFl_Winkel) 180.0))
	cosAWnkl (cos (/ (* PI AFl_Winkel) 180.0))
  	tanAWnkl (tan (/ (* PI AFl_Winkel) 180.0))
  )
  
  (setq abstand_Stz 30)

  (if (= (connect.get CastaData anhtlinkesende) 1) (progn
     (setq HTrLinks (Traeger.get HTrg links))
     (setq deltaL (TrEnde.get HTrLinks delta_L))
     (if (> deltaL kuerzLng) (setq kuerzLng deltaL))
  ))
  (if (= (connect.get CastaData anhtRechtesEnde) 1) (progn
     (setq HTrRechts (Traeger.get HTrg rechts))
     (setq deltaL (TrEnde.get HTrRechts delta_L))
     (if (> deltaL kuerzLng) (setq kuerzLng deltaL))
  ))

  (print "----------------------")
  (print kuerzLng)

  
  (if (= cosAWnkl 0.0) (setq cosAWnkl 1.0))
  ;(setq deltaLNeu (+ (/ kuerzLng cosAWnkl) (* 0.5 b_Trg tanAWnkl)))
  (setq anteil_Stz (/ kuerzLng cosAWnkl))
  (setq anteil_Verb (* 0.5 b_Trg tanAWnkl))

  (if (< cosAWnkl 0.0) 
  	(setq anteil_Stz  (- anteil_Stz)
  	      anteil_Verb (- anteil_Verb)
  	)
  )


  (print cosAWnkl)
  (print anteil_Stz)
  (print anteil_Verb)
  
  (if (< AFl_Winkel 0) 
  	(setq deltaLNeu (+ abstand_Stz anteil_Stz (- anteil_Verb)))
  	(setq deltaLNeu (+ abstand_Stz anteil_Stz anteil_Verb))
  )
  
  (print b_Trg)
  (print abstand_Stz)
  (print deltaLNeu)
  
  
  
	;Krzen
  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq TrE_Links (Traeger.get Tr_ID links))
      (TrEnde.set TrE_Links (delta_L 0))
      (TrEnde.pTrim TrE_Links deltaLNeu)
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrE_Rechts (Traeger.get Tr_ID rechts))
      (TrEnde.set TrE_Rechts (delta_L 0))			; erst einmal zurcksetzen
      (TrEnde.pTrim TrE_Rechts deltaLNeu)			; dann krzen
  ))


	;Positionieren
  (setq RWinkel (Traeger.get Tr_ID R_Winkel)
        dp      (Blech.get   knotenBlech  dp)
  )
  (print RWinkel)
  (print dp)
  
  (if (= RWinkel   0.0) (Traeger.set Tr_ID (delta_V (* -0.5 dp   )) (delta_LR (* -0.5 h_Trg))))
  (if (= RWinkel  90.0) (Traeger.set Tr_ID (delta_V (*  0.5 b_Trg)) (delta_LR (*  0.5 dp   ))))
  (if (= RWinkel 180.0) (Traeger.set Tr_ID (delta_V (* -0.5 dp   )) (delta_LR (* -0.5 h_Trg))))
  (if (= RWinkel 270.0) (Traeger.set Tr_ID (delta_V (*  0.5 b_Trg)) (delta_LR (*  0.5 dp   ))))


)
