; $	HT	QT(IUKR)	AF(FS)	P(EZ)
; $	AT	QT(R)			AF(K)		P(E)
; $ 	AE	V(-)			H(-)		R(-)

(defun load-modules ()
	; Profil prfen
	(setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
  (if (= qsform_at "L")	(alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "F")	(alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "U") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "I") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  (if (= qsform_at "R") (load "mod-calc-uz-windverband_R"))
  (if (= qsform_at "K") (alertBox "Anschluss noch nicht mglich."  "Connection_Not_Possible_Yet"));
  
)

(defun init-connection ()
	(print "********************************************************************")
  (print "in init-connection - stz_Windverb_1");
   
  (connect.ShowAttributes CastaData)
 
    
  (setq l_schr 200)
  (setq parallel_abstand_stz 30)
  (setq rand_abst 10)
	
	
	; Berechnung der Rotation des Windverbandes
	;(if (= (Connect.get CastaData anschl_anderesende) 0)
	;	(setRWinkelVerband)
	;)
			
	
	(init-windverband)
	
)

; ----------------------------------------------------------------------------------------
; Testweise Implementierung der Formel fr die Rotation der Windverbnde
; ----------------------------------------------------------------------------------------
(defun setRWinkelVerband ()
	(print "------------------------------------------------------------")
	(print "AUTOMATISCHE BERECHNUNG DES AT-ROTATIONSWINKEL")
	
	; abhngige Gren
	(setq vwinkel_ht 	(Connect.get CastaData hpttrg_vwinkel))		(print vwinkel_ht) 
	(setq vwinkel_at 	(Connect.get CastaData trg_vwinkel))			(print vwinkel_at) 
	(setq afl_winkel 	(Connect.get CastaData afl_hwinkel))			(print afl_winkel)
	(setq at_lwinkel	(Connect.get CastaData at_laengswinkel)) 	(print at_lwinkel)
	
	(setq r_winkel_at	(Traeger.get Tr_ID r_winkel))							(print r_winkel_at)
	
	;(if (>= afl_winkel 90.0)
	;	(setq afl_winkel (- afl_winkel 90.0))
	;) 
	(print afl_winkel)
	
	; Winkel in Bogenmae umrechnen
	(setq cos_v_ht (cos (/ (* PI vwinkel_ht) 180.0)))
	(setq cos_v_at (cos (/ (* PI vwinkel_at) 180.0)))
	(setq cos_afl (cos (/ (* PI afl_winkel) 180.0)))
	(setq sin_v_ht (sin (/ (* PI vwinkel_ht) 180.0)))
	(setq sin_v_at (sin (/ (* PI vwinkel_at) 180.0)))
	
	(print cos_v_ht)
	(print cos_v_at)
	(print cos_afl)
	(print sin_v_ht)
	(print sin_v_at)
	
	(setq w_arg (+ (* cos_v_ht cos_v_at) (* sin_v_ht sin_v_at cos_afl) ))
	(print w_arg)
	
	(setq rwinkel_at (acos w_arg))
	(print rwinkel_at)
	
	(setq rwinkel_at (/ (* rwinkel_at 180.0) PI))
	(print rwinkel_at)
	
	
	(setq rwinkel_at_ToSet 0)
	; Unterscheidung fr Profile
	(if (= qsform_at "L")	(berechneWinkel_L))
	(if (= qsform_at "R")	(berechneWinkel_R))
	
	
	(print rwinkel_at_ToSet)
	
	; Rotationswinkel setzen
	(Traeger.set Tr_ID (r_winkel rwinkel_at_ToSet))
)

; ----------------------------------------------------------------------------------------
; berechnet den zu setzenden Winkel fr Winkelprofile
; ----------------------------------------------------------------------------------------
(defun berechneWinkel_L ()
	(print "L-----------------------------------------------------------")
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= vwinkel_ht 0.0)
				(progn
					(rwinkel_at_ToSet r_winkel_at)
				)
				(progn
					(if (< vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr)  1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
							(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
						)
					)
				)
			)
		)
	)
		
)

; ----------------------------------------------------------------------------------------
; berechnet den zu setzenden Winkel fr Rundstahlprofile
; ----------------------------------------------------------------------------------------
(defun berechneWinkel_R ()
	(print "R-----------------------------------------------------------")
	; Wenn der Anschluss am Flansch stattfindet ...
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= vwinkel_ht 0.0) 
				(progn
					(setq rwinkel_at_ToSet 90.0)
				)
				(progn
					(if (>= vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData amHtUnterFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtOberFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData amHtUnterFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtOberFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
					)
				)
			)
		)
	)
	
	; Wenn der Anschluss am Steg stattfindet ...
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; Wenn der HT NICHT geneigt ist ...
			(if (= vwinkel_ht 0.0) 
				(progn
					(setq rwinkel_at_ToSet 0.0)
				)
				; Wenn der HT geneigt ist ...
				(progn
					(if (>= vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData amHtStegLinks) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtStegRechts) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData amHtStegLinks) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtStegRechts) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
					)
				)
			)
		)
	)
	
)








