; $ G(20)	HT	QT(IUKR)	AF(FS)		P(EZ)
; $ G(20)	AT	QT(L)		AF(FS)		P(E)
; $ G(20)	AE	V(-)		H(-)		R(-)
; $		HT	QT(IUKR)	AF(FS)		P(EZ)
; $		AT	QT(R)		AF(K)		P(E)
; $		AE	V(-)		H(-)		R(-)

(defun load-modules ()
  ; Profil prfen
  (setq qsform_at (Traeger.get Tr_ID qsform))
  (print qsform_at)
  
)

(defun init-connection ()
  (print "*clear*")
  (print "********************************************************************")
  (print "in init-connection - uz_Windverb_1");
   
;  (connect.ShowAttributes CastaData)

  (setq K-Verband 0)
  (sucheKnotenBlech 1)

  (Continue_Connection)
  
  (if (=  K-Verband 1) (KnotenblechAnpassen))

)
(defun Continue_Connection ()    
  (setq l_schr 200)
  (setq parallel_abstand_stz 30)
  (setq rand_abst 10)
	
  ; neu eingebaut - Sept 2011 
  (setq AnschlussAusfuehren 1)
  (setq qsform_Ht (Traeger.get HTrg qsform))
  (if (= qsform_Ht "R") (Untersuchung_AnschlMoegl))

  (setq STD 0)
  (if (= AnschlussAusfuehren 1) (progn

	; Rohrprofil-Anschluss
	(rProf)
	
	(if (= qsform_Ht "R") (Untersuchung_Knbl_Aussmitte))


   ))	
)
; --- ergnzt Sept. 2011 fr Anschlsse an Rohre als Haupttrger
(defun Untersuchung_AnschlMoegl ()
    (if (= (Connect.get CastaData amHtSteg) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_VWinkel))
	(setq EbenenWinkel (runde EbenenWinkel auf 0))
	(setq AnschlussAusfuehren 0)
	
	(if (= EbenenWinkel 180.0) (setq AnschlussAusfuehren 1))
	(if (= EbenenWinkel  90.0) (setq AnschlussAusfuehren 1))
	(if (= EbenenWinkel   0.0) (setq AnschlussAusfuehren 1))
    ))
    (if (= (Connect.get CastaData amHtFlansch) 1) (progn
	(setq EbenenWinkel (Connect.get CastaData afl_HWinkel))
	(setq EbenenWinkel (runde EbenenWinkel auf 0))

	(setq AnschlussAusfuehren 0)
	(if (= EbenenWinkel 180.0) (setq AnschlussAusfuehren 1))
	(if (= EbenenWinkel  90.0) (setq AnschlussAusfuehren 1))
	(if (= EbenenWinkel   0.0) (setq AnschlussAusfuehren 1))
    ))
    (if (= AnschlussAusfuehren 0) (AlertBox "Anschluss wird nicht erstellt!\nDer Winkel in der Windverbandsebene ist unpassend." "ERR_AngleInPlaneProblem"))
)
(defun Untersuchung_Knbl_Aussmitte ()
  (if (objExist knotenBlech) (progn
     (setq	h_HT	(Traeger.get HTrg h)
		r	(/ h_HT 2.0)
		a	(Blech.get knotenBlech delta_LR)
		dp	(Blech.get knotenBlech dp)
		a1	(- a (* 0.5 dp))
		a2	(+ a (* 0.5 dp))
      )
      (setq	x1	(- r (sqrt (- (* r r) (* a1 a1)))))
      (setq	x2	(- r (sqrt (- (* r r) (* a2 a2)))))
      
      (if (< x1 x2) (progn
          (if (>= x1 1.0) (WarnMeldung_Ausmitte x2))
      ))
      (if (< x2 x1) (progn
          (if (>= x2 1.0) (WarnMeldung_Ausmitte x1))
      ))
  ))
)
(defun WarnMeldung_Ausmitte (klaffende_Fuge)
  (alertBox "Achtung!!\n\nDurch die ausmittige Lage des Knotenblechs ist ein Spalt von 1mm der nahen Kante zu verzeichnen!\nBitte beachten Sie die klaffende Fuge - durch Schweinaht zu verschlieen." "NOTE_GapToClose")
  (alertBox klaffende_Fuge)
)


; ----------------------------------------------------------------------------------------
(defun rProf ()
	
	(if (= (Connect.get CastaData satr-lhtr) 0)
		(progn
			(Traeger.set Tr_ID (r_winkel 90.0))
			(alertBox "Die Orientierung des Anschlusstrgers wird durch das Programm angepasst. Bitte wiederholen Sie nun Ihre Eingabe."  "NOTE_BracingBeamRotationCorrection")
		)
		(progn
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					
					(init-windverband)
					; CALLBACKS
					(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
						
				)
			)
			(if (= (Connect.get CastaData amHtSteg) 1)
				(progn
					(if (/= (Connect.get CastaData vatr-vhtr) 0)
						
						(progn
							(init-windverband)
							; CALLBACKS
							(Blech.set knotenBlech 	(formFkt "cb_knotenBlech"))
						)
						(alertBox "Bitte passen Sie die rel. Lage des Anschlusstrgers dem Haupttrger an." "ModifyRelativePos_AT_HT")
						
					)
				)
			)
		)
	)
	
	
)

; ----------------------------------------------------------------------------------------



; ----------------------------------------------------------------------------------------
; Testweise Implementierung der Formel fr die Rotation der Windverbnde
; ----------------------------------------------------------------------------------------
(defun setRWinkelVerband ()
	(print "------------------------------------------------------------")
	(print "AUTOMATISCHE BERECHNUNG DES AT-ROTATIONSWINKEL")
	
	; abhngige Gren
	(setq vwinkel_ht 	(Connect.get CastaData hpttrg_vwinkel))		(print vwinkel_ht) 
	(setq vwinkel_at 	(Connect.get CastaData trg_vwinkel))		(print vwinkel_at) 
	(setq afl_winkel 	(Connect.get CastaData afl_hwinkel))		(print afl_winkel)
	(setq at_lwinkel	(Connect.get CastaData at_laengswinkel)) 	(print at_lwinkel)
	
	(setq r_winkel_at	(Traeger.get Tr_ID r_winkel))							(print r_winkel_at)
	
	;(if (>= afl_winkel 90.0)
	;	(setq afl_winkel (- afl_winkel 90.0))
	;) 
	(print afl_winkel)
	
	; Winkel in Bogenmae umrechnen
	(setq cos_v_ht (cos (/ (* PI vwinkel_ht) 180.0)))
	(setq cos_v_at (cos (/ (* PI vwinkel_at) 180.0)))
	(setq cos_afl (cos (/ (* PI afl_winkel) 180.0)))
	(setq sin_v_ht (sin (/ (* PI vwinkel_ht) 180.0)))
	(setq sin_v_at (sin (/ (* PI vwinkel_at) 180.0)))
	
	(print cos_v_ht)
	(print cos_v_at)
	(print cos_afl)
	(print sin_v_ht)
	(print sin_v_at)
	
	(setq w_arg (+ (* cos_v_ht cos_v_at) (* sin_v_ht sin_v_at cos_afl) ))
	(print w_arg)
	
	(setq rwinkel_at (acos w_arg))
	(print rwinkel_at)
	
	(setq rwinkel_at (/ (* rwinkel_at 180.0) PI))
	(print rwinkel_at)
	
	
	(setq rwinkel_at_ToSet 0)
	; Unterscheidung fr Profile
	(if (= qsform_at "L")	(berechneWinkel_L))
	(if (= qsform_at "R")	(berechneWinkel_R))
	
	
	(print rwinkel_at_ToSet)
	
	; Rotationswinkel setzen
	(Traeger.set Tr_ID (r_winkel rwinkel_at_ToSet))
)

; ----------------------------------------------------------------------------------------
; berechnet den zu setzenden Winkel fr Winkelprofile
; ----------------------------------------------------------------------------------------
(defun berechneWinkel_L ()
	(print "L-----------------------------------------------------------")
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= vwinkel_ht 0.0)
				(progn
					(rwinkel_at_ToSet r_winkel_at)
				)
				(progn
					(if (< vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData vatr-lhtr) -1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
								)
							)
							(if (= (Connect.get CastaData vatr-lhtr)  1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (+ r_winkel_at rwinkel_at)))
							(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- r_winkel_at rwinkel_at)))
						)
					)
				)
			)
		)
	)
		
)

; ----------------------------------------------------------------------------------------
; berechnet den zu setzenden Winkel fr Rundstahlprofile
; ----------------------------------------------------------------------------------------
(defun berechneWinkel_R ()
	(print "R-----------------------------------------------------------")
	; Wenn der Anschluss am Flansch stattfindet ...
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= vwinkel_ht 0.0) 
				(progn
					(setq rwinkel_at_ToSet 90.0)
				)
				(progn
					(if (>= vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData amHtUnterFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtOberFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData amHtUnterFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtOberFlansch) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
					)
				)
			)
		)
	)
	
	; Wenn der Anschluss am Steg stattfindet ...
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; Wenn der HT NICHT geneigt ist ...
			(if (= vwinkel_ht 0.0) 
				(progn
					(setq rwinkel_at_ToSet 0.0)
				)
				; Wenn der HT geneigt ist ...
				(progn
					(if (>= vwinkel_ht 180.0)
						(progn
							(if (= (Connect.get CastaData amHtStegLinks) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtStegRechts) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
						(progn
							(if (= (Connect.get CastaData amHtStegLinks) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
							(if (= (Connect.get CastaData amHtStegRechts) 1)
								(progn
									(if (= (Connect.get CastaData satr-lhtr)  1) (setq rwinkel_at_ToSet    rwinkel_at)  )
									(if (= (Connect.get CastaData satr-lhtr) -1) (setq rwinkel_at_ToSet (- rwinkel_at)) )
								)
							)
						)
					)
				)
			)
		)
	)
	
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Knotenblech am HT
; ----------------------------------------------------------------------------------------
(defun cb_knotenBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)

	(setq KeinKVerband 0)
	(if (objExist knotenBlech)
	       (setq KeinKVerband 1)
	       (sucheKnotenBlech 0)
	)

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get knotenBlech dp))
	    ; (print altesDxSKopf)
	    (Connect.Showattributes CastaData)
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get knotenBlech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 		(Lochbild.get knblLochbild Klemml)
								altesDxSKopf	(Lochbild.get knblLochbild dxSKopf)
					)
					
					(setq delta_lr_Alt 	(Blech.get knotenBlech delta_lr))
					
					(setq qsform_at (Traeger.get Tr_ID qsform))
					
					
					; Flachstahl
					; --------------------------------------
					(if (= qsform_at "F")
						(progn
							(print "Flachstahl-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff)))
							
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
								)
							)
							(if (= (Connect.get CastaData satr-lhtr) -1)	
								(progn
									(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
									(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
								)
							)
						)
					)
					
					; Winkelprofil
					; --------------------------------------
					(if (= qsform_at "L")
						(progn
							(print "Winkel-Profil")
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
																					;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
							
							(Connect.showAttributes CastaData)
							
							; HT STEG
							; ----------------------------------
							(if (= (Connect.get CastaData amHtSteg) 1)
								(progn
									(if (= (Connect.get CastaData vatr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-vhtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
			
							
							; HT FLANSCH
							; ----------------------------------
							(if (= (Connect.get CastaData amHtFlansch) 1)
								(progn
									(if (= (Connect.get CastaData vatr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData satr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
									(if (= (Connect.get CastaData vatr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData satr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData satr-lhtr)  1)
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr)  1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
											(if (= (Connect.get CastaData vatr-lhtr)  1)	
												(progn
													(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
													(Lochbild.set knblLochbild 	(dxsKopf	(+ altesDxSKopf dpDiff)))
												)
											)
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(if (= (Connect.get CastaData vatr-lhtr) -1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
											(if (= (Connect.get CastaData vatr-lhtr)  1)	(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff)))))
										)
									)
								)
							)
							
						)
					)
							
					; Rundstahl
					; --------------------------------------
					(if (= qsform_at "R")
						(progn
						   (print "Rundstahl-Profil")
						   (if (objExist knotenBlech) (progn
						     (setq AbTeilKBlch (Traeger.get HTrg abTeil knotenBlech))
						     (Traeger.updateschrblng HTrg AbTeilKBlch dpDiff)
						     ; (Traeger.updateschrblng Tr_ID knotenBlech dpDiff)
						     (if (= 1 2) (progn
							(Lochbild.set knblLochbild 	(Klemml 	(+ alteKlemml dpDiff))
											;(dxsKopf	(+ altesDxSKopf (* 0.5 dpDiff)))
							)
						      ))
						      (if (= KeinKVerband 1) (progn
						          (calc_Rundr_delta_LR dpDiff)
						          (calc_Rundr_DxsKopf dpDiff)
						      )) ; Kein K-Verband
						    )) ; if Bknotenblech vorhanden
						)
					)
					
	    ))
	))
)




(defun sucheKnotenBlech (WinkelSetzen)

  (setq xPos_HT (Connect.get CastaData xPos_HT))
  (setq gesKnoBlTyp 0) ; auf unknown setzen
  (if (= (connect.get CastaData amHtOberFlansch)  1)  (setq gesKnoBlTyp _knotenblech_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1)  (setq gesKnoBlTyp _knotenblech_uf_))
  (if (= (connect.get CastaData amHtStegLinks)    1)  (setq gesKnoBlTyp _knotenblech_steg_li_))
  (if (= (connect.get CastaData amHtStegRechts)   1)  (setq gesKnoBlTyp _knotenblech_steg_re_))

  (if (= 1 2) (progn
    (setq abtl_KnoBl (Traeger.get Htrg firstAbtl knotenblech (- xPos_HT 0.1) (+ xPos_HT 0.1)))
    (while abtl_KnoBl
  	(setq sType     (Anbauteil.get abtl_KnoBl is_type gesKnoBlTyp))
	(print "Knotenblech gefunden -----------------------------------------------------")
  	(print sType)

	(showAbtlDaten abtl_KnoBl)	;; nur zu Entwicklungszwecken

	(setq afl_wnkl (Connect.get CastaData at_laengswinkel))
	(if (= WinkelSetzen 1) (Anbauteil.set abtl_KnoBl (winkel afl_wnkl)))

	(setq knotenBlech (Anbauteil.get abtl_KnoBl Objekt Blech))
        (setq K-Verband 1)

  	(setq abtl_KnoBl (Traeger.get Htrg nextAbtl knotenblech))
    )
  ))
  (setq K-Verband 0)


)
(defun KnotenblechAnpassen ()
    (setq abtl_KnoBl (Traeger.get HTrg ABTeil knotenBlech))
    (Anbauteil.BoltFit abtl_KnoBl)
)


(defun showAbtlDaten (abtlObjekt)
	(print "Beginn Anbauteildaten -------------------------------------------")
  	(setq xPos_abtl		(Anbauteil.get abtlObjekt xPos))
  	(setq winkel_abtl	(Anbauteil.get abtlObjekt winkel))
  	(setq neigwnkl_d_abtl	(Anbauteil.get abtlObjekt neigwnkl_d))
  	(setq neigwnkl_q_abtl	(Anbauteil.get abtlObjekt neigwnkl_q))
  	(setq kplrwnkl_abtl	(Anbauteil.get abtlObjekt kplrwnkl))
  	
  	(setq delta_v_abtl	(Anbauteil.get abtlObjekt delta_v))
  	(setq delta_lrs_abtl	(Anbauteil.get abtlObjekt delta_lr))
  	(setq delta_sx_abtl	(Anbauteil.get abtlObjekt delta_sx))
  	(setq seitricht_abtl	(Anbauteil.get abtlObjekt seitricht))
  	(print xPos_abtl)
  	(print winkel_abtl)
  	(print neigwnkl_d_abtl)
  	(print neigwnkl_q_abtl)
  	(print kplrwnkl_abtl)
  	
  	(print delta_v_abtl)
  	(print delta_lrs_abtl)
  	(print delta_sx_abtl)
  	(print seitricht_abtl)
	(print "Ende Anbauteildaten -------------------------------------------")
)
(defun calc_Rundr_DxsKopf (dpDiff)
    (if (= (Connect.get CastaData amHtFlansch)  1) (progn
	(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
	(if (= (Connect.get CastaData amHtOberFlansch)  1) (progn
	      (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-shtr) 1) (progn
		    	(Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
		))
	      ))
	      (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-shtr) -1) (progn
		    	(Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
		))
	      ))
	))
	(if (= (Connect.get CastaData amHtUnterFlansch)  1) (progn
	      (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-shtr)-1) (progn
		    	(Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
		))
	      ))
	      (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData vatr-shtr) 1) (progn
		    	(Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
		))
	      ))
	))
    ))
    (if (= (Connect.get CastaData amHtSteg)  1) (progn
      (if (= (Connect.get CastaData linkesEnde) 1) (progn
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
		(if (= (Connect.get CastaData amHtStegRechts)  1)
	    	   (Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
	    	)
	))
	(if (= (Connect.get CastaData vatr-vhtr)  1) (progn
		(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
		(if (= (Connect.get CastaData amHtStegLinks)  1)
	    	   (Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
	    	)
	))
      ))
      (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
		(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
		(if (= (Connect.get CastaData amHtStegRechts)  1)
	    	    (Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
	    	)
	))
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(setq altesDxSKopf	(Lochbild.get knblLochbild dxSKopf))
		(if (= (Connect.get CastaData amHtStegLinks)  1)
	    	    (Lochbild.set knblLochbild (dxSKopf (+ altesDxSKopf dpDiff)))
	    	)
	))
      ))
    ))
)

(defun calc_Rundr_delta_LR (dpDiff)

    (if (= (Connect.get CastaData amHtFlansch)  1) (progn
        (if (= (Connect.get CastaData satr-lhtr)  1) (progn
		(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
	))
	(if (= (Connect.get CastaData satr-lhtr) -1) (progn
		(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
	))
    ))
    (if (= (Connect.get CastaData amHtSteg)  1) (progn
	(if (= (Connect.get CastaData amHtStegLinks)  1) (progn
            (if (= (Connect.get CastaData linkesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
            ))
            (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
	    ))
	))
	(if (= (Connect.get CastaData amHtStegRechts)  1) (progn
            (if (= (Connect.get CastaData linkesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
            ))
            (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	            (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
			(Blech.set knotenBlech (delta_lr (+ delta_lr_alt (* 0.5 dpDiff))))
		    ))
		    (if (= (Connect.get CastaData vatr-vhtr)  1) (progn
			(Blech.set knotenBlech (delta_lr (- delta_lr_alt (* 0.5 dpDiff))))
		    ))
	    ))
	))

    ))
)


; ----------------------------------------------------------------------------------------
; erstellt den Windverband fr Rohrprofile
; ----------------------------------------------------------------------------------------
(defun init-windverband ()
    (print "********************************************************************")
    (print "in init-connection - stz_Windverb_1");
  
    ; Einstellungen ............................
    (setq Windverbandsstab_Umsetzen 0)
    (setq K_VerbandsKnBlech         0)
    (setq LB_DEBUG 0)
	
    (setq KONTAKTLAENGE 0)
    (setq ANTEIL_STUETZE 0)
    
    (setq MIN_ABST_AUGENLCHB_BLECHENDE 60) ; Variante 2
   
    (if (objExist knotenBlech)  (progn
        (setq K_VerbandsKnBlech         1)
        ; (print "Knotenblech ist schon angelegt!")
  	(setq knblLochbild	(Lochbild.create))
  	(setq augenBlech	(Blech.create))
;  	(Connect.storeAnschlObjs CastaData knblLochbild augenBlech) 
      )
      (progn
        ; (print "Knotenblech ist noch nicht angelegt!\nDies erfolgt nun ...")
  	(setq knotenBlech	(Blech.create))
  	(setq knblLochbild	(Lochbild.create))
  	(setq augenBlech	(Blech.create))
  	(Connect.storeAnschlObjs CastaData knotenBlech) 
      )
    )
    
    (calcAndSetKnotenBlechDicke knotenBlech)  ; -> dp_kb

	
    (setq min_blech 10)
	
    ; STD = 0  :	schrges Blech mit zwei Schrauben
    ;     = 1  :	Rechteck-Blech abgechrgt mit einer Schraube
    (if (= STD 0) (progn
		(createKnotenBlech knotenBlech l_schr rand_abst)	
	)
	(progn
		(calcAndSetE0_Var2 knblLochbild parallel_abstand_stz)
		(manualKnotenBlechCreation knblLochbild)
    ))

    (kuerzeProfil knblLochbild parallel_abstand_stz)
  
    (if (= Windverbandsstab_Umsetzen 1) (progn
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
	    (if (= (Connect.get CastaData anschl_anderesende) 0) (positioniereVerband))
	))
        (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    (if (= (Connect.get CastaData anschl_anderesende) 0) (positioniereVerband))
        ))
    ))


    (calcKnbl_LR)

    
    ; Testen der eingestellten Daten
    (setq AbtlKnbl (Traeger.get HTrg ABTeil knotenBlech))

    (if (= K_VerbandsKnBlech 1) (progn
    	(Anbauteil.set AbtlKnbl (winkel 	 90.0)
    				(delta_v	  0.0)
    	)
    ))
    
)


; ====================================================================== 
(defun kuerzeProfil (Lchb_ID p_abst_stz)
	(print "--------------------------------------------------------------------------------")
	(print "KUERZE PROFIL")
  ; Winkelprofil krzen ...
  ; korrekten Wert noch aus Sttzenprofil und Winkel berechnen
  (setq kuerzLng     0
        h_Ht     	(Traeger.get HTrg h)
        b_Ht     	(Traeger.get HTrg b)
        s_Ht     	(Traeger.get HTrg s)
        t_Ht     	(Traeger.get HTrg t)
        deltaV   	(Traeger.get HTrg delta_V)
        deltaLR  	(Traeger.get HTrg delta_LR)
	qsform_HT	(Traeger.get HTrg qsform)
  )
  (setq b_Trg		(Traeger.get Tr_ID b)			; ist die Frage, wie der Stab liegt
        h_Trg    	(Traeger.get Tr_ID h)			; ob Breite oder Hhe entscheidend sind.
        rwnkl		(Traeger.get Tr_ID r_winkel)
        deltaV_at	(Traeger.get Tr_ID delta_v)
        deltaLR_at	(Traeger.get Tr_ID delta_lr)
  )
  
  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (setq kuerzLng (- (* 0.5 h_Ht) deltaV))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (setq kuerzLng (+ (* 0.5 h_Ht) deltaV))
  ))

  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (setq kuerzLng (- (* 0.5 s_Ht) deltaLR))
      (if (= qsform_HT "K") (setq kuerzLng (- (* 0.5 b_Ht) deltaLR)))
      (if (= qsform_HT "R") (setq kuerzLng (- (* 0.5 b_Ht) deltaLR)))
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (setq kuerzLng (+ (* 0.5 s_Ht) deltaLR))
      (if (= qsform_HT "K") (setq kuerzLng (- (* 0.5 b_Ht) deltaLR)))
      (if (= qsform_HT "R") (setq kuerzLng (- (* 0.5 b_Ht) deltaLR)))
  ))

  ;; Mrz 2010 - Windverbandsstab im Bereich der Flansche.
  (setq blch_dlr (Blech.get Knotenblech delta_lr))
  (if (< blch_dlr 0) (setq blch_dlr (- blch_dlr)))	; sozusagen absolut setzen
  
  (if (> blch_dlr (- (* 0.5 h_Ht) t_Ht)) (progn
     ; (print "Mrzerweiterung - Windverbandsablngung")
     (setq qsform_ht (Traeger.get HTrg qsform))

     (if (= (connect.get CastaData amHtStegLinks) 1) (progn
         (setq kuerzLng (- (* 0.5 b_Ht) deltaLR))
         (if (= qsform_ht "U") (setq kuerzLng deltaLR))
     ))
     (if (= (connect.get CastaData amHtStegRechts) 1) (progn
         (setq kuerzLng (+ (* 0.5 b_Ht) deltaLR))
         (if (= qsform_ht "U") (setq kuerzLng (+ b_Ht deltaLR)))
     ))
  ))
  ;; Mrz 2010 - Ende Erweiterung


	(print kuerzLng)
	
  (setq AFl_Winkel (connect.get CastaData at_laengswinkel))
  
  (print AFl_Winkel)
  (setq AFl_Winkel (- AFl_Winkel 90.0))
	(print AFl_Winkel)
  
  (setq sinAWnkl (sin (/ (* PI AFl_Winkel) 180.0))
  			cosAWnkl (cos (/ (* PI AFl_Winkel) 180.0))
  			tanAWnkl (tan (/ (* PI AFl_Winkel) 180.0))
  )
  (print tanAWnkl)
  
  
  ; Anteil, wenn Verbandstab entlang der HT-Lngsachse verschoben wird
	; (abhngig von der Rotation des Winkels)
	; --------------------------------------------------------
	
	(setq A_Winkel (connect.get CastaData at_laengswinkel))
	
	(setq tanAW (tan (/ (* PI A_Winkel) 180.0))
				sinAW	(sin (/ (* PI A_Winkel) 180.0))
	)
	
	
	(print deltaLR_at)
	(print deltaV_at)
	
	(setq delta 0)
	; 1. ANSCHLUSS
	; --------------------------------------------------------------------------------------
	
	; FLANSCH
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
		)
	)
	
	; STEG
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta deltaLR_at))
					(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- deltaLR_at)))
				)
			)
		)
	)
	(print delta)
	; --------------------------------------------------------------------------------------
	
	
	
	; 2. ANSCHLUSS
	; --------------------------------------------------------------------------------------
	
	(if (> (Connect.get CastaData anschl_anderesEnde) 0)
		(progn
			(setq h_trg_halb (* 0.5 h_trg)) ; TODO: je nach Rotation h oder b verwenden
			
			(if (= 1 2)
				(progn
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta h_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta h_trg_halb)))
						)
					)
					(if (= (Connect.get CastaData vatr-shtr) -1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta (- delta h_trg_halb)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta (+ delta h_trg_halb)))
						)
					)
				)
			)
		))
			
			
			
		)
	)

	; --------------------------------------------------------------------------------------
	(print delta)
	
	(setq anteil_delta (/ delta tanAW))
  (print anteil_delta)
  
  (setq abstand_Stz p_abst_stz)
		  
	(if (= cosAWnkl 0.0) (setq cosAWnkl 1.0))
		  
	(setq anteil_Stz (/ kuerzLng cosAWnkl))
	(setq ANTEIL_STUETZE anteil_Stz)
  
  (if (= STD 0)
  	(progn
		  
		  (setq anteil_Verb (* b_Trg tanAWnkl))
		  
		  ; Soll-Kontaktlnge zwichen Augenlasche und Knotenblech
			(print AFl_Winkel)
			(setq tan_afl	(tan (/ (* PI AFl_Winkel) 180.0)))
			(print tan_afl)
			(if (< tan_afl 0) (setq tan_afl (- tan_afl)))
			(print tan_afl)
			(setq diff_1 (* rand_abst tan_afl))
			(print diff_1)
			(setq diff_2 (- p_abst_stz diff_1))
			(print diff_2)
			(setq kontakt_laenge (- l_schr diff_2))
			(setq KONTAKTLAENGE kontakt_laenge)
			(print kontakt_laenge)
			(print l_schr)
		  (setq anteil_augenlasche (+ diff_1 diff_2 (* kontakt_laenge 1.25)))
		  
		  (print abstand_Stz)
		  (print anteil_Stz)
		  (print anteil_Verb)
		  (print anteil_augenlasche)
		  (print anteil_delta)
		  
		  (if (< AFl_Winkel 0) 
		  	(setq deltaLNeu (+ anteil_Stz (- anteil_Verb) anteil_augenlasche anteil_delta))
		  	(setq deltaLNeu (+ anteil_Stz anteil_Verb anteil_augenlasche anteil_delta))
		  )
		)
	)
  
  
  
  (print deltaLNeu)
  ;(print kuerzLng)
  ;(print b_Trg)
  ;(print abstand_Stz)
  ;(print anteil_Stz)
  ;(print anteil_Verb)
  ;(print deltaLNeu)
  
  
  
	;Krzen
  (if (= (connect.get CastaData LinkesEnde) 1) (progn
      (setq TrE_Links (Traeger.get Tr_ID links))
      (TrEnde.set TrE_Links (delta_L 0))
      (TrEnde.pTrim TrE_Links deltaLNeu)
  ))
  (if (= (connect.get CastaData RechtesEnde) 1) (progn
      (setq TrE_Rechts (Traeger.get Tr_ID rechts))
      (TrEnde.set TrE_Rechts (delta_L 0))			; erst einmal zurcksetzen
      (TrEnde.pTrim TrE_Rechts deltaLNeu)			; dann krzen
  ))

	(print "--------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Verschiebt den Trger passend zum Knotenblech
; ****************************************************************************************
(defun positioniereVerband ()
	(print "--------------------------------------------------------------------------------")		
	(print "POSITIONIERE VERBAND")
	
  (setq RWinkel (Traeger.get Tr_ID R_Winkel)
        dp      (Blech.get   knotenBlech  dp)
        dp_al		(Blech.get	 augenBlech		dp)
  )
  (print RWinkel)
  (print dp)
  (print dp_al)
	(setq dp (* 0.5 (+ dp dp_al)))
	
  ;Positionieren
  (setq delta_V 0)
  
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
	    (if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 		(- delta_v_at dp)	))
	    (if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 		(+ delta_v_at dp)	))
	    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 		(+ delta_v_at dp)	))
		(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 		(- delta_v_at dp)	))
	    ))
	))
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 	(+ delta_v_at dp)))
			(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 	(- delta_v_at dp)))
			
			(if (= (Connect.get CastaData vatr-shtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_V 	(- delta_v_at dp)))
					(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_V 	(+ delta_v_at dp)))
				)
			)
		)
	)
	
	(print delta_V)
	
	(Traeger.set Tr_ID (delta_V delta_V))
	
	(print "--------------------------------------------------------------------------------")		
)

; ----------------------------------------------------------------------
; ---------------------------------------------------------------------- 
(defun createKnotenBlech (Blech_ID l_schr rand_abst)
	(print "------------------------------------------------------------")
	(print "ERZEUGE KNOTENBLECH")
	
	
  
  ; Default-Werte des Blechs
  (Blech.set Blech_ID (hp 200)
      								(bp 120)
  )
	
	; allg. Daten
	(setq	b_Trg   	(Traeger.get Tr_ID b)
		h_Trg	  	(Traeger.get Tr_ID h)
		RWinkel 	(Traeger.get Tr_ID R_Winkel)
		delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq	delta_v_ht 	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	
	(setq anschl_winkel (Connect.get CastaData at_laengswinkel))
	
	(print anschl_winkel)
	
	(if (< anschl_winkel 0.0)
		(if (< anschl_winkel (- 180.0))
			(setq anschl_winkel (+ anschl_winkel 360.0))
			(setq anschl_winkel (+ anschl_winkel 90.0))
		)
	)
	(print anschl_winkel)
	; wenn schrg, wird afl_winkel negativ ausgegeben ?????
	;(setq anschl_winkel (- anschl_winkel))
	
	(setq sinAW (sin (/ (* PI anschl_winkel) 180.0)))
	(print sinAW)
	
	
	(print RWinkel)
	(setq dp_knbl (Blech.get Blech_ID dp))
	
	  
  ; lokale Verschiebung des Windverbandes bestimmen
  (setq wv_versatz 0)
  
  (if (= Windverbandsstab_Umsetzen 1) (progn
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(calcFirstConnection)
		
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 2. Anschluss
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0) (progn
		(calcSecondConnection)
	))
  ))
  ; nderung Mrz 2010 - keine Verschiebung des Windverbandsstabs vorsehen
  (if (= Windverbandsstab_Umsetzen 0) (progn
	(calcFirstConnection)
	(calcSecondConnection)
  ))
  
    (if (= K-Verband 0) (progn		
	  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_of_)  ;
	  ))
	  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_uf_)  ;
	  ))
	  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_li_)  ;    
	  ))
	  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
	      (traeger.addabtl Htrg Blech_ID 0.0 0.0 _knotenblech_steg_re_)  ;    
	  ))
    ))  
  
  
    (setq xPosStz      (Connect.get CastaData xPos_HT))
    ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  
    ; Verschiebung des HT delta_v / delta_lr
    (calcXPosDelta_HT)
	
    ; Verschiebung des AT delta_v / delta_lr
    (calcXPosDelta_AT)
	
    ; xPos setzen

;    (Connect.showAttributes CastaData)
    (setq xPosOrg (Connect.get CastaData xPos_HT))
    (print xPosOrg)
    (print xPosStz)
    (setq xPosStz xPosOrg)

    (setq AbtlKnBlech (traeger.get Htrg ABTeil Blech_ID))
    (Anbauteil.set  AbtlKnBlech (xpos xPosStz))

;    (setq d_schr 20 l_schr 200 )
    ; Objekt.Methode         Variable 	d_Schr 	l_Schrb  	SchrAchsWnkl
;    (Blech.knotenblechschraeg Blech_ID 	d_schr 	l_schr  	anschl_winkel)
    (print knotenblech_soll_versatz)
    
    ; wenn es sich nicht um einen K-Verband handelt, dann das Knotenblech
    ; versetzen
    (if (= K_VerbandsKnBlech 0) 
        (Blech.set Blech_ID (delta_lr knotenblech_soll_versatz))
    )
  												
 
    (print "ENDE KNOTENBLECH")
    (print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild
; ----------------------------------------------------------------------------------------





; ----------------------------------------------------------------------------------------
; Berechnet die Position des Knotenbleches entlang des Stegs fr den 1. Anschluss
; ----------------------------------------------------------------------------------------
(defun calcFirstConnection ()
	(print "BERECHNE ERSTEN ANSCHLUSS")
	; Korrektur aus Verschiebung delta_lr bzw. delta_v des AT ANSCHLUSS AM STEG
  (print delta_v_at)
  (print delta_lr_at)
  
  (setq at_verschiebung 0)
	(if (= (Connect.get CastaData amHtSteg) 1)
  	(progn
		  (if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    delta_v_at))
		  (if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    delta_v_at))
		  
		  (if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    (- delta_v_at)))
		  		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    (- delta_v_at)))
				)
			)
			
		)
	)
	(if (= (Connect.get CastaData amHtFlansch) 1)
  	(progn
		  (if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    (- delta_v_at)))
		  (if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    (- delta_v_at)))
		  
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_verschiebung    delta_v_at))
		  		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_verschiebung    delta_v_at))
				)
			)
		)
	)
  
  (print at_verschiebung)
  
  ; Knotenblech Verschiebung aus AT-Verschiebung
	(setq knotenblech_soll_versatz at_verschiebung)
	
	(setq schrauben_versatz knotenblech_soll_versatz)
	
	; Knotenblech Verschiebung aus HT-Verschiebung
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_lr_ht))
		)
	)
	(if (= (Connect.get CastaData amHTSteg) 1)
		(progn
			(setq knotenblech_soll_versatz (- knotenblech_soll_versatz delta_v_ht))
		)
	)
	(print knotenblech_soll_versatz)
	(print "ENDE ERSTER ANSCHLUSS")
)



; ----------------------------------------------------------------------------------------
; Berechnet die Position des Knotenbleches entlang des Stegs fr den 2. Anschluss
; ----------------------------------------------------------------------------------------
(defun calcSecondConnection ()
	(print "------------------------------------------------------------------------------>")
	(print "BERECHNE ZWEITEN ANSCHLUSS")
	(print "TRGER IST BEREITS FIXIERT.")
	(print knotenblech_soll_versatz)
	(print dp_knbl)
	
		
	; Anschluss am HT-Flansch
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr) 1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz dp_knbl))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz dp_knbl))
					)
				)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz dp_knbl))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz dp_knbl))
					)
				)
			)
		)
	)
	
	; Anschluss am HT-Steg
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			(if (= (Connect.get CastaData vatr-vhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz dp_knbl))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz dp_knbl))
					)
				)
				(progn
					(if (= (Connect.get CastaData satr-lhtr) 1)
						(setq knotenblech_soll_versatz (- knotenblech_soll_versatz dp_knbl))
					)
					(if (= (Connect.get CastaData satr-lhtr) -1)
						(setq knotenblech_soll_versatz (+ knotenblech_soll_versatz dp_knbl))
					)
				)
			)
			
		)
	)
	(print knotenblech_soll_versatz)
	
	(print "ENDE ZWEITER ANSCHLUSS")
	(print "<------------------------------------------------------------------------------")
)

(defun calcXPosDelta_HT ()
   (print "calcXPosDelta_HT wurde komplett ersetzt")
)
(defun calcXPosDelta_HT_Alt ()
	(print "*clear*")
	(print "------------------------------------------------------------")
	(print "BERECHNE DELTA_HT AUSWIRKUNG")
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(setq Winkel (connect.get CastaData at_laengswinkel))
	)
	(if (= (Connect.get CastaData amHtSteg) 1)
		(setq Winkel (connect.get CastaData at_laengswinkel))
	)
	(setq Winkel (- 90.0 Winkel))
	(setq sinW (sin (/ (* PI Winkel) 180.0)))
	(setq tanW (tan (/ (* PI Winkel) 180.0)))
	
	(print Winkel)
	(print tanW)
	
	(print xPosStz)
	
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(progn
			(setq deltaXPos (* delta_v_ht tanW))
			(print deltaXPos)
	
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(setq xPosStz (+ xPosStz deltaXPos))
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(setq xPosStz (- xPosStz deltaXPos))
			)
		)
	)
	
	(if (= (Connect.get CastaData amHTSteg) 1)
		(progn
			(setq knotenblech_final_versatz (- knotenblech_soll_versatz delta_lr_ht))
			(setq deltaXPos (* delta_lr_ht tanW))
			(print deltaXPos)

			(setq dlr_AT (Traeger.get Tr_ID delta_LR))
			(setq dlr_AT_Laengs (/ dlr_AT sinW))
			(if (= (Connect.get CastaData vAtr-vHtr) -1) (setq dlr_AT_Laengs (- dlr_AT_Laengs)))
	
			(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
				(setq xPosStz (- xPosStz deltaXPos))
				(if (= (Connect.get CastaData linkesEnde)  1) (setq xPosStz (+ xPosStz dlr_AT_Laengs)))
;				(if (= (Connect.get CastaData rechtesEnde) 1) (setq xPosStz (- xPosStz dlr_AT_Laengs)))
			))
			(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
				(setq xPosStz (+ xPosStz deltaXPos))
;				(if (= (Connect.get CastaData linkesEnde)  1) (setq xPosStz (+ xPosStz dlr_AT_Laengs)))
				(if (= (Connect.get CastaData rechtesEnde) 1) (setq xPosStz (- xPosStz dlr_AT_Laengs)))
			))
		)
	)
	
	
	(print xPosStz)
	(print "--------------------------------------------------------ENDE")

)


; ----------------------------------------------------------------------------------------
; BERECHNET DIE NEUE XPOS, DIE AUS DER VERSCHIEBUNG DES AT RESULTIERT
; ----------------------------------------------------------------------------------------
(defun calcXPosDelta_AT ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE DELTA_AT AUSWIRKUNG")
	; xPos berechnen und setzen
	(print xPosStz)
	
	(setq h_Trg (Traeger.get Tr_ID h)
				b_Trg	(Traeger.get Tr_ID b)
	)
	
	(if (= (Connect.get CastaData amHtFlansch) 1)
  	(setq Winkel (connect.get CastaData AFl_VWinkel))
  )
  (if (= (Connect.get CastaData amHtSteg) 1)
  	(setq Winkel (connect.get CastaData AFl_HWinkel))
  )
  
  	(if (= Winkel 0.0) (alertBox "Winkel ist 0.0 - das kann eigentlich nicht sein!" "ERR_AngleCantBeZero"))
  
  	(if (= Winkel 0.0) (setq Winkel 90.0))			;; Nur eine Notlsung
  	
  	(setq sinAW (sin (/ (* PI Winkel) 180.0)))
	(print Winkel)
	
	(setq rwinkel (Traeger.get Tr_ID r_winkel))
	(print rwinkel)
	(setq anteil_aus_delta_lr (/ delta_lr_at sinAW))
	(print anteil_aus_delta_lr)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq xPosStz (+ xPosStz anteil_aus_delta_lr)))
					(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq xPosStz (- xPosStz anteil_aus_delta_lr)))
				)
			)
		)
	)
				
	
	(print xPosStz)
	(print "<-----------------------------------------------------------")
)






; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; ----------------------------------------------------------------------------------------
; VARIANTE 2
; ----------------------------------------------------------------------------------------
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++


; ----------------------------------------------------------------------------------------
; Erzeugt das Knotenblech fr Variante 2
; ----------------------------------------------------------------------------------------
(defun manualKnotenBlechCreation (Lchb_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KNOTENBLECH VAR_2")
	(setq h_ht 				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq h_at				(Traeger.get Tr_ID h)
				b_at				(Traeger.get Tr_ID b)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel)
				xPos_ht		(Connect.get CastaData xPos_ht)
	)
	
	(setq lb_e0 (Lochbild.get Lchb_ID e0))
	
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	
	;(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq bp_blech (* 1.67 h_at)))
	;(if (= (Connect.get CastaData satr-lhtr)  1)	(setq bp_blech (* 1.67 b_at)))
	;(if (= (Connect.get CastaData satr-lhtr) -1)	(setq bp_blech (* 1.67 b_at)))
	
	(setq lb_rand_abst (* 1.3 (* 1.5 e_min_rund))) ; TODO: Rotation AT evtl. noch beachten 
	(setq lb_stz_abst (* lb_e0 sinATW))
	(print lb_stz_abst)
	
	(setq bp_blech (+ lb_rand_abst lb_stz_abst))
	(setq bp_blech_rund (runde bp_blech auf 5.0))
	
	(setq hp_blech (* 1.2 bp_blech_rund))
	(setq hp_blech_rund (runde hp_blech auf 5.0))
	
	(setq help_1 (+ h_ht_halb bp_blech_rund))
	
	(setq help_2 (/ help_1 tanATW))
	
		
	; Blechecken
	(if (> at_winkel 90.0)
		(progn
			(setq y4_blech (* 0.5 bp_blech_rund))
			(setq x4_blech (- (/ y4_blech tanATW)))
			
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	(if (< at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			
			(setq y1_blech (* 0.5 bp_blech_rund))
			(setq x1_blech (/ y1_blech tanATW))
		)
	)
	(if (= at_winkel 90.0)
		(progn
			(setq x4_blech 0.0)
			(setq y4_blech 0.0)
			(setq x1_blech 0.0)
			(setq y1_blech 0.0)
		)
	)
	
	(setq dok_blech (* 0.5 (- hp_blech_rund bp_blech_rund)))
	(if (> at_winkel 90.0)
		(setq dok_blech (- dok_blech))
	)
	(if (= at_winkel 90.0)
		(setq dok_blech 0.0)
	)

;  (print "Blechdaten setzen ...")
  (print "-------------------------------------------------------------------------Blechdaten Start")
  (print hp_blech_rund)
  (print bp_blech_rund)
  (print dok_blech)
  (print x1_blech)
  (print y1_blech)
  (print x4_blech)
  (print y4_blech)
  (print "-------------------------------------------------------------------------Blechdaten Ende")

  ; Korrektur, falls der Wert nicht mglich sein sollte
  (if (> x1_blech hp_blech_rund) (setq x1_blech hp_blech_rund))
  (if (> x4_blech hp_blech_rund) (setq x4_blech hp_blech_rund))

	  
  ; Default-Werte des Blechs
  (Blech.set knotenBlech 	(hp 	hp_blech_rund)
      				(bp 	bp_blech_rund)
      				(dok 	dok_blech)
      				(x1 	x1_blech)
      				(y1 	y1_blech)
      				(x4 	x4_blech)
      				(y4 	y4_blech)
  )
  
  (setq dp_knbl (Blech.get knotenBlech dp))
	(setq half_kbl (* 0.5 dp_knbl))
	
  (if (= Windverbandsstab_Umsetzen 1) (progn
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 1. Anschluss (es liegt noch kein Anschluss am Windverbandstab vor)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	(calcFirstConnection)
		
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; 2. Anschluss
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Wenn der Traeger bereits angeschlossen ist, mu das zweite Blech versetzt werden 
	(if (> (Connect.get CastaData anschl_anderesEnde) 0) (progn
		(calcSecondConnection)
	))
  ))  
  (if (= Windverbandsstab_Umsetzen 0) (progn
	(calcFirstConnection)
	(calcSecondConnection)
  ))
  ; xPos Knotenblech
  ; ----------------------------------------------
	;(if (> at_winkel 90.0) 
	;	(setq xPos_ht (+ xPos_ht (+ help_2 (* 0.5 hp_blech_rund))))
	;	(setq xPos_ht (+ xPos_ht (- help_2 (* 0.5 hp_blech_rund))))
	;)
	(print xPos_ht)
	

  
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_of_)  ;
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_uf_)  ;
  ))
  (if (= (connect.get CastaData amHtStegLinks) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_li_)  ;    
  ))
  (if (= (connect.get CastaData amHtStegRechts) 1) (progn
      (traeger.addabtl Htrg knotenBlech xPos_ht 0.0 _knotenblech_steg_re_)  ;    
  ))
  
  
  
  ;(setq xPosStz      (Connect.get CastaData xPos_HT))
  ;(setq WnklAnschlFl (Connect.get CastaData afl_vwinkel))
  (setq xPosStz xPos_ht)
  
  ; Verschiebung des HT delta_v / delta_lr
	(calcXPosDelta_HT)
	; Verschiebung des AT delta_v / delta_lr
	(calcXPosDelta_AT)
	
	(setq xPosStz (Connect.get CastaData xPos_HT))
	(print xPosStz)
	; xPos setzen
	(setq AbtlKnBlech (traeger.get Htrg ABTeil knotenBlech))
  (Anbauteil.set  AbtlKnBlech (xPos xPosStz))
  
  (Blech.knotenblechschraeg knotenBlech 0.0 0.0 at_winkel)
  
  (Blech.set knotenBlech (delta_lr knotenblech_soll_versatz))
  
  (print "<-----------------------------------------------------------")
)


(defun calcAndSetE0_Var2 (Lchb_ID parallel_abstand_stz)
	
	(setq	h_at 	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
	)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq at_halb (* 0.5 h_at)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq at_halb (* 0.5 h_at)))
	(if (= (Connect.get CastaData satr-lhtr)  1)	(setq at_halb (* 0.5 b_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1)	(setq at_halb (* 0.5 b_at)))
	
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanATW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinATW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq abst_lb_stz (* 1.5 MIN_ABST_AUGENLCHB_BLECHENDE)) ; Verhltniswert
	
	(setq e0 (/ abst_lb_stz sinATW))
	;(setq e0 1)
	(Lochbild.set Lchb_ID (e0 e0))
)



(defun calcAndSetKnotenBlechDicke (Blech_ID)
    (if (= K_VerbandsKnBlech 1) (setq dp_kb (Blech.get Blech_ID dp)))
    (if (= K_VerbandsKnBlech 0) (progn
	(print ">-----------------------------------------------------------")
	(print "BERECHNE DICKE DES KNOTENBLECHES")
	(setq dp_kb 10)
	(print dp_kb)
	
	(Blech.set Blech_ID (dp dp_kb))
	(print "<-----------------------------------------------------------")
    ))
)



(defun calcKnbl_LR ()
   (setq ABtl_Knbl_HT (Traeger.get HTrg   ABTeil knotenBlech))
   (setq delta_LR_abtl (Anbauteil.get ABtl_Knbl_HT delta_LR))
   (setq dOK_Blch (Blech.get knotenBlech dOK))

   (setq AbtlLchb_HT (Traeger.get HTrg   ABTeil knblLochbild))
   (setq Winkel (Anbauteil.get AbtlLchb_HT Winkel))
   (if (<= Winkel  90.0)  (setq Wst_Winkel Winkel)
   (if (<= Winkel 270.0)  (setq Wst_Winkel (- 180.0 Winkel))
   			  (setq Wst_Winkel (- 360.0 Winkel))
   ))

   (setq delta_LR_AT (Traeger.get Tr_ID delta_LR))

   (setq sin_WST (sin (/ (* PI Wst_Winkel) 180.0)))
   (setq cos_WST (cos (/ (* PI Wst_Winkel) 180.0)))
   (setq tan_WST (tan (/ (* PI Wst_Winkel) 180.0)))

   (setq delta_dOK (/ delta_LR_AT cos_WST))
   (if (= (Connect.get CastaData amHtSteg) 1)  (progn

	   (if (= (Connect.get CastaData amHtStegRechts) 1)  (progn
		(if (= (Connect.get CastaData vAtr-vHtr)  1) (progn
		    (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_dOK (- delta_dOK)))
		))
		(if (= (Connect.get CastaData vAtr-vHtr) -1) (progn
		    (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_dOK (- delta_dOK)))
		))
	   ))
	   (if (= (Connect.get CastaData amHtStegLinks) 1)  (progn
		(if (= (Connect.get CastaData vAtr-vHtr)  -1) (progn
	           (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_dOK (- delta_dOK)))
	        ))
		(if (= (Connect.get CastaData vAtr-vHtr)  1) (progn
		    (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_dOK (- delta_dOK)))
		))
	   ))
	   ; Horizontalverschiebung des HT hier noch bercksichtigen (Blechverschiebung)
	   (setq delta_LR_HT (Traeger.get HTrg delta_LR))
	   (setq dlr_Aus_HT (* delta_LR_HT tan_WST))
	   (if (= (Connect.get CastaData amHtStegLinks) 1)  (setq dlr_Aus_HT (- dlr_Aus_HT)))

	   (setq delta_dOK (+ delta_dOK dlr_Aus_HT))

	   ; Horizontalverschiebung des HT hier fr Lochbildverschiebung
	   (setq dlr_Lchb_Aus_HT (* sin_WST delta_LR_HT))
	   (print dlr_Lchb_Aus_HT)
	   (setq vorh_dlr_Lchb_HT (Anbauteil.get AbtlLchb_HT delta_LR))
	   (setq neu_dlr_Lchb_HT  (+ vorh_dlr_Lchb_HT dlr_Lchb_Aus_HT))
	   (Anbauteil.set AbtlLchb_HT (delta_LR neu_dlr_Lchb_HT))

   ))
   (if (= (Connect.get CastaData amHtFlansch) 1)  (progn
	(setq delta_dOK (- delta_dOK))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	   (if (= (Connect.get CastaData vAtr-sHtr) 1) (progn
	       (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_dOK (- delta_dOK)))
	   ))
	   (if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
	       (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_dOK (- delta_dOK)))
	   ))
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	   (if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
	       (if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_dOK (- delta_dOK)))
	   ))
	   (if (= (Connect.get CastaData vAtr-sHtr)  1) (progn
	       (if (= (Connect.get CastaData linkesEnde) 1) (setq delta_dOK (- delta_dOK)))
	   ))
	))
	; Vertikalverschiebung des HT hier bercksichtigen
	(setq delta_V_HT (Traeger.get HTrg delta_V))
	(setq dlr_Aus_HT (* delta_V_HT tan_WST))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (setq dlr_Aus_HT (- dlr_Aus_HT)))

	(setq delta_dOK (+ delta_dOK dlr_Aus_HT))

   ))

   (Blech.set knotenBlech (dOK (- dOK_Blch delta_dOK)))
   

)