; $		HT	QT(F)		AF(F)		P(EZ)
; $ 	AT	QT(FIUKR)	AF(K)		P(E)
; $		AE	V(-)		H(60-120)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-help-uz_an_stzFlansch")
)

; INITIALISIERUNGSMETHODE (START)
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun init-connection ()

	(connect.showattributes CastaData)
	
	(setq LB_DEBUG 0)
  (print "*clear*")
  (init-traegerenden)				

  (calcUzStzFlanschAbst)
  (trimmeTrgEnde)
  
  (connect.Showattributes CastaData)
)

(defun	trimmeTrgEnde ()
    (setq delta_Lr_HT (Traeger.get HTrg  delta_LR)
	  t_HTrg      (Traeger.get HTrg  t)
    )
    (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq TrgEnde (Traeger.get Tr_ID links))
		(calcTrEnde_AT_DeltaV TrgEnde  -1.0)
		(calcTrEnde_AT_DeltaLR TrgEnde -1.0)
    ))
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq TrgEnde (Traeger.get Tr_ID rechts))
		(calcTrEnde_AT_DeltaV TrgEnde   1.0)
		(calcTrEnde_AT_DeltaLR TrgEnde  1.0)
    ))
    
)

(defun calcTrEnde_AT_DeltaV (TrgEnde fakt)

	(setq dv_AT (Traeger.get TR_ID delta_V))

	(setq Fl_Wnkl (Connect.get CastaData v-atrgewnkl_flansch))
	(setq Fl_Wnkl (- 90.0 Fl_Wnkl))

	(setq sinAW (sin (/ (* PI Fl_Wnkl) 180.0)))

	(TrEnde.ptrim TrgEnde (* fakt (* sinAW dv_AT)))

)
(defun calcTrEnde_AT_DeltaLR (TrgEnde  fakt)
	(setq EWinkel (Connect.get CastaData h-atrgewnkl_flansch))
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	
	(setq NWinkel (- EWinkel 90.0))
	(setq tanW (tan (/ (* PI NWinkel) 180.0)))
	
	(setq dlr_Offset (* fakt tanW dlr_AT))
	
	(setq dl_TrgEnde (TrEnde.get TrgEnde delta_L))
	
	(setq dl_TrgEnde (- dl_TrgEnde dlr_Offset))
	(TrEnde.set TrgEnde (delta_L dl_TrgEnde))
	

)
; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------


; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */

; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD
; ----------------------------------------------------------------------------------------



; --------------------------------------------------------------------
; Begradigt die Rahmenecke wieder
; --------------------------------------------------------------------
(defun eckeBegradigen ()
	(print ">-------------------------------------------------------------------------------")
	(print "Begradige Sttzenecke")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(TrEnde.set HtEnde (v_winkel 90.0))
	
	; Verlngern und an AT anpassen
	(setq h_ht				(Traeger.get Htrg h))
	(setq afl_vwinkel (Connect.get CastaData afl_vwinkel))
	(setq delta_l			(TrEnde.get HtEnde delta_l))
	
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
	
	(setq delta_l_korr (/ h_ht_halb tanAW))
	(print delta_l)
	(print delta_l_korr)
	
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq delta_l (+ delta_l delta_l_korr))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq delta_l (- delta_l delta_l_korr))
	)	
		
	(TrEnde.set HtEnde (delta_l delta_l))
	(print "<-------------------------------------------------------------------------------")
)


; ----------------------------------------------------------


