; $		HT	QT(F)		AF(F)		P(EZ)
; $ 	AT	QT(IU)		AF(K)		P(E)
; $		AE	V(70-110)	H(90)		R(-)

(defun load-modules ()

        (print "*clear*")

	(print "Anschluss:")
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(print "am HT-Oberflansch")
			(load "mod-endinit-uz-an-flachstahl.lsp")
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(print "am HT-Unterflansch")
			(load "mod-endinit-uz-an-flachstahl.lsp")
		) 
	)
        (load "mod-lochbild")
)




(defun init-connection ()

	(setq LB_DEBUG 0)
	
	(connect.showattributes CastaData)
	
	(checkPosition)		; berechnet isInside

	(if (= isInside 1)
	    (progn
			(print "in init-connection uz_an_Flachstahl mit Fahne .........................")
			(if (= (Connect.get CastaData amHtSteg) 1)
				(alertBox "Anschluss an der schmalen Kante ist nicht mglich!" "ERR_SlimRimConnection")
			)
			(if (= (Connect.get CastaData amHtFlansch) 1)
				(init-traegerenden)	; hier werden die Traegerenden gestutzt
			)
			(setConnection)	
	  
			(print bFahnenbl)
  	    )
  	    (progn
			(alertBox "Anschluss ist nicht mglich!" "Connection_Not_Possible")
		)
	)

	(connect.showattributes CastaData)
  
    ; (Lochbild.set lchbAtrgSteg (e "0 25 75 0 0 0") (w "0 0"))
	; (Lochbild.set lchbAtrgSteg (e "0 25 75 0 0 0") (w "80 0"))
	
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil lchbAtrgSteg))
	(setq lb_ht_abtl (Traeger.get HTrg  Abteil lchbAtrgSteg))
	(setq abtlWinkel (Anbauteil.get lb_ht_abtl Winkel))
	(setq dv_Lchb_1    (Anbauteil.get lb_ht_abtl delta_V))
	
;	(Anbauteil.set lb_at_abtl (Master 0))
;	(Anbauteil.set lb_ht_abtl (Master 1))

)


(defun setConnection ()
	
	(setq bFahnenbl 		(Blech.create))
	(setq lchbAtrgSteg (Lochbild.create))
	(Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg)
	(print "Fahnenblech erzeugt")
  
	(Blech.set bFahnenbl (dp 10) (hp 200) (bp 110) (dOK 0))
	(print "Default Blechdaten")
  
	(setq	XPos 	(Connect.get CastaData XPos_HT)
  		xPos_at	(Connect.get CastaData xPos_AT)
  	)
  	(print XPos)
  
  	(setq abstzumSteg 10)

  ; Fahnenblechdaten Berechnen
  (calcAndSetBlechdaten bFahnenbl)


  
  ; Fahnenblech hinzufgen
	(setFahnenBlechAnbauteil bFahnenbl)


		
	; Lochbild HT
	(print "ADDABTL - Fahnenblechlochbild in HT")
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
	(Traeger.addabtl Htrg lchbAtrgSteg XPos 0.0 _fahnblLochbild_ AbtlFahnenBl)
	
	
	;Lochbild AT
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn			
			(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrLinks)
			(print "ADDABTL - Fahnenblechlochbild in AT")
;			(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
			
			(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _steglochbild_system_)
			
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn			
			(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrRechts)
			(print "ADDABTL - Fahnenblechlochbild in AT")
;			(traeger.addabtl tr_id lchbAtrgSteg xPos_at 0.0 _WnklSteglochbildRechts_)

			(traeger.addabtl tr_id lchbAtrgSteg xPos_at 0.0 _steglochbild_system_)

		)
	)
	
	(setLochbild lchbAtrgSteg)	

	(schiebeBlechUndFahne)
	
	(set_Lchb_Abtl_an_AT)
	(set_Lchb_Abtl_an_HT)
	
	(setze_Blech_seitlich)
	
	; CALLBACKS
	(Blech.set bFahnenbl (formFkt "cb_bFahnenbl"))

)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_bFahnenbl (zp)
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 	(Blech.get bFahnenbl dp))
	    (setq hpAlt 	(Blech.get bFahnenbl hp))
	    (setq dokAlt 	(Blech.get bFahnenbl dok))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get bFahnenbl dp))
		(setq hpNeu (Blech.get bFahnenbl hp))
		(setq dokNeu (Blech.get bFahnenbl dok))
		
		(print dpAlt) (print dpNeu)
		(print hpAlt) (print hpNeu)
		(print dokAlt) (print dokNeu)
		(print "--------------------------------------")
		
		; nderung der Blechdicke
		(if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
			
			(setq qsform_at	(Traeger.get Tr_ID qsform))
			
			(setq alteKlemml 	(Lochbild.get lchbAtrgSteg Klemml)
						dxs_alt			(Lochbild.get lchbAtrgSteg dxskopf)
			)
			
			(setq delta_lr_blech_alt (Blech.get bFahnenbl delta_lr))
			(print delta_lr_blech_alt)
			
			(setq klemml_neu	(+ alteKlemml dpDiff))
			
			(setq dxs_neu (+ dxs_alt (* 0.5 dpDiff)))
			
			(if (= qsform_at "I")
				(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
			)
			(if (= qsform_at "U")
				(progn
					
					(if (= (Connect.get CastaData amHtSteg) 1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-vhtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
						(if (= (Connect.get CastaData amHtFlansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-shtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
					
				)
			)
			
			(print delta_lr_blech_neu)		  	
			
			(Blech.set bFahnenbl (delta_lr delta_lr_blech_neu))
			              
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu)
																	(dxskopf dxs_neu)
			)    
			
			
			(setq abtl_lb_ht (Traeger.get Htrg AbTeil lchbAtrgSteg))
		  
		  (setq delta_sx_abtl_ht_neu delta_lr_blech_neu )
						
			(Anbauteil.set abtl_lb_ht (delta_sx delta_sx_abtl_ht_neu))
			
			
		))
		    
				
		(if (= 1 2)	(progn		
		; nderung der Blechhhe
		(if (/= hpAlt hpNeu) (progn
		  (setq hpDiff (- hpNeu hpAlt))
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(print delta_v_abtl_at_neu)
			
			(Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
		
		; Verschiebung des Bleches in HT-Lngsrichtung
		(if (/= dokAlt dokNeu) (progn
		  (setq dokDiff (- dokNeu dokAlt))
		  (print dokDiff)
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
		  (if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt dokDiff)))
		  (if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt dokDiff)))
		  (print delta_v_abtl_at_neu)

		  (Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
	))
	))
)



; ------------------------------------------------------------------------
; Setzt das Fahnenblech-Anbauteil
; ------------------------------------------------------------------------
(defun setFahnenBlechAnbauteil (Blech_ID)
	
  (setq XPos 		(Connect.get CastaData XPos_HT))
	
  (setq delta_v_at (Traeger.get Tr_ID delta_v))
	
  (setq rWinkel (Connect.get CastaData  r-atrgewnkl_flansch))
  (if (= (Connect.get CastaData linkesEnde) 1) (progn
     (if (= (Connect.get CastaData vatr-shtr)  1) 	(setq rWinkel (- rWinkel)))
  ))
  (if (= (Connect.get CastaData rechtesEnde) 1) (progn
     (if (= (Connect.get CastaData vatr-shtr) -1) 	(setq rWinkel (- rWinkel)))
  ))
  (print rWinkel)
		
	; Anschlsse am Flansch des Haupttrgers
  (if (= (Connect.get CastaData amHtOberflansch) 1) 	(progn
	(print "ADDABTL - Fahnenblech an HT (amHtOberflansch)")
  	(traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_of_)
  ))
  (if (= (Connect.get CastaData amHtUnterflansch) 1) 	(progn
	(print "ADDABTL - Fahnenblech an HT (amHtUnterflansch)")
  	(traeger.addabtl hTrg Blech_ID XPos rWinkel _fahnenblech_uf_)
  ))
  
  
  ; Anteil delta_v AT
  (setq delta_v_abtl_fb 0)
  
  (if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_abtl_fb (- delta_v_abtl_fb delta_v_at)))
  (if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_abtl_fb (+ delta_v_abtl_fb delta_v_at)))
	
  
  (setq abtl_fahne (Traeger.get Htrg AbTeil Blech_ID))
  
  (Anbauteil.set abtl_fahne (delta_v delta_v_abtl_fb))
  ;; wird jetzt einfach 0 eingesetzt ...
  (Anbauteil.set abtl_fahne (delta_v 0.0))
)




; ------------------------------------------------------------------------
; Passt die Lochbild-Anbauteile an.
; ------------------------------------------------------------------------
(defun setLochbild (LOCHB_ID)
	(print ">-----------------------------------------------------------")
	(print "LOCHBILDER WERDEN ANGEPASST")
	
	(setq 	h_ht		(Traeger.get Htrg h)
		s_ht		(Traeger.get Htrg s)
		b_ht		(Traeger.get Htrg b)
		delta_v_ht 	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
		qsform_ht	(Traeger.get Htrg qsform)
		
		delta_v_ht  (* 1.0 delta_v_ht)
	)
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v)
		  h_at			(Traeger.get Tr_ID h)

		  delta_v_at  (* 1.0 delta_v_at)
	  )
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht))
	
	(setq dok_blech   (Blech.get bFahnenbl dok))
	
	(setq lb_ht_abtl (Traeger.get Htrg Abteil LOCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil LOCHB_ID))
	
	(if lb_ht_abtl
	    (print "lb_ht_abtl ist als Anbauteil vorhanden");
	    (print "lb_ht_abtl nicht vorhanden")
	)
	(if lb_at_abtl
	    (print "lb_at_abtl ist als Anbauteil vorhanden");
	    (print "lb_at_abtl nicht vorhanden")
	)
	
	; s_ht bei Rund- und Kastenprofilen ndern!!!
	(if (= qsform_ht "K")
		(setq s_ht b_ht)
	)
	(if (= qsform_ht "F") (progn
		; Weil bei Flachstahl die TRgerhe h null betrgt, muss diese auf t
		; hergeleitet werden.
		(setq h_ht (Traeger.get Htrg t))
	))
	
	;(setq e_diff (- (* 0.5 h_trg) (* 0.5 hp_blech) dok_blech))
	
	; Anbauteil HT
	; ----------------------------------------------
	
	; Positionieren (an AT)
	(setq r_Wnkl (Connect.get CastaData r-atrgewnkl_flansch))
	(setq v_Wnkl (Connect.get CastaData v-atrgewnkl_kopf))
	(setq sWinkel   90.0)
	
	(if (= (Connect.get CastaData vatr-lhtr) -1) (progn
		(setq sWinkel v_Wnkl)
	))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (progn
		(setq sWinkel (- 180.0 v_Wnkl))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
		(setq sWinkel (- 180.0 sWinkel))
	))
	

	(setq cosW (cos (/ (* PI sWinkel) 180.0)))
	(setq tanW (tan (/ (* PI sWinkel) 180.0)))

	(if (= cosW 0.0) (progn
		(AlertBox "Sonderfall - Winkel = 90.0")
		(setq cosW 1.0)
	))
	;	(setq cosW 1.0)

	(setq delta_v_abtl_ht (- (* 0.5 h_at)))
	(setq delta_v_abtl_ht (/ (* 0.5 h_at) cosW))
	(if (= (Connect.get CastaData linkesEnde)      1) (setq delta_v_abtl_ht (- delta_v_abtl_ht)))
;	(if (= (Connect.get CastaData amHtOberflansch) 1) (setq delta_v_abtl_ht (- delta_v_abtl_ht)))
	
	(setq t_HT (Traeger.get HTrg t))
	(setq delta_v_abtl_ht (- delta_v_abtl_ht (* 0.5 t_HT tanW)))
	
	; Anteil delta_V HT
	(setq delta_v_ht (* delta_v_ht tanW))

	(if (= (Connect.get CastaData amHtUnterflansch) 1) (setq delta_v_ht (- delta_v_ht)))
	
	; Anteil delta_v AT
	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at delta_v_ht))
	
	(print dok_blech)
	
	; Anbauteil AT
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 h_ht) delta_v_ht)))
	(if (= (Connect.get CastaData amHtOberFlansch) 1) 	(setq delta_lr_abtl_at (- (* 0.5 h_ht) delta_v_ht)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_lr_abtl_at (- (* 0.5 s_ht) delta_lr_ht)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 s_ht) delta_lr_ht)))
	
	(Anbauteil.set lb_ht_abtl (delta_v		delta_v_abtl_ht))
	(Anbauteil.set lb_at_abtl (delta_lr 	delta_lr_abtl_at))
	
	
	; TEST
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	;(setq LB_DUMMY (Lochbild.create))
	;(Lochbild.copy LB_DUMMY Lchb_ID)
	
	;(Traeger.addabtl Htrg LB_DUMMY 0.0 0.0 _WnklSteglochbildLinks_)
	;(setq AbtlKnoBlLchbAT_DUMMY    (Traeger.get Htrg AbTeil LB_DUMMY))
	;(Anbauteil.set AbtlKnoBlLchbAT_DUMMY 	(Master 1)
	;																			(delta_lr delta_lr_abtl_at)
	;																			;(delta_v 	delta_v_abtl_at)
	;)
	
	;(Connect.storeAnschlObjs CastaData LB_DUMMY)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	
	(Anbauteil.set lb_at_abtl (Master 0))
	(Anbauteil.set lb_ht_abtl (Master 1))
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
	    (progn
		(setq dummy (Lochbild.create))
		(Lochbild.copy dummy LOCHB_ID)
						
		(if (= (connect.get CastaData LinkesEnde) 1) (progn
			(print "ADDABTL - Dummy-Lochbild zum Debuggen")
			(traeger.addabtl Tr_ID dummy 0.0 0.0 _WnklSteglochbildLinks_)
		))
		(if (= (connect.get CastaData RechtesEnde) 1) (progn
			(print "ADDABTL - Dummy-Lochbild zum Debuggen")
			(traeger.addabtl Tr_ID dummy xPos_at 0.0 _WnklSteglochbildRechts_)
		))
		(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
		(Anbauteil.set dummy_abtl	(Master 1)	
						(delta_lr delta_lr_abtl_at)
		)
	    )
	)
	;===================================================================
	
	(print "<-----------------------------------------------------------")
)



; ----------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde)
	(Lochbild.set Lchb_ID	(Anz_S    2)
				(Guete   "4.6")
				(e       "100 50 0 0 0 0")
				(w       "0  0")
	)
	
	(setq	h_AT 			(Traeger.get Tr_ID h)
			t_AT			(Traeger.get Tr_ID t)
			r_AT			(Traeger.get Tr_ID r)
	)
	(setq	s_htrg			(Traeger.get Htrg s)
			delta_lr_htrg	(Traeger.get Htrg delta_lr)
			delta_v_htrg	(Traeger.get Htrg delta_v)
			h_htrg			(Traeger.get Htrg h)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l))
		
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	
	(print e_min)
	(print abstZumSteg)
	(print s_htrg)
	
	; Abstand HT Kante zum Lochbild
	(if (= (Connect.get CastaData amHTSteg) 1)
		(setq abst_lchb_kante (+ abstZumSteg e_min))
	)
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(setq abst_lchb_kante (+ abstZumSteg e_min))
	)
	
	(setq w0 abst_lchb_kante)
	(print abst_lchb_kante)
	(print delta_lr_htrg)
	
(if (= 1 1) (progn	
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (< delta_lr_htrg abst_lchb_kante)
				(setq w0_rund (runde w0 auf 5))
				(setq w0_rund (runde w0 ab 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (< delta_lr_htrg abst_lchb_kante)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (< delta_v_htrg abst_lchb_kante)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	) 
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (< delta_v_htrg abst_lchb_kante)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)
))	


	(setq w0_rund (runde w0 auf 5))
	
	(print w0)
	(print w0_rund)
	;(setq w0_rund (runde w0 auf 5))
	
	(setq hp_blech 	(Blech.get BlechID hp)
				dok_blech	(Blech.get BlechID dok)
	)
	(print hp_blech)
	(print dok_blech)
	
	(setq maxHP (- h_AT t_AT t_AT r_AT r_AT))
	(setq sd (Lochbild.get lchbAtrgSteg sdurchm))

	(setq eAbstand  	(runde (+ t_AT r_AT sd sd) auf 5))
	(setq eZwAbstand	(- h_AT eAbstand))
	; man knnte noch eZwAbstand prfen und wenn grer als 6sd
	; dann eAbstand (e0) vergrern.
	
	(setq e0 eAbstand)
	(setq e1 (- eZwAbstand e0))
	
	; Klemmlnge
	(setq dp_blech 	(Blech.get BlechID dp))
	(setq s_trg	(Traeger.get Tr_ID s))
	
	; Schraubenkopf
	(calcDxSKopf s_trg dp_blech)

	
	(Lochbild.set Lchb_ID	(e0 		e0)
				(e1 		e1)
				(w0 		w0_rund)
				(klemml (+ dp_blech s_trg))
				(dxSKopf dxSKopf)           ; HIER EINFACH AUF 0 SETZEN.
	) 

(if (= LB_DEBUG 1) (progn	 
	(Lochbild.set Lchb_ID	(e0 		0)
				(e1 		20)
				(e2 		60)
	)
))
	
	(print e_min)
	(print w0)
	
	; Korregiere Fahnenblech
	(Blech.set BlechID (bp (+ (* 2.0 e_min_rund) abstZumSteg))) 
)

(defun calcDxSKopf (s_trg dp_blech)
	(print "------------------------------------------------------------")
	(print "BERECHNE DXSKOPF")
	(setq qsform (Traeger.get Tr_ID qsform))

	(setq dxSKopf 10.0)

	(if (= qsform "I")
		(progn
;			(setq dxSKopf (+ s_trg (* 1.0 dp_blech)))
			(setq dxSKopf (- (* 1.0 dp_blech) s_trg))
		)
	)
	(if (= qsform "U")
		(progn
			(setq dxSKopf  (- (* 1.0 dp_blech) (* 0.5 s_trg)))
		)
	)

	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Prft, die Position des AT in Bezug auf den HT
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq	hc_ht		(Traeger.get Htrg hc)
		b_ht		(Traeger.get Htrg b)
		delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr)
				s_at				(Traeger.get Tr_ID s)
	)
	
	; Standardmig wird angenommen, dass der AT angeschlossen werden kann.
	(setq isInside 1)
	
	; Wenn der Anschluss am HT-Steg erfolgt, wird geprft, ob sich der AT-Steg im HC-Bereich des HT befindet.
	(if (= (connect.get CastaData amHtSteg) 1) (setq isInside 1))
	
	; Wenn der Anschluss am HT-Flansch erfolgt, wird geprft, ob der AT-Steg noch am Flansch 
	; angeschlossen werden kann.
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			; linke und rechte Seite des HT-Fansches
			(setq flansch_ht_l (- delta_lr_ht (* 0.5 b_ht)))
			(setq flansch_ht_r (+ flansch_ht_l b_ht))
			(print flansch_ht_l)
			(print flansch_ht_r)
			(print delta_lr_at)
			
			(if (= (Connect.get CastaData satr-shtr) 1)
				(progn
					(if (> delta_lr_at flansch_ht_r)
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at flansch_ht_l)
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (> delta_lr_at (- flansch_ht_l))
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at (- flansch_ht_r))
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			
			(if (= isInside 0)
				(print "AUSSERHALB FLANSCH")
				(print "INNERHALB FLANSCH")
			)
		)
	)
)
; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten (fahnenblech)
	(print "------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN")
	
	(setq	hc_trg 		(Traeger.get Tr_ID hc)
		delta_v_trg 	(Traeger.get Tr_ID delta_v)
		delta_lr_trg	(Traeger.get Tr_ID delta_lr)
		rwnkl_trg	(Traeger.get Tr_ID r_winkel)
		tSteg 		(Traeger.get Tr_ID s)
		t_at	 	(Traeger.get Tr_ID t)
		r_at	 	(Traeger.get Tr_ID r)
		qsform		(Traeger.get Tr_ID qsform)
	)
		
	(setq	s_htrg 		(Traeger.get Htrg s)
		delta_v_htrg	(Traeger.get Htrg delta_v)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
	)

	(setq dok_fahne			(Blech.get fahnenblech dok))
	
	(setq hp_soll hc_trg)
	(setq dok dok_fahne)
	
	
	(setq dp_blech (runde tSteg auf 5))
	
	(Blech.set fahnenblech 	(dp 	dp_blech) 
				(hp 	hp_soll)
	)
	
	(setq dp (Blech.get bFahnenbl dp))
	
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< dp tSteg)
		(setq min_bl dp)
		(setq min_bl tSteg)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	(print s_bez)
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set lchbAtrgSteg (S_Bez S_Bez))

  ; ----------------------------------------------------------------
)
; -------------------------------------------------------------------

(defun schiebeBlechUndFahne ()

    ; Anbauteile ermitteln -----------------------
    (setq abtl_Fahne     (Traeger.get HTrg ABTeil bFahnenbl))
    (setq abtl_Lchb_Htrg (Traeger.get HTrg ABTeil lchbAtrgSteg))
    ; ---------------------------------------------
    (setq delta_Lr_HT (Traeger.get HTrg  delta_LR))
    (setq delta_Lr_HT (* 1.0 delta_Lr_HT))

    (setq delta_Lr_AT (Traeger.get Tr_ID delta_LR)
          delta_V_AT  (Traeger.get Tr_ID delta_V)
          h_Atrg      (Traeger.get Tr_ID h)
    	  s_Atrg      (Traeger.get Tr_ID s)
    )
    (setq delta_Lr_AT (* 1.0 delta_Lr_AT)
          delta_V_AT  (* 1.0 delta_V_AT)
	)
    ; ---------------------------------------------

    (setq Winkel_FahLchb_HTrg (Connect.get CastaData r-atrgewnkl_flansch))
    (setq cosRWnkl (cos (/ (* PI Winkel_FahLchb_HTrg) 180.0))
          sinRWnkl (sin (/ (* PI Winkel_FahLchb_HTrg) 180.0))
    )
    (setq Wnkl_Ges  (- Winkel_FahLchb_HTrg))

    (if (= (Connect.get CastaData satr-lhtr) 1) (progn
        (setq Wnkl_Ges (- Wnkl_Ges))
        (setq sinRWnkl (- sinRWnkl))
    ))
    
    (setq dp     (Blech.get   bFahnenbl dp)) 

    (setq Schrb_DX 0.0)		;; sicherheitshalber initialisieren ...
    (setq qsform_at	(Traeger.get Tr_ID qsform))
    
    ; lokale Verschiebungen des AT werden zum Schluss erst aufgebracht ...
    ; da diese vom Rotationswinkel vllig unabhngig sind.
    ; Beim Blech ist es nicht an den Winkel des Blechs auf dem Trger
    ; gebunden. Deswegen wird die seitliche Verschiebung
    ; direkt am Blech angebracht und nicht am Anbauteil.
   
    (if (= (Connect.get CastaData linkesEnde) 1) (progn
        (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
            (setq delta_SX_Ges (- (* cosRWnkl delta_Lr_HT)))
            (setq lchb_RWinkel Wnkl_Ges)
    	    (setq delta_SX_Ges (+ delta_SX_Ges delta_Lr_AT))
    	    (setq delta_V_AT (- delta_V_AT))
            (setq Schrb_DX  (* 0.5 s_ATrg))
            (if (= qsform_at "U") 
                (setq Schrb_DX  0)
            )
			
			(if (= (Connect.get CastaData vAtr-sHtr) -1) (setq lchb_RWinkel (+ Wnkl_Ges 180)))
        ))
        (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
            (setq delta_SX_Ges (* cosRWnkl delta_Lr_HT))
            (setq lchb_RWinkel (- Wnkl_Ges 180))
            (setq delta_SX_Ges (- delta_SX_Ges delta_Lr_AT))
            (setq Schrb_DX (+ (* 0.5 s_ATrg) dp))
            (if (= qsform_at "U") 
                (setq Schrb_DX (+ s_ATrg dp))
            )
        ))
    ))

    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
        (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
            (setq delta_SX_Ges (* cosRWnkl delta_Lr_HT))
            (setq lchb_RWinkel (- Wnkl_Ges 180))
            (setq delta_SX_Ges (- delta_SX_Ges delta_Lr_AT))
            (setq Schrb_DX (+ (* 0.5 s_ATrg) dp))
            (if (= qsform_at "U") 
                (setq Schrb_DX (+ s_ATrg dp))
            )
        ))
        (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
            (setq delta_SX_Ges (- (* cosRWnkl delta_Lr_HT)))
            (setq lchb_RWinkel Wnkl_Ges)
    	    (setq delta_SX_Ges (+ delta_SX_Ges delta_Lr_AT))
    	    (setq delta_V_AT (- delta_V_AT))
            (setq Schrb_DX  (* 0.5 s_ATrg))
            (if (= qsform_at "U") 
                (setq Schrb_DX  0)
            )
        ))
    ))

   
    (Lochbild.set lchbAtrgSteg (dxskopf Schrb_DX))
   
    (Anbauteil.set abtl_Fahne
    		(delta_v  0)
    		(delta_lr 0.0)		; nderung!! 08-2024
    		(winkel   Wnkl_Ges)
    )

	(if (<= lchb_RWinkel -180.0) (setq lchb_RWinkel (+ 360.0 lchb_RWinkel)))
    (Anbauteil.set abtl_Lchb_Htrg
    		(delta_lr 0)
    		(delta_sx delta_SX_Ges)
    		(winkel   lchb_RWinkel)
    )
 
)
; ----------------------------------------------------------
(defun set_Lchb_Abtl_an_AT ()
	(setq h_AT 		(Traeger.get Tr_ID h)
		  dv_AT		(Traeger.get Tr_ID delta_V)
		  dv_AT		(* 1.0 dv_AT)
	)
	(setq t_HT 		(Traeger.get HTrg t)
		  dv_HT		(Traeger.get HTrg delta_V)
		  dv_HT		(* 1.0 dv_HT)
	)

	(setq lb_at_abtl (Traeger.get Tr_ID Abteil lchbAtrgSteg))

	(setq v_Wnkl (Connect.get CastaData v-atrgewnkl_kopf))
	(setq v_Wnkl_Lb 0.0)
	(setq sWinkel   0.0)
	
	(if (= (Connect.get CastaData vatr-lhtr) -1) (progn
		(setq v_Wnkl_Lb (-  270.0 v_Wnkl))
		(setq sWinkel v_Wnkl)
	))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (progn
		(setq v_Wnkl_Lb (+ v_Wnkl 90.0))
		(setq sWinkel (- 180.0 v_Wnkl))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
		(setq v_Wnkl_Lb (+ v_Wnkl_Lb 180.0))
		(if (> v_Wnkl_Lb 360.0) (setq v_Wnkl_Lb (- v_Wnkl_Lb 360.0)))
		(setq sWinkel (- 180.0 sWinkel))
	))
	
	; ------------------ nochmal neu
	(setq v_Wnkl_Lb (-  270.0 v_Wnkl))
	
	
	(setq sinW (sin (/ (* sWinkel PI) 180.0)))
	(setq cosW (cos (/ (* sWinkel PI) 180.0)))
	(setq tanW (tan (/ (* sWinkel PI) 180.0)))
	
	(print v_Wnkl_Lb)
	(print sWinkel)

	; Anteile aus AT	------------------------------
	(setq dlr_dv_AT (* dv_AT sinW))
	(setq dv_dv_AT (* dlr_dv_AT tanW))
	
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
		(setq dlr_Lchb  (* 0.5 t_HT))
		(setq dlr_Lchb  (- dlr_Lchb dlr_dv_AT))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
		(setq dlr_Lchb (* -0.5 t_HT))
		(setq dlr_Lchb  (+ dlr_Lchb dlr_dv_AT))
	))

	; (setq dv_Lchb  (/ (* -0.5 h_AT) cosW))
	(setq dv_Lchb  (* -0.5 h_AT))
	
	
	(setq dv_Lchb (+ dv_Lchb dv_dv_AT))

	; Anteile aus HT	------------------------------
	(setq dv_aus_tHT (* 0.5 t_HT tanW))
	(setq dv_Lchb (- dv_Lchb dv_aus_tHT))

	(setq dv_aus_dvHT (* dv_HT tanW))
	
	(if (= (Connect.get CastaData amhtunterflansch )  1) (progn
		(if (= (Connect.get CastaData linkesEnde)  1) (progn
			(setq dlr_Lchb (+ dlr_Lchb dv_HT))
		))
		(if (= (Connect.get CastaData rechtesEnde)  1) (progn
			(setq dlr_Lchb (- dlr_Lchb dv_HT))
		))
		(setq dv_Lchb  (- dv_Lchb dv_aus_dvHT))
	))
	(if (= (Connect.get CastaData amhtoberflansch  )  1) (progn
		(if (= (Connect.get CastaData linkesEnde)  1) (progn
			(setq dlr_Lchb (- dlr_Lchb dv_HT))
		))
		(if (= (Connect.get CastaData rechtesEnde)  1) (progn
			(setq dlr_Lchb (+ dlr_Lchb dv_HT))
		))
		(setq dv_Lchb  (+ dv_Lchb dv_aus_dvHT))
	))
	
	(setq SRicht 0)
	(if (= (Connect.get CastaData amhtoberflansch  )  1) (progn
		(if (= (Connect.get CastaData linkesEnde)  1) (progn
			(setq SRicht -1)
		))
	))
	(if (= (Connect.get CastaData amhtUnterflansch  )  1) (progn
		(if (= (Connect.get CastaData rechtesEnde)  1) (progn
			(setq SRicht -1)
		))
	))

;	(if (= (Connect.get CastaData amhtoberflansch  )  1) (AlertBox "amhtoberflansch"))
;	(if (= (Connect.get CastaData amhtUnterflansch  )  1) (AlertBox "amhtUnterflansch"))
	
	(Anbauteil.set lb_at_abtl 	(winkel v_Wnkl_Lb)
								(delta_LR dlr_Lchb)
								(delta_V dv_Lchb)
								(SeitRicht SRicht)
	)


)
; ----------------------------------------------------------
(defun set_Lchb_Abtl_an_HT ()
	(setq lb_ht_abtl (Traeger.get HTrg  Abteil lchbAtrgSteg))
	(setq abtlLchbWinkel_HT (Anbauteil.get lb_ht_abtl Winkel))
;	(AlertBox abtlLchbWinkel_HT)
	(setq nw (+ abtlLchbWinkel_HT 180.0))
;	(Anbauteil.set lb_ht_abtl (Winkel nw))

    (setq Winkel_FahLchb_HTrg (Connect.get CastaData r-atrgewnkl_flansch))

    (setq lchb_RWinkel Winkel_FahLchb_HTrg)

;	(if (= (Connect.get CastaData amhtoberflansch  )  1) (AlertBox "amhtoberflansch"))
;	(if (= (Connect.get CastaData amhtUnterflansch  )  1) (AlertBox "amhtUnterflansch"))

	(if (= (Connect.get CastaData at-von-unten)  1) (progn
		(if (= (Connect.get CastaData sAtr-lHtr)  1) (progn
			(Anbauteil.set lb_ht_abtl (winkel   (+ lchb_RWinkel 180.0)))
		))
		(if (= (Connect.get CastaData sAtr-lHtr) -1) (progn
			(Anbauteil.set lb_ht_abtl (winkel  (- 180.0 lchb_RWinkel)))
		))
	))
	(if (= (Connect.get CastaData at-von-oben)  1) (progn
		(if (= (Connect.get CastaData sAtr-lHtr)  1) (progn
			(Anbauteil.set lb_ht_abtl (winkel   lchb_RWinkel))
		))
		(if (= (Connect.get CastaData sAtr-lHtr) -1) (progn
			(Anbauteil.set lb_ht_abtl (winkel  (+ (- 180.0 lchb_RWinkel) 180.0)))
		))
	))

	(setq checkLchb_RWinkel (Anbauteil.get lb_ht_abtl Winkel))
	(if (> checkLchb_RWinkel 90.0) (if (< checkLchb_RWinkel 270.0) (progn
		(setq h_AT (Traeger.get Tr_ID h))
		(setq dv_Lchb (Anbauteil.get lb_ht_abtl delta_V))
		(setq dv_Lchb_Neu (- dv_Lchb h_AT))
		(Anbauteil.set lb_ht_abtl (delta_V dv_Lchb_Neu))
	)))
	(setq SWinkel 0.0)
	(setq chFlag 0)
	(if (= chFlag 0) (if (> checkLchb_RWinkel 270.0) (setq chFlag 1 	SWinkel (- checkLchb_RWinkel 270.0))))
	(if (= chFlag 0) (if (> checkLchb_RWinkel 180.0) (setq chFlag 2 	SWinkel (- 270.0 checkLchb_RWinkel))))
	(if (= chFlag 0) (if (> checkLchb_RWinkel  90.0) (setq chFlag 3 	SWinkel (- checkLchb_RWinkel 90.0))))
	(if (= chFlag 0) (if (> checkLchb_RWinkel   0.0) (setq chFlag 4 	SWinkel (- 90.0 checkLchb_RWinkel))))

	(setq delta_LR_HT (Traeger.get HTrg delta_LR))
	(if (/= delta_LR_HT 0) (progn
		(setq delta_LR_HT (* 1.0 delta_LR_HT))
		(setq cosW (cos (/ (* PI SWinkel) 180.0)))
		(setq dv_aus_dlr_HT (* cosW delta_LR_HT))

		; Korrektur, weil wir den Winkel umgesetzt haben.
		(if (= chFlag 3) (setq dv_aus_dlr_HT (- dv_aus_dlr_HT)))
		(if (= chFlag 4) (setq dv_aus_dlr_HT (- dv_aus_dlr_HT)))
		
		(setq dv_Lchb (Anbauteil.get lb_ht_abtl delta_V))
		(setq dv_Lchb_Neu (+ dv_Lchb dv_aus_dlr_HT))
		(Anbauteil.set lb_ht_abtl (delta_V dv_Lchb_Neu))
	))


)
(defun setze_Blech_seitlich ()

     ; Anbauteile ermitteln -----------------------
    (setq abtl_Fahne     (Traeger.get HTrg ABTeil bFahnenbl))
    (setq abtl_Lchb_Htrg (Traeger.get HTrg ABTeil lchbAtrgSteg))
    ; ---------------------------------------------
    (setq delta_Lr_HT (Traeger.get HTrg  delta_LR))
    (setq delta_Lr_HT (* 1.0 delta_Lr_HT))
    ; ---------------------------------------------
    (setq delta_Lr_AT (Traeger.get Tr_ID delta_LR)
          delta_V_AT  (Traeger.get Tr_ID delta_V)
          h_Atrg      (Traeger.get Tr_ID h)
    	  s_Atrg      (Traeger.get Tr_ID s)
    )
    (setq delta_Lr_AT (* 1.0 delta_Lr_AT)
          delta_V_AT  (* 1.0 delta_V_AT)
	)
	(setq qsform_at	(Traeger.get Tr_ID qsform))
    ; ---------------------------------------------
	(setq dp (Blech.get bFahnenbl dp))
	(setq blWinkel (Anbauteil.get abtl_Fahne Winkel))


	(setq lokal_Blech_LR (* 0.5 (+ s_ATrg dp)))
    (if (= qsform_at "U") 
        (setq lokal_Blech_LR (+ (* 0.5 s_ATrg) dp))
    )
	; seitliche Verschiebung des AT
    (setq lokal_Blech_LR (+ lokal_Blech_LR delta_Lr_AT))
	;seitliche Verschiebung des HT
	(setq cosW (cos (/ (* PI blWinkel) 180.0)))
	(setq dlr_Anteil_HT (* cosW delta_Lr_HT))
	
	(setq lokal_Blech_LR (- lokal_Blech_LR dlr_Anteil_HT))

	; ----------------------------
	(setq sinW (sin (/ (* PI blWinkel) 180.0)))
	(setq dv_Anteil_HT (* sinW delta_Lr_HT))
	
;	(AlertBox blWinkel)
	(setq lokal_Blech_dOK delta_V_AT)
	(if (<  blWinkel  0.0) (if (= (Connect.get CastaData vAtr-sHtr)  1) (setq lokal_Blech_dOK (- delta_V_AT))))
	(if (>= blWinkel  0.0) (if (= (Connect.get CastaData vAtr-sHtr) -1) (setq lokal_Blech_dOK (- delta_V_AT))))

	(setq lokal_Blech_dOK (- lokal_Blech_dOK dv_Anteil_HT))

	
    (Blech.set bFahnenbl
    		(dOK      lokal_Blech_dOK)
    		(delta_lr lokal_Blech_LR)
    )
)