; $	G(24) HT	QT(IUK)		AF(F)		P(EZ)
; $ G(24) AT	QT(IKT)		AF(K)		P(E)
; $	G(24) AE	V(-)		H(-)		R(-)
; $	G(26) HT	QT(IUK)		AF(F)		P(EZ)
; $ G(26) AT	QT(IKT)		AF(K)		P(E)
; $	G(26) AE	V(-)		H(-)		R(-)
; $	HT	QT(IUK)		AF(F)		P(EZ)
; $	AT	QT(IUKR)	AF(IKT)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	letzte nderung: 	13.04.2006
;	letzte Prfung:		13.04.2006
;	
;	Zulassung fr T-Profile 02.03.2022
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
)

(defun init-connection ()
  
  (print "*clear*")  
  (connect.showattributes CastaData)


  (print "in init-connection uz_an_Stz-Flansch");
  (sichereAktuellesTrgEnde)
  (init-traegerenden)				; hier werden die Traegerenden gestutzt
						; eventuell spter alte Werte merken,
						; falls Ende schon bearbeitet wurde.
;  (print "*clear*")
  (calcAnvoutung_aus_TrgEnde)	
						
;  (SchweissProfil_Einsetzen)			; Schweiprofil hier verankern
)
; ----------------------------------------------------
(defun sichereAktuellesTrgEnde ()
    (getTrgEndeValues)
    (setq	VWinkel_1 	VWinkel
    		HWinkel_1 	HWinkel
    		delta_L_1	delta_L
    		VScherLng_1	VScherLng	
    )
)
; ----------------------------------------------------
(defun calcAnvoutung_aus_TrgEnde ()
    (getTrgEndeValues)
    (berechneSP_Steg)
    (setq h_AT 		(Traeger.get Tr_ID h)
    	  h_AT_halbe	(* 0.5 h_AT)
    )

;   (if (< x_SP 0) (setq x_SP (- x_SP)))
    (setq dh (+ h_AT_halbe x_SP))

    (print "Schnittpunkt:") (print x_SP)
	(print dh)
    (if (= (Connect.get CastaData amhtOberFlansch) 1) (progn
    	(if (= (Connect.get CastaData VAtr-VHtr) 1) (progn
    	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
	    	(setq dh (- h_AT_halbe x_SP))	; checken, wann das erfolgen soll.
    	    ))
    	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    	(setq dh (+ h_AT_halbe x_SP))	; checken, wann das erfolgen soll.
    	    ))
    	))
    	(if (= (Connect.get CastaData VAtr-VHtr) -1) (progn
    	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
	    	(setq dh (+ h_AT_halbe x_SP))	; checken, wann das erfolgen soll.
    	    ))
    	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    	(setq dh (- h_AT_halbe x_SP))	; checken, wann das erfolgen soll.
    	    ))
    	))
    ))

    (if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
    	(if (= (Connect.get CastaData VAtr-VHtr) 1) (progn
    	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
	    	(setq dh (+ h_AT_halbe x_SP))	; checken, wann das erfolgen soll.
    	    ))
    	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    	(setq dh (- h_AT_halbe x_SP))	; checken, wann das erfolgen soll.
    	    ))
    	))
    	(if (= (Connect.get CastaData VAtr-VHtr) -1) (progn
    	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
	    	(setq dh (- h_AT_halbe x_SP))	; checken, wann das erfolgen soll.
    	    ))
    	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    	(setq dh (+ h_AT_halbe x_SP))	; checken, wann das erfolgen soll.
    	    ))
    	))
    ))


    (setq h1 (* dh (tan (/ (* PI (- VWinkel_1 90.0)) 180.0))))
    (setq h2 (* dh (tan (/ (* PI (- VWinkel   90.0)) 180.0))))

    
    (setq delta_Lng (- h1 h2))
    (print h1)
    (print h2)
    (print dh)
    (print delta_Lng)

    (setze_Vouten_Parameter delta_Lng dh)


    ; Alten Trgerendewerte zurck kopieren
    (TrEnde.set trgEnde		(V_Winkel 	VWinkel_1)
    			 	(H_Winkel 	HWinkel_1)
    			 	(delta_L	delta_L_1)
    )
)
(defun setze_Vouten_Parameter (LV1 HV1)

    (print "---------------------------")
  (setq v_unten 0 v_oben 0)

  (if (= (Connect.get CastaData vAtr-vHtr) 1) (progn
    (if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    	(print "Fall 1  -ok-")
			(setq v_oben 1)
	    	(TrEnde.set trgEnde 	
						(l_voute_oben (- LV1)) 
	    				(h_voute_oben (- HV1))
	    	)
	    ))
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
	    	(print "Fall 2  -ok-")
			(setq v_oben 1)
	    	(TrEnde.set trgEnde 	
						(l_voute_oben    LV1)
	    				(h_voute_oben (- HV1))
	    	)
	    ))
    ))
    (if (= (Connect.get CastaData amhtOberFlansch) 1) (progn
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    	(print "Fall 3 -ok-")
			(setq v_unten 1)
	    	(TrEnde.set trgEnde 	
						(l_voute_unten   LV1)
	    				(h_voute_unten (- HV1))
	    	)
	    ))
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
	    	(print "Fall 4  -ok-")
			(setq v_unten 1)
	    	(TrEnde.set trgEnde 	
						(l_voute_unten (-   LV1))
	    				(h_voute_unten (- HV1))
	    	)
	    ))
    ))
  ))
  (if (= (Connect.get CastaData vAtr-vHtr) -1) (progn
    (if (= (Connect.get CastaData amhtUnterFlansch) 1) (progn
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    	(print "Fall 5")
			(setq v_unten 1)
	    	(TrEnde.set trgEnde 	
						(l_voute_unten    LV1) 
	    				(h_voute_unten (- HV1))
	    	)
	    ))
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
	    	(print "Fall 6")
			(print HV1) (print LV1)
			(setq v_unten 1)
	    	(TrEnde.set trgEnde 	
						(l_voute_unten (- LV1))
	    				(h_voute_unten (- HV1))
	    	)
	    ))
    ))
    (if (= (Connect.get CastaData amhtOberFlansch) 1) (progn
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
	    	(print "Fall 7 -ok-")
			(setq v_oben 1)
	    	(TrEnde.set trgEnde 	
						(l_voute_oben (- LV1))
	    				(h_voute_oben (- HV1))
	    	)
	    ))
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
	    	(print "Fall 8")
			(setq v_oben 1)
	    	(TrEnde.set trgEnde 	
						(l_voute_oben    LV1)
	    				(h_voute_oben (- HV1))
	    	)
	    ))
    ))

   	(TrEnde.set trgEnde  (xakl	       1))
	
	(setq VersuchRunden 0)
	(if (= VersuchRunden 1) (progn
		(if (= v_unten 1) (progn
			(setq lv (TrEnde.get trgEnde l_voute_unten)
				  hv (TrEnde.get trgEnde h_voute_unten)
			)
			(setq lv (+ lv 1) hv (- hv 0))
			(TrEnde.set trgEnde (l_voute_unten lv) (h_voute_unten hv))
		))
		(if (= v_oben 1) (progn
			(setq lv (TrEnde.get trgEnde l_voute_oben)
				  hv (TrEnde.get trgEnde h_voute_oben)
			)
			(setq lv (+ lv 1) hv (- hv 0))
			(TrEnde.set trgEnde (l_voute_oben lv) (h_voute_oben hv))
		))
	))
  ))
  
    (print VWinkel)
    (print VWinkel_1)
    (print "---------------------------")

)


; ----------------------------------------------------
(defun getTrgEndeValues ()
    (if (= (Connect.get CastaData linkesEnde) 1)  (setq trgEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData rechtesEnde) 1) (setq trgEnde (Traeger.get Tr_ID rechts)))
    
    (setq	VWinkel 	(TrEnde.get trgEnde V_Winkel)
    		HWinkel 	(TrEnde.get trgEnde H_Winkel)
    		delta_L		(TrEnde.get trgEnde delta_L)
    		VScherLng	(TrEnde.get trgEnde VScherl)
    )
)
; ----------------------------------------------------
(defun SchweissProfil_Einsetzen ()

;   (print "*clear*")
	; Anschlussdaten ...
	; X-Position
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	; Rotationswinkel des AT
	(setq rWinkel 0.0)
	(setq rWinkel_AT	(Connect.get CastaData r-atrgewnkl_flansch))

	(setq	dv_HT 	(Traeger.get HTrg delta_V)
		dlr_HT	(Traeger.get HTrg delta_LR)
	)
	(setq	dv_AT 	(Traeger.get Tr_ID delta_V)
		dlr_AT	(Traeger.get Tr_ID delta_LR)
	)

	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtOberflansch )   1) (setq rWinkel    (- rWinkel_AT 90.0)))
	    (if (= (Connect.get CastaData amHtUnterflansch )  1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtOberflansch )   1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	    (if (= (Connect.get CastaData amHtUnterflansch )  1) (setq rWinkel    (- rWinkel_AT 90.0)))
	))

	(setq rWinkel_Abtl rWinkel)
	(if (= (Connect.get CastaData linkesEnde)     1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)   1)  (setq rWinkel_Abtl (- 180.0 rWinkel)))
	))
	(if (= (Connect.get CastaData rechtesEnde)     1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)    -1) (setq rWinkel_Abtl (- 180.0 rWinkel)))
	    	(setq dlr_HT (- dlr_HT))
	))


	(if (= (Connect.get CastaData vAtr-lHtr)     1) (setq dlr_HT (- dlr_HT)))

	(if (= (Connect.get CastaData amHtOberflansch)  1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel_Abtl _oberflansch_))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel_Abtl _unterflansch_))
	
	; Anbauteil ermitteln
	(setq abtl_Trg (Traeger.get HTrg abTeil Tr_ID))
	(if (= (Connect.get CastaData linkesEnde)     1) (Anbauteil.set abtl_Trg (addflag  _endelinks_)))
	(if (= (Connect.get CastaData rechtesEnde)    1) (Anbauteil.set abtl_Trg (addflag _enderechts_)))
	


	; Winkel berechnen fr die Verschiebungen des AT
	(setq rWinkel2 (- 90.0 rWinkel_Abtl))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (setq rWinkel2 (+ 90.0 rWinkel_Abtl)))

	(setq sinWnk  (sin (* PI (/ rWinkel2 180.0))))
	(setq cosWnk  (cos (* PI (/ rWinkel2 180.0))))

	; Winkel-Check	
	(print rWinkel_Abtl)
	(print rWinkel)
	(print rWinkel2)

	(setq delta_V_Abtl 0.0)			; ---------------------------------------------
	(if (= (Connect.get CastaData amHtOberflansch)  1) (setq delta_V_Abtl    dv_AT))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (setq delta_V_Abtl (- dv_AT)))
	
	(setq delta_LR_Abtl 0.0)		; ---------------------------------------------
	(if (= (Connect.get CastaData linkesEnde)  1) (setq delta_LR_Abtl    dlr_AT))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq delta_LR_Abtl (- dlr_AT)))

	(print delta_LR_Abtl)
	(print delta_V_Abtl)

	; Winkelfunktioen auf Lokalverschiebungen anwenden 
	(setq delta_LR_Abtl_Set (- (* cosWnk delta_V_Abtl)  (* sinWnk delta_LR_Abtl)))
	(setq delta_V_Abtl_Set  (+ (* cosWnk delta_LR_Abtl) (* sinWnk delta_V_Abtl)))

	(print delta_LR_Abtl_Set)
	(print delta_V_Abtl_Set)

	; Horizontalverschiebung des HT bercksichtigen
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
	    (if (= (Connect.get CastaData satr-shtr)   1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dlr_HT)))
	    (if (= (Connect.get CastaData satr-shtr)  -1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dlr_HT)))
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
	    (if (= (Connect.get CastaData satr-shtr)  -1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dlr_HT)))
	    (if (= (Connect.get CastaData satr-shtr)   1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dlr_HT)))
	))

	; letztendich im Anbauteil speichern
	(Anbauteil.set abtl_Trg (delta_V  delta_V_Abtl_Set))
	(Anbauteil.set abtl_Trg (delta_LR delta_LR_Abtl_Set))

)

(defun berechneSP_Steg ()
    (setq	dl_1 delta_L_1
    		dl_2 delta_L
    		Alfa_1 (- 90.0 VWinkel_1)
    		Alfa_2 (- 90.0 VWinkel)
    )
	(print dl_1) (print dl_2)
    (print Alfa_1) (print Alfa_2)
    
    (setq m1 (tan (/ (* PI Alfa_1) 180.0)))
    (setq m2 (tan (/ (* PI Alfa_2) 180.0)))

    (setq iTest (* 10000 (- m1 m2)))
    
    (if (= iTest 0) (progn
    		(setq x_SP 0.0 y_SP 0.0)
    	)
    	(progn

	    (print "-----------------------------------")
	    (print Alfa_1)
	    (print Alfa_2)
	    (print m1)
	    (print m2)
	    (print dl_1)
	    (print dl_2)
	
	
	    ; x_SP - x-Schnittpunkt - Richtung Unterflansch ist positiv von Mittelachse
	    ; y_SP - y-Schnittpunkt - lngs des Trgers, negativ ist Trger krzen, positiv verlngern.
	
	    (setq x_SP (/ (- dl_1 dl_2) (- m1 m2)))
	    (setq y_SP (- (* m1 x_SP) dl_1))
	
	    (print x_SP)
	    (print y_SP)
	    (print "-----------------------------------")
	)
    )


)

(defun berechneSP_Steg_Alt ()
   
    (setq dl_Diff 0.0)
    (if (< delta_L 0) (progn
        (if (> delta_L_1 0) (setq dl_Diff (- delta_L_1 delta_L)))
    ))
    (if (< delta_L_1 0) (progn
        (if (> delta_L 0) (setq dl_Diff (- delta_L delta_L_1)))
    ))
    
    (setq dl_Diff (- delta_L delta_L_1))
    (if (< dl_Diff      0) (setq dl_Diff      (- dl_Diff)))

    (setq h_AT 		(Traeger.get Tr_ID h)
    	  h_AT_halbe	(* 0.5 h_AT)
    )


    (setq Alfa_1   (- 90.0 VWinkel))
    (setq Alfa_2   (- 90.0 VWinkel_1))
    (setq sinAlfa_1 (sin (/ (* PI Alfa_1) 180.0)))
    (setq sinAlfa_2 (sin (/ (* PI Alfa_2) 180.0)))
    (setq tanAlfa_1 (tan (/ (* PI Alfa_1) 180.0)))
    (setq tanAlfa_2 (tan (/ (* PI Alfa_2) 180.0)))
    
    (setq sys_dl_Lng_1 (* h_AT_halbe tanAlfa_1))
    (setq sys_dl_Lng_2 (* h_AT_halbe tanAlfa_2))
    
    
    (setq LngFlansch_1 (* VScherLng   sinAlfa_1))
    (setq LngFlansch_2 (* VScherLng_1 sinAlfa_2))
    (if (< LngFlansch_1 0) (setq LngFlansch_1 (- LngFlansch_1)))
    (if (< LngFlansch_2 0) (setq LngFlansch_2 (- LngFlansch_2)))
    (setq Lng_Fl_Gesamt (+ LngFlansch_1 LngFlansch_2))
    (setq Lng_Fl_Rest   (- Lng_Fl_Gesamt dl_Diff))

    (setq Verhlt (/ Lng_Fl_Gesamt (- Lng_Fl_Gesamt dl_Diff)))
    (setq dl_Erg (* 0.5 VScherLng Verhlt))
    (setq h1 (* 0.5 Verhlt h_AT))
    
    (print "-----------------------------------")
    (print delta_L) (print delta_L_1)
    (print sys_dl_Lng_1) (print sys_dl_Lng_2)
    (print VWinkel)
    (print VWinkel_1)
    (print Alfa_1)
    (print Alfa_2)
    (print LngFlansch_1)
    (print LngFlansch_2)
    (print Lng_Fl_Gesamt)
    (print dl_Diff)
    (print Verhlt)
    (print h1)
    (print dl_Erg)
    (print "-----------------------------------")


)
