(defun load-modules ()
   (load "mod-lochbild")
	 (load "mod-utils")
)

(defun init-connection ()
	(print "*clear*")
	(print ">>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>")
	; (connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	;(simpleTrim) ; AF - Mrz 2008 
	
	(setConnection)
)






; ****************************************************************************************
; Erzeugt die Verbindung
; ****************************************************************************************
(defun setConnection ()
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGE VERBINDUNG")
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))

	; Objekte erzeugen
	; ---------------------------------------------
;	(setq atKpl					(Blech.Create))
;	(setq kpl_lb				(Lochbild.Create))
	
;	(Connect.storeAnschlObjs CastaData atKpl kpl_lb)
	
	(kuerzeAtEnde)
	
;	(calcAtKpl atKpl)
;	(createAtKpl atKpl)
	
;	(calcKplLB kpl_lb)
;	(createKplLB kpl_lb)
)

; ****************************************************************************************
; Krzt das Trgerende
; ****************************************************************************************
(defun kuerzeAtEnde ()
	(print ">-------------------------------------------------------------------------------")
	(print "KUERZE TRAEGERENDE")
	; erstmal alles zurcksetzen
	(resetAtEnde)
	
	(Connect.showAttributes CastaData)
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))

	(setq	xPos_AT (Connect.get CastaData xPos_AT)
				VWinkel (Connect.get CastaData v-atrgewnkl_steg)
				HWinkel (Connect.get CastaData h-atrgewnkl_steg)
	)
	
	(setq	xPos_AT 	(Connect.get CastaData xPos_AT)
		VWinkel 	(Connect.get CastaData v-atrgewnkl_kopf)
		HWinkel		(Connect.get CastaData h-atrgewnkl_kopf)
	)
	
	
	(setq	TrgLaenge (Traeger.get Tr_ID syslng))

	
	(if (= (Connect.get CastaData linkesEnde)  1) (setq deltaL xPos_AT))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq deltaL (- TrgLaenge xPos_AT)))
	
	(setq dl_Additional (Connect.get CastaData additional_delta_l))
	(setq deltaL (+ deltaL dl_Additional))		; neu ab Version 7.01 (Wert additional_delta_l)
	
	(TrEnde.set At_Ende	(delta_l 	 deltaL)
				(V_Winkel	 VWinkel)
				(H_Winkel	 HWinkel)
	)
	
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet die Kopfplatte
; ****************************************************************************************
(defun calcAtKpl (KPL_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTE")
	
	(setq h_at 	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
				t_at	(Traeger.get Tr_ID t)
	)
	
	; Hoehe
	; ---------------------------------------------
	(setq kpl_hp (- h_at t_at))
	(setq kpl_hp_rund (runde kpl_hp auf 5.0))
	
	; Breite
	; ---------------------------------------------
	(setq kpl_bp b_at)
	(setq kpl_bp_rund (runde kpl_bp auf 5.0))
	
	; Dicke
	; ---------------------------------------------
	(setq kpl_dp t_at)
	(setq kpl_dp_rund (runde kpl_dp auf 5.0))
	
	
	; Werte zuweisen
	; ---------------------------------------------
	(Blech.set KPL_ID (hp 	kpl_hp_rund)
										(bp 	kpl_bp_rund)
										(dp 	kpl_dp_rund)
										(dok	5.0)
	)
	
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Erzeugt die Kopfplatte
; ****************************************************************************************
(defun createAtKpl (KPL_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTE")
	(if (= (Connect.get CastaData linkesEnde)  1)	(Traeger.addabtl Tr_ID KPL_ID 0.0 0.0 _fussplattelinks_))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(Traeger.addabtl Tr_ID KPL_ID 0.0 0.0 _fussplatterechts_))
	
	(setq kpl_dp (Blech.get KPL_ID dp))
	
	(TrEnde.ptrim At_Ende kpl_dp)
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet das Kopfplattenlochbild
; ****************************************************************************************
(defun calcKplLB (LCHB_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTENLOCHBILD")
	(Lochbild.set LCHB_ID (Anz_S 		4)
												(Lb_Art   16)
												(Guete   	"4.6")
												(Montage 	_AnkerSchraube_)
	)
	
	(setq h_at 	(Traeger.get Tr_ID h)
				b_at	(Traeger.get Tr_ID b)
				r_at	(Traeger.get Tr_ID r)
				s_at	(Traeger.get Tr_ID s)
	)
	
	(calcSchraube kpl_dp) ;--> S_Bez
	
	(Lochbild.set LCHB_ID (S_Bez S_Bez))
	
	; e0
	; ---------------------------------------------
	(setq e0 (* 0.5 h_at))
	(setq e0_rund (runde e0 auf 5.0))
	
		
	; w0
	; ---------------------------------------------
	;(setq helpVar (+ (* 2.0 r_at) (* 0.5 (- b_at s_at))))
	;(setq w0_rund (runde helpVar auf 5.0))
	(setq w0 (+ (* 0.5 (- b_at s_at)) s_at))
	(setq w0_rund (runde w0 auf 5.0))
	
	; Laenge
	; ---------------------------------------------
	(calcBohrLochTiefe) ;-->vba_min_tiefe
	
	(setq vb_tiefe (+ vba_min_tiefe kpl_dp))
	(print vb_tiefe)
	
	
	(Lochbild.set LCHB_ID (e0 		e0_rund)
												(w0			w0_rund)
												(Laenge vb_tiefe)
												
	)
	
	(print "<-------------------------------------------------------------------------------")
)


; ****************************************************************************************
; Erzeugt das Kopfplattenlochbild
; ****************************************************************************************
(defun createKplLB (LCHB_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGE KOPFPLATTENLOCHBILD")
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addabtl Tr_ID LCHB_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addabtl Tr_ID LCHB_ID 0.0 0.0 _kpllochbildrechts_)
	)
		
	(setq Abtl_AnkLchb (traeger.get Tr_ID ABTeil LCHB_ID))
  (Anbauteil.set Abtl_AnkLchb (Master 1))
	(print "<-------------------------------------------------------------------------------")
)


(defun calcBohrLochTiefe ()
	(setq vba_min_tiefe 100.0)
	
	(if (= S_Bez "M8")	(setq vba_min_tiefe 80.0))
	(if (= S_Bez "M10")	(setq vba_min_tiefe 90.0))
	(if (= S_Bez "M12")	(setq vba_min_tiefe 110.0))
	(if (= S_Bez "M16")	(setq vba_min_tiefe 125.0))
	(if (= S_Bez "M20")	(setq vba_min_tiefe 170.0))
	(if (= S_Bez "M24")	(setq vba_min_tiefe 210.0))
	(if (= S_Bez "M27")	(setq vba_min_tiefe 250.0))
	(if (= S_Bez "M30")	(setq vba_min_tiefe 280.0))
)