

; ---------------------------------------------------------------------
; $$$  Prototyp:
; $$$  Unterzug an Sttze mit einer Fahne angeschlossen   $$$
; ---------------------------------------------------------------------
; eventuell muss man Anschlsse an Sttzensteg und Sttzenflansch
; noch trennen - je nachdem, ob es bersichtlich genug bleibt.
; derzeit nur rechtwinklige Verbindungen mglich
; Blechgren mssen sich aus dem magebenden Trgerquerschnitt herleiten lassen
; auch Verschiebung dOK - delta_lr ist hier mal provisorisch eingebaut
; Ausklinkungen oben und/oder unten knnen erforderlich sein.
; ...
(defun load-modules ()
	(print "Anschluss:")
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(print "am HT-Oberflansch")
			(load "mod-endinit-uz-stzflansch-abstand")
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(print "am HT-Unterflansch")
			(load "mod-endinit-uz-stzflansch-abstand")
		) 
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(print "am HT Steg links")
			(load "mod-endinit-uz-stzsteg") 
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(print "am HT Steg rechts")
			(load "mod-endinit-uz-stzsteg")
		) 
	)
  (load "mod-lochbild")
)

(defun init-connection ()

	(print "in init-connection uz_an_stz mit Fahne .........................")
	(if (= (Connect.get CastaData amHtSteg) 1)
  	(init-traegerenden 10)	; hier werden die Traegerenden gestutzt
  )
  (if (= (Connect.get CastaData amHtFlansch) 1)
  	(init-traegerenden)	; hier werden die Traegerenden gestutzt
  )
  (print "nach init-traegerenden")
  ;(connect.showattributes CastaData)

	(setq bFahnenbl (blech.create))
	(setq lchbAtrgSteg (Lochbild.create))
	(Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg)
	(print "Fahnenblech erzeugt")
  (Blech.set bFahnenbl (dp 10) (hp 200) (bp 110) (dOK 0))
	(print "Default Blechdaten")
  (setq XPos (Connect.get CastaData XPos_HT))
  (print XPos)
  
  (setq abstzumSteg 10)
  
  ; Anschlsse am Flansch des Haupttrgers
  (if (= (Connect.get CastaData amHtOberflansch) 1) 
  	(progn
  		(print "Anschluss am Oberflansch")
			(traeger.addabtl hTrg bFahnenbl XPos 0.0 _fahnenblech_of_)
			(calcAndSetBlechdaten bFahnenbl)
   	)
  )
  (if (= (Connect.get CastaData amHtUnterflansch) 1) 
  	(progn
  		(print "Anschluss am Unterflansch")
			(traeger.addabtl hTrg bFahnenbl XPos 0.0 _fahnenblech_uf_)
			(calcAndSetBlechdaten bFahnenbl)
   	)
  )
  ; Anschlsse am Steg des Haupttrgers
  (if (= (Connect.get CastaData amHtStegLinks) 1) 
  	(progn
  		(print "Anschluss am Steg links")
			(traeger.addabtl hTrg bFahnenbl XPos 0.0 _fahnenblech_steg_li_)
			(calcAndSetBlechdaten bFahnenbl)
   	)
  )
  (if (= (Connect.get CastaData amHtStegRechts) 1) 
  	(progn
  		(print "Anschluss am Steg rechts")
			(traeger.addabtl hTrg bFahnenbl XPos 0.0 _fahnenblech_steg_re_)
			(calcAndSetBlechdaten bFahnenbl)
   	)
  )


	(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn			
					
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrLinks 2)
					(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrRechts -2)
					(setq trgLaenge (Traeger.get Tr_ID syslng))
					(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
				)
			)
   

)


; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten (fahnenblech)
	(print "------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN")
	
	(setq hc_trg 				(Traeger.get Tr_ID hc)
				delta_v_trg 	(Traeger.get Tr_ID delta_v)
				delta_lr_trg	(Traeger.get Tr_ID delta_lr)
				rwnkl_trg			(Traeger.get Tr_ID r_winkel)
				tSteg 				(Traeger.get Tr_ID s)
				qsform				(Traeger.get Tr_ID qsform)
	)
	(print delta_v_trg)
	(print delta_lr_trg)
	
	(setq s_htrg 				(Traeger.get Htrg s)
				delta_v_htrg	(Traeger.get Htrg delta_v)
				delta_lr_htrg	(Traeger.get Htrg delta_lr)
	)
	
	(setq dp (Blech.get bFahnenbl dp))
	
	(if (= rwnkl_trg 180.0) (setq delta_v_trg (- delta_v_trg)))
	
	(print delta_lr_trg)
	(print delta_lr_htrg)
	
	;(setq delta_lr_soll (+ (* 0.5 (+ dp tSteg)) delta_lr_trg))
	(setq delta_lr_soll (* 0.5 (+ dp tSteg))) 
	
	(if (= qsform "U")
  	(progn
  		(setq delta_lr_soll (+ (* 0.5 dp) tSteg)) 
  	)
  )
	
	(print delta_lr_soll)
  	
  ; Verschiebung des AT in delta_lr-Richtung	
  (if (/= delta_lr_trg 0.0)
  	(progn
	  	(if (= (Connect.get CastaData amHtUnterflansch) 1)
	  		(progn
		  		(if (= (Connect.get CastaData LinkesEnde) 1)
		  			(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg))
		  		)
		  		(if (= (Connect.get CastaData RechtesEnde) 1)
		  			(setq delta_lr_soll (- delta_lr_soll delta_lr_trg))
		  		)
		  	)
		  )
		  (if (= (Connect.get CastaData amHtOberflansch) 1)
	  		(progn
		  		(if (= (Connect.get CastaData LinkesEnde) 1)
		  			(setq delta_lr_soll (- delta_lr_soll delta_lr_trg))
		  		)
		  		(if (= (Connect.get CastaData RechtesEnde) 1)
		  			(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg))
		  		)
		  	)
		  )
		  (if (= (Connect.get CastaData amHtStegLinks) 1)
	  		(progn
		  		(if (= (Connect.get CastaData LinkesEnde) 1)
		  			(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg))
		  		)
		  		(if (= (Connect.get CastaData RechtesEnde) 1)
		  			(setq delta_lr_soll (- delta_lr_soll delta_lr_trg))
		  		)
		  	)
		  )
		  (if (= (Connect.get CastaData amHtStegRechts) 1)
	  		(progn
		  		(if (= (Connect.get CastaData LinkesEnde) 1)
		  			(setq delta_lr_soll (- delta_lr_soll delta_lr_trg))
		  		)
		  		(if (= (Connect.get CastaData RechtesEnde) 1)
		  			(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg))
		  		)
		  	)
		  )
  	)
  )
  (print delta_lr_soll)
  
  ; Verschiebung des HT in delta_lr-Richtung	
  (if (/= delta_lr_htrg 0.0)
  	(progn
  		(if (= (Connect.get CastaData amHtUnterflansch) 1)
  			(progn
		  		(if (= (Connect.get CastaData LinkesEnde) 1)
		  			(setq delta_lr_soll (- delta_lr_soll delta_lr_htrg))
		  		)
		  		(if (= (Connect.get CastaData RechtesEnde) 1)
		  			(setq delta_lr_soll (- delta_lr_soll delta_lr_htrg))
		  		)
		  	)
		  )
		  (if (= (Connect.get CastaData amHtOberflansch) 1)
  			(progn
		  		(if (= (Connect.get CastaData LinkesEnde) 1)
		  			(setq delta_lr_soll (- delta_lr_soll delta_lr_htrg))
		  		)
		  		(if (= (Connect.get CastaData RechtesEnde) 1)
	  			(setq delta_lr_soll (- delta_lr_soll delta_lr_htrg))
		  		)
		  	)
		  )
  	)
  ) 
  (print delta_lr_soll)
  
  ;Korrektur bei Rotation des AT
	(print "--------------- Korrektur ----------------------")
	(print delta_lr_htrg)
	(print rwnkl_trg)
	
		
	(setq tanRW (tan (/ (* PI rwnkl_trg) 180.0)))
	(setq cosRW (cos (/ (* PI rwnkl_trg) 180.0)))
	
	(print tanRW)
	(print cosRW)
	
	(setq help_1 (* 0.5 (+ tSteg dp)))
	(print help_1)
	
	(setq help_2 (/ delta_lr_htrg cosRW))
	(print help_2)
	
	(setq xPos_korr (* delta_lr_htrg tanRW))
	(print xPos_korr)
	
	; delta_lr korregieren
	(if (/= delta_lr_htrg 0.0)
		(progn
			(if (/= delta_lr_trg 0.0)
				(progn
					(setq delta_lr_soll (- (- help_2 help_1)))
					(if (= (Connect.get CastaData amHtUnterflansch) 1)
						(progn
							(if (= (Connect.get CastaData linkesEnde) 1)
								(progn
									(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg))
									(print delta_lr_soll)
								)
							)
							(if (= (Connect.get CastaData rechtesEnde) 1)
								(progn
									(setq delta_lr_soll (- delta_lr_soll delta_lr_trg))
									(print delta_lr_soll)
								)
							)
						)
					)
					(if (= (Connect.get CastaData amHtOberflansch) 1)
						(progn
							(if (= (Connect.get CastaData linkesEnde) 1)
								(progn
									(setq delta_lr_soll (- delta_lr_soll delta_lr_trg))
									(print delta_lr_soll)
								)
							)
							(if (= (Connect.get CastaData rechtesEnde) 1)
								(progn
									(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg))
									(print delta_lr_soll)
								)
							)
						)
					)
				)
				(progn
					(setq delta_lr_soll (- (- help_2 help_1)))
				)
			)
		)
	)
					
				
	;xPos korregieren	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(setq xPos (+ xPos xPos_korr))
				  (print xPos)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(setq xPos (- xPos xPos_korr))
				  (print xPos)
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(setq xPos (- xPos xPos_korr))
				  (print xPos)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(setq xPos (+ xPos xPos_korr))
				  (print xPos)
				)
			)
		)
	)
  	
  (print delta_lr_soll)	
  	
  (setq abTeil_fahne (Traeger.get Htrg abteil bFahnenbl))
	
	
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn	
					(Anbauteil.set abTeil_fahne (winkel  rwnkl_trg)
																			(xPos			xPos)
					)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn
					(Anbauteil.set abTeil_fahne (winkel  (- 360.0 rwnkl_trg))
																			(xPos			xPos)
					)
				)
			)	
		)
	)
  (if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn	
					(Anbauteil.set abTeil_fahne (winkel  (- rwnkl_trg))
																			(xPos			xPos)
					)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn
					(Anbauteil.set abTeil_fahne (winkel  (- (- 360.0 rwnkl_trg)))
																			(xPos			xPos)
					)
				)
			)	
		)
	)
  
  
	; BLECHDATEN:
	; -----------
	; dp : Standardmig auf Dicke des Steges des Haupttrgers
	; hp : Standardmig auf hc des Anschlusstrgers
	(Blech.set fahnenblech 	(dp 				s_htrg) 
													(hp 				hc_trg) 
													(dok 				delta_v_trg) 
													(delta_lr 	delta_lr_soll)
	)
	
	
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde LbArt)
	(Lochbild.set Lchb_ID	(lb_art  LbArt)
												(Anz_S    2)
												(Guete   "4.6")
												(e       "100 50 0 0 0 0")
												(w       "0  0")
												
	)
	
	(setq h_trg 	(Traeger.get Tr_ID h))
	
	(setq s_htrg				(Traeger.get Htrg s)
				delta_lr_htrg	(Traeger.get Htrg delta_lr)
				delta_v_htrg	(Traeger.get Htrg delta_v)
				h_htrg				(Traeger.get Htrg h)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l))
		
	; Schraubenbezeichnung
	(set_S_Bez Tr_ID Lchb_ID)
	
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	
	(print e_min)
	(print abstZumSteg)
	(print s_htrg)
	(if (= (Connect.get CastaData amHTSteg) 1)
		(setq abst_lchb_steg (+ abstZumSteg e_min (* 0.5 s_htrg)))
	)
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(setq abst_lchb_steg (+ abstZumSteg e_min (* 0.5 h_htrg)))
	)
	(print abst_lchb_steg)
	(print delta_lr_htrg)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(setq w0 (- abst_lchb_steg delta_lr_htrg))
			(if (< delta_lr_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 auf 5))
				(setq w0_rund (runde w0 ab 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(setq w0 (+ abst_lchb_steg delta_lr_htrg))
			(if (< delta_lr_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(setq w0 (+ abst_lchb_steg delta_v_htrg))
			(if (< delta_v_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	) 
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(setq w0 (- abst_lchb_steg delta_v_htrg))
			(if (< delta_v_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)
	(print w0)
	(print w0_rund)
	;(setq w0_rund (runde w0 auf 5))
	
	(setq hp_blech 	(Blech.get BlechID hp)
				dok_blech	(Blech.get BlechID dok)
	)
	(print hp_blech)
	(print dok_blech)
	
	(setq e0 (- (* 0.5 h_trg) (* 0.25 hp_blech)))
	(setq e1 (* 0.5 hp_blech))
	
	; Klemmlnge
	(setq dp_blech 	(Blech.get BlechID dp))
	(setq s_trg			(Traeger.get Tr_ID s))
	
	; Schraubenkopf
	(calcDxSKopf s_trg dp_blech)
	
	
	(Lochbild.set Lchb_ID (e0 		e0)
												(e1 		e1)
												(w0 		w0_rund)
												(klemml (+ dp_blech s_trg))
												(dxSKopf dxSKopf)
	) 
	
	(print e_min)
	(print w0)
	(setq test (+ (* 2.0 e_min) abstZumSteg))
	(print test)
	; Korregiere Fahnenblech
	(Blech.set BlechID (bp (+ (* 2.0 e_min_rund) abstZumSteg))) 
)

(defun calcDxSKopf (s_trg dp_blech)
	(print "------------------------------------------------------------")
	(print "BERECHNE DXSKOPF")
	(setq qsform (Traeger.get Tr_ID qsform))
	
	(if (= qsform "I")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde) 1)
						(setq dxSKopf (* 0.5 s_trg))
					)
					(if (= (Connect.get CastaData RechtesEnde) 1)
						(setq dxSKopf (+ (* 0.5 s_trg) dp_blech))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde) 1)
						(setq dxSKopf (+ (* 0.5 s_trg) dp_blech))	
					)
					(if (= (Connect.get CastaData RechtesEnde) 1)
						(setq dxSKopf (* 0.5 s_trg))
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde) 1)
						(setq dxSKopf (* 0.5 s_trg))
					)
					(if (= (Connect.get CastaData RechtesEnde) 1)
						(setq dxSKopf (+ (* 0.5 s_trg) dp_blech))
					)
				)
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde) 1)
						(setq dxSKopf (+ (* 0.5 s_trg) dp_blech))	
					)
					(if (= (Connect.get CastaData RechtesEnde) 1)
						(setq dxSKopf (* 0.5 s_trg))
					)
				)
			)
		)
	)
	(if (= qsform "U")
		(progn
			(setq dxSKopf 0)
		)
	)
	
	(print "------------------------------------------------------------")
)