; $	HT	QT(IURK)	AF(FS)		P(EZ)
; $	AT	QT(IUZT)		AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

(defun load-modules ()
	(print "*clear*")
	(print "Anschluss:")
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(print "am HT-Oberflansch")
			(load "mod-endinit-uz-stzflansch-abstand")
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(print "am HT-Unterflansch")
			(load "mod-endinit-uz-stzflansch-abstand")
		) 
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(print "am HT Steg links")
			(load "mod-endinit-uz-stzsteg") 
			(load "mod-multiconnect-stz-steg")
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(print "am HT Steg rechts")
			(load "mod-endinit-uz-stzsteg")
			(load "mod-multiconnect-stz-steg")
		) 
	)
  (load "mod-lochbild")
)

(defun init-connection ()

	(setq LB_DEBUG 0)
	
	(print "--------------------------------------------- Attributes -----------------")
	(connect.showattributes CastaData)
	(checkPosition)

	(if (= isInside 1)
		(progn
			(print "in init-connection uz_an_stz mit Fahne .........................")
			(if (= (Connect.get CastaData amHtSteg) 1)
  			(init-traegerenden 10)	; hier werden die Traegerenden gestutzt
  		)
  		(if (= (Connect.get CastaData amHtFlansch) 1)
  			(init-traegerenden)	; hier werden die Traegerenden gestutzt
  		)
  
  		(setConnection)
  		; (teste_Daten)
  	)
  	(progn
  		(alertBox "Anschluss ist nicht mglich!" "Connection_Not_Possible")
  	)
  )
  
)

(defun setConnection ()
	
	
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; berprfung der Umgebung auf Anbauteile
			(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
		  (print anzAnschl)
		  (if (> anzAnschl 0)
				(checkEnv)
			)
		)
	)
	
	(setq bFahnenbl 		(Blech.create))
	(setq lchbAtrgSteg (Lochbild.create))
	(Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg)
	(print "Fahnenblech erzeugt")
  
 	 (Blech.set bFahnenbl (dp 10) (hp 200) (bp 110) (dOK 0))
	(print "Default Blechdaten")
  
  	(setq	XPos 	(Connect.get CastaData XPos_HT)
  		xPos_at	(Connect.get CastaData xPos_AT)
  	)
  	(print XPos)
  
  	(setq abstzumSteg 10)
	
	; Fahnenblechdaten Berechnen
	(calcFahnenWinkel)
	(calcAndSetBlechdaten bFahnenbl)
  
	; Fahnenblech hinzufgen
	(setFahnenBlechAnbauteil bFahnenbl)
	
	; Lochbild HT
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
	(Traeger.addabtl Htrg lchbAtrgSteg XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
	
	(print "------------------------------------- hier")
	(teste_Daten) ; ------------------------------------------------
	
	;Lochbild AT
	(if (= (Connect.get CastaData LinkesEnde) 1) (progn			
		(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrLinks)
		(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn			
		(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrRechts)
		(traeger.addabtl tr_id lchbAtrgSteg xPos_at 0.0 _WnklSteglochbildRechts_)
	))

;	ist jetzt ganz berflssig - wurde vorher auch nicht ausgefhrt.
;	(dreheFahnenblechAm_HTrg)
	
	(setLochbild lchbAtrgSteg)	
	
	
	; CALLBACKS
	(Blech.set bFahnenbl (formFkt "cb_bFahnenbl"))
)
; ========================================================================================
;	Test-Umgebung --------------------------------------------------------------------
;	Werte abfragen
;	Werte setzen und berprfen
(defun teste_Daten ()

	; LOCHBILD-TEST
	;===================================================================
	(if (= 1 2) (progn
		; (Lochbild.set LOCHB_ID	(e0 0) (e1 20) (e2 80))
		; (Lochbild.set LOCHB_ID	(e2 80))
		(setq e1 (Lochbild.get lchbAtrgSteg e1))
		 (Lochbild.set lchbAtrgSteg	(e1 20) (e2 (- e1 20)))
		; (Lochbild.set LOCHB_ID	(e0 0))
		
		(setq dok_curr (Blech.get bFahnenbl dok))
		; (Blech.set bFahnenbl (dok (- dok_curr 20))) 
		(setq abtl_FBlech (Traeger.get HTrg ABTeil bFahnenbl))
		(setq dv_FahnenBlech (Anbauteil.get abtl_FBlech delta_V))
		; (Anbauteil.set abtl_FBlech (Delta_V -40))

		(setq abtl_FLochb_HT (Traeger.get HTrg ABTeil lchbAtrgSteg))
		(setq abtl_FLochb_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
		
		(setq dv_FahnenLchb_HT (Anbauteil.get abtl_FLochb_HT delta_V))
		(setq dv_FahnenLchb_AT (Anbauteil.get abtl_FLochb_AT delta_V))
		

	))
	; BLECH-TEST
	;===================================================================
	(if (= 1 2) (progn
		(setq h_AT (Traeger.get Tr_ID h))
		; (Blech.set bFahnenbl 
		;		(dok (- (* 0.25 h_AT)))
		;		(hp  (* 0.5 h_AT))
		; ) 
		; (Blech.set bFahnenbl (dok 10.0))
		(setq hp_FahnenBlech (Blech.get bFahnenbl hp))
		(setq bp_FahnenBlech (Blech.get bFahnenbl bp))
		(setq dp_FahnenBlech (Blech.get bFahnenbl dp))
		
	))
	; Lochbild-TEST
	;===================================================================
	(if (= 1 1) (progn
			(setq abtl_lb_ht (Traeger.get Htrg AbTeil lchbAtrgSteg))
			(setq delta_SX_Lochbild (Anbauteil.get abtl_lb_ht delta_sx))
			(print "---------------------------------------------------")
			(print  delta_SX_Lochbild)
	))

)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_bFahnenbl (zp)
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 	(Blech.get bFahnenbl dp))
	    (setq hpAlt 	(Blech.get bFahnenbl hp))
	    (setq dokAlt 	(Blech.get bFahnenbl dok))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
		(setq dpNeu (Blech.get bFahnenbl dp))
		(setq hpNeu (Blech.get bFahnenbl hp))
		(setq dokNeu (Blech.get bFahnenbl dok))
		
		(print dpAlt) (print dpNeu)
		(print hpAlt) (print hpNeu)
		(print dokAlt) (print dokNeu)
		(print "--------------------------------------")
		
		; nderung der Blechdicke
		(if (/= dpAlt dpNeu) (progn
			(setq dpDiff (- dpNeu dpAlt))
			
			(setq	qsform_at	(Traeger.get Tr_ID qsform))
			
			(setq	alteKlemml 	(Lochbild.get lchbAtrgSteg Klemml)
				dxs_alt		(Lochbild.get lchbAtrgSteg dxskopf)
			)
			
			(setq delta_lr_blech_alt (Blech.get bFahnenbl delta_lr))
			(print delta_lr_blech_alt)
			
			(setq klemml_neu	(+ alteKlemml dpDiff))
			
			(setq dxs_neu (+ dxs_alt (* 0.5 dpDiff)))

			; gilt fr alle I-Profile, aber auch Z zB.
			(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))

			(if (= qsform_at "Z") (progn
				(Z_Profile_calc_Blech_nach_Unten)
				(if (= BL_nach_unten 0) (setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff))))
				(if (= BL_nach_unten 1) (setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff))))

				(if (= BL_nach_unten 0) (setq dxs_neu (+ dxs_alt (* 0.5 dpDiff))))
				(if (= BL_nach_unten 1) (setq dxs_neu (+ dxs_alt (* 0.5 dpDiff))))
			))
			
			(if (= qsform_at "U")	(progn
					(if (= (Connect.get CastaData amHtSteg) 1)
						(progn
							(if (= (Connect.get CastaData satr-vhtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-vhtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
						(if (= (Connect.get CastaData amHtFlansch) 1)
						(progn
							(if (= (Connect.get CastaData satr-shtr)  1)	
								(setq delta_lr_blech_neu (+ delta_lr_blech_alt (* 0.5 dpDiff)))
							)
							(if (= (Connect.get CastaData satr-shtr) -1)	
								(setq delta_lr_blech_neu (- delta_lr_blech_alt (* 0.5 dpDiff)))
							)
						)
					)
			))
			
			(print delta_lr_blech_neu)		  	
			
			(Blech.set bFahnenbl (delta_lr delta_lr_blech_neu))
			              
			(Lochbild.set lchbAtrgSteg 	(klemml klemml_neu)
							(dxskopf dxs_neu)
			)    
			
			
			(setq abtl_lb_ht (Traeger.get Htrg AbTeil lchbAtrgSteg))
		  
		  (setq delta_sx_abtl_ht_neu delta_lr_blech_neu )
						
			(Anbauteil.set abtl_lb_ht (delta_sx delta_sx_abtl_ht_neu))
			
			
		))
		    
				
		(if (= 1 2)	(progn		
		; nderung der Blechhhe
		(if (/= hpAlt hpNeu) (progn
		  (setq hpDiff (- hpNeu hpAlt))
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
			(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt (* 0.5 hpDiff))))
			(print delta_v_abtl_at_neu)
			
			(Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
		
		; Verschiebung des Bleches in HT-Lngsrichtung
		(if (/= dokAlt dokNeu) (progn
		  (setq dokDiff (- dokNeu dokAlt))
		  (print dokDiff)
		  
		  (setq abtl_lb_at (Traeger.get Tr_ID AbTeil lchbAtrgSteg))
		  (setq delta_v_abtl_at_alt (Anbauteil.get abtl_lb_at delta_v))
		  (print delta_v_abtl_at_alt)
		  
		  (if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_at_neu (+ delta_v_abtl_at_alt dokDiff)))
			(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_at_neu (- delta_v_abtl_at_alt dokDiff)))
			(print delta_v_abtl_at_neu)
			
			(Anbauteil.set abtl_lb_at (delta_v delta_v_abtl_at_neu))
		))
	))
	))
)



; ------------------------------------------------------------------------
; Setzt das Fahnenblech-Anbauteil
; ------------------------------------------------------------------------
(defun setFahnenBlechAnbauteil (Blech_ID)
	
	(setq XPos 		(Connect.get CastaData XPos_HT))
	
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	
		
	; Anschlsse am Flansch des Haupttrgers
	(if (= (Connect.get CastaData amHtOberflansch)  1) 	(traeger.addabtl hTrg Blech_ID XPos Fahnenwinkel _fahnenblech_of_))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) 	(traeger.addabtl hTrg Blech_ID XPos Fahnenwinkel _fahnenblech_uf_))
  
	; Anschlsse am Steg des Haupttrgers
	(if (= (Connect.get CastaData amHtStegLinks)    1) 	(traeger.addabtl hTrg Blech_ID XPos Fahnenwinkel _fahnenblech_steg_li_))
	(if (= (Connect.get CastaData amHtStegRechts)   1) 	(traeger.addabtl hTrg Blech_ID XPos Fahnenwinkel _fahnenblech_steg_re_))
  
  
	; Anteil delta_v AT
	(setq delta_v_abtl_fb 0)

	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
	    (setq delta_LR_ht (Traeger.get HTrg delta_LR))
	    (setq sinW (sin (/ (* PI FahnenWinkel) 180.0)))
	    (if (/= delta_LR_ht 0.0) (setq delta_v_abtl_fb (- delta_v_abtl_fb (* sinW delta_LR_ht))))
	))
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
	    (setq delta_V_ht (Traeger.get HTrg delta_V))
	    (setq sinW (sin (/ (* PI FahnenWinkel) 180.0)))
	    (if (/= delta_V_ht 0.0) (setq delta_v_abtl_fb (- delta_v_abtl_fb (* sinW delta_V_ht))))
	))
		

  
;	delta-v-Anteil aus Vertikalverschiebung des AT
	(if (/= delta_v_at 0) (setq delta_v_abtl_fb (+ delta_v_abtl_fb delta_v_at)))
  
	(setq abtl_fahne (Traeger.get Htrg AbTeil Blech_ID))
  
	(Anbauteil.set abtl_fahne (delta_v delta_v_abtl_fb))
)




; ------------------------------------------------------------------------
; Passt die Lochbild-Anbauteile an.
; ------------------------------------------------------------------------
(defun setLochbild (LOCHB_ID)
	(print ">-----------------------------------------------------------")
	(print "LOCHBILDER WERDEN ANGEPASST")
	
	
	(setq	h_ht		(Traeger.get Htrg h)
		s_ht		(Traeger.get Htrg s)
		b_ht		(Traeger.get Htrg b)
		delta_v_ht 	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
		qsform_ht	(Traeger.get Htrg qsform)
	)
	
	(setq	delta_v_at	(Traeger.get Tr_ID delta_v)
		h_at		(Traeger.get Tr_ID h)
	)
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht))
	
	(setq dok_blech   (Blech.get bFahnenbl dok))
	
	(setq lb_ht_abtl (Traeger.get Htrg	Abteil LOCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID	Abteil LOCHB_ID))
	
	; s_ht bei Rund- und Kastenprofilen ndern!!!
	(if (= qsform_ht "K") (setq s_ht b_ht))
	(if (= qsform_ht "R") (setq s_ht b_ht))
	
	;(setq e_diff (- (* 0.5 h_trg) (* 0.5 hp_blech) dok_blech))
	
	; Anbauteil HT
	; ----------------------------------------------
	
	; Positionieren (an AT)
	(setq delta_v_abtl_ht (- (* 0.5 h_at)))
	
	; Anteil delta_v AT
	(if (/= delta_v_at 0.0) (setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))

	; Anteil delta_v HT
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
	    (setq sinW (sin (/ (* PI FahnenWinkel) 180.0)))
	    (if (/= delta_v_ht 0.0) (setq delta_v_abtl_ht (- delta_v_abtl_ht (* sinW delta_v_ht))))
	))
	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
	    (setq sinW (sin (/ (* PI FahnenWinkel) 180.0)))
	    (if (/= delta_lr_ht 0.0) (setq delta_v_abtl_ht (- delta_v_abtl_ht (* sinW delta_lr_ht))))
	))

	
	; Anbauteil Lochbild delta_V am HT setzen
	; (setq delta_v_abtl_h delta_v_at)
	(Anbauteil.set lb_ht_abtl (delta_v delta_v_abtl_ht))
		
	
	(print dok_blech)
	
	; Anbauteil AT
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 h_ht) delta_v_ht)))
	(if (= (Connect.get CastaData amHtOberFlansch) 1) 	(setq delta_lr_abtl_at (- (* 0.5 h_ht) delta_v_ht)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_lr_abtl_at (- (* 0.5 s_ht) delta_lr_ht)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 s_ht) delta_lr_ht)))

	; Anmerkung: fr Rohr- und Kastenprofile wird s_ht auf b_ht gesetzt.
	
	(Anbauteil.set lb_at_abtl (delta_lr 	delta_lr_abtl_at))
		
	
	; TEST
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	;(setq LB_DUMMY (Lochbild.create))
	;(Lochbild.copy LB_DUMMY Lchb_ID)
	
	;(Traeger.addabtl Htrg LB_DUMMY 0.0 0.0 _WnklSteglochbildLinks_)
	;(setq AbtlKnoBlLchbAT_DUMMY    (Traeger.get Htrg AbTeil LB_DUMMY))
	;(Anbauteil.set AbtlKnoBlLchbAT_DUMMY 	(Master 1)
	;		(delta_lr delta_lr_abtl_at)
	;		;(delta_v 	delta_v_abtl_at)
	;)
	
	;(Connect.storeAnschlObjs CastaData LB_DUMMY)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	
	
	(Anbauteil.set lb_at_abtl (Master 0))
	(Anbauteil.set lb_ht_abtl (Master 1))
	
	(if (= LB_DEBUG 1) (progn
		(setq dummy (Lochbild.create))
		(Lochbild.copy dummy LOCHB_ID)
						
		(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _WnklSteglochbildLinks_)
    		)
		(if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy xPos_at 0.0 _WnklSteglochbildRechts_)
		)
			
		(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
		(Anbauteil.set dummy_abtl	(Master 1)	
						(delta_lr delta_lr_abtl_at)
		)
	))
	;===================================================================
	
	(print "<-----------------------------------------------------------")
)


; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten (fahnenblech)
	(print "------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN")
	
	(setq	hc_trg 		(Traeger.get Tr_ID hc)
		delta_v_trg 	(Traeger.get Tr_ID delta_v)
		delta_lr_trg	(Traeger.get Tr_ID delta_lr)
		rwnkl_trg	(Traeger.get Tr_ID r_winkel)
		tSteg 		(Traeger.get Tr_ID s)
		t_at	 	(Traeger.get Tr_ID t)
		r_at	 	(Traeger.get Tr_ID r)
		h_at	 	(Traeger.get Tr_ID h)
		qsform		(Traeger.get Tr_ID qsform)
	)
		
	(setq	s_htrg 		(Traeger.get Htrg s)
		delta_v_htrg	(Traeger.get Htrg delta_v)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
	)
	(setq	dok_fahne	(Blech.get fahnenblech dok))
	
	(setq hp_soll hc_trg)
	(if (= qsform "c") (setq hp_soll (-  h_at t_at t_at 10)))
	(if (= qsform "C") (setq hp_soll (-  h_at t_at t_at 10)))
	(if (= qsform "Z") (setq hp_soll (-  h_at t_at t_at 10)))
	(if (= qsform "T") (setq hp_soll (-  h_at t_at r_at  5)))
	
	(setq dok dok_fahne)
	
	(if hsteg  (progn
	    (print hsteg)
	    ; Blechhhe und dok aus Ausklinkung
	    (if (/= hsteg 0.0)	(progn
			(print "hsteg /= 0")
			(if (/= zakl 0.0) (progn				; unten und oben
				(print "zakl /= 0")
				(setq hp_soll hsteg)
				(setq doK 0)
			    )													; nur unten
			    (progn
				(print "zakl = 0")
				(setq hp_soll (- h_at t_at r_at (- h_at hsteg)))
				(setq dok (- (* 0.5 (- hc_trg hp_soll))))
				;(setq dok 0)
			))
		)
		(progn
			(print "hsteg = 0")
			(if (/= zakl 0.0) (progn				; nur oben
				(print "zakl /= 0")
				(setq hp_soll (- h_at t_at r_at zakl))
				(setq dok (+ (* 0.5 (- hc_trg hp_soll))))
			    )													; keine
			    (progn
				(print "zakl = 0")
				(setq doK 0)
			))
	    ))
	))
	(setq dp_blech (runde tSteg auf 5))
	(if (<= dp_Blech 5) (setq dp_Blech 6))		; Mindestdicke des Fahnenblechs
	
	(Blech.set fahnenblech 	(dp 	dp_blech) 
				(hp 	hp_soll)
	)
	
	
	(setq dp (Blech.get bFahnenbl dp))
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< dp tSteg)
		(setq min_bl dp)
		(setq min_bl tSteg)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	(print s_bez)
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set lchbAtrgSteg (S_Bez S_Bez))
	
	;(if (= rwnkl_trg 180.0) (setq delta_v_trg (- delta_v_trg)))
	
	(setq delta_lr_soll (* 0.5 (+ tSteg dp))) 
	
	(setq movePlate_Add 0)				; Initialisieren
	
	(if (= qsform "c") (setq qsform "U"))
	(if (= qsform "C") (setq qsform "U"))
	(if (= qsform "U") (progn
		(setq movePlate_Add 1)
  		(if (= (Connect.get CastaData satr-lhtr-ex)  0)	(progn
	  	    (if (= (Connect.get CastaData satr-vhtr) -1)	(setq movePlate_Add -1))

	  	    (if (= (Connect.get CastaData satr-shtr) -1)	(setq movePlate_Add -1))
  		))
  		(if (= (Connect.get CastaData satr-lhtr-ex)   1) (progn
	  	    (if (= (Connect.get CastaData vatr-vhtr) -1)	(setq movePlate_Add -1))
	  	    (if (= (Connect.get CastaData vatr-vhtr)  0) (progn
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq movePlate_Add -1))
	  	    ))
  		))
  		(if (= (Connect.get CastaData satr-lhtr-ex)  -1) (progn
	  	    (if (= (Connect.get CastaData vatr-vhtr)  1)	(setq movePlate_Add -1))
	  	    (if (= (Connect.get CastaData vatr-vhtr)  0) (progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq movePlate_Add -1))
	  	    ))
  		))
  	))

	; Ermittlung der Global-Variable BL_nach_unten - 
	(if (= qsform "Z") (progn
		(Z_Profile_calc_Blech_nach_Unten)
		(if (= BL_nach_unten 1)  (setq movePlate_Add -1))
	))
	
	
  	(if (= movePlate_Add  1) (setq delta_lr_soll (+     tSteg (* 0.5 dp))))
  	(if (= movePlate_Add -1) (setq delta_lr_soll (- 0.0 tSteg (* 0.5 dp))))
	
	(if (= qsform "Z") (progn
		(if (= movePlate_Add  1) (setq delta_lr_soll (+   delta_lr_soll   (* 0.5 tSteg))))
		(if (= movePlate_Add -1) (setq delta_lr_soll (+   delta_lr_soll   (* 0.5 tSteg))))
	))
	
  ; Verschiebung des AT in delta_lr-Richtung	
  (if (/= delta_lr_trg 0.0) (progn
	 	(print "Verschiebung des AT in delta_lr-Richtung") 
	 	(print delta_lr_soll) 
	 	
		(if (= (Connect.get CastaData LinkesEnde) 1) (progn
		    (if (= (Connect.get CastaData amHtStegLinks)    1) (setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
		    (if (= (Connect.get CastaData amHtStegRechts)   1) (setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		    (if (= (Connect.get CastaData amHtOberflansch)  1) (setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		    (if (= (Connect.get CastaData amHtUnterflansch) 1) (setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
	 	))
		(if (= (Connect.get CastaData RechtesEnde) 1) (progn
		    (if (= (Connect.get CastaData amHtStegLinks)    1) (setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		    (if (= (Connect.get CastaData amHtStegRechts)   1) (setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
		    (if (= (Connect.get CastaData amHtOberflansch)  1) (setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
		    (if (= (Connect.get CastaData amHtUnterflansch) 1) (setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
	 	))
		(print delta_lr_soll)  
  ))
  
  ; Verschiebung des HT in delta_lr-Richtung	
  (if (/= delta_lr_htrg 0.0) (progn
  		(print "Verschiebung des HT in delta_lr-Richtung") 
	 	(print delta_lr_soll)
;		(if (= (Connect.get CastaData amHtFlansch) 1)
;			(setq delta_lr_soll (- delta_lr_soll delta_lr_htrg))
;		)
		 (print delta_lr_soll)
  ))

  
  ; Verschiebung des HT in delta_v-Richtung
  (print "Verschiebung des HT in delta_v-Richtung") 
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
		; (setq delta_lr_soll (- delta_lr_soll delta_v_htrg))
		(setq cosW (cos (/ (* PI FahnenWinkel) 180.0)))
		(setq delta_lr_soll (- delta_lr_soll (* cosW delta_v_htrg)))
	))

	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
		; (setq delta_lr_soll (- delta_lr_soll delta_v_htrg))
		(setq cosW (cos (/ (* PI FahnenWinkel) 180.0)))
		(setq delta_lr_soll (- delta_lr_soll (* cosW delta_lr_htrg)))
	))

        (setq xPos_Global xPos)

	; AF - Okt. 2008
	; hier wurde zuvo auf abTeil_fahne zugegriffen, obwohl das Blech erst spter
	; als Anbauteil an den Trger angefgt wird. Die Passage habe ich rausgenommen und
	; an das Ende des Durchlaufs angeordnet.
  	
	(setq dok_soll 0)
  	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq dok_soll (- dok)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq dok_soll (+ dok)))
  
    	(print delta_lr_soll)
    	(setq dok_soll 0)

	; BLECHDATEN:
	; -----------
	(Blech.set	fahnenblech 	(dok 		dok_soll) 
					(delta_lr 	delta_lr_soll)
	)
	
	
	(print "------------------------------------------------------------")

)



; ----------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde)
	(Lochbild.set Lchb_ID	(Anz_S    2)
				(Guete   "4.6")
				(e       "100 50 0 0 0 0")
				(w       "0  0")
	)
	(setq e0 (Lochbild.get Lchb_ID e0))

	
	(setq h_trg 	(Traeger.get Tr_ID h))
	
	(setq	s_htrg		(Traeger.get Htrg s)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
		delta_v_htrg	(Traeger.get Htrg delta_v)
		h_htrg		(Traeger.get Htrg h)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l))
		
	
	
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	
	(print e_min)
	(print abstZumSteg)
	(print s_htrg)
	
	; Abstand HT Kante zum Lochbild
	(if (= (Connect.get CastaData amHTSteg) 1)
		(setq abst_lchb_kante (+ abstZumSteg e_min))
	)
	(if (= (Connect.get CastaData amHTFlansch) 1)
		(setq abst_lchb_kante (+ abstZumSteg e_min))
	)
	
	(setq w0 abst_lchb_kante)
	(print abst_lchb_kante)
	(print delta_lr_htrg)
	
(if (= 1 1) (progn	
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (< delta_lr_htrg abst_lchb_kante)
				(setq w0_rund (runde w0 auf 5))
				(setq w0_rund (runde w0 ab 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (< delta_lr_htrg abst_lchb_kante)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (< delta_v_htrg abst_lchb_kante)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	) 
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (< delta_v_htrg abst_lchb_kante)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)
))	


	(setq w0_rund (runde w0 auf 5))
	
	(print w0)
	(print w0_rund)
	;(setq w0_rund (runde w0 auf 5))
	
	(setq	hp_blech 	(Blech.get BlechID hp)
		dok_blech	(Blech.get BlechID dok)
	)
	(print hp_blech)
	(print dok_blech)
	
	(if (= (Connect.get CastaData amHtFlansch)  1) (progn
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq e0 (- (- (* 0.5 h_trg) (* 0.25 hp_blech)) dok_blech)))
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq e0 (+ (- (* 0.5 h_trg) (* 0.25 hp_blech)) dok_blech))) 

		(if (= (Connect.get CastaData vatr-shtr)  1)	(setq e0 (- (- (* 0.5 h_trg) (* 0.25 hp_blech)) dok_blech)))
		(if (= (Connect.get CastaData vatr-shtr) -1)	(setq e0 (+ (- (* 0.5 h_trg) (* 0.25 hp_blech)) dok_blech))) 
	))

	(if (= (Connect.get CastaData amHtSteg)  1) (progn
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq e0 (- (- (* 0.5 h_trg) (* 0.25 hp_blech)) dok_blech)))
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq e0 (+ (- (* 0.5 h_trg) (* 0.25 hp_blech)) dok_blech))) 

		(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq e0 (- (- (* 0.5 h_trg) (* 0.25 hp_blech)) dok_blech)))
		(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq e0 (+ (- (* 0.5 h_trg) (* 0.25 hp_blech)) dok_blech))) 
	))

	(setq e1 (* 0.5 hp_blech))
	
	; Klemmlnge
	(setq dp_blech 	(Blech.get 	BlechID		dp))
	(setq s_trg	(Traeger.get 	Tr_ID		s))
	
	; Schraubenkopf
	(calcDxSKopf s_trg dp_blech)
	
	; hier working
	(Lochbild.set Lchb_ID	(e0 		e0)
				(e1 		e1)
				(w0 		w0_rund)
				(klemml		(+ dp_blech s_trg))
				(dxSKopf	dxSKopf)           ; HIER EINFACH AUF 0 SETZEN.
	) 
	
	(print e0)
	
	(print e_min)
	(print w0)
	
	; Korregiere Fahnenblech
	(Blech.set BlechID (bp (+ (* 2.0 e_min_rund) abstZumSteg))) 
)

(defun calcDxSKopf (s_trg dp_blech)
	(print "------------------------------------------------------------")
	(print "BERECHNE DXSKOPF")
	(setq qsform (Traeger.get Tr_ID qsform))
	
	(setq dxSKopf 0)	; sicherheitshalber initialisieren

	; I-Profile
	(if (= qsform "I") (setq dxSKopf (+ s_trg (* 0.5 dp_blech))))
	(if (= qsform "T") (setq dxSKopf (+ s_trg (* 0.5 dp_blech))))
	(if (= qsform "Z") (setq dxSKopf (+ s_trg (* 0.5 dp_blech))))
	; U und C sollen gleich/hnlich/analog behandelt werden	
	(if (= qsform "c") (setq qsform "U"))
	(if (= qsform "C") (setq qsform "U"))
	(if (= qsform "Z") (setq qsform "U"))
	(if (= qsform "U") (progn
	
		(if (= (Connect.get CastaData amHtFlansch) 1) (progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq dxSKopf (+ s_trg (* 0.5 dp_blech))))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq dxSKopf (* 0.5 dp_blech)))
		))
		(if (= (Connect.get CastaData amHtSteg) 1) (progn
			(if (= (Connect.get CastaData satr-vhtr)  1)	(setq dxSKopf (+ s_trg (* 0.5 dp_blech))))
			(if (= (Connect.get CastaData satr-vhtr) -1)	(setq dxSKopf (* 0.5 dp_blech)))
		))
		(if (= movePlate_Add  1) (progn
		    (setq dxSKopf (+ s_trg (* 0.5 dp_blech)))
		))
		(if (= movePlate_Add -1) (progn
		    (setq dxSKopf (+ 0.0 (* 0.5 dp_blech)))
		))
	))
	
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Prft, die Position des AT in Bezug auf den HT
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq	hc_ht 		(Traeger.get Htrg hc)
			b_ht		(Traeger.get Htrg b)
			delta_v_ht	(Traeger.get Htrg delta_v)
			delta_lr_ht	 (Traeger.get Htrg delta_lr)
			qsform_HT (Traeger.get Htrg qsform)
	)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		s_at		(Traeger.get Tr_ID s)
	)
	
	; Standardmig wird angenommen, dass der AT angeschlossen werden kann.
	(setq isInside 1)
	
	(if (= hc_ht 0.0) (setq hc_ht (Traeger.get Htrg h)))
	
	; Wenn der Anschluss am HT-Steg erfolgt, wird geprft, ob sich der AT-Steg im HC-Bereich des HT befindet.
	(if (= (connect.get CastaData amHtSteg) 1)
		(progn
			; obere und untere Ausrundung des HT
			(setq ausrO_ht (- delta_v_ht (* 0.5 hc_ht)))
			(setq ausrU_ht (+ ausrO_ht hc_ht))
			(print ausrO_ht)
			(print ausrU_ht)
			(print delta_lr_at)
				
			(if (= (Connect.get CastaData satr-vhtr) 1)
				(progn
					(if (> delta_lr_at ausrU_ht)
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at ausrO_ht)
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(if (> delta_lr_at (- ausrO_ht))
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at (- ausrU_ht))
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			
			(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
				(if (= qsform_HT "U") (setq  isInside 1))
			))

			
			(if (= isInside 0)
				(print "AUSSERHALB")
				(print "INNERHALB")
			)
		)
	)
	
	; Wenn der Anschluss am HT-Flansch erfolgt, wird geprft, ob der AT-Steg noch am Flansch 
	; angeschlossen werden kann.
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			; linke und rechte Seite des HT-Fansches
			(setq flansch_ht_l (- delta_lr_ht (* 0.5 b_ht)))
			(setq flansch_ht_r (+ flansch_ht_l b_ht))
			(print flansch_ht_l)
			(print flansch_ht_r)
			(print delta_lr_at)
			
			(if (= (Connect.get CastaData satr-shtr) 1)
				(progn
					(if (> delta_lr_at flansch_ht_r)
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at flansch_ht_l)
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (> delta_lr_at (- flansch_ht_l))
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at (- flansch_ht_r))
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			
			(if (= isInside 0)
				(print "AUSSERHALB FLANSCH")
				(print "INNERHALB FLANSCH")
			)
		)
	)
)

(defun	calcFahnenWinkel ()
	(setq rwnkl_trg (Traeger.get Tr_ID r_winkel))
	(setq FahnenWinkel 0.0)
	 
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
		(setq trg_RWinkel (Connect.get CastaData r-atrgewnkl_steg))
	))
	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
		(setq trg_RWinkel (Connect.get CastaData r-atrgewnkl_flansch))
	))

	(if (= (Connect.get CastaData LinkesEnde) 1)	(progn	
	   	; Flanschbereich - sollte auch umgestellt werden wie beim Stegbereich
	   	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
			(setq FahnenWinkel		rwnkl_trg)
			(setq FahnenWinkel_Old		rwnkl_trg)
		))
		(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
			(setq FahnenWinkel		(- rwnkl_trg))
			(setq FahnenWinkel_Old		(- rwnkl_trg))
		))

	   	; Stegbereich -  ----------------------------------------------------
		(setq 	DrehRichtung 0)							; unbekannte Drehrichtung
		(if (= (Connect.get CastaData sAtr-lHtr-ex)  1) (setq DrehRichtung  1))
		(if (= (Connect.get CastaData sAtr-lHtr-ex) -1) (setq DrehRichtung -1))
		(if (= DrehRichtung 0)	(progn
			(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq FahnenWinkel 180.0))
			(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq FahnenWinkel   0.0))
		))

		(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
			(print "linkes-Ende ... am Ht-Steg-links")
			(if (= DrehRichtung 1)	(setq FahnenWinkel	trg_RWinkel))
			(if (= DrehRichtung -1)	(setq FahnenWinkel	(- trg_RWinkel)))
		))
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(print "linkes-Ende ... am Ht-Steg-rechts")
			(if (= DrehRichtung 1)	(setq FahnenWinkel	(- trg_RWinkel 180.0)))
			(if (= DrehRichtung -1)	(setq FahnenWinkel	(- 180.0 trg_RWinkel)))
		))

		(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
			(print "linkes-Ende ... am amHtUnterflansch")
			(if (= DrehRichtung 1)	(setq FahnenWinkel	trg_RWinkel))
			(if (= DrehRichtung -1)	(setq FahnenWinkel	(- trg_RWinkel)))
		))
		(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
			(print "linkes-Ende ... am amHtOberflansch")
			(if (= DrehRichtung 1)	(setq FahnenWinkel	(- trg_RWinkel 180.0)))
			(if (= DrehRichtung -1)	(setq FahnenWinkel	(- 180.0 trg_RWinkel)))
		))

	))
	
	(if (= (Connect.get CastaData RechtesEnde) 1)	(progn
	   	; Flanschbereich - sollte auch umgestellt werden wie beim Stegbereich
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
			(setq FahnenWinkel		(- 360.0 rwnkl_trg))
			(setq FahnenWinkel_Old		(- 360.0 rwnkl_trg))
		))
		(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
			(setq FahnenWinkel		(- (- 360.0 rwnkl_trg)))
			(setq FahnenWinkel_Old		(- (- 360.0 rwnkl_trg)))
		))

	   	; Stegbereich -  ----------------------------------------------------
		(setq 	DrehRichtung 0)							; unbekannte Drehrichtung
		(if (= (Connect.get CastaData sAtr-lHtr-ex)  1) (setq DrehRichtung  1))
		(if (= (Connect.get CastaData sAtr-lHtr-ex) -1) (setq DrehRichtung -1))

		(if (= DrehRichtung 0)	(progn
			(if (= (Connect.get CastaData vAtr-lHtr)  1) (setq FahnenWinkel 180.0))
			(if (= (Connect.get CastaData vAtr-lHtr) -1) (setq FahnenWinkel   0.0))
		))
		
		(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
			(if (= DrehRichtung 1)	(setq FahnenWinkel	(- trg_RWinkel 180.0)))
			(if (= DrehRichtung -1)	(setq FahnenWinkel	(- 180.0 trg_RWinkel)))
		))
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(if (= DrehRichtung 1)	(setq FahnenWinkel	trg_RWinkel))
			(if (= DrehRichtung -1)	(setq FahnenWinkel	(- trg_RWinkel)))
		))
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
			(print "rechtes Ende am HT Unter-Flansch")
			(if (= DrehRichtung 1)	(setq FahnenWinkel	(- trg_RWinkel 180.0)))
			(if (= DrehRichtung -1)	(setq FahnenWinkel	(- 180.0 trg_RWinkel)))
		))
		(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
			(print "rechtes Ende am HT Ober-Flansch")
			(if (= DrehRichtung 1)	(setq FahnenWinkel	trg_RWinkel))
			(if (= DrehRichtung -1)	(setq FahnenWinkel	(- trg_RWinkel)))
		))
		
	))


)

(defun	dreheFahnenblechAm_HTrg ()

	; hier muss ein anderer Winkel hin, weil
	; das nur der lokale Winkel des Trgerprofils ist.
	(setq rwnkl_trg (Traeger.get Tr_ID r_winkel))
        (setq xPos xPos_Global)

 	(setq abTeil_fahne (Traeger.get Htrg abteil bFahnenbl))
	
 	(if abTeil_fahne (progn
	    (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(if (= (Connect.get CastaData LinkesEnde) 1)	(progn	
			(Anbauteil.set abTeil_fahne	(winkel		rwnkl_trg)
							(xPos		xPos)
			)
		))
		(if (= (Connect.get CastaData RechtesEnde) 1)	(progn
			(Anbauteil.set abTeil_fahne	(winkel		(- 360.0 rwnkl_trg))
							(xPos		xPos)
			)
		))	
	    ))

  	    (if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		(if (= (Connect.get CastaData LinkesEnde) 1) (progn	
			(Anbauteil.set abTeil_fahne	(winkel  (- rwnkl_trg))
							(xPos			xPos)
			)
		))
		(if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(Anbauteil.set abTeil_fahne	(winkel  (- (- 360.0 rwnkl_trg)))
							(xPos			xPos)
			)
		))
	    ))
   	))

	(print "------------------------------------------------------------")

)
(defun Z_Profile_calc_Blech_nach_Unten ()
	(setq BL_nach_unten 0)
	(setq qsform		(Traeger.get Tr_ID qsform))
	(if (= qsform "Z") (progn
		(setq BL_nach_unten 0)
		(setq ht_VWinkel (Connect.get CastaData  hpttrg_vwinkel))
		(if (= ht_VWinkel 270.0)  (progn
	  	    (if (= (Connect.get CastaData satr-lhtr)  -1)	(setq BL_nach_unten 1)) ; (AlertBox "Blech nach unten versetzen"))
		))
		(if (= ht_VWinkel 90.0)  (progn
	  	    (if (= (Connect.get CastaData satr-lhtr)   1)	(setq BL_nach_unten 1)) ;  (AlertBox "Blech nach unten versetzen"))
		))

		(setq BL_nach_unten 0)

		(if (= ht_VWinkel 270.0)  (progn
	  	    (if (= (Connect.get CastaData satr-lhtr)  -1)	(progn
				(if (= (Connect.get CastaData vatr-vhtr)  -1) (setq BL_nach_unten 1))
			))
	  	    (if (= (Connect.get CastaData satr-lhtr)   1)	(progn
				(if (= (Connect.get CastaData vatr-vhtr)  -1) (setq BL_nach_unten 1))
			))
		))
		(if (= ht_VWinkel 90.0)  (progn
	  	    (if (= (Connect.get CastaData satr-lhtr)  -1)	(progn
				(if (= (Connect.get CastaData vatr-vhtr)  1) (setq BL_nach_unten 1))
			))
	  	    (if (= (Connect.get CastaData satr-lhtr)   1)	(progn
				(if (= (Connect.get CastaData vatr-vhtr)  1) (setq BL_nach_unten 1))
			))
		))

		(print "----------------------------------------------------------- Z_Profile_calc_Blech_nach_Unten")
		(print  ht_VWinkel)
		(if (= (Connect.get CastaData satr-lhtr)   1) (print  "satr-lhtr =   1"))
		(if (= (Connect.get CastaData satr-lhtr)  -1) (print  "satr-lhtr =  -1"))
		(if (= (Connect.get CastaData vatr-vhtr)   1) (print  "vatr-vhtr =   1"))
		(if (= (Connect.get CastaData vatr-vhtr)  -1) (print  "vatr-vhtr =  -1"))
		(print "-----------------------------------------------------------")
	))
)

