; $ HT		QT(IUT)	AF(F)	P(EZ)
; $ AT		QT(IU)	AF(K)	P(E)
; $ AE		V(-)		H(90)	R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")		
   (load "mod-help-uz_an_stzFlansch")
   (load "mod-multiconnect-stz-flansch")
   (load "mod-messages")
   (load "mod_lchb_verschiebungen")
)

(defun init-connection ()

	;(connect.showattributes CastaData)

	(setq LB_DEBUG 0)

  (setq Anschliessen 1)
  (setq qsForm (Traeger.get HTrg qsForm))
  (if (= qsForm "T") (progn
		(if (= (connect.get CastaData amHtUnterFlansch) 1) (setq Anschliessen 0))
  ))

  (if (= Anschliessen 1) (progn

		(init-traegerenden)				


	  (setq blKpl 	(blech.create))
	  (setq lchbKpl (lochbild.create))
		(Connect.storeAnschlObjs CastaData blKpl lchbKpl)
				
	  (if (= (connect.get CastaData RechtesEnde) 1) 
		(progn
			(print "Anschluss rechts am Anschlusstrger")
			
			; Kopfplatte
				(calcAndSetBlechdaten blKpl TrRechts)
				(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplatterechts_)

				; Lochbild
				(calcFlanschLochbildDaten lchbKpl blKpl)
				(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildrechts_)

				(createFlanschLochb lchbKpl blKpl)

				(setq dp (Blech.get blKpl dp))
		)
	  )
	  (if (= (connect.get CastaData LinkesEnde) 1) 
		(progn
			(print "Anschluss links am Anschlusstrger")
			
				; Kopfplatte
				(calcAndSetBlechdaten blKpl TrLinks)
				(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplattelinks_)

				; Lochbild
				(calcFlanschLochbildDaten lchbKpl blKpl)
				(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildlinks_)
				
				(createFlanschLochb lchbKpl blKpl)
		
				(setq dp (Blech.get blKpl dp))
		)
	  )
	  
	  (korrigiereKpl blKpl lchbKpl)
	  (calcHVerschLochbild lchbKpl)
	  
		
	  ; ******************************************
	  ; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
	  ; ******************************************
	  
	  ; erstmal berprfen, ob berhaupt schon ein Anschluss vorhanden ist
	  (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	  (print anzAnschl)
	  
	  (if (/= anzAnschl 0)
		(progn
			;(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden. Fgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."    "ERR_OrderOfConnections")
			(message "Anschl_vorh")
			(createStuetzenSteifen dp)
		)
		(progn
			(createStuetzenSteifen dp)
			
			(if (= (Connect.get CastaData anschlZwHtEnden) 0)
				(eckeBegradigen)
			)
		)
	  )
		

	  ; CALLBACKS
	  (Blech.set blKpl (formFkt "cb_blKpl"))

	  (LchbShowAbschlussKontrolle lchbKpl)
	))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_blKpl (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lchbKpl Klemml))
	       (setq altesDxS		(Lochbild.get lchbKpl dxsKopf))
	       
	       (Lochbild.set lchbKpl 	(Klemml (+ alteKlemml dpDiff))
	       												(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
	
	
)

; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */

; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD
; ----------------------------------------------------------------------------------------
(defun	createFlanschLochb (flLochbild BLECH_ID)
	(createFlanschLochb_2011 flLochbild BLECH_ID)
;	(createFlanschLochb_Alt  flLochbild BLECH_ID)
)

(defun	createFlanschLochb_Alt (flLochbild BLECH_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
  
  (setq xPos 		(Connect.get CastaData xPos_HT)
  	afl_vwinkel 	(Connect.get CastaData afl_vwinkel)
  	htrg_vwinkel	(Connect.get CastaData hpttrg_vwinkel)
  )
  	
  (setq hProf		(Traeger.get Htrg h)
        delta_v_ht	(Traeger.get Htrg delta_v)      
        delta_lr_ht	(Traeger.get Htrg delta_lr)      
  )
	
  (setq h_at		(Traeger.get Tr_ID h)
	delta_v_at	(Traeger.get Tr_ID delta_v)
	delta_lr_at	(Traeger.get Tr_ID delta_lr)
  )
	
	(setq dp_blech		(Blech.get BLECH_ID dp)
				dok_blech		(Blech.get BLECH_ID dok)
	)
	
	(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
	(setq sinAW (sin (/ (* PI afl_vwinkel) 180.0)))
	(print tanAW)
	(print sinAW)
	
	(if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	  (setq Flansch _flanschlochbild_of_)
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	  (setq Flansch _flanschlochbild_uf_)
  ))
  
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
  
  ; Orientierung des HT festlegen
  ;(setq oben_unten 0)
  (if (= (Connect.get CastaData vatr-lhtr) -1)
  			(setq oben_unten 0)
				(setq oben_unten 1)
  )
  
  ; Winkel des Lochbildes festlegen
	; (abhngig von HT-Orientierung) 
	(setq wAbtl 180.0)
	(if (= oben_unten 1)
		(setq wAbtl 0.0)
	)
	
	(print xPos)
	; Positionierung und Ausrichtung zum AT
	; Verschiebung auf die Hhe der AT-Oberkante
	(setq scherl_at (TrEnde.get TrgEnde vscherl))
	(setq delta_xPos (* 0.5 scherl_at))
	(if (= oben_unten 1)
		(setq xPos (- xPos delta_xPos))
		(setq xPos (+ xPos delta_xPos))
	)
	(print "nach vscherl")
  (print xPos)
  
  (print dok_blech)
  ; Anteil AT_Oberkante bis Ht-Ende
  (setq anteil_n (/ (* 1.0 dp_blech) tanAW))
  (print anteil_n)
  
	(setq xPos (- xPos anteil_n))
	
	
	
	; die restlichen Korrekturen aus Trgerverschiebungen zusammenfassen
	(setq xPos_korr_ges 0)
	; ----------------------------------------------
	(if (= 1 1) (progn
	(print "ANTEIL DER VERTIKALEN NEIGUNG")
	; ----------------------------------------------
	
		(setq einbauWinkel (Connect.get CastaData v-atrgewnkl_flansch))
		(print einbauWinkel)
		
		(setq tanEW (tan (/ (* PI einbauWinkel) 180.0)))
		(print tanEW)
		
		(setq h_ht_halb (* 0.5 hProf))
		(print h_ht_halb)
		(if (= (Connect.get CastaData amHtOberflansch) 1)
			(setq anteil_ht (- h_ht_halb delta_v_ht))	; AF korrigiert Feb. 2011
		)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
			(setq anteil_ht (+ h_ht_halb delta_v_ht))	; AF korrigiert Feb. 2011
		)
		
		(setq anteil_vert_neigung (/ anteil_ht tanEW))
				
		(if (= (Connect.get CastaData linkesEnde) 1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_vert_neigung)))
		(if (= (Connect.get CastaData rechtesEnde) 1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_vert_neigung)))
			
	; ----------------------------------------------
	))
	; ----------------------------------------------
 
  
  ; Bercksichtigung der AT-Neigung ( -> Verschiebung der xPos)
  ; Anschluss an den Ht-Enden
  (if (= (connect.get CastaData anschlzwhtenden) 0)
  	(progn 
		  (if (= (connect.get CastaData anhtlinkesende) 1) 
		  	(progn
					(setq EWnkl   (Connect.get CastaData afl_vwinkel))
		      (setq dvWnkl  (/ (+ (* 0.5 hProf) dp_blech) (tan (* PI (/ EWnkl 180.0)))))
					
					(if (= (connect.get CastaData amHtOberFlansch) 1) 
						(progn
			    		(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
						)
					)
					(if (= (connect.get CastaData amHtUnterFlansch) 1) 
						(progn
			    		(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
						)
					)
		  	)
		  )
		  (if (= (connect.get CastaData anhtrechtesende) 1) 
		  	(progn
					(setq EWnkl   (Connect.get CastaData afl_vwinkel))
					(setq dvWnkl  (/ (+ (* 0.5 hProf) dp_blech) (tan (* PI (/ EWnkl 180.0)))))
					
					(if (= (connect.get CastaData amHtOberFlansch) 1) 
						(progn
			    		(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
						)
					)
					(if (= (connect.get CastaData amHtUnterFlansch) 1) 
						(progn
			    		(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
						)
					)
		  	)
		  )
		)
	)
	
	; Anschluss zwischen den Ht-Enden
	(if (= (connect.get CastaData anschlzwhtenden) 1)
  	(progn 
  		(setq EWnkl   (Connect.get CastaData afl_vwinkel))
		  (setq dvWnkl  (/ (+ (* 0.5 hProf) dp_blech) (tan (* PI (/ EWnkl 180.0)))))
			
			(if (= (connect.get CastaData amHtOberFlansch) 1) 
				(progn
					(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
			  )
			)
			(if (= (connect.get CastaData amHtUnterFlansch) 1) 
				(progn
			    (setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
			  )
			)
			(print xPos_korr_ges)
		)
	)

	(print dvWnkl)
	
	
	
	
	; Verschiebung delta_v AT
	(setq xPos_delta_v_at_korr (/ delta_v_at sinAW))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
		)
	)


  ; Verschiebung delta_v HT
  (setq xPos_korr (/ delta_v_ht tanAW))
	(print xPos_korr)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq xPos_korr_ges (- xPos_korr_ges xPos_korr))
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq xPos_korr_ges (+ xPos_korr_ges xPos_korr))
	) 
	
  (print "*clear*")
	
	(setq xPos (+ xPos xPos_korr_ges))
	(print xPos)
	(print wAbtl)
	
	(print delta_lr_at)
	(print delta_lr_ht)

	; Verschiebung delta_lr AT
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
	    )
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
	    )
	)

	
	; Verschiebung delta_lr HT
    (if (= 1 1) (progn
        (if (= (Connect.get CastaData anHtLinkesEnde) 1) (setq delta_lr_ht (- delta_lr_ht)))

	(if (= (Connect.get CastaData rechtesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
	    )
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
	    )
	)

        (if (= (Connect.get CastaData anHtLinkesEnde) 1) (setq delta_lr_ht (- delta_lr_ht)))
    ))


	
  (Traeger.addabtl Htrg flLochbild   xPos wAbtl Flansch)
  (print delta_lr_at)
  
  (setq abteil 		(Traeger.get Htrg abteil flLochbild))
  (setq abteil_at (Traeger.get Tr_ID abteil flLochbild))

;  Korrektur - AF-20090512
;  (Lochbild.set flLochbild (LB_Art   2))			; AF-20090512
;  (Lochbild.set flLochbild (delta_w 50))			; AF-20090512
;  (Lochbild.set flLochbild (e    "10 30 100 0 0 0"))		; AF-20090512
  
  (Anbauteil.set abteil (delta_lr delta_lr_abt_ht))
  (if (= 1 1) (progn
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
		)
	)
  ))
	(Anbauteil.set abteil (Master 1))
	(Anbauteil.set abteil_at (Master 0))
	
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			;(setq XPos_at (Connect.get CastaData XPos_AT))
			(Lochbild.set flLochbild (e2 200))
			
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy flLochbild)
						
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(traeger.addabtl tr_id dummy 0.0 0.0 _kpllochbildrechts_)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(traeger.addabtl tr_id dummy 0.0 0.0 _kpllochbildlinks_)
			)
	
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1) )
		)
	)
	;===================================================================
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------
; Erzeugt die Sttzensteifen
; ----------------------------------------------------------------------
(defun createStuetzenSteifen (dp)
	(print "")
	(print "BEGIN createStuetzenSteifen")
	(print "---------------------------")
	; allgemeine Daten holen
	(setq h_at    			(Traeger.get  Tr_Id h)
	      t_at    			(Traeger.get  Tr_Id t)
	      delta_v_at   (Traeger.get  Tr_Id delta_V)
	      h_ht     		(Traeger.get  HTrg  h)
	      delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq at_vwinkel 	(Connect.get CastaData at_laengswinkel)
				xPos_ht			(Connect.get CastaData xPos_ht)
	)
	(print delta_v_at)
	(setq dp_steife 10)
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	(setq vscherl_at (TrEnde.get AT_Ende vscherl))
	(setq vscherl_at_halb	(* 0.5 vscherl_at))
	
	(setq xPosOben 	(- (+ xPos_ht vscherl_at_halb) (* 0.5 dp_steife)))
	(setq xPosUnten (+ (- xPos_ht vscherl_at_halb) (* 0.5 dp_steife)))
	
	(setq tanW (tan (/ (* PI at_vwinkel) 180.0)))
	(setq sinW (sin (/ (* PI at_vwinkel) 180.0)))
	
	; Korrektur aus Neigung
	
	(setq xPos_korr_neig (/ (* 0.5 h_ht) tanW))
	
	(setq xPosOben 	(+ xPosOben xPos_korr_neig))
	(setq xPosUnten (+ xPosUnten xPos_korr_neig))
	
	
	; Anteil aus delta_v Verschiebung HT
	(setq anteil_delta_v_ht (/ delta_v_ht tanW))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(setq xPosOben 	(- xPosOben anteil_delta_v_ht))
			(setq xPosUnten (- xPosUnten anteil_delta_v_ht))
		)
	)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(setq xPosOben 	(+ xPosOben anteil_delta_v_ht))
			(setq xPosUnten (+ xPosUnten anteil_delta_v_ht))
		)
	)
	
	
	; Anteil aus delta_v Verschiebung AT
	
	(setq anteil_delta_v_at (/ delta_v_at sinW))
	(print anteil_delta_v_at)
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(setq xPosOben 	(+ xPosOben anteil_delta_v_at))
			(setq xPosUnten (+ xPosUnten anteil_delta_v_at))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq xPosOben 	(- xPosOben anteil_delta_v_at))
			(setq xPosUnten (- xPosUnten anteil_delta_v_at))
		)
	)
	
	
	; Erstellen der Steifen
	; ---------------------
	
	; Auf Steifen am HT prfen
	(checkForSteifeAtPosition xPosOben 100 Htrg)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosOben 100 Htrg)
	)
	
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeOben (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeOben)
			(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_)	;1539
			(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeOben))
			(Anbauteil.set  AbtlSteife (xpos xPosOben))
			(Blech.set blSteifeOben (dp dp_steife))
		)
	)
	
	
	(checkForSteifeAtPosition xPosUnten 100 Htrg)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosUnten 100 Htrg)
	)
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeUnten (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeUnten)
			(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)   ;1539
			(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
			(Anbauteil.set  AbtlSteife (xpos xPosUnten))
			(Blech.set blSteifeUnten (dp dp_steife))
		)
	)
	
	
	
	(Traeger.updvollstf Htrg)
	(print "---------------------------")
	(print "END createStuetzenSteifen")
	(print "")
)

; --------------------------------------------------------------------
; Begradigt die Rahmenecke wieder
; --------------------------------------------------------------------
(defun eckeBegradigen ()
	(print ">-------------------------------------------------------------------------------")
	(print "Begradige Sttzenecke")
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(TrEnde.set HtEnde (v_winkel 90.0))
	
	; Verlngern und an AT anpassen
	(setq h_ht				(Traeger.get Htrg h))
	(setq afl_vwinkel (Connect.get CastaData afl_vwinkel))
	(setq delta_l			(TrEnde.get HtEnde delta_l))
	
	(setq h_ht_halb (* 0.5 h_ht))
	
	(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
	
	(setq delta_l_korr (/ h_ht_halb tanAW))
	(print delta_l)
	(print delta_l_korr)
	
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq delta_l (+ delta_l delta_l_korr))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq delta_l (- delta_l delta_l_korr))
	)	
		
	(TrEnde.set HtEnde (delta_l delta_l))
	(print "<-------------------------------------------------------------------------------")
)

(defun	createFlanschLochb_2011 (flLochbild BLECH_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
  
	; allg. Daten
	; ----------------------------------------------
  (setq xPos 					(Connect.get CastaData xPos_HT)
  			afl_vwinkel 	(Connect.get CastaData afl_vwinkel)
  			htrg_vwinkel	(Connect.get CastaData hpttrg_vwinkel)
  )
  	
  (setq hProf					(Traeger.get Htrg h)
        delta_v_ht		(Traeger.get Htrg delta_v)      
  )
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
				r_winkel_at (Traeger.get Tr_ID r_winkel)
	)
	
	(setq dp_blech		(Blech.get BLECH_ID dp)
				dok_blech		(Blech.get BLECH_ID dok)
	)
	
	(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
	(setq sinAW (sin (/ (* PI afl_vwinkel) 180.0)))
	(print tanAW)
	(print sinAW)
	
	(if (= (connect.get CastaData amHtOberFlansch) 1) 	(setq Flansch _flanschlochbild_of_))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) 	(setq Flansch _flanschlochbild_uf_))
  
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq TrgEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq TrgEnde (Traeger.get Tr_ID rechts)))
  
	
  (setq delta_lr_lb_abtl 0.0)
	(setq delta_v_lb_abtl 0.0)
	
	
  ; Winkel des Lochbildes festlegen
	; (abhngig von HT-Orientierung)
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
		(print "Winkel des LB berechnen")
		(setq wAbtl 0.0)
		
		(setq r_flansch (Connect.get CastaData r-atrgewnkl_flansch))
		(print r_flansch)
		
		; Die folgende Unterscheidung ist provisorisch, bis die Unterscheidung mglich ist
		(setq vwnkl_ht	(Connect.get CastaData hpttrg_vwinkel))
		(print vwnkl_ht)
		
		(if (<= vwnkl_ht 90.0)	
			(setq von_Unten_nach_Oben 1)
			(setq von_Unten_nach_Oben 0)
		)
		(print von_Unten_nach_Oben)
		(print r_winkel_at)
		
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	
			(progn
				(if (= (Connect.get CastaData linkesEnde) 1)
					(progn
						(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl (+ 180.0 r_flansch)))
						(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl (- 180.0 r_flansch)))
							
						(if (= (Connect.get CastaData vatr-lhtr) 0)	
							(progn
								(if (= von_Unten_nach_Oben 1)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (- r_winkel_at 180.0)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (+ 180.0 r_winkel_at)))
									)
								)
								(if (= von_Unten_nach_Oben 0)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (+ 360.0 r_winkel_at)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (- 180.0 r_winkel_at)))
									)
								)
							)
						)
					)
				)
				(if (= (Connect.get CastaData rechtesEnde) 1)
					(progn
						(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl r_flansch))
						(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl r_flansch))
							
						(if (= (Connect.get CastaData vatr-lhtr) 0)	
							(progn
								(if (= von_Unten_nach_Oben 1)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (+ 360.0 r_winkel_at)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (- 180.0 r_winkel_at)))
									)
								)
								(if (= von_Unten_nach_Oben 0)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (- r_winkel_at 180.0)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (+ 180.0 r_winkel_at)))
									)
								)
							)
						)
					)
				)
			)
		)
		(if (= (Connect.get CastaData amHtOberflansch) 1)	
			(progn
				(if (= (Connect.get CastaData linkesEnde) 1)
					(progn
						(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl r_flansch))
						(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl r_flansch))
							
						(if (= (Connect.get CastaData vatr-lhtr) 0)	
							(progn
								(if (= von_Unten_nach_Oben 1)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (+ 360.0 r_winkel_at)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (- 180.0 r_winkel_at)))
									)
								)
								(if (= von_Unten_nach_Oben 0)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (- r_winkel_at 180.0)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (+ 180.0 r_winkel_at)))
									)
								)
							)
						)
					)
				)
				(if (= (Connect.get CastaData rechtesEnde) 1)
					(progn
						(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq wAbtl (+ 180.0 r_flansch)))
						(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq wAbtl (- 180.0 r_flansch)))
							
						(if (= (Connect.get CastaData vatr-lhtr) 0)	
							(progn
								(if (= von_Unten_nach_Oben 1)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (- r_winkel_at 180.0)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (+ 180.0 r_winkel_at)))
									)
								)
								(if (= von_Unten_nach_Oben 0)
									(progn
										(if (= (Connect.get CastaData satr-lhtr) -1)	(setq wAbtl (+ 360.0 r_winkel_at)))
										(if (= (Connect.get CastaData satr-lhtr)  1)	(setq wAbtl (- 180.0 r_winkel_at)))
									)
								)
							)
						)			
					)
				)
			)
		)
		(print wAbtl)
		
			
		(print wAbtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	(print xPos)
	
	
	; Positionierung und Ausrichtung zum AT
	; Verschiebung auf die Hhe der AT-Oberkante
	; ----------------------------------------------
	(if (= 1 1) (progn
	; ----------------------------------------------
		(setq scherl_at (TrEnde.get TrgEnde vscherl))
		(setq delta_xPos (* 0.5 scherl_at))
		(print delta_xPos)
		
		(if (= (Connect.get CastaData linkesEnde) 1)
			(progn
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos (- xPos delta_xPos)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos (+ xPos delta_xPos)))
			)
		)
		(if (= (Connect.get CastaData rechtesEnde) 1)
			(progn
				(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq xPos (+ xPos delta_xPos)))
				(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq xPos (- xPos delta_xPos)))
			)
		)	
	; ----------------------------------------------
	))
	; ----------------------------------------------
  (print xPos)
  
	
	; Bercksichtigung der AT_Rotation
	; ----------------------------------------------
	(if (= 1 1)	(progn
	(print "ROTATION")
	; ----------------------------------------------
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq vscherl_at (TrEnde.get AtEnde vscherl))
	(print vscherl_at)
	
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	(print vscherl_at_halb)
	
	(setq r_flansch (Connect.get CastaData r-atrgewnkl_flansch))
	
	(setq hilfsWnkl r_flansch)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq hilfsWnkl (- 360.0 r_flansch)))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq hilfsWnkl r_flansch))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-shtr)  1)	(setq hilfsWnkl r_flansch))
			(if (= (Connect.get CastaData vatr-shtr) -1)	(setq hilfsWnkl (- 360.0 r_flansch)))
		)
	)
	
	(print r_flansch)
	(print hilfsWnkl)
	
	(print delta_lr_lb_abtl)
	(print delta_v_lb_abtl)
	
	(setq cosRW (cos (/ (* PI hilfsWnkl) 180.0)))
	(setq sinRW (sin (/ (* PI hilfsWnkl) 180.0)))
	
	
	(setq ankathete (* vscherl_at_halb cosRW))
	(setq gegenkathete (* vscherl_at_halb sinRW))
	(print ankathete)
	(print gegenkathete)

; ---- neu ...	
	(setq dp_Kpl (Blech.get blKpl dp))
	(setq VWnkl_HT_fuer_dv (Connect.get CastaData v-atrgewnkl_kopf))
	(setq tan_VWnkl (tan (/ (* PI (- VWnkl_HT_fuer_dv 90.0)) 180.0)))
	(setq tan_VWnkl (tan (/ (* PI    VWnkl_HT_fuer_dv) 180.0)))

	(setq hTr_DV (Traeger.get HTrg delta_V)
	      h_HTrg (Traeger.get HTrg h)
	)
	(setq test_DV (+ (- (* 0.5 h_HTrg) hTr_DV)  dp_Kpl))
	(setq dv_aus_HTrg (* tan_VWnkl test_DV))

; ---- neu bis hier ...
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl 0.0))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (+ vscherl_at_halb ankathete )))
						)
					)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl 0.0))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (+ vscherl_at_halb ankathete )))
						)
					)
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (+ vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl 0.0))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete )))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete )))
						)
					)
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (+ vscherl_at_halb ankathete)))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl 0.0))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete )))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr) 1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl gegenkathete))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl (- vscherl_at_halb ankathete )))
						)
					)
				)
			)
;; ----------------------------			
;			(if (= (Connect.get CastaData satr-shtr) -1) (progn
;				(setq delta_v_lb_abtl (+  delta_v_lb_abtl dv_aus_HTrg))
;			))
			
		)
	)
	
	(print delta_lr_lb_abtl)
	(print delta_v_lb_abtl)
	
	
	; ----------------------------------------------
	))
	; ----------------------------------------------
  
	
	; die restlichen Korrekturen aus Trgerverschiebungen zusammenfassen
	(setq xPos_korr_ges 0) ; default
	; ----------------------------------------------
	(if (= 1 1) (progn
	(print "ANTEIL DER VERTIKALEN NEIGUNG")
	; ----------------------------------------------
	
		(setq einbauWinkel (Connect.get CastaData v-atrgewnkl_flansch))
		(print einbauWinkel)
		
		(setq tanEW (tan (/ (* PI einbauWinkel) 180.0)))
		(print tanEW)
		
		(setq h_ht_halb (* 0.5 hProf))
		(print h_ht_halb)
		(if (= (Connect.get CastaData amHtOberflansch) 1)
			(setq anteil_ht (- h_ht_halb delta_v_ht))	; AF korrigiert Feb. 2011
		)
		(if (= (Connect.get CastaData amHtUnterflansch) 1)
			(setq anteil_ht (+ h_ht_halb delta_v_ht))	; AF korrigiert Feb. 2011
		)
		
		(setq anteil_vert_neigung (/ anteil_ht tanEW))
				
		(if (= (Connect.get CastaData linkesEnde) 1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_vert_neigung)))
		(if (= (Connect.get CastaData rechtesEnde) 1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_vert_neigung)))
			
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Bercksichtigung der horizontalen Neigung
	; ----------------------------------------------
	(if (= 1 1)	(progn
	(print "ANTEIL DER HORIZONTALEN NEIGUNG")
	; ----------------------------------------------
		(setq h_ht 				(Traeger.get Htrg h)
					delta_v_ht	(Traeger.get Htrg delta_v)
		)
		
		(setq dp_kpl (Blech.get BLECH_ID dp))
		
		(setq hwnkl_at_flansch (Connect.get CastaData h-atrgewnkl_flansch))
		(print hwnkl_at_flansch)
		
		(setq h_ht_halb (* 0.5 h_ht))
		(setq anteil_ht (+ h_ht_halb delta_v_ht dp_kpl)) 
		(print anteil_ht)
		
		(setq tanHW (tan (/ (* PI hwnkl_at_flansch) 180.0)))
		(print tanHW)
		
		(setq anteil_horiz_neigung (/ anteil_ht tanHW))
		(print anteil_horiz_neigung)
		
		(if (= (Connect.get CastaData amHtUnterflansch) 1)	
			(progn
				(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_horiz_neigung))
			)
		)
		(if (= (Connect.get CastaData amHtOberflansch)  1)	
			(progn
				(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_horiz_neigung))
			)
		)
		
		(print delta_lr_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	
	; VERSCHIEBUNGEN
	; --------------------------------------------------------------------------------------
	(if (= 1 1)	(progn
	
	; Verschiebung delta_v AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "Verschiebung delta_v AT")
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v))
	(print delta_v_at)
	(print delta_v_lb_abtl)

		(setq einbauWinkel (Connect.get CastaData v-atrgewnkl_flansch))
		(print einbauWinkel)
		
		(setq sinEW (sin (/ (* PI einbauWinkel) 180.0)))
		(print tanEW)

	; korr. AF Feb.2011	
	(if (/= sinEW 0.0) (setq delta_v_at (/ delta_v_at sinEW)))
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr)  0)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr)  0)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr)  0)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData vatr-shtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
					(if (= (Connect.get CastaData vatr-shtr)  0)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl delta_v_at)))
				)
			)
		)
	)
	(print delta_v_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------

  ; Verschiebung delta_v HT
	; ----------------------------------------------
	(if (= 1 2) 	(progn
	; ----------------------------------------------
  (setq xPos_korr (/ delta_v_ht tanAW))
	(print xPos_korr)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq xPos_korr_ges (- xPos_korr_ges xPos_korr))
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq xPos_korr_ges (+ xPos_korr_ges xPos_korr))
	) 
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	(setq xPos (+ xPos xPos_korr_ges))
	(print xPos)
	(print wAbtl)
	
	
	
	
	
	; Verschiebung delta_lr AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "Verschiebung delta_lr AT")
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_lr_at)
	
	
	(print delta_lr_lb_abtl)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTOberflansch) 1) 	
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
				)
			)
			(if (= (Connect.get CastaData amHTUnterflansch) 1) 	
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTOberflansch) 1) 	
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl delta_lr_at)))
				)
			)
			(if (= (Connect.get CastaData amHTUnterflansch) 1) 	
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
					(if (= (Connect.get CastaData vatr-lhtr)  0)	(setq delta_lr_lb_abtl (- delta_lr_lb_abtl delta_lr_at)))
				)
			)
		)
	)
	(print delta_lr_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; Verschiebung delta_lr HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
	(print "Verschiebung delta_lr HT")
	(setq delta_lr_ht	(Traeger.get Htrg delta_lr))
	(print delta_lr_ht)
	
	(setq anteil_an_delta_v_ht	(* sinRW delta_lr_ht))
	(print anteil_an_delta_v_ht)
	(setq anteil_an_delta_lr_ht	(* cosRW delta_lr_ht))
	(print anteil_an_delta_lr_ht)
	
	(print delta_lr_lb_abtl)
	(print delta_v_lb_abtl)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht)))
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht)))
						)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(setq delta_lr_lb_abtl (- delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht)))
						)
					)
				)
			)
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData vatr-lhtr) -1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  1)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht))
						)
					)
					(if (= (Connect.get CastaData vatr-lhtr)  0)
						(progn
							(setq delta_lr_lb_abtl (+ delta_lr_lb_abtl anteil_an_delta_lr_ht))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_lb_abtl (- delta_v_lb_abtl anteil_an_delta_v_ht)))
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_lb_abtl (+ delta_v_lb_abtl anteil_an_delta_v_ht)))
						)
					)
				)
			)
		)
	)
	
	(print delta_lr_lb_abtl)
	(print delta_v_lb_abtl)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	))

	
	; hinzufgen
	; ----------------------------------------------
  (Traeger.addabtl Htrg flLochbild xPos wAbtl Flansch)
  (print delta_lr_at)
  
  (setq abteil 		(Traeger.get Htrg abteil flLochbild))
  (setq abteil_at (Traeger.get Tr_ID abteil flLochbild))
  
  
  (if (= 1 1) (progn
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
		)
	)
	))
	
	
	(Anbauteil.set abteil 		(Master 	1)
														(delta_lr delta_lr_lb_abtl)
														(delta_v 	delta_v_lb_abtl)
	)
	(Anbauteil.set abteil_at 	(Master 0))
	
	(if (= LB_DEBUG 1)
		(progn
			(Lochbild.set flLochbild (e2 400))
			
			(setq lbDummy (Lochbild.create))
			(Lochbild.copy lbdummy flLochbild)
			
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildrechts_)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildlinks_)
			)
			
			(setq abteil_dummy (Traeger.get Tr_ID abteil lbdummy))
			(Anbauteil.set abteil_dummy 		(Master 1))
		)
	)
	(print "------------------------------------------------------------")
	
	
)