(defun init-connection ()

  (print "in init-connection uz_an_Stz-Flansch mit Voute unten");

  (setq TrTest (traeger.create))
  (setq TrLi   (trende.create))
  
  (setq connTest (connect.create))

  (setq xSchnp     (connect.get CastaData xSp)
  	ySchnp     (connect.get CastaData ySp)
  	zSchnp     (connect.get CastaData zSp)
  	htanschlfl (connect.get CastaData htanschlfl)
  	htmodify   (connect.get CastaData htmodify)
  	xpos_ht    (connect.get CastaData xpos_ht)
  )
  
  (if (= (connect.get CastaData amHtFlansch) 1) (print "Anschluss am Hautptrgerflansch"))
  (if (= (connect.get CastaData amHtSteg)    1) (print "Anschluss am Hautptrgersteg"))
  

  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))

  (setq HTrLinks   (traeger.get htrg links))
  (setq HTrRechts  (traeger.get htrg rechts))


  ; Bedeutung an_seite
  ; 10 - links zwischendurch
  ; 11 - links an linkes Ende des Haupttrgers
  ; 12 - links an rechtes Ende des Haupttrgers
  ; 20 - rechts zwischendurch
  ; 21 - rechts an linkes Ende des Haupttrgers
  ; 22 - rechts an rechtes Ende des Haupttrgers
  ;
  (setq _links 1 _rechts 2)
  
;  (if (> vwnkl_aflch 360) (setq vwnkl_aflch (- vwnkl_aflch 360.0)))
;  (if (< vwnkl_aflch   0) (setq vwnkl_aflch (+ vwnkl_aflch 360.0)))


  (if (= an_seite 22) (setq ept_HTrg _rechts ept_ATrg _rechts))
  (if (= an_seite 21) (setq ept_HTrg _links  ept_ATrg _rechts))
  (if (= an_seite 20) (setq ept_HTrg      0  ept_ATrg _rechts))
  (if (= an_seite 12) (setq ept_HTrg _rechts ept_ATrg _links))
  (if (= an_seite 11) (setq ept_HTrg _links  ept_ATrg _links))
  (if (= an_seite 10) (setq ept_HTrg      0  ept_ATrg _links))

  (print an_seite)

  ; Verlngerung des Endes am Haupttrger
  (if (= ept_HTrg _links) 
    (progn
									(print "-- linkes Haupttrgerende")
	(calcHaupttrg_TrgEnde HTrLinks)
    )
  )

  (if (= ept_HTrg _rechts) 
    (progn
									(print "-- rechtes Haupttrgerende")
	(calcHaupttrg_TrgEnde HTrRechts)
    )
  )

  ; Trgerende-Ablngung aufgrund des Sttzenprofils
  (if (= ept_ATrg _rechts)  (progn
  						(print "Anschluss rechts am Anschlusstrger")
	(berechneTrgEndeAblng TrRechts)

	(setq blKplRechts (blech.create))
	(calcAndSetBlechdaten blKplRechts TrRechts)
	(traeger.addabtl tr_id blKplRechts 0.0 0.0 _kopfplatterechts_)

	(setq lchbKplRechts (lochbild.create))
	(calcAndSetLochbildDaten lchbKplRechts TrRechts);
	(traeger.addabtl tr_id lchbKplRechts 0.0 0.0 _kpllochbildrechts_)
	(createFlanschLochb lchbKplRechts)

	(setq vouteRechts (voute.create))
	(voute.set vouteRechts (laenge	 200) (hsteg1	 150) (d_OK 0) (t_flansch  10) (b_flansch  80) (t_steg	  10))
	(traeger.addabtl tr_id vouteRechts 0.0 0.0 _vouterechts_)
  ))
  (if (= ept_ATrg _links)  (progn
  						(print "Anschluss links am Anschlusstrger")
	(berechneTrgEndeAblng TrLinks)

	(setq blKplLinks (blech.create))
	(calcAndSetBlechdaten blKplLinks TrLinks)
	(traeger.addabtl tr_id blKplLinks 0.0 0.0 _kopfplattelinks_)

	(setq lchbKplLinks (lochbild.create))
	(calcAndSetLochbildDaten lchbKplLinks TrLinks);
	(traeger.addabtl tr_id lchbKplLinks 0.0 0.0 _kpllochbildlinks_)
	(createFlanschLochb lchbKplLinks)
	
	(print _voutelinks_)
	(print _vouterechts_)
	
	(setq vouteLinks (voute.create))
	(voute.set vouteLinks (laenge	 200) (hsteg1	 150) (d_OK 0) (t_flansch  10) (b_flansch  80) (t_steg	  10))
	(traeger.addabtl tr_id vouteLinks 0.0 0.0 _voutelinks_)
	
  ))



  
)
; ---------------------------------------------------------------------- */
(defun berechneTrgEndeAblng (TrgEnde)
								(print "in berechneTrgEndeAblng")

;    (traeger.set Tr_ID (V_Winkel (- vwnkl_aflch 90.0)))

    (setq vWnklTest (Traeger.get HTrg V_Winkel))
								(print vwnkl_aflch)
								(print vWnklTest)
								
    (if (> vwnkl_aflch 180.0) 
	   (setq vWnkl (- vwnkl_aflch 180.0))
	   (setq vWnkl    vwnkl_aflch)
    )
    (setq vWnkl (- 90.0 (- vWnkl 90.0)))
    								(print vWnkl)
    (if (< vWnkl 0) (setq vWnkl (+ vWnkl 180.0)))
    								(print vWnkl)

    (trende.set     TrgEnde (V_Winkel vWnkl))
    (trende.set     TrgEnde (delta_l 0))

	
    (setq ATr_VWinkel (traeger.get Tr_ID V_Winkel))


    (setq Profil (traeger.get hTrg Profil))
    (setq hProf (traeger.get hTrg h))
    (setq  delta_L (/ hProf 2.0))

    (setq htDeltaV (Traeger.get hTrg delta_V))
    (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
;	(setq delta_L (- (+ delta_L htDeltaV)))
;	(setq delta_L (+ delta_L htDeltaV))
	(setq delta_L (- delta_L htDeltaV))
	(setq cosW (cos (* PI (/ ATr_VWinkel 180.0))))
	(if (/= cosW 0) (setq delta_L (/ delta_L cosW)))
    ))
    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	(setq delta_L (+ delta_L htDeltaV))
	(setq cosW (cos (* PI (/ ATr_VWinkel 180.0))))
	(if (/= cosW 0) (setq delta_L (/ delta_L cosW)))
    ))
    (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
									(print cosW)
    									(print delta_L)

    (if (> vwnkl_aflch 180) (progn
;	    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	    	(setq delta_L (- delta_L))
;	    ))
   ))

   (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	(print "------------- Anschluss am Unterflansch ---------------")
   ))
   (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	(print "------------- Anschluss am Oberflansch ---------------")
	(print vwnkl_aflch)
   ))



    (TrEnde.pTrim TrgEnde delta_L)


)
; ---------------------------------------------------------------------- */
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)

   (print "----------------------------- In calcAndSetBlechdaten")

        (setq hProf (Traeger.get Tr_ID h))

	(setq hp hProf)		; erstmal so voreinstellen
        (setq bp 120)
        (setq dp  50)
        (setq dOK  5)

        (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
        							(print EWinkel)
	(setq sinW (sin (* PI (/ EWinkel 180.0))))
	(if (/= sinW 0) (setq hp (/ hp sinW)))

        (setq hp (- hp dOK 5))	; wir erzeugen eine bndige Kopfplatte
	      
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp 10) (hp hp) (bp bp) (dOK dOK))

    (setq htDeltaV (Traeger.get hTrg delta_V))
;    (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
;	(TrEnde.pTrim TrgEnde (- dp))
;    ))
;    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
;	(TrEnde.pTrim TrgEnde dp)
;    ))

    (setq delta_L dp)
    (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
    								(print delta_L)
;    (TrEnde.pTrim TrgEnde dp)

	
)
; ---------------------------------------------------------------------- */
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde)
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
;		(e       "-1 1 60 0 0 0")
		(e       "60 60 0 0 0 0")
		(w       "80  0")
		
	)
)
(defun calcHaupttrg_TrgEnde (HTrg_TrEnde)
								(print "-- in calcHaupttrg_TrgEnde")
								(print vwnkl_aflch)
  (setq anHTrgEnde 0)
  (setq trgEndeWinkel 90.0)

; -------------------------------------------------------Berechnung TrgEnde-Winkel
  (setq trgEndeWinkel (+ 90.0 (- vwnkl_aflch 270.0)))
; -------------------------------------------------------Unterflansch
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
    (if (= (connect.get CastaData linkesende) 1)  (progn
      (if (< trgEndeWinkel   0) 
         (setq trgEndeWinkel (+ 180.0 trgEndeWinkel))
         (progn
            (if (> trgEndeWinkel 180) 
      		(setq trgEndeWinkel (- trgEndeWinkel 180.0))
      		(setq trgEndeWinkel (- 180.0 trgEndeWinkel))
      	    )
      	 )
      )
      (setq anHTrgEnde 1)
    ))
    (if (= (connect.get CastaData rechtesende) 1)  (progn
      (if (< trgEndeWinkel   0) 
          (setq trgEndeWinkel (- trgEndeWinkel))
          (progn
              (if (> trgEndeWinkel 180) 
           	(setq trgEndeWinkel (- trgEndeWinkel 180.0))
                (setq trgEndeWinkel trgEndeWinkel)
              )
          )
      )
      (setq anHTrgEnde 1)
    ))
  ))
; -------------------------------------------------------Oberflansch
  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
    (if (= (connect.get CastaData linkesende) 1)  (progn
      (if (< trgEndeWinkel   0) 
         (setq trgEndeWinkel (- trgEndeWinkel))
         (progn
            (if (> trgEndeWinkel 180) 
		(setq trgEndeWinkel (- trgEndeWinkel 180.0))
		(setq trgEndeWinkel (- (- 180.0 trgEndeWinkel)))
            )
         )
      )
      (setq anHTrgEnde 1)
    ))
    (if (= (connect.get CastaData rechtesende) 1)  (progn
      (if (< trgEndeWinkel   0) (setq trgEndeWinkel (- trgEndeWinkel)))
      (if (> trgEndeWinkel 180) 
		(setq trgEndeWinkel (- trgEndeWinkel 180.0))
		(setq trgEndeWinkel (- 180.0 trgEndeWinkel))
      )
      (setq anHTrgEnde 1)
    ))
  ))
  (if (< trgEndeWinkel 0) (progn
      (print "!!!!!!!!!!!!!!!!!!!!!!!!!!!! Ende-Winkel Haupttrger ist kleiner 0!!!!!!!!!!!!!")
      (setq trgEndeWinkel (+ 180.0 trgEndeWinkel))
    )
    (progn
      (print "Trg-Ende-Winkel ist OK!!!")
      (print trgEndeWinkel)
    )
  )

  (if (= anHTrgEnde 1) (progn   
	(trEnde.set HTrg_TrEnde (V_Winkel trgEndeWinkel))

	(setq hProf (traeger.get tr_id h))
	(setq  delta_L (- (/ hProf 2.0)))
	(setq delta_L_alt (TrEnde.get HTrg_TrEnde delta_l))
								(print delta_L_alt)
	; ist negativ - deswegen so rum abfragen. Wenn das Ende zu kurz ist, dann
	; muss es verlngert werden.
	(if (> delta_L_alt delta_L)  (trende.set  HTrg_TrEnde (delta_l delta_L)))
      )
   )

   (setq dvTrID (Traeger.get Tr_ID delta_V))
   (TrEnde.ptrim    HTrg_TrEnde dvTrID)

)
; ---------------------------------------------
(defun	createFlanschLochb (flLochbild)
   (setq inOberFlansch  1
         inUnterFlansch 2
         xPos 		(connect.get CastaData xPos_HT)
         hProf		(traeger.get HTrg h)
   )
   (print xPos)


  (if (= (connect.get CastaData anhtlinkesende) 1) (progn
	(print ".......... in HT links Ende ...........")
        (setq delta_L (TrEnde.get HTrLinks delta_L)
              EWnkl   (TrEnde.get HTrLinks V_Winkel)
        )
        (setq dvWnkl  (/ (* 0.5 hProf) (tan (* PI (/ EWnkl 180.0)))))
	(if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	    (setq xPos    (+ xPos delta_L dvWnkl))
	    (setq wAbtl   0.0)
	    (setq Flansch inOberFlansch)
	))
	(if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	    (setq xPos    (+ xPos delta_L (- dvWnkl)))
	    (setq wAbtl   0.0)
	    (setq Flansch inUnterFlansch)
	))
  ))
  (if (= (connect.get CastaData anhtrechtesende) 1) (progn
	(print ".......... in HT rechtes Ende ...........")
	(setq delta_L (TrEnde.get HTrRechts delta_L)
	      EWnkl   (TrEnde.get HTrRechts V_Winkel)
	)
	(setq dvWnkl  (/ (* 0.5 hProf) (tan (* PI (/ EWnkl 180.0)))))
	(if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	    (setq xPos    (- xPos delta_L (- dvWnkl)))
	    (setq wAbtl   180.0)
	    (setq Flansch inOberFlansch)
	))
	(if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	    (print ".... in Unterflansch am rechten Ende des Haupttrgers")
	    (setq xPos    (- xPos delta_L dvWnkl))
	    (setq wAbtl   180.0)
	    (setq Flansch inUnterFlansch)
	))
  ))
  (print delta_L)

  (traeger.addabtl Htrg flLochbild   xPos wAbtl Flansch)

  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
  	(setq xPosLokal (connect.get CastaData xPos_HT))
;	(setq xPos    (+ xPosLokal (- delta_L) (- dvWnkl)))
;	(traeger.addabtl Htrg flLochbild   xPos 0.0 inOberFlansch)
;	(setq gen501ae8 (traeger.get Htrg ABTeil flLochbild))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
  	(setq xPosLokal (connect.get CastaData xPos_HT))
;	(setq xPos    (- xPosLokal (- delta_L) (- dvWnkl)))
;	(traeger.addabtl Htrg flLochbild   xPos 0.0 inUnterFlansch)
;	(setq gen501ae8 (traeger.get Htrg ABTeil flLochbild))
  ))


)