; $	HT	QT(I)		AF(FS)		P(EZ)
; $ 	AT	QT(IU)		AF(K)		P(E)
; $	AE	V(-)		H(90)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; 
; letzte nderung: 18.04.2006
; letztePrfung:		19.04.2006
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-multiconnect-stz-flansch")
   (load "mod_lchb_verschiebungen")
)

(defun init-connection ()
	(setq rwinkel_at (Traeger.get Tr_ID r_winkel))

	; Defaults fr Voutenerstellung - hier initialisieren, werden - sofern Config-Datei
	; vorhanden, aus dieser dann eingelesen und gesetzt
	(setq _Voute_Aus_Profil 0)
    	(setq _Vouten_Default_Laenge 1000)
	(loadConfig "makro_defaults.lsp")		; zentrale Config-Datei mit Defaults
	
	;  knnte auch in eine Config-Datei
	(setq stf_Min_Abstand 30)			; Mindest Abstand zu vorhandenen Steifen
	
	(if (/= rwinkel_at 0.0)
		(alertBox "Bitte setzen Sie den Rotationswinkel des Anschlusstrgers auf 0"   "Set_RotAngle_AT_To_Zero")
  		(setConnection)
 	)
)

(defun setConnection ()
  (print "in init-connection uz_an_Stz-Flansch");
  (init-traegerenden)				

  (print "nachher")
  ; Trgerende-Ablngung aufgrund des Sttzenprofils
  ; Rechtes Ende Anschlusstrger
  
  (setq blSteifeUnten	(blech.create))
  (setq diagSteife	(Blech.create))
  (setq uzVoute		(Voute.create))
  
;  (Connect.storeAnschlObjs CastaData blSteifeUnten diagSteife uzVoute)
  (Connect.storeAnschlObjs CastaData diagSteife uzVoute)
  
  ; Voutendaten berechnen
  (calcAndSetVoutenDaten uzVoute)
  
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
							
				
		(traeger.addabtl tr_id uzVoute 0.0 0.0 _vouterechts_)
  			
		(setq	hVoute 		(Voute.get uzVoute hsteg1)
	      		lVoute 		(Voute.get uzVoute laenge)
	      		ugwVoute 	(Voute.get uzVoute ug_winkel)
		)
		(print ugwVoute)
  	)
  )
  
  ; Linkes Ende Anschlusstrger
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
			

		(traeger.addabtl tr_id uzVoute 0.0 0.0 _voutelinks_)
	
		(setq	hVoute 		(Voute.get uzVoute hsteg1)
	      		lVoute 		(Voute.get uzVoute laenge)
	      		ugwVoute 	(Voute.get uzVoute ug_winkel)
		)
		(print ugwVoute)
  	)
  )


	; Auf Steifen am HT prfen
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq HT_Ende (Traeger.get Htrg links))
			(setq verl (TrEnde.get HT_Ende delta_l))
			(print verl) 
			(checkForSteifeAtPosition verl stf_Min_Abstand Htrg); -> ABTL_VORH
			(if (= ABTL_VORH 0)
				(checkForKplAtPosition verl stf_Min_Abstand Htrg); -> ABTL_VORH
			)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq pos (Traeger.get Htrg laenge))
			(print pos)
			(checkForSteifeAtPosition pos stf_Min_Abstand Htrg); -> ABTL_VORH
			(if (= ABTL_VORH 0)
				(checkForKplAtPosition pos stf_Min_Abstand Htrg); -> ABTL_VORH
			)
		)
	)
	
	(if (= ABTL_VORH 0)
		(progn
		  ; Kopfplatte am Haupttrger
		  (setq blkplHTOben (blech.create))
		  (Connect.storeAnschlObjs CastaData blkplHTOben)
		  ; rechtes Ende am Haupttrger
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) 
		  	(progn
		  	  (print "Kopfplatte rechts am Haupttrger")
			    (calcAndSetBlechdatenKplHT blkplHTOben HTrRechts 0)
			    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplatterechts_)
		  	)
		  )
		  ; linkes Ende am Haupttrger
		  (if (= (connect.get CastaData anHtLinkesEnde) 1) 
		  	(progn
		  	  (print "Kopfplatte links am Haupttrger")
			    (calcAndSetBlechdatenKplHT blkplHTOben HTrLinks 0)
			    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplattelinks_)
		  	)
		  )
		)
	)


	; ******************************************
  ; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
  ; ******************************************
  (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
  (print anzAnschl)
  
  (if (/= anzAnschl 0)
  	(progn
  		(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden.\nberprfen Sie bitte ggf. ob es zu berschneidungen kommt."  "WRN_CheckForCollisions")
  	)
  )
  
  (setq dp 0)
  (createStuetzenSteifen dp hVoute)
  (createTraegerSteife lVoute)
  
  (createDiagonalSteife)
  
  
  ;CALLBACK VOUTE
   (Voute.set uzVoute (formFkt "cb_uzVoute"))
   (if (objExist blkplHTOben)  (Blech.set blkplHTOben (formFkt "cb_blkplHTOben")))
	
)


; ---------------------------------------------------------------------- */
; CALLBACKFUNKTIONEN
; ---------------------------------------------------------------------- */
(defun cb_uzVoute (zp)
	(print "------------------------------------------------------------")
	(print "CALLBACK")
	(print "------------------------------------------------------------")
	(print "in Callback-Funktion cb_uzVoute")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq lVouteAlt (Voute.get uzVoute laenge))
	    (setq hVouteAlt	(Voute.get uzVoute hsteg1))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq lVouteNeu (Voute.get uzVoute laenge))
	    (setq hVouteNeu	(Voute.get uzVoute hsteg1))
	    
	    (print lVouteAlt) (print lVouteNeu)
	    (print hVouteAlt) (print hVouteNeu)
	    
	    ; Lngennderung der Voute
	    (if (/= lVouteAlt lVouteNeu) (progn
		    (setq lDiff (- lVouteNeu lVouteAlt))
		    
			(if (objExist blTrgSteife) (progn
				(setq AbtlSteife_at (Traeger.get Tr_ID ABTeil blTrgSteife))
				   
				(setq alteXPosSteife_at (Anbauteil.get AbtlSteife_at xPos))
			   
				(if (= (Connect.get CastaData LinkesEnde) 1)
					(setq neueXPosSteife_at (+ alteXPosSteife_at lDiff))
				)
				(if (= (Connect.get CastaData RechtesEnde) 1)
					(setq neueXPosSteife_at (- alteXPosSteife_at lDiff))
				)
			
				(Anbauteil.set  AbtlSteife_at (xpos neueXPosSteife_at))
			))
	    ))
	    
	    ; Hhennderung der Voute
	    (if (/= hVouteAlt hVouteNeu) (progn
	        ; Steife muss vorhanden sein - wenn gelscht, dann nicht ausfhren
		(if (objExist blSteifeUnten) (progn
		    (setq hDiff (- hVouteNeu hVouteAlt))
		    (print hDiff)
		    (setq AbtlSteife_ht (Traeger.get Htrg ABTeil blSteifeUnten))
		       
		    ; untere Steife
		    (setq alteXPosSteife_ht (Anbauteil.get AbtlSteife_ht xPos))
		    (print alteXPosSteife_ht)
		    (if (= (Connect.get CastaData anHtLinkesEnde) 1)
			(setq neueXPosSteife_ht (+ alteXPosSteife_ht hDiff))
		    )
		    (if (= (Connect.get CastaData anHtRechtesEnde) 1)
			(setq neueXPosSteife_ht (- alteXPosSteife_ht hDiff))
		    )
		    (print neueXPosSteife_ht)
		    (Anbauteil.set  AbtlSteife_ht (xpos neueXPosSteife_ht))
	    	
		    ; Diagonalsteife
		    (if (objExist diagSteife) (progn
		    	(setq AbtlDiag_ht		(Traeger.get Htrg AbTeil diagSteife))
				(calcDiagonalSteife)
				(Anbauteil.set AbtlDiag_ht 	(xPos xPosDiag)
							(winkel winkel_Diag)
				)
		    ))
	    	
		    (Traeger.updvollstf Htrg)
		))
	    ))
	))
)


(defun cb_blkplHTOben (zp)
	(print "------------------------------------------------------------")
	(print "CALLBACK")
	(print "------------------------------------------------------------")
	(print "in Callback-Funktion cb_blkplHTOben")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_kpl_alt (Blech.get blkplHTOben dp))
	    
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_kpl_neu (Blech.get blkplHTOben dp))
	    
	    ; Lngennderung der Voute
	    (if (/= dp_kpl_alt dp_kpl_neu) (progn
			(if (objExist diagSteife) (progn
				(setq dpDiff (- dp_kpl_neu dp_kpl_alt))
				
				(setq AbtlDiag_ht		(Traeger.get Htrg AbTeil diagSteife))
							
				(calcDiagonalSteife)
				(Anbauteil.set AbtlDiag_ht 	(xPos xPosDiag)
								(winkel winkel_Diag)
				)
			))
	    ))
	    
	    
	))
)


; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */
(defun	createFlanschLochb (flLochbild)
   (setq inOberFlansch  1
         inUnterFlansch 2
         xPos 		(connect.get CastaData xPos_HT)
         hProf		(traeger.get HTrg h)
   )
   (print xPos)

; -- erst mal Dummy
    (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	    (setq wAbtl   0.0)
	    (setq Flansch _flanschlochbild_of_)
    ))
    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	    (setq wAbtl   0.0)
	    (setq Flansch _flanschlochbild_uf_)
    ))
; -- bis hierhin


  (if (= (connect.get CastaData anhtlinkesende) 1) (progn
	(print ".......... in HT links Ende ...........")
        (setq delta_L (TrEnde.get HTrLinks delta_L)
              EWnkl   (TrEnde.get HTrLinks V_Winkel)
        )
        (setq dvWnkl  (/ (* 0.5 hProf) (tan (* PI (/ EWnkl 180.0)))))
	(if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	    (setq xPos    (+ xPos delta_L dvWnkl))
	))
	(if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	    (setq xPos    (+ xPos delta_L (- dvWnkl)))
	))
  ))
  (if (= (connect.get CastaData anhtrechtesende) 1) (progn
	(print ".......... in HT rechtes Ende ...........")
	(setq delta_L (TrEnde.get HTrRechts delta_L)
	      EWnkl   (TrEnde.get HTrRechts V_Winkel)
	)
	(setq dvWnkl  (/ (* 0.5 hProf) (tan (* PI (/ EWnkl 180.0)))))
	(if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	    (setq xPos    (- xPos delta_L (- dvWnkl)))
	    (setq wAbtl   180.0)
	    (setq Flansch _flanschlochbild_of_)
	))
	(if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	    (print ".... in Unterflansch am rechten Ende des Haupttrgers")
	    (setq xPos    (- xPos delta_L dvWnkl))
	    (setq wAbtl   180.0)
	    (setq Flansch _flanschlochbild_uf_)
	))
  ))
  (print delta_L)

  (traeger.addabtl Htrg flLochbild   xPos wAbtl Flansch)

  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
  	(setq xPosLokal (connect.get CastaData xPos_HT))
;	(setq xPos    (+ xPosLokal (- delta_L) (- dvWnkl)))
;	(traeger.addabtl Htrg flLochbild   xPos 0.0 inOberFlansch)
;	(setq gen501ae8 (traeger.get Htrg ABTeil flLochbild))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
  	(setq xPosLokal (connect.get CastaData xPos_HT))
;	(setq xPos    (- xPosLokal (- delta_L) (- dvWnkl)))
;	(traeger.addabtl Htrg flLochbild   xPos 0.0 inUnterFlansch)
;	(setq gen501ae8 (traeger.get Htrg ABTeil flLochbild))
  ))


)



; ********************************************************************************
; Erzeugt u. berechnet die Blechdaten fr die Kopfplatte
; ********************************************************************************
(defun calcAndSetBlechdatenKplHT (blKopfplatte TrgEnde kplVerl)

   (print "---------------- calcAndSetBlechdatenKplHT -------------------------------")

   (setq hProf (Traeger.get HTrg h))		; Hhe des Haupttrgerprofils

   (setq hp  hProf)				; erstmal so voreinstellen
   (setq bp  (Traeger.get Htrg b))		; Breite
   (setq dp  20)
   
   
   (setq schwKante 0)				
   
   (if (= (connect.get CastaData amHtUnterFlansch) 1) 
   (progn
   	(setq dOK schwKante)
   ))
   (if (= (connect.get CastaData amHtOberFlansch) 1)
   (progn
   	(setq vers (+ kplverl schwKante)) 
   	(setq dOK (- vers))
   ))
   
   
   (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
   (print EWinkel)
        							
   								
   (setq hp (+ hp  kplverl))	
   (setq sinW (sin (* PI (/ EWinkel 180.0))))
	
   (if (/= sinW 0) (setq hp (/ hp sinW)))
        
   
   (Blech.set blKopfplatte (dp dp) (hp hp) (bp bp) (dOK dOK))

   (setq htDeltaV (Traeger.get hTrg delta_V))


    (setq delta_L dp)
    (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
    	
    (print dp)							(print delta_L)
    
		(TrEnde.ptrim TrgEnde dp)
    (print "---------------- ENDE -------------------------------")
)





; -------------------------------------------------------------
; Erzeugt die Steifen im HT
; -------------------------------------------------------------
(defun createStuetzenSteifen (dp hVoute)
	(print "ERZEUGE STTZENSTEIFEN")
	(print "------------------------------------------------------------")
	(setq hProf    (Traeger.get  Tr_Id h)
	      tProf    (Traeger.get  Tr_Id t)
	      dV       (Traeger.get  Tr_Id delta_V)
	      dVStz		 (Traeger.get  Htrg  delta_v)
	      hStz     (Traeger.get  HTrg  h)
	      VWnkl    		(Connect.get CastaData trg_vwinkel)
	      afl_Winkel	(Connect.get CastaData afl_vwinkel)
	)
	
	
	; Anteil AT
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq vschl (TrEnde.get TrgEnde vscherl))
	(setq vscherl_halb (* 0.5 vschl))
	(print vscherl_halb)
	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	(setq tanAlfa (tan (/ (* VWnkl PI) 180.0)))
	(print cosAlfa)
	(print tanAlfa)
	(setq tanAfl (tan (/ (* afl_Winkel PI) 180.0)))
	(print tanAfl)
	
	; Anteil delta_v Verschiebung des AT
	(if (/= cosAlfa 0.0) (setq dV (/ dV cosAlfa)))

  (setq xPos (connect.get CastaData xPos_HT))
  
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
  	(setq xPosUnten (- xPos vscherl_halb dV hVoute))
  )
  (if (= (Connect.get CastaData anHtLinkesEnde) 1)
  	(setq xPosUnten (+ xPos vscherl_halb dV hVoute))
  )
  
	(print dp)
	;Anteil der Trgerneigung
	(setq xPos_H  (/ (* 0.5 hStz) tanAfl))
		
	;Anteil der Stirnplatte des AT
	;(setq xPos_dp (* tanAlfa dp))
	(setq xPos_dp (/ dp tanAfl))
	(print xPos_H)
	(print xPos_dp)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq xPos_dp (- xPos_dp))
	)
  
  ; Anteil aus Verschiebung HT (delta_v)
  (setq dv_HT (/ dVStz tanAfl))
  (if (= (Connect.get CastaData amHTUnterflansch) 1)
  	(setq dv_HT (- dv_HT))
  )
  
  (if (= tanAlfa 0.0)
  	(setq xPos_dp (- 5))
  )
  
  (setq xPosUnten (+ xPosUnten xPos_H xPos_dp (- dv_ht)))

	(if (= (connect.get CastaData AnschlZwHtEnden) 1) 
		(progn
			(setq VWnkl 0.0)
		)
	)

	
	; Auf Steifen am HT prfen
	(checkForSteifeAtPosition xPosUnten 50 Htrg)
	(if (= ABTL_VORH 0)
		(progn
			(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)  ;1539
			(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
			(Anbauteil.set  AbtlSteife (xpos xPosUnten))
		  	(Connect.storeAnschlObjs CastaData blSteifeUnten)	; wird hier jetzt vermerkt
		)
	)

	; Das kann so nicht bleiben, weil andere Steifen nicht gendert
	; werden sollen!
	(Traeger.updvollstf Htrg)
	(print "ENDE STTZENSTEIFEN")

)


;************************************************************************
(defun createTraegerSteife (lVoute)

	(print "ERZEUGE TRGERSTEIFE")
	(setq blTrgSteife (blech.create))
	(Connect.storeAnschlObjs CastaData blTrgSteife)
	
	(Blech.set blTrgSteife (dp 10))
	
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(setq TrLinks   (traeger.get tr_id links))
  	  (setq delta_L (TrEnde.get TrLinks delta_l)
  	    	  EWnkl   (TrEnde.get TrLinks V_Winkel)
  	    	  VWnkl   (- EWnkl 90.0)
  	    	  h_Trg    (Traeger.get Tr_ID h)
  	  )
  	  
  	  (setq dV (* 0.5 h_Trg (tan (/ (* PI VWnkl) 180.0))))
  	  (print dV)
	    (setq xPosTraeger (+ lVoute delta_L dV))
  	)
  )
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(setq TrRechts  (traeger.get tr_id rechts))
  	  (setq delta_L (TrEnde.get TrRechts delta_l)
  	  			EWnkl   (TrEnde.get TrRechts V_Winkel)
  	    	  VWnkl   (- 90.0 EWnkl )
  	    	  h_Trg    (Traeger.get Tr_ID h)
  	  )
  	  (print EWnkl)
  	  (print VWnkl)
  	  (setq dV (* 0.5 h_Trg (tan (/ (* PI VWnkl) 180.0))))
  	  (print dV)
  	  (setq TrgLaenge (Traeger.get Tr_ID SysLng))
			(setq xPosTraeger (- TrgLaenge lVoute delta_L dV))
  	)
  )

	(traeger.addabtl Tr_ID blTrgSteife 0.0 0.0 1539)
	(setq AbtlSteife (traeger.get Tr_ID ABTeil blTrgSteife))
	(Anbauteil.set  AbtlSteife (xpos xPosTraeger) (Winkel 0.0))

	; Auch nur Behelfslsung (siehe oben)
	(Traeger.updvollstf Tr_ID)
	(print "ENDE TRGERSTEIFE")
)

; ----------------------------------------------------------------------------------------
; ERZEUGT DIE DIAGONALSTEIFE
; ----------------------------------------------------------------------------------------
(defun createDiagonalSteife ()
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE DIAGONALSTEIFE")
	
	(calcDiagonalSteife)
	
	(Traeger.addabtl Htrg diagSteife xPosDiag winkel_diag _vollsteife_beids_)
	
	(print "<-----------------------------------------------------------")
)

(defun calcDiagonalSteife ()
	(setq	h_ht	(Traeger.get Htrg h)
		t_ht	(Traeger.get Htrg t)
	)
	
	(setq	xPos_ht 	(Connect.get CastaData xPos_ht)
		afl_winkel	(Connect.get CastaData afl_vwinkel)
	)
	(print xPos_ht)
	(print afl_winkel)
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	(print tanAfl)

	(setq 	xPosSteife 0.0)			;; hier genau ermitteln
	(setq AbtlSteife (Traeger.get Htrg ABTeil blSteifeUnten))
	(if (objExist AbtlSteife) (progn
		(setq xPosSteife (Anbauteil.get AbtlSteife xpos))
	))
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq TrgEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq TrgEnde (Traeger.get Htrg rechts))
	)
	
	; Xpos berechnen
	(setq anteil_ht (- (* 0.5 h_ht) t_ht)) ; halbe Hoehe ohne Flanschdicke
	
	(setq delta_l (TrEnde.get TrgEnde delta_l))
	(print delta_l)
	
	(setq anteil_neig (/ anteil_ht tanAfl))
	(print anteil_neig)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq diff_xPos (- xPosSteife xPos_ht))
			(setq laenge (+ diff_xPos (- delta_l) anteil_neig))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq diff_xPos (- xPos_ht xPosSteife))
			(setq laenge (+ diff_xPos (- delta_l) (- anteil_neig)))
		)
	)
	(print diff_xPos)
	(print laenge)
	
	(setq laenge_halb	(* 0.5 laenge))
	
	(setq diff (- diff_xPos laenge_halb))
	(print diff)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq xPosDiag (+ xPos_ht diff))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq xPosDiag (- xPos_ht diff))
	)
	(print xPosDiag)
	
	
	; Winkel berechnen
	(setq winkel_diag_rad (atan (/ anteil_ht laenge_halb)))
	(print winkel_diag_rad)
	(setq winkel_diag (* (/ winkel_diag_rad PI) 180.0))
	(print winkel_diag)
	(setq winkel_diag (- (- 90.0 winkel_diag)))
	(print winkel_diag)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(setq winkel_diag (- winkel_diag))
			)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(setq winkel_diag (- winkel_diag))
			)
		)
	)
)


(defun calcAndSetVoutenDaten (Voute_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE VOUTENDATEN")
	
	(setq	l_at	(Traeger.get Tr_ID laenge)
		h_at	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
	)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(print l_at)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanAW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinAW (sin (/ (* PI at_winkel) 180.0)))
	
	(if (> at_winkel 90.0)
		(progn
			(setq anteil_at_neigung (/ h_at tanAW))
			(print anteil_at_neigung)
			
			(setq l_at (+ l_at anteil_at_neigung))
			(print l_at)
		)
	)
	
	; Voutenlnge
	(if (< l_at _Vouten_Default_Laenge)
		(setq laenge_voute l_at)
		(setq laenge_voute _Vouten_Default_Laenge)
	)
	(print laenge_voute)
	
	
	; Voutenhhe
	(setq hoehe_voute (* 0.5 laenge_voute))
	
	; Flanschbreite
	(if (<= b_at b_ht)
		(setq breite_flansch b_at)
		(setq breite_flansch b_ht)
	)
	
	; Daten setzen
	(Voute.set Voute_ID 
		(laenge	 		laenge_voute) 
		(hsteg1	 		hoehe_voute) 
		(d_OK 			0) 
		(t_flansch  10) 
		(b_flansch  breite_flansch) 
		(t_steg	  	10)
	)

	; als Einstellung setzen - Alternative also
	(if (= _Voute_Aus_Profil 1) (progn
		(setq TrProfil (Traeger.get Tr_ID Profil))
		(Voute.set Voute_ID (Profil TrProfil))
	))
	
	(print ">-----------------------------------------------------------")
)