; $	HT	QT(I)		AF(FS)	P(EZ)
; $ 	AT	QT(IU)		AF(K)		P(E)
; $	AE	V(-)			H(90)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; 
; letzte nderung: 	19.04.2006
; letztePrfung:		19.04.2006	
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-multiconnect-stz-flansch")
   (load "mod-lochbild")
   (load "mod_lchb_verschiebungen")
)

(defun init-connection ()
	(setq rwinkel_at (Traeger.get Tr_ID r_winkel))

	; Defaults fr Voutenerstellung - hier initialisieren, werden - sofern Config-Datei
	; vorhanden, aus dieser dann eingelesen und gesetzt
	(setq _Voute_Aus_Profil 0)
    	(setq _Vouten_Default_Laenge 1000)
	(loadConfig "makro_defaults.lsp")		; zentrale Config-Datei mit Defaults

	;  knnte auch in eine Config-Datei
	(setq min_Blech_Abstand 40)			; Mindest Abstand zu vorhandenen Steifen
	
	(if (/= rwinkel_at 0.0)
		(alertBox "Bitte setzen Sie den Rotationswinkel des Anschlusstrgers auf 0"   "Set_RotAngle_AT_To_Zero")
  	(setConnection)
 	) 
)

(defun setConnection ()
	(print "in init-connection uz_an_Stz-Flansch");
  (init-traegerenden)				; hier werden die Traegerenden gestutzt
														; eventuell spter alte Werte merken,
														; falls Ende schon bearbeitet wurde.

  (print "nachher")
  
  (setq blKpl (blech.create))
  (setq uzVoute	(Voute.create))
  (setq lchbKpl	(Lochbild.create))
	(Connect.storeAnschlObjs CastaData blKpl uzVoute lchbKpl)

  ; Kopfplatte noch nicht erzeugt - wird gesetzt, wenn sie erzeugt wurde
  (setq KPL_CREATED 0)
  
  ; Kopfplattendicke berechnen
  (setKplDicke blKpl)
  
  ; Voutendaten berechnen
  (calcAndSetVoutenDaten uzVoute blKpl)
  
  ; Kopfplattendaten berechnen
  (calcAndSetBlechdaten blKpl uzVoute)
  
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
				
				
		(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplatterechts_)

		(traeger.addabtl tr_id uzVoute 0.0 0.0 _vouterechts_)
  			
  			
		(calcAndSetLochbildDaten lchbKpl TrRechts blKpl uzVoute);
		(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildrechts_)
		(createFlanschLochb lchbKpl)

		(calcHVerschLochbild 			lchbKpl)	; 20052009	AF
		(setzeFlanschLochbSeitenRichtung	lchbKpl)	; 20052009	AF

		(setq	dp    		(Blech.get blKpl dp)
	      		hVoute 		(Voute.get uzVoute hsteg1)
	      		lVoute 		(Voute.get uzVoute laenge)
	      		ugwVoute 	(Voute.get uzVoute ug_winkel)
		)
		(print ugwVoute)
  	)
  )
  
  ; Linkes Ende Anschlusstrger
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
			
		(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplattelinks_)

		(traeger.addabtl tr_id uzVoute 0.0 0.0 _voutelinks_)

			
		(calcAndSetLochbildDaten lchbKpl TrLinks blKpl uzVoute);
		(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildlinks_)
		(createFlanschLochb lchbKpl)

		(calcHVerschLochbild 			lchbKpl)	; 20052009	AF
		(setzeFlanschLochbSeitenRichtung	lchbKpl)	; 20052009	AF
	
		(setq	dp     		(Blech.get blKpl dp)
	      		hVoute 		(Voute.get uzVoute hsteg1)
	      		lVoute 		(Voute.get uzVoute laenge)
	      		ugwVoute 	(Voute.get uzVoute ug_winkel)
		)
		(print ugwVoute)
  	)
  )


	; Auf Steifen am HT prfen
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq HT_Ende (Traeger.get Htrg links))
			(setq verl (TrEnde.get HT_Ende delta_l))
			(print verl) 
			(checkForSteifeAtPosition verl min_Blech_Abstand Htrg); -> ABTL_VORH
			(if (= ABTL_VORH 0)
				(checkForKplAtPosition verl min_Blech_Abstand Htrg); -> ABTL_VORH
			)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq pos (Traeger.get Htrg laenge))
			(print pos)
			(checkForSteifeAtPosition pos min_Blech_Abstand Htrg); -> ABTL_VORH
			(if (= ABTL_VORH 0)
				(checkForKplAtPosition pos min_Blech_Abstand Htrg); -> ABTL_VORH
			)
		)
	)
	
	(if (= ABTL_VORH 0)
		(progn
			; ZUGLASCHE
		  ; Kopfplatte am Haupttrger
		  (setq blkplHTOben (blech.create))
		  (setq zuglLochbild (Lochbild.create))
			(Connect.storeAnschlObjs CastaData blkplHTOben zuglLochbild)
			
			(calcSchrBez Tr_ID) ; -> S_Bez_toSet (z.B. S_Bez_toSet = "M16")
			
			(Lochbild.set zuglLochbild (S_Bez S_Bez_toSet))
			
			(calcMinRandLochAbst zuglLochbild) ; -> minE_rand, minE_loch
			
			(calcKplVerl blKpl e_min e1_min) ; -> kplVerl
			
		  ; rechtes Ende am Haupttrger
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) 
		  	(progn
		  	  (print "Kopfplatte rechts am Haupttrger")
			    (calcAndSetBlechdatenKplHT blkplHTOben HTrRechts kplVerl)
			    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplatterechts_)
			    (setq KPL_CREATED 1)
			    
			    (createZuglaschenLochbild blkplHTOben zuglLochbild kplVerl)
		  	)
		  )
		  ; linkes Ende am Haupttrger
		  (if (= (connect.get CastaData anHtLinkesEnde) 1) 
		  	(progn
		  	  (print "Kopfplatte links am Haupttrger")
			    (calcAndSetBlechdatenKplHT blkplHTOben HTrLinks kplVerl)
			    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplattelinks_)
			    (setq KPL_CREATED 1)
			    
			    (createZuglaschenLochbild blkplHTOben zuglLochbild kplVerl)
		  	)
		  )
		)
	)

	
	; ******************************************
  ; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
  ; ******************************************
  (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
  (print anzAnschl)
  
  (if (/= anzAnschl 0)
  	(progn
  		(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden.\nberprfen Sie bitte ggf. ob es zu berschneidungen kommt."  "WRN_CheckForCollisions")
  	)
  )


  (createStuetzenSteifen dp hVoute)
  (createTraegerSteife lVoute)
  
  
	;  callbacks hinzufgen - Zuglasche knnte auch fehlen, wenn bereits Anbauteil in dem Bereich vorhanden ist. 
	(Voute.set uzVoute (formFkt "cb_uzVoute"))						; Voute
	(Blech.set blKpl (formFkt "cb_KplBlech"))						; Kopfplatte am AT
	(if (= KPL_CREATED 1)  (Blech.set blkplHTOben (formFkt "cb_blkplHTOben")))		; Kopfplatte / Zuglasche
	
)


; ---------------------------------------------------------------------- */
; CALLBACKFUNKTIONEN
; ---------------------------------------------------------------------- */
(defun cb_uzVoute (zp)
	(print "------------------------------------------------------------")
	(print "CALLBACK")
	(print "------------------------------------------------------------")
	(print "in Callback-Funktion cb_uzVoute")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq lVouteAlt (Voute.get uzVoute laenge))
	    (setq hVouteAlt	(Voute.get uzVoute hsteg1))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq lVouteNeu (Voute.get uzVoute laenge))
	    (setq hVouteNeu	(Voute.get uzVoute hsteg1))
	    
	    (print lVouteAlt) (print lVouteNeu)
	    (print hVouteAlt) (print hVouteNeu)
	    
	    ; Lngennderung der Voute
	    (if (/= lVouteAlt lVouteNeu) (progn
		    (setq lDiff (- lVouteNeu lVouteAlt))
		    
			(if (objExist blTrgSteife) (progn
				(setq AbtlSteife_at (Traeger.get Tr_ID ABTeil blTrgSteife))
				   
				(setq alteXPosSteife_at (Anbauteil.get AbtlSteife_at xPos))
			   
				(if (= (Connect.get CastaData LinkesEnde) 1)
					(setq neueXPosSteife_at (+ alteXPosSteife_at lDiff))
				)
				(if (= (Connect.get CastaData RechtesEnde) 1)
					(setq neueXPosSteife_at (- alteXPosSteife_at lDiff))
				)
			
				(Anbauteil.set  AbtlSteife_at (xpos neueXPosSteife_at))
			))
	    ))
	    
	    ; Hhennderung der Voute
	    (if (/= hVouteAlt hVouteNeu) (progn
	        ; Steife muss vorhanden sein - wenn gelscht, dann nicht ausfhren
		(if (objExist blSteifeUnten) (progn
		    (setq hDiff (- hVouteNeu hVouteAlt))
		    (print hDiff)
		    (setq AbtlSteife_ht (Traeger.get Htrg ABTeil blSteifeUnten))
		       
		    (setq alteXPosSteife_ht (Anbauteil.get AbtlSteife_ht xPos))
		    (print alteXPosSteife_ht)
		    (if (= (Connect.get CastaData anHtLinkesEnde) 1)
			(setq neueXPosSteife_ht (+ alteXPosSteife_ht hDiff))
		    )
		    (if (= (Connect.get CastaData anHtRechtesEnde) 1)
			(setq neueXPosSteife_ht (- alteXPosSteife_ht hDiff))
		    )
		    (print neueXPosSteife_ht)
		    (Anbauteil.set  AbtlSteife_ht (xpos neueXPosSteife_ht))
		))
	    ))
	))
)


(defun cb_KplBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lchbKpl Klemml))
	       (setq altesDxS		(Lochbild.get lchbKpl dxsKopf))
	       
	       (Lochbild.set lchbKpl 	(Klemml (+ alteKlemml dpDiff))
	       												(DxSKopf (+ altesDxS dpDiff))
	       )
	       
		   (if (objExist blTrgSteife) (progn
				(setq AbtlSteife_at (Traeger.get Tr_ID ABTeil blTrgSteife))
		       
				(setq alteXPosSteife_at (Anbauteil.get AbtlSteife_at xPos))
	       
				(if (= (Connect.get CastaData LinkesEnde) 1)
					(setq neueXPosSteife_at (+ alteXPosSteife_at dpDiff))
				)
				(if (= (Connect.get CastaData RechtesEnde) 1)
					(setq neueXPosSteife_at (- alteXPosSteife_at dpDiff))
				)
				(Anbauteil.set  AbtlSteife_at (xpos neueXPosSteife_at))
			))
	    ))
	))
)


(defun cb_blkplHTOben (zp)
 
 (print "*clear*")
	(print "in Callback-Funktion cb_blkplHTOben")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 	(Blech.get blkplHTOben dp))
	    (setq hpAlt 	(Blech.get blkplHTOben hp))	   
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu 	(Blech.get blkplHTOben dp))
	    (setq hpNeu 	(Blech.get blkplHTOben hp))
	    
	    (print dpAlt) (print dpNeu)
	    (print hpAlt) (print hpNeu)
	    
	    ; dp der Zuglasche wurde gendert
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       
	       (setq alteKlemml (Lochbild.get zuglLochbild Klemml))
	       (setq altesDxS		(Lochbild.get zuglLochbild dxsKopf))
	       
	       (setq klemml_neu 	(+ alteKlemml dpDiff))
	       (setq dxskopf_neu	(+ altesDxS dpDiff))
	       
	       (print alteKlemml)
	       (print klemml_neu)
	       (print altesDxS)
	       (print dxskopf_neu)
	       
	       (Lochbild.set zuglLochbild 	(Klemml klemml_neu)
	       															(DxSKopf dxskopf_neu)
	       )
	       
	      (if (= (Connect.get CastaData anHtLinkesEnde) 1)
	      	(setq HT_Ende (Traeger.get Htrg links))
	      )
	      (if (= (Connect.get CastaData anHtRechtesEnde) 1)
	      	(setq HT_Ende (Traeger.get Htrg rechts))
	      )
	      
	      (setq delta_l_alt	(TrEnde.get HT_Ende delta_l))
	      (setq delta_l_neu (- delta_l_alt dpDiff))
	      
	      (TrEnde.set HT_Ende (delta_l delta_l_neu))
	      
	    ))
	    
	    ; hp der Zuglasche wurde gendert
	    (if (= 1 2) (progn
		    (if (/= hpAlt hpNeu) (progn
		       (setq hpDiff (- hpNeu hpAlt))
		       
		       (setq dok_Blech_Alt	(Blech.get blkplHTOben dok))
		       
		       (setq dok_Blech_neu	(- dok_Blech_Alt hpDiff))
		       
		       (Blech.set blkplHTOben (dok dok_Blech_neu))	       
		    ))
	    ))
	))
	
)

; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */
(defun	createFlanschLochb (flLochbild)
   (print "-----------------------------------------------------------")
   (print "ERZEUGE FLANSCHLOCHBILD")
   (setq xPos 				(Connect.get CastaData xPos_HT)
   			 afl_vwinkel	(Connect.get CastaData afl_vwinkel)
   )
   
   (setq hProf		(Traeger.get HTrg h)
   	 delta_v_ht	(Traeger.get Htrg delta_v)
   	 delta_lr_ht	(Traeger.get Htrg delta_lr)
   )
   
   (setq h_at		(Traeger.get Tr_ID h)
   	 delta_v_at	(Traeger.get Tr_ID delta_v)
   	 delta_lr_at	(Traeger.get Tr_ID delta_lr)
   )
   
   (print xPos)
   
  (if (= (Connect.get CastaData linkesEnde) 1)
  	(setq AT_Ende (Traeger.get Tr_ID links))
  )
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(setq AT_Ende (Traeger.get Tr_ID rechts))
  )
  
  (setq vscherl_at	(TrEnde.get AT_Ende vscherl))
  (setq vscherl_at_halb	(* 0.5 vscherl_at))

	(setq afl_w (- 90.0 afl_vwinkel))
	(setq tan_W	(tan (/ (* PI afl_w) 180.0)))
	(setq cos_W	(cos (/ (* PI afl_w) 180.0)))
	
	(print afl_vwinkel)
	(print afl_w)
	(print tan_W)


  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	  (setq wAbtl   0.0)
	  (setq Flansch _flanschlochbild_of_)
	  (setq anteil_neigung (* (- (* 0.5 hProf) delta_v_ht) tan_W))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	  (setq wAbtl   0.0)
	  (setq Flansch _flanschlochbild_uf_)
	  (setq anteil_neigung (* (+ (* 0.5 hProf) delta_v_ht) tan_W))
  ))

	(print anteil_neigung)
	(print vscherl_at_halb)

  (if (= (connect.get CastaData anhtlinkesende) 1) 
  	(progn
			(print ".......... in HT links Ende ...........")
			(if (= (connect.get CastaData amHtOberFlansch) 1) 
				(progn
	    		(setq xPos    (- xPos vscherl_at_halb (- anteil_neigung)))
				)
			)
			(if (= (connect.get CastaData amHtUnterFlansch) 1) 
				(progn
	    		(setq xPos    (- xPos vscherl_at_halb (- anteil_neigung)))
				)
			)
  	)
  )
  (if (= (connect.get CastaData anhtrechtesende) 1) 
  	(progn
			(print ".......... in HT rechtes Ende ...........")
			(if (= (connect.get CastaData amHtOberFlansch) 1) 
				(progn
	    		(setq xPos    (+ xPos vscherl_at_halb anteil_neigung))
	    		(setq wAbtl   180.0)
	    		(setq Flansch _flanschlochbild_of_)
				)
			)
			(if (= (connect.get CastaData amHtUnterFlansch) 1) 
				(progn
	    		(print ".... in Unterflansch am rechten Ende des Haupttrgers")
	    		(setq xPos    (+ xPos vscherl_at_halb anteil_neigung))
	    		(setq wAbtl   180.0)
	    		(setq Flansch _flanschlochbild_uf_)
				)
			)
  	)
  )
  (print xPos)
  
  ; Anteil delta_v Verschiebung AT
  (setq anteil_delta_v_at (/ delta_v_at cos_W))
  (print anteil_delta_v_at)
  
  (if (= (connect.get CastaData anhtrechtesende) 1) 
  	(setq xPos (- xPos anteil_delta_v_at))
  )
  (if (= (connect.get CastaData anhtlinkesende) 1) 
  	(setq xPos (+ xPos anteil_delta_v_at))
  )
  
  
  ; ANSCHLUSS ZWISCHEN DEN ENDEN
  (if (= (connect.get CastaData anschlzwhtenden) 1) 
  	(progn
  		(print ".......... zwischen den Ende ...........")
			
			(setq afl_wnkl (Connect.get CastaData afl_vwinkel))
			(print afl_wnkl)
			(setq wnkl (- afl_wnkl 90.0))
			(print wnkl)
			(setq dvWnkl  (* (* 0.5 hProf) (tan (* PI (/ wnkl 180.0)))))
			(print dvWnkl)
			
			(if (= (connect.get CastaData amHtOberFlansch) 1) 
				(progn
	    		(setq xPos    (+ xPos (* 0.5 h_at) (- dvWnkl)))
	    		(setq wAbtl   180.0)
	    		(setq Flansch _flanschlochbild_of_)
				)
			)
			(if (= (connect.get CastaData amHtUnterFlansch) 1) 
				(progn
	    		(setq xPos    (+ xPos (* 0.5 h_at) dvWnkl))
	    		(setq wAbtl   180.0)
	    		(setq Flansch _flanschlochbild_uf_)
				)
			)
  	)
  )
  (print delta_L)

    (if (= 1 1) (progn
	; Verschiebung delta_lr AT
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
	    )
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
	    )
	)
    ))	
	
	; Verschiebung delta_lr HT
    (if (= 1 1) (progn
	(if (= (Connect.get CastaData rechtesEnde) 1)
	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
	    )
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_abt_ht (* 1.0 delta_lr_ht))))
	    )
	)
    ))


  (traeger.addabtl Htrg flLochbild   xPos wAbtl Flansch)

  (setq abtl_ht (Traeger.get HTrg AbTeil flLochbild))

  (Anbauteil.set abtl_ht  (delta_lr	delta_lr_abt_ht))



  (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
  	(setq xPosLokal (connect.get CastaData xPos_HT))
;	(setq xPos    (+ xPosLokal (- delta_L) (- dvWnkl)))
;	(traeger.addabtl Htrg flLochbild   xPos 0.0 inOberFlansch)
;	(setq gen501ae8 (traeger.get Htrg ABTeil flLochbild))
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
  	(setq xPosLokal (connect.get CastaData xPos_HT))
;	(setq xPos    (- xPosLokal (- delta_L) (- dvWnkl)))
;	(traeger.addabtl Htrg flLochbild   xPos 0.0 inUnterFlansch)
;	(setq gen501ae8 (traeger.get Htrg ABTeil flLochbild))
  ))
)

; ----------------------------------------------------------------------
(defun calcAndSetBlechdaten (Blech_ID Voute_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTE")
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID rechts))
	)
	
	(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
	
	(setq h_Voute 		(Voute.get Voute_ID hsteg1)
				t_voute_fl	(Voute.get Voute_ID t_flansch)
	)
	
  (setq hProf (Traeger.get Tr_ID h)
  			b_at	(Traeger.get Tr_ID b)
  )
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))	
	
  (setq dp (Blech.get Blech_ID dp))
  
  ; dok der Kopfplatte
  (setq anteil_kpl_dp (/ (* 1.0 dp) tanW))
	(setq dOK anteil_kpl_dp)
	
	; Kopfplattenbreite
	(if (<= b_at b_ht)
		(setq bp b_at)
		(setq bp b_ht)
	)
	
	; Kopfplattenhhe
	(setq hp (+ (- dok) vscherl_at h_Voute (* 3.0 t_voute_fl)))
  
  
  
	(Blech.set Blech_ID (dp dp) (hp hp) (bp bp) (dOK dOK))

  (setq htDeltaV (Traeger.get hTrg delta_V))


  (setq delta_L dp)
  (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
  (print delta_L)
  
  (TrEnde.pTrim AT_Ende dp)

	(print "<-------------------------------------------------------------------------------")
)


; ********************************************************************************
; Erzeugt u. berechnet die Blechdaten fr die Kopfplatte
; ********************************************************************************
(defun calcAndSetBlechdatenKplHT (blKopfplatte TrgEnde kplVerl)

   (print "---------------- calcAndSetBlechdatenKplHT -------------------------------")

   (setq hProf (Traeger.get HTrg h))		; Hhe des Haupttrgerprofils

   (setq hp  hProf)				; erstmal so voreinstellen
   (setq bp  (Traeger.get Tr_ID b))		; Breite
   (setq dp  20)
   
   ;(setq kplverl 120)				; Verlngerung der Kopfplatte
   (setq schwKante 0)				
   
   (if (= (connect.get CastaData amHtUnterFlansch) 1) 
   (progn
   	(setq dOK schwKante)
   ))
   (if (= (connect.get CastaData amHtOberFlansch) 1)
   (progn
   	(setq vers (+ kplverl schwKante)) 
   	(setq dOK (- vers))
   ))
   
   
   (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
   (print EWinkel)
        							
   								
   (setq hp (+ hp  kplverl))	
   (setq sinW (sin (* PI (/ EWinkel 180.0))))
	
   (if (/= sinW 0) (setq hp (/ hp sinW)))
        
        ;(setq hp (+ hp hVoute 40))
	      
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
   (Blech.set blKopfplatte (dp dp) (hp hp) (bp bp) (dOK dOK))

   (setq htDeltaV (Traeger.get hTrg delta_V))
;    (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
;	(TrEnde.pTrim TrgEnde (- dp))
;    ))
;    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
;	(TrEnde.pTrim TrgEnde dp)
;    ))

    (setq delta_L dp)
    (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
    	
    (print dp)							(print delta_L)
    ;(TrEnde.pTrim TrgEnde dp)

    (print "---------------- ENDE -------------------------------")
)




; ----------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde Blech_ID Voute_ID)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
;		(e       "-1 1 60 0 0 0")
		(e       "0 510 0 0 0 0")
		(w       "80  0")

	)
	
	(setq t_htrg (Traeger.get htrg t))
	
	(setq s_at	(Traeger.get Tr_ID s)
				t_at	(Traeger.get Tr_ID t)
				r_at	(Traeger.get Tr_ID r)
	)
	
	(setq dp_blech (Blech.get Blech_ID dp))
	
	(setq hp_kpl 	(Blech.get Blech_ID hp)
				bp_kpl	(Blech.get Blech_ID bp)
	)
	
	(Lochbild.set Lchb_ID (klemml (+ t_htrg dp_blech))
												(dxskopf dp_blech)
	)
	
	; Schraubengre berechnen
	(if (> t_htrg dp_blech)
		(setq min_blech dp_blech)
		(setq min_blech t_htrg)
	)
	(calcSchraube min_blech) ; => S_Bez
	
	; Schraubengre setzen
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	
	; Rand- u. Lochabstnde
	(calcMinRandLochAbst Lchb_ID) ; => e_min, e1_min, e_min_rund, e1_min_rund, h_min 
	
	; SchraubenLnge
	(setq schr_l (Lochbild.get Lchb_ID laenge))
	(print schr_l)
	
	
	; e0 berechnen	
	;(setq vWinkel_ht (TrEnde.get TrgEnde v_winkel)) 
	;(print vWinkel_ht)
	
	;(setq wnkl (- vWinkel_ht 90.0))
	;(print wnkl)
	
	;(if (< wnkl 0.0) (setq wnkl (- wnkl)))
	
	;(setq tanW (tan (/ (* PI wnkl) 180.0)))
	;(print tanW)
	
	;(setq min_e0 (* schr_l tanW))
	;(print min_e0)
	
	;(setq e0 (+ min_e0 50))
	;(print e0)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq sinAW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq t_r_at	(/ (+ t_at r_at) sinAW))
	
	(setq abst_schr_of	(+ t_r_at (* 1.0 e_min)))
	(setq e0 abst_schr_of)
	
	; e1 berechnen
	(setq ugVoutenWnkl	(Voute.get Voute_ID ug_winkel))
	(print ugVoutenWnkl)
	
	(setq tanUG	(tan (/ (* PI ugVoutenWnkl) 180.0)))
	(print tanUG)
	
	(setq min_Abst_von_VteUG (* schr_l tanUG))
	(print min_Abst_von_VteUG)
	
	(setq e1 (- hp_kpl e0 min_Abst_von_VteUG 40 40))
	(print e1)
	
	; w0 berechnen
	(setq w0 (+ (/ (- bp_kpl s_at) 2.0) s_at))
	
	(Lochbild.set Lchb_ID (e0 e0)
												(e1 e1)
												(w0 w0)
	)
	
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild der Zuglasche
; ----------------------------------------------------------------------------------------
(defun createZuglaschenLochbild (Blech_ID zuglLochbild kplverl)
	(print "BERECHNE ZUGLASCHENLOCHBILD")
	
	
	(Lochbild.set zuglLochbild 	(Guete   "4.6")
	)
	
	(setq t_at 		(Traeger.get Tr_ID t)
				h_at		(Traeger.get Tr_ID h)
				sysl_at	(Traeger.get Tr_ID syslng)
	)
			
	(setq s_ht		(Traeger.get Htrg s))
		
	(setq dp_blech	(Blech.get Blech_ID dp)
				bp_blech	(Blech.get Blech_ID bp)
				dok_blech	(Blech.get Blech_ID dok)
	)
	
	(setq dp_kopfplatte (Blech.get blKpl dp))
	
	(setq xPos_ht			(Connect.get CastaData xPos_ht)
				xPos_at			(Connect.get CastaData xPos_at)
				afl_vwinkel	(Connect.get CastaData afl_vwinkel)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq delta_l (TrEnde.get TrgEnde delta_l)
				vwnkl		(TrEnde.get TrgEnde v_winkel)
	)
	(print vWnkl)
	
	(setq tanAN (tan (/ (* PI vwnkl) 180.0)))
	(print tanAN)
	(setq sinAFL (sin (/ (* PI afl_vwinkel) 180.0)))
	(setq tanAFL (tan (/ (* PI afl_vwinkel) 180.0)))
	
	(setq anteil_aus_neigung (/ (* 0.5 h_at) tanAN))
	
	(setq anteil_dp_blech (/ dp_kopfplatte sinAFL))
	(print anteil_dp_blech)
	(print dok_blech)
	
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq xpos (+ delta_l anteil_aus_neigung))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq xpos (- sysl_at delta_l (- anteil_aus_neigung)))
	)
	
	(setq w0 (+ (/ (- bp_blech s_ht) 2.0) s_ht))
	
	(Lochbild.set zuglLochbild 	(klemml (+ t_at dp_blech))
															(dxSKopf	dp_blech)
															(e0 e_min)
															(e1 e1_min)
															(w0 w0)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq abtl_at_winkel 0.0)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq abtl_at_winkel 180.0)
	)
	
	; Anschlusstraeger
	(Traeger.addabtl Tr_ID zuglLochbild xpos abtl_at_winkel _flanschlochbild_of_)
	
	; Haupttraeger
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(Traeger.addabtl Htrg zuglLochbild xpos_ht 0.0 _kpllochbildlinks_)
			(setq HtEnde (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(Traeger.addabtl Htrg zuglLochbild xpos_ht 0.0 _kpllochbildrechts_)
			(setq HtEnde (Traeger.get Htrg rechts))
		)
	)
	
	; delta_v ABTEIL am HT
	(setq vscherl_ht (TrEnde.get HtEnde vscherl))
	
	(setq anteil_zugl (/ dp_blech tanAFL))
	
	
	(setq delta_v_abtl (+ vscherl_ht anteil_dp_blech (- anteil_zugl)))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq delta_v_abtl (- delta_v_abtl))
	)
	
	
	(setq abteil_lb_zugl_at (Traeger.get Tr_ID Abteil zuglLochbild))
	(Anbauteil.set abteil_lb_zugl_at (Master 1))
	
	(setq abteil_lb_zugl_ht (Traeger.get Htrg Abteil zuglLochbild))
	(Anbauteil.set abteil_lb_zugl_ht (delta_v delta_v_abtl)
																	 (Master 0)
	)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(Anbauteil.set abteil_lb_zugl_ht (switch_on _unterflansch_))
	)
	(print "ENDE ZUGLASCHENLOCHBILD")
)

; -------------------------------------------------------------
; Erzeugt die Steifen im HT
; -------------------------------------------------------------
(defun createStuetzenSteifen (dp hVoute)
	(print "ERZEUGE STTZENSTEIFEN")
	(print "------------------------------------------------------------")
	(setq hProf    (Traeger.get  Tr_Id h)
	      tProf    (Traeger.get  Tr_Id t)
	      dV       (Traeger.get  Tr_Id delta_V)
	      dVStz		 (Traeger.get  Htrg  delta_v)
	      hStz     (Traeger.get  HTrg  h)
	      VWnkl    		(Connect.get CastaData trg_vwinkel)
	      afl_Winkel	(Connect.get CastaData afl_vwinkel)
	)
	
	
	; Anteil AT
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq vschl (TrEnde.get TrgEnde vscherl))
	(setq vscherl_halb (* 0.5 vschl))
	(print vscherl_halb)
	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	(setq tanAlfa (tan (/ (* VWnkl PI) 180.0)))
	(print cosAlfa)
	(print tanAlfa)
	(setq tanAfl (tan (/ (* afl_Winkel PI) 180.0)))
	(print tanAfl)
	
	; Anteil delta_v Verschiebung des AT
	(if (/= cosAlfa 0.0) (setq dV (/ dV cosAlfa)))

  (setq xPos (connect.get CastaData xPos_HT))
  
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
  	(setq xPosUnten (- xPos vscherl_halb dV hVoute))
  )
  (if (= (Connect.get CastaData anHtLinkesEnde) 1)
  	(setq xPosUnten (+ xPos vscherl_halb dV hVoute))
  )
  
	(print dp)
	;Anteil der Trgerneigung
	(setq xPos_H  (/ (* 0.5 hStz) tanAfl))
		
	;Anteil der Stirnplatte des AT
	;(setq xPos_dp (* tanAlfa dp))
	(setq xPos_dp (/ dp tanAfl))
	(print xPos_H)
	(print xPos_dp)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq xPos_dp (- xPos_dp))
	)
  
  ; Anteil aus Verschiebung HT (delta_v)
  (setq dv_HT (/ dVStz tanAfl))
  (if (= (Connect.get CastaData amHTUnterflansch) 1)
  	(setq dv_HT (- dv_HT))
  )
  
  (if (= tanAlfa 0.0)
  	(setq xPos_dp (- 5))
  )
  
  (setq xPosUnten (+ xPosUnten xPos_H xPos_dp (- dv_ht)))

	(if (= (connect.get CastaData AnschlZwHtEnden) 1) 
		(progn
			(setq VWnkl 0.0)
		)
	)

	; Auf Steifen am HT prfen
	(checkForSteifeAtPosition xPosUnten min_Blech_Abstand Htrg)
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeUnten (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeUnten)
			(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)  ;1539
			(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
			(Anbauteil.set  AbtlSteife (xpos xPosUnten))
		)
	)

	; Das kann so nicht bleiben, weil andere Steifen nicht gendert
	; werden sollen!
	(Traeger.updvollstf Htrg)
	(print "ENDE STTZENSTEIFEN")

)


;************************************************************************
(defun createTraegerSteife (lVoute)

	(print "ERZEUGE TRGERSTEIFE")
	(setq blTrgSteife (blech.create))
	(Connect.storeAnschlObjs CastaData blTrgSteife)
	
	(Blech.set blTrgSteife (dp 10))
	
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(setq TrLinks   (traeger.get tr_id links))
  	  (setq delta_L (TrEnde.get TrLinks delta_l)
  	    	  EWnkl   (TrEnde.get TrLinks V_Winkel)
  	    	  VWnkl   (- EWnkl 90.0)
  	    	  hTrg    (Traeger.get Tr_ID h)
  	  )
  	  
  	  (setq dV (* 0.5 hTrg (tan (/ (* PI VWnkl) 180.0))))
  	  (print dV)
	    (setq xPosTraeger (+ lVoute delta_L dV))
  	)
  )
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(setq TrRechts  (traeger.get tr_id rechts))
  	  (setq delta_L (TrEnde.get TrRechts delta_l)
  	  			EWnkl   (TrEnde.get TrRechts V_Winkel)
  	    	  VWnkl   (- 90.0 EWnkl )
  	    	  hTrg    (Traeger.get Tr_ID h)
  	  )
  	  (print EWnkl)
  	  (print VWnkl)
  	  (setq dV (* 0.5 hTrg (tan (/ (* PI VWnkl) 180.0))))
  	  (print dV)
  	  (setq TrgLaenge (Traeger.get Tr_ID SysLng))
			(setq xPosTraeger (- TrgLaenge lVoute delta_L dV))
  	)
  )

	(traeger.addabtl Tr_ID blTrgSteife 0.0 0.0 1539)
	(setq AbtlSteife (traeger.get Tr_ID ABTeil blTrgSteife))
	(Anbauteil.set  AbtlSteife (xpos xPosTraeger) (Winkel 0.0))

	; Auch nur Behelfslsung (siehe oben)
	(Traeger.updvollstf Tr_ID)
	(print "ENDE TRGERSTEIFE")
)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; Hilfsfunktionen fr die Zuglasche
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun calcSchrBez (TRG)
	(print "------------------------------------------------------------")
	(print "WHLE SCHRAUBE")
	(print "------------------------------------------------------------")
	(setq b_trg (Traeger.get TRG b)
				s_trg	(Traeger.get TRG s)
				r_trg	(Traeger.get TRG r)
	)
	
	(setq verfuegbarer_bereich (- (* 0.5 b_trg) (* 0.5 s_trg) r_trg))
	(print verfuegbarer_bereich)
	
	(setq maxSchDurch (* 0.25 verfuegbarer_bereich))
	(print maxSchDurch)
	
	(setq S_Bez_toSet "M36")
	
	(if (<= maxSchDurch 36.0)
		(setq S_Bez_toSet "M30")
	)
	(if (<= maxSchDurch 30.0)
		(setq S_Bez_toSet "M27")
	)
	(if (<= maxSchDurch 27.0)
		(setq S_Bez_toSet "M24")
	)
	(if (<= maxSchDurch 22.0)
		(setq S_Bez_toSet "M20")
	)
	(if (<= maxSchDurch 20.0)
		(setq S_Bez_toSet "M16")
	)
	(if (<= maxSchDurch 16.0)
		(setq S_Bez_toSet "M12")
	)
	(if (<= maxSchDurch 12.0)
		(setq S_Bez_toSet "M12")
	)
	
	
	(print S_Bez_toSet)
			
	(print "------------------------------------------------------------")
)




(defun calcKplVerl (BLECH_ID E_RAND E_LOCH)
	(print "------------------------------------------------------------")
	(print "BERECHNE ZUGLASCHENVERLNGERUNG")
	(print "------------------------------------------------------------")
	(setq afl_winkel (Connect.get CastaData afl_vwinkel))
	(print afl_winkel)
	
	(setq sinAFL (sin (/ (* PI afl_winkel) 180.0)))
	(print sinAFL)
	
	(setq dp_kpl (Blech.get BLECH_ID dp))
	(print dp_kpl)
	
	(setq anteil_kpl (/ dp_kpl sinAFL))
	(print anteil_kpl)
	
	(setq kplVerl (+ anteil_kpl E_LOCH (* 2.0 E_RAND)))
	(print kplVerl)
	
	(print "------------------------------------------------------------")
)


(defun calcAndSetVoutenDaten (Voute_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE VOUTENDATEN")
	
	
	(setq	l_at	(Traeger.get Tr_ID laenge)
		h_at	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
	)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(setq kpl_dp	(Blech.get Blech_ID dp))
	
	(print l_at)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanAW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinAW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq anteil_kpl (/ kpl_dp sinAW))
	
	(setq l_at (- l_at anteil_kpl))
	(print l_at)
	
	(if (> at_winkel 90.0)
		(progn
			(setq anteil_at_neigung (/ h_at tanAW))
			(print anteil_at_neigung)
			
			(setq l_at (+ l_at anteil_at_neigung))
			(print l_at)
		)
	)
	
	; Voutenlnge
	(if (< l_at _Vouten_Default_Laenge)
		(setq laenge_voute l_at)
		(setq laenge_voute _Vouten_Default_Laenge)
	)
	(print laenge_voute)
	
	
	; Voutenhhe
	(setq hoehe_voute (* 0.5 laenge_voute))
	
	; Flanschbreite
	(if (<= b_at b_ht)
		(setq breite_flansch b_at)
		(setq breite_flansch b_ht)
	)
	
	
	
	; Daten setzen
	(Voute.set Voute_ID 
		(laenge	 		laenge_voute) 
		(hsteg1	 		hoehe_voute) 
		(d_OK 			0) 
		(t_flansch  10) 
		(b_flansch  breite_flansch) 
		(t_steg	  	10)
	)

	; als Einstellung setzen - Alternative also
	(if (= _Voute_Aus_Profil 1) (progn
		(setq TrProfil (Traeger.get Tr_ID Profil))
		(Voute.set Voute_ID (Profil TrProfil))
	))
	
	(print ">-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke aus der Flanschdicke des AT
; ----------------------------------------------------------------------------------------
(defun setKplDicke (Blech_ID)
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq kpl_dp (runde t_at auf 5))
	(print kpl_dp)
	
	(Blech.set Blech_ID (dp kpl_dp))
)
