; $	HT	QT(I)		AF(F)		P(EZ)
; $ AT	QT(IU)		AF(K)		P(E)
; $	AE	V(-)			H(90)		R(0)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
; 
; letzte nderung: 18.04.2006
; letztePrfung:		19.04.2006
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-multiconnect-stz-flansch")
   (load "mod-lochbild")
)

(defun init-connection ()
	(setq rwinkel_at (Traeger.get Tr_ID r_winkel))

	; Defaults fr Voutenerstellung - hier initialisieren, werden - sofern Config-Datei
	; vorhanden, aus dieser dann eingelesen und gesetzt
	(setq _Voute_Aus_Profil 0)
    	(setq _Vouten_Default_Laenge 1000)
	(loadConfig "makro_defaults.lsp")		; zentrale Config-Datei mit Defaults

	(if (/= rwinkel_at 0.0)
		(alertBox "Bitte setzen Sie den Rotationswinkel des Anschlusstrgers auf 0"    "Set_RotAngle_AT_To_Zero")
  		(setConnection)
 	)
)

(defun setConnection ()
	(print "in init-connection uz_an_Stz-Flansch");
  (init-traegerenden)				

  ; Trgerende-Ablngung aufgrund des Sttzenprofils
  ; Rechtes Ende Anschlusstrger
  
  ;(setq blSteifeUnten	(blech.create))
  (setq uzVoute		(Voute.create))
	(Connect.storeAnschlObjs CastaData uzVoute)
  
	; Voutendaten berechnen
	; ----------------------------------------------
  (calcAndSetVoutenDaten uzVoute)
  
	
  ; Voute dem Trger hinzufgen
	; ----------------------------------------------
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
			(traeger.addabtl tr_id uzVoute 0.0 0.0 _vouterechts_)
  			
			(setq hVoute 	(Voute.get uzVoute hsteg1)
	      		lVoute 	(Voute.get uzVoute laenge)
	      		ugwVoute 	(Voute.get uzVoute ug_winkel)
			)
			(print ugwVoute)
  	)
  )
  
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
			(traeger.addabtl tr_id uzVoute 0.0 0.0 _voutelinks_)
	
			(setq hVoute 	(Voute.get uzVoute hsteg1)
	      		lVoute 	(Voute.get uzVoute laenge)
	      		ugwVoute 	(Voute.get uzVoute ug_winkel)
			)
			(print ugwVoute)
  	)
  )

	
	(setq KPL_CREATED 0)
	
	; Auf Steifen am HT prfen (Sind weitere Anschlsse vorhanden?)
	(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	(print "VOR KPL ERZEUGUNG")
  (print anzAnschl)
  
	; Wenn keine weiteren Anschlsse vorhanden sind ...
  (if (= anzAnschl 0)
		(progn
			(if (= (Connect.get CastaData anschlzwhtenden) 0)
				(progn
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)
						(progn
							(setq HT_Ende (Traeger.get Htrg links))
							(setq verl (TrEnde.get HT_Ende delta_l))
							(print verl) 
							(checkForSteifeAtPosition verl 100 Htrg); -> ABTL_VORH
							(if (= ABTL_VORH 0)
								(checkForKplAtPosition verl 100 Htrg); -> ABTL_VORH
							)
						)
					)
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)
						(progn
							(setq pos (Traeger.get Htrg laenge))
							(print pos)
							(checkForSteifeAtPosition pos 100 Htrg); -> ABTL_VORH
							(if (= ABTL_VORH 0)
								(checkForKplAtPosition pos 100 Htrg); -> ABTL_VORH
							)
						)
					)
			
					(if (= ABTL_VORH 0)
						(progn
						  ; Kopfplatte am Haupttrger
						  (setq blkplHTOben (blech.create))
							(Connect.storeAnschlObjs CastaData blkplHTOben)
						  ; rechtes Ende am Haupttrger
						  (if (= (connect.get CastaData anHtRechtesEnde) 1) 
						  	(progn
						  	  (print "Kopfplatte rechts am Haupttrger")
							    (calcAndSetBlechdatenKplHT blkplHTOben HTrRechts 0)
							    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplatterechts_)
							    (setq KPL_CREATED 1)
						  	)
						  )
						  ; linkes Ende am Haupttrger
						  (if (= (connect.get CastaData anHtLinkesEnde) 1) 
						  	(progn
						  	  (print "Kopfplatte links am Haupttrger")
							    (calcAndSetBlechdatenKplHT blkplHTOben HTrLinks 0)
							    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplattelinks_)
							    (setq KPL_CREATED 1)
						  	)
						  )
						)
					)
					
				)
			)
		)
	)


	; ******************************************
  ; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
  ; ******************************************
  (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
  (print anzAnschl)
  
  (if (/= anzAnschl 0)
  	(progn
  		(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden.\nberprfen Sie bitte ggf. ob es zu berschneidungen kommt."  "WRN_CheckForCollisions")
  	)
  )
  
  (setq dp 0)
	
	; Sttzensteifen erzeugen
	; ----------------------------------------------
  (createStuetzenSteifen dp hVoute)
	
  ;(createTraegerSteife lVoute)
    
  
  ;CALLBACK VOUTE
	(Voute.set uzVoute (formFkt "cb_uzVoute"))
	(if (= KPL_CREATED 1)
		(Blech.set blkplHTOben (formFkt "cb_blkplHTOben"))
	)
	
)


; ---------------------------------------------------------------------- */
; CALLBACKFUNKTIONEN
; ---------------------------------------------------------------------- */
(defun cb_uzVoute (zp)
	(print "------------------------------------------------------------")
	(print "CALLBACK")
	(print "------------------------------------------------------------")
	(print "in Callback-Funktion cb_uzVoute")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq lVouteAlt (Voute.get uzVoute laenge))
	    (setq hVouteAlt	(Voute.get uzVoute hsteg1))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq lVouteNeu (Voute.get uzVoute laenge))
	    (setq hVouteNeu	(Voute.get uzVoute hsteg1))
	    
	    (print lVouteAlt) (print lVouteNeu)
	    (print hVouteAlt) (print hVouteNeu)
	    
	    ; Lngennderung der Voute
	    (if (/= lVouteAlt lVouteNeu) (progn
		    (setq lDiff (- lVouteNeu lVouteAlt))
		    
		    ;(setq AbtlSteife_at (Traeger.get Tr_ID ABTeil blTrgSteife))
		       
		    ;(setq alteXPosSteife_at (Anbauteil.get AbtlSteife_at xPos))
	       
	      ;(if (= (Connect.get CastaData LinkesEnde) 1)
	      ; 	(setq neueXPosSteife_at (+ alteXPosSteife_at lDiff))
	      ;)
	      ;(if (= (Connect.get CastaData RechtesEnde) 1)
	      ; 	(setq neueXPosSteife_at (- alteXPosSteife_at lDiff))
	      ;)
	    
	    	;(Anbauteil.set  AbtlSteife_at (xpos neueXPosSteife_at))
	    ))
	    
	    ; Hhennderung der Voute
	    (if (/= hVouteAlt hVouteNeu) (progn
	        ; Steife muss vorhanden sein - wenn gelscht, dann nicht ausfhren
		(if (objExist blSteifeUnten) (progn
		    (setq hDiff (- hVouteNeu hVouteAlt))
		    (print hDiff)
		    (setq AbtlSteife_ht (Traeger.get Htrg ABTeil blSteifeUnten))
		    
		       
		    ; untere Steife
		    (setq alteXPosSteife_ht (Anbauteil.get AbtlSteife_ht xPos))
		    (print alteXPosSteife_ht)
		    (if (= (Connect.get CastaData vatr-lhtr)  1)
			(setq neueXPosSteife_ht (+ alteXPosSteife_ht hDiff))
		    )
		    (if (= (Connect.get CastaData vatr-lhtr) -1)
			(setq neueXPosSteife_ht (- alteXPosSteife_ht hDiff))
		    )
		    (print neueXPosSteife_ht)
		    (Anbauteil.set  AbtlSteife_ht (xpos neueXPosSteife_ht))
	    	))
	    ))
	))
)


(defun cb_blkplHTOben (zp)
	(print "------------------------------------------------------------")
	(print "CALLBACK")
	(print "------------------------------------------------------------")
	(print "in Callback-Funktion cb_blkplHTOben")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_kpl_alt (Blech.get blkplHTOben dp))
	    
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_kpl_neu (Blech.get blkplHTOben dp))
	    
	    ; Lngennderung der Voute
	    (if (/= dp_kpl_alt dp_kpl_neu) (progn
		    (setq dpDiff (- dp_kpl_neu dp_kpl_alt))
		    
		    
		    
	    ))
	    
	    
	))
)


; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */

; ********************************************************************************
; Erzeugt u. berechnet die Blechdaten fr die Kopfplatte
; ********************************************************************************
(defun calcAndSetBlechdatenKplHT (blKopfplatte TrgEnde kplVerl)

   (print "---------------- calcAndSetBlechdatenKplHT -------------------------------")

   (setq hProf (Traeger.get HTrg h))		; Hhe des Haupttrgerprofils

   (setq hp  hProf)				; erstmal so voreinstellen
   (setq bp  (Traeger.get Htrg b))		; Breite
   (setq dp  20)
   
   
   (setq schwKante 0)				
   
   (if (= (connect.get CastaData amHtUnterFlansch) 1) 
   (progn
   	(setq dOK schwKante)
   ))
   (if (= (connect.get CastaData amHtOberFlansch) 1)
   (progn
   	(setq vers (+ kplverl schwKante)) 
   	(setq dOK (- vers))
   ))
   
   
   (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
   (print EWinkel)
        							
   								
   (setq hp (+ hp  kplverl))	
   (setq sinW (sin (* PI (/ EWinkel 180.0))))
	
   (if (/= sinW 0) (setq hp (/ hp sinW)))
        
   
   (Blech.set blKopfplatte (dp dp) (hp hp) (bp bp) (dOK dOK))

   (setq htDeltaV (Traeger.get hTrg delta_V))


    (setq delta_L dp)
    (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
    	
    (print dp)							(print delta_L)
    
		(TrEnde.ptrim TrgEnde dp)
    (print "---------------- ENDE -------------------------------")
)





; -------------------------------------------------------------
; Erzeugt die Steifen im HT
; -------------------------------------------------------------
(defun createStuetzenSteifen (dp_blech hVoute)
	(print "ERZEUGE STTZENSTEIFEN")
	(print "------------------------------------------------------------")
	
	(setq hProf    		(Traeger.get Tr_Id h)
	      tProf    		(Traeger.get Tr_Id t)
	      dV       		(Traeger.get Tr_Id delta_V)
	      dVStz		 		(Traeger.get Htrg  delta_v) 	
	      hStz     		(Traeger.get HTrg  h)
	      VWnkl    		(Connect.get CastaData trg_vwinkel)
	      afl_winkel	(Connect.get CastaData afl_vwinkel)
	      xPos_ht			(Connect.get CastaData xPos_ht)
	)
	
	(setq blSteifeOben (blech.create))
	(setq blSteifeUnten (blech.create))
	
	
	; setzen der Steifendicken
	(setq tProf_rund (runde tProf auf 5))
	(Blech.set blSteifeOben (dp tProf_rund))
	(Blech.set blSteifeUnten (dp tProf_rund))
	
	(setq sinAW (sin (/ (* PI afl_winkel) 180.0)))		(print sinAW)
	(setq cosAW (cos (/ (* PI afl_winkel) 180.0)))
	(setq tanAW (tan (/ (* PI afl_winkel) 180.0)))
	(if (< tanAW 0.0)
		(setq tanAW (- tanAW))
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq vschl (TrEnde.get TrgEnde vscherl))
	(setq vscherl_halb (* 0.5 vschl))
	
	
	; Anteil AT-Neigung (nur fr untere Steife)
	(setq hStz_halb (* 0.5 hStz))
	(setq helpVar (/ hStz_halb tanAW))
	(print helpVar)
	(setq xPos_neig 0)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (< afl_winkel 90.0)
				(setq xPos_neig (- vscherl_halb helpVar))
				(setq xPos_neig (+ vscherl_halb helpVar))
			)
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (< afl_winkel 90.0)
				(setq xPos_neig (+ vscherl_halb helpVar))
				(setq xPos_neig (- vscherl_halb helpVar))
			)
		)
	)
	(print xPos_neig)
	
	; Obere Steife um halbe Dicke nach unten schieben
	(setq dp_steife_oben (Blech.get blSteifeOben dp))
	(print dp_steife_oben)
	(setq xPos_dp (/ (* 0.5 dp_steife_oben) sinAW))
	
	; xPos setzen
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq xPosOben (+ xPos_ht vscherl_halb (- xPos_dp)))
			(setq xPosUnten (- xPos_ht xPos_neig hVoute))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(setq xPosOben (- xPos_ht vscherl_halb (- xPos_dp)))
			(setq xPosUnten (+ xPos_ht xPos_neig hVoute))
		)
	)

	; Winkel der oberen Steife ermitteln
	(setq stf_winkel (- 90.0 afl_winkel))
	(print stf_winkel)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq stf_winkel (- stf_winkel))
	)
	(print stf_winkel)
	
	; BIS HIER NUR BERECHNUNGEN, WENN TRGER AUF SYSTEMLINIE
	;
	; --> AB HIER VERSCHIEBUNGEN EINBAUEN
	
	; Anteil Verschiebung delta_v des AT
	(setq xPos_dv_at (/ dv sinAW))
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq xPosOben (- xPosOben xPos_dv_at))
			(setq xPosUnten (- xPosUnten xPos_dv_at))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(setq xPosOben (+ xPosOben xPos_dv_at))
			(setq xPosUnten (+ xPosUnten xPos_dv_at))
		)
	)
	
	; Anteil Verschiebung delta_v des HT
	(setq dv_HT (/ dVStz tanAW))
	(print dv_HT)
  (if (= (Connect.get CastaData amHTUnterflansch) 1)
  	(setq dv_HT (- dv_HT))
  )
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (< afl_winkel 90.0)
				(progn
					(setq xPosOben (- xPosOben dv_HT))
					(setq xPosUnten (- xPosUnten dv_HT))
				)
				(progn
					(setq xPosOben (+ xPosOben dv_HT))
					(setq xPosUnten (+ xPosUnten dv_HT))
				)
			)
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(if (< afl_winkel 90.0)
				(progn
					(setq xPosOben (- xPosOben dv_HT))
					(setq xPosUnten (- xPosUnten dv_HT))
				)
				(progn
					(setq xPosOben (+ xPosOben dv_HT))
					(setq xPosUnten (+ xPosUnten dv_HT))
				)
			)
		)
	)
	
	
	(print "BERECHNE UNTERSCHIED")
	(checkDifferenz)
	
	; ANBAU
	; Auf Steifen am HT prfen
	
	(if (= KPL_CREATED 0)
		(progn
			(checkForSteifeAtPosition xPosOben 100 Htrg)
			(if (= ABTL_VORH 0)
				(checkForKplAtPosition xPosOben 100 Htrg)
			)
			(if (= ABTL_VORH 0)
				(progn				
					(Connect.storeAnschlObjs CastaData blSteifeOben)
					(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_)  ;1539
					(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeOben))
					(Anbauteil.set  AbtlSteife (xpos xPosOben) (winkel stf_winkel))
				)
			)
		)
	)	
	
	(checkForSteifeAtPosition xPosUnten 100 Htrg)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosUnten 100 Htrg)
	)
	(if (= ABTL_VORH 0)
		(progn			
			(Connect.storeAnschlObjs CastaData blSteifeUnten)
			(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)  ;1539
			(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
			(Anbauteil.set  AbtlSteife (xpos xPosUnten))
		)
	)
	

	; Das kann so nicht bleiben, weil andere Steifen nicht gendert
	; werden sollen!
	(Traeger.updvollstf Htrg)
	(print "ENDE STTZENSTEIFEN")
)


;************************************************************************
(defun createTraegerSteife (lVoute)

	(print "ERZEUGE TRGERSTEIFE")
	(setq blTrgSteife (blech.create))
	(Connect.storeAnschlObjs CastaData blTrgSteife)
	
	(Blech.set blTrgSteife (dp 10))
	
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(setq TrLinks   (traeger.get tr_id links))
  	  (setq delta_L (TrEnde.get TrLinks delta_l)
  	    	  EWnkl   (TrEnde.get TrLinks V_Winkel)
  	    	  VWnkl   (- EWnkl 90.0)
  	    	  h_Trg    (Traeger.get Tr_ID h)
  	  )
  	  
  	  (setq dV (* 0.5 h_Trg (tan (/ (* PI VWnkl) 180.0))))
  	  (print dV)
	    (setq xPosTraeger (+ lVoute delta_L dV))
  	)
  )
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(setq TrRechts  (traeger.get tr_id rechts))
  	  (setq delta_L (TrEnde.get TrRechts delta_l)
  	  			EWnkl   (TrEnde.get TrRechts V_Winkel)
  	    	  VWnkl   (- 90.0 EWnkl )
  	    	  h_Trg    (Traeger.get Tr_ID h)
  	  )
  	  (print EWnkl)
  	  (print VWnkl)
  	  (setq dV (* 0.5 h_Trg (tan (/ (* PI VWnkl) 180.0))))
  	  (print dV)
  	  (setq TrgLaenge (Traeger.get Tr_ID SysLng))
			(setq xPosTraeger (- TrgLaenge lVoute delta_L dV))
  	)
  )

	(traeger.addabtl Tr_ID blTrgSteife 0.0 0.0 1539)
	(setq AbtlSteife (traeger.get Tr_ID ABTeil blTrgSteife))
	(Anbauteil.set  AbtlSteife (xpos xPosTraeger) (Winkel 0.0))

	; Auch nur Behelfslsung (siehe oben)
	(Traeger.updvollstf Tr_ID)
	(print "ENDE TRGERSTEIFE")
)


; ----------------------------------------------------------------------------------------
; berprft, ob sich das Ende der Sttze oberhalb des AT-Oberflansches befindet
; ----------------------------------------------------------------------------------------
(defun checkDifferenz ()
	
	(setq xPos_ht (Connect.get CastaData xPos_ht))
		
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AT_Ende (Traeger.get Tr_ID rechts))
	)
	(setq vscherl_at_ende (TrEnde.get AT_Ende vscherl)
				delta_l_ht			(TrEnde.get AT_Ende delta_l)
	)
	(setq vscherl_at_ende_halb (* 0.5 vscherl_at_ende))
	
	(print xPos_ht)
	(print delta_l_ht)
	(print delta_v_at)
	(print vscherl_at_ende_halb)
	
	
	(setq IST_OBERHALB 0)
	
)


(defun calcAndSetVoutenDaten (Voute_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE VOUTENDATEN")
	
	(setq	l_at	(Traeger.get Tr_ID laenge)
		h_at	(Traeger.get Tr_ID h)
		b_at	(Traeger.get Tr_ID b)
	)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(print l_at)
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	(setq tanAW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinAW (sin (/ (* PI at_winkel) 180.0)))
	
	
	
	;(setq anteil_at_neigung (/ (* 0.5 h_at) tanAW))
	;(print anteil_at_neigung)
	
	;(setq l_at (- l_at anteil_at_neigung))
	;(print l_at)
	
	; Voutenlnge
	(if (< l_at _Vouten_Default_Laenge)
		(setq laenge_voute l_at)
		(setq laenge_voute _Vouten_Default_Laenge)
	)
	(print laenge_voute)
	
	
	; Voutenhhe
	(setq hoehe_voute (* 0.5 laenge_voute))
	(if (> hoehe_voute 500.0) (setq hoehe_voute 500.0))
	
	; Flanschbreite
	(if (<= b_at b_ht)
		(setq breite_flansch b_at)
		(setq breite_flansch b_ht)
	)
	
	
	
	; Daten setzen
	(Voute.set Voute_ID
		(laenge	 		laenge_voute) 
		(hsteg1	 		hoehe_voute) 
		(d_OK 			0) 
		(t_flansch  10) 
		(b_flansch  breite_flansch) 
		(t_steg	  	10)
	)

	; als Einstellung setzen - Alternative also
	(if (= _Voute_Aus_Profil 1) (progn
		(setq TrProfil (Traeger.get Tr_ID Profil))
		(Voute.set Voute_ID (Profil TrProfil))
	))
	
	(print ">-----------------------------------------------------------")
)