; $	HT	QT(IU)		AF(F)		P(EZ)
; $ AT	QT(IU)		AF(K)		P(E)
; $	AE	V(-)			H(90)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; letzte nderung:	13.04.2006
; letzte Prfung:		13.04.2006
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-add-schweiss-querschn")
)

(defun init-connection ()

	;(connect.showattributes CastaData)

	(print "in init-connection uz_an_Stz-Flansch");
  (init-traegerenden)				

 	
	; ******************************************
	; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
	; ******************************************
	(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	(print anzAnschl)
	  
	(if (/= anzAnschl 0) 	(progn
			(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden. Fgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."    "ERR_OrderOfConnections")
	 	)
	 	(progn
			(createStuetzenSteifen 10)
			(SchweissProfil_Einsetzen_Fl)
	  )
	)
)
; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */
; ----------------------------------------------------------------------
; Erzeugt die Sttzensteifen
; ----------------------------------------------------------------------
(defun createStuetzenSteifen (dp)
	(print "")
	(print "BEGIN createStuetzenSteifen")
	(print "---------------------------")
	; allgemeine Daten holen
	(setq h_trg    			(Traeger.get  Tr_Id h)
	      t_trg    			(Traeger.get  Tr_Id t)
	      b_trg					(Traeger.get  Tr_ID b)
	      delta_v_trg   (Traeger.get  Tr_Id delta_V)
	)
	(setq h_htrg     		(Traeger.get  HTrg  h)
				s_htrg				(Traeger.get  Htrg  s)
				t_htrg				(Traeger.get	Htrg	t)
	      delta_v_htrg	(Traeger.get 	Htrg delta_v)
	)
	(setq VWnkl    			(connect.get CastaData trg_vwinkel)
	      vwinkel_ht		(connect.get CastaData hpttrg_vwinkel)
	)
	
	; Orientierung des HT festlegen
  (setq oben_unten 0)
  (if (>= vwinkel_ht 255.0)
  	(progn
  		(if (<= vwinkel_ht 285.0)
  			(setq oben_unten 1)
  		)
  	)
  )
	
	
	(setq dp_steife 10)
	
	;(if (> VWnkl 180.0) (setq VWnkl (- 360.0 VWnkl)))
	(print VWnkl)
	
	
	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	(setq tanAlfa	(tan (/ (* VWnkl PI) 180.0)))
	
	(print cosAlfa)
	(print tanAlfa)
	
	;Hlfte des AT
	(setq h_trg_halb (/ (* 0.5 (- h_trg t_trg)) cosAlfa))
	(setq xOben (/ (* 0.5 (- h_trg dp_steife)) cosAlfa))
	
  (setq xPos (connect.get CastaData xPos_HT))
  
  (setq xPosOben	(+ xPos xOben)
  			xPosUnten	(- xPos h_trg_halb)
  )
  
    
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq VWnkl (- VWnkl))	
	)

	(if (>= vwinkel_ht 255.0)
		(progn
			(if (<= vwinkel_ht 285.0)
				(setq VWnkl (- VWnkl))	
			)
		)
	)
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq VWnkl (- VWnkl))
	)
	
	; Anteil aus Verschiebung des AT (delta_v)
	; ----------------------------------------
	(setq dhAT_aus_deltaV (/ delta_v_trg cosAlfa))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
				)
			)
		)
	)
	
	(setq xPosOben (- xPosOben dhAT_aus_deltaV))
	(setq xPosUnten (- xPosUnten dhAT_aus_deltaV))
	
	; Anteil aus Verschiebung des HT (delta_v)
	; ----------------------------------------
	(setq dhHT_aus_deltaV (* delta_v_htrg tanAlfa))
	(if (= oben_unten 0)
		(progn
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq dhHT_aus_deltaV (- dhHT_aus_deltaV))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV))
					)
				)	
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq dhHT_aus_deltaV (- dhHT_aus_deltaV))
					)
				)	
			)
		)
	)
	(if (= oben_unten 1)
		(progn
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq dhHT_aus_deltaV (- dhHT_aus_deltaV))
					)
				)	
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq dhHT_aus_deltaV (- dhHT_aus_deltaV))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV))
					)
				)	
			)
		)
	)
	
	(setq xPosOben (- xPosOben dhHT_aus_deltaV))
	(setq xPosUnten (- xPosUnten dhHT_aus_deltaV))
	
	; Erstellen der Steifen
	; ---------------------
	(setq blSteifeOben (blech.create))
	(Connect.storeAnschlObjs CastaData blSteifeOben)
	(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_)	;1539
	(setq AbtlSteifeOben (traeger.get Htrg ABTeil blSteifeOben))
	(Anbauteil.set  AbtlSteifeOben (xpos xPosOben) (Winkel VWnkl))
	
	(setq blSteifeUnten (blech.create))
	(Connect.storeAnschlObjs CastaData blSteifeUnten)
	(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)   ;1539
	(setq AbtlSteifeUnten (traeger.get Htrg ABTeil blSteifeUnten))
	(Anbauteil.set  AbtlSteifeUnten (xpos xPosUnten) (Winkel VWnkl))
	
	
	(if (= (Connect.get CastaData amHTUnterflansch) 1)
		(progn
			(Anbauteil.steifenart AbtlSteifeOben _teilsteife_uf_)
			(Anbauteil.steifenart AbtlSteifeUnten _teilsteife_uf_)
		)
	)
	(if (= (Connect.get CastaData amHTOberflansch) 1)
		(progn
			(Anbauteil.steifenart AbtlSteifeOben _teilsteife_of_)
			(Anbauteil.steifenart AbtlSteifeUnten _teilsteife_of_)
		)
	)
	
	(setq bp_steife (* (- b_trg s_htrg) 0.5))
	(setq hp_steife (- (* 0.5 h_htrg) t_htrg))
	
	(Blech.set blSteifeOben (dp dp_steife)
													(bp bp_steife)
													(hp hp_steife)
	)
	
	(Blech.set blSteifeUnten 	(dp dp_steife)
														(bp bp_steife)
														(hp hp_steife)
	)
	
	(Traeger.updvollstf Htrg)
	(print "---------------------------")
	(print "END createStuetzenSteifen")
	(print "")
)