; $	HT	QT(IU)		AF(F)		P(EZ)
; $ AT	QT(IU)	AF(K)		P(E)
; $	AE	V(-)			H(90)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
; letzte nderung:	13.04.2006
; letzte Prfung:		13.04.2006
;
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
  (load "mod-add-schweiss-querschn")
)

(defun init-connection ()

	;(connect.showattributes CastaData)

	(print "in init-connection uz_an_Stz-Flansch");
  (init-traegerenden)				

 	; ******************************************
	; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
	; ******************************************
	(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	(print anzAnschl)
	  
	(if (/= anzAnschl 0)
	 	(progn
	  	(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden. Fgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."   "ERR_OrderOfConnections")
	 	)
	 	(progn
	  	(createStuetzenSteifen 10)
		(SchweissProfil_Einsetzen_Fl)
	  )
	)

)
; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */
; ----------------------------------------------------------------------
; Erzeugt die Sttzensteifen
; ----------------------------------------------------------------------
(defun createStuetzenSteifen (dp)
	(print "")
	(print "BEGIN createStuetzenSteifen")
	(print "---------------------------")
	; allgemeine Daten holen
	(setq h_trg    			(Traeger.get  Tr_Id h)
	      t_trg    			(Traeger.get  Tr_Id t)
	      delta_v_trg   (Traeger.get  Tr_Id delta_V)
	      h_htrg     		(Traeger.get  HTrg  h)
	      delta_v_htrg	(Traeger.get 	Htrg delta_v)
				VWnkl    			(Connect.get 	CastaData at_laengswinkel)
	)
	
	(setq dp_steife 10)
	
	(setq sinAlfa (sin (/ (* PI VWnkl) 180.0)))
	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	(setq tanAlfa	(tan (/ (* VWnkl PI) 180.0)))
	
	(print sinAlfa)
	(print cosAlfa)
	(print tanAlfa)
	
	;Hlfte des AT
	(setq h_trg_halb (/ (* 0.5 (- h_trg t_trg)) sinAlfa))
	(setq xOben (/ (* 0.5 (- h_trg dp_steife)) sinAlfa))
	
  (setq xPos (connect.get CastaData xPos_HT))
  
  (setq xPosOben	(+ xPos xOben)
  			xPosUnten	(- xPos h_trg_halb)
  )
  
    
	; Winkel der Steifen
	; ----------------------------------------------
	(print VWnkl)
	
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq VWnkl (- VWnkl 90.0)))
			(if (= (Connect.get CastaData amHtUnterFlansch) 1)	(setq VWnkl (- 90.0 VWnkl)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq VWnkl (- VWnkl 90.0)))
			(if (= (Connect.get CastaData amHtUnterFlansch) 1)	(setq VWnkl (- 90.0 VWnkl)))
		)
	)
	(print VWnkl)
	
	; Anteil aus Verschiebung des AT (delta_v)
	; ----------------------------------------------
	(setq dhAT_aus_deltaV (/ delta_v_trg sinAlfa))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
				)
			)
		)
	)
	
	(setq xPosOben (- xPosOben dhAT_aus_deltaV))
	(setq xPosUnten (- xPosUnten dhAT_aus_deltaV))
	
	; Anteil aus Verschiebung des HT (delta_v)
	; ----------------------------------------
	(print delta_v_htrg)
	(setq dhHT_aus_deltaV (* delta_v_htrg cosAlfa))
	(print dhHT_aus_deltaV)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV)))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq dhHT_aus_deltaV (- dhHT_aus_deltaV)))
	
	(setq xPosOben (- xPosOben dhHT_aus_deltaV))
	(setq xPosUnten (- xPosUnten dhHT_aus_deltaV))
	
	; Erstellen der Steifen
	; ---------------------
	(setq blSteifeOben (blech.create))
	(Connect.storeAnschlObjs CastaData blSteifeOben)
	(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_)	;1539
	(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeOben))
	(Anbauteil.set  AbtlSteife (xpos xPosOben) (Winkel VWnkl))
	
	(setq blSteifeUnten (blech.create))
	(Connect.storeAnschlObjs CastaData blSteifeUnten)
	(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)   ;1539
	(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
	(Anbauteil.set  AbtlSteife (xpos xPosUnten) (Winkel VWnkl))
	
	(Blech.set blSteifeOben (dp dp_steife))
	
	(Blech.set blSteifeUnten (dp dp_steife))
	
	(Traeger.updvollstf Htrg)
	(print "---------------------------")
	(print "END createStuetzenSteifen")
	(print "")
)