; $	HT	QT(IU)	AF(F)	P(EZ)
; $ 	AT	QT(IU)	AF(K)	P(E)
; $	AE	V(-)		H(90)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-stzflansch")
   (load "mod-help-uz_an_stzFlansch")
   (load "mod-multiconnect-stz-flansch")
   (load "mod-messages")
   (load "mod_lchb_verschiebungen")
)

(defun init-connection ()

	(setq LB_DEBUG 0)
	(setq LB_DEBUG_ZL 0)
	
	(print "in init-connection uz_an_Stz-Flansch");
	(if (= (Connect.get CastaData amATUnterflansch) 1) (progn
		(init-traegerenden)				
					
		(Connect.showAttributes CastaData)
	
		(if (> (Connect.get CastaData anz_weitere_anschl) 0)
			(message "Anschl_vorh")
		)
					
		(setConnection)
	   )
	   (progn
			(AlertBox "Die Zuglasche kann nur am Oberflansch des Anschlusstrgers montiert werden" "TensionLug_TopFlange_Only")
	))

  

)


; ----------------------------------------------------------------------------------------
; Erzeugt den Anschluss
; ----------------------------------------------------------------------------------------
(defun setConnection ()
	
	(setq blKpl (blech.create))
  (setq lchbKpl (lochbild.create))
	(Connect.storeAnschlObjs CastaData blKpl lchbKpl)
	
  (if (= (connect.get CastaData RechtesEnde) 1) 
  	(progn
  		(print "Anschluss rechts am Anschlusstrger")
  		
  		; Kopfplatte
			(calcAndSetBlechdaten blKpl TrRechts)
			(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplatterechts_)

			; Lochbild
			(calcFlanschLochbildDaten lchbKpl blKpl)
			(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildrechts_)

			(createFlanschLochb lchbKpl blKpl)

			(setq dp (Blech.get blKpl dp))
  	)
  )
  (if (= (connect.get CastaData LinkesEnde) 1) 
  	(progn
  		(print "Anschluss links am Anschlusstrger")
  		
			; Kopfplatte
			(calcAndSetBlechdaten blKpl TrLinks)
			(traeger.addabtl tr_id blKpl 0.0 0.0 _kopfplattelinks_)

			; Lochbild
			(calcFlanschLochbildDaten lchbKpl blKpl)
			(traeger.addabtl tr_id lchbKpl 0.0 0.0 _kpllochbildlinks_)
			
			(createFlanschLochb lchbKpl blKpl)
	

			(setq dp (Blech.get blKpl dp))
  	)
  )
  
  (korrigiereKpl blKpl lchbKpl)
  (calcHVerschLochbild lchbKpl)
;  (LchbAmFlanschDrehen lchbKpl)		; das ist nur eine Korrektur, falls nicht auf dem Kopf liegende AT abgefangen werden
  					; xPos muss zuvor eingestellt worden sein.


  
	; Auf Steifen am HT prfen
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq HT_Ende (Traeger.get Htrg links))
			(setq verl (TrEnde.get HT_Ende delta_l))
			(print verl) 
			(checkForSteifeAtPosition verl 100 Htrg); -> ABTL_VORH
			(if (= ABTL_VORH 0)
				(checkForKplAtPosition verl 100 Htrg); -> ABTL_VORH
			)
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq pos (Traeger.get Htrg laenge))
			(print pos)
			(checkForSteifeAtPosition pos 100 Htrg); -> ABTL_VORH
			(if (= ABTL_VORH 0)
				(checkForKplAtPosition pos 100 Htrg); -> ABTL_VORH
			)
		)
	)
  
  (if (= ABTL_VORH 0)
  	(progn
		  ;ZUGLASCHE
		  ; Kopfplatte am Haupttrger
		  (setq blkplHTOben (blech.create))
		  (setq zuglLochbild (Lochbild.create))
			(Connect.storeAnschlObjs CastaData blkplHTOben zuglLochbild)
			
			(calcSchrBez Tr_ID) ; -> S_Bez_toSet (z.B. S_Bez_toSet = "M16")
			
			(Lochbild.set zuglLochbild (S_Bez S_Bez_toSet))
			
			(calcMinRandLochAbst zuglLochbild) ; -> minE_rand, minE_loch
			
			(calcKplVerl blKpl minE_rand minE_loch) ; -> kplVerl
			
		  ; rechtes Ende am Haupttrger
		  (if (= (connect.get CastaData anHtRechtesEnde) 1) 
		  	(progn
		  	  (print "Kopfplatte rechts am Haupttrger")
			    (calcAndSetZuglasche blkplHTOben HTrRechts kplVerl)
			    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplatterechts_)
			    			    
			    (createZuglaschenLochbild blkplHTOben zuglLochbild kplVerl)
		  	)
		  )
		  ; linkes Ende am Haupttrger
		  (if (= (connect.get CastaData anHtLinkesEnde) 1) 
		  	(progn
		  	  (print "Kopfplatte links am Haupttrger")
			    (calcAndSetZuglasche blkplHTOben HTrLinks kplVerl)
			    (traeger.addabtl Htrg blkplHTOben 0.0 0.0 _kopfplattelinks_)
			    
			    (createZuglaschenLochbild blkplHTOben zuglLochbild kplVerl)
		  	)
		  )
		  
		  		  
		  (createStuetzenSteifen dp)
		)
	)
  
  
  ; CALLBACKS
  (Blech.set blKpl (formFkt "cb_KplBlech"))
  (if (= ABTL_VORH 0)
  	(Blech.set blkplHTOben (formFkt "cb_ZugLasche"))	
  )
  
  
    (print "*clear*")
    (Connect.showattributes CastaData)
    (LchbShowAbschlussKontrolle lchbKpl)

		  (if (= 1 2) (progn
		      (setq Abtl_KplLchb_ht (Traeger.get HTrg  ABTeil zuglLochbild))
		      (setq Abtl_KplLchb_at (Traeger.get Tr_ID ABTeil zuglLochbild))
		      (Lochbild.set zuglLochbild (e "0 50 150 0 0 0"))
		      (Lochbild.set zuglLochbild (w "10 100"))
		      (Lochbild.set zuglLochbild (LB_Art 2))
		      (Anbauteil.set Abtl_KplLchb_ht 		(Master 0))
		      (Anbauteil.set Abtl_KplLchb_at 		(Master 1))
		  ))


)

; ---------------------------------------------------------------------- */
; CALLBACKFUNKTIONEN
; ---------------------------------------------------------------------- */
(defun cb_KplBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lchbKpl Klemml))
	       (setq altesDxS		(Lochbild.get lchbKpl dxsKopf))
	       
	       (Lochbild.set lchbKpl 	(Klemml (+ alteKlemml dpDiff))
	       												(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
)

(defun cb_ZugLasche (zp)
	(print "in Callback-Funktion cb_ZugLasche")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt 	(Blech.get blkplHTOben dp))
	    (setq hpAlt 	(Blech.get blkplHTOben hp))	   
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu 	(Blech.get blkplHTOben dp))
	    (setq hpNeu 	(Blech.get blkplHTOben hp))
	    
	    (print dpAlt) (print dpNeu)
	    (print hpAlt) (print hpNeu)
	    
	    ; dp der Zuglasche wurde gendert
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       
	       (setq alteKlemml (Lochbild.get zuglLochbild Klemml))
	       (setq altesDxS		(Lochbild.get zuglLochbild dxsKopf))
	       
	       (setq klemml_neu 	(+ alteKlemml dpDiff))
	       (setq dxskopf_neu	(+ altesDxS dpDiff))
	       
	       (print alteKlemml)
	       (print klemml_neu)
	       (print altesDxS)
	       (print dxskopf_neu)
	       
	       (Lochbild.set zuglLochbild 	(Klemml klemml_neu)
	       															(DxSKopf dxskopf_neu)
	       )
	       
	      (if (= (Connect.get CastaData anHtLinkesEnde) 1)
	      	(setq HT_Ende (Traeger.get Htrg links))
	      )
	      (if (= (Connect.get CastaData anHtRechtesEnde) 1)
	      	(setq HT_Ende (Traeger.get Htrg rechts))
	      )
	      
	      (setq delta_l_alt	(TrEnde.get HT_Ende delta_l))
	      (setq delta_l_neu (- delta_l_alt dpDiff))
	      
	      (TrEnde.set HT_Ende (delta_l delta_l_neu))
	      
	    ))
	    
	    ; hp der Zuglasche wurde gendert
	    (if (= 1 2) (progn
		    (if (/= hpAlt hpNeu) (progn
		       (setq hpDiff (- hpNeu hpAlt))
		       
		       (setq dok_Blech_Alt	(Blech.get blkplHTOben dok))
		       
		       (setq dok_Blech_neu	(- dok_Blech_Alt hpDiff))
		       
		       (Blech.set blkplHTOben (dok dok_Blech_neu))	       
		    ))
	    ))
	))
	
)


; ---------------------------------------------------------------------- */
; Hilfsfunktionen
; ---------------------------------------------------------------------- */

; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD
; ----------------------------------------------------------------------------------------
(defun createFlanschLochb (flLochbild BLECH_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")

 
  (setq xPos 					(Connect.get CastaData xPos_HT)
  			afl_vwinkel 	(Connect.get CastaData afl_vwinkel)
  			htrg_vwinkel	(Connect.get CastaData hpttrg_vwinkel)
  )
  	
  (setq hProf					(Traeger.get Htrg h)
        delta_v_ht		(Traeger.get Htrg delta_v)      
  )
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq dp_blech		(Blech.get BLECH_ID dp)
				dok_blech		(Blech.get BLECH_ID dok)
	)
	
	(setq tanAW (tan (/ (* PI afl_vwinkel) 180.0)))
	(setq sinAW (sin (/ (* PI afl_vwinkel) 180.0)))
	(print tanAW)
	(print sinAW)
	
	(if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	  (setq Flansch _flanschlochbild_of_)
  ))
  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	  ;; **AFKorrektur** 
	  (setq Flansch _flanschlochbild_uf_)
  ))
  
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
  
  ; Orientierung des HT festlegen
  (setq oben_unten 0)
  (if (>= htrg_vwinkel 255.0)
  	(progn
  		(if (<= htrg_vwinkel 285.0)
  			(setq oben_unten 1)
  		)
  	)
  )
  
  ; Winkel des Lochbildes festlegen
	; (abhngig von HT-Orientierung) 
	(setq wAbtl 180.0)
	(if (= oben_unten 1)
		(setq wAbtl 0.0)
	)
	
	; Positionierung und Ausrichtung zum AT
	; Verschiebung auf die Hhe der AT-Oberkante
	(setq scherl_at (TrEnde.get TrgEnde vscherl))
	(setq delta_xPos (* 0.5 scherl_at))
	(if (= oben_unten 1)
		(setq xPos (- xPos delta_xPos))
		(setq xPos (+ xPos delta_xPos))
	)
  (print xPos)
  
  
  ; die restlichen Korrekturen aus Trgerverschiebungen zusammenfassen
  (setq xPos_korr_ges 0)
  
  
  ; Bercksichtigung der AT-Neigung ( -> Verschiebung der xPos)
  ; Anschluss an den Ht-Enden
  (if (= (connect.get CastaData anschlzwhtenden) 0)
  	(progn 
		  (if (= (connect.get CastaData anhtlinkesende) 1) 
		  	(progn
					(setq EWnkl   (Connect.get CastaData afl_vwinkel))
		      ;(setq dvWnkl  (/ (+ (* 0.5 hProf) dp_blech) (tan (* PI (/ EWnkl 180.0)))))
					(setq dvWnkl  (/ (* 0.5 hProf) (tan (* PI (/ EWnkl 180.0)))))
					
					(if (= (connect.get CastaData amHtOberFlansch) 1) 
						(progn
			    		(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
						)
					)
					(if (= (connect.get CastaData amHtUnterFlansch) 1) 
						(progn
			    		(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
						)
					)
		  	)
		  )
		  (if (= (connect.get CastaData anhtrechtesende) 1) 
		  	(progn
					(setq EWnkl   (Connect.get CastaData afl_vwinkel))
					;(setq dvWnkl  (/ (+ (* 0.5 hProf) dp_blech) (tan (* PI (/ EWnkl 180.0)))))
					(setq dvWnkl  (/ (* 0.5 hProf) (tan (* PI (/ EWnkl 180.0)))))
					
					(if (= (connect.get CastaData amHtOberFlansch) 1) 
						(progn
			    		(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
						)
					)
					(if (= (connect.get CastaData amHtUnterFlansch) 1) 
						(progn
			    		(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
						)
					)
		  	)
		  )
		)
	)
	
	; Anschluss zwischen den Ht-Enden
	(if (= (connect.get CastaData anschlzwhtenden) 1)
  	(progn 
  		(setq EWnkl   (Connect.get CastaData afl_vwinkel))
		  ;(setq dvWnkl  (/ (+ (* 0.5 hProf) dp_blech) (tan (* PI (/ EWnkl 180.0)))))
			(setq dvWnkl  (/ (* 0.5 hProf) (tan (* PI (/ EWnkl 180.0)))))
			
			(if (= (connect.get CastaData amHtOberFlansch) 1) 
				(progn
					(setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
			  )
			)
			(if (= (connect.get CastaData amHtUnterFlansch) 1) 
				(progn
			    (setq xPos_korr_ges    (+ xPos_korr_ges dvWnkl))
			  )
			)
			(print xPos_korr_ges)
		)
	)

	(print dvWnkl)
	
	
	
	
	; Verschiebung delta_v AT
	(setq xPos_delta_v_at_korr (/ delta_v_at sinAW))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_korr_ges (- xPos_korr_ges xPos_delta_v_at_korr)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_korr_ges (+ xPos_korr_ges xPos_delta_v_at_korr)))
				)
			)
		)
	)


  ; Verschiebung delta_v HT
  (setq xPos_korr (/ delta_v_ht tanAW))
	(print xPos_korr)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq xPos_korr_ges (- xPos_korr_ges xPos_korr))
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq xPos_korr_ges (+ xPos_korr_ges xPos_korr))
	) 
	
	
	(setq xPos (+ xPos xPos_korr_ges))
	(print xPos)
	(print wAbtl)
	
	(print delta_lr_at)
	(setq delta_lr_abt_ht 0.0)
	
	; Verschiebung delta_lr AT
    (if (= 1 1)	(progn
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
	    )
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht delta_lr_at))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (- delta_lr_at)))
	    )
	)
    ))

    (if (= (Connect.get CastaData anHtRechtesEnde) 1) (setq delta_lr_abt_ht (- delta_lr_abt_ht delta_lr_ht)))
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) (setq delta_lr_abt_ht (+ delta_lr_abt_ht delta_lr_ht)))

	
	; Verschiebung delta_lr HT
    (if (= 1 2) (progn
	(if (= (Connect.get CastaData rechtesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (+ delta_lr_abt_ht delta_lr_ht)))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (+ delta_lr_abt_ht delta_lr_ht)))
	    )
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	    (progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1) 	(setq delta_lr_abt_ht (+ delta_lr_abt_ht delta_lr_ht)))
		(if (= (Connect.get CastaData amHTOberflansch) 1) 	(setq delta_lr_abt_ht (+ delta_lr_abt_ht delta_lr_ht)))
	    )
	)
    ))
	
  (Traeger.addabtl Htrg flLochbild   xPos wAbtl Flansch)
  (print delta_lr_at)
  
  (setq abteil 		(Traeger.get Htrg abteil flLochbild))
  (setq abteil_at (Traeger.get Tr_ID abteil flLochbild))
  
  (Anbauteil.set abteil (delta_lr delta_lr_abt_ht))
  
  
  (if (= 1 1) (progn
  (if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
			(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
			(if (= (Connect.get CastaData amHTOberflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
		)
	)
))
	(Anbauteil.set abteil (Master 1))
	(Anbauteil.set abteil_at (Master 0))
	
	
	
	(if (= LB_DEBUG 1)
		(progn
			(Lochbild.set flLochbild (e2 200))
			
			(setq lbDummy (Lochbild.create))
			(Lochbild.copy lbdummy flLochbild)
			
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildrechts_)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
				(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildlinks_)
			)
			
			(setq abteil_dummy (Traeger.get Tr_ID abteil lbdummy))
			
			(if (= (Connect.get CastaData rechtesEnde) 1)
		  	(progn
					(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil_dummy (SeitRicht 1)))
					(if (= (Connect.get CastaData amHTOberflansch) 1)		(Anbauteil.set abteil_dummy (SeitRicht -1)))
				)
			)
			(if (= (Connect.get CastaData linkesEnde) 1)
		  	(progn
					(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil_dummy (SeitRicht -1)))
					(if (= (Connect.get CastaData amHTOberflansch) 1)		(Anbauteil.set abteil_dummy (SeitRicht 1)))
				)
			)
			
			(Anbauteil.set abteil_dummy 		(Master 1))
			
		)
	)
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------
; Erzeugt die Sttzensteifen
; ----------------------------------------------------------------------
(defun createStuetzenSteifen (dp)
	(print "")
	(print "BEGIN createStuetzenSteifen")
	(print "---------------------------")
	; allgemeine Daten holen
	(setq h_trg    			(Traeger.get  Tr_Id h)
	      t_trg    			(Traeger.get  Tr_Id t)
	      delta_v_trg   (Traeger.get  Tr_Id delta_V)
	      h_htrg     		(Traeger.get  HTrg  h)
	      delta_v_htrg	(Traeger.get Htrg delta_v)
	      VWnkl    			(connect.get CastaData trg_vwinkel)
	      vwinkel_ht		(connect.get CastaData hpttrg_vwinkel)
	)
	
	(setq dp_steife 10)
	
	;(if (> VWnkl 180.0) (setq VWnkl (- 360.0 VWnkl)))
	(print VWnkl)
	
	
	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	(setq tanAlfa	(tan (/ (* VWnkl PI) 180.0)))
	
	(print cosAlfa)
	(print tanAlfa)
	
	;Hlfte des AT
	(setq h_trg_halb (/ (* 0.5 (- h_trg t_trg)) cosAlfa))
	(setq xOben (/ (* 0.5 (- h_trg dp_steife)) cosAlfa))
	
  (setq xPos (connect.get CastaData xPos_HT))
  
  (setq xPosOben	(+ xPos xOben)
  			xPosUnten	(- xPos h_trg_halb)
  )
  
    
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq VWnkl (- VWnkl))	
	)

	(if (>= vwinkel_ht 255.0)
		(progn
			(if (<= vwinkel_ht 285.0)
				(setq VWnkl (- VWnkl))	
			)
		)
	)
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq VWnkl (- VWnkl))
	)
	
	; Anteil aus Verschiebung des AT (delta_v)
	; ----------------------------------------
	(setq dhAT_aus_deltaV (/ delta_v_trg cosAlfa))
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
				)
			)
		)
	)
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
				)
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq dhAT_aus_deltaV dhAT_aus_deltaV))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq dhAT_aus_deltaV (- dhAT_aus_deltaV)))
				)
			)
		)
	)
	
	(setq xPosOben (- xPosOben dhAT_aus_deltaV))
	(setq xPosUnten (- xPosUnten dhAT_aus_deltaV))
	
	; Anteil aus Verschiebung des HT (delta_v)
	; ----------------------------------------
	(setq dhHT_aus_deltaV (* delta_v_htrg tanAlfa))
	(if (= oben_unten 0)
		(progn
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq dhHT_aus_deltaV (- dhHT_aus_deltaV))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV))
					)
				)	
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq dhHT_aus_deltaV (- dhHT_aus_deltaV))
					)
				)	
			)
		)
	)
	(if (= oben_unten 1)
		(progn
			(if (= (Connect.get CastaData amHtUnterflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq dhHT_aus_deltaV (- dhHT_aus_deltaV))
					)
				)	
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq dhHT_aus_deltaV (- dhHT_aus_deltaV))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq dhHT_aus_deltaV (+ dhHT_aus_deltaV))
					)
				)	
			)
		)
	)
	
	(setq xPosOben (- xPosOben dhHT_aus_deltaV))
	(setq xPosUnten (- xPosUnten dhHT_aus_deltaV))
	
	
	; Winkel der Steife
	; ----------------------------------------------
	(print "Winkel der Steife")
	(setq anschl_winkel (Connect.get CastaData at_laengswinkel))
	(print anschl_winkel)
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq steife_winkel (- 90.0 anschl_winkel)))
	(if (= (Connect.get CastaData amHtOberflansch) 1)		(setq steife_winkel (- anschl_winkel 90.0)))
	
	(print steife_winkel)
	
	
	
	; Erstellen der Steife
	; ---------------------
	(if (= oben_unten 1)
		(progn
			(checkForSteifeAtPosition xPosOben 100 Htrg)
			(if (= ABTL_VORH 0)
				(progn
					(setq blSteifeOben (blech.create))
					(Connect.storeAnschlObjs CastaData blSteifeOben)
					(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_)	;1539
					(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeOben))
					(Anbauteil.set  AbtlSteife (xpos xPosOben) (Winkel steife_winkel))
					(Blech.set blSteifeOben (dp dp_steife))
				)
			)
		)
	)
	
	(if (= oben_unten 0)
		(progn
			(checkForSteifeAtPosition xPosUnten 100 Htrg)
			(if (= ABTL_VORH 0)
				(progn
					(setq blSteifeUnten (blech.create))
					(Connect.storeAnschlObjs CastaData blSteifeUnten)
					(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)   ;1539
					(setq AbtlSteife (traeger.get Htrg ABTeil blSteifeUnten))
					(Anbauteil.set  AbtlSteife (xpos xPosUnten) (Winkel steife_winkel))
					(Blech.set blSteifeUnten (dp dp_steife))
				)
			)
		)
	)
	
	
	
	
	
	(Traeger.updvollstf Htrg)
	(print "---------------------------")
	(print "END createStuetzenSteifen")
	(print "")
)

; ********************************************************************************
; Erzeugt u. berechnet die Blechdaten fr die Kopfplatte
; ********************************************************************************
(defun calcAndSetZuglasche (blKopfplatte TrgEnde kplVerl)

   (print "---------------- calcAndSetBlechdatenKplHT -------------------------------")

   (setq hProf (Traeger.get HTrg h))		; Hhe des Haupttrgerprofils
   
   (setq delta_lr_at	(Traeger.get Tr_ID delta_lr))

   (setq hp  hProf)				; erstmal so voreinstellen
   (setq bp  (Traeger.get Tr_ID b))		; Breite
   (setq dp  20)
   
	 ; Dicke 
	 (setq t_at	(Traeger.get Tr_ID t))
	 
	 (setq dp_zugl (runde t_at auf 5))
	 
	 
   ;(setq kplverl 0)				; Verlngerung der Kopfplatte
   (setq schwKante 0)				
   
   ;(setq dOK schwKante)
   
   (if (= (connect.get CastaData amHtUnterFlansch) 1) 
   (progn
   	(setq dOK schwKante)
   ))
   (if (= (connect.get CastaData amHtOberFlansch) 1)
   (progn
   	(setq vers (+ kplverl schwKante)) 
   	(setq dOK (- vers))
   ))
   
   
   (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
   (print EWinkel)
        							
   								
   (setq hp (+ hp  kplverl))	
   (setq sinW (sin (* PI (/ EWinkel 180.0))))
	
   (if (/= sinW 0) (setq hp (/ hp sinW)))
        
        ;(setq hp (+ hp hVoute 40))
        
	(setq delta_lr_at_blech 0.0)
		
  (if (= (Connect.get CastaData satr-shtr)  1)
   	(setq delta_lr_at_blech delta_lr_at)
  )
	(if (= (Connect.get CastaData satr-shtr) -1)
   	(setq delta_lr_at_blech (- delta_lr_at))
  )
       
	; delta_lr HT
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_at_blech (- delta_lr_at_blech delta_lr_ht)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_at_blech (- delta_lr_at_blech delta_lr_ht)))	 
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_at_blech (- delta_lr_at_blech delta_lr_ht)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_at_blech (- delta_lr_at_blech delta_lr_ht)))	 
		)
	)
	
	
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
   (Blech.set blKopfplatte 	(dp dp_zugl) 
   				(hp hp) 
   				(bp bp) 
   				(dOK dOK)
   				(delta_lr delta_lr_at_blech)
   )

   (setq htDeltaV (Traeger.get hTrg delta_V))
;    (if (= (connect.get CastaData amHtOberFlansch) 1) (progn
;	(TrEnde.pTrim TrgEnde (- dp))
;    ))
;    (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
;	(TrEnde.pTrim TrgEnde dp)
;    ))

    (setq delta_L dp_zugl)
    (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
    	
    (print dp_zugl)							(print delta_L)
    ;(TrEnde.pTrim TrgEnde dp)

    (print "---------------- ENDE -------------------------------")
)

; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild der Zuglasche
; ----------------------------------------------------------------------------------------
(defun createZuglaschenLochbild (Blech_ID zuglLochbild kplverl)
	(print "*clear*")				; 20090513
	(print "BERECHNE ZUGLASCHENLOCHBILD")
	
	
	(Lochbild.set zuglLochbild 	(Guete   "4.6"))
	
	(setq t_at 		(Traeger.get Tr_ID t)
				h_at		(Traeger.get Tr_ID h)
				sysl_at	(Traeger.get Tr_ID syslng)
	)
			
	(setq s_ht		(Traeger.get Htrg s))
		
	(setq dp_blech	(Blech.get Blech_ID dp)
	      bp_blech	(Blech.get Blech_ID bp)
	      dok_blech	(Blech.get Blech_ID dok)
	)


	(setq dp_kopfplatte (Blech.get blKpl dp))
	
	(setq	xPos_ht		(Connect.get CastaData xPos_ht)
		xPos_at		(Connect.get CastaData xPos_at)
		afl_vwinkel	(Connect.get CastaData afl_vwinkel)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq delta_l (TrEnde.get TrgEnde delta_l)
				vwnkl		(TrEnde.get TrgEnde v_winkel)
	)
	(print vWnkl)
	
	(setq tanAN (tan (/ (* PI vwnkl) 180.0)))
	(print tanAN)
	(setq sinAFL (sin (/ (* PI afl_vwinkel) 180.0)))
	(setq tanAFL (tan (/ (* PI afl_vwinkel) 180.0)))
	
	(setq anteil_aus_neigung (/ (* 0.5 h_at) tanAN))
	
	(setq anteil_dp_blech (/ dp_kopfplatte sinAFL))
	(print anteil_dp_blech)
	(print dok_blech)
	
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq xpos (+ delta_l anteil_aus_neigung))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq xpos (- sysl_at delta_l (- anteil_aus_neigung)))
	)
	
	(setq w0 (+ (/ (- bp_blech s_ht) 2.0) s_ht))
	
	(Lochbild.set zuglLochbild 	(klemml (+ t_at dp_blech))
															(dxSKopf	dp_blech)
															(e0 minE_rand)
															(e1 minE_loch)
															(w0 w0)
															;(dlr_achse 300)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq abtl_at_winkel 0.0)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq abtl_at_winkel 180.0)
	)
	
	; Anschlusstraeger
	(Traeger.addabtl Tr_ID zuglLochbild xpos abtl_at_winkel _flanschlochbild_of_)
	
	; Haupttraeger
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(Traeger.addabtl Htrg zuglLochbild xpos_ht 0.0 _kpllochbildlinks_)
			(setq HtEnde (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(Traeger.addabtl Htrg zuglLochbild xpos_ht 0.0 _kpllochbildrechts_)
			(setq HtEnde (Traeger.get Htrg rechts))
		)
	)
	
	
	
	; delta_v ABTEIL am HT
	(setq vscherl_ht (TrEnde.get HtEnde vscherl))
	
	(setq anteil_zugl (/ dp_blech tanAFL))
	
	
	(setq delta_v_abtl (+ vscherl_ht anteil_dp_blech (- anteil_zugl)))
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq delta_v_abtl (- delta_v_abtl))
	)
	
	; delta_hr ABTEIL am HT
	(setq delta_lr_ht (Traeger.get Htrg delta_lr))
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr))
	(setq delta_lr_abtl delta_lr_ht)
	
;	(setq delta_lr_abtl (- delta_lr_abtl delta_lr_at))
	
	
	(setq dlr_blech (Blech.get Blech_ID delta_lr))
	(print dlr_blech)
	(print delta_lr_abtl)
;	(Lochbild.set zuglLochbild (LB_Art 2))				; 20090513 AF
	(setq  delta_lr_abtl (- delta_lr_abtl dlr_blech))
	(setq  delta_lr_abtl (-	dlr_blech))
	
	(setq abteil_lb_zugl_at (Traeger.get Tr_ID Abteil zuglLochbild))
	(Anbauteil.set abteil_lb_zugl_at (Master 1)
					 (SeitRicht  1)			;; zu berprfen	20090513
	)

	
	(setq abteil_lb_zugl_ht (Traeger.get Htrg Abteil zuglLochbild))
	(Anbauteil.set abteil_lb_zugl_ht (delta_v  delta_v_abtl)
					 (delta_lr delta_lr_abtl)
					 (Master 0)
					 (SeitRicht -1)			;; zu berprfen	20090513
	)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		(Anbauteil.set abteil_lb_zugl_ht (switch_on _unterflansch_))
	))
	
	; ------------------------------------------------------------------
	; LOCHBILD TEST
	; ------------------------------------------------------------------
	(if (= LB_DEBUG_ZL 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy zuglLochbild)
			
			(if (= (Connect.get CastaData anHtLinkesEnde) 1)
				(Traeger.addabtl Htrg dummy XPos_ht 0.0 _kpllochbildlinks_)
			)
			(if (= (Connect.get CastaData anHtRechtesEnde) 1)
				(Traeger.addabtl Htrg dummy XPos_ht 0.0 _kpllochbildrechts_)
			)
			
			(setq dummy_abtl (Traeger.get Htrg Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)
						  (delta_v delta_v_abtl)
						  (delta_lr delta_lr_abtl)
			)
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(Anbauteil.set dummy_abtl (switch_on _unterflansch_))
			)
		)
	)
	; ------------------------------------------------------------------
	(print "ENDE ZUGLASCHENLOCHBILD")
)


(defun calcSchrBez (TRG)
	(print "------------------------------------------------------------")
	(print "WHLE SCHRAUBE")
	(print "------------------------------------------------------------")
	(setq b_trg (Traeger.get TRG b)
				s_trg	(Traeger.get TRG s)
				r_trg	(Traeger.get TRG r)
	)
	
	(setq verfuegbarer_bereich (- (* 0.5 b_trg) (* 0.5 s_trg) r_trg))
	(print verfuegbarer_bereich)
	
	(setq maxSchDurch (* 0.25 verfuegbarer_bereich))
	(print maxSchDurch)
	
	(setq S_Bez_toSet "M36")
	
	(if (<= maxSchDurch 36.0)
		(setq S_Bez_toSet "M30")
	)
	(if (<= maxSchDurch 30.0)
		(setq S_Bez_toSet "M27")
	)
	(if (<= maxSchDurch 27.0)
		(setq S_Bez_toSet "M24")
	)
	(if (<= maxSchDurch 22.0)
		(setq S_Bez_toSet "M20")
	)
	(if (<= maxSchDurch 20.0)
		(setq S_Bez_toSet "M16")
	)
	(if (<= maxSchDurch 16.0)
		(setq S_Bez_toSet "M12")
	)
	(if (<= maxSchDurch 12.0)
		(setq S_Bez_toSet "M12")
	)
	
	(print S_Bez_toSet)
			
	(print "------------------------------------------------------------")
)


(defun calcMinRandLochAbst (LOCHB_ID)
	(print "------------------------------------------------------------")
	(print "BERECHNE MINIMALE RAND- UND LOCHABSTNDE")
	(print "------------------------------------------------------------")
	
	(setq dschr (Lochbild.get LOCHB_ID sdurchm))
	
	(setq minE_rand (* 2.0 dschr))
	(setq minE_loch	(* 4.0 dschr))
	(print "------------------------------------------------------------")
)


(defun calcKplVerl (BLECH_ID E_RAND E_LOCH)
	(print "------------------------------------------------------------")
	(print "BERECHNE ZUGLASCHENVERLNGERUNG")
	(print "------------------------------------------------------------")
	(setq afl_winkel (Connect.get CastaData afl_vwinkel))
	(print afl_winkel)
	
	(setq sinAFL (sin (/ (* PI afl_winkel) 180.0)))
	(print sinAFL)
	
	(setq dp_kpl (Blech.get BLECH_ID dp))
	(print dp_kpl)
	
	(setq anteil_kpl (/ dp_kpl sinAFL))
	(print anteil_kpl)
	
	(setq kplVerl (+ anteil_kpl E_LOCH (* 2.0 E_RAND)))
	(print kplVerl)
	
	(print "------------------------------------------------------------")
)