; $ 	HT	QT(IU)		AF(FS)	P(EZ)
; $	AT	QT(IUFL)	AF(K)		P(E)
; $	AE	V(90)			H(90)		R(0)

(defun load-modules ()
	(load "mod-endinit-uz-stzsteg")
	(load "mod-lochbild")
	;(load "mod-auskl-steifen-amSteg")
	(load "mod-multiconnect-stz-steg")
)

(defun init-connection ()
	
	
	(setq LB_DEBUG 0)
	
	;(checkPosition)
	(setq isInside 1)
	
	(if (= isInside 1)
		(progn
			(init-traegerenden 10)
			(setConnection)
		)
		(progn
			(alertBox "Anschluss nicht mglich"  "Connection_Not_Possible")
		)
	)
	
)



(defun setConnection ()
	
	; berprfung auf weitere Anschlsse
	(if (= (Connect.get CastaData amHtSteg) 1)
		(progn
			; berprfung der Umgebung auf Anbauteile
			(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
		  (print anzAnschl)
		  (if (> anzAnschl 0)
				(checkEnv)
			)
		)
	)
	
	
	(setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  (setq winkel_blech	(Winkel.create))
  (setq lchbAtrgSteg 	(lochbild.create))
  (Connect.storeAnschlObjs CastaData winkel_blech lchbAtrgSteg)
    
  (if (= (Connect.get CastaData exist_steglchb) 1)
  	(progn
  		(setq lchbWnkl (Connect.get CastaData steglchb_gegen))
  	)
	(progn
		(setq lchbWnkl (lochbild.create))
	)
  )
  (Connect.storeAnschlObjs CastaData lchbWnkl)

  
  ; Winkeldicke festlegen
	(setq wnkl_dw 10)
	
	
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn
			(createWinkel TrLinks winkel_blech)
			(setq AT_Ende (Traeger.get Tr_ID links)) 
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn
			(createWinkel TrRechts winkel_blech)
			(setq AT_Ende (Traeger.get Tr_ID rechts)) 
		)
	)

	(if (= (Connect.get CastaData exist_steglchb) 1)
		(getExistingLochbild)
		(createLochbildAbtl AT_Ende winkel_blech)
	)	
	
	; CALLBACKS
  (Winkel.set winkel_blech (formFkt "cb_winkel"))
  
  
    (if (= 2 3) (progn
	;; Testen - AF-20090513
	(Lochbild.set lchbWnkl (LB_Art   2))			; AF-20090512
	(Lochbild.set lchbWnkl (delta_w  50))		; AF-20090512
	(Lochbild.set lchbWnkl (e    "0 30 100 0 0 0"))	; AF-20090512
	(Lochbild.set lchbWnkl (w    "23 40"))		; AF-20090512

  ))

  
)

; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_winkel (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dwAlt (Winkel.get winkel_blech dw))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dwNeu (Winkel.get winkel_blech dw))
	    
	    (print dwAlt) (print dwNeu)
	    
	    (if (/= dwAlt dwNeu) (progn
			(setq dwDiff (- dwNeu dwAlt))
			(setq alteKlemml (Lochbild.get lchbWnkl Klemml))
			(setq dxsKopf_alt	(Lochbild.get lchbWnkl dxSKopf))
	       
			(setq dxsKopf_neu (+ dxsKopf_alt dwDiff))
	       	      
			(if (= (Connect.get CastaData amHtStegLinks) 1) 
		       (Lochbild.set lchbWnkl 	(Klemml (+ alteKlemml dwDiff))
		       							(dxSKopf	dxsKopf_neu)
		       )
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1) 
		       (Lochbild.set lchbWnkl 	(Klemml (+ alteKlemml dwDiff)))
			)
		    
			(if (= 2 3) (progn
			   ; am AT-Steg
			   (setq alteKlemml (Lochbild.get lchbAtrgSteg Klemml))
			   (setq dxsKopf_alt	(Lochbild.get lchbAtrgSteg dxSKopf))
			   
			   (setq dxsKopf_neu (+ dxsKopf_alt dwDiff))
					   
			   (Lochbild.set lchbAtrgSteg 	(Klemml (+ alteKlemml (* 2.0 dwDiff)))
																		(dxSKopf	dxsKopf_neu)
			   )
			))
	    ))
	))
)



; -------------------------------------------------------------------------
; Erzeugt die Winkel
; -------------------------------------------------------------------------
(defun createWinkel (TrgEnde Winkel)
	;Erzeugung der Winkel
	(calcAndSetWinkeldaten Winkel TrgEnde)
	(if (= TrgEnde TrLinks)
		(progn
			(traeger.addabtl tr_id Winkel 0.0 0.0 _kopfplattelinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn
			(traeger.addabtl tr_id Winkel 0.0 0.0 _kopfplatterechts_)
		)
	)
)

; --------------------------------------------------------------------------
; Berechnet die Daten der Winkel
; --------------------------------------------------------------------------
(defun calcAndSetWinkeldaten (wnklAnbTeil TrgEnde)

  (print "----------------------------- In calcAndSetWinkeldaten")

	(setq zAkl     (trEnde.get TrgEnde zakl)
				xAkl		 (trEnde.get TrgEnde xakl)
	      hSteg    (trEnde.get TrgEnde hsteg)
	      hProf    (Traeger.get Tr_ID h)
	      sAnProf  (Traeger.get Tr_ID s)
	      hcAnProf (Traeger.get Tr_ID hc);
	      bProf		 (Traeger.get Tr_ID b)
	      r_at		 (Traeger.get Tr_ID r)
	      t_at		 (Traeger.get Tr_ID t)
	)
	(setq bHtrg		 			(Traeger.get Htrg b);
	      delta_v_htrg	(Traeger.get Htrg delta_v)
	      hc_htrg				(Traeger.get Htrg hc)
	      delta_lr_ht		(Traeger.get Htrg delta_lr)
	)
	
	; Vorbereitung zu Bestimmung der Winkelhhe
	; ------------------------------------------------------------------
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< wnkl_dw sAnProf)
		(setq min_bl wnkl_dw)
		(setq min_bl sAnProf)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set lchbAtrgSteg (S_Bez S_Bez))
	(Lochbild.set lchbWnkl     (S_Bez S_Bez))
	
	; default Rand- und Lochabstnde aus Schraubendurchmesser bestimmen
	(calcMinRandLochAbst lchbAtrgSteg)	; -> e_min_rund, e1_min_rund, min_h
	; ->
	(setq wnkLng min_h)
		
	; wenn die min. Winkelhhe fr 4 Schrauben grer als die verfgbare Steglnge am AT ist,
	; wird die Winkelhhe auf die verfgbare Steglnge am AT gesetzt.
	(if (> wnkLng hcAnProf)
			(setq wnkLng hcAnProf)
	)
	; ->
	(setq dOK (* 0.5 (- hProf wnkLng)))
	
	
	; Blechhhe und dok bei Ausklinkung
	(if (/= hsteg 0.0)							
		(progn
			(print "hsteg /= 0")
			(if (/= zakl 0.0)						; unten und oben
				(progn
					(print "zakl /= 0")
					(if (> wnkLng hsteg)
						(setq wnkLng hsteg)
					)
					(setq dOK (+ zakl (* 0.5 (- hsteg wnkLng))))
				)													; nur unten
				(progn
					(print "zakl = 0")
					(setq verf_steg_l (- hProf t_at r_at (- hProf hsteg)))
					(if (>= wnkLng verf_steg_l)
						(progn
							(setq wnkLng verf_steg_l)
							(setq dok (+ t_at r_at))
						)
						(progn
							(setq diff_vsl_wl (- verf_steg_l wnkLng))
							(setq dok (+ t_at r_at (* 0.5 diff_vsl_wl)))
						)
					)
				)
			)
		)
		(progn
			(print "hsteg = 0")
			(if (/= zakl 0.0)						; nur oben
				(progn
					(print "zakl /= 0")
					(setq verf_steg_l (- hProf t_at r_at zakl))
					(if (>= wnkLng verf_steg_l)
						(progn
							(setq wnkLng verf_steg_l)
							(setq dok zakl)
						)
						(progn
							(setq diff_vsl_wl (- verf_steg_l wnkLng))
							(setq dok (+ zakl (* 0.5 diff_vsl_wl)))
						)
					)
				)													; keine
				(progn
					(print "zakl = 0")
				)
			)
		)
	)
	
	(if verf_steg_l
		(print verf_steg_l)
	)
	(print wnkLng)
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= TrgEnde TrRechts)
				(setq delta_v_htrg (- delta_v_htrg))
			)
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= TrgEnde TrRechts)
				(setq delta_v_htrg (- delta_v_htrg))
			)
			(if (= TrgEnde TrLinks)
				(setq delta_v_htrg (- delta_v_htrg))
			)
		)
	)
	      
	(setq s_HtProf (Traeger.get HTrg s))
	; muss jetzt noch berprft werden, ob es sich um ein U oder I-Profil handelt,
	; ggflls auch Kastenprofil - Rohre erst einmal nicht
	(setq s_HtProf (* 0.5 s_HtProf))
	      
	; Berechnung der Schenkellngen
	;(setq slk_std (* 0.5 hc_htrg))	; Teil am HT
	(setq slk_std	(+ (* 2.0 e_min_rund) wnkl_dw)) 
	(setq sll_std (+ (* 0.5 bHtrg) 10))				; Teil am AT
	
	; Achsabstand
	(setq achsAbst s_HtProf)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq achsAbst (+ achsAbst delta_lr_ht)))
	(if (= (Connect.get CastaData amHtStegLinks) 1)	(setq achsAbst (- achsAbst delta_lr_ht)))
	
	(print wnkLng)
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Winkel.set wnklAnbTeil (wanz 	 	2)
													(l 	 			wnkLng)
													(sll 	 		sll_std)
													(slk 	 		slk_std)
													(dw 	 		wnkl_dw)
													(wabst 	 	sAnProf)
													(achsab		achsAbst)
													(dok 	 		dOK)
													(delta_x 	0.0)
													(lage 	 	1)
													(schhoriz	100.000000)
	)
)

; -------------------------------------------------------------------------
; Erzeugt die Lochbild-Anbauteile
; -------------------------------------------------------------------------
(defun createLochbildAbtl (TrgEnde Winkel)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILDER")
		
	(calcAndSetLochbildDaten lchbWnkl TrgEnde Winkel)
	
	(setq	delta_V  			(Traeger.get hTrg delta_v)
				hProf    			(Traeger.get hTrg h)
	)
	
	(setq delta_V2 			(Traeger.get Tr_ID delta_v)
				hProf2   			(Traeger.get Tr_ID h)
				delta_lr_at		(Traeger.get Tr_ID delta_lr)
				lbDOK    			(- delta_V (/ hProf 2.0) (- (- (/ hProf2 2) delta_V2)))
	)
	(print lbDOK)
	
	(setq xPos_at (Connect.get CastaData xPos_at)
				xPos_ht	(Connect.get CastaData xPos_ht)
	)
	
	(setq xPos xPos_ht)
	
	;(if (= ori 1)
	;	(setq xPos (- xPos_HT delta_V2))
	;	(setq xPos (- xPos_HT delta_lr_at))
	;)
		
	; Lochbild-Anbauteil am Haupttrgersteg
	(print ori)
	(if (= ori 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(traeger.addabtl hTrg lchbWnkl xPos 180.0 _steglochbild_system_))
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(traeger.addabtl hTrg lchbWnkl xPos   0.0 _steglochbild_system_))
		)
		(progn
			(traeger.addabtl hTrg lchbWnkl xPos 90.0 _steglochbild_system_)
		)
	)
	
	(print TrgEnde)
	;Anschlusstrger
	(if (= (Connect.get CastaData linkesEnde) 1)	(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildlinks_))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildrechts_))
	
	
	(createLochbildAbtl_ATSteg TrgEnde Winkel)
	
	
	; Lochbild-Anbauteil des HT richtig ausrichten
	(setq e0_ht (Lochbild.get lchbWnkl e0))
	(setq delta_v_abtl	(- (* 0.5 hProf2)));(- e0_ht))
	(print delta_v_abtl)
	
	
	; Anbauteilverschiebungen
	; ==========================
	(setq delta_lr_abtl_ht 0.0)
	
	; Anteil delta_v HT
	; --------------------------
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_V)))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_V)))
	
	; Anteil delta_v AT
	; --------------------------
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl (+ delta_v_abtl delta_V2)))
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl (+ delta_v_abtl delta_V2)))
	
	; Anteil delta_lr AT
	; --------------------------
	(if (= (Connect.get CastaData vatr-lhtr)  1)	
		(progn
			(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
			(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
			(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
		)
	)
	
	
	
	(setq Abtl_lbhtsteg_ht (Traeger.get Htrg Abteil lchbWnkl))
	(Anbauteil.set Abtl_lbhtsteg_ht (Master 	1)
																	(delta_v 	delta_v_abtl)
																	(delta_lr	delta_lr_abtl_ht)
	)
	(setq Abtl_lbhtsteg_at (Traeger.get Tr_ID Abteil lchbWnkl))
	(Anbauteil.set Abtl_lbhtsteg_at (Master 0))
	
	; TEST
	(if (= LB_DEBUG 1)
		(progn
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy lchbWnkl)
			
			(if (= (Connect.get CastaData linkesEnde) 1)	(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(traeger.addabtl tr_id lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq Abtl_lbdummy (Traeger.get Tr_ID Abteil lbdummy))
			(Anbauteil.set Abtl_lbdummy (Master 1))
			
			(Connect.storeAnschlObjs CastaData lbdummy)
		)
	)
	
	(print "<-----------------------------------------------------------")
	; neu - August 2024
	(if (= (Connect.get CastaData amHtSteg) 1) (progn
		(setq changeSeiteRicht 0)
		(if (= (Connect.get CastaData linkesEnde)  1) (if (= (Connect.get CastaData amHtSTegRechts) 1) (setq changeSeiteRicht 1)))
		(if (= (Connect.get CastaData rechtesEnde) 1) (if (= (Connect.get CastaData amHtStegLinks)  1) (setq changeSeiteRicht 1)))
		(if (= changeSeiteRicht 1) (Anbauteil.set Abtl_lbhtsteg_ht (SeitRicht -1)))
	))

)




(defun createLochbildAbtl_ATSteg (TrgEnde WinkelID)
	;Anschlusstrger
	(if (= TrgEnde TrLinks)
		(progn 
			;am Anschlusstrger
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde WinkelID  2)
			(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
			
		)
	)
	
	(if (= TrgEnde TrRechts)
		(progn 
			;am Anschlusstrger
			(setq trgLaenge (Traeger.get Tr_ID syslng))
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde WinkelID -2)
			(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
		)
	)
)


; --------------------------------------------------------------------
; Berechnet die Lochbilddaten am Haupttrger
; --------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde WinkelID)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN AM HT")
	(print "------------------------------------------------------------")
	;Basiseinstellungen (evtl. weglassen und Gren in Abhngigkeit anderer Gren berechnen)
	(Lochbild.set Lchb_ID (Anz_S    4)
												(Guete   "4.6")
	)
	
	(setq Wnkl_L	(Winkel.get WinkelID l)
				slk_W		(Winkel.get WinkelID slk)
				dw_W		(Winkel.get WinkelID dw)
				dok_W		(Winkel.get WinkelID dok)
	)
	(setq h_trg		(Traeger.get Tr_ID h)
				hc_trg	(Traeger.get Tr_ID hc)
				s_trg		(Traeger.get Tr_ID s)
	)
	(setq hc_htrg (Traeger.get Htrg hc)
				s_htrg 	(Traeger.get Htrg s)
	)
	
	
	; default Rand- und Lochabstnde aus Schraubendurchmesser bestimmen
	(calcMinRandLochAbst lchbAtrgSteg)	; -> e_min_rund, e1_min_rund, min_h
	->
	(setq min_h_Winkel 		min_h)
	(setq e_blech 				e_min)
	(setq e1_blech 				e1_min)
	(setq e_blech_rund 		e_min_rund)
	(setq e1_blech_rund 	e1_min_rund)
	
	
	(setq slk_aus_e (+ (* e_blech_rund 2.0) dw_W)) ; min. Winkelbreite am HT aus Lochbild
	
	; standardmig 4 Schrauben
	(setq VIER 1)
	
	
	; Wenn die tatschliche Winkelhhe kleiner als die minimale Winkelhhe (fr 4 Schrauben) ist,
	; wird die Anzahl der Schrauben auf 2 reduziert.
	(if (< Wnkl_L min_h_Winkel)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq VIER 0) 
		)
	)
	
	
	(setq w0 (+ (* 0.5 s_trg) (* (+ dw_W e_blech_rund) 2.0)))					
	(setq w0rund (runde w0 auf 5))
		
		
	
	(if (= VIER 1)
		(progn
			;(setq e0 (- (* 0.5 h_trg) (* 0.5 e1_blech_rund)) )
			(setq e0 (+ dok_W e_blech_rund))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0rund) 
														(e1 e1_blech_rund)
														(w0 w0rund)
			)
		)
		(progn
			(setq e0 (+ dok_W (* 0.5 Wnkl_L)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0) 										
														(w0 w0rund)
			)
		)
	)
	(print "Hier")
	;Winkellnge am AT korregieren
	(Winkel.set WinkelID 	(slk slk_aus_e))
	;											(l l_aus_e)
	;											(dok (- dok (* 0.5 diff) ))
	;)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(setq dxS (* 0.5 s_htrg))
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq dxS (+ (* 0.5 s_htrg) dw_W))
	)
	
	(Lochbild.set Lchb_ID (klemml (+ dw_W s_htrg))
												(dxSKopf	dxS)
	)	
	
	(print "------------------------------------------------------------")
)

; --------------------------------------------------------------------
; Berechnet die Lochbilddaten am Anschlutrger
; --------------------------------------------------------------------
(defun calcAndSetLochbildDatenAtrgSteg (Lchb_ID TrgEnde WinkelID LB_Art)
;	Bei den w-Maen daran denken - werden nochmals durch 2 geteilt
;
	(Lochbild.set Lchb_ID	(Anz_S    4)
				(Guete   "4.6")
				(LB_Art LB_Art)
	)
		
	(setq Wnkl_L	(Winkel.get WinkelID l)
				dw_W		(Winkel.get WinkelID dw)
				dok_W		(Winkel.get WinkelID dok)
	)
	(setq h_trg				(Traeger.get Tr_ID h)
				l_trg				(Traeger.get Tr_ID l)
				hc_trg			(Traeger.get Tr_ID hc)
				s_trg				(Traeger.get Tr_ID s)
				delta_v_trg	(Traeger.get Tr_ID delta_v)
				delta_l_trg	(TrEnde.get TrgEnde delta_l)
	)
		
				
	; default Rand- und Lochabstnde aus Schraubendurchmesser bestimmen
	(calcMinRandLochAbst lchbAtrgSteg)	; -> e_min_rund, e1_min_rund, min_h
	->
	(setq min_h_Winkel 		min_h)
	(setq e_blech 				e_min)
	(setq e1_blech 				e1_min)
	(setq e_blech_rund 		e_min_rund)
	(setq e1_blech_rund 	e1_min_rund)
	
	; standardmig 4 Schrauben
	(setq VIER 1)
	
	(print Wnkl_L)
	(print min_h_Winkel)
	
	
	
	; Wenn die tatschliche Winkelhhe kleiner als die minimale Winkelhhe (fr 4 Schrauben) ist,
	; wird die Anzahl der Schrauben auf 2 reduziert.
	(if (< Wnkl_L min_h_Winkel)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq VIER 0) 
		)
	)	
	
	(setq w0 (+ e_blech dw_W))					; Randabstand
	(setq w0rund (runde w0 auf 5))
	(setq w1 (+ e1_blech w0rund))				; Lochabstand
	(setq w1rund (runde w1 auf 5))
		
	 
	
	(if (= VIER 1)
		(progn
			;(setq e0 (- (* 0.5 h_trg) (* 0.5 e1_blech_rund)) )
			(setq e0 (+ dok_W e_blech_rund))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0rund) 
														(e1 e1_blech_rund) 
														(w0 w0rund)
														(w1 w1rund)
			)
		)
		(progn
			(setq e0 (+ dok_W (* 0.5 Wnkl_L)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0) 										
														(w0 w0rund)
														(w1 w1rund)
			)
		)
	)
	
		
	;Winkellnge am AT korregieren
	(Winkel.set WinkelID 	(sll (- (+ w1rund w0rund) dw_W)))
	
	(Lochbild.set Lchb_ID (klemml (+ (* 2 dw_W) s_trg)))
)


; ----------------------------------------------------------------------------------------
; Prft, ob der Steg des AT in dem HC-Bereich des HT liegt
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq hc_ht 			(Traeger.get Htrg hc)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq delta_lr_at	(Traeger.get Tr_ID delta_lr)
				s_at				(Traeger.get Tr_ID s)
	)
	
	; obere und untere Ausrundung des HT
	(setq ausrO_ht (- delta_v_ht (* 0.5 hc_ht)))
	(setq ausrU_ht (+ ausrO_ht hc_ht))
	(print ausrO_ht)
	(print ausrU_ht)
	(print delta_lr_at)
		
	(if (= (Connect.get CastaData satr-vhtr) 1)
		(progn
			(if (> delta_lr_at ausrU_ht)
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at ausrO_ht)
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (> delta_lr_at (- ausrO_ht))
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at (- ausrU_ht))
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	
	(if (= isInside 0)
		(print "AUSSERHALB")
		(print "INNERHALB")
	)
)

(defun getExistingLochbild ()
	(alertBox "Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden. Nehmen Sie nderungen ggf. manuell vor."  "OppositeSideConnection_Found")
			
	(setq dp_wnkl (Winkel.get winkel_blech dw))
	(print dp_wnkl)
			
	(setq klemml_alt 	(Lochbild.get lchbWnkl klemml))
	(setq dxskopf_alt	(Lochbild.get lchbWnkl dxsKopf))
	(print klemml_alt)
	(print dxskopf_alt)
			
	(setq klemml_neu 	(+ klemml_alt dp_wnkl))
	(setq dxskopf_neu (+ dxskopf_alt dp_wnkl))
	(print klemml_neu)
	(print dxskopf_neu)
			
	(if (= (Connect.get CastaData amHtSTegLinks) 1)
		(Lochbild.set lchbWnkl	(klemml klemml_neu)
								(dxsKopf dxskopf_neu)
		)	
	)								
	(if (= (Connect.get CastaData amHtSTegRechts) 1)
		(Lochbild.set lchbWnkl (klemml klemml_neu))	
	)	
			
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildrechts_)
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildlinks_)
		)
	)
			
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
			delta_lt_at	(traeger.get Tr_ID delta_lr)
	)
			
	(setq at_lochbild_abtl (Traeger.get Tr_ID Abteil lchbWnkl))
	(setq Ht_lochbild_abtl (Traeger.get HTrg  Abteil lchbWnkl))
		  
	(Anbauteil.set at_lochbild_abtl (Master 	0)
		  						(delta_v 	(- delta_v_at))
		  						;(delta_lr 40); ??? funktioniert nicht
	)
	
	(setq changeSeiteRicht 0)
	(if (= (Connect.get CastaData linkesEnde)  1) (if (= (Connect.get CastaData amHTStegRechts) 1) (setq changeSeiteRicht 1)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (if (= (Connect.get CastaData amHTStegLinks)  1) (setq changeSeiteRicht 1)))
	(if (= (Connect.get CastaData exist_steglchb) 1) (progn
		(setq htLchbSeitRicht (Anbauteil.get Ht_lochbild_abtl SeitRicht))
		(if (>= htLchbSeitRicht  0) (if (= changeSeiteRicht 1) (Anbauteil.set at_lochbild_abtl (SeitRicht -1))))
		(if (=  htLchbSeitRicht -1) (if (= changeSeiteRicht 0) (Anbauteil.set at_lochbild_abtl (SeitRicht -1))))
	))
	
	(createLochbildAbtl_ATSteg AT_Ende winkel_blech)							
)