(defun init-connection ()

  (connect.showattributes CastaData)

  (print "in init-connection uz_an_uz-Steg");

  (setq TrTest (traeger.create))
  (setq TrLi   (trende.create))

  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))

  (setq HTrLinks   (traeger.get htrg links))
  (setq HTrRechts  (traeger.get htrg rechts))

  (print htrg);
  (print an_seite)

  ; Bedeutung an_seite
  ; 10 - links zwischendurch
  ; 11 - links an linkes Ende des Haupttrgers
  ; 12 - links an rechtes Ende des Haupttrgers
  ; 20 - rechts zwischendurch
  ; 21 - rechts an linkes Ende des Haupttrgers
  ; 22 - rechts an rechtes Ende des Haupttrgers
  ;
  (setq _links 1 _rechts 2)
    (print vwnkl_aflch)


  (if (= an_seite 22) (setq ept_HTrg _rechts ept_ATrg _rechts))
  (if (= an_seite 21) (setq ept_HTrg _links  ept_ATrg _rechts))
  (if (= an_seite 20) (setq ept_HTrg      0  ept_ATrg _rechts))
  (if (= an_seite 12) (setq ept_HTrg _rechts ept_ATrg _links))
  (if (= an_seite 11) (setq ept_HTrg _links  ept_ATrg _links))
  (if (= an_seite 10) (setq ept_HTrg      0  ept_ATrg _links))


  ; Trgerende-Ablngug aufgrund des Sttzenprofils
  (if (= ept_ATrg _rechts)  (progn
  						(print "Anschluss rechts am Anschlusstrger")
	(berechneTrgEndeAblng TrRechts)

	(setq blKplRechts (blech.create))
	(Connect.storeAnschlObjs CastaData blKplRechts)
	(calcAndSetBlechdaten blKplRechts TrRechts)
	(traeger.addabtl tr_id blKplRechts 0.0 0.0 _kopfplatterechts_)

	(setq lchbKplRechts (lochbild.create))
	(Connect.storeAnschlObjs CastaData lchbKplRechts)
	(calcAndSetLochbildDaten lchbKplRechts TrRechts blKplRechts);
	(traeger.addabtl tr_id lchbKplRechts 0.0 0.0 _kpllochbildrechts_)
  ))
  
  (if (= ept_ATrg _links)  (progn
  						(print "Anschluss links am Anschlusstrger")
	(berechneTrgEndeAblng TrLinks)

	(setq blKplLinks (blech.create))
	(Connect.storeAnschlObjs CastaData blKplLinks)
	(calcAndSetBlechdaten blKplLinks TrLinks)
	(traeger.addabtl tr_id blKplLinks 0.0 0.0 _kopfplattelinks_)

	(setq lchbKplLinks (lochbild.create))
	(Connect.storeAnschlObjs CastaData lchbKplLinks)
	(calcAndSetLochbildDaten lchbKplLinks TrLinks blKplLinks);
	(traeger.addabtl tr_id lchbKplLinks 0.0 0.0 _kpllochbildlinks_)
  ))


  ; Verlngerung des Endes am Haupttrger
  (if (= ept_HTrg _links) 
    (progn					(print "ept_HTrg _links")
	(setq hProf (traeger.get tr_id h))
	(setq  delta_L (- (/ hProf 2.0)))
	(setq delta_L_alt (TrEnde.get HTrLinks delta_l))
	; ist negativ - deswegen so rum abfragen. Wenn das Ende zu kurz ist, dann
	; muss es verlngert werden.
	(if (> delta_L_alt delta_L)  (trende.set  HTrLinks (delta_l delta_L)))
    )
  )

  (if (= ept_HTrg _rechts) 
    (progn					(print "ept_HTrg _rechts")
	(setq hProf (traeger.get tr_id h))
	(setq  delta_L (- (/ hProf 2.0)))
	(setq delta_L_alt (TrEnde.get HTrRechts delta_l))
	; ist negativ - deswegen so rum abfragen. Wenn das Ende zu kurz ist, dann
	; muss es verlngert werden.
	(if (> delta_L_alt delta_L)  (trende.set  HTrRechts (delta_l delta_L)))
    )
  )

  
)
; ---------------------------------------------------------------------- */
; Traegerende muss um s/2 bzw. Stegdicke gekrzt werden
; derzeit noch keine U-Profile, da hier anderer Wert (entweder 0 oder s)
(defun berechneTrgEndeAblng (TrgEnde)
					(print "in berechneTrgEndeAblng")
					(print vwnkl_aflch)
	(if (> vwnkl_aflch 180.0) 
	   (setq vWnkl (- vwnkl_aflch 180.0))
	   (setq vWnkl    vwnkl_aflch)
	)
	(trende.set     TrgEnde (V_Winkel (- 90.0 (- vWnkl 90.0))))
	(setq Profil (traeger.get hTrg Profil))
	(setq sProf (traeger.get hTrg s))
	(setq  delta_L (/ sProf 2.0))
	(trende.set     TrgEnde (delta_l delta_L))
)
; ---------------------------------------------------------------------- */
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)

   (print "----------------------------- In calcAndSetBlechdaten")

        (setq hProf (Traeger.get Tr_ID h))

	(setq hp (- hProf 10))	; wir erzeugen eine bndige Kopfplatte
        (setq bp 120)
        (setq dp  10)
        (setq dOK  5)
	      
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp 10) (hp hp) (bp bp) (dOK dOK))
	
	(TrEnde.pTrim TrgEnde dp)
)
; ---------------------------------------------------------------------- */
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde Blech_ID)
	(Lochbild.set Lchb_ID 
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "50 100 0 0 0 0")
		(w       "60  0)

	)

	(setq s_htrg (Traeger.get Htrg s))
	(setq dp_blech (Blech.get Blech_ID dp))
	
	(Lochbild.set Lchb_ID (klemml (+ s_htrg dp_blech))) 	
)
