; $	HT	QT(IUK)		AF(S)		P(EZ)
; $	AT	QT(IU)		AF(K)		P(E)
; $	AE	V(-)		H(90)		R(0-45 135-180)

(defun load-modules ()
   (load "mod-endinit-uz-stzsteg")
   (load "mod-multiconnect-stz-steg")
   (load "mod-add-schweiss-querschn")
)

(defun init-connection ()
	(print "*clear*")
	(print "Initialisieren ANSCHLUSS")
	(connect.showattributes CastaData)
	
	(checkPosition)
  (if (= isInside 1) (progn
  	  (init-traegerenden 0)
  	  (SchweissProfil_Einsetzen_St)
  		
  	  ; berprfung der Umgebung auf Anbauteile
	  (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	  (print anzAnschl)
	  (if (> anzAnschl 0)	(checkEnv))
	)
	(progn
  		(alertBox "Anschluss ist nicht mglich!"  "Connection_Not_Possible")
  ))
  				
  
)

; ----------------------------------------------------------------------------------------
; Prft, ob der Steg des AT in den HC-Berech des HT liegt
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq	hc_ht 		(Traeger.get Htrg hc)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		s_at		(Traeger.get Tr_ID s)
	)
	
	; obere und untere Ausrundung des HT
	(setq ausrO_ht (- delta_v_ht (* 0.5 hc_ht)))
	(setq ausrU_ht (+ ausrO_ht hc_ht))
	(print ausrO_ht)
	(print ausrU_ht)
	(print delta_lr_at)
		
	(if (= (Connect.get CastaData satr-vhtr) 1)
		(progn
			(if (> delta_lr_at ausrU_ht)
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at ausrO_ht)
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (> delta_lr_at (- ausrO_ht))
				(progn
					(setq isInside 0)
				)
				(progn
					(if (< delta_lr_at (- ausrU_ht))
						(setq isInside 0)
						(setq isInside 1)
					)
				)
			)
		)
	)
	
	(if (= isInside 0)
		(print "AUSSERHALB")
		(print "INNERHALB")
	)
)



(defun SchweissProfil_Einsetzen ()

;	(print "*clear*")

	; Anschlussdaten ...
	; X-Position
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	; Rotationswinkel des AT
	(setq rWinkel 0.0)
	(setq rWinkel_AT	(Connect.get CastaData r-atrgewnkl_steg ))

	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (- rWinkel_AT 90.0)))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel (- (- rWinkel_AT 90.0))))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (- rWinkel_AT 90.0)))
	))

	(print "----------------") (print rWinkel)

	(setq rWinkel_Abtl rWinkel)
	(if (= (Connect.get CastaData linkesEnde)     1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)     1)  (setq rWinkel_Abtl (- rWinkel)))
	))
	(if (= (Connect.get CastaData rechtesEnde)     1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)    -1) (setq rWinkel_Abtl (- rWinkel)))
	))
	(if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel_Abtl    (- rWinkel_Abtl)))
	
	(if (< rWinkel_Abtl 0.0) (setq rWinkel_Abtl (+ 180.0 rWinkel_Abtl)))
	(if (= (Connect.get CastaData vatr-lhtr)     1)  (setq rWinkel_Abtl (+ rWinkel_Abtl 180.0)))
	

	(if (= (Connect.get CastaData amHtStegLinks)  1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel_Abtl _steg_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel_Abtl _steg_rechts_))
	
	; Anbauteil ermitteln
	(setq abtl_Trg (Traeger.get HTrg abTeil Tr_ID))
	(if (= (Connect.get CastaData linkesEnde)     1) (Anbauteil.set abtl_Trg (addflag  _endelinks_)))
	(if (= (Connect.get CastaData rechtesEnde)    1) (Anbauteil.set abtl_Trg (addflag _enderechts_)))
	(if (= (Connect.get CastaData amHtStegLinks)  1) (Anbauteil.set abtl_Trg (addflag _steg_links_)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Anbauteil.set abtl_Trg (addflag _steg_rechts_)))

	
	(setq	dv_HT 	(Traeger.get HTrg delta_V))
	(setq	dv_AT 	(Traeger.get Tr_ID delta_V)
		dlr_AT	(Traeger.get Tr_ID delta_LR)
	)

	(print "Eingangswerte: -----------------------------------------")
	(print dv_HT)
	(print dv_AT)
	(print dlr_AT)


	(print rWinkel_AT)
	(print rWinkel_Abtl)
	(print rWinkel)
	(setq sinWnk  (sin (* PI (/ rWinkel 180.0))))
	(setq cosWnk  (cos (* PI (/ rWinkel 180.0))))
	
	(print sinWnk)
	(print cosWnk)


	(setq delta_V_Abtl dv_AT)
	
	(setq delta_LR_Abtl dlr_AT)
	(if (= (Connect.get CastaData satr-lhtr-ex)    -1)  (setq delta_LR_Abtl (- dlr_AT)))


	(setq delta_V_Abtl_Set  (- (* cosWnk delta_V_Abtl)  (* sinWnk delta_LR_Abtl)))
	(setq delta_LR_Abtl_Set (+ (* cosWnk delta_LR_Abtl) (* sinWnk delta_V_Abtl)))

	(if (= (Connect.get CastaData amHtStegRechts)  1) (setq dv_HT    (- dv_HT)))
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData satr-lhtr-ex)  1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
	    (if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData satr-lhtr-ex)  1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
	    (if (= (Connect.get CastaData satr-lhtr-ex) -1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
	))



	(if (= (Connect.get CastaData rechtesEnde)   1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)    -1)  (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		    (if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
		    (if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
		))
	))
	(if (= (Connect.get CastaData linkesEnde)   1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)     1)  (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		    (if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_V_Abtl_Set (+ delta_V_Abtl_Set dv_HT)))
		    (if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set dv_HT)))
		))
	))
	(if (/= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		(if (= (Connect.get CastaData amHtStegRechts)   1) (setq delta_V_Abtl_Set (- delta_V_Abtl_Set)))
	))
	



	(Anbauteil.set abtl_Trg (delta_V  (- delta_V_Abtl_Set)))
	(Anbauteil.set abtl_Trg (delta_LR delta_LR_Abtl_Set))
	
	
	(print delta_V_Abtl_Set)
	(print delta_LR_Abtl_Set)

	(print (Connect.get CastaData satr-lhtr-ex))


)  	
