; $	HT	QT(IUK)		AF(F)			P(EZ)
; $	AT	QT(IU)		AF(K)			P(E)
; $  AE	V(90)			H(90)			R(0)

(defun load-modules ()
	(load "mod-endinit-uz-stzflansch-abstand")
)

(defun init-connection ()
	
	(init-traegerenden )
	
	(Connect.showAttributes CastaData)
	
	(setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  (setq winkel_blech	(Winkel.create))
  (Connect.storeAnschlObjs CastaData winkel_blech)
  
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn
			(createWinkel TrLinks winkel_blech)
			(createLochbild TrLinks winkel_blech 2)	
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn
			(createWinkel TrRechts winkel_blech)
			(createLochbild TrRechts winkel_blech -2)	
		)
	)
  
  
  ; CALLBACKS
  (Winkel.set winkel_blech (formFkt "cb_winkel"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_winkel (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dwAlt (Winkel.get winkel_blech dw))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dwNeu (Winkel.get winkel_blech dw))
	    
	    (print dwAlt) (print dwNeu)
	    
	    (if (/= dwAlt dwNeu) (progn
			(setq dwDiff (- dwNeu dwAlt))
			(setq alteKlemml (Lochbild.get lchbWnkl Klemml))
			(setq dxsKopf_alt	(Lochbild.get lchbWnkl dxSKopf))
	       
			(setq dxsKopf_neu (+ dxsKopf_alt dwDiff))
	       	       
			(Lochbild.set lchbWnkl 	(Klemml (+ alteKlemml dwDiff))
	       							(dxSKopf	dxsKopf_neu)
			)
	       
			(if (= 2 3) (progn
				; am AT-Steg
				(setq alteKlemml (Lochbild.get lchbAtrgSteg Klemml))
				(setq dxsKopf_alt	(Lochbild.get lchbAtrgSteg dxSKopf))
			   
				(setq dxsKopf_neu (+ dxsKopf_alt dwDiff))
					   
				(Lochbild.set lchbAtrgSteg 	(Klemml		(+ alteKlemml (* 2.0 dwDiff)))
											(dxSKopf	dxsKopf_neu)
				)
			))
			  
	    ))
	))
)



; -------------------------------------------------------------------------
; Erzeugt die Winkel
; -------------------------------------------------------------------------
(defun createWinkel (TrgEnde Winkel)
	;Erzeugung der Winkel
	(calcAndSetWinkeldaten Winkel TrgEnde)
	(if (= TrgEnde TrLinks)
		(progn
			(traeger.addabtl tr_id Winkel 0.0 0.0 _kopfplattelinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn
			(traeger.addabtl tr_id Winkel 0.0 0.0 _kopfplatterechts_)
		)
	)
	
	(Winkel.set Winkel (vWinkel 45))
)

; --------------------------------------------------------------------------
; Berechnet die Daten der Winkel
; --------------------------------------------------------------------------
(defun calcAndSetWinkeldaten (wnklAnbTeil TrgEnde)

  (print "----------------------------- In calcAndSetWinkeldaten")

	(setq zAkl     (trEnde.get TrgEnde zakl)
				xAkl		 (trEnde.get TrgEnde xakl)
	      hSteg    (trEnde.get TrgEnde hsteg)
	      hProf    (Traeger.get Tr_ID h)
	      sAnProf  (Traeger.get Tr_ID s)
	      hcAnProf (Traeger.get Tr_ID hc)
	      bProf		 (Traeger.get Tr_ID b)
	      dlMinFl  (* 0.5 (- hProf hcAnProf))
	)
	(setq bHtrg		 			(Traeger.get Htrg b)
	      delta_v_htrg	(Traeger.get Htrg delta_v)
	      qsform				(Traeger.get Htrg qsform)
	      h_ht					(Traeger.get Htrg h)
	)
	
	(setq diffWnklHc 20) ; Unterschied zwischen hc des Trgers und der Winkelhhe
	
	(print "---------")
	(print zAkl)
	(print hSteg)
	(print hProf)
	(print hcAnProf)
	(print "---------")
	
	(setq dOK     dlMinFl 
	      wnkLng  hcAnProf
	)
	
	
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= TrgEnde TrRechts)
				(setq delta_v_htrg (- delta_v_htrg))
			)
			(if (= TrgEnde TrLinks)
				(setq delta_v_htrg (- delta_v_htrg))
			)
		)
	)
	      
	(setq b_HtProf (Traeger.get HTrg b))
	(print b_HtProf)
	; muss jetzt noch berprft werden, ob es sich um ein U oder I-Profil handelt,
	; ggflls auch Kastenprofil - Rohre erst einmal nicht
	(setq b_HtProf (* 0.5 b_HtProf))
	(print b_HtProf) 
	
	(setq h_ht_halb (* 0.5 h_ht))
	
	; Berechnung der Schenkellngen
	(setq slk_std (* 0.5 (- bProf sAnProf)))	; Teil am HT
	(setq sll_std (+ (* 0.5 bHtrg) 10 ))				; Teil am AT
	(setq dw 10)
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	
	;Achsabstand
	(if (= qsform "K")
		(progn
			(setq achsABST (* 0.5 bHtrg))
		)
		(progn
			(if (= (Connect.get CastaData amHtSteg) 1)		(setq achsABST (- b_HtProf (* 0.5 dw) delta_v_htrg)))
			(if (= (Connect.get CastaData amHtFlansch) 1)	(setq achsABST (- h_ht_halb delta_v_htrg)))
		)
	)
	
	(print achsABST)
	
	(Winkel.set wnklAnbTeil (wanz 	 	2)
													(l 	 			wnkLng)
													(sll 	 		sll_std)
													(slk 	 		slk_std)
													(dw 	 		dw)
													(wabst 	 	sAnProf)
													(achsab		achsABST)
													(dok 	 		dOK)
													(delta_x 	0.0)
													(lage 	 	1)
													(schhoriz	100.000000)
	)
)

; -------------------------------------------------------------------------
; Erzeugt die Lochbilder
; -------------------------------------------------------------------------
(defun createLochbild (TrgEnde Winkel LB_Art)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	; Lochbild HT - Winkel
	(setq lchbWnkl (lochbild.create))
	(Connect.storeAnschlObjs CastaData lchbWnkl)
	(calcAndSetLochbildDaten lchbWnkl TrgEnde Winkel)
	
	; allg. Daten
	(setq	delta_V  		(Traeger.get Htrg delta_v)
				hProf    		(Traeger.get Htrg h)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq	delta_V2 		(Traeger.get Tr_ID delta_v)
				hProf2   		(Traeger.get Tr_ID h)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	
	; Lochbild AT - Winkel (nur am AT vorhanden)
	(setq lchbAtrgSteg (lochbild.create))
	(Connect.storeAnschlObjs CastaData lchbAtrgSteg)
	
	(setq hProf_halb	(* 0.5 hProf))
	
	; xPos am HT
	; ----------
	; Flanschlochbild ausrichten
	(if (= (Connect.get CastaData vatr-lhtr) 1)
		(progn
			(setq abtlWinkel 0.0)
			(setq xPos_HT (- xPos_HT (* 0.5 hProf2)))
			; Verschiebung des AT in delta_v
			(setq xPos_HT (+ xPos_HT delta_V2))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(setq abtlWinkel 180.0)
			(setq xPos_HT (+ xPos_HT (* 0.5 hProf2)))
			; Verschiebung des AT in delta_v
			(setq xPos_HT (- xPos_HT delta_V2))
		)
	)
	(print abtlWinkel)
	
	
	(if (= TrgEnde TrLinks)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildlinks_)
			
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(traeger.addabtl hTrg lchbWnkl xPos_HT abtlWinkel _flanschlochbild_of_)
				(traeger.addabtl hTrg lchbWnkl xPos_HT abtlWinkel _flanschlochbild_uf_)
			)
						
			;am Anschlusstrger
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde Winkel LB_Art)
			(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildrechts_)
			
			(if (= (Connect.get CastaData amHtOberflansch) 1)
				(traeger.addabtl hTrg lchbWnkl xPos_HT abtlWinkel _flanschlochbild_of_)
				(traeger.addabtl hTrg lchbWnkl xPos_HT abtlWinkel _flanschlochbild_uf_)
			)
						
			;am Anschlusstrger
			(setq trgLaenge (Traeger.get Tr_ID syslng))
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde Winkel LB_Art)
			(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
		)
	)
	
	
	; Anbauteilverschiebungen
	; ==========================
	(setq delta_lr_abteil_ht 0.0)
	
	; Anteil delta_lr AT
	; --------------------------
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abteil_ht (- delta_lr_abteil_ht delta_lr_at)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abteil_ht (+ delta_lr_abteil_ht delta_lr_at)))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abteil_ht (+ delta_lr_abteil_ht delta_lr_at)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abteil_ht (- delta_lr_abteil_ht delta_lr_at)))
				)
			)
		)
	)
	
	; Anteil delta_lr HT
	; --------------------------
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abteil_ht (+ delta_lr_abteil_ht delta_lr_ht)))
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abteil_ht (- delta_lr_abteil_ht delta_lr_ht)))
		)
	)
	
		
	(print delta_lr_abteil_ht)
	
	; Anbauteil Lochbild HT-Winkel
	(setq Abtl_ht_flanschlochbild (Traeger.get Htrg Abteil lchbWnkl))
	(Anbauteil.set Abtl_ht_flanschlochbild 	(Master 1)
																					(delta_lr delta_lr_abteil_ht)	
	)
	(setq Abtl_at_flanschlochbild (Traeger.get Tr_ID Abteil lchbWnkl))
	(Anbauteil.set Abtl_at_flanschlochbild 	(Master 0))
	
	(print "<-----------------------------------------------------------")
	; neu - August 2024
	(if (= (Connect.get CastaData amHtFlansch) 1) (progn
		(setq changeSeiteRicht 0)
		(if (= (Connect.get CastaData linkesEnde)  1) (if (= (Connect.get CastaData amHtOberflansch)  1) (setq changeSeiteRicht 1)))
		(if (= (Connect.get CastaData rechtesEnde) 1) (if (= (Connect.get CastaData amHtUnterflansch) 1) (setq changeSeiteRicht 1)))
		(if (= changeSeiteRicht 1) (Anbauteil.set Abtl_ht_flanschlochbild (SeitRicht -1)))
	))
		
	
)

; ----------------------------------------------------------------------------------
; Berechnet die Lochbilddaten des Anschlusstrgers fr den Anschluss am Haupttrger
; ----------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde WinkelID)
	(print ">-----------------------------------------------------------")
	(print "LOCHBILDDATEN HT-AT")
	;Basiseinstellungen (evtl. weglassen und Gren in Abhngigkeit anderer Gren berechnen)
	(Lochbild.set Lchb_ID (Anz_S    4)
												(Guete   "4.6")
												(e       "100 0 0 0 0 0")
												(w       "40  0")
	)
	
	(setq Wnkl_L	(Winkel.get WinkelID l)
				slk_W		(Winkel.get WinkelID slk)
				dw_W		(Winkel.get WinkelID dw)
	)
	(setq h_trg		(Traeger.get Tr_ID h)
				hc_trg	(Traeger.get Tr_ID hc)
				s_trg		(Traeger.get Tr_ID s)
	)
	(setq hc_htrg (Traeger.get Htrg hc)
				t_htrg	(Traeger.get Htrg t)
	)
	
	; Schaube anhand der Anschlusstrgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq l_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	(setq slk_aus_e (+ (* e_blech_rund 2.0) dw_W)) ; min. Winkelbreite am HT aus Lochbild
	
	(setq hc hc_trg)
	
	
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	(if (> l_aus_e hc)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq l_aus_e (* e_blech_rund 2.0))
			(setq VIER 0) 
		)
	)
	
	
	(setq w0 (+ (* 0.5 s_trg) (* (+ dw_W e_blech_rund) 2.0)))					
	(setq w0rund (runde w0 auf 5))
		
	(if (= VIER 1)
		(progn
			(setq e0 (- (* 0.5 h_trg) (* 0.5 e1_blech)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0) 
														(e1 e1_blech_rund) 
														(w0 w0rund)
			)
		)
		(progn
			(setq e0 (* 0.5 h_trg))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0) 										
														(w0 w0rund)
			)
		)
	)
	
	(print e0)
	
	(print w0)
	
	;Winkellnge am AT korregieren
	(Winkel.set WinkelID 	(slk slk_aus_e))
	;											(l l_aus_e)
	;											(dok (- dok (* 0.5 diff) ))
	;)	
	
	(setq dxS dw_w)
	
	(Lochbild.set Lchb_ID (klemml 	(+ dw_w t_htrg))
												(dxSKopf	dxS)
	)
	
	(print "------------------------------------------------------------")
)

; --------------------------------------------------------------------
; Berechnet die Lochbilddaten des Anschlutrgers am Steg
; --------------------------------------------------------------------
(defun calcAndSetLochbildDatenAtrgSteg (Lchb_ID TrgEnde WinkelID LB_Art)
;	Bei den w-Maen daran denken - werden nochmals durch 2 geteilt
;	
	(Lochbild.set Lchb_ID	(Anz_S    4)
				(Guete   "4.6")
				(e       "100 50 0 0 0 0")
				(w       "60  140")
				;(klemml   55)
				(LB_Art LB_Art)
	)
		
	(setq Wnkl_L	(Winkel.get WinkelID l)
				dw_W		(Winkel.get WinkelID dw)
				dok_W		(Winkel.get WinkelID dok)
	)
	(setq h_trg				(Traeger.get Tr_ID h)
				l_trg				(Traeger.get Tr_ID l)
				s_trg				(Traeger.get Tr_ID s)
				hc_trg			(Traeger.get Tr_ID hc)
				delta_v_trg	(Traeger.get Tr_ID delta_v)
				delta_l_trg	(TrEnde.get TrgEnde delta_l)
	)
		
	; Schaube anhand der Anschlusstrgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq l_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	(print hc_trg)
	(print l_aus_e)
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	(if (> l_aus_e hc_trg)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq l_aus_e (* e_blech_rund 2.0))
			(setq VIER 0) 
		)
	)	
	
	(setq w0 (+ e_blech dw_W))					; Randabstand
	(setq w0rund (runde w0 auf 5))
	(setq w1 (+ e1_blech w0rund))				; Lochabstand
	(setq w1rund (runde w1 auf 5))
		
	 
	
	(if (= VIER 1)
		(progn
			(setq e0 (- (* 0.5 h_trg) (* 0.5 e1_blech_rund)) )
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0rund) 
														(e1 e1_blech_rund) 
														(w0 w0rund)
														(w1 w1rund)
			)
		)
		(progn
			(setq e0 (* 0.5 h_trg))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0) 										
														(w0 w0rund)
														(w1 w1rund)
			)
		)
	)
	
	(setq diff (- l_aus_e Wnkl_L)) ; Differenz zwischen alter und neuer Winkelhhe
	
	;Winkellnge am AT korregieren
	(Winkel.set WinkelID 	(sll (- (+ w1rund w0rund) dw_W))
												(l l_aus_e)
												(dok (- dok (* 0.5 diff) ))
	)
	
	(Lochbild.set Lchb_ID (klemml (+ (* 2 dw_w) s_trg)))
)

