; $	HT	QT(IURK)	AF(FS)		P(EZ)
; $ 	AT	QT(IU)		AF(K)			P(E)
; $	AE	V(90)			H(90)			R(0)

(defun load-modules ()
	(print "Anschluss:")
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(print "am HT-Oberflansch")
			(load "mod-endinit-uz-stzflansch-abstand")
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(print "am HT-Unterflansch")
			(load "mod-endinit-uz-stzflansch-abstand")
		) 
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(print "am HT Steg links")
			(load "mod-endinit-uz-stzsteg") 
			(load "mod-multiconnect-stz-steg")
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(print "am HT Steg rechts")
			(load "mod-endinit-uz-stzsteg")
			(load "mod-multiconnect-stz-steg")
		) 
	)
  (load "mod-lochbild")
)




(defun init-connection ()

	(setq LB_DEBUG 0)
	
	;(connect.showattributes CastaData)
	
;	(checkPosition)
	(setq isInside 1)
	
	
	(if (= isInside 1)
		(progn
			(print "in init-connection uz_an_stz mit Fahne .........................")
			(if (= (Connect.get CastaData amHtSteg) 1)
  			(init-traegerenden 10)	; hier werden die Traegerenden gestutzt
  		)
  		(if (= (Connect.get CastaData amHtFlansch) 1)
  			(init-traegerenden)	; hier werden die Traegerenden gestutzt
  		)
  		
  		(setConnection)
  		  		
  	)
  	(progn
  		(alertBox "Anschluss ist nicht mglich!"  "Connection_Not_Possible")
  	)
  )
  
    
)


(defun setConnection ()

  (setq Alternative_WklFlanschKanten 0)
	
  (if (= (Connect.get CastaData amHtSteg) 1)
	(progn
		; berprfung der Umgebung auf Anbauteile
		(setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
		(print anzAnschl)
		(if (> anzAnschl 0)
				(checkEnv)
		)
	)
  )
	
  (setq bFahnenbl 		(Blech.create))			; kommt weg
  (setq wFahnenWinkel		(Winkel.create))		;
  (setq lchbAtrgSteg		(Lochbild.create))
  (Connect.storeAnschlObjs CastaData lchbAtrgSteg wFahnenWinkel)
  
  (print "Default Winkeldaten")
  (Winkel.set wFahnenWinkel (wanz 1) (l 100) (profil "L100*8"))
  
  (setq XPos 		(Connect.get CastaData XPos_HT)
  	XPos_AT		(Connect.get CastaData XPos_AT)
  )
  (print XPos)
  
  (setq abstzumSteg 10)
  
  ; Fahnenblechdaten Berechnen
;  (calcAndSetWinkeldaten)
  
  ; Fahnenblech hinzufgen
	(addWinkelAnbauteil)

	; Lochbild HT
	(setq AbtlWinkel	(Traeger.get Htrg AbTeil wFahnenWinkel))
	(Traeger.addabtl Htrg lchbAtrgSteg XPos 180.0 _winkel_fahnenlb_  AbtlWinkel)
	
	;Lochbild AT
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn			
			(calcAndSetLochbildDaten lchbAtrgSteg TrLinks)
			(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _flanschlochbild_uf_)
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn	
			(calcAndSetLochbildDaten lchbAtrgSteg TrRechts)
			(traeger.addabtl tr_id lchbAtrgSteg XPos_AT 0.0 _flanschlochbild_uf_)
		)
	)

	(setLochbild lchbAtrgSteg)	
	
	; Bei Alternative Winkel an Flanschkanten
	(setq QS_Form_HT (Traeger.get HTrg qsForm))
	(if (= QS_Form_HT "K")
	   (progn
		(WinkelAnFlanschKanten)
	   )
	   (progn
		(if (= Alternative_WklFlanschKanten 1) 	(WinkelAnFlanschKanten))
	   )
	)

 	; CALLBACKS
	(Winkel.set wFahnenWinkel (formFkt "cb_Winkelfkt"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================
(defun cb_Winkelfkt (zp)
	(if (= zp 0) (progn
		(setq dwAlt (Winkel.get wFahnenWinkel dw))
   ))
   (if (= zp 1) (progn
		(setq dwNeu (Winkel.get wFahnenWinkel dw))
		(if (/= dwAlt dwNeu) (progn
			(setq t_AT (Traeger.get Tr_ID t))
			(Lochbild.set lchbAtrgSteg (Klemml (+ t_AT dwNeu)))
		))
   ))

)
; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------




; ------------------------------------------------------------------------
; Setzt das Fahnenblech-Anbauteil
; ------------------------------------------------------------------------
(defun addWinkelAnbauteil ()
	
	(setq XPos		(Connect.get CastaData XPos_HT))
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v))
	

; ------------------------ Winkel anbringen
  (setq rWnkWinkel 0.0)
  (if (= (Connect.get CastaData vatr-lhtr)  -1)	(setq rWnkWinkel 180.0))
  
  (if (= (Connect.get CastaData amHtOberflansch) 1) 	(traeger.addabtl hTrg wFahnenWinkel XPos rWnkWinkel _winkel_oberflansch_))
  (if (= (Connect.get CastaData amHtUnterflansch) 1) 	(traeger.addabtl hTrg wFahnenWinkel XPos rWnkWinkel _winkel_unterflansch_))
  
  ; Anschlsse am Steg des Haupttrgers
  (if (= (Connect.get CastaData amHtStegLinks) 1) 	(traeger.addabtl hTrg wFahnenWinkel XPos rWnkWinkel _winkel_steg_links_))
  (if (= (Connect.get CastaData amHtStegRechts) 1) 	(traeger.addabtl hTrg wFahnenWinkel XPos rWnkWinkel _winkel_steg_rechts_))
  
  ; Verschiebung des Winkels entlang des HT, damit er unterhalb (oberhalb eventuell) des AT
  ; angebracht wird
  (if (= (Connect.get CastaData vatr-lhtr)  -1)	(progn
  	(setq 	h_AT 	(Traeger.get Tr_ID h)
  		dv_AT	(Traeger.get Tr_ID delta_V)
  	)
  	(setq delta_v_abtl_wnkl (+ (* 0.5 h_AT) dv_AT))
  	(Winkel.set wFahnenWinkel (Achsab delta_v_abtl_wnkl))
  ))

  ; -----------------------------
	(setq	
		delta_v_htrg	(Traeger.get Htrg delta_v)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
	)
	(setq	
		delta_v_trg 	(Traeger.get Tr_ID delta_v)
		delta_lr_trg	(Traeger.get Tr_ID delta_lr)
	)
	(setq SeitVersch 0.0)
	(if (= (Connect.get CastaData amHtFlansch)  1) (progn
	    (if (= (Connect.get CastaData satr-shtr)  1)  (setq SeitVersch (- delta_lr_htrg delta_lr_trg)))
	    (if (= (Connect.get CastaData satr-shtr) -1)  (setq SeitVersch (+ delta_lr_htrg delta_lr_trg)))
	))
	(if (= (Connect.get CastaData amHtSteg)  1) (progn
	    (if (= (Connect.get CastaData satr-vhtr)  1)  (setq SeitVersch (- delta_v_htrg  delta_lr_trg)))
	    (if (= (Connect.get CastaData satr-vhtr) -1)  (setq SeitVersch (+ delta_v_htrg  delta_lr_trg)))
	))


	(Winkel.set wFahnenWinkel
		(dok 		SeitVersch)
	)
  ; -----------------------------


)




; ------------------------------------------------------------------------
; Passt die Lochbild-Anbauteile an.
; ------------------------------------------------------------------------
(defun setLochbild (LOCHB_ID)
	(print ">-----------------------------------------------------------")
	(print "LOCHBILDER WERDEN ANGEPASST")
	
	
	(setq	h_ht		(Traeger.get Htrg h)
		s_ht		(Traeger.get Htrg s)
		b_ht		(Traeger.get Htrg b)
		delta_v_ht 	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
		qsform_ht	(Traeger.get Htrg qsform)
	)
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v)
				h_at				(Traeger.get Tr_ID h)
	)
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht))
	
	(setq lb_ht_abtl (Traeger.get Htrg Abteil LOCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil LOCHB_ID))
	
	; s_ht bei Rund- und Kastenprofilen ndern!!!
	(if (= qsform_ht "K")
		(setq s_ht b_ht)
	)
	
	
	; Anbauteil HT
	; ----------------------------------------------
	
	; Positionieren (an AT)
	(setq delta_v_abtl_ht (- (* 0.5 h_at)))
	(print delta_v_abtl_ht)
	
	; Anteil delta_v AT
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at)))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_at)))
	
	
	
		
	
	; Anbauteil AT
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 h_ht) delta_v_ht)))
	(if (= (Connect.get CastaData amHtOberFlansch) 1) 	(setq delta_lr_abtl_at (- (* 0.5 h_ht) delta_v_ht)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_lr_abtl_at (- (* 0.5 s_ht) delta_lr_ht)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 s_ht) delta_lr_ht)))
	
		
	
	; TEST
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	;(setq LB_DUMMY (Lochbild.create))
	;(Lochbild.copy LB_DUMMY Lchb_ID)
	
	;(Traeger.addabtl Htrg LB_DUMMY 0.0 0.0 _WnklSteglochbildLinks_)
	;(setq AbtlKnoBlLchbAT_DUMMY    (Traeger.get Htrg AbTeil LB_DUMMY))
	;(Anbauteil.set AbtlKnoBlLchbAT_DUMMY 	(Master 1)
	;																			(delta_lr delta_lr_abtl_at)
	;																			;(delta_v 	delta_v_abtl_at)
	;)
	
	;(Connect.storeAnschlObjs CastaData LB_DUMMY)
	; +++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	(setq HT_TrgVerschiebung 0.0)
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) (setq HT_TrgVerschiebung    delta_v_ht))
	(if (= (Connect.get CastaData amHtOberFlansch)  1) (setq HT_TrgVerschiebung (- delta_v_ht)))
	(if (= (Connect.get CastaData amHtStegRechts)   1) (setq HT_TrgVerschiebung    delta_lr_ht))
	(if (= (Connect.get CastaData amHtStegLinks)    1) (setq HT_TrgVerschiebung (- delta_lr_ht)))

	(setq	wkl_Laenge  (Winkel.get 	wFahnenWinkel  l)
		AchsAbstand (Winkel.get 	wFahnenWinkel  wabst)
	)
	(if (= (Connect.get CastaData amHTSteg) 1) (setq AchsAbstand 0.0))

	

	(if (= (Connect.get CastaData LinkesEnde) 1) (progn
		(Anbauteil.set lb_at_abtl	(Winkel		 -90.0)
						(delta_V	 (* -0.5 wkl_Laenge))
						(delta_LR	 (+ AchsAbstand HT_TrgVerschiebung))
		)
	))
	(if (= (Connect.get CastaData RechtesEnde) 1) (progn
		(Anbauteil.set lb_at_abtl	(Winkel		 90.0)
						(delta_V	 (* -0.5 wkl_Laenge))
						(delta_LR	 (+ AchsAbstand HT_TrgVerschiebung))
		)
	))

	
	
	(Anbauteil.set lb_at_abtl (Master 0))
	(Anbauteil.set lb_ht_abtl (Master 1))
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy LOCHB_ID)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _WnklSteglochbildLinks_)
    	)
	    (if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy XPos_AT 0.0 _WnklSteglochbildRechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)	
																(delta_lr delta_lr_abtl_at)
		)
		)
	)
	;===================================================================
	
	(print "<-----------------------------------------------------------")
)


; ------------------------------------------------------------------------
; Besetzt die Winkeldaten
; ------------------------------------------------------------------------
(defun calcAndSetWinkeldaten ()
	(print "------------------------------------------------------------")
	(print "BERECHNE WINKELDATEN")
	
	(setq	hc_trg 		(Traeger.get Tr_ID hc)
		delta_v_trg 	(Traeger.get Tr_ID delta_v)
		delta_lr_trg	(Traeger.get Tr_ID delta_lr)
		rwnkl_trg	(Traeger.get Tr_ID r_winkel)
		tSteg 		(Traeger.get Tr_ID s)
		t_at	 	(Traeger.get Tr_ID t)
		r_at	 	(Traeger.get Tr_ID r)
		qsform		(Traeger.get Tr_ID qsform)
	)
		
	(setq	s_htrg 		(Traeger.get Htrg s)
		delta_v_htrg	(Traeger.get Htrg delta_v)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
	)
  	
	
	(setq SeitVersch 0.0)
	
	(if (= (Connect.get CastaData amHtFlansch)  1) (progn
	    (if (= (Connect.get CastaData satr-shtr)  1)  (setq SeitVersch (- delta_lr_htrg delta_lr_trg)))
	    (if (= (Connect.get CastaData satr-shtr) -1)  (setq SeitVersch (+ delta_lr_htrg delta_lr_trg)))
	))
	
  
	; WINKELDATEN:
	; -----------
	(Winkel.set wFahnenWinkel
		(Achsab 	0.0)
		(dok 		SeitVersch)
	)
	(print "------------------------------------------------------------")

	(setq	
		delta_v_htrg	(Traeger.get Htrg delta_v)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
	)
	(setq	
		delta_v_trg 	(Traeger.get Tr_ID delta_v)
		delta_lr_trg	(Traeger.get Tr_ID delta_lr)
	)
	(setq SeitVersch 0.0)
	(if (= (Connect.get CastaData amHtFlansch)  1) (progn
	    (if (= (Connect.get CastaData satr-shtr)  1)  (setq SeitVersch (- delta_lr_htrg delta_lr_trg)))
	    (if (= (Connect.get CastaData satr-shtr) -1)  (setq SeitVersch (+ delta_lr_htrg delta_lr_trg)))
	))
	(Winkel.set wFahnenWinkel
		(dok 		SeitVersch)
	)


)



; ----------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID  TrgEnde)

	(Lochbild.set Lchb_ID	(Anz_S    2)
				(S_Bez  "M12")
				(Guete   "4.6")
;				(e       "100 50 0 0 0 0")
;				(w       "0  0")
	)
	
	(setq	h_trg		(Traeger.get Tr_ID h))
	
	(setq	s_htrg		(Traeger.get Htrg s)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
		delta_v_htrg	(Traeger.get Htrg delta_v)
		h_htrg		(Traeger.get Htrg h)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l))
		
	
	
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	(print e_min)
	
	
	(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
		(print "amHtStegLinks")
	))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
		(print "amHtStegRechts")
	))
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(print "amHtUnterflansch")
	))
	(if (= (Connect.get CastaData amHtOberflansch) 1) (progn
		(print "amHtOberflansch")
	))


	
	
	; Klemmlnge
	(setq s_trg			(Traeger.get Tr_ID s))
	(setq t_trg			(Traeger.get Tr_ID t))
	(setq dw		(Winkel.get wFahnenWinkel dw))
	
	; Schraubenkopf
	
	; Lochbild-Daten - eventuell eigene Funktion einbauen
	(Lochbild.set Lchb_ID 					
				(klemml (+ dw t_trg))
				(dxSKopf dw)
	) 
	

;;	Falls ber interne Verschiebung, dann hier einbauen
	(setq abtl_LB  (Traeger.get HTrg ABTeil lchbAtrgSteg))
;;	(setq abtl_Wkl (Traeger.get HTrg ABTeil wFahnenWinkel))
	
	
	(setq SeitVersch_Wkl (Winkel.get wFahnenWinkel dok))
	(setq dv_LB (Anbauteil.get abtl_LB delta_V))
	(setq dv_LB (+ dv_LB SeitVersch_Wkl))
	(Anbauteil.set abtl_LB (delta_V dv_LB))
	
)



; ----------------------------------------------------------------------------------------
; Prft, die Position des AT in Bezug auf den HT
; ----------------------------------------------------------------------------------------
(defun checkPosition ()
	(print "------------------------------------------------------------")
	(print "BERPRFE AT POSITION")
	(print "------------------------------------------------------------")
	
	(setq	hc_ht 		(Traeger.get Htrg hc)
		b_ht		(Traeger.get Htrg b)
		delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq	delta_lr_at	(Traeger.get Tr_ID delta_lr)
		s_at		(Traeger.get Tr_ID s)
	)
	
	; Standardmig wird angenommen, dass der AT angeschlossen werden kann.
	(setq isInside 1)
	
	; Wenn der Anschluss am HT-Steg erfolgt, wird geprft, ob sich der AT-Steg im HC-Bereich des HT befindet.
	(if (= (connect.get CastaData amHtSteg) 1)
		(progn
			; obere und untere Ausrundung des HT
			(setq ausrO_ht (- delta_v_ht (* 0.5 hc_ht)))
			(setq ausrU_ht (+ ausrO_ht hc_ht))
			(print ausrO_ht)
			(print ausrU_ht)
			(print delta_lr_at)
				
			(if (= (Connect.get CastaData satr-vhtr) 1)
				(progn
					(if (> delta_lr_at ausrU_ht)
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at ausrO_ht)
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData satr-vhtr) -1)
				(progn
					(if (> delta_lr_at (- ausrO_ht))
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at (- ausrU_ht))
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			
			(if (= isInside 0)
				(print "AUSSERHALB")
				(print "INNERHALB")
			)
		)
	)
	
	; Wenn der Anschluss am HT-Flansch erfolgt, wird geprft, ob der AT-Steg noch am Flansch 
	; angeschlossen werden kann.
	(if (= (Connect.get CastaData amHtFlansch) 1)
		(progn
			; linke und rechte Seite des HT-Fansches
			(setq flansch_ht_l (- delta_lr_ht (* 0.5 b_ht)))
			(setq flansch_ht_r (+ flansch_ht_l b_ht))
			(print flansch_ht_l)
			(print flansch_ht_r)
			(print delta_lr_at)
			
			(if (= (Connect.get CastaData satr-shtr) 1)
				(progn
					(if (> delta_lr_at flansch_ht_r)
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at flansch_ht_l)
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn
					(if (> delta_lr_at (- flansch_ht_l))
						(progn
							(setq isInside 0)
						)
						(progn
							(if (< delta_lr_at (- flansch_ht_r))
								(setq isInside 0)
								(setq isInside 1)
							)
						)
					)
				)
			)
			
			(if (= isInside 0)
				(print "AUSSERHALB FLANSCH")
				(print "INNERHALB FLANSCH")
			)
		)
	)
)

; Optionale Ausfhrung
(defun WinkelAnFlanschKanten ()

  ; Seitenanschluss an Flanschkanten
  ; Sonderfall - Winkel wird an die Flanschkanten geschweit und so lang gemacht, dass er von
  ; Flanschkante zu Flanschkante reicht.
  (setq stegW_Abstand (Winkel.get wFahnenWinkel wAbst))
  (setq QS_Form_HT (Traeger.get HTrg qsForm))

  (if (= (Connect.get CastaData amHtSteg)  1) (progn
		(setq	b_HT 	(Traeger.get HTrg b)
			h_HT 	(Traeger.get HTrg h)
			dlr_HT	(Traeger.get HTrg delta_LR)
		)
		
		(setq neuStegAbstand (* 0.5 b_HT))	; Abhngig von Profilquerschnitt - U-Profile gesondert
							; aber noch nicht bercksichtigt
		(Winkel.set wFahnenWinkel
				(wAbst neuStegAbstand)
				(l	h_HT)
				(dOK	0)
		)
	; Differenz ausrechnen, die durch das Winkelverschieben entsteht
	; und bei Lochbild, und Traegerende bercksichtigen
	; Traegerende krzen
	(setq wAbst_Diff (- neuStegAbstand stegW_Abstand))
	
	(if (/= QS_Form_HT "K") (progn
	    (if (= (connect.get CastaData LinkesEnde) 1) (progn
		(setq TrgEnde (Traeger.get Tr_ID links))
		(TrEnde.ptrim TrgEnde wAbst_Diff)
		(TrEnde.set TrgEnde (bflansch 0) (xAkl 0) (yAkl 0))	; keine horizontale Ausklinkung
	    ))
	    (if (= (connect.get CastaData RechtesEnde) 1) (progn
		(setq TrgEnde (Traeger.get Tr_ID rechts))
		(TrEnde.ptrim TrgEnde wAbst_Diff)
		(TrEnde.set TrgEnde (bflansch 0) (xAkl 0)  (yAkl 0))	; keine horizontale Ausklinkung
	    ))
	))

	(setq lb_ht_abtl (Traeger.get Htrg  Abteil lchbAtrgSteg))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil lchbAtrgSteg))

	(setq alt_DLR (Anbauteil.get lb_at_abtl delta_LR))
	

	(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
		(Anbauteil.set lb_at_abtl	
			(delta_LR (- (+ wAbst_Diff alt_DLR) dlr_HT))
			(delta_LR (-  neuStegAbstand dlr_HT))
		)
		(Anbauteil.set lb_ht_abtl	
			(delta_LR (+ alt_DLR wAbst_Diff))
			(delta_LR    neuStegAbstand)
		)
	))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
		(Anbauteil.set lb_at_abtl	
			(delta_LR (+ (+ wAbst_Diff alt_DLR) dlr_HT))
			(delta_LR (+  neuStegAbstand dlr_HT))
		)
		(Anbauteil.set lb_ht_abtl	
			(delta_LR (- (+ alt_DLR wAbst_Diff)))
			(delta_LR (- neuStegAbstand))
		)
	))
	
;	(Lochbild.set lchbAtrgSteg (w0 10))
	
  ))
  
)