; $	G(1) 	HT	 QT(IU)	 	AF(S)		P(EZ)
; $ G(1)	AT	 QT(IU) 	AF(K)		P(E)
; $	G(1)	AE	 V(-)		 	H(-)		R(46-90)
; $	G(31) HT	 QT(IU)	 	AF(S)		P(EZ)
; $ G(31)	AT	 QT(IU) 	AF(K)		P(E)
; $	G(31)	AE	 V(-)		 	H(-)		R(-)
; $	HT	QT(IU)	 	AF(S)		P(EZ)
; $ AT	QT(IU) 		AF(K)		P(E)
; $	AE	V(-)		 	H(-)		R(-)

(defun load-modules ()
   (load "mod-lochbild")
)

(defun init-connection ()

  (print "in init-connection uz_an_uzCoup");
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	(setq rwinkel_at (Traeger.get Tr_ID r_winkel))
	
	(setq rwinkel_ht 	(Traeger.get Htrg r_winkel)
				qsform_ht		(Traeger.get Htrg qsform)
	)
	
	;(if (/= rwinkel_at 0.0)
	(if (/= (Connect.get CastaData vatr-lhtr) 0.0)
		(progn
			(alertBox "Bitte passen sie die relative Lage des Anschlusstrgers an die des Haupttrgers an!" "VertPos_AT_MustFit_to_HT")
		)
		(progn
			(if (= qsform_ht "U")
				(progn
					(if (= (Connect.get CastaData amHtStegLinks) 1)
						(alertBox "Der Anschluss ist an dieser Seite des Haupttrgers nicht mglich. Bitte whlen Sie einen anderen Anschluss." "ConnNotPossibleOnThisSide")
						(setConnection)
					)
				)
			)
			(if (= qsform_ht "I")
				(setConnection)
			)
		)
	)
	
)

(defun setConnection ()
	;(connect.showattributes CastaData)
	
 	(setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  (setq qsform (Traeger.get Htrg qsform))
  
  (setq blKopfplatte 	(Blech.create))
  (setq lochb					(Lochbild.create))
  (setq couponTrg 		(Traeger.create))
  (Connect.storeAnschlObjs CastaData blKopfplatte lochb couponTrg)
  
  (setq ueberstand 5.0) ; berstand des Coupons zum Schweien an HT-Flansch
  (setq dp_Kpl 10.0)
  
	; Erzeugt den Coupon
	; ---------------------------------------------
  (createCoupon Tr_ID ueberstand)
  
  
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn
			(kuerzeTraeger TrLinks ueberstand)
			(calcAndSetBlechdaten blKopfplatte TrLinks)
			(traeger.addabtl Tr_ID blKopfplatte 0.0 0.0 _kopfplattelinks_)
			(calcAndSetLochbildDaten lochb couponTrg blKopfplatte ueberstand)
			(traeger.addabtl Tr_ID lochb 0.0 0.0 _kpllochbildlinks_)
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn
			(kuerzeTraeger TrRechts ueberstand)
			(calcAndSetBlechdaten blKopfplatte TrRechts)
			(traeger.addabtl Tr_ID blKopfplatte 0.0 0.0 _kopfplatterechts_)
			(calcAndSetLochbildDaten lochb couponTrg blKopfplatte ueberstand)
			(traeger.addabtl Tr_ID lochb 0.0 0.0 _kpllochbildrechts_)
		)
	)
	
	(calcLochbild_AT) ; => delta_v_lb_at
	
	; Lochbild am HT
	(calcLochbildXPos)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)  (progn
		(traeger.addabtl HTrg lochb xPos 0.0 _couponlochbild_links_)
	))
	(if (= (Connect.get CastaData amHtStegRechts) 1)  (progn
		(traeger.addabtl HTrg lochb xPos 0.0 _couponlochbild_rechts_)
	)) 

	  (if (= 2 3) (progn
		;; Testen - AF-20090513
		(Lochbild.set lochb (LB_Art   2))		; AF-20090512
		(Lochbild.set lochb (delta_w  50))		; AF-20090512
		(Lochbild.set lochb (e    "0 30 100 0 0 0"))	; AF-20090512
		(Lochbild.set lochb (w    "23 40"))		; AF-20090512
	  ))


	
	; Wenn der Anschluss an HT-Ende stattfindet
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			(setq bp_blech (Blech.get blKopfplatte bp))
			(if (= (Connect.get CastaData anhtlinkesEnde) 1)
				(progn
					(setq HTLinks 	(Traeger.get Htrg Links))
					(korrTraegerEnde HTLinks bp_blech couponTrg)
				)
			)
			(if (= (Connect.get CastaData anhtrechtesEnde) 1)
				(progn
					(setq HTRechts	(Traeger.get Htrg Rechts))
					(korrTraegerEnde HTRechts bp_blech couponTrg)
				)
			)			
		)
	)
		
	(setq Abtl_KplLchb_ht (traeger.get Htrg ABTeil lochb))
  	(Anbauteil.set Abtl_KplLchb_ht (Master 1))
  	(setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil lochb))
  	(Anbauteil.set Abtl_KplLchb_at 	(Master 0)
  					 (delta_v delta_v_lb_at)
  	)
  

  
  ; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lochb)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
    			)
	    		(if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
	    		)
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl 	(Master 1)	
							(delta_v delta_v_lb_at)
			)
		)
	)
	;===================================================================
  
  ; CALLBACKS
  (Traeger.set couponTrg 	(formFkt "cb_couponTrg"))
  (Blech.set blKopfplatte (formFkt "cb_blKopfplatte")) 

)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Coupon-Profil wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_couponTrg (zp)
	(print "in Callback-Funktion cb_couponTrg")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (objExist Tr_ID) 
		(print "OK")
		(setq zp 100)	; damit hier nicht weiter ausgewertet wird
	)
	
	(if (= zp 0) (progn
	    (setq t_alt (Traeger.get couponTrg t))
		(setq h_Alt (Traeger.get couponTrg h))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq t_neu (Traeger.get couponTrg t))
		(setq h_Neu (Traeger.get couponTrg h))
		(setq trgLngAendern 0)
		(if (/= h_Neu h_Alt) (progn
			(setq hDiff (- h_Neu h_Alt))
		    (trgLngAnpassen hDiff)
			
			(setq dlrCpLchb_Alt (Lochbild.get lochb dlr_Coupon))
			(setq dlrCpLchb_Neu (+ dlrCpLchb_Alt hDiff))
			(Lochbild.set lochb (dlr_Coupon dlrCpLchb_Neu))
		))
			
	    
	    (print t_alt) (print t_neu)
	    
	    (if (/= t_alt t_neu) (progn
	       (setq tDiff (- t_neu t_alt))
	       (setq alteKlemml (Lochbild.get lochb Klemml))
	       ;(setq altesDxS		(Lochbild.get lchbKpl dxsKopf))
	       
	       (Lochbild.set lochb 	(Klemml (+ alteKlemml tDiff))
	       												;(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
)
(defun trgLngAnpassen (lngDiff)
	(if (objExist Tr_ID) (progn
		(print "Traeger exisitiert")
		(if (= (Connect.get CastaData linkesEnde) 1) (progn
			(setq tEnd (Traeger.get Tr_ID links))
			(TrEnde.ptrim tEnd lngDiff)
		))
		(if (= (Connect.get CastaData rechtesEnde) 1) (progn
			(setq tEnd (Traeger.get Tr_ID rechts))
			(TrEnde.ptrim tEnd lngDiff)
		))
	))

)


; ----------------------------------------------------------------------------------------
; Kopfplatte wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_blKopfplatte (zp)
	(print "CALLBACK: cb_blKopfplatte")
	(print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_alt (Blech.get blKopfplatte dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_neu (Blech.get blKopfplatte dp))
	    
	    (print dp_alt) (print dp_neu)
	    
	    (if (/= dp_alt dp_neu) (progn
	       (setq dpDiff (- dp_neu dp_alt))
	       (setq alteKlemml (Lochbild.get lochb Klemml))
	       (setq altesDxS		(Lochbild.get lochb dxsKopf))
	       
	       (Lochbild.set lochb 	(Klemml (+ alteKlemml dpDiff))
	       											(DxSKopf (+ altesDxS dpDiff))
	       )
				 
				 ; LB verschieben
				 (cbDeltaLR lochb couponTrg dpDiff)
	    ))
	))
)

; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB COUPON DP_DIFF)
	(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteile des HT-LB
	(setq ht_lb_abtl 			(Traeger.get Htrg Abteil KPL_LB))
	(setq ht_coupon_abtl 	(Traeger.get Htrg Abteil COUPON))
	
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl 		(delta_lr delta_lr_abtl_neu))
	(Anbauteil.set ht_coupon_abtl	(delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)



; ---------------------------------------------------------------------
; krzt den Anschlusstrger
; ---------------------------------------------------------------------
(defun kuerzeTraeger (TrgEnde ueberstand)
	(print ">------------------------------------------------------------------------------")
	(print "KRZE TRGER")

	; HT Daten
	; ----------------------------------------------
	(setq b_htrg 			(Traeger.get Htrg b)
				s_htrg			(Traeger.get Htrg s)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				qsform			(Traeger.get Htrg qsform)
	)
	
	; AT Daten
	; ----------------------------------------------
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(TrEnde.set TrgEnde (delta_l 0.0))
	
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(setq delta_l (+ (+ (* 0.5 b_htrg) ueberstand) delta_lr_ht))
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq delta_l (- (+ (* 0.5 b_htrg) ueberstand) delta_lr_ht))
	)
	
	(if (= qsform "U")
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq delta_l (+ (+ b_htrg ueberstand) delta_lr_ht))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq delta_l (-  delta_lr_ht))
			)
		)
	)
	
	(print delta_l)
	
	; horizontaler Winkel am AT
	; ---------------------------------------------
	(setq h_Wnkl (Connect.get CastaData afl_hwinkel))
	(print h_Wnkl)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq h_Wnkl (- 180.0 h_Wnkl))
	)
	
	
	; Anteil aus der Verschiebung delta_lr des AT
	; ---------------------------------------------
	(setq cosW (cos (/ (* PI h_wnkl) 180.0)))
	(setq delta_lt_at_trim (* delta_lr_at cosW))
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= r_winkel_at   0.0)	(setq delta_l (- delta_l delta_lt_at_trim)))
			(if (= r_winkel_at 180.0)	(setq delta_l (+ delta_l delta_lt_at_trim)))
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= r_winkel_at   0.0) 	(setq delta_l (+ delta_l delta_lt_at_trim)))
			(if (= r_winkel_at 180.0) 	(setq delta_l (- delta_l delta_lt_at_trim)))
		)
	)
	
	(if (= r_winkel_at 180.0) 	(setq h_Wnkl (- h_Wnkl))) 
	
	(print delta_l)
	
	; Bercksichtigung eines vert. Neigungswinkels
	; --------------------------------------------
	(print "vert. Neigung")
	(print "---------------------------------------")
	(setq v_Wnkl 90.0)
	
	(setq v_rotaW (Connect.get CastaData at_rotawinkel))
	(print v_rotaW)
	
	(if (< v_rotaW 180.0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq v_Wnkl v_rotaW))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq v_Wnkl v_rotaW))
		)
	)
	(if (> v_rotaW 180.0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq v_Wnkl (+ (- 270.0 v_rotaW) v_Wnkl)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq v_Wnkl (+ (- 270.0 v_rotaW) v_Wnkl)))
		)
	)
	(print v_Wnkl)
	
	(if (>= v_Wnkl 90.0)
		(setq vWnkl_help (- v_Wnkl 90.0))
		(setq vWnkl_help (- 90.0 v_Wnkl))
	)
	(print vWnkl_help)
	
	; Anteil delta_l aus Neigung
	(setq h_at (Traeger.get Tr_ID h))
	(setq h_at_halb (* 0.5 h_at))
	
	(setq sinRota (sin (/ (* PI vWnkl_help) 180.0)))
	(setq tanRota (tan (/ (* PI vWnkl_help) 180.0)))
	(print sinRota)
	(print tanRota)
		
	(setq anteil_delta_v_at (* delta_v_at sinRota))
	(print anteil_delta_v_at)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
	(if (= (Connect.get CastaData amHtStegLinks)  1)	
		(if (>= v_Wnkl 90.0)	
			(setq delta_l (+ delta_l  anteil_delta_v_at))
			(setq delta_l (- delta_l  anteil_delta_v_at))
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)	
		(if (>= v_Wnkl 90.0)	
			(setq delta_l (+ delta_l  anteil_delta_v_at))
			(setq delta_l (- delta_l  anteil_delta_v_at))
		)
	)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData amHtStegLinks)  1)	
				(if (>= v_Wnkl 90.0)	
					(setq delta_l (- delta_l  anteil_delta_v_at))
					(setq delta_l (+ delta_l  anteil_delta_v_at))
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)	
				(if (>= v_Wnkl 90.0)	
					(setq delta_l (- delta_l  anteil_delta_v_at))
					(setq delta_l (+ delta_l  anteil_delta_v_at))
				)
			)
		)
	)
	(print delta_l)
	
	
	(TrEnde.set TrgEnde (h_winkel 	h_Wnkl)
											(v_winkel 	v_Wnkl)
	)
	
	(TrEnde.ptrim TrgEnde delta_l)
	
	(print "<------------------------------------------------------------------------------")
)





; ----------------------------------------------------------------------------------------
; Berechnet die Blechdaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)

  (print "----------------------------- In calcAndSetBlechdaten")
	(setq h_trg (Traeger.get Tr_ID h)
				t_trg (Traeger.get Tr_ID t)
				b_trg	(Traeger.get Tr_ID b)
	)
	
	(calcUnterschied)
		
	;(if (>= diff_oben 0.0)
	;	(progn
	;		(if (<= diff_unten 0.0)
	;			(progn
	;				(setq dOK (* 0.5 t_trg))
	;				(setq hp_kpl (- h_trg t_trg ))
	;			)
	;			(progn
	;				(setq dOK (* 0.5 t_trg))
	;				(setq hp_kpl (- (- h_trg t_trg ) diff_unten))
	;			)
	;		)			
	;	)
	;	(progn
	;		(if (<= diff_unten 0.0)
	;			(progn
	;				(setq dOK (- (* 0.5 t_trg) diff_oben))
	;				(setq hp_kpl (+ (- h_trg t_trg ) diff_oben))
	;			)
	;		)
	;	)
	;)
	      
	(setq bp b_trg)
	
	; dok
	(setq t_halb (* 0.5 t_trg))
	;(setq dok (runde t_halb auf 5.0))
	(setq dok t_halb)
	
	(setq vscherl_at (TrEnde.get TrgEnde vscherl))
	
	(setq hp (- vscherl_at dok dok))
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp dp_Kpl) 
													(hp hp) 
													(bp bp) 
													(dOK dOK)
	)
	
	(TrEnde.pTrim TrgEnde dp_Kpl)
)


; ---------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ---------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID Coupon KopfPl ueberstand)
	(print "--------------------------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID (Anz_S 		2)
												(Guete   	"4.6")
	)
	
	; Allg. Daten
	(setq t_Coup 	(Traeger.get Coupon t)
				h_Coup 	(Traeger.get Coupon h)
				b_Coup 	(Traeger.get Coupon b)
				s_Coup	(Traeger.get Coupon s)
				r_Coup	(Traeger.get Coupon r)
				l_Coup	(traeger.get Coupon laenge)
	)
	
	(setq s_Htrg			(Traeger.get Htrg s)
				h_Htrg			(Traeger.get Htrg h)
				b_Htrg			(Traeger.get Htrg b)
				delta_v_ht	(Traeger.get Htrg delta_v)
				delta_lt_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq h_trg				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq dp_kpl	(Blech.get KopfPl dp)
				hp_kpl	(Blech.get KopfPl hp)
				dok_kpl	(Blech.get KopfPl dok)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq vscherl_at (TrEnde.get AtEnde vscherl))
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	
	(print vWnkl_help)
	
	(setq sinRota (sin (/ (* PI vWnkl_help) 180.0)))
	(setq tanRota (tan (/ (* PI vWnkl_help) 180.0)))
	(setq cosRota (cos (/ (* PI vWnkl_help) 180.0)))
	(print sinRota)
	(print tanRota)
	(print cosRota)
	
	(setq anteil_delta_v_at (* (* 1.0 delta_v_at) cosRota))
	(print anteil_delta_v_at)
	
	; Differenz zwischen Flanschkanten AT und HT 
	(setq diff_AT_HT (+ (- (* 0.5 h_Htrg) vscherl_at_halb) anteil_delta_v_at (- delta_v_ht)))
	(print diff_AT_HT)
	
	; Setzen der Schraubenbezeichnung
	(set_S_Bez Tr_ID Lchb_ID)
	
	; Anzahl der Schrauben
	;(calc_Anz_Schr Lchb_ID Tr_ID)
	(setq hc_trg (Traeger.get Tr_ID hc))
	(print hc_trg)
	(calcMinRandLochAbst Lchb_ID)
	
		
	(if (> min_h verfuegbarer_LB_bereich)
		(progn
			(print "2 Schrauben")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq anz_schr 2)
		)
		(progn
			(print "4 Schrauben")
			(Lochbild.set Lchb_ID (Anz_S 4))
			(setq anz_schr 4)
		)
	)
	
	; Berechnung w0
	(setq r_s_r_Coup (+ s_Coup (* 2.0 r_Coup)))
	
	(setq w0_help (* (- b_Coup r_s_r_Coup) 0.5))
	(setq w0 (+ w0_help r_s_r_Coup))
	
	
	; Berechnung e0, e1
	(if (= anz_schr 4)
		(progn
			(if (> diff_oben 0.0)
				(setq e0 (+ (* 0.25 verfuegbarer_LB_bereich) diff_oben))
				(setq e0 (* 0.25 verfuegbarer_LB_bereich))
			)
			(setq e0_rund (runde e0 auf 5.0))
			(if (> diff_oben 0.0)
				(setq e1 (* 0.5 verfuegbarer_LB_bereich))
				(setq e1 (* 0.5 verfuegbarer_LB_bereich))
			)
			(setq e1_rund (runde e1 auf 5.0))
		)
	)
	(if (= anz_schr 2)
		(progn
			(if (> diff_oben 0.0)
				(setq e0 (+ (* 0.5 verfuegbarer_LB_bereich) diff_oben))
				(setq e0 (* 0.5 verfuegbarer_LB_bereich))
			)
			(setq e0_rund (runde e0 auf 5.0))
			(setq e1_rund 0.0)
		)
	)
	
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(setq dlr_Coup (- (+ h_Coup (* 0.5 s_Htrg))))
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(setq dlr_Coup (+ h_Coup (* 0.5 s_Htrg)))
		)
	)
	
	;dxSKopf
	(setq dxskopf dp_kpl)
 	
	
	(Lochbild.set Lchb_ID (dlr_Coupon 	dlr_Coup)
												(dxskopf   		dxskopf)
												(klemml 			(+ t_Coup dp_kpl))
												(w0 					w0)
												(e0						e0_rund)
												(e1						e1_rund)
	)
	
	
	
	
			
	(print "--------------------------------------------------------------------------------")
)


; ---------------------------------------------------------------------------------
; Korregiert das Traegerende des HT, wenn Anschluss am HT-Ende
; ---------------------------------------------------------------------------------
(defun korrTraegerEnde (TrgEnde bp Coupon)
	(print "KORREGIERE HT-ENDE ...")
	
	(setq afl_winkel (Connect.get CastaData afl_hwinkel))
	(print afl_winkel)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq hscherl_at (TrEnde.get AtEnde hscherl))
	
	(setq hscherl_halb (* 0.5 hscherl_at))
		
	(setq b_ht_halb (* 0.5 b_ht))
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	(print tanafl)
	(if (< tanAfl 0.0)	(setq tanAfl (- tanAfl)))
	(print tanafl)
	
	(setq verl_1 (/ b_ht_halb tanafl))
	(print verl_1)
	
	(setq delta_l_ht (+ verl_1 hscherl_halb))
	(print delta_l_ht)
	
	(TrEnde.set TrgEnde (delta_l (- delta_l_ht)))
	
	(print "KORREKTUR FERTIG")
)
; ====================================================================== 


;***************************************************************************
; Erzeugt Coupon am HT
;***************************************************************************
(defun createCoupon (Tr_ID ueberstand)
	(print "______________________")
	(print "IN createCoupon")
	
	;Schnittpunkt
	(setq xSP (connect.get CastaData xsp)
				ySP (connect.get CastaData ysp)
				zSP (connect.get CastaData zsp)
	)
	(print xsp)
	(print ysp)
	(print zsp)
	
	;Daten des AT
	(setq at_Breite 	(Traeger.get Tr_ID b))
	(print at_Breite)
	
	;Daten des HT
	(setq ht_hoehe 		(Traeger.get HTrg h)
				ht_steg			(Traeger.get HTrg s)
				t_htrg			(Traeger.get Htrg t)
				ht_breite		(Traeger.get HTrg b)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				hWnkl				(Traeger.get HTrg hpttrg_vwinkel)
				qsform			(Traeger.get Htrg qsform)			
	)
	(print ht_hoehe)
	(print hWnkl)
	
	;Daten der Steife
	(setq steife_b (* 0.5 (- ht_breite ht_steg)))
	(print steife_b)
	
	(setq sp ysp)
	
	(setq xpos1 sp)
	
; ---- mal rausgenommen um erst einmal den Copon mit Profil einbzubauen	
;	(setq blSteife1 (blech.create))
;	(Blech.set blSteife1 (dp 10) (hp ht_hoehe) (bp steife_b) )
;	(traeger.addabtl HTrg blSteife1 0.0 0.0 _vollsteife_rechts_)
;	(setq AbtlSteife_1 (traeger.get HTrg ABTeil blSteife1))
;	(Anbauteil.set  AbtlSteife_1 (xpos xpos1) )
	
	; Coupon an den Haupttrger anbauen
  (print "---------------------------------------- Coupon neu - hier einbauen!")
  ; syslng - maximal Abstand zwischen den Flanschen
  ; delta_L am linken Trgerende - Abstand von oben - also meist Flanschdicke
  ; h - Abstand Stegflche zur Schraubenflche (Oberflansch des Coupons)
 	
 	
	(setq coup_l	(- ht_hoehe t_htrg ))
	
	(if (= qsform "U")
		(setq coup_h	(- ht_breite ht_steg))
		(setq coup_h	(* 0.5 (- ht_breite ht_steg)))
 	)
 	
 	(setq prof 					(Traeger.get Tr_ID Profil)
 				delta_lr_trg	(Traeger.get Tr_ID delta_lr)
 				r_wnkl_trg		(Traeger.get Tr_ID r_winkel)
 	)
 	(print prof)
 	;Berechnung der XPos
 	(setq xpos (Connect.get CastaData xpos_ht))
 	(print xpos)
 	 	(setq h_wnkl (Connect.get CastaData afl_hwinkel))
 	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq h_Wnkl (- 180.0 h_Wnkl))
	)
	(print h_Wnkl)
	(setq tanW (tan (/ (* PI h_wnkl) 180.0)))
	(setq sinW (sin (/ (* PI h_wnkl) 180.0)))
	(print sinW)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(setq delta (+ (* 0.5 ht_breite) ueberstand dp_Kpl delta_lr_ht))
			(setq xpos (+ xpos (/ delta tanW)))
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(setq delta (+ (* 0.5 ht_breite) ueberstand dp_Kpl (- delta_lr_ht)))
			(setq xpos (- xpos (/ delta tanW)))
		)
	)
 	(print xpos)
 	(setq versch_aus_delta_lr_trg (/ delta_lr_trg sinW))
 	(print versch_aus_delta_lr_trg)
 	
 	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq xpos (- xpos versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq xpos (+ xpos versch_aus_delta_lr_trg)))
		 		)
		 	)
		 	(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq xpos (+ xpos versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq xpos (- xpos versch_aus_delta_lr_trg)))
		 		)
		 	)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq xpos (+ xpos versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq xpos (- xpos versch_aus_delta_lr_trg)))
		 		)
		 	)
		 	(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq xpos (- xpos versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq xpos (+ xpos versch_aus_delta_lr_trg)))
		 		)
		 	)
		)
	)
 	(print xpos)
 	;(setq xPos (- xPos versch_aus_delta_lr_at))
 	; TODO
 	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 	; Wenn der Coupon aus einen Trgerprofil erstellt wird, knnen die Abmessungen
 	; nicht frei whlbar sein, da sie vom Profil anhngen.
 	; Wird hier allerdings erstmal ignoriert!
 	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 	(Traeger.set couponTrg (Profil prof)
                         (syslng coup_l)
                         (h      (+ coup_h ueberstand))
  )
  
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Traeger.set couponTrg (delta_v (+ (* 0.5 ht_steg) 0.0)))			; delta_lr_ht entfernt (Mai 2009 AF)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= qsform "U")
				(Traeger.set couponTrg (delta_v (+ ht_steg 0.0)))		; delta_lr_ht entfernt (Mai 2009 AF)
				(Traeger.set couponTrg (delta_v (+ (* 0.5 ht_steg) 0.0)))	; delta_lr_ht entfernt (Mai 2009 AF)
			)
		)
	)
	
	
  (setq cpELinks (Traeger.get couponTrg links))
  (TrEnde.set cpELinks 	(delta_L t_htrg))
  
  
  
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)  
	      (traeger.addabtl hTrg couponTrg xpos 0.0 _couponprofil_links_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)  
	      (traeger.addabtl hTrg couponTrg xpos 0.0 _couponprofil_rechts_)
	)
	
	
	(Traeger.updvollstf HTrg)
)

; --------------------------------------------------------------------
; BERECHNET DIE XPOSITION DES LOCHBILDS AM HT
; --------------------------------------------------------------------
(defun calcLochbildXPos ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE XPOS LOCHBILD")
	(setq xPos (Connect.get CastaData xPos_ht))
	
	(setq delta_lr_ht 	(Traeger.get Htrg delta_lr))
	(setq delta_lr_trg 	(Traeger.get Tr_ID delta_lr))
	
	(print xPos)
	
	(setq h_wnkl (Connect.get CastaData afl_hwinkel))
 	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq h_Wnkl (- 180.0 h_Wnkl))
	)
	(setq tanW (tan (/ (* PI h_wnkl) 180.0)))
	(setq sinW (sin (/ (* PI h_wnkl) 180.0)))
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(setq delta (+ (* 0.5 b_Htrg) ueberstand dp_Kpl delta_lr_ht))
			(setq delta_w (/ delta tanW))
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(setq delta (+ (* 0.5 b_Htrg) ueberstand dp_Kpl (- delta_lr_ht)))
			(setq delta_w (- (/ delta tanW)))
		)
	)
	
	(setq versch_aus_delta_lr_trg (/ delta_lr_trg sinW))
 	(print versch_aus_delta_lr_trg)
 	
 	(if (= (Connect.get CastaData amHtStegRechts) 1)
 		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq delta_w (- delta_w versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq delta_w (+ delta_w versch_aus_delta_lr_trg)))
		 		)
		 	)
		 	(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq delta_w (+ delta_w versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq delta_w (- delta_w versch_aus_delta_lr_trg)))
		 		)
		 	)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
 		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq delta_w (+ delta_w versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq delta_w (- delta_w versch_aus_delta_lr_trg)))
		 		)
		 	)
		 	(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq delta_w (- delta_w versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq delta_w (+ delta_w versch_aus_delta_lr_trg)))
		 		)
		 	)
		)
	)
	
	(setq xPos (+ xPos delta_w))
	
	(print "<-----------------------------------------------------------")
)

; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE TRG DIFFERENZEN")
	(setq h_ht				(Traeger.get Htrg h)
				t_ht				(Traeger.get Htrg t)
				b_ht				(Traeger.get Htrg b)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				t_at				(Traeger.get Tr_ID t)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq vscherl_at (TrEnde.get AtEnde vscherl))
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	
	(print vWnkl_help)
	
	(setq sinRota (sin (/ (* PI vWnkl_help) 180.0)))
	(setq tanRota (tan (/ (* PI vWnkl_help) 180.0)))
	(setq cosRota (cos (/ (* PI vWnkl_help) 180.0)))
	(print sinRota)
	(print tanRota)
	(print cosRota)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- (* 1.0 delta_v_ht) h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))											(print uKante_ht)
	
	; Anteil delta_v AT
	(print delta_v_at)
	;(setq anteil_delta_v (* (* 1.0 delta_v_at) cosRota))
	(if (/= cosRota 0.0)
		(setq anteil_delta_v (/ (* 1.0 delta_v_at) cosRota))
		(setq anteil_delta_v (* 1.0 delta_v_at))
	)
	(print anteil_delta_v)
	
	(setq delta_v_at_anteil anteil_delta_v)
	(print delta_v_at_anteil)
	
	(setq oKante_at	(- delta_v_at_anteil vscherl_at_halb))				
	(print oKante_at)
	
	; zustzl. Anteil aus AT-Neigung
	(setq b_ht (Traeger.get Htrg b))
	(setq ht_anteil (+ ueberstand (* 0.5 b_ht)))
	
	(print tanRota)
	
	(if (< v_Wnkl 90.0)	
		(setq anteil_neigung (- (* ht_anteil tanRota)))
		(setq anteil_neigung (* ht_anteil tanRota))
	)
	(print anteil_neigung)
	
	(setq oKante_at (+ oKante_at anteil_neigung)) 								(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))											(print uKante_at)
	
	
	(setq diff_oben (- oKante_at oKante_ht))
	(setq diff_unten (- uKante_at uKante_ht))
	
	(print diff_oben)
	(print diff_unten)

	(setq verfuegbarer_LB_bereich h_at)
	(if (> diff_oben 0.0)
		(progn
			(if (< diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_at (* 2.0 t_at))))
			(if (= diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_at t_at t_ht)))
			(if (> diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- (- uKante_ht oKante_at) t_ht t_at)))
		)
	)
	(if (< diff_oben 0.0)
		(progn
			(if (<  diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- (- uKante_at oKante_ht) t_ht t_at)))
			(if (>= diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_ht (* 2.0 t_ht))))
		)
	)
	(if (= diff_oben 0.0)
		(progn
			(if (<  diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_at t_at t_ht)))
			(if (>= diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_ht t_ht t_at)))
		)
	)
	(print verfuegbarer_LB_bereich)
	(print "<-------------------------------------------------------------------------------")
)






(defun calcLochbild_AT ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE LOCHBILD AM AT")
	
	;Lochbildkorrektur am AT
	(setq delta_v_lb_at	0.0)
	(print diff_oben)
	
	(if (= 1 1)	(progn
		(setq delta_v_lb_at	(- delta_v_lb_at (* 1.0 diff_oben)))
	))
	(print delta_v_lb_at)
		
	
	(print "<-------------------------------------------------------------------------------")
)