

; ****************************************************************************************
; Erzeugt die Verbindung
; ****************************************************************************************
(defun setConnection ()
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGE VERBINDUNG (DM)")

	; Lochbild im HT anpassen aus 3D-Geometrie
	(connect.set CastaData (htmodify 1))
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
		
	(setq ueberstand 5.0) ; berstand des Coupons zum Schweien an HT-Flansch
	
	
	; die folgenden zwei Bleche u. das Lochbild 
	; werden auf jedenfall erzeugt
	; ---------------------------------------------
	(setq atKpl					(Blech.Create))
	(setq cpFrontBlech 	(Blech.Create))
	(setq cplchb				(Lochbild.Create))
	
	(Connect.storeAnschlObjs CastaData atKpl cpFrontBlech cplchb)
	
	; Variante ohne Gurtblech
	(if (= COUPON_TYPE 1)
		(progn
			(setq cpStegBlech 	(Blech.Create))
			(Connect.storeAnschlObjs CastaData cpStegBlech)
		)
	)
	
	; Variante mit Steg- und Gurtblech
	(if (= COUPON_TYPE 2)
		(progn
			(setq cpStegBlech 	(Blech.Create))
			(setq cpFlaBlech  	(Blech.Create))
			(Connect.storeAnschlObjs CastaData cpStegBlech cpFlaBlech)
		)
	)
	
	; Abstand der Flansche bzw. Trgerkanten berechnen
	; ----------------------------------------------
	(calcUnterschied) ; --> diff_oben
	
	; Winkel des AT-Endes berechnen
	; ----------------------------------------------
	(berechneATEndeWnkl)
	
	; Berechnen u. Setzen der Blechdicken
	; ----------------------------------------------
	(calcBlechdicken atKpl cpFrontBlech)
	
	; Berechnen u. Setzen der LB-Bezeichnung
	; ----------------------------------------------
	(setLchbBez atKpl cpFrontBlech cplchb)
	
	; Rand- u. Lochabstnde
	; ----------------------------------------------
	(calcMinRandLochAbst cplchb) 	; -> min_h (minimale Blechhhe aus e0/e1)
																; -> e_min_rund
																; -> e1_min_rund

	; Berechnen der AT-Kopfplatte
	; ----------------------------------------------
	(calcAtKpl atKpl)
	
	
	; Berechnung des Gurtbleches, wenn vorhanden
	; ----------------------------------------------
	(if (= COUPON_TYPE 2)	(calcGurtBlech cpFlaBlech))
		
	; Berechnung des Stegbleches
	; ----------------------------------------------
	(if (= COUPON_TYPE 1)	(calcStegBlech cpStegBlech))
	(if (= COUPON_TYPE 2)	(calcStegBlechMitGurt cpStegBlech cpFlaBlech diff_oben))
	
	; Berechnung der Frontplatte
	; ----------------------------------------------
	(calcFrontBlech cpFrontBlech atKpl diff_oben)
	
	
	; Erzeugen der AT-Kopfplatte
	; ----------------------------------------------
	(createAtKpl atKpl)
		
	; Krzen des AT-Endes
	; ----------------------------------------------
	(kuerzeATEnde)
	
	; Erzeugen der Couponbleche
	; ----------------------------------------------
	(createCouponBleche)
	
	; Berechnen des KopfplattenLB
	; ----------------------------------------------
	(calcLchb cpFrontBlech atKpl cplchb)
	; Erzeugen der Lochbilder
	; ----------------------------------------------
	(createLochbilder cplchb atKpl)
	
	
	
	
	; Callback-Funktionen
	; ----------------------------------------------
	(Blech.set atKpl (formFkt "cb_atKpl")) 
	(Blech.set cpFrontBlech (formFkt "cb_cpFrontBlech"))
	;(Blech.set cpStegBlech (formfkt "cb_cpStegBlech"))
	(print "<-------------------------------------------------------------------------------")
)


; ****************************************************************************************
; Berechnet die Blechdicken fr die Anschlussplatte und die Kopfplatte am AT
; ****************************************************************************************
(defun calcBlechdicken (KPL_ID AP_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE BLECHDICKEN")
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq kpl_dp (runde t_at auf 5.0))
	(print kpl_dp)
	
	(setq ap_dp (runde t_at auf 5.0))
	(print ap_dp)
	
	
	(Blech.set KPL_ID (dp 	kpl_dp))
	(Blech.set AP_ID 	(dp 	ap_dp))
	(print "<-------------------------------------------------------------------------------")
) 

; ****************************************************************************************
; Setzt die LB-Bezeichnung (Schraubengre)
; ****************************************************************************************
(defun setLchbBez (KPL_ID AP_ID LCHB_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "SETZE BLECHDICKEN")
	
	(setq coupBlech_dp 	(Blech.get AP_ID dp))
	(setq atBlech_dp 		(Blech.get KPL_ID dp))
	
	(setq minBl_dp 0.0)
	
	(if (< coupBlech_dp atBlech_dp)
		(setq minBl_dp coupBlech_dp)
		(setq minBl_dp atBlech_dp)
	)
	
	(calcSchraube minBl_dp) ;--> S_Bez
	
	(Lochbild.set LCHB_ID (S_Bez S_Bez))
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet die Daten der Frontplatte
; ****************************************************************************************
(defun calcFrontBlech (BLECH_ID KPL_ID DIFF)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE FRONTBLECH")
	
	; HHE
	; ---------------------------------------------
	(setq delta_v_ht	(Traeger.get Htrg delta_v)
				t_ht				(Traeger.get Htrg t)
				h_ht				(Traeger.get Htrg h)
	)
	
	(setq h_at				(Traeger.get Tr_ID h)
				t_at				(Traeger.get Tr_ID t)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	; maximale Hhe
	(setq max_hp	(- h_ht t_ht))
	(setq cpFront_hp max_hp)
	
	(if (= COUPON_TYPE 2)
		(progn
			;(setq cpFront_hp (- (+ h_at DIFF) (* 0.5 t_at) (* 0.5 t_ht)))
			(setq cpFront_hp (+ cpSteg_hp (* 0.5 t_ht) (* 0.5 cp_gurt_dp)))
	
			(if (> cpFront_hp max_hp)
				(setq cpFront_hp max_hp)
			)
		)
	)
	(setq cpFront_hp_rund (runde cpFront_hp auf 5.0))
	
	; BREITE
	; ---------------------------------------------
	(print "ANSCHLUSSPLATTE - BREITE:")
	(setq h_scherl_at 	(TrEnde.get At_Ende hscherl))
	(setq h_scherl_at_rund (runde h_scherl_at auf 5.0))
		
	(setq h_at 			(Traeger.get Tr_ID h)
				b_at			(Traeger.get Tr_ID b)
	)
	(setq r_wnkl_at	(Connect.get CastaData r-atrgewnkl_steg))
	(print r_wnkl_at)
	
	(setq tanW (tan (/ (* PI r_wnkl_at) 180.0)))
	(setq sinW (sin (/ (* PI r_wnkl_at) 180.0)))
	(setq cosW (cos (/ (* PI r_wnkl_at) 180.0)))
	(print tanW)
	(print sinW)
	(print cosW)
	
	(setq h_at_halb (* 0.5 h_at))
	(setq b_at_halb (* 0.5 b_at))
	
	(setq aTan_wnkl_bogen (atan (/ b_at_halb h_at_halb)))
	(print aTan_wnkl_bogen)
	(setq wnkl (/ (* 180.0 aTan_wnkl_bogen) PI))
	(print wnkl)
	
	(if (> r_wnkl_at 90.0)	
		(setq rest_wnkl (- 180.0 (+ r_wnkl_at wnkl)))	
		(setq rest_wnkl (- r_wnkl_at wnkl))	
	)
	
	(print rest_wnkl)
	
	(setq cosWnkl (cos (/ (* PI rest_wnkl) 180.0))) 
	
	(setq fp_diag_halb (sqrt (+ (* h_at_halb h_at_halb) (* b_at_halb b_at_halb))))
	(print fp_diag_halb)
	
	(setq b_fp_halb (* cosWnkl fp_diag_halb))
	(print b_fp_halb)
	
	(setq b_fp (* 2.0 b_fp_halb))
	(print b_fp)
	
	(setq b_fp_rund (runde b_fp auf 5.0))
	(print b_fp_rund)
	(print h_scherl_at_rund)
	(if (> b_fp_rund  h_scherl_at_rund)
		(setq cpFront_bp b_fp_rund)
		(setq cpFront_bp h_scherl_at_rund)
	)
	
	
	(setq kpl_bp (Blech.get KPL_ID bp))
	
	(if (< cpFront_bp kpl_bp)	(setq cpFront_bp kpl_bp))
	
	(print cpFront_bp)
	
	; DICKE
	; ---------------------------------------------
	(setq t_at	(Traeger.get Tr_ID t))
	
	(setq cpFront_dp (runde t_at auf 5.0))
	
	; DOK
	; ---------------------------------------------
	(setq t_ht	(Traeger.get Htrg t))
	
	(setq cpFront_dok (* 0.5 t_ht))
	
	
	(print cpFront_hp)
	(print cpFront_bp)
	(print cpFront_dp)
	(print cpFront_dok)
	
	
	; Werte setzen
	; ---------------------------------------------
	(Blech.set BLECH_ID (hp		cpFront_hp_rund)
											(bp		cpFront_bp)
											(dp		cpFront_dp)
											(dok	cpFront_dok)
	)
		
	
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet die Daten des Stegbleches
; ****************************************************************************************
(defun calcStegBlech (BLECH_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE STEGBLECH")
	
	; HOEHE
	; ---------------------------------------------
	(setq h_at	(Traeger.get Tr_ID h)
				t_at	(Traeger.get Tr_ID t)
	)
	
	(setq h_ht	(Traeger.get Htrg h)
				t_ht	(Traeger.get Htrg t)
	)
		
	(setq cpSteg_hp (- h_ht (* 2.0 t_ht)))
		
	(Blech.set BLECH_ID (hp cpSteg_hp))
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet die Daten des Stegbleches, wenn auch ein Gurt vorhanden ist
; ****************************************************************************************
(defun calcStegBlechMitGurt (BLECH_ID GURT_ID DIFF_OBEN)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE STEGBLECH BEI VORHANDENEM GURT")
	
	; HOEHE
	; ---------------------------------------------
	(setq h_at	(Traeger.get Tr_ID h)
				t_at	(Traeger.get Tr_ID t)
	)
	
	(setq h_ht	(Traeger.get Htrg h)
				t_ht	(Traeger.get Htrg t)
	)
		
	(setq cpSteg_hp (- h_ht (* 2.0 t_ht)))
	
	(if (= COUPON_TYPE 2)
		(progn
			(setq gurt_dp (Blech.get GURT_ID dp))
	
			(setq cpSteg_hp (+ (- h_at t_ht gurt_dp) DIFF_OBEN))
		)
	)
	
	(Blech.set BLECH_ID (hp cpSteg_hp))
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet die Daten des Gurtbleches
; ****************************************************************************************
(defun calcGurtBlech (GURT_ID)
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq cp_gurt_dp (runde t_at auf 5.0))
	(print cp_gurt_dp)
	
	(Blech.set GURT_ID 	(dp 	cp_gurt_dp)
											
	)
									
	
)


; ****************************************************************************************
; Erzeugt einen Coupon aus Blechen
; ****************************************************************************************
(defun createCouponBleche ()
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGE COUPONBLECHE")
	(setq xPos_HT	(Connect.get CastaData xPos_ht))
	(print xPos_HT)
		
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= COUPON_TYPE 1)	(Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_links_ cpStegBlech))
			(if (= COUPON_TYPE 2)	(Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_links_ cpStegBlech cpFlaBlech))
			(if (= COUPON_TYPE 3)	(Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_links_))
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= COUPON_TYPE 1)	(Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_rechts_ cpStegBlech))
			(if (= COUPON_TYPE 2)	(Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_rechts_ cpStegBlech cpFlaBlech))
			(if (= COUPON_TYPE 3)	(Traeger.addabtl Htrg cpFrontBlech xPos_HT 0.0 _blechcoupon_rechts_))
		)
	)
	
	
	; Diesen Teil noch ndern!!!
	; ||||||||||||||||||||||||||
	; Seitliche Verschiebung (entlang der HT-Achse) ber Bleche berechnen
  ; --------------------------------------------------------------------------------------	
	(calcSeitVerschiebung) ; --> verschiebung
	
	(Blech.set cpFrontBlech (delta_lr verschiebung))
	
	
	
	(if (= COUPON_TYPE 1)	
		(progn
			(setq abtl_cpStegBlech (Traeger.get Htrg AbTeil cpStegBlech))
			(Anbauteil.set abtl_cpStegBlech (delta_lr verschiebung))
		)
	)
	(if (= COUPON_TYPE 2)	
		(progn
			(setq abtl_cpStegBlech 	(Traeger.get Htrg AbTeil cpStegBlech))
			(setq abtl_cpFlaBlech 	(Traeger.get Htrg AbTeil cpFlaBlech))
			
			(Anbauteil.set abtl_cpStegBlech (delta_lr verschiebung))
			(Anbauteil.set abtl_cpFlaBlech 	(delta_lr verschiebung))
		)
	)
	
	;(Blech.set cpFlaBlech (delta_lr 300))
	
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet die Verschiebung des Coupons aufgrund der AT-Lage
; ****************************************************************************************
 (defun calcCouponXPos ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE COUPONVERSCHIEBUNG")
		
	(setq verschiebung_dlr 0.0)
	
	; Einfluss der Verschiebung des AT um delta_v fr die xPos des Frontblechs
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
		
		(if (= (Connect.get CastaData amHtSteglinks)  1)
			(progn
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq verschiebung_dlr (+ verschiebung_dlr delta_lr_at)))
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_dlr (- verschiebung_dlr delta_lr_at)))
			)
		)
		(if (= (Connect.get CastaData amHtStegrechts)  1)
			(progn
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq verschiebung_dlr (- verschiebung_dlr delta_lr_at)))
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_dlr (+ verschiebung_dlr delta_lr_at)))
			)
		)
		(print verschiebung_dlr)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	(setq xPos_HT (+ xPos_HT verschiebung_dlr))
	(print xPos_HT)
	
	
	(setq verschiebung_aus_hneigung 0.0)
	; Einfluss der Horizontalneigung des AT fr die xPos des Frontblechs
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		;(setq h_winkel_at (Connect.get CastaData h-atrgewnkl_steg))
		(setq h_winkel_at (Connect.get CastaData at_laengswinkel))
		(print h_winkel_at)
		
		(setq delta_l_at (TrEnde.get At_Ende delta_l))
		(print delta_l_at)
		
		(setq cosW (cos (/ (* PI h_winkel_at) 180.0)))
		(print cosW)
		
		(setq verschiebung_aus_hneigung (* delta_l_at cosW))
		(print verschiebung_aus_hneigung)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	(setq xPos_HT (+ xPos_HT verschiebung_aus_hneigung))
	(print xPos_HT)
	
	(print "<-------------------------------------------------------------------------------")
)


; ****************************************************************************************
; Berechnet die Verschiebung des Coupons aufgrund der AT-Lage
; ****************************************************************************************
 (defun calcSeitVerschiebung ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE SEITLICHE VERSCHIEBUNG")
		
	(setq verschiebung 0.0)
	
	(setq verschiebung_dlr 0.0)
	
	; Einfluss der Verschiebung des AT um delta_v fr die xPos des Frontblechs
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
		
		(if (= (Connect.get CastaData amHtSteglinks)  1)
			(progn
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq verschiebung_dlr (+ verschiebung_dlr delta_lr_at)))
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_dlr (- verschiebung_dlr delta_lr_at)))
			)
		)
		(if (= (Connect.get CastaData amHtStegrechts)  1)
			(progn
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq verschiebung_dlr (- verschiebung_dlr delta_lr_at)))
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_dlr (+ verschiebung_dlr delta_lr_at)))
			)
		)
		(print verschiebung_dlr)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	(setq verschiebung (+ verschiebung verschiebung_dlr))
	(print verschiebung)
	
	
	(setq verschiebung_aus_hneigung 0.0)
	; Einfluss der Horizontalneigung des AT fr die xPos des Frontblechs
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		;(setq h_winkel_at (Connect.get CastaData h-atrgewnkl_steg))
		(setq h_winkel_at (Connect.get CastaData at_laengswinkel))
		(print h_winkel_at)
		
		(setq delta_l_at (TrEnde.get At_Ende delta_l))
		(print delta_l_at)
		
		(setq cosW (cos (/ (* PI h_winkel_at) 180.0)))
		(print cosW)
		
		(setq verschiebung_aus_hneigung (* delta_l_at cosW))
		(print verschiebung_aus_hneigung)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	(setq verschiebung (+ verschiebung verschiebung_aus_hneigung))
	(print verschiebung)
	
	(print "<-------------------------------------------------------------------------------")
)


; ****************************************************************************************
; Krzt den Anschlusstrger
; ****************************************************************************************
(defun berechneATEndeWnkl ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE AT ENDWINKEL")
	
	; erstmal alles zurcksetzen
	(resetAtEnde)
	
	; jetzt die Berechnung
	(setq b_ht 	(Traeger.get Htrg b))
	
	(setq hscherl_at 	(TrEnde.get AT_Ende hscherl)
				vscherl_at	(TrEnde.get At_Ende vscherl)
	)
	
	(print b_ht)
	
	; Horizontale Neigung des AT
	; ----------------------------------------------
	(setq at_h_winkel_steg (Connect.get CastaData h-atrgewnkl_steg))
	(print at_h_winkel_steg)

	(TrEnde.set At_Ende (h_winkel at_h_winkel_steg))
	
	; Vertikale Neigung des AT
	; ----------------------------------------------
	(setq at_v_winkel_steg (Connect.get CastaData v-atrgewnkl_steg))
	(print at_v_winkel_steg)

	(TrEnde.set At_Ende (v_winkel at_v_winkel_steg))
	
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Krzt den Anschlusstrger
; ****************************************************************************************
(defun kuerzeATEnde ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE AT ABLNGUNG")
	(setq b_ht 			(Traeger.get Htrg b)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	
	(setq kuerzung (+ (* 0.5 b_ht) cpFront_dp kpl_dp))
	
	(if (= qsform_ht "U") (setq kuerzung (+ b_ht cpFront_dp kpl_dp)))
	(print kuerzung)
		
		
	; Anteil delta_v_at
	(if (= 1 1)
		(progn
			(setq at_v_winkel_steg (Connect.get CastaData v-atrgewnkl_steg))
			(print at_v_winkel_steg)
		
			(setq cosW (cos (/ (* PI at_v_winkel_steg) 180.0)))
			(print cosW)
		
			(setq delta_v_at (Traeger.get Tr_ID delta_v))
			(print delta_v_at)
	
			(setq anteil_dv_at (* delta_v_at cosW))
	
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq kuerzung (- kuerzung anteil_dv_at)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq kuerzung (+ kuerzung anteil_dv_at)))
		)
	)
	
	(TrEnde.ptrim At_Ende kuerzung) 
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Berechnet die Kopfplatte des AT
; ****************************************************************************************
(defun calcAtKpl (BLECH_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE AT KOPFPLATTE")
	
	(setq vscherl_at (TrEnde.get At_Ende vscherl))
	(print vscherl_at)
	
	(setq h_at 			(Traeger.get Tr_ID h)
				t_at			(Traeger.get Tr_ID t)
				b_at			(Traeger.get Tr_ID b)
				qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	
	(setq v_wnkl_steg_at (Connect.get CastaData v-atrgewnkl_steg)
				h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg)
	)
	(print v_wnkl_steg_at)
	(print h_wnkl_steg_at)
	
	(if (> v_wnkl_steg_at 90.0)		(setq wnkl (- v_wnkl_steg_at 90.0)))
	(if (<= v_wnkl_steg_at 90.0)	(setq wnkl (- 90.0 v_wnkl_steg_at)))
	(print wnkl)
	
	(if (> h_wnkl_steg_at 90.0)		(setq h_wnkl (- h_wnkl_steg_at 90.0)))
	(if (<= h_wnkl_steg_at 90.0)	(setq h_wnkl (- 90.0 h_wnkl_steg_at)))
	(print h_wnkl)
	
	(setq tanVW (tan (/ (* PI wnkl) 180.0)))
	(setq tanHW (tan (/ (* PI h_wnkl) 180.0)))
	
	(print tanVW)
	
	
	(setq abst_zum_rand e_min_rund)
	(setq abst_zum_trg (* 0.5 e_min_rund))
	(if (= qsform_at "R")
		(setq abst_zum_trg (* 0.25 e_min_rund))
	)
	(setq rand (+ abst_zum_rand abst_zum_trg))
			
			
	; Hhe
	; -----------------------------------------------------------------
	(setq kpl_hp	(- vscherl_at t_at))
	(print kpl_hp)
	
	(setq anteil_h_neigung (* (* 0.5 b_at) tanHW))
	(print anteil_h_neigung)
	
	(setq anteil_neigung_v (* tanVW anteil_h_neigung))
	(print anteil_neigung_v)
	
	(setq kpl_hp (+ kpl_hp (* 4.0 anteil_neigung_v)))
	
	(setq kpl_hp_rund (runde kpl_hp auf 5.0))
	
	(if (= qsform_at "R")	(setq kpl_hp (+ vscherl_at (* 2.0 rand))))
	(if (= qsform_at "K")	(setq kpl_hp (+ vscherl_at (* 2.0 rand))))
	
	(print kpl_hp)
	
	; Breite
	; -----------------------------------------------------------------
	(setq hscherl_at (TrEnde.get At_Ende hscherl))
	(setq hscherl_at_rund (runde hscherl_at auf 5.0))
	
	(setq kpl_bp	hscherl_at_rund)
	
	(if (= qsform_at "R")	(setq kpl_bp (+ hscherl_at_rund (* 2.0 rand))))
	(if (= qsform_at "K")	(setq kpl_bp (+ hscherl_at_rund (* 2.0 rand))))
	(print kpl_bp)
		
	; dok
	; -----------------------------------------------------------------
	(setq kpl_dok (- (* 0.5 t_at) (* 2.0 anteil_neigung_v)))
	
	(if (= qsform_at "R")	(setq kpl_dok (- rand)))
	(if (= qsform_at "K")	(setq kpl_dok (- rand)))
	
	(print kpl_dok)
	
	
	; Werte setzen
	; -----------------------------------------------------------------
	(Blech.set BLECH_ID (hp		kpl_hp)
											(bp		kpl_bp)
											(dok  kpl_dok)
	)
	
	(print "<-------------------------------------------------------------------------------")
)

; ****************************************************************************************
; Erzeugt die Kopfplatte des AT
; ****************************************************************************************
(defun createAtKpl (BLECH_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGT AT KOPFPLATTE")
	
	(if (= (Connect.get CastaData linkesEnde)  1)	(Traeger.addabtl Tr_ID BLECH_ID 0.0 0.0 _kopfplattelinks_))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(Traeger.addabtl Tr_ID BLECH_ID 0.0 0.0 _kopfplatterechts_))
	
	(print "<-------------------------------------------------------------------------------")
)




; ****************************************************************************************
; 
; ****************************************************************************************
(defun calcUnterschied ()
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE TRG DIFFERENZEN")
	(setq h_ht				(Traeger.get Htrg h)
				t_ht				(Traeger.get Htrg t)
				b_ht				(Traeger.get Htrg b)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				t_at				(Traeger.get Tr_ID t)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq vscherl_at (TrEnde.get AtEnde vscherl))
	(setq vscherl_at_halb (* 0.5 vscherl_at))
	
	(setq v_Wnkl 90.0)
	
	(setq v_rotaW (Connect.get CastaData at_rotawinkel))
	(print v_rotaW)
	
	(if (< v_rotaW 180.0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq v_Wnkl v_rotaW))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq v_Wnkl v_rotaW))
		)
	)
	(if (> v_rotaW 180.0)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq v_Wnkl (+ (- 270.0 v_rotaW) v_Wnkl)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq v_Wnkl (+ (- 270.0 v_rotaW) v_Wnkl)))
		)
	)
	(print v_Wnkl)
	
	(if (>= v_Wnkl 90.0)
		(setq vWnkl_help (- v_Wnkl 90.0))
		(setq vWnkl_help (- 90.0 v_Wnkl))
	)
	(print vWnkl_help)
	
	(setq sinRota (sin (/ (* PI vWnkl_help) 180.0)))
	(setq tanRota (tan (/ (* PI vWnkl_help) 180.0)))
	(setq cosRota (cos (/ (* PI vWnkl_help) 180.0)))
	(print sinRota)
	(print tanRota)
	(print cosRota)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- (* 1.0 delta_v_ht) h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))											(print uKante_ht)
	
	; Anteil delta_v AT
	(print delta_v_at)
	;(setq anteil_delta_v (* (* 1.0 delta_v_at) cosRota))
	(if (/= cosRota 0.0)
		(setq anteil_delta_v (/ (* 1.0 delta_v_at) cosRota))
		(setq anteil_delta_v (* 1.0 delta_v_at))
	)
	(print anteil_delta_v)
	
	(setq delta_v_at_anteil anteil_delta_v)
	(print delta_v_at_anteil)
	
	(setq oKante_at	(- delta_v_at_anteil vscherl_at_halb))				
	(print oKante_at)
	
	; zustzl. Anteil aus AT-Neigung
	(setq b_ht (Traeger.get Htrg b))
	(setq ht_anteil (+ ueberstand (* 0.5 b_ht)))
	
	(print tanRota)
	
	(if (< v_Wnkl 90.0)	
		(setq anteil_neigung (- (* ht_anteil tanRota)))
		(setq anteil_neigung (* ht_anteil tanRota))
	)
	(print anteil_neigung)
	
	(setq oKante_at (+ oKante_at anteil_neigung)) 								(print oKante_at)
	(setq uKante_at (+ oKante_at vscherl_at))											(print uKante_at)
	
	
	(setq diff_oben  (- oKante_at oKante_ht))
	(setq diff_unten (- uKante_at uKante_ht))
	
	(print diff_oben)
	(print diff_unten)
	
	
	(if (> diff_oben 0.0)
		(progn
			(if (< diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_at (* 2.0 t_at))))
			(if (= diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_at t_at t_ht)))
			(if (> diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- (- uKante_ht oKante_at) t_ht t_at)))
		)
	)
	(if (< diff_oben 0.0)
		(progn
			(if (< diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- (- uKante_at oKante_ht) t_ht t_at)))
			(if (> diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_ht (* 2.0 t_ht))))
		)
	)
	(if (= diff_oben 0.0)
		(progn
			(if (< diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_at t_at t_ht)))
			(if (>= diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_ht t_ht t_at)))
		)
	)
	(print verfuegbarer_LB_bereich)
		
	(print "<-------------------------------------------------------------------------------")
)






; ########################################################################################
; # LOCHBILDER
; ########################################################################################

; ***************************************************************************************
; Erzeugt das Lochbild fr das Couponblech und die Kopfplatte
; ***************************************************************************************
(defun createLochbilder (LCHB_ID BLECH_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGT LOCHBILDER")
	
	; allg. Daten holen
	; =================================================================
	(setq h_ht						(Traeger.get Htrg h)
				delta_v_ht			(Traeger.get Htrg delta_v)
	)
	
	(setq rwinkel_at			(Traeger.get Tr_ID r_winkel)
				delta_v_at 			(Traeger.get Tr_ID delta_v)
				h_at						(Traeger.get Tr_ID h)
				delta_lr_at			(Traeger.get Tr_ID delta_lr)
	)
	
	(setq vwinkel_uz		(Connect.get CastaData hpttrg_vwinkel)
				r_winkel_steg	(Connect.get CastaData r-atrgewnkl_steg)
	)
	
	; Kopfplattenlochbild - Anbauteil hinzufgen
	; =================================================================
	(if (= (Connect.get CastaData linkesEnde) 1)	(Traeger.addabtl Tr_ID LCHB_ID 0.0 0.0 _kpllochbildlinks_))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(Traeger.addabtl Tr_ID LCHB_ID 0.0 0.0 _kpllochbildrechts_))
	
	; Couponlochbild - Anbauteil hinzufgen
	; =================================================================
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	(print xPos_ht)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)  (Traeger.addabtl Htrg LCHB_ID xPos_ht 0.0 _couponlochbild_links_))
  (if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addabtl HTrg LCHB_ID xPos_ht 0.0 _couponlochbild_rechts_)) 
	
	
	; BEARBEITUNG
	; =================================================================
	
	; Anbauteile zur Verwendung holen
	; ---------------------------------------------
	(setq ht_lochbild_abtl (Traeger.get Htrg Abteil LCHB_ID))
	(setq at_lochbild_abtl (Traeger.get Tr_ID Abteil LCHB_ID))
	
	
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print "---- Differenzwinkel ----")
	(print vwinkel_uz)
	(print rwinkel_at)
	(print r_winkel_steg)
	
	(setq diffWinkel 0.0)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
		)
	)
	
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	
	; Positionierung des Anbauteil-Lochbildes am HT
	; ----------------------------------------------
	(setq verschiebung_delta_lr 0.0)
	(setq verschiebung_delta_v 0.0)
	
	; Winkel des Anbauteils
	; ----------------------------------------------
	(setq abtl_winkel 0.0)
	(setq abtl_winkel (- diffWinkel))
	(print abtl_winkel)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel (- 180.0 abtl_winkel)))
	(print abtl_winkel)
	
	
	; delta_v / delta_lr Anteile allein durch Rotation und delta_v AT
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Verschiebung delta_lr des Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn	
	; ----------------------------------------------
		(print "-------------> Anteil an delta_lr aus Rotation")
		(print delta_v_at)
		(print sinW)
		
		(setq h_at_halb (* 0.5 h_at))
		(print h_at_halb)
		
		(setq verschiebung_delta_lr	(* (- h_at_halb delta_v_at) sinW))
		(print verschiebung_delta_lr)
		
	; ----------------------------------------------	
	))
	; ----------------------------------------------
	
	; Verschiebung delta_v des Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "-------------> Anteil an delta_v aus Rotation")
		(setq h_at_halb (* 0.5 h_at))
		(print h_at_halb)
		(setq delta_v_at (Traeger.get Tr_ID delta_v))
		
		(setq anteil_rot (* h_at_halb cosW))
				
		(setq diff (- h_at_halb anteil_rot))
		(print diff)
		
		(setq verschiebung_delta_v (+ verschiebung_delta_v diff))
		(print verschiebung_delta_v)
		
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; HT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "-------------> Auswirkungen delta_v HT")
		(print delta_v_ht)
		
		(setq verschiebung_delta_v (- verschiebung_delta_v delta_v_ht))
		(print verschiebung_delta_v)
		(print verschiebung_delta_lr)
	; ----------------------------------------------
	))
	; ----------------------------------------------

	
	; AT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData vatr-vhtr) 1)
			(progn		
				(print delta_lr_at)
				(setq anteil_delta_lr_at	(* (* 1.0 delta_lr_at) cosW))
				(print anteil_delta_lr_at)
				
				(if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))	
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
						(print "Liste")
					)
				)
				
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
					)
				)
					
				
				(setq anteil_delta_v_at (* (* 1.0 delta_lr_at) sinW))
				(print anteil_delta_v_at)
				(if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1) (setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
					)
				)
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
					)
				)
			)
		)
		
		(if (= (Connect.get CastaData vatr-vhtr) -1)
			(progn		
				(print delta_lr_at)
				(setq anteil_delta_lr_at	(* (* 1.0 delta_lr_at) cosW))
				(print anteil_delta_lr_at)
				
				(if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))	
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
						(print "Liste")
					)
				)
				
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
					)
				)
					
				
				(setq anteil_delta_v_at (* (* 1.0 delta_lr_at) sinW))
				(print anteil_delta_v_at)
				(if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1) (setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
					)
				)
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
					)
				)
			)
		)
		
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Anteil delta_v Verschiebung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "-------------> delta_v AT")	
		(setq delta_v_at (Traeger.get Tr_ID delta_v))
		(print delta_v_at)
		
		(setq anteil_delta_v_at (* (* 1.0 delta_v_at) cosW))
		(print anteil_delta_v_at)
		
		(print verschiebung_delta_v)
		(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_delta_v_at))
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; Horizontale Neigung des AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "-------------> Horizontale Neigung")
		(setq at_h_winkel_steg (Connect.get CastaData h-atrgewnkl_steg))
		(print at_h_winkel_steg)
		
		(setq dp_kpl (Blech.get BLECH_ID dp))
		
		(setq s_ht 			(Traeger.get Htrg s)
					b_ht 			(Traeger.get Htrg b)
					qsform_ht	(Traeger.get Htrg qsform)
		)
		
		(setq cp_front_dp (Blech.get cpFrontBlech dp))
		
		(print dp_kpl)
		(print cp_front_dp)
		(print b_ht)
		
		(setq b_ht_halb (* 0.5 b_ht))
		(print b_ht_halb)
		
		(setq b_ht_halb_plus_dp_kpl (+ b_ht_halb dp_kpl cp_front_dp))
		(if (= qsform_ht "U") (setq b_ht_halb_plus_dp_kpl (+ b_ht dp_kpl cp_front_dp)))
		(print b_ht_halb_plus_dp_kpl)
		
		(setq tanAFW (tan (/ (* PI at_h_winkel_steg) 180.0)))
		(print tanAFW)
		
		(setq anteil_h_neig_at (/ b_ht_halb_plus_dp_kpl tanAFW))
		(print anteil_h_neig_at)
		
		
		(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_h_neig_at)))
		(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_h_neig_at)))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Vertikale Neigung des AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "-------------> Vertikale Neigung")
		(setq at_v_winkel_steg (Connect.get CastaData v-atrgewnkl_steg))
		(print at_v_winkel_steg)
		
		(setq b_ht				(Traeger.get Htrg b)
					h_ht				(Traeger.get Htrg h)
		)
		(setq cp_front_dp (Blech.get cpFrontBlech dp))
		
		(setq h_ht_halb (* 0.5 h_ht))
		(setq b_ht_halb (* 0.5 b_ht))
		
		(setq v_scherl_at (TrEnde.get At_Ende vscherl))
		(setq v_scherl_at_halb (* 0.5 v_scherl_at))
		
		(if (= (Connect.get CastaData LinkesEnde) 1)	(setq at_v_winkel_steg at_v_winkel_steg))
		(if (= (Connect.get CastaData RechtesEnde) 1)	(setq at_v_winkel_steg (- 180.0 at_v_winkel_steg)))
		(print at_v_winkel_steg)
		
		(setq tanW (tan (/ (* PI at_v_winkel_steg) 180.0)))
		(print tanW)
		
		(setq abstand (+ b_ht_halb cp_front_dp))
		(print abstand)
		
		(setq anteil_v_neig_at 0.0)
		
		(setq anteil_v_neig_at (/ abstand tanW))
		(print anteil_v_neig_at)
		
		(setq anteil_at (+ anteil_v_neig_at v_scherl_at_halb))
		(setq anteil_ht h_ht_halb)
		
		(setq diff_at_ht (- anteil_at anteil_ht))
		
		(print verschiebung_delta_v)
		(setq verschiebung_delta_v (- verschiebung_delta_v diff_at_ht))
		(print verschiebung_delta_v)
		
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Beidseitige Neigung des AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "-------------> beidseitige Neigung")
		(setq at_v_winkel_steg 	(Connect.get CastaData v-atrgewnkl_steg)
					at_h_winkel_steg 	(Connect.get CastaData h-atrgewnkl_steg)
					h_afl_wnkl				(Connect.get CastaData afl_hwinkel)
					v_afl_wnkl				(Connect.get CastaData afl_vwinkel)
		)
		(print at_v_winkel_steg)
		(print at_h_winkel_steg)
		(print h_afl_wnkl)
		
				
		(setq h_at (Traeger.get Tr_ID h))
		(setq h_at_halb (* 0.5 h_at))
		(print h_at_halb)
		

		(setq h_ht (Traeger.get Htrg h))
		(setq cp_front_dp (Blech.get cpFrontBlech dp))
		
		(setq h_ht_halb (* 0.5 h_ht))
		(setq b_ht_halb (* 0.5 b_ht))

		
		(setq b_ht (Traeger.get Htrg b))
		(setq b_ht_halb (* 0.5 b_ht))
		
		(setq cp_front_dp (Blech.get cpFrontBlech dp))
		(setq kpl_dp 			(Blech.get BLECH_ID dp))
		
		(setq abstand (+ b_ht_halb cp_front_dp kpl_dp))
		(print abstand)
				
		; horizontaler Anteil
		; --------------------------------
		(if (= 1 1)	(progn
		; --------------------------------
		
		(print "-------------> H")
				(setq tan_h_real (tan (/ (* PI at_h_winkel_steg) 180.0)))
				(setq tan_h_ds (tan (/ (* PI h_afl_wnkl) 180.0)))
		
		
				(setq h_ant_drauf (/ abstand tan_h_ds))
				(print h_ant_drauf)
				(setq h_ant_real (/ abstand tan_h_real))
				(print h_ant_real)
				
				(setq diff_h (- h_ant_real h_ant_drauf))
				(print diff_h)
					
				(setq verschiebung_delta_lr (- verschiebung_delta_lr diff_h))
				(print verschiebung_delta_lr)
		; --------------------------------
		))
		; --------------------------------
			
		
		; vertikaler Anteil
		; --------------------------------
		(if (= 1 1)	(progn
		; --------------------------------
			(print "*clear*")
		(print "-------------> V")
		
			;		1.		... Anmerkung AF ... Kopfplattendicke nicht auch dazuaddieren,
			;					weil die Schrauben an der Kontaktflche orientiert sind.
				(setq abstand (+ b_ht_halb cp_front_dp))

				(setq h_at (Traeger.get Tr_ID h))
				(setq h_ht (Traeger.get Htrg h))
				(setq h_at_halb (* 0.5 h_at))
				(print h_at_halb)

			;		2.		... Anmerkung AF ... Verschiebung habe ich hier erneut als Differenz
			;				der Trgerhhen ausgerechnet. Wenn noch delta_V eines er Trger
			;				dazukommt, muss das wohl hier auch eingebaut werden.
				(setq verschiebung_delta_v (* 0.5 (- h_ht h_at)))
				(print verschiebung_delta_v)
				
				(setq deltaV_HT (Traeger.get Htrg  delta_V))
				(setq deltaV_AT (Traeger.get Tr_ID delta_V))
				(setq verschiebung_delta_v (- verschiebung_delta_v deltaV_HT))
				(setq verschiebung_delta_v (+ verschiebung_delta_v deltaV_AT))

				; ist nicht so schn - man sollte vielleicht eine Extra-Variable verwenden.
				(setq h_at_halb (- h_at_halb deltaV_AT))
				
				(print verschiebung_delta_v)

				(print v_afl_wnkl)
				(print at_v_winkel_steg)
				(print Abstand)
				
				(setq alpha (- at_v_winkel_steg 90.0))

				(setq hwTre  	(TrEnde.get At_Ende h_Winkel))
				(setq vwTre  	(TrEnde.get At_Ende v_Winkel))
				(setq alfaR 	(TrEnde.get At_Ende Alfa_R))
				(setq alfaV2 	(TrEnde.get At_Ende Alfa_V2))
				(print hwTre) (print vwTre) 

			;		3.		... Anmerkung AF ... den Horizontalwinkel habe ich aus dem
			;				Trgerendewinkel ermittelt, da dieser eindeutig ist.
			;				Zudem habe ich AlfaR vom Trgerende abgeholt.
			;				Die Funktionen (AlfaV2 und AlfaR) sind neu eingebaut, weil ich der Ansicht war,
			;				dass dies im Lisp dann bersichtlicher aussieht.
				(setq alfaH   (- 90.0 hwTre))
				(setq alfaV2  (- alfaV2 90.0))

				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq alpha (* -1.0 alpha)))
				
				(print "------");
				(print alpha)
				(print alfaR)
				(print alfaH)
				(print "------");

				(setq cosAlphaH   (cos (/ (* PI alfaH)  180.0)))
				(setq cosAlphaV2  (cos (/ (* PI alfaV2) 180.0)))
				
				(setq tan_v_real (tan (/ (* PI alpha) 180.0)))
				(print tan_v_real)
				
				(setq v_ant_real (* (/ (- abstand 0) cosAlphaH) tan_v_real))
								
				(setq cosAlpha   (cos (/ (* PI alpha)  180.0)))
				(setq cosAlphaR  (cos (/ (* PI alfaR) 180.0)))
				(print v_ant_real)
				
				(setq cosAlphaR 1.0)
				
			;		4.		... Anmerkung AF ... hier muss man auf die TrgerOK von der Systemachse
			;				zurckrechnen, umd dann die verlngerte Vorderkante des Trgers wieder
			;				dazuzuaddieren. Man rotiert ja um die Systemachse. Bei delta_V
			;				Verschiebung eines Trgers msste der DV-Anteil hier auch bercksichtigt werden.
			;				Sicher bin ich mir nicht, aber weil die Systemachse am Ort bleibt, msste es so
			;				sein.
				(setq v_ant_real (+ v_ant_real h_at_halb))
				(setq v_ant_real (- v_ant_real (/ h_at_halb cosAlpha)))
				
				(print verschiebung_delta_v)
				(setq verschiebung_delta_v (+ verschiebung_delta_v v_ant_real))
				
		))	
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; Wenn HT und AT Vertikal-Richtung unterschiedlich ist
	; ----------------------------------------------
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq verschiebung_delta_v (+ verschiebung_delta_v h_ht)))



	
	; Werte setzen
	; =================================================================
	(print "Zu setzende Werte:")
	(print verschiebung_delta_v)
	(print verschiebung_delta_lr)
	(print abtl_winkel)
	
	(Anbauteil.set ht_lochbild_abtl (delta_v 		verschiebung_delta_v)
																	(delta_lr 	verschiebung_delta_lr)
																	(winkel			abtl_winkel)
	)
	
	
	; Master setzen
	; =================================================================
	(Anbauteil.set ht_lochbild_abtl (Master 1))
	(Anbauteil.set at_lochbild_abtl (Master 0))
	
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(Anbauteil.set ht_lochbild_abtl 	(SeitRicht -1))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(Anbauteil.set ht_lochbild_abtl 	(SeitRicht -1))
			)
		)
	)
	
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy LCHB_ID)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
    	)
	    (if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1))
			
			;(if (= qsform_at "U")	
			;	(Anbauteil.set dummy_abtl (delta_lr uProf_anpassung))
			;)
		)
	)
	;===================================================================
	(print "------------------------------------------------------------")
)

; ***************************************************************************************
; Berechnet das Lochbild fr die Kopfplatte
; ***************************************************************************************
(defun calcLchb (BLECH_HT BLECH_AT LCHB_ID)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE KOPFPLATTENLOCHBILD")
	(Lochbild.set Lchb_ID (Anz_S 		2)
												(Guete   	"4.6")
	)
	
	(setq coupBlech_dp 	(Blech.get BLECH_HT dp))
	(setq atBlech_dp		(Blech.get BLECH_AT dp)
				atBlech_bp		(Blech.get BLECH_AT bp)
				atBlech_hp		(Blech.get BLECH_AT hp)
				atBlech_dok		(Blech.get BLECH_AT dok)
	)
			
	(setq qsform_at (Traeger.get Tr_ID qsform))
	
	(print min_h)
	(print verfuegbarer_LB_bereich)
		
	; Vorraussetzung ist, dass "verfuegbarer_LB_bereich" richtig berechnet wurde
	(if (> min_h verfuegbarer_LB_bereich)
		(progn
			(print "2 Schrauben")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq anz_schr 2)
		)
		(progn
			(print "4 Schrauben")
			(Lochbild.set Lchb_ID (Anz_S 4))
			(setq anz_schr 4)
		)
	)
	
	(if (= qsform_at "R")	(setq anz_schr 4))
	(if (= qsform_at "K")	(setq anz_schr 4))
	
	; Klemmlnge
	; ---------------------------------------------
	(setq klemml_cp (+ coupBlech_dp atBlech_dp))
	
	; w0 
	; ---------------------------------------------
	(setq s_at 	(Traeger.get Tr_ID s)
				b_at	(Traeger.get Tr_ID b)
	)
	
	(setq w0_help (+ (* 0.5 (- atBlech_bp s_at)) s_at))
	(setq w0 w0_help)
	
	(if (= qsform_at "R")	(setq w0 (- atBlech_bp (* 2.0 e_min_rund))))
	(if (= qsform_at "K")	(setq w0 (- atBlech_bp (* 2.0 e_min_rund))))
	
	; Berechnung e0, e1
	; ---------------------------------------------
	(if (= anz_schr 4)
		(progn
			(if (> diff_oben 0.0)
				(setq e0 (* 0.25 verfuegbarer_LB_bereich))
				(setq e0 (- (* 0.25 verfuegbarer_LB_bereich) diff_oben))
			)
			(setq e0_rund (runde e0 auf 5.0))
			
			(if (= qsform_at "R") (setq e0_rund (- abst_zum_trg)))
			(if (= qsform_at "K") (setq e0_rund (- abst_zum_trg)))
			
			(if (> diff_oben 0.0)
				(setq e1 (* 0.5 verfuegbarer_LB_bereich))
				(setq e1 (* 0.5 verfuegbarer_LB_bereich))
			)
			(setq e1_rund (runde e1 auf 5.0))
			
			(if (= qsform_at "R") (setq e1_rund (- atBlech_hp (* 2.0 e_min_rund))))
			(if (= qsform_at "K") (setq e1_rund (- atBlech_hp (* 2.0 e_min_rund))))
			
		)
	)
	(if (= anz_schr 2)
		(progn
			(if (> diff_oben 0.0)
				(setq e0 (* 0.5 verfuegbarer_LB_bereich))
				(setq e0 (- (* 0.5 verfuegbarer_LB_bereich) diff_oben))
			)
			
			(setq e0_rund (runde e0 auf 5.0))
			(setq e1_rund 0.0)
		)
	)
	
	; dlr_Coupon
	; ---------------------------------------------
	(setq b_ht			(Traeger.get Htrg b)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	
	(setq coup_dlr 0.0)
	
	(if (= qsform_ht "I")
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq coup_dlr (+ (* 0.5 b_ht) coupBlech_dp atBlech_dp))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq coup_dlr (- (+ (* 0.5 b_ht) coupBlech_dp atBlech_dp)))
			)
		)
	)
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq coup_dlr (+ b_ht coupBlech_dp atBlech_dp))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq coup_dlr 0.0)
			)
		)
	)
	(print coup_dlr)
	
	
	; Werte setzen
	; ---------------------------------------------
	(Lochbild.set LCHB_ID (e0 				e0_rund)
												(e1 				e1_rund)
												(w0 				w0)
												(klemml			klemml_cp)
	)
	(if (= LB_DEBUG 1)
		(progn
			(Lochbild.set LCHB_ID (dlr_Coupon	(+ 10.0 coup_dlr)))
			;(Lochbild.set LCHB_ID (dlr_Coupon	(+ 0.0 coup_dlr)))
			(Lochbild.set LCHB_ID (e2 400.0))
		)
		(progn
			(Lochbild.set LCHB_ID (dlr_Coupon	coup_dlr))
		)
	)
	(print "<-------------------------------------------------------------------------------")
)




