; $	G(1) 	HT	 QT(IU)	 		AF(S)		P(EZ)
; $ G(1)	AT	 QT(IUKR) 	AF(K)		P(E)
; $	G(1)	AE	 V(-)		 		H(-)		R(46-90)
; $	G(31) HT	 QT(IU)	 		AF(S)		P(EZ)
; $ G(31)	AT	 QT(IUKR) 	AF(K)		P(E)
; $	G(31)	AE	 V(-)		 		H(-)		R(-)
; $	HT	QT(IU)	 	AF(S)		P(EZ)
; $ AT	QT(IUKR) 	AF(K)		P(E)
; $	AE	V(-)		 	H(-)		R(-)

(defun load-modules ()
   (load "mod-lochbild")
   (load "mod-utils")
   (load "uz_an_uzCoupBlech")
;	 (load "uz_an_uzCoupBlech-af")
)

(defun init-connection ()

  (print "in init-connection uz_an_uzCoupBlech");
  (print "*clear*")
;  (connect.showattributes CastaData)

	(setq LB_DEBUG 0)
	(setq COUPON_TYPE 1) ; 1 = ohne Gurtplatte
											 ; 2 = mit Gurtplatte
											 ; 3 = nur Kontaktplatte
	
	; spitzester Anschlusswinkel zwischen HT und AT
	; -----------------------------------------------------------------
	(setq grenzwinkel 15.0)
	
	(setq h_winkel_atht (Connect.get CastaData h-atrgewnkl_steg))
	
	(if (> h_winkel_atht grenzwinkel)
		(progn
			(print h_winkel_atht)
			(setq max (- 180.0 grenzwinkel))
			(print max)
			(if (> max h_winkel_atht)
				(progn
					(setq qsform_ht (Traeger.get Htrg qsform))
					(print qsform_ht)
					(if (= qsform_ht "U")
						(progn
							(print "QUERSCHNITT: U")
							(if (= (Connect.get CastaData amHtStegLinks) 0)	
								(progn
									(print "STEG LINKS")
									(setConnection)
									(calcHTrgEndeAblaengung_UZ)
								)
							)
						)
						(progn
							(setConnection)
							(calcHTrgEndeAblaengung_UZ)
						)
					)
					
				)
			)
		)
	)

	
	
)


;########################################################################################
;# CALLBACKS
;########################################################################################

; ----------------------------------------------------------------------------------------
; Kontaktplatte des Coupons wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_cpFrontBlech (zp)
	(print "*clear*")
	(print "CALLBACK: cb_cpFrontBlech <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(print zp)
	(if (objExist Tr_ID) 
		(print "ok")
		(setq zp 100)
	)
	
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_alt   (Blech.get cpFrontBlech dp))
		(setq hp_alt   (Blech.get cpFrontBlech hp))
	    (setq Abtl_BL (Traeger.get HTrg ABTeil cpFrontBlech))
	    (setq dlr_Alt 0.0)
	    (if Abtl_BL (progn
	    	(setq dlr_Alt (Anbauteil.get Abtl_BL delta_LR))
	    ))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_neu (Blech.get cpFrontBlech dp))

	    (setq dlr_Neu 0.0)
	    (if Abtl_BL (progn
	    	(setq dlr_Neu (Anbauteil.get Abtl_BL delta_LR))
	    ))

	    (setq dpDiff       0.0)
	    (setq dpDiff_Klemm 0.0)
	    (if (/= dlr_Alt dlr_Neu) (setq dpDiff (+ dpDiff (- dlr_Neu dlr_Alt))))
	    (if (/= dp_alt  dp_neu)  (setq dpDiff (+ dpDiff (- dp_neu dp_alt))))
	    (if (/= dp_alt  dp_neu)  (setq dpDiff_Klemm (- dp_neu dp_alt)))
	    
		(print dp_alt) 
		(print dp_neu)

		(setq hp_neu (Blech.get cpFrontBlech hp))
		(setq CopyMode (Connect.get CastaData CopyMode))
		(if (= CopyMode 1) (progn
			(if (/= hp_alt hp_neu) (Blech.set cpFrontBlech (hp hp_alt)))
		))
	    
	    (if (/= dpDiff 0.0) (progn
			(setq alteKlemml  (Lochbild.get cplchb Klemml))
			(setq altesDxS	  (Lochbild.get cplchb dxsKopf))

			(Lochbild.set	cplchb 	(Klemml (+ alteKlemml dpDiff_Klemm))
					; (DxSKopf (+ altesDxS dpDiff)) ;; weil Kpl jetzt Master ist
					(callbackfl 1)
			)

			; derzeit nicht erforderlich
			; (Connect.storeCallbackObjs CastaData cplchb)	; als Callback-Objekt speichern
						
			(if (objExist Tr_ID) (progn
				(print dpDiff)
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
				(print At_Ende)
				(TrEnde.ptrim At_Ende dpDiff)
			))
			(Connect.set CastaData (htModify 1))
		
	    ))

	    (if (/= dlr_Alt dlr_Neu) (progn
			(if (objExist cpStegBlech) (progn
				(setq bpStegBl (Blech.get cpStegBlech bp))
				(setq bpStegBl (+ bpStegBl (- dlr_Neu dlr_Alt)))
				(Blech.set cpStegBlech (bp bpStegBl))
				(setq bp_alt bpStegBl)		; damit es nicht zum Zirkelbezug kommt - 
			))
	    ))

	))
)

; ----------------------------------------------------------------------------------------
; Stegplatte des Coupons wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_cpStegBlech (zp)
	(print "CALLBACK: cb_cpStegBlech <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(if (objExist Tr_ID) 
		(print "ok")
		(setq zp 100)
	)
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq	bp_alt (Blech.get cpStegBlech bp)
					hp_alt (Blech.get cpStegBlech hp)
		)
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq bp_neu (Blech.get cpStegBlech bp))
	    (setq hp_neu (Blech.get cpStegBlech hp))
	    
	    (print bp_alt) (print bp_neu)

		(setq CopyMode (Connect.get CastaData CopyMode))
		(if (= CopyMode 1) (progn
			(if (/= hp_alt hp_neu) (Blech.set cpStegBlech (hp hp_alt)))
		))
		
	    
	    (if (/= bp_alt bp_neu) 
				(progn
					(setq bpDiff (- bp_neu bp_alt))
					
					(print bpDiff)
					(if (objExist Tr_ID) (progn
						(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
						(print At_Ende)
						(TrEnde.ptrim At_Ende bpDiff)
					))

					(setq Abtl_BL (Traeger.get HTrg ABTeil cpFrontBlech))
					(if Abtl_BL (progn
						(setq dlr_Alt (Anbauteil.get Abtl_BL delta_LR))
						(Anbauteil.set Abtl_BL (delta_LR (+ dlr_Alt bpDiff)))
					))
					
				)
			)
	))
)

; ----------------------------------------------------------------------------------------
; Kopfplatte wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_atKpl (zp)
	(print "CALLBACK: v1 cb_blKopfplatte <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_alt (Blech.get atKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_neu (Blech.get atKpl dp))
	    
	    (print dp_alt) (print dp_neu)
	    
	    (if (/= dp_alt dp_neu) 
				(progn
					(setq dpDiff (- dp_neu dp_alt))
					(setq alteKlemml (Lochbild.get cplchb Klemml))
					(setq altesDxS		(Lochbild.get cplchb dxsKopf))
	       
					(Lochbild.set cplchb 	(Klemml (+ alteKlemml dpDiff))
								; (DxSKopf (+ altesDxS dpDiff))  ;; weil Master das KPL-Lochbild ist
								(callbackfl 1)
					)

					; Frontblech muss vorhanden sein - je nachdem, ob es auch noch ein Stegblech gibt
					; dann Einstellungen durchfhren
					(if (objExist cpFrontBlech) (progn
						(if (objExist cpStegBlech) 
							(cbDeltaLR cplchb cpFrontBlech cpStegBlech dpDiff)
							(cbDeltaLR cplchb cpFrontBlech 0 dpDiff)
						)
					))
					(Connect.set CastaData (htModify 1))
				)
			)
	))
)
; 2018-08 - eigentlich Dummy-Funktion, weil Gurtblech in diesem Anschluss eher nicht vorkommt
(defun cb_cpFlanschBlech (zp)
	(if (objExist Tr_ID) 
		(print "ok")
		(setq zp 100)
	)
	(if (= zp 0) (progn
	    (setq bp_alt (Blech.get atKpl bp))
	))
	(if (= zp 1) (progn
	    (setq bp_neu (Blech.get atKpl bp))
		(setq CopyMode (Connect.get CastaData CopyMode))
		(if (= CopyMode 1) (progn
			(if (/= bp_alt bp_neu) (Blech.set cpFlaBlech (bp bp_alt)))
		))
	))
)



; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB FRONT STEG DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl 	(Traeger.get Htrg Abteil KPL_LB))
	(if STEG (setq ht_sb_abtl 	(Traeger.get Htrg Abteil STEG)))
	
	(setq fp_delta_lr_alt (Blech.get FRONT delta_lr))
	
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq fp_delta_lr_neu (- fp_delta_lr_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq fp_delta_lr_neu (+ fp_delta_lr_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
			(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	(if ht_sb_abtl	(Anbauteil.set ht_sb_abtl (delta_lr delta_lr_abtl_neu)))
	
	(Blech.set FRONT (delta_lr fp_delta_lr_neu))
	(print "<------------------------------------------------------------------------------")
)