; $	G(1) 	HT	 QT(IU)	 	AF(S)		P(EZ)
; $ G(1)	AT	 QT(IU) 	AF(K)		P(E)
; $	G(1)	AE	 V(-)		 	H(-)		R(46-90)
; $	G(31) HT	 QT(IU)	 	AF(S)		P(EZ)
; $ G(31)	AT	 QT(IU) 	AF(K)		P(E)
; $	G(31)	AE	 V(-)		 	H(-)		R(-)
; $	HT	QT(IU)	 	AF(S)		P(EZ)
; $ AT	QT(IUKR) 		AF(K)		P(E)
; $	AE	V(-)		 	H(-)		R(-)

(defun load-modules ()
   (load "mod-lochbild")
	 (load "mod-utils")
	 (load "uz_an_uzCoupBlech")
)

(defun init-connection ()

  (print "in init-connection uz_an_uzCoupBlech");
	; (connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	(setq COUPON_TYPE 2) ; 1 = ohne Gurtplatte
											 ; 2 = mit Gurtplatte
											 ; 3 = nur Kontaktplatte
	
	; spitzester Anschlusswinkel zwischen HT und AT
	; -----------------------------------------------------------------
	(setq grenzwinkel 15.0)
	
	(setq h_winkel_atht (Connect.get CastaData h-atrgewnkl_steg))
	
	(if (> h_winkel_atht grenzwinkel)
		(progn
			(print h_winkel_atht)
			(setq max (- 180.0 grenzwinkel))
			(print max)
			(if (> max h_winkel_atht)
				(progn
					(setq qsform_ht (Traeger.get Htrg qsform))
					(print qsform_ht)
					(if (= qsform_ht "U")
						(progn
							(print "QUERSCHNITT: U")
							(if (= (Connect.get CastaData amHtStegLinks) 0)	
								(progn
									(print "STEG LINKS")
									(setConnection)
									(calcHTrgEndeAblaengung_UZ)
								)
							)
						)
						(progn
							(setConnection)
							(calcHTrgEndeAblaengung_UZ)
						)
					)
				)
			)
		)
	)
	
	
)



;########################################################################################
;# CALLBACKS
;########################################################################################

; ----------------------------------------------------------------------------------------
; Kontaktplatte des Coupons wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_cpFrontBlech (zp)
	(print "*clear*")
	(print "CALLBACK: v2 cb_cpFrontBlech <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(print zp)
	(if (objExist Tr_ID) 
		(print "ok")
		(setq zp 100)
	)
	
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_alt   (Blech.get cpFrontBlech dp))
	    (setq Abtl_BL (Traeger.get HTrg ABTeil cpFrontBlech))
	    (setq dlr_Alt 0.0)
	    (if Abtl_BL (progn
	    	(setq dlr_Alt (Anbauteil.get Abtl_BL delta_LR))
	    ))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_neu (Blech.get cpFrontBlech dp))

	    (setq dlr_Neu 0.0)
	    (if Abtl_BL (progn
	    	(setq dlr_Neu (Anbauteil.get Abtl_BL delta_LR))
	    ))
	    
	    (setq dpDiff       0.0)
	    (setq dpDiff_Klemm 0.0)
	    (if (/= dlr_Alt dlr_Neu) (setq dpDiff (+ dpDiff (- dlr_Neu dlr_Alt))))
	    (if (/= dp_alt  dp_neu)  (setq dpDiff (+ dpDiff (- dp_neu dp_alt))))
	    (if (/= dp_alt  dp_neu)  (setq dpDiff_Klemm (- dp_neu dp_alt)))
	    
		(print dp_alt) 
		(print dp_neu)
	    
	    (if (/= dpDiff 0.0) (progn
			(if (objExist cplchb) (progn
				(setq alteKlemml  (Lochbild.get cplchb Klemml))
				(setq altesDxS	  (Lochbild.get cplchb dxsKopf))
				   
				(Lochbild.set	cplchb 	(Klemml (+ alteKlemml dpDiff_Klemm))
						; (DxSKopf (+ altesDxS dpDiff)) ;; weil Kpl jetzt Master ist
						(callbackfl 1)
				)
			))
						
			; derzeit nicht erforderlich
			; (Connect.storeCallbackObjs CastaData cplchb)	; als Callback-Objekt speichern
						
			(print dpDiff)
			(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
			(print At_Ende)
			(TrEnde.ptrim At_Ende dpDiff)
			(Connect.set CastaData (htModify 1))
		
	    ))

	    (if (/= dlr_Alt dlr_Neu) (progn
			(if (objExist cpStegBlech) (progn
				(setq bpStegBl (Blech.get cpStegBlech bp))
				(setq bpStegBl (+ bpStegBl (- dlr_Neu dlr_Alt)))
				(Blech.set cpStegBlech (bp bpStegBl))
				(setq bp_alt bpStegBl)		; damit es nicht zum Zirkelbezug kommt - 
			))
			(if (objExist cpFlaBlech) (progn
				(setq bpFlaBl (Blech.get cpFlaBlech bp))
				(setq bpFlaBl (+ bpFlaBl (- dlr_Neu dlr_Alt)))
				(Blech.set cpFlaBlech (bp bpFlaBl))
			))
	    ))

	))
)
; ----------------------------------------------------------------------------------------
; Stegplatte des Coupons wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_cpStegBlech (zp)
	(print "CALLBACK: cb_cpStegBlech <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(if (objExist Tr_ID) 
		(print "ok")
		(setq zp 100)
	)
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq bp_alt_Steg (Blech.get cpStegBlech bp))
	    (setq hp_alt_Steg (Blech.get cpStegBlech hp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq bp_neu_Steg (Blech.get cpStegBlech bp))
	    (setq hp_neu_Steg (Blech.get cpStegBlech hp))
	    
	    (print bp_alt_Steg) (print bp_neu_Steg)
	    
		
	    (if (/= bp_alt_Steg bp_neu_Steg) 
				(progn
					(setq bpDiff (- bp_neu_Steg bp_alt_Steg))
					(if (= (Connect.get CastaData linkesEnde)  1)	(setq At_Ende (Traeger.get Tr_ID links)))
					(if (= (Connect.get CastaData rechtesEnde) 1)	(setq At_Ende (Traeger.get Tr_ID rechts)))
					(print At_Ende)
					(TrEnde.ptrim At_Ende bpDiff)
					
					(if (objExist cpFlaBlech) (progn
						(setq bpFlagBl (Blech.get cpFlaBlech bp))
						(Blech.set cpFlaBlech (bp (+ bpFlagBl bpDiff)))
					))
					(setq Abtl_BL (Traeger.get HTrg ABTeil cpFrontBlech))
					(if Abtl_BL (progn
						(setq dlr_Alt (Anbauteil.get Abtl_BL delta_LR))
						(Anbauteil.set Abtl_BL (delta_LR (+ dlr_Alt bpDiff)))
					))
					
				)
		)
	    (if (/= hp_alt_Steg hp_neu_Steg) (progn
			(setq hc_HT (Traeger.get HTrg hc))
			(if (= hc_HT 0.0) (progn
				(setq t_HT (Traeger.get hTrg t) r_HT (Traeger.get hTrg r) h_HT (Traeger.get HTrg h))
				(setq hc_HT (- h_HT t_HT t_HT r_HT r_HT))
			))
			(if (> hp_neu_Steg hc_HT) (progn
				(setq X1 (Blech.get cpStegBlech x1)
					  Y1 (Blech.get cpStegBlech y1)
				)
				(Blech.set cpStegBlech (x2 X1) (y2 Y1))
			))
		))
	))
)

; ----------------------------------------------------------------------------------------
; Kopfplatte wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_atKpl (zp)
	(print "CALLBACK: cb_blKopfplatte <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_alt (Blech.get atKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_neu (Blech.get atKpl dp))
	    
	    (print dp_alt) (print dp_neu)
	    
	    (if (/= dp_alt dp_neu) 
			(progn
				(setq dpDiff (- dp_neu dp_alt))
				(if (objExist cplchb) (progn
						(setq alteKlemml	(Lochbild.get cplchb Klemml))
						(setq altesDxS		(Lochbild.get cplchb dxsKopf))
				   
						(Lochbild.set cplchb 	(Klemml (+ alteKlemml dpDiff))
									; (DxSKopf (+ altesDxS dpDiff))
									(callbackfl 1)
						)
						(if (objExist cpStegBlech) 
							(cbDeltaLR cplchb cpFrontBlech cpStegBlech cpFlaBlech dpDiff)
							(cbDeltaLR cplchb cpFrontBlech 0 cpFlaBlech dpDiff)
						)
				))
					
				(Connect.set CastaData (htModify 1))
			)
		)
	))
)

; 2018-08 - eigentlich Dummy-Funktion, weil Gurtblech in diesem Anschluss eher nicht vorkommt
(defun cb_cpFlanschBlech (zp)
	(print  "Aufruf  cb_cpFlanschBlech")
	(if (objExist Tr_ID) 
		(print "ok")
		(setq zp 100)
	)
	(if (= zp 0) (progn
	    (setq bp_alt_Flansch (Blech.get cpFlaBlech bp))
	))
	(if (= zp 1) (progn
	    (setq bp_neu_Flansch (Blech.get cpFlaBlech bp))
		(setq CopyMode (Connect.get CastaData CopyMode))
		(if (= CopyMode 1) (progn
			(Blech.set cpFlaBlech (bp bp_alt_Flansch))

			(if (objExist cpStegBlech) (progn
				(setq t_HT (Traeger.get HTrg t))
				(setq h_StegBl (Blech.get cpStegBlech hp))
				(setq  dOK_GurtBl (+ t_HT h_StegBl))
				(Blech.set cpFlaBlech (dOK  dOK_GurtBl))
			))
		))
	))
)

; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB FRONT STEG GURT DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl 	(Traeger.get Htrg Abteil KPL_LB))
	(setq ht_sb_abtl 	(Traeger.get Htrg Abteil STEG))
	(setq ht_ug_abtl 	(Traeger.get Htrg Abteil GURT))
	
	(setq fp_delta_lr_alt (Blech.get FRONT delta_lr))
	
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq fp_delta_lr_neu (- fp_delta_lr_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq fp_delta_lr_neu (+ fp_delta_lr_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
			(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	(if ht_sb_abtl	(Anbauteil.set ht_sb_abtl (delta_lr delta_lr_abtl_neu)))
			(Anbauteil.set ht_ug_abtl (delta_lr delta_lr_abtl_neu))
	
	(Blech.set FRONT (delta_lr fp_delta_lr_neu))
	(print "<------------------------------------------------------------------------------")
)