(defun load-modules ()
   (load "mod-lochbild")
)

(defun init-connection ()

  (print "in init-connection uz_an_uzCoup");
	(connect.showattributes CastaData)
	(setq LB_DEBUG 0)
	
	
	(setConnection)
	
)

(defun setConnection ()
	;(connect.showattributes CastaData)
	  
  (setq blKopfplatte 	(Blech.create))
  (setq lochb					(Lochbild.create))
  (setq couponTrg 		(Traeger.create))
  (Connect.storeAnschlObjs CastaData blKopfplatte lochb couponTrg)
  
  (setq ueberstand 10) ; berstand des Coupons zum Schweien an HT-Flansch
  (setq dp_Kpl 10)
  
  ; Erzeugen des Coupons
  (createCoupon ueberstand)
  
	; Krzen des AT
	(kuerzeTraeger ueberstand)
	
	
	
  (if (= 1 2) (progn
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(progn
			(kuerzeTraeger TrLinks ueberstand)
			(calcAndSetBlechdaten blKopfplatte TrLinks)
			(traeger.addabtl Tr_ID blKopfplatte 0.0 0.0 _kopfplattelinks_)
			(calcAndSetLochbildDaten lochb couponTrg blKopfplatte ueberstand)
			(traeger.addabtl Tr_ID lochb 0.0 0.0 _kpllochbildlinks_)
		)
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(progn
			(kuerzeTraeger TrRechts ueberstand)
			(calcAndSetBlechdaten blKopfplatte TrRechts)
			(traeger.addabtl Tr_ID blKopfplatte 0.0 0.0 _kopfplatterechts_)
			(calcAndSetLochbildDaten lochb couponTrg blKopfplatte ueberstand)
			(traeger.addabtl Tr_ID lochb 0.0 0.0 _kpllochbildrechts_)
		)
	)
	
	


	; Lochbild am HT
	(calcLochbildXPos)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)  (progn
		(traeger.addabtl HTrg lochb xPos 0.0 _couponlochbild_links_)
  ))
  (if (= (Connect.get CastaData amHtStegRechts) 1)  (progn
   (traeger.addabtl HTrg lochb xPos 0.0 _couponlochbild_rechts_)
  )) 
	
	; Wenn der Anschluss an HT-Ende stattfindet
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			(setq bp_blech (Blech.get blKopfplatte bp))
			(if (= (Connect.get CastaData anhtlinkesEnde) 1)
				(progn
					(setq HTLinks 	(Traeger.get Htrg Links))
					(korrTraegerEnde HTLinks bp_blech couponTrg)
				)
			)
			(if (= (Connect.get CastaData anhtrechtesEnde) 1)
				(progn
					(setq HTRechts	(Traeger.get Htrg Rechts))
					(korrTraegerEnde HTRechts bp_blech couponTrg)
				)
			)			
		)
	)
		
	(setq Abtl_KplLchb_ht (traeger.get Htrg ABTeil lochb))
  (Anbauteil.set Abtl_KplLchb_ht (Master 1))
  (setq Abtl_KplLchb_at (traeger.get Tr_ID ABTeil lochb))
  (Anbauteil.set Abtl_KplLchb_at (Master 0)
  															 (delta_v delta_v_lb_at)
  )
  
  ; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lochb)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
    	)
	    (if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)	
																(delta_v delta_v_lb_at)
			)
		)
		
))

		
	)
	;===================================================================
  
  ; CALLBACKS
  (Traeger.set couponTrg 	(formFkt "cb_couponTrg"))
  (Blech.set blKopfplatte (formFkt "cb_blKopfplatte")) 
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Coupon-Profil wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_couponTrg (zp)
	(print "in Callback-Funktion cb_couponTrg")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq t_alt (Traeger.get couponTrg t))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq t_neu (Traeger.get couponTrg t))
	    
	    (print t_alt) (print t_neu)
	    
	    (if (/= t_alt t_neu) (progn
	       (setq tDiff (- t_neu t_alt))
	       (setq alteKlemml (Lochbild.get lochb Klemml))
	       ;(setq altesDxS		(Lochbild.get lchbKpl dxsKopf))
	       
	       (Lochbild.set lochb 	(Klemml (+ alteKlemml tDiff))
	       												;(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
)

; ----------------------------------------------------------------------------------------
; Kopfplatte wird verndert
; ----------------------------------------------------------------------------------------
(defun cb_blKopfplatte (zp)
	(print "in Callback-Funktion cb_blKopfplatte")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dp_alt (Blech.get blKopfplatte dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dp_neu (Blech.get blKopfplatte dp))
	    
	    (print dp_alt) (print dp_neu)
	    
	    (if (/= dp_alt dp_neu) (progn
	       (setq dpDiff (- dp_neu dp_alt))
	       (setq alteKlemml (Lochbild.get lochb Klemml))
	       (setq altesDxS		(Lochbild.get lochb dxsKopf))
	       
	       (Lochbild.set lochb 	(Klemml (+ alteKlemml dpDiff))
	       											(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
)

; ---------------------------------------------------------------------
; krzt den Anschlusstrger
; ---------------------------------------------------------------------
(defun kuerzeTraeger (ueberstand)
	(print ">-------------------------------------------------------------------------------")
	(print "KRZE TRGER")
	(setq h_ht 				(Traeger.get Htrg h)
				b_ht				(Traeger.get Htrg b)
				delta_v_ht 	(Traeger.get Htrg delta_v)
	)
	
	(setq at_v_winkel (Connect.get CastaData at_laengswinkel))
	(setq at_h_winkel (Connect.get CastaData at_rotawinkel))
	
	(if (= (Connect.get CastaData linkesEnde)	1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	; AT-ENDE Winkel
	; ----------------------------------------------
	(setq v_atEndWnkl (Connect.get CastaData v-atrgewnkl_steg))
	(setq h_atEndWnkl (Connect.get CastaData h-atrgewnkl_steg))
	(print v_atEndWnkl)
	(print h_atEndWnkl)
	
	
	; Ablngung
	; ----------------------------------------------
	(setq delta_l_ende 0.0)
	
	(if (= (Connect.get CastaData amHtSteg) 1)		 (setq delta_l_ende (+ delta_l_ende (* 0.5 b_ht))))
	(if (= (Connect.get CastaData amHtFlansch) 1)  (setq delta_l_ende (+ delta_l_ende (* 0.5 h_ht))))
	
	
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq delta_l_ende (- delta_l_ende delta_v_ht)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq delta_l_ende (- delta_l_ende delta_v_ht )))
		)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq delta_l_ende (+ delta_v_ht delta_l_ende)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq delta_l_ende (+ delta_v_ht delta_l_ende)))
		)
	)
	
	
	
	(TrEnde.set AT_Ende (h_winkel h_atEndWnkl)
											(v_winkel v_atEndWnkl)
											(delta_l	0)
	)
	(TrEnde.ptrim AT_ENDE (+ delta_l_ende ueberstand))
	(print "<-----------------------------------------------------------")
)





; ----------------------------------------------------------------------------------------
; Berechnet die Blechdaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)

  (print "----------------------------- In calcAndSetBlechdaten")
	(setq h_trg (Traeger.get Tr_ID h)
				t_trg (Traeger.get Tr_ID t)
				b_trg	(Traeger.get Tr_ID b)
	)
	
	(calcUnterschied)
		
	;(if (>= diff_oben 0.0)
	;	(progn
	;		(if (<= diff_unten 0.0)
	;			(progn
	;				(setq dOK (* 0.5 t_trg))
	;				(setq hp_kpl (- h_trg t_trg ))
	;			)
	;			(progn
	;				(setq dOK (* 0.5 t_trg))
	;				(setq hp_kpl (- (- h_trg t_trg ) diff_unten))
	;			)
	;		)			
	;	)
	;	(progn
	;		(if (<= diff_unten 0.0)
	;			(progn
	;				(setq dOK (- (* 0.5 t_trg) diff_oben))
	;				(setq hp_kpl (+ (- h_trg t_trg ) diff_oben))
	;			)
	;		)
	;	)
	;)
	      
	(setq bp b_trg)
	
	; dok
	(setq t_halb (* 0.5 t_trg))
	;(setq dok (runde t_halb auf 5.0))
	(setq dok t_halb)
	
	(setq hp (- h_trg dok dok))
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp dp_Kpl) 
													(hp hp) 
													(bp bp) 
													(dOK dOK)
	)
	
	(TrEnde.pTrim TrgEnde dp_Kpl)
)


; ---------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ---------------------------------------------------------------------------------



; ---------------------------------------------------------------------------------
; Korregiert das Traegerende des HT, wenn Anschluss am HT-Ende
; ---------------------------------------------------------------------------------
(defun korrTraegerEnde (TrgEnde bp Coupon)
	(print "KORREGIERE HT-ENDE ...")
	
	(setq afl_winkel (Connect.get CastaData afl_hwinkel))
	(print afl_winkel)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq hscherl_at (TrEnde.get AtEnde hscherl))
	
	(setq hscherl_halb (* 0.5 hscherl_at))
		
	(setq b_ht_halb (* 0.5 b_ht))
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	(print tanafl)
	(if (< tanAfl 0.0)	(setq tanAfl (- tanAfl)))
	(print tanafl)
	
	(setq verl_1 (/ b_ht_halb tanafl))
	(print verl_1)
	
	(setq delta_l_ht (+ verl_1 hscherl_halb))
	(print delta_l_ht)
	
	(TrEnde.set TrgEnde (delta_l (- delta_l_ht)))
	
	(print "KORREKTUR FERTIG")
)
; ====================================================================== 


;***************************************************************************
; Erzeugt Coupon am HT
;***************************************************************************
(defun createCoupon (ueberstand)
	(print "______________________")
	(print "IN createCoupon")
		
	;Daten des AT
	(setq at_Breite 	(Traeger.get Tr_ID b))
	(print at_Breite)
	
	;Daten des HT
	(setq ht_hoehe 		(Traeger.get HTrg h)
				ht_steg			(Traeger.get HTrg s)
				t_htrg			(Traeger.get Htrg t)
				ht_breite		(Traeger.get HTrg b)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				hWnkl				(Traeger.get HTrg hpttrg_vwinkel)
				qsform_ht		(Traeger.get Htrg qsform)			
	)
		
	;Daten der Steife
	(setq steife_b (* 0.5 (- ht_breite ht_steg)))
	(print steife_b)
	
	(setq xpos1 (Connect.get CastaData xPos_AT))
	
; ---- mal rausgenommen um erst einmal den Copon mit Profil einbzubauen	
;	(setq blSteife1 (blech.create))
;	(Blech.set blSteife1 (dp 10) (hp ht_hoehe) (bp steife_b) )
;	(traeger.addabtl HTrg blSteife1 0.0 0.0 _vollsteife_rechts_)
;	(setq AbtlSteife_1 (traeger.get HTrg ABTeil blSteife1))
;	(Anbauteil.set  AbtlSteife_1 (xpos xpos1) )
	
	; Coupon an den Haupttrger anbauen
  (print "---------------------------------------- Coupon neu - hier einbauen!")
  ; syslng - maximal Abstand zwischen den Flanschen
  ; delta_L am linken Trgerende - Abstand von oben - also meist Flanschdicke
  ; h - Abstand Stegflche zur Schraubenflche (Oberflansch des Coupons)
 	
 	
	(setq coup_l	(- ht_hoehe t_htrg ))
	
	(if (= qsform_ht "U")
		(setq coup_h	(- ht_breite ht_steg))
		(setq coup_h	(* 0.5 (- ht_breite ht_steg)))
 	)
 	
 	(setq prof 					(Traeger.get Tr_ID Profil)
 				delta_lr_trg	(Traeger.get Tr_ID delta_lr)
 				r_wnkl_trg		(Traeger.get Tr_ID r_winkel)
 	)
 	(print prof)
 	;Berechnung der XPos
 	(setq xpos (Connect.get CastaData xpos_ht))
 	(print xpos)
 	 	(setq h_wnkl (Connect.get CastaData afl_hwinkel))
 	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq h_Wnkl (- 180.0 h_Wnkl))
	)
	(print h_Wnkl)
	(setq tanW (tan (/ (* PI h_wnkl) 180.0)))
	(setq sinW (sin (/ (* PI h_wnkl) 180.0)))
	(print sinW)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(setq delta (+ (* 0.5 ht_breite) ueberstand dp_Kpl delta_lr_ht))
			(setq xpos (+ xpos (/ delta tanW)))
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(setq delta (+ (* 0.5 ht_breite) ueberstand dp_Kpl (- delta_lr_ht)))
			(setq xpos (- xpos (/ delta tanW)))
		)
	)
 	(print xpos)
 	(setq versch_aus_delta_lr_trg (/ delta_lr_trg sinW))
 	(print versch_aus_delta_lr_trg)
 	
 	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq xpos (- xpos versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq xpos (+ xpos versch_aus_delta_lr_trg)))
		 		)
		 	)
		 	(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq xpos (+ xpos versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq xpos (- xpos versch_aus_delta_lr_trg)))
		 		)
		 	)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq xpos (+ xpos versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq xpos (- xpos versch_aus_delta_lr_trg)))
		 		)
		 	)
		 	(if (= (Connect.get CastaData rechtesEnde) 1)
				(progn
		 			(if (= r_wnkl_trg   0.0) (setq xpos (- xpos versch_aus_delta_lr_trg)))
		 			(if (= r_wnkl_trg 180.0) (setq xpos (+ xpos versch_aus_delta_lr_trg)))
		 		)
		 	)
		)
	)
 	(print xpos)
 	;(setq xPos (- xPos versch_aus_delta_lr_at))
 	; TODO
 	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 	; Wenn der Coupon aus einen Trgerprofil erstellt wird, knnen die Abmessungen
 	; nicht frei whlbar sein, da sie vom Profil anhngen.
 	; Wird hier allerdings erstmal ignoriert!
 	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
 	(Traeger.set couponTrg (Profil prof)
                         (syslng coup_l)
                         (h      (+ coup_h ueberstand))
  )
  
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Traeger.set couponTrg (delta_v (- (* 0.5 ht_steg) delta_lr_ht)))
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= qsform_ht "U")
				(Traeger.set couponTrg (delta_v (+ ht_steg delta_lr_ht)))
				(Traeger.set couponTrg (delta_v (+ (* 0.5 ht_steg) delta_lr_ht)))
			)
		)
	)
	
	
  (setq cpELinks (Traeger.get couponTrg links))
  (TrEnde.set cpELinks 	(delta_L t_htrg))
  
  
  
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)  
	      (traeger.addabtl hTrg couponTrg xpos 0.0 _couponprofil_links_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)  
	      (traeger.addabtl hTrg couponTrg xpos 0.0 _couponprofil_rechts_)
	)
	
	
	(Traeger.updvollstf HTrg)
)

; --------------------------------------------------------------------
; BERECHNET DIE XPOSITION DES LOCHBILDS AM HT
; --------------------------------------------------------------------


; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	(print ">-------------------------------------------------------------------------------")
	(setq h_ht				(Traeger.get Htrg h)
				t_ht				(Traeger.get Htrg t)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				t_at				(Traeger.get Tr_ID t)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_v_ht h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))							(print uKante_ht)
	(setq oKante_at	(- delta_v_at h_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))							(print uKante_at)
	
	
		
	(setq diff_oben (- oKante_at oKante_ht))
	(setq diff_unten (- uKante_at uKante_ht))
	
	(print diff_oben)
	(print diff_unten)
	
	
	(if (> diff_oben 0.0)
		(progn
			(if (< diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_at (* 2.0 t_at))))
			(if (= diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_at t_at t_ht)))
			(if (> diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- (- uKante_ht oKante_at) t_ht t_at)))
		)
	)
	(if (< diff_oben 0.0)
		(progn
			(if (< diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- (- uKante_at oKante_ht) t_ht t_at)))
			(if (> diff_unten 0.0)	(setq verfuegbarer_LB_bereich (- h_ht (* 2.0 t_ht))))
		)
	)
	(if (= diff_oben 0.0)
		(setq verfuegbarer_LB_bereich (- h_at t_at t_ht))
	)
	(print verfuegbarer_LB_bereich)
		
	(print "<-------------------------------------------------------------------------------")
)