; $ G(23)	HT	QT(IU)		AF(S)		P(EZ)
; $ G(23)	AT	QT(T)		AF(K)		P(E)
; $ G(23)	AE	V(90)		H(90)		R(46-135)
; $ G(30)	HT	QT(F)		AF(F)		P(EZ)
; $ G(30)	AT	QT(I)		AF(K)		P(E)
; $ G(30)	AE	V(90)		H(90)		R(46-135)
; $ 		HT	QT(F)		AF(S)		P(EZ)
; $ 		AT	QT(IUT)		AF(K)		P(E)
; $ 		AE	V(90)		H(90)		R(46-135)

(defun load-modules ()
   (load "mod-endinit-uz-uzflansch")
   (load "mod-connection")
   (load "mod-lochbild")
)

(defun init-connection ()
	
	(setq LB_DEBUG 0)
	
	(print "*clear*")
	(Connect.showAttributes CastaData)
	
  (print "BEGIN init-connection uz_an_uzStegMitWinkeln");
  (setq rwinkel_at (Traeger.get Tr_ID r_winkel))
  
  (setq anz_Anschl (Connect.get CastaData anz_weitere_Anschl))
  (print anz_Anschl)
  (if (> anz_Anschl 0)
  	(progn
  		;(checkForSteifen)
  	)
  )
  
  ;(if (/= rwinkel_at 0.0)
  ;	(print "Bitte setzen Sie den Rotationswinkel des Anschlusstrgers auf 0."   "Set_RotAngle_AT_To_Zero")
		(setConnection)
	;)
	
	
  (print "END init-connection uz_an_uzStegMitWinkeln");
)

(defun setConnection ()
	(trimmeTrgEnde)
;	(TraegerAusklinkung  205 80)
  ; linkes und rechtes AT-Ende festlegen  
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
	; Anbauteile bereitstellen
	(setq winkel_blech	(Winkel.create))
	(setq lchbAtrgSteg (lochbild.create))
	(Connect.storeAnschlObjs CastaData winkel_blech lchbAtrgSteg)
  
  (setq test (Connect.get CastaData exist_steglchb))
  (print test)
  
  (if (= (Connect.get CastaData exist_steglchb) 1)
  	(progn
  		(setq lchbWnkl	(Connect.get CastaData steglchb_gegen))
  	)
  	(progn
			(setq lchbWnkl (lochbild.create))
		)
	)
  (Connect.storeAnschlObjs CastaData lchbWnkl)
  
  ; Winkeldicke festlegen
	(setq wnkl_dw 8)

	(if (= (Connect.get CastaData LinkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData RechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
  
  
  ; Winkel erzeugen
	(createWinkel AT_Ende winkel_blech)
	
	(if (= (Connect.get CastaData exist_steglchb) 1)
  		(getExistingLochbild)								; nur bernehmen und lokal anpassen
  		(progn												; else-Teil
			(createLochbildAbtl AT_Ende winkel_blech)
		)
	)	
	
	; CALLBACKS
	(Winkel.set winkel_blech (formFkt "cb_winkel"))
	
	; Einstellungen fr Fassadenprojekt Gandt
	(if (= 2 2) (progn
		(Winkel.set winkel_blech	(l 115))
		(Lochbild.set lchbWnkl  (w0 96)
								(e0 (+ zAkl 30))
								(e1 55)
		)
		(Lochbild.set lchbAtrgSteg  (w0 45)
								(e0 (+ zAkl 30))
								(e1 55)
		)
	))
	
	(if (= 1 2) (progn
		(Lochbild.set lchbWnkl (S_Bez "M20"))
	))
	(if (= 1 2) (progn
		;; Testen - AF-20090513
		(Lochbild.set lchbWnkl (LB_Art   2))		; AF-20090512
		(Lochbild.set lchbWnkl (delta_w  0))		; AF-20090512
		(Lochbild.set lchbWnkl (e    "0 30 100 0 0 0"))	; AF-20090512
		(Lochbild.set lchbWnkl (w    "23 40"))		; AF-20090512

;		(setq ht_lochbild_abtl (Traeger.get Htrg Abteil lchbWnkl))
;		(setq dummy_delta_lr (Anbauteil.get ht_lochbild_abtl delta_lr))
;		(print dummy_delta_lr)
	))

)
(defun XXX ()  
	
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlZwHtEnden) 0)
			(korrHtEnde winkel_blech)
		)
	)
	
	; Ablngung korrigieren, weil hier auch Knirsch-Ablngungen vorkommen knnen
	; Bei Winkelanschlssen sollte hier ein Spalt bestehen bleiben
	(korrigiereAblaengung)

	
	; CALLBACKS
	(Winkel.set winkel_blech (formFkt "cb_winkel"))
	
	(setq lbTest (Lochbild.get lchbAtrgSteg dxskopf))
	(print lbtest)
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Winkel am AT
; ----------------------------------------------------------------------------------------
(defun cb_winkel (zp)
	(print "in Callback-Funktion cb_winkel")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dwAlt (Winkel.get winkel_blech dw))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dwNeu (Winkel.get winkel_blech dw))
	    
	    (print dwAlt) (print dwNeu)
	    
	    (if (/= dwAlt dwNeu) (progn
	       (setq dwDiff (- dwNeu dwAlt))
	       
	       (setq alteKlemml (Lochbild.get lchbWnkl Klemml))
	       (setq dxsKopf_alt	(Lochbild.get lchbWnkl dxSKopf))
	      	
	       
	       (if (= (Connect.get CastaData amHtOberflansch) 1)
	       	 (setq dxsKopf_neu (+ dxsKopf_alt dwDiff))
	       )
	       (if (= (Connect.get CastaData amHtUnterflansch) 1)
	       	 (setq dxsKopf_neu dxsKopf_alt)
	       )
	             
	       (print dxsKopf_alt)
	       (print dxsKopf_neu)
	       
	       (Lochbild.set lchbWnkl 	(Klemml (+ alteKlemml dwDiff))
	       							(dxSKopf	dxsKopf_neu)
	       )
	       
	       ; am AT-Steg
	       (setq alteKlemml_at 	(Lochbild.get lchbAtrgSteg Klemml))
	       (setq dxsKopf_alt_at	(Lochbild.get lchbAtrgSteg dxSKopf))
	       (setq t_ht			(Traeger.get Htrg t))
	       (print dxsKopf_alt_at)
	       
	       (setq dxsKopf_neu_at 0)
	       (if (= (Connect.get CastaData amHtStegLinks) 1) (setq dxsKopf_neu_at (+ dxsKopf_alt_at dwDiff)))
	       (if (= (Connect.get CastaData amHtStegRechts) 1) (setq dxsKopf_neu_at t_ht))
	       
	       (print dxsKopf_neu_at)
	       
	       (Lochbild.set lchbAtrgSteg 	(Klemml (+ alteKlemml_at (* 2.0 dwDiff)))
	       								(dxSKopf	dxsKopf_neu_at)
	       )
	    ))
	))
)

; --------------------------------------------------------------------------
; Berechnet die Daten der Winkel
; --------------------------------------------------------------------------
(defun calcAndSetWinkeldaten (wnklAnbTeil TrgEnde)

  (print "----------------------------- In calcAndSetWinkeldaten")

	(setq 	zAkl     		(trEnde.get TrgEnde zakl)
			xAkl	 		(trEnde.get TrgEnde xakl)
			hSteg    		(trEnde.get TrgEnde hsteg)
	)
	
	(setq 	bHtrg		 	(Traeger.get Htrg b)
			delta_lr_ht		(Traeger.get Htrg delta_lr)
			qsform_ht		(Traeger.get Htrg qsform)
			delta_v_ht		(Traeger.get Htrg delta_v)
	)
	
	(setq	hProf    		(Traeger.get Tr_ID h)
			sAnProf  		(Traeger.get Tr_ID s)
			hcAnProf 		(Traeger.get Tr_ID hc)
			bProf		 	(Traeger.get Tr_ID b)
			t_at			(Traeger.get Tr_ID t)
			r_at			(Traeger.get Tr_ID r)
			delta_v_at		(Traeger.get Tr_ID delta_v)
			qsform_at		(Traeger.get Tr_ID qsform)
	)
	
	
	; Vorbereitung zu Bestimmung der Winkelhhe
	; ------------------------------------------------------------------
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< wnkl_dw sAnProf)
		(setq min_bl wnkl_dw)
		(setq min_bl sAnProf)
	)
	(setq S_Bez "M16")
	(calcSchraube min_bl) 	; -> S_Bez
	
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set lchbAtrgSteg (S_Bez S_Bez))
	(Lochbild.set lchbWnkl     (S_Bez S_Bez))
	
	; default Rand- und Lochabstnde aus Schraubendurchmesser bestimmen
	(calcMinRandLochAbst lchbAtrgSteg)	; -> e_min_rund, e1_min_rund, min_h
	; ->
	(print min_h)
	(setq wnkLng min_h)
	(print wnkLng)
		
	; wenn die min. Winkelhhe fr 4 Schrauben grer als die verfgbare Steglnge am AT ist,
	; wird die Winkelhhe auf die verfgbare Steglnge am AT gesetzt.
	(if (> hcAnProf 40) (progn
		(if (> wnkLng hcAnProf) (setq wnkLng hcAnProf))
	))
	; ->
	(setq dOK (* 0.5 (- hProf wnkLng)))
		
		

	; Blechhhe und dok bei Ausklinkung
	(if (/= hsteg 0.0)							
		(progn
			(print "hsteg /= 0")
			(if (/= zakl 0.0)						; unten und oben
				(progn
					(print "zakl /= 0")
					(if (> wnkLng hsteg)
						(setq wnkLng hsteg)
					)
					;(setq dOK (* 0.5 (- hProf wnkLng)))
					(setq dOK (+ zakl (* 0.5 (- hsteg wnkLng))))
				)													; nur unten
				(progn
					(print "zakl = 0")
					(setq verf_steg_l (- hProf t_at r_at (- hProf hsteg)))
					(if (>= wnkLng verf_steg_l)
						(progn
							(setq wnkLng verf_steg_l)
							(setq dok (+ t_at r_at))
						)
						(progn
							(setq diff_vsl_wl (- verf_steg_l wnkLng))
							(setq dok (+ t_at r_at (* 0.5 diff_vsl_wl)))
						)
					)
				)
			)
		)
		(progn
			(print "hsteg = 0")
			(if (/= zakl 0.0)						; nur oben
				(progn
					(print "zakl /= 0")
					(setq verf_steg_l (- hProf t_at r_at zakl))
					(if (>= wnkLng verf_steg_l)
						(progn
							(setq wnkLng verf_steg_l)
							(setq dok zakl)
						)
						(progn
							(setq diff_vsl_wl (- verf_steg_l wnkLng))
							(setq dok (+ zakl (* 0.5 diff_vsl_wl)))
							
							(setq dOK zAkl)
							(setq wnkLng (- hProf t_at r_at dOK 5.0))
						)
					)
				)													; keine
				(progn
					(print "zakl = 0")
				)
			)
		)
	)
  	
	 	
	;(if (= qsform "U")
	;	(if (= (Connect.get CastaData amHtStegLinks) 1)
	;		(setq dOK    5 hp (- hProf 10))		; keine Ausklinkung
	;	)
	;)
	
	(setq t_HtProf (Traeger.get HTrg t))
	; muss jetzt noch berprft werden, ob es sich um ein U oder I-Profil handelt,
	; ggflls auch Kastenprofil - Rohre erst einmal nicht
	(setq t_HtProf_halb (* 0.5 t_HtProf))
	      
	; Berechnung der Schenkellngen
	;(setq slk_std (* 0.5 (- bProf sAnProf)))	; Teil am HT
	(setq slk_std (+ (* e_min_rund 2.0) wnkl_dw))
	;(setq sll_std (+ (* 0.5 bHtrg) 10))				; Teil am AT
	(setq sll_std (+ (* 2.0 e1_min_rund) wnkl_dw))

	(setq dv_HT (Traeger.get HTrg delta_V))
	(setq AchsAbstand t_HtProf_halb)
    (if (= (Connect.get CastaData amHtOberflansch ) 1) (progn
		(setq AchsAbstand (- AchsAbstand dv_HT))
	))
    (if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(setq AchsAbstand (+ AchsAbstand dv_HT))
	))

	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Winkel.set wnklAnbTeil (wanz 	 	2)
				(l 	 		wnkLng)
				(sll 	 	sll_std)
				(slk 	 	slk_std)
				(dw 	 	wnkl_dw)
				(wabst 	 	sAnProf)
				(achsab		AchsAbstand)
				(dok 	 	dOK)
				(delta_x 	0.0)
				(lage 	 	1)
				(schhoriz	100.000000)
				(Profil		"L80*8")
	)

	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(Winkel.set wnklAnbTeil (achsab (+ t_HtProf delta_lr_ht)))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(Winkel.set wnklAnbTeil (achsab (- 0 delta_lr_ht)))
			)
		)
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(Winkel.set wnklAnbTeil (achsab (+ t_HtProf_halb delta_lr_ht)))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(Winkel.set wnklAnbTeil (achsab (- t_HtProf_halb delta_lr_ht)))
			)
		)
	)
	
)

; --------------------------------------------------------------------
; Berechnet die Lochbilddaten am Haupttrger
; --------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde WinkelID)
	
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN VERBINDUNG HT")
	;Basiseinstellungen (evtl. weglassen und Gren in Abhngigkeit anderer Gren berechnen)
	(Lochbild.set Lchb_ID 	(Anz_S    4)
							(Guete   "4.6")
							(e       "100 0 0 0 0 0")
							(w       "40  0")									
	)
	
	(setq 	Wnkl_L		(Winkel.get WinkelID l)
			slk_W		(Winkel.get WinkelID slk)
			dw_W		(Winkel.get WinkelID dw)
			dok_W		(Winkel.get WinkelID dok)
	)
	(setq	h_trg		(Traeger.get Tr_ID h)
			hc_trg		(Traeger.get Tr_ID hc)
			s_trg		(Traeger.get Tr_ID s)
			delta_v_at	(Traeger.get Tr_ID delta_v)
			qsform_at	(Traeger.get Tr_ID qsform)
	)
	(setq	hc_htrg 	(Traeger.get Htrg hc)
			t_htrg  	(Traeger.get HTRG t)
			delta_v_ht	(traeger.get Htrg delta_v)
			h_ht		(Traeger.get Htrg h)
	)
	
	(print dok_W)
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq l_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	; berprfen, welches hc magebend ist
	(if (> hc_htrg hc_trg)
		(setq hc hc_trg)
		(setq hc hc_htrg)
	)
		
	
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	(if (> l_aus_e Wnkl_L)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq l_aus_e (* e_blech_rund 2.0))
			(setq VIER 0) 
		)
	)
	
	
	(setq w0 (+ (* 0.5 s_trg) (* (+ dw_W e_blech_rund) 2.0)))					; Randabstand
	(setq w0rund (runde w0 auf 5))
		
	
	(calcUnterschied)
	
	(setq diff (- l_aus_e Wnkl_L)) ; Differenz zwischen alter und neuer Winkelhhe
	(setq dok_w (- dok (* 0.5 diff) ))
	
	(print VIER)
	
	(print dok_w)
	(print l_aus_e)
	
	(if (= VIER 1)
		(progn
			(setq e0 (+ dok_w (* 0.25 l_aus_e)))
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			(Lochbild.set Lchb_ID (e0 e0) 
														(e1 e1_blech_rund)
														(w0 w0rund)								
			)
			(if (= LB_DEBUG 1)
				(Lochbild.set Lchb_ID (e2 300))
			)
		)
		(progn
			(setq e0 (+ dok_w (* 0.5 l_aus_e)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID	(e0 e0)
						(e1 0) 										
						(w0 w0rund)
			)
		)
	)
	
	(setq w0rund (runde (+ s_trg slk_W 10.0) au 10))
	(Lochbild.set Lchb_ID (w0 w0rund))
	(print e0)
	
	(setq dxsKopf_ht 0.0)
	(if (= (Connect.get CastaData amHtOberflansch ) 1) (progn
		(setq dxsKopf_ht (Winkel.get WinkelID dw))
	))
	(if (= (Connect.get CastaData amHtUnterflansch ) 1) (progn
		; (setq t_HT (Traeger.get HTrg t))
		; (setq dxsKopf_ht (* 0.5 t_HT))
		(setq dxsKopf_ht 0.0)
	))
	
	(Lochbild.set Lchb_ID 	(klemml (+ dw_W t_htrg))
							(dxsKopf	dxsKopf_ht)
	)
	
	
	(print "------------------------------------------------------------")
)

; --------------------------------------------------------------------
; Berechnet die Lochbilddaten am Anschlutrger
; --------------------------------------------------------------------
(defun calcAndSetLochbildDatenAtrgSteg (Lchb_ID TrgEnde WinkelID LbArt)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILD AM AT-STEG") 
;	Bei den w-Maen daran denken - werden nochmals durch 2 geteilt
;	
	(Lochbild.set Lchb_ID	
				(Lb_Art   LbArt)
	        	(Anz_S    4)
				(Guete   "4.6")
				(e       "100 50 0 0 0 0")
				(w       "60  140")
	)
		
	(setq	Wnkl_L			(Winkel.get WinkelID l)
			dw_W			(Winkel.get WinkelID dw)
			dok_W			(Winkel.get WinkelID dok)
	)
	(setq h_trg				(Traeger.get Tr_ID h)
			l_trg			(Traeger.get Tr_ID l)
			hc_trg			(Traeger.get Tr_ID hc)
			s_trg			(Traeger.get Tr_ID s)
			delta_v_trg		(Traeger.get Tr_ID delta_v)
			delta_l_trg		(TrEnde.get TrgEnde delta_l)
			qsform_at		(Traeger.get Tr_ID qsform)
	)
	
	(if (= qsform_at "C") (setq qsform_at "U"))
	
	(setq delta_v_ht	(Traeger.get Htrg delta_v))
		
	
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq l_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	(print Wnkl_L)
	(print l_aus_e)
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	(if (> l_aus_e Wnkl_L)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq l_aus_e (* e_blech_rund 2.0))
			(if (< Wnkl_L l_aus_e)
				(setq l_aus_e Wnkl_L)
			)
			(setq VIER 0) 
		)
	)	
	
	(setq w0 (+ e_blech dw_W))					; Randabstand
	(setq w0rund (runde w0 auf 5))
	(setq w1 (+ e1_blech w0rund))				; Lochabstand
	(setq w1rund (runde w1 auf 5))
		
	 
	
	(setq diff (- l_aus_e Wnkl_L)) ; Differenz zwischen alter und neuer Winkelhhe
	(setq dok_wnkl (- dok (* 0.5 diff) ))
	;Winkellnge am AT korregieren
	;(Winkel.set WinkelID 	(sll (- (+ w1rund w0rund) dw_W))
												;(l l_aus_e)
												;(dok dok_wnkl)
	;)
	
	(print dok_wnkl)
	(print Wnkl_L)
	(print l_aus_e)
	
	(if (= VIER 1)
		(progn
			(setq e0 (+ dok_wnkl (* 0.25 l_aus_e)))
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			(Lochbild.set Lchb_ID 	(e0 e0) 
									(e1 e1_blech_rund) 
									(w0 w0rund)
									(w1 w1rund)												
			)
		)
		(progn
			(setq e0 (+ dok_wnkl (* 0.5 l_aus_e)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID 	(e0 e0)
									(e1 0) 										
									(w0 w0rund)
									(w1 w1rund)
			)
		)
	)
	
	(setq wEinfach (+ w0rund (* 0.25 w1rund)))
	(Lochbild.set Lchb_ID (w0 wEinfach) (w1 0))
	(print e0)
	
	
	;Klemmlnge
	(if (= qsform_at "U")
		(progn
			(setq dxskopf_at 0)
		)
		(progn
			(setq dxskopf_at 0)
		)
	)	
	(print dxskopf_at)
	(Lochbild.set Lchb_ID	(klemml (+ (* dw_W 2) s_trg))
							(dxSKopf dxskopf_at)
	) 
	
	(print "<-----------------------------------------------------------")
)


; -------------------------------------------------------------------------
; Erzeugt die Lochbilder
; -------------------------------------------------------------------------
(defun createLochbildAbtl (TrgEnde WinkelID)
	
	(setq	deltaV_HT  		(Traeger.get hTrg delta_v)
			deltaLR_HT  	(Traeger.get hTrg delta_LR)
			h_HT    		(Traeger.get hTrg h)
			delta_lr_ht		(Traeger.get hTrg delta_lr)
			qsform_ht		(Traeger.get Htrg qsform)
	)
	
	(setq	deltaV_AT		(Traeger.get Tr_ID delta_v)
			h_AT   			(Traeger.get Tr_ID h)
			delta_lr_trg	(Traeger.get Tr_ID delta_lr)	
			rwinkel_at		(Traeger.get Tr_ID r_winkel)
	)
	
	
	(setq	xPos_HT 		(Connect.get CastaData xPos_ht)
			vwinkel_uz		(Connect.get CastaData hpttrg_vwinkel)
	)
	(print xPos_HT)
	
	(setq abteil_winkel 0.0)
	
	(setq xPos xPos_HT)

	(if (= (connect.get CastaData amHtOberFlansch) 1) 	(setq L_Flansch_add _flanschlochbild_of_))
	(if (= (connect.get CastaData amHtUnterFlansch) 1) 	(setq L_Flansch_add _flanschlochbild_uf_))
	
	(if (= TrgEnde TrLinks)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildlinks_)
			(traeger.addabtl hTrg lchbWnkl xPos abteil_winkel L_Flansch_add)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildrechts_)
			(traeger.addabtl hTrg lchbWnkl xPos abteil_winkel L_Flansch_add)
		)
	)

	(createLochbildAbtl_ATSteg TrgEnde WinkelID)

	; Berechnet die Lochbilddaten der Verbindung zum HT-Steg
	(calcAndSetLochbildDaten lchbWnkl TrgEnde WinkelID)
	

		
	(setq e0_lb (Lochbild.get lchbWnkl e0)
				e1_lb	(Lochbild.get lchbWnkl e1)
	)
	
	(print e0_lb)
	
	(setq e_diff (- (+ e0_lb e1_lb) (- h_AT e0_lb)))
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(setq delta_v_lb_ht (+ (- diff_oben) e_diff))
		(setq delta_v_lb_ht	(- diff_oben))
	)
	
	(setq ht_lochbild_abtl (Traeger.get Htrg Abteil lchbWnkl))
	(setq at_lochbild_abtl (Traeger.get Tr_ID Abteil lchbWnkl))
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(setq diffWinkel 0.0)
	
	; Positionierung des Anbauteil-Lochbildes am HT
	; ----------------------------------------------
	(setq N_Versch_delta_v 0.0)
	(setq N_Versch_delta_LR 0.0)
	
	; Winkel des Anbauteils
	; ----------------------------------------------
	
	(setq abtl_winkel (Connect.get CastaData r-atrgewnkl_flansch))
	(print abtl_winkel)
	(if (= (Connect.get CastaData vAtr-sHtr) 1) (setq abtl_winkel (- abtl_winkel 180.0)))
	
	(setq N_Versch_delta_v (- N_Versch_delta_v (* 0.5 h_AT)))
	(setq N_Versch_delta_v (+ N_Versch_delta_v deltaV_AT))
	(if (= (Connect.get CastaData vAtr-sHtr) 1) (progn
		(setq N_Versch_delta_v (- N_Versch_delta_v deltaLR_HT))
	))
	(if (= (Connect.get CastaData vAtr-sHtr) -1) (progn
		(setq N_Versch_delta_v (+ N_Versch_delta_v deltaLR_HT))
	))
	
	(print N_Versch_delta_v)
	(print N_Versch_delta_LR)
	(Anbauteil.set ht_lochbild_abtl 
				(delta_v 	N_Versch_delta_v)
				(delta_lr 	N_Versch_delta_LR)
				(winkel		abtl_winkel)
	)

	
	(if (= qsform_at "U")
		(Anbauteil.set at_lochbild_abtl (delta_lr uProf_anpassung))
	)
	
	; Master setzen
	; ----------------------------------------------
	(Anbauteil.set ht_lochbild_abtl (Master 1))
	(Anbauteil.set at_lochbild_abtl (Master 0))
	
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lchbWnkl)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
    	)
	    (if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1))
			
			(if (= qsform_at "U")	
				(Anbauteil.set dummy_abtl (delta_lr uProf_anpassung))
			)
		)
	)
	;===================================================================
	(print "------------------------------------------------------------")
)


(defun createLochbildAbtl_ATSteg (TrgEnde WinkelID)
	(if (= TrgEnde TrLinks)
		(progn 
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde WinkelID 2)
			(Traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			(setq trgLaenge (Traeger.get Tr_ID syslng))
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde WinkelID -2)
			(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
		)
	)
)

; -------------------------------------------------------------------------
; Erzeugt die Winkel
; -------------------------------------------------------------------------
(defun createWinkel (TrgEnde WinkelID)
	;Erzeugung der Winkel
	(calcAndSetWinkeldaten WinkelID TrgEnde)
	(if (= TrgEnde TrLinks)
		(progn
			(traeger.addabtl tr_id WinkelID 0.0 0.0 _kopfplattelinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn
			(traeger.addabtl tr_id WinkelID 0.0 0.0 _kopfplatterechts_)
		)
	)
)

; -------------------------------------------------------------------------

; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	
	(setq 	b_ht		(Traeger.get Htrg b)
			delta_lr_ht	(Traeger.get Htrg delta_LR)
	)
	(setq	h_at		(Traeger.get Tr_ID h)
			delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq b_ht_halb	(* 0.5 b_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_lr_ht b_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht b_ht))						(print uKante_ht)
	(setq oKante_at	(- delta_v_at b_ht_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))						(print uKante_at)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(setq oKante_at_tmp oKante_at)
			(setq uKante_at_tmp uKante_at)
			
			(setq oKante_at (- uKante_at_tmp))
			(setq uKante_at (- oKante_at_tmp))
		)
	)
		
	(setq diff_oben (- oKante_at oKante_ht))
	(print diff_oben)
)

(defun korrHtEnde (WINKELID)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(setq s_at 					(Traeger.get Tr_ID s)
				delta_lr_at		(Traeger.get Tr_ID delta_lr)
	)
	
	(setq slk_winkel (Winkel.get WINKELID slk))
	(print slk_winkel)
	
	(setq delta_l_htende (+ (+ slk_winkel (* 0.5 s_at)) delta_lr_at))
	
	(TrEnde.set HtEnde (delta_l (- delta_l_htende)))
)


(defun getExistingLochbild ()
	(alertBox "Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden. Nehmen Sie nderungen ggf. manuell vor." "OppositeSideConnection_Found")
	(print "gegenberliegendes Lochbild holen")
	
	(setq xPos_at 			(Connect.get CastaData xPos_at))
	
	
	(setq delta_v_at		(Traeger.get Tr_ID delta_v))
	
	(setq dp_wnkl 			(Winkel.get winkel_blech dw))
		
	(setq klemml_alt 		(Lochbild.get lchbWnkl klemml)
				dxskopf_alt		(Lochbild.get lchbWnkl dxsKopf)
	)
	
			
	(setq klemml_neu 	(+ klemml_alt dp_wnkl))
	(setq dxskopf_neu (+ dxskopf_alt dp_wnkl))
	
	(Lochbild.set lchbWnkl (klemml klemml_neu))
			
	(print xPos_at)
				
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildrechts_)
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildlinks_)
		)
	)
	
	
	(setq loch_ht_abtl (Traeger.get Htrg AbTeil lchbWnkl))
	(setq delta_v_abtl_lb_ht 	(Anbauteil.get loch_ht_abtl delta_v))
	(print delta_v_abtl_lb_ht)	
	
	(setq delta_v_abtl_at delta_v_abtl_lb_ht)
	(print delta_v_abtl_at)
	
	(calcUnterschied)
	
	; Anteil Unterschied HT u. AT
	(setq delta_v_abtl_at (+ delta_v_abtl_at (- diff_oben)))
	(print delta_v_abtl_at)
	
	(setq loch_at_abtl (Traeger.get Tr_ID Abteil lchbWnkl))
	(Anbauteil.set loch_at_abtl (Master 	0)
								(delta_v  0.0)
		  						;(delta_lr 40); ??? funktioniert nicht
	)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(Anbauteil.set loch_at_abtl (switch_on _unterflansch_))
	)
	
	(createLochbildAbtl_ATSteg AT_Ende winkel_blech)							
)


(defun korrigiereAblaengung ()
    (if (= (Connect.get CastaData LinkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData RechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
    
    (setq at_DeltaL (TrEnde.get TrgEnde Delta_L))
    (setq nWert (runde at_DeltaL auf 5))
    (if (< (- nWert at_DeltaL) 2.5) (progn
        (setq at_DeltaL (+ 2.5 at_DeltaL))
        (setq nWert (runde at_DeltaL auf 5))
    ))
    (TrEnde.set TrgEnde (Delta_L nWert))
)


(defun	trimmeTrgEnde ()
    (setq delta_V_HT (Traeger.get HTrg  delta_V)
		  t_HTrg      (Traeger.get HTrg  t)
		  dxEnde	  10.0
    )
    (if (= (Connect.get CastaData amHtOberflansch ) 1) (progn
		(setq dxEnde (- dxEnde  delta_V_HT))
	))

    (if (= (Connect.get CastaData linkesEnde) 1) (progn
        (setq TrgEnde (Traeger.get Tr_ID links))
		(TrEnde.set TrgEnde (delta_l dxEnde))
        (TrEnde.ptrim TrgEnde (* 0.5 t_HTrg))

        (calcTrEnde_AT_DeltaV TrgEnde -1.0)
    ))
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
        (setq TrgEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set TrgEnde (delta_l dxEnde))
        (TrEnde.ptrim TrgEnde (* 0.5 t_HTrg))

        (calcTrEnde_AT_DeltaV TrgEnde  1.0)
    ))
    
)
(defun	TraegerAusklinkung (AklLnge AklVert)

    (if (= (Connect.get CastaData linkesEnde) 1) (progn
        (setq TrgEnde (Traeger.get Tr_ID links))
		(TrEnde.set TrgEnde (xAkl AklLnge)
							(zAkl AklVert)
		)
    ))
    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
        (setq TrgEnde (Traeger.get Tr_ID rechts))
		(TrEnde.set TrgEnde (xAkl AklLnge)
							(zAkl AklVert)
		)
    ))
    
)

