; $	HT	QT(K)		AF(SK)		P(EZ)
; $ 	AT	QT(IUKRS)	AF(K)		P(E)
; $	AE	V(-)		H(-)		R(-)

; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
;
;	
; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")	
   (load "mod-lochbild")
   ;(load "mod-multiconnect-stz-steg")
   (load "mod-messages")
)



(defun init-connection ()

	(print "*clear*")
	(connect.showattributes CastaData)

	(EbenenUntersuchung)

	(setq MakroStarten 0)
	(if (= VertikalEbene   1)	(setq MakroStarten 1))
	(if (= HorizontalEbene 1)	(setq MakroStarten 1))
	
	(setq MakroStarten 1)
	(if (= MakroStarten 1) (progn
		(init-traegerenden)
		;(korrAtEnde abstandZumSteg)
		
		(setq LB_DEBUG 0)
		
		(setConnection)	
		
		(HK_ProfilAnpassung)

		(if (= 2 1) (progn
			(setq lb_abtl_at (Traeger.get Tr_ID Abteil kpl_lochbild))
			(setq lb_abtl_ht (Traeger.get Htrg Abteil kpl_lochbild))
			(Anbauteil.set lb_abtl_at	(Master 	0))
			(Anbauteil.set lb_abtl_ht	(Master 	1))
			
			(setq e1_vorh (Lochbild.get kpl_lochbild e1))
			; (Lochbild.set kpl_lochbild (e1 30) (e2 (- e1_vorh 30)))
			 (Lochbild.set kpl_lochbild (e0 0) (e1 20) (e2 50))

			 (Lochbild.set kpl_lochbild (LB_Art -2) (w0 30))
			
			(setq abtl_lb_dv_vorhanden (Anbauteil.get lb_abtl_ht delta_v))
			(setq abtl_lb_dlr_vorhanden (Anbauteil.get lb_abtl_ht delta_lr))
;			(print abtl_lb_dlr_vorhanden)
;			(Anbauteil.set lb_abtl_ht (delta_v (- abtl_lb_dv_vorhanden)))
		))
	   )
	   (AlertBox "Die Winkelkonstellation wrde mit diesem Makro nicht zu einem fehlerfreien Lochbild fhren.\nLeider ist diese Anschluss nicht mglich"  "WRN_AngleConfiguration_HolepatternProblem")
	)

	; (setq AnschlussTyp (Connect.get CastaData AnschlussTyp))
	; (print AnschlussTyp)
)


(defun setConnection ()
	
	; Objekte erzeugen
	(setq kpl_blech (Blech.create))
	(Connect.storeAnschlObjs CastaData kpl_blech)


;	Schrauben bei Kastenprofilen werden zwar erzeugt aber nicht eingebaut.	
	(setq qsform_ht	(Traeger.get Htrg qsform))
	(if (= qsform_ht "K") (setq kpl_lochbild (Lochbild.create))
	(progn
	    (if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(setq kpl_lochbild (Connect.get CastaData steglchb_gegen))
		)
		(progn
			(setq kpl_lochbild (Lochbild.create))
		)
	    )
	    (Connect.storeAnschlObjs CastaData kpl_lochbild)
	))
	
	
	; Blechdicke berechnen
	(calcAndSetKplThickness)
	
	;Schraubengre anhand der min. Blechdicke bestimmen(grobe Anhaltswerte)
	(setq min_blech_dp 10)
	(setq akt_kpl_dp (Blech.get kpl_blech dp))
	(setq s_ht (Traeger.get Htrg s))
	(if (< s_ht akt_kpl_dp)
		(setq min_blech_dp s_ht)
		(setq min_blech_dp akt_kpl_dp)
	)
	(print min_blech_dp)
	(calcSchraube min_blech_dp) ; -> S_Bez
	
	; Schraubengre dem Lochbild hinzufgen
	(Lochbild.set kpl_lochbild (S_Bez S_Bez))
	
	; min. Rand- / Lochabstnde berechnen
	(calcMinRandLochAbst kpl_lochbild) ; -> e_min, e1_min, e_min_rund, e1_min_rund, h_min
	
	; Kopfplatte berechnen
	(calcAndSetKplDaten)
	
	;Einbauposition prfen
	(checkPosition kpl_blech)
	
	; Anbauteil Kopfplatte hinzufgen
	(setKplAbtl)
	
	(if (= qsform_ht "K") (progn
	    (print "Kastenprofil bercksichtigen"); Ist aber eigentlich immer Kasten
	    (calcAndSetLochbildDaten kpl_lochbild kpl_blech)
			
	    ; Lochbildanbauteile hinzufgen
	    (setLochbildAbtl kpl_lochbild kpl_blech)
	    (Connect.storeAnschlObjs CastaData kpl_lochbild)
	))


	(if (/= qsform_ht "K") (progn
	    ; Auf gegenberliegenden Anschluss prfen
	
	    (if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(getExistingLochbild)												
		)
		(progn
  		; Lochbilddaten berechnen
			(calcAndSetLochbildDaten kpl_lochbild kpl_blech)
			
			; Lochbildanbauteile hinzufgen
			(setLochbildAbtl kpl_lochbild kpl_blech)
		)
  	    )
	))
	
	; korrigiere Stz-Ende
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlzwhtenden) 0)
			(korrigiereStzEnde)
		)
	)
	
	
;	(Lochbild.set kpl_lochbild (e "0 30 70 0 0 0") (w "180 0") (LB_Art 2))
	
	; Callbacks
  (Blech.set kpl_blech (formFkt "cb_kplblech"))
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr die Kopfplatte
; ----------------------------------------------------------------------------------------
(defun cb_kplblech (zp)
	(print "*clear*")
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpl_blech dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpl_blech dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml 	(Lochbild.get kpl_lochbild Klemml))
	       (setq altesDxSKopf (Lochbild.get kpl_lochbild dxSKopf))
	       (print alteKlemml)
	       (print altesDxSKopf)
	       
	       (setq klemml_neu (+ alteKlemml dpDiff))
	       (print klemml_neu)
	       
	       (Lochbild.set kpl_lochbild 	(Klemml  klemml_neu))
	       
	       (if (= (Connect.get CastaData amHtStegLinks) 1)
	       	(progn
	       		(setq dxsKopf_neu (+ altesDxSKopf dpDiff))
	       		(print dxsKopf_neu)
	       		
	       		(Lochbild.set kpl_lochbild (dxSKopf dxsKopf_neu))	 
	       		(Lochbild.set kpl_lochbild (dxSKopf 0.0))	 
	       	)      	
	       )
				 
				 (cbDeltaLR kpl_lochbild dpDiff)
	    ))
	))
)


; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	;(print "*clear*")
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)



; ****************************************************************************************
; HILFSFUNKTIONEN
; ****************************************************************************************

; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendicke
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplThickness ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DICKE")
	(print "------------------------------------------------------------")
	(setq t_ht (Traeger.get Htrg t))
	(setq t_at (Traeger.get Tr_ID t))
	
	(setq dp_kpl (runde t_at auf 5.0))
	(print dp_kpl)
	
	(Blech.set kpl_blech (dp dp_kpl))

	(print "<-----------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Berechnet die Kopfplattendaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetKplDaten ()
	(print ">-----------------------------------------------------------")
	(print "BERECHNE KOPFPLATTEN-DATEN")
	(print "------------------------------------------------------------")
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
	
	(setq	vscherl_at	(TrEnde.get AT_Ende vscherl)
		hscherl_at	(TrEnde.get AT_Ende hscherl)
	)
	
	(setq	b_at		(Traeger.get Tr_ID b)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(setq abst_zum_rand e_min_rund)
	(setq abst_zum_trg (* 0.5 e_min_rund))
	(if (= qsform_at "R")
		(setq abst_zum_trg (* 0.25 e_min_rund))
	)
	
	(setq rand (+ abst_zum_rand abst_zum_trg))
	; Kopfplattenhhe
	(setq kpl_hp (+ vscherl_at (* 2.0 rand)))
	(print kpl_hp)
	
	; Kopfplattenbreite
	(setq kpl_bp (+ hscherl_at (* 2.0 rand)))
	(print kpl_bp)
	
	; Dok
	(setq kpl_dok (- rand))
	(print kpl_dok)
	
	(Blech.set kpl_blech 	(hp		kpl_hp)
				(bp 		kpl_bp)
				(dok 		kpl_dok)
	)
	(print "<-----------------------------------------------------------")	
)		


; ----------------------------------------------------------------------------------------
; Hinzufgen des Kopfplatten-Anbauteils
; ----------------------------------------------------------------------------------------
(defun setKplAbtl ()
	(print ">-----------------------------------------------------------")
	(print "FGE KOPFPLATTEN-ANBAUTEIL HINZU")
	(print "------------------------------------------------------------")
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq kpl_dp (Blech.get kpl_blech dp))
	
	(setq xPos_abtl	xPos_ht)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(Traeger.addAbtl Tr_ID kpl_blech xPos_abtl 0.0 _kopfplatterechts_)
		)
	)
	
	(TrEnde.pTrim AT_Ende kpl_dp)
	
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
	(Lochbild.set Lochb_ID 	(Guete  "4.6")
													(Anz_S  4)
	)
	
	(setq kpl_hp 	(Blech.get Blech_ID hp)
				kpl_bp 	(Blech.get Blech_ID bp)
				kpl_dok (Blech.get Blech_ID dok)
				kpl_dp	(Blech.get Blech_ID dp)
	)
	
	(setq s_ht			(Traeger.get Htrg s)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	(setq s_ht_halb (* 0.5 s_ht))
	
	; e0
	(setq e0_lb (- abst_zum_trg))
	(print e0_lb)
	; e1
	(setq e1_lb (- kpl_hp (* 2.0 e_min_rund)))
	
	; w0
	(setq w0_lb (- kpl_bp (* 2.0 e_min_rund)))
	 
		
	; klemml
	(setq klemml_lb (+ s_ht kpl_dp))
	(print klemml_lb)
	
	; dxskopf
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(setq dxskopf_lb (+ kpl_dp s_ht_halb))
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(setq dxskopf_lb s_ht_halb)
	)

	(if (= qsform_ht "U")	
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1) (setq dxskopf_lb kpl_dp))
			(if (= (Connect.get CastaData amHtStegRechts) 1) (setq dxskopf_lb 0.0))
		)
	)
	
	(print dxskopf_lb)
	
	(Lochbild.set Lochb_ID 	(e0		e0_lb)
				(e1		e1_lb)
				(w0		w0_lb)
				(klemml		klemml_lb)
				(dxsKopf	dxskopf_lb)
	)

	(if (< e0_lb 0) (progn
	    (if (> kpl_dok -10) (progn
	    	(print "Lochbild korrigieren, weil es auerhalb des Bleches liegt")
	    	(setq	ENetto 	(Lochbild.get Lochb_ID eNetto)
	    		sD	(Lochbild.get Lochb_ID sDurchm)
	    	)
	    	(setq	h_HT	(Traeger.get HTrg h)
	    		t_HT	(Traeger.get HTrg t)
	    	)
	    	(setq	h_HT_Min (+ (* 4.0 sd) eNetto))
	    	(print h_HT_Min)
	    	(if (> h_HT_Min (- h_HT t_HT t_HT)) (progn
	    		(setq e0_lb (* 0.5 h_HT))
			(Lochbild.set	Lochb_ID 	(e0		e0_lb)
							(e1		0)
			)
	    	))
	    ))
	))
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lochb_ID (e2 	300))
	)
	(print "<-----------------------------------------------------------")	
)


; ----------------------------------------------------------------------------------------
; Hinzufgen der Lochbild-Anbauteile
; ----------------------------------------------------------------------------------------
(defun setLochbildAbtl (Lochb_ID Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "FGE LOCHBILD-ANBAUTEILE HINZU")
	(print "------------------------------------------------------------")
	
	; AT
	; ######################################################################################
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildlinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addAbtl Tr_ID Lochb_ID 0.0 0.0 _kpllochbildrechts_)
	)
	
	(setq delta_v_abtl_at 0)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	(setq sinW (sin (/ (* PI at_winkel) 180.0)))
	
	(setq anteil_hneigung (/ (* 1.0 kpl_dp) tanW))
	
	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_at (- anteil_hneigung)))
	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_at    anteil_hneigung))
	
	
	; HT
	; ######################################################################################
	(setq rwinkel_at		(Traeger.get Tr_ID r_winkel))
	
	(setq	xPos_ht 	(Connect.get CastaData xPos_ht)
		vwinkel_uz	(Connect.get CastaData hpttrg_vwinkel)
		r_winkel_steg	(Connect.get CastaData r-atrgewnkl_steg)
	)
	
	(setq delta_v_abtl_ht 0.0)
	(setq delta_lr_abtl_ht 0.0)
		
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print "---- Differenzwinkel ----")
	(print vwinkel_uz)
	(print rwinkel_at)
	(print r_winkel_steg)
	
	(setq diffWinkel 0.0)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
		)
	)
	
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))

	; Winkel des Anbauteils
	; ----------------------------------------------
	(setq abtl_winkel_ht 0.0)
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel_ht  90.0)	)
	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq abtl_winkel_ht 270.0)	)
	(if (= (Connect.get CastaData vatr-vhtr)  0)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq abtl_winkel_ht 180.0)	)
			(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq abtl_winkel_ht 	 0.0)	)

			(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq abtl_winkel_ht  90.0)	)
			(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq abtl_winkel_ht 270.0)	)
		)
	)

	(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq abtl_winkel_ht  90.0)	)
	(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq abtl_winkel_ht 270.0)	)
	(if (= (Connect.get CastaData satr-lhtr-ex)  0)	(progn
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq abtl_winkel_ht 270.0)	)
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq abtl_winkel_ht  90.0)	)
	))

	(print "Winkel nach dem generellen Ausrichten")
	(print abtl_winkel_ht)
	(print diffWinkel)

	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abtl_winkel_ht  90.0))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abtl_winkel_ht 270.0))

	(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
	    (setq abtl_winkel_ht 270.0)
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq abtl_winkel_ht (- (+ abtl_winkel_ht diffWinkel) 180.0)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0)	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel)))
	    ))
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq abtl_winkel_ht (- (+ abtl_winkel_ht diffWinkel) 180.0)))
		(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0)	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel)))
	    ))
	))


	(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
	    (setq abtl_winkel_ht 270.0)
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq abtl_winkel_ht (- (+ abtl_winkel_ht diffWinkel) 180.0)))
		(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0)	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel)))
	    ))
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData satr-lhtr-ex) -1)	(setq abtl_winkel_ht (- (+ abtl_winkel_ht diffWinkel) 180.0)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  1)	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel)))
		(if (= (Connect.get CastaData satr-lhtr-ex)  0)	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel)))
	    ))
	))
	
	
	(print "Differenzwinkel mitbetrachtet")
;	(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel))
;	(if (= (Connect.get CastaData vatr-vhtr)  0)
;		(setq abtl_winkel_ht (- abtl_winkel_ht (- 90.0 diffWinkel)))
;		(setq abtl_winkel_ht (- abtl_winkel_ht diffWinkel))
;	)
	(print abtl_winkel_ht)
	
;	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel_ht (- 180.0 abtl_winkel_ht)))
	(print abtl_winkel_ht)
	
	
	
	; delta_v Anbauteil HT
	; ----------------------------------------------
	
	; Anteil AT-Hhe
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData linkesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID links)))
		(if (= (Connect.get CastaData rechtesEnde) 1)		(setq AT_Ende (Traeger.get Tr_ID rechts)))
		
		(setq vscherl_at	(TrEnde.get AT_Ende vscherl))
		(setq hScherl_AT 	(TrEnde.get AT_Ende hscherl))

		(setq vscherl_at_halb (* 0.5 vscherl_at))
		(setq hscherl_at_halb (* 0.5 hScherl_AT))

		(setq delta_v_abtl_ht (- vscherl_at_halb))

		(setq H_Wnkl_Steg (Connect.get CastaData h-atrgewnkl_steg))
		(setq V_Wnkl_Steg (Connect.get CastaData v-atrgewnkl_steg))

		(if (= HorizontalEbene 1) (progn
;			(if (< V_Wnkl_Steg 90.0) (setq delta_v_abtl_ht (- delta_v_abtl_ht)))
;			(if (/= V_Wnkl_Steg 90.0) (setq delta_lr_abtl_ht (* 0.5 (- hScherl_AT hscherl_at_halb))))
		))
;		(if (= (Connect.get CastaData satr-vhtr) 1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht)))
		
		; (setq delta_v_abtl_ht (- delta_v_abtl_ht))
		(if (= HorizontalEbene 1) (progn
		    (setq H_Wnkl_Steg (Connect.get CastaData h-atrgewnkl_steg))
		    (if (/= V_Wnkl_Steg 90.0) (progn
	    		; (setq delta_v_abtl_ht (- delta_v_abtl_ht))
			(if (= (Connect.get CastaData linkesEnde) 1) (progn
			    (if (= (Connect.get CastaData amhtsteglinks ) 1) (progn
		    		; (print "Hier Fall 1....")
				; (setq delta_v_abtl_ht (- delta_v_abtl_ht))
			    ))
			    (if (= (Connect.get CastaData amhtstegrechts ) 1) (progn
		    		 ; (print "Hier Fall 2....")
				 ; (setq delta_v_abtl_ht (- delta_v_abtl_ht))
			    ))
		        ))
		    ))
		))
		
	; ----------------------------------------------
	))
	; ----------------------------------------------

	; Anteil AT-Neigung (horizontal)
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq	qs_AT		(Traeger.get Htrg qsForm)
		b_ht 		(Traeger.get Htrg b)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
		delta_lr_ht	(* 1.0 delta_lr_ht)
	)
	
	
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	(setq kpl_dp (* 1.0 kpl_dp))
	
	(setq at_winkel (Connect.get CastaData at_laengswinkel))
	
	(setq tanW (tan (/ (* PI at_winkel) 180.0)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abst (+ (* 0.5 b_ht) kpl_dp (- delta_lr_ht))))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abst (+ (* 0.5 b_ht) kpl_dp delta_lr_ht)))

	(setq anteil_hneigung (/ abst tanW))

	(if (= HorizontalEbene 1) (progn
		(if (/= V_Wnkl_Steg 90.0) (progn
		    	(if (= (Connect.get CastaData amHtStegLinks)  1) (if (= (Connect.get CastaData linkesEnde) 1)  (setq abst (- delta_lr_ht (* 0.5 b_ht) kpl_dp))))
		    	(if (= (Connect.get CastaData amHtStegRechts) 1) (if (= (Connect.get CastaData rechtesEnde) 1) (setq abst (- (- delta_lr_ht) (* 0.5 b_ht) kpl_dp))))
		    	(if (= (Connect.get CastaData amHtStegLinks)  1) (if (= (Connect.get CastaData rechtesEnde) 1) (setq abst (- (+ (- delta_lr_ht) (* 0.5 b_ht) kpl_dp)))))
		    	(if (= (Connect.get CastaData amHtStegRechts) 1) (if (= (Connect.get CastaData linkesEnde) 1)  (setq abst (- (+ delta_lr_ht (* 0.5 b_ht) kpl_dp)))))

			(setq anteil_hneigung (/ abst tanW))
		))

		(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_hneigung)))
		(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_hneigung)))
	))
	(if (= VertikalEbene 1) (progn
	))
;;	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_hneigung)))
;;	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_hneigung)))
	; ----------------------------------------------
	(if (= HorizontalEbene 1) (progn
	    (if (/= (Connect.get CastaData vatr-lhtr) -1) (setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_hneigung)))
	    (if (/= (Connect.get CastaData vatr-lhtr)  1) (setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_hneigung)))
	))
	(if (= VertikalEbene 1) (progn
		(setq delta_lr_ht (- delta_lr_ht))
	    	(if (= (Connect.get CastaData amHtStegLinks)  1) (if (= (Connect.get CastaData linkesEnde) 1)  (setq abst (+ delta_lr_ht (* 0.5 b_ht) kpl_dp))))
	    	(if (= (Connect.get CastaData amHtStegRechts) 1) (if (= (Connect.get CastaData rechtesEnde) 1) (setq abst (- delta_lr_ht (* 0.5 b_ht) kpl_dp))))
	    	(if (= (Connect.get CastaData amHtStegLinks)  1) (if (= (Connect.get CastaData rechtesEnde) 1) (setq abst (+ delta_lr_ht (* 0.5 b_ht) kpl_dp))))
	    	(if (= (Connect.get CastaData amHtStegRechts) 1) (if (= (Connect.get CastaData linkesEnde) 1)  (setq abst (- delta_lr_ht (* 0.5 b_ht) kpl_dp))))

		(if (/= H_Wnkl_Steg 90.0) (progn
			(setq b_HT (Traeger.get HTrg b))
			(setq tanW (tan (/ (* PI (- H_Wnkl_Steg 90.0)) 180.0)))
			(setq delta_lr_abtl_ht (* tanW abst))
		))
	))

    ))
	; ----------------------------------------------	
		
	; Anteil AT-Neigung (vertikal)
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq	b_ht 		(Traeger.get Htrg b)
		delta_v_ht	(Traeger.get Htrg delta_v)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq abstQ 0.0)
	
	(setq kpl_dp (Blech.get Blech_ID dp))
	(setq kpl_dp (* 1.0 kpl_dp))			;; AF 08-2009 --- dp sollte nicht bercksichtigt werden
	
	(setq at_qwinkel (Connect.get CastaData v-atrgewnkl_steg))
	(if (/= at_qwinkel 90.0) (progn
		;; AF - Meldung eingesetzt, da aus Zeitgrnden Code von DM nicht komplett nachvollzogen werden konnte
		;; muss noch einmal komplett durchgesehen werden.
		;; (print "Bei dieser Winkelkonstellation gibt es derzeit Abweichungen der Schrauben im Trgersteg!")
	))
	(setq tanQW (tan (/ (* PI at_qwinkel) 180.0)))
	
;	Kopfplattendicke bei vertikalem Versatz nicht mitnehmen.	
;	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abstQ (+ (* 0.5 b_ht)  kpl_dp (- delta_v_ht))))
;	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abstQ (+ (* 0.5 b_ht)  kpl_dp    delta_v_ht)))

	; nochmal Testen, ob dies berhaupt je relevant sein knnte
	(if (= HorizontalEbene 1) (progn
		(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abstQ (+ (* 0.5 b_ht)  (- delta_v_ht))))
		(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abstQ (+ (* 0.5 b_ht)     delta_v_ht)))
	))
	(if (= VertikalEbene 1) (progn
		(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq abstQ (+ (* 0.5 b_ht)  (- delta_lr_ht))))
		(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq abstQ (+ (* 0.5 b_ht)     delta_lr_ht)))
	))

;	(setq abstQ (+ abstQ kpl_dp))			; Testweise doch einbauen
	(setq anteil_qneigung (/ abstQ tanQW))
	
	(if (= (Connect.get CastaData vatr-lhtr)  0)   (progn
	    (if (= (Connect.get CastaData linkesEnde) 1) (progn
		(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_qneigung))
	    ))
	    (if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_qneigung))
	    ))
	))
	(print "XXXXXXXXXXXXX  AT-Neigung vertikal")	(print delta_v_abtl_ht)
;--->	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_qneigung)))
;--->	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_qneigung)))
	; ----------------------------------------------
    ))
	; ----------------------------------------------	
	
	
	; TRAEGERVERSCHIEBUNGEN
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
		
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_v_ht (Traeger.get Htrg delta_v))

	(setq anteil_delta_v_ht (* delta_v_ht cosW))			; AF - 	08-2009 gendert
									; 	Winkel war nicht bercksichtigt
	(print delta_v_abtl_ht)
	(print anteil_delta_v_ht)
;	(setq anteil_delta_v_ht delta_v_ht)



	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_delta_v_ht))	)
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_ht))	)
;;	(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_ht))	)
;;	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_ht))	)
									; AF - Ende nderung

	(print sinW)

									; AF - 08-2009 gendert
									; 	Winkel war nicht bercksichtigt
	(setq anteil_delta_v_ht (* delta_v_ht    sinW))	
	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht anteil_delta_v_ht))
;;	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_v_ht))	)
;;	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_v_ht))	)
								; AF - Ende nderung
	(print "HT-Verschiebung")	(print delta_v_abtl_ht)
	; ----------------------------------------------
    ))
	; ----------------------------------------------
	
	; Anteil delta_v Verschiebung AT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	
	(if (/= sinW 0.0)
		(setq anteil_delta_v_at (/ delta_v_at sinW))
		(setq anteil_delta_v_at 0)
	)
	
	; AF - 08-2009 gendert - herauskommentiert ...
;;	(if (= (Connect.get CastaData vatr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))	)
;;	(if (= (Connect.get CastaData vatr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))	)

	; Horizontalebene ist schon getestet
	(setq delta_v_at (* 1.0 delta_v_at))
	(if (= HorizontalEbene 1) (progn
		(setq V_Wnkl_Steg (Connect.get CastaData v-atrgewnkl_steg))
		(if (/= V_Wnkl_Steg 90.0) (progn
		    (setq sinW (sin (/ (* PI    V_Wnkl_Steg)       180.0)))
		    (setq delta_v_at (/ delta_v_at sinW))
		))
		(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))	)
		(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))	)
	
		(if (= (Connect.get CastaData satr-lhtr)  0) (progn
			(if (= (Connect.get CastaData vatr-lhtr)   1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))	)
			(if (= (Connect.get CastaData vatr-lhtr)  -1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_at))	)
		))
	))
	(if (= VertikalEbene 1) (progn
		(setq V_Wnkl_Steg (Connect.get CastaData v-atrgewnkl_steg))

		(setq sinW (sin (/ (* PI    V_Wnkl_Steg)       180.0)))

		(if (/= sinW 0.0)
		    (setq anteil_delta_v_at (/ delta_v_at sinW))
		    (setq anteil_delta_v_at delta_v_at)
		)
		(if (= HorizontalEbene 0) (progn
			; Ansonsten wrde delta_v_at hier noch einmal bercksichtigt werden.
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))
	))
	))
	(print "DeltaV-Verschiebung AT") (print delta_v_abtl_ht)
	; ----------------------------------------------
    ))
	; ----------------------------------------------
	
	

	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
    (if (= 1 1)	(progn
	; ----------------------------------------------
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	(print delta_lr_at)
	(print sinW)

;	(setq VertikalEbene 0)
	(if (= VertikalEbene 1) (progn
		
	    (setq H_Wnkl_Steg (Connect.get CastaData h-atrgewnkl_steg))
	    (if (/= H_Wnkl_Steg 90.0) (progn
			(setq sinW (sin (/ (* PI    H_Wnkl_Steg)       180.0)))
			(setq anteil_delta_lr_at (/ delta_lr_at sinW))

			; weitermachen
	    	(if (= (Connect.get CastaData amHtStegLinks)  1) (if (= (Connect.get CastaData rechtesEnde) 1)  (setq anteil_delta_lr_at (- anteil_delta_lr_at))))
	    	(if (= (Connect.get CastaData amHtStegRechts) 1) (if (= (Connect.get CastaData linkesEnde) 1) (setq anteil_delta_lr_at (- anteil_delta_lr_at))))
			(setq delta_lr_abtl_ht (+ delta_lr_abtl_ht anteil_delta_lr_at))
	    ))
	))

	(if (= HorizontalEbene 1) (progn	

		(setq H_Wnkl_Steg (Connect.get CastaData h-atrgewnkl_steg))
		(if (/= H_Wnkl_Steg 90.0) (progn
			(setq sinW (sin (/ (* PI    H_Wnkl_Steg)       180.0)))
			(setq anteil_delta_lr_at (/ (* 1.0 delta_lr_at) sinW))
			(setq delta_lr_at anteil_delta_lr_at)
		))

	))
    ))
	; ----------------------------------------------
	(setq runThisPart 1)
	(if (= runThisPart 1) (progn
		(if (= (Connect.get CastaData satr-lhtr) 0) (progn
			(setq h_AtrWnklSteg (Connect.get CastaData h-atrgewnkl_steg))
			(if (= h_AtrWnklSteg 90.0) (progn
				(if (= (Connect.get CastaData linkesEnde)  1) (progn
					(if (= (Connect.get CastaData amHtStegLinks)  1) (progn
					(if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
					(if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
					))
					(if (= (Connect.get CastaData amHtStegRechts)  1) (progn
					(if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
					(if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
					))
				))
				(if (= (Connect.get CastaData rechtesEnde)  1) (progn
					(if (= (Connect.get CastaData amHtStegLinks)  1) (progn
					(if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
					(if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
					))
					(if (= (Connect.get CastaData amHtStegRechts)  1) (progn
					(if (= (Connect.get CastaData satr-vhtr) -1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
					(if (= (Connect.get CastaData satr-vhtr)  1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
					))
				))
			))
		))

		; getestet 09.2012 - OK in Zusammenhang mit Winkelbercksichtigung direkt hier drber
		(if (/= (Connect.get CastaData satr-lhtr) 0) (progn
			(if (= (Connect.get CastaData linkesEnde)  1) (progn
			    (if (= (Connect.get CastaData amHtStegLinks)  1) (progn
				(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
				(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
			    ))
			    (if (= (Connect.get CastaData amHtStegRechts)  1) (progn
				(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
				(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
			    ))
			))
			(if (= (Connect.get CastaData rechtesEnde)  1) (progn
			    (if (= (Connect.get CastaData amHtStegLinks)  1) (progn
				(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
				(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_lr_abtl_ht (- delta_lr_abtl_ht delta_lr_at)))
			    ))
			    (if (= (Connect.get CastaData amHtStegRechts)  1) (progn
				(if (= (Connect.get CastaData satr-lhtr) -1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
				(if (= (Connect.get CastaData satr-lhtr)  1) (setq delta_lr_abtl_ht (+ delta_lr_abtl_ht delta_lr_at)))
			    ))
			))
		))
									; AF - 03-2012 Korrektur Ende Einfgung
		; ----------------------------------------------
	))

	
	
	(print "Werte, die endltig eingesetzt werden .............................................")
	(print  delta_v_abtl_ht)
	(print  delta_lr_abtl_ht)
	
	(Traeger.addAbtl Htrg Lochb_ID xPos_ht abtl_winkel_ht _steglochbild_system_)
	
	(setq lb_abtl_at (Traeger.get Tr_ID Abteil Lochb_ID))
	(setq lb_abtl_ht (Traeger.get Htrg Abteil Lochb_ID))

	
	(if (= VertikalEbene 1) (progn
		(setq H_Wnkl_Steg (Connect.get CastaData h-atrgewnkl_steg))
		(if (/= H_Wnkl_Steg 90) (progn
			(setq delta_v_abtl_ht_Dummy 	   delta_v_abtl_ht)
;			(setq delta_v_abtl_ht 		(- delta_lr_abtl_ht))
;			(setq delta_lr_abtl_ht		(- delta_v_abtl_ht_Dummy))
		))
	))
	
	(Anbauteil.set lb_abtl_at	(Master 	0)
					(delta_v 	delta_v_abtl_at)
	)
	(Anbauteil.set lb_abtl_ht	(Master 	1)
					(delta_v 	delta_v_abtl_ht)
					(delta_lr	delta_lr_abtl_ht)
	)
   (if (= 1 1) (progn
	(if (= (Connect.get CastaData amHTStegLinks) 1) (progn
	        (if (= (Connect.get CastaData RechtesEnde) 1) (progn
			(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	        ))
	))
	(if (= (Connect.get CastaData amHTStegRechts) 1) (progn
	        (if (= (Connect.get CastaData LinkesEnde) 1) (progn
			(Anbauteil.set lb_abtl_ht	(SeitRicht 	-1))
	        ))
	))
   ))
	(if (= qsform_ht "K") (progn
	    (setq abst_Achse (Traeger.get HTrg b)
	          abst_Achse (/ abst_Achse 2.0)
	    )
	    (setq LiReFlag _steg_rechts_)

	    (if (= (Connect.get CastaData amHTStegLinks) 1) (setq 
	    		abst_Achse 	(- abst_Achse)
	    		LiReFlag	_steg_links_
	    ))

	    (Anbauteil.set lb_abtl_ht	(delta_sx 	abst_Achse)
	    				(addFlag	LiReFlag)
	    				(Master 	0)
	    )
	    (Anbauteil.set lb_abtl_at	(Master 	1))
	    (Lochbild.set Lochb_ID 	(dxsKopf	0))
	))
	    
	
	; LOCHBILD-TEST
	; --------------------------------------------------------------------------------------
	(if (= LB_DEBUG 1)
		(progn
			
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy Lochb_ID)
			
			(if (= (connect.get CastaData LinkesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (connect.get CastaData RechtesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq abtl_lb_at_dummy (Traeger.get Tr_ID Abteil lbdummy))
			(Anbauteil.set abtl_lb_at_dummy (Master 1)
							(delta_v delta_v_abtl_at)
			)
			
		)
	)
	; --------------------------------------------------------------------------------------
	
	(print "<-----------------------------------------------------------")	
)





; ----------------------------------------------------------------------------------------
; Verlngert bzw. Verkrzt das Sttzenende
; ----------------------------------------------------------------------------------------
(defun korrigiereStzEnde ()
	(print ">-----------------------------------------------------------")
	(print "KORRIGIERE STZ-ENDE")
	(print "------------------------------------------------------------")

	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg links))
		)
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(progn
			(setq delta_l_stz (- rand))
			(setq HT_Ende (Traeger.get Htrg rechts))
		)
	)


	(setq delta_lr (Traeger.get Tr_ID delta_lr))
	(setq bp       (Blech.get   kpl_blech   bp))
	(if (= (Connect.get CastaData sATr-lHTr) -1) (progn
	      (setq delta_L_UZ (- (* 0.5 bp) delta_lr))
	      (print delta_L_UZ)
	      (TrEnde.set HT_Ende (delta_l (- delta_L_UZ)))
	))
	(if (= (Connect.get CastaData sATr-lHTr)  1) (progn
	      (setq delta_L_UZ (+ (* 0.5 bp) delta_lr))
	      (print delta_L_UZ)
	      (TrEnde.set HT_Ende (delta_l (- delta_L_UZ)))
	))


	
	(if (= (Connect.get CastaData sATr-lHTr) 0) (progn
		(setq delta_l_alt (TrEnde.get Ht_Ende delta_l))
		(print delta_l_alt)
		(print rand)
	
		(setq delta_l_stz (- delta_l_alt rand))
	
		(TrEnde.set HT_Ende (delta_l delta_l_stz))
	))
	(print "<-----------------------------------------------------------")	
)

; ----------------------------------------------------------------------------------------
; bernimmt das gegenberliegende Lochbild
; ----------------------------------------------------------------------------------------
(defun getExistingLochbild ()
	(print "*clear*")
; ---------------------------------------------------------------------
(alertBox "
Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden.\n
Nehmen Sie nderungen ggf. manuell vor.\n
\n
Kontrollieren Sie bitte auch den Rotationswinkel der anschlieenden Trger!\n
Unterschiedliche Rotationswinkel fhren zu fehlerhaften Werkstattzeichnungen.
"  "NOTE_OppositeConnectionFound_RotAngle")
; ---------------------------------------------------------------------
	
	(print ">-----------------------------------------------------------")
	(print "BERNEHME LOCHBILD")
	
	(setq dp_kpl (Blech.get kpl_blech dp))
	(print dp_kpl)

	(setq delta_w (Lochbild.get kpl_lochbild delta_w))
	(if (/= delta_w 0) (progn
	     (alertBox "
Bei diesem Gegenanschluss liegt bereits ein asymmetrisches Lochbild vor.\nLochbild wird symmetrisch gestaltet.\n
\n
Bitte korrigieren Sie ggflls. die Kopfplatten an den Trgerenden der beiden Anschlsse!
")
	     (Lochbild.set lchbBlech (delta_w 0))
	))
			
	(setq klemml_alt 	(Lochbild.get kpl_lochbild klemml))
	(setq dxskopf_alt	(Lochbild.get kpl_lochbild dxsKopf))
	(print klemml_alt)
	(print dxskopf_alt)
			
	(setq klemml_neu 	(+ klemml_alt dp_kpl))
	(setq dxskopf_neu (+ dxskopf_alt dp_kpl))
	(print klemml_neu)
	(print dxskopf_neu)
			
	(Lochbild.set kpl_lochbild (klemml klemml_neu))									
				
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(Lochbild.set kpl_lochbild (dxsKopf dxskopf_neu))
	)
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildrechts_)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id kpl_lochbild 0.0 0.0 _kpllochbildlinks_)
	)
			
			
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
		delta_v_ht 	(Traeger.get HTrg  delta_v)
		delta_lt_at	(traeger.get Tr_ID delta_lr)
	)
			
	(setq loch_at_abtl (Traeger.get Tr_ID Abteil kpl_lochbild))
	(setq loch_ht_abtl (Traeger.get Htrg  Abteil kpl_lochbild))	  
	
	(setq	delta_v_abtl_ht 	(Anbauteil.get loch_ht_abtl delta_v)
		delta_lr_abtl_ht	(Anbauteil.get loch_ht_abtl delta_lr)
		h_ht			(Traeger.get Htrg h)
	)

	(setq	delta_v_abtl_at 	(Anbauteil.get loch_at_abtl delta_v)
		delta_lr_abtl_at	(Anbauteil.get loch_at_abtl delta_lr)
		h_at			(Traeger.get Tr_ID h)
	)

	(setq	delta_v_gesamt (- (* 0.5 h_at) delta_v_at (- delta_v_ht)))
	(print	delta_v_gesamt)

	(print delta_v_abtl_at)
	(print delta_lr_abtl_at)
	(print delta_v_at)
	(print delta_v_abtl_ht)
	(print delta_lr_abtl_ht)
	
;	(setq delta_v_abtl_at_neu (- (- delta_v_at) delta_v_abtl_ht))
	(setq delta_v_abtl_at_neu (+ delta_v_gesamt delta_v_abtl_ht))

;	Korrektur Feb.2011 (AF)
;	kompletter neuer Abschnitt	
	(setq ABTeilVorhanden (Traeger.get Htrg ABTeil kpl_lochbild))
	
	(if ABTeilVorhanden
		(progn
			(print "Anbauteil am Haupttrger gefunden.")
			; Vorbereitung Korrektur - Feb.2011 
			; Es gibt leider zwei verschiedene Steglochbildtypen
			; eines ist auf die Systemachse bezogen, das andere auf die OK des Trgers (hier des HT)
			; deswegen muss noch in einem Fall die halbe Hhe des HT bercksichtigt werden.
			(setq Steg_LB 	  131072)	; auf OK bezogen
			(setq Steg_LB_Sys 33554432)	; auf Achse bezogen (nur zur Verdeutlichung)

			(setq isType_1 (Anbauteil.get ABTeilVorhanden is_type Steg_LB))
			(setq isType_2 (Anbauteil.get ABTeilVorhanden is_type Steg_LB_Sys))

			(setq delta_v_vorhanden (Anbauteil.get ABTeilVorhanden delta_v))
			(print delta_v_vorhanden)
			
			(setq winkel_ht_lb_abtl (Anbauteil.get ABTeilVorhanden winkel))
			(print winkel_ht_lb_abtl)
			
; 			--------------------------------------------
;	-	-	korrigiert Feb. 2011 - (AF)
			(setq delta_v_gesamt (+ (* 0.5 h_at) delta_v_vorhanden))
			(setq delta_v_gesamt (+ delta_v_gesamt delta_v_ht))
			(setq delta_v_gesamt (- delta_v_gesamt delta_v_at))
			
			(if (= isType_1 1) (setq delta_v_gesamt (- delta_v_gesamt (* 0.5 h_HT))))
;			Ende Korrektur
		)
	)
	
	(Anbauteil.set loch_at_abtl (Master 	0)
;		(delta_v 	delta_v_abtl_at_neu)
		(delta_v 	delta_v_gesamt)
		(delta_lr delta_lr_abtl_ht)
	)				
	
	(print "<-----------------------------------------------------------")				
)


; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des AT
; ---------------------------------------------------------------------------------
(defun korrAtEnde (abst)
	; Abstnde zum Ht korrigieren
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq s_ht			(Traeger.get Htrg s)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	
	
	
	(TrEnde.ptrim AtEnde (- abst))
			
	
)


; ----------------------------------------------------------------------------------------
; berprft, ob der Anschluss in der bestehenden Positionierung eingebaut werden kann
; ----------------------------------------------------------------------------------------
(defun checkPosition (Blech_ID)
	(print ">-----------------------------------------------------------")
	(print "BERPRFE POSITION")
	
	; Oberkante HT
	(setq	h_ht		(Traeger.get Htrg h)
		r_ht		(Traeger.get Htrg r)
		t_ht		(Traeger.get Htrg t)
		hc_ht		(Traeger.get Htrg hc)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq	h_ht_halb	(* 0.5 h_ht))
	
	(setq	h_at		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	(setq	h_at_halb	(* 0.5 h_at))
	
	(setq	kpl_hp		(Blech.get Blech_ID hp)
		kpl_bp		(Blech.get Blech_ID bp)
	)
	(setq kpl_hp_halb	(* 0.5 kpl_hp))
	(setq kpl_bp_halb	(* 0.5 kpl_bp))
	
	
	(setq oGrenze_ht (- delta_v_ht (- h_ht_halb r_ht t_ht)))
	(setq uGrenze_ht (+ oGrenze_ht hc_ht))
	(print oGrenze_ht)
	(print uGrenze_ht)
	
	(if (= (Connect.get CastaData satr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_lr_at kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	(if (= (Connect.get CastaData satr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_lr_at) kpl_bp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_bp))
				)
			)
		)
	)
	
	(if (= (Connect.get CastaData vatr-vhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- delta_v_at kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
			(if (= (Connect.get CastaData satr-lhtr) -1)
				(progn
					(setq oGrenze_kpl	(- (- delta_v_at) kpl_hp_halb))
					(setq uGrenze_kpl (+ oGrenze_kpl kpl_hp))
				)
			)
		)
	)
	(print oGrenze_kpl)
	(print uGrenze_kpl)
	(setq KopfplatteZuGross 0)
	
	(if (>= oGrenze_kpl oGrenze_ht)
		(progn
			(if (<= uGrenze_kpl uGrenze_ht)
					(print "OK")
				; else
					(setq KopfplatteZuGross 1)
			)
		)
		(progn
			(setq KopfplatteZuGross 1)
		)
	)
	(if (= KopfplatteZuGross 1) (progn
		(setq qTyp_HT (Traeger.get HTrg qsform))
		(if (= qTyp_HT "K") (progn
		     (if (= (Connect.get CastaData vatr-lhtr)  0) (progn
			(setq 	Bl_dOK (Blech.get Blech_ID dOK)
				Bl_hp  (Blech.get Blech_ID hp)
			)
			; man knnte noch untersuchen, wie das Blech an den HT geschweit werden soll
			(setq dOK_neu (- Bl_dOK (* 0.5 (-  h_HT Bl_hp))))
			(Blech.set Blech_ID (hp h_HT) (dOK dOK_neu))
		     ))
		     (if (= (Connect.get CastaData satr-lhtr)  0) (progn
			(Blech.set Blech_ID (bp h_HT))
		     ))
		  )
		  (progn
			(alertBox "Die Kopfplatte reicht in die obere Ausrundung den Haupttrgers.\nBitte korrigieren Sie die Positionierung der Trger oder passen Sie die Kopfplatte an!" "Headplate_To_Fit_FilletTop")
		))
	))
	
	(print "<-----------------------------------------------------------")
)
(defun HK_ProfilAnpassung ()
    (print "Berechne HK_ProfilAnpassung")

    (Lochbild.set kpl_lochbild 
    	(S_Bez	"M12")	; Hollo-Bolt-Schraube ruhig kleiner whlen
    	(Montage 7)	; Hollo-Bolt-Schraube verwenden
    )	

    (if (= 1 3) (progn    
	    (setq lochb_AT_abtl (Traeger.get Tr_ID Abteil kpl_lochbild))
	    (setq lochb_HT_abtl (Traeger.get HTrg Abteil kpl_lochbild))
	    (Anbauteil.set lochb_AT_abtl (Master 1))
	    (Anbauteil.set lochb_HT_abtl (Master 0))
	    
	    ; und noch die berstehende Kopfplatte
	    (setq hProf (Traeger.get Tr_ID h))
	    (setq Ueberstand 80)
	    (setq eAbst (- (/ Ueberstand 2) 5))
	    (Blech.set blKpl
	    		(dOK (- Ueberstand))
	    		(hp  (+ hProf Ueberstand Ueberstand))
	    )
	    (Lochbild.set kpl_lochbild
	    	(e "0 0 0 0 0 0")
	    	(e0 (- eAbst))
	    	(e1 (+ hProf eAbst eAbst))
	    	(dxSKopf 0)
	    )
    ))   
)

;	-----------------------------------------------------------
;	In einer Richtung soll ein rechter Winkel vorliegen
(defun	EbenenUntersuchung ()
	(setq H_Wnkl_Steg (Connect.get CastaData h-atrgewnkl_steg))
	(setq V_Wnkl_Steg (Connect.get CastaData v-atrgewnkl_steg))

	(setq VertikalEbene   0)
	(setq HorizontalEbene 0)

	(if (= (Connect.get CastaData vatr-vhtr) 0) (progn
			(print "vatr-vhtr = 0")
		)
		(progn
			(print "vatr-vhtr /= 0")
	))
	(if (= 	V_Wnkl_Steg 90.0)  (print "V_Wnkl_Steg = 90"))
	(if (= 	H_Wnkl_Steg 90.0)  (print "H_Wnkl_Steg = 90"))

	
	(if (= (Connect.get CastaData vatr-vhtr) 0) (progn
		(if (= 	V_Wnkl_Steg 90.0)  (setq VertikalEbene 1))
		(if (= 	H_Wnkl_Steg 90.0)  (setq HorizontalEbene 1))
	   )
	   (progn
		(if (= 	H_Wnkl_Steg 90.0)  (setq VertikalEbene 1))
		(if (= 	V_Wnkl_Steg 90.0)  (setq HorizontalEbene 1))
	))

	(if (= VertikalEbene   1) (print "AT in der 90-Vertikalebene"))
	(if (= HorizontalEbene 1) (print "AT in der 90-HorizontalEbene"))


)