; $	G(1) 	HT	 QT(IU)	 	AF(S)		P(EZ)
; $ G(1)	AT	 QT(IU) 	AF(K)		P(E)
; $	G(1)	AE	 V(-)		 	H(-)		R(46-90)
; $	G(31) HT	 QT(IU)	 	AF(S)		P(EZ)
; $ G(31)	AT	 QT(IU) 	AF(K)		P(E)
; $	G(31)	AE	 V(-)		 	H(-)		R(-)
; $	HT	QT(IU)	 	AF(S)		P(EZ)
; $ AT	QT(IUT) 		AF(K)		P(E)
; $	AE	V(90)		 	H(-)		R(-)

(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
   (load "mod-lochbild")
)

(defun init-connection ()

	(print "*clear*")
	(connect.showAttributes CastaData)

	(setq rwinkel (Traeger.get Tr_ID r_winkel))
		
	;(if (= rwinkel 0.0)
	;	(calcAnschluss)
	;	(alertBox "Bitte setzen Sie die Rotation des Anschlusstrgers auf 0, da eine Berechnung der Verbindung sonst nicht mglich ist." "Set_AT_Rotation_to_0")
	;)
	(calcAnschluss)	
  

  (if (= 1 2) (progn
	  (setq abtlLchb_AT (Traeger.get Tr_ID AbTeil lchbBlech))
	  (setq SeitRicht_AT (Anbauteil.get abtlLchb_AT SeitRicht))
	  (print SeitRicht_AT)
	  (setq abtlLchb_HT (Traeger.get HTrg AbTeil lchbBlech))
	  (setq SeitRicht_HT (Anbauteil.get abtlLchb_HT SeitRicht))
	  (print SeitRicht_HT)

	  (setq  abtl_dlr_AT (Anbauteil.get abtlLchb_AT delta_lr))
	  (setq  abtl_dlr_HT (Anbauteil.get abtlLchb_HT delta_lr))
	  (print abtl_dlr_AT)
	  (print abtl_dlr_HT)
  ))
  
  (if (= 1 2) (progn
	  (setq abtlLchb_AT (Traeger.get Tr_ID AbTeil lchbBlech))
	  (setq dv_Abtl_Lchb_AT (Anbauteil.get abtlLchb_AT delta_V))
	  (AlertBox dv_Abtl_Lchb_AT)
   ))
   (if (= 1 2) (progn
		; (Lochbild.set lchbBlech (LB_Art 2) (e "0 40 80 0 0 0") (w "60 0 0 0"))
		(Lochbild.set lchbBlech (xAsym 50) (e "0 40 80 0 0 0") (w "60 0 0 0"))
   ))
  
  
)


(defun calcAnschluss ()
	(print "ANSCHLUSS :: uz_anuz_Steg");
	(init-traegerenden)

  (setq LB_DEBUG 0)
  
	; Kopfplatten-Objekt erzeugen und in Objektliste ablegen
  (setq kpfpl	(Blech.create))
  (Connect.storeAnschlObjs CastaData kpfpl)
  
  ; At-Ende bestimmen
	(if (= (Connect.get CastaData LinkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData RechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
   
 	; Kopfplatte erzeugen
	(createKopfplatte AT_Ende kpfpl)
	(Blech.set kpfpl (dp 10))
	
	; ggf. existierendes LB bernehmen, ansonsten neues erzeugen	
	(if (= (Connect.get CastaData exist_steglchb) 1)
		(progn
			(getExistingLochbild)
		)
		(progn
			(setq lchbBlech (lochbild.create))	
  			(Connect.storeAnschlObjs CastaData lchbBlech)
			;(calcAndSetLochbildDaten lchbBlech AT_Ende kpfpl)
  			(createLochbildAbtl AT_Ende kpfpl)

			  (if (= 1 2) (progn
				;; Testen - AF-20090513
				(Lochbild.set lchbBlech (LB_Art   2))		; AF-20090512
				(Lochbild.set lchbBlech (delta_w  50))		; AF-20090512
				(Lochbild.set lchbBlech (e    "0 20 100 0 0 0")); AF-20090512
				(Lochbild.set lchbBlech (w    "75 0"))		; AF-20090512
			  ))

  		)
	) 
	
	; Traegerende um dp der Kopfplatte verkrzen
	(trimAtEndeUmKpl AT_Ende kpfpl)

	
  (if (= 2 1) (progn
       (setq ABtl_Lochb_HT (Traeger.get HTrg  ABTeil lchbBlech))
       (setq ABtl_Lochb_AT (Traeger.get TR_ID ABTeil lchbBlech))
       (Anbauteil.set ABtl_Lochb_HT (master 0))
       (Anbauteil.set ABtl_Lochb_AT (master 1))

      (Lochbild.set lchbBlech 
      		; (LB_Art 	   -2)
      		(delta_w	   45)
      		(w0		   80)
      )
      ; (Anbauteil.set  ABtl_Lochb_AT (seitricht       1))
      
      (setq SeitRicht (Anbauteil.get ABtl_Lochb_AT seitricht))
      (print SeitRicht)
  ))
 
  (if (= 2 1) (progn
	(setq ABtl_Lochb_AT (Traeger.get TR_ID ABTeil lchbBlech))
	(setq SeitRicht (Anbauteil.get ABtl_Lochb_AT seitricht))
	(print  SeitRicht)
  ))	
	
	; CALLBACKS
	(Blech.set kpfpl (formFkt "cb_kpfpl"))
	
  (print "END uz_an_uzSteg");
)



; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Kopfplatte am AT
; ----------------------------------------------------------------------------------------
(defun cb_kpfpl (zp)
	(print "CALLBACK: cb_KplBlech")
	(print zp)

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get kpfpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get kpfpl dp))

		(setq Obj_OK 0)
		(if (objExist lchbBlech) (setq Obj_OK 1))

	    (if (= Obj_OK 0) (progn
		    (if (/= dpAlt dpNeu) (progn
				(AlertBox "Lochbild nicht gefunden - Schraubenlnge wird nicht angepasst")
				(setq dpNeu dpAlt)
			))
		))
		
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) 
				(progn
					(setq dpDiff (- dpNeu dpAlt))
					(setq alteKlemml 	(Lochbild.get lchbBlech Klemml))
					(setq dxsKopf_alt 	(Lochbild.get lchbBlech dxskopf)) 
	       
					(if (= (Connect.get CastaData amHtStegRechts) 1)
						(setq dxskopf_neu dxskopf_alt)
					)
					(if (= (Connect.get CastaData amHtStegLinks) 1)
						(setq dxskopf_neu (+ dxskopf_alt dpDiff))
					)
	      
	     	             
					(Lochbild.set lchbBlech 	(Klemml (+ alteKlemml dpDiff))
									(dxskopf dxskopf_neu)
					)
					
					(if (= (Connect.get CastaData exist_steglchb) 1) 
					   (cbDeltaLR_MitGegeg_LB  lchbBlech dpDiff)	; mit Gegenanschluss eine andere Berechnung durchfhren
					   (cbDeltaLR 		lchbBlech dpDiff)	; normale Berechnung
					)
	    ))
	))
)



; ---------------------------------------------------------------------
; Korrigiert die delta_lr Verschiebung des LB-ABTL bei einem Aufruf
; der Callbackfunktion (Dickennderung des Bleches)
; ---------------------------------------------------------------------
(defun cbDeltaLR (KPL_LB DP_DIFF)
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion")
	
	; Anbauteil des HT-LB
	(setq ht_lb_abtl (Traeger.get Htrg Abteil KPL_LB))
				 
	; delta_lr Verschiebung des Anbauteils
	(setq delta_lr_abtl_alt (Anbauteil.get ht_lb_abtl delta_lr))
	(print delta_lr_abtl_alt)
	
	; Wert, um den das Anbauteil korrigiert wird (erstmal auf 0.0) 
	(setq delta_lr_abtl_neu 0.0)
	
	; Winkel des AT zum HT in horizontaler Richtung
	(setq h_wnkl_steg_at (Connect.get CastaData h-atrgewnkl_steg))
	(print h_wnkl_steg_at)
	
	(setq tanHW (tan (/ (* PI h_wnkl_steg_at) 180.0)))
	(print tanHW)
	
	(if (/= tanHW 0.0)
		(setq delta_lr_abtl_korr (/ DP_DIFF tanHW))
	)
	(print delta_lr_abtl_korr)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq delta_lr_abtl_neu (- delta_lr_abtl_alt delta_lr_abtl_korr)))
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq delta_lr_abtl_neu (+ delta_lr_abtl_alt delta_lr_abtl_korr)))
	
	; Anbauteil korrigieren
	(print delta_lr_abtl_neu)
	(Anbauteil.set ht_lb_abtl (delta_lr delta_lr_abtl_neu))
	
	(print "<------------------------------------------------------------------------------")
)

(defun cbDeltaLR_MitGegeg_LB (KPL_LB DP_DIFF)
	(print ">------------------------------------------------------------------------------")
	(print "Anbauteil Korrektur wegen Callback-Funktion - Gegenanschluss")
	
	
        (setq	abtlLchb_HT	(Traeger.get HTrg AbTeil lchbBlech))		; Anbauteil des HT-LB
        (setq 	delta_LR_HT 	(Anbauteil.get abtlLchb_HT delta_LR))		; seitliche Lochbildverschiebung

	(calc_dlr_Lochbild_HT)							; Berechnet verschiebung_delta_lr

	(setq delta_LR_AT 0.0)							; sicherheitshalber initialisieren

	(if (= (Connect.get CastaData amhtstegrechts) 1) (setq delta_LR_AT (- delta_LR_HT verschiebung_delta_lr)))
	(if (= (Connect.get CastaData amhtsteglinks)  1) (setq delta_LR_AT (- verschiebung_delta_lr delta_LR_HT)))
	(if (= (Connect.get CastaData rechtesende) 1) (setq delta_LR_AT (- delta_LR_AT)))

	; Anbauteil korrigieren
	(print delta_LR_AT)
        (setq	abtlLchb_AT	(Traeger.get Tr_ID AbTeil lchbBlech))		; Anbauteil des AT-LB
	(Anbauteil.set abtlLchb_AT (delta_lr delta_LR_AT))			; Anbauteil am AT ndern
	
	(print "<------------------------------------------------------------------------------")
)




; -------------------------------------------------------------------------
; Erzeugt die Kopfplatte
; -------------------------------------------------------------------------
(defun createKopfplatte (TrgEnde Kpfpl)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE DIE KOPFPLATTE")
	
	;Erzeugung der Kopfplatte
	(calcAndSetBlechdaten Kpfpl TrgEnde)
	
	(if (= TrgEnde TrLinks)		(traeger.addabtl tr_id Kpfpl 0.0 0.0 _kopfplattelinks_))
	(if (= TrgEnde TrRechts)	(traeger.addabtl tr_id Kpfpl 0.0 0.0 _kopfplatterechts_))
	
		
	(print "<-----------------------------------------------------------")
)


; --------------------------------------------------------------------------
; Berechnet die Daten der Kopfplatte
; --------------------------------------------------------------------------
(defun calcAndSetBlechdaten (Kpfpl TrgEnde)

  (print ">-----------------------------------------------------------")
  (print "Berechne Kopfplattendaten")

	(setq	zAkl   (trEnde.get TrgEnde zakl)
		hSteg  (trEnde.get TrgEnde hsteg)
		hProf  (Traeger.get Tr_ID h)
		h_wnkl (trEnde.get TrgEnde hsteg)
	    	qsform (Traeger.get htrg qsform)
	)
	(print "---------")
	(print zAkl)
	(print hSteg)
	(print hProf)
	(print "---------")

	(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
			(if (> zAkl 0) 	(progn
			    (if (> hSteg 0) 
			        (setq	dOK	zAkl 
			        	hp 	hSteg)			; Doppelausklinkung
			        ;else
			        (setq	dOK 	zAkl 
			        	hp 	(- hProf zAkl 5))	; nur obere Ausklinkung
			    )
			  ) ; progn
			  (progn
			    (if (> hSteg 0) 
			        (setq 	dOK 	5 
			        	hp 	hSteg)			; nur untere Ausklinkung
			        ;else
			        (setq 	dOK	5 
			        	hp 	(- hProf 10))		; keine Ausklinkung
			    )
			 )) ; progn
	))
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(if (> zAkl 0) 
				(progn
			    (if (> hSteg 0) 
			        (setq	dOK	zAkl 
			        	hp 	hSteg)			; Doppelausklinkung
			        ;else
			        (setq	dOK	zAkl 
			        	hp 	(- hProf zAkl 5))	; nur obere Ausklinkung
			    )
			  ) ; progn
			  (progn
			    (if (> hSteg 0) 
			        (setq	dOK	5 
			        	hp 	(- hsteg 5))		; nur untere Ausklinkung
			        ;else
			        (setq	dOK	5 
			        	hp 	(- hProf 10))		; keine Ausklinkung
			    )
			  ) ; progn
			)	
		)
	)
	(setq qsForm_AT (Traeger.get Tr_ID qsForm))
	(if (= qsForm_AT "C")
		(setq	hp 	(+ hProf 10)
			dOK	-5)
	)
	
	; Kpl-Breite
	(setq b_at (Traeger.get Tr_ID b))
	
  	(setq bp b_at)
	
	
	
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set Kpfpl (dp 10) (hp hp) (bp bp) (dOK dOK))
	
	(print "<-----------------------------------------------------------")
)

; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des HT, wenn Anschluss am HT-Ende
; ---------------------------------------------------------------------------------


; -------------------------------------------------------------------------
; Erzeugt die Lochbilder
; -------------------------------------------------------------------------
(if (= 1 2)	(progn
(defun createLochbild (TrgEnde BlechID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
			
	; allg. Daten
	(setq xPos_ht	(Connect.get CastaData xPos_ht))	(print xPos_ht)
	
	(setq	delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
		delta_V2 	(Traeger.get Tr_ID delta_v)
		hProf2   	(Traeger.get Tr_ID h)
		rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)

	(setq	delta_V  	(Traeger.get Htrg delta_v)
		hProf    	(Traeger.get Htrg h)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
		s_HProf 	(Traeger.get HTrg s)
		qsform_ht	(Traeger.get Htrg qsform)
	)
	
	(setq dp      		(Blech.get BlechID dp))
	
	(if (= (Connect.get CastaData vatr-vhtr) 1)
		(setq lbDOK    		(- delta_V (/ hProf 2.0) (- (- (/ hProf2 2) delta_V2))))
	)
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(setq lbDOK    		(- delta_V (/ hProf 2.0) (- (+ (/ hProf2 2) delta_V2))))
	)
			
	(print lbDOK)
	
	
	;(Lochbild.set lchbBlech (dvHTrg lbDOK))

	; dxSKopf berechnen
	(if (= (Connect.get CastaData amHtStegrechts) 1)	(setq dxSKopf (* 0.5 s_HProf)))
	(if (= (Connect.get CastaData amHtSteglinks) 1)		(setq dxSKopf (+ dp (* 0.5 s_HProf))))
	
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegrechts) 1)	(setq dxSKopf 0))
			(if (= (Connect.get CastaData amHtSteglinks) 1)		(setq dxSKopf dp ))
		)
	)
	
	; dxSKopf setzen
	(Lochbild.set lchbBlech  (dxSKopf  dxSKopf))
	
	
	; korregiere XPOS am HT des Lochbildes bei schrgem Anschluss
	(setq abst_1 (+ dp (* 0.5 s_HProf)))
	
	(setq hWnkl (Connect.get CastaData afl_hwinkel))
	(print hWnkl)
	
	(setq tanAFL (tan (/ (* PI hWnkl) 180.0)))
	(setq sinAFL (sin (/ (* PI hWnkl) 180.0)))
	(print tanafl)
	
	(setq xPosKorr_1 (/ abst_1 tanAFL))
	(print xPosKorr_1)
	
	(setq xPos_ht (+ xPos_ht xPosKorr_1))
	(print xPos_ht)
	; <-------------------------
	
	; Korregiere XPOS am HT des Lochbildes bei Verschiebung des HT in delta_lr
	(setq xPosKorr_2 (/ delta_lr_ht tanAFL))
	
	(print xPosKorr_2)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq xPos_ht (+ xPos_ht xPosKorr_2)))
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq xPos_ht (- xPos_ht xPosKorr_2)))
	
	(print xPos_ht)
	; <-------------------------
	
	; Korregiere XPOS am HT des Lochbildes bei Verschiebung des AT in delta_lr
	(setq versch_aus_delta_lr_trg (/ delta_lr_trg sinAFL))
	(print versch_aus_delta_lr_trg)
	
	(if (= TrgEnde TrLinks)
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)	
				(setq xPos_ht (+ xPos_HT versch_aus_delta_lr_trg))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPos_ht (- xPos_HT versch_aus_delta_lr_trg))
			)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			(if (= (Connect.get CastaData amHtStegLinks) 1)	
				(setq xPos_ht (- xPos_HT versch_aus_delta_lr_trg ))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPos_ht (+ xPos_HT versch_aus_delta_lr_trg ))
			)
		)
	)
	
	(print xPos_ht)
	
 	
 	; Korregiert das Lochbild und die Kopfplatte bei schrgem Anschluss, damit die Schrauben
 	; eingesetzt werden knnen
 	; --> Asymmetrie
 	(korrBlech lchbBlech BlechID)
 	(korrLochbild lchbBlech BlechID)
 	; <-------------------------
 	
 	; gleicht die Verschiebung delta_w des HT mit der des AT ab.
 	(if (> hWnkl 90.0)
 		;(setq delta_w_korr_ht (* 2.0 delta_w_lb))
 		(setq delta_w_korr_ht 0)
 		(setq delta_w_korr_ht 0)
 	)
 	(print delta_w_korr_ht)
 	
 	(setq xPos_ht (- xPos_ht delta_w_korr_ht))
 	; <-------------------------
 	
 	(setq xPos xPos_ht)
 	
 	
	
 	; Anbauteil LOCHBILD einfgen
 	; ---------------------------
	(if (= TrgEnde TrLinks)
		(progn
			(traeger.addabtl hTrg lchbBlech xPos 0.0 _steglochbild_)
			(traeger.addabtl tr_id lchbBlech 0.0 0.0 _kpllochbildlinks_)
			
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			(traeger.addabtl hTrg lchbBlech xPos 0.0 _steglochbild_)
			(traeger.addabtl tr_id lchbBlech 0.0 0.0 _kpllochbildrechts_)
		)
	)
	
	
	
	(setq steg_abtl_at (Traeger.get Tr_ID Abteil lchbBlech))
	(Anbauteil.set steg_abtl_at 	(Master 0))
	
	
	(setq steg_abtl (Traeger.get Htrg Abteil lchbBlech))
	(Anbauteil.set steg_abtl 	(Master 1)
					(delta_v (- lbDOK))
					(SeitRicht 1)
	)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(Anbauteil.set steg_abtl 	(SeitRicht -1))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(Anbauteil.set steg_abtl 	(SeitRicht -1))
			)
		)
	)
	
	
	; LOCHBILDTEST
	; ==================================================================
	(if (= LB_DUMMY 1)
		(progn
			
			(Lochbild.set lchbBlech (e2 200))
			
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lchbBlech)
			
			(if (= TrgEnde TrLinks)
				(traeger.addabtl tr_id dummy 0.0 0.0 _kpllochbildlinks_)
			)
			(if (= TrgEnde TrRechts)
				(traeger.addabtl tr_id dummy 0.0 0.0 _kpllochbildrechts_)
			)
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl 	(Master 1))
		)
	)
	; ==================================================================
	(print "<-----------------------------------------------------------")
)
))

(defun calc_HT_LchbWinkel ()
	(setq abtl_winkel 0.0)
	(setq diffWinkel  0.0)

	(setq	r_winkel_steg		(Connect.get CastaData r-atrgewnkl_steg))
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
		)
	)

	(setq abtl_winkel (- diffWinkel))
	(print abtl_winkel)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel (- 180.0 abtl_winkel)))
	(print abtl_winkel)

)

; -------------------------------------------------------------------------
; Erzeugt die Lochbilder
; -------------------------------------------------------------------------
(defun createLochbildAbtl (TrgEnde BlechID)
	
	(setq	delta_V  		(Traeger.get hTrg delta_v)
		hProf    		(Traeger.get hTrg h)
		delta_lr_ht		(Traeger.get hTrg delta_lr)
		qsform_ht		(Traeger.get Htrg qsform)
	)
	
	(setq	delta_V2 		(Traeger.get Tr_ID delta_v)
		hProf2   		(Traeger.get Tr_ID h)
		delta_lr_trg		(Traeger.get Tr_ID delta_lr)	
		rwinkel_at		(Traeger.get Tr_ID r_winkel)
	)
	
	
	(setq	xPos_HT 		(Connect.get CastaData xPos_ht)
		vwinkel_uz		(Connect.get CastaData hpttrg_vwinkel)
		r_winkel_steg		(Connect.get CastaData r-atrgewnkl_steg)
	)
	(print xPos_HT)
	
	(setq abteil_winkel 0.0)
	
	(setq xPos xPos_HT)
	
	(if (= TrgEnde TrLinks)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbBlech 0.0 0.0 _kpllochbildlinks_)
			(traeger.addabtl hTrg lchbBlech xPos abteil_winkel _steglochbild_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbBlech 0.0 0.0 _kpllochbildrechts_)
			(traeger.addabtl hTrg lchbBlech xPos abteil_winkel _steglochbild_)
		)
	)

	
	; Berechnet die Lochbilddaten der Verbindung zum HT-Steg
	(calcAndSetLochbildDaten lchbBlech TrgEnde BlechID)
	

	
	(setq ht_lochbild_abtl (Traeger.get Htrg Abteil lchbBlech))
	(setq at_lochbild_abtl (Traeger.get Tr_ID Abteil lchbBlech))
	
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print "---- Differenzwinkel ----")
	(print vwinkel_uz)
	(print rwinkel_at)
	(print r_winkel_steg)
	
	(setq diffWinkel 0.0)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- (- r_winkel_steg 90.0)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ (- r_winkel_steg 90.0)))
			)
		)
	)
	
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	; Positionierung des Anbauteil-Lochbildes am HT
	; ----------------------------------------------
	(setq verschiebung_delta_lr 0.0)
	(setq verschiebung_delta_v 0.0)
	
	
	; Winkel des Anbauteils
	; ----------------------------------------------
	(setq abtl_winkel 0.0)
	(setq abtl_winkel (- diffWinkel))
	(print abtl_winkel)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq abtl_winkel (- 180.0 abtl_winkel)))
	(print abtl_winkel)
	
	
	
	; delta_v / delta_lr Anteile allein durch Rotation und delta_v AT
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Verschiebung delta_lr des Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn	
	; ----------------------------------------------
		(print "Anteil an delta_lr")
		(print delta_V2)
		(setq h_at_halb (* 0.5 hProf2))
		(print h_at_halb)
		
		(setq verschiebung_delta_lr	(* (- h_at_halb delta_V2) sinW))
		(print verschiebung_delta_lr)
	; ----------------------------------------------	
	))
	; ----------------------------------------------
	
	; Verschiebung delta_v des Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "Anteil an delta_v")
		(setq h_ht_halb (* 0.5 hProf))
		(print h_ht_halb)
		
		;(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq rest (- h_at_halb delta_V2)))
		;(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq rest (+ h_at_halb delta_V2)))
		(setq rest (- h_at_halb delta_V2))
		(print rest)
		
		(setq rest_delta_v (* rest cosW))
		
		(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq verschiebung_delta_v (- (- h_ht_halb rest_delta_v))))
		(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq verschiebung_delta_v (- h_ht_halb rest_delta_v)))
		;(setq verschiebung_delta_v (- h_ht_halb rest_delta_v))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; HT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print delta_V)
		
		(setq verschiebung_delta_v (- verschiebung_delta_v delta_V))
		(print verschiebung_delta_v)
		(print verschiebung_delta_lr)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; AT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "=========================================> Anteil delta_lr Verschiebung AT")
		(setq at_h_winkel_steg (Connect.get CastaData h-atrgewnkl_steg))
		(print at_h_winkel_steg)
		
		(setq sinAW (sin (/ (* PI at_h_winkel_steg) 180.0)))
		(setq cosAW (cos (/ (* PI at_h_winkel_steg) 180.0)))
		
		(if (= (Connect.get CastaData vatr-vhtr) 1)
			(progn	
				(print "in 	vatr-vhtr == 1")
				(print delta_lr_trg)
				(print sinAW)
				(if (/= sinAW 0.0)
					(setq anteil_delta_lr_at	(/ (* 1.0 delta_lr_trg) sinAW))
					(setq anteil_delta_lr_at	(* 1.0 delta_lr_trg))
				)
				; AF - 	eingefgt Juni 2009 - Roationswinkel bei seitlichen Verschiebungen wurde nicht
				;	bercksichtigt.
				(setq anteil_delta_lr_at (* cosW anteil_delta_lr_at))
				(print verschiebung_delta_lr)
				(print anteil_delta_lr_at)
				
				(if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))	
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
						(print "Liste")
					)
				)
				
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
					)
				)
					
				
				(setq anteil_delta_v_at (* (* 1.0 delta_lr_trg) sinW))
				(print anteil_delta_v_at)
				(if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1) (setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
					)
				)
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
					)
				)
			)
		)
		
		(if (= (Connect.get CastaData vatr-vhtr) -1)
			(progn		
				(print delta_lr_trg)
				(if (/= sinAW 0.0)
					(setq anteil_delta_lr_at	(/ (* 1.0 delta_lr_trg) sinAW))
					(setq anteil_delta_lr_at	(* 1.0 delta_lr_trg))
				)
				(print anteil_delta_lr_at)
				; AF - 	eingefgt Juni 2009 - Roationswinkel bei seitlichen Verschiebungen wurde nicht
				;	bercksichtigt.
				(setq anteil_delta_lr_at (* cosW anteil_delta_lr_at))
				
				(if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))	
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
						(print "Liste")
					)
				)
				
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
					)
				)
					
				
				(setq anteil_delta_v_at (* (* 1.0 delta_lr_trg) sinW))
				(print anteil_delta_v_at)
				(if (= (Connect.get CastaData amHtStegLinks) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1) (setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
					)
				)
				(if (= (Connect.get CastaData amHtStegRechts) 1)
					(progn
						(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
						(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
					)
				)
			)
		)
		
		(print "<========================================= Anteil delta_lr Verschiebung AT")
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; Anteil delta_v Verschiebung AT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(print "=========================================> Anteil delta_v Verschiebung AT")
		(setq at_v_winkel_steg (Connect.get CastaData v-atrgewnkl_steg))
		(print at_v_winkel_steg)
		
		(setq delta_v_at (Traeger.get Tr_ID delta_v))
		(print delta_v_at)
		
		(setq sinVW (sin (/ (* PI at_v_winkel_steg) 180.0)))
		(print sinVW)
				
		(if (/= sinVW 0.0)
			(setq anteil_delta_v_at (/ delta_v_at sinVW))
			(setq anteil_delta_v_at delta_v_at)
		)
		(print anteil_delta_v_at)
		
		(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_delta_v_at))
		(print "<========================================= Anteil delta_v Verschiebung AT")
	; ----------------------------------------------
	))
	; ----------------------------------------------
		
		
	; Horizontale Neigung des AT

	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "=========================================> Anteil Horiz. Neigung")
		(setq at_h_winkel_steg (Connect.get CastaData h-atrgewnkl_steg))
		
		(setq dp_kpl (Blech.get BlechID dp))
		(setq dp_kpl (* 1.0 dp_kpl))
		
		(setq s_ht (Traeger.get Htrg s))
		
		(print at_h_winkel_steg)
		(print dp_kpl)
		(print s_ht)

		; Standard-Fall - HT ist I-Profil
		(setq s_ht_halb_plus_dp_kpl (+ (* 0.5 s_ht) dp_kpl))
		
		; mark_jul_2015
		; Wenn U-Profil als Haupttrger, dann s_HT anpassen.
		(setq QTyp_HT (Traeger.get HTrg QsForm))
		(if (= QTyp_HT "U") (progn
		    (if (= (Connect.get CastaData amHtStegrechts) 1) (setq s_ht_halb_plus_dp_kpl (+ s_ht dp_kpl)))
		    (if (= (Connect.get CastaData amHtSteglinks)  1) (setq s_ht_halb_plus_dp_kpl (+ 0.0  dp_kpl)))
		))
		
		(print s_ht_halb_plus_dp_kpl)
		
		(setq tanAFW (tan (/ (* PI at_h_winkel_steg) 180.0)))
		(print tanAFW)
		
		(setq anteil_h_neig_at (/ s_ht_halb_plus_dp_kpl tanAFW))
		(print anteil_h_neig_at)
	
		(if (= (Connect.get CastaData vatr-vhtr)  1)
			(progn
				(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_h_neig_at)))
				(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_h_neig_at)))
			)
		)
		(if (= (Connect.get CastaData vatr-vhtr) -1)
			(progn
				(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_h_neig_at)))
				(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_h_neig_at)))
			)
		)
		(print "<========================================= Anteil Horiz. Neigung")
	; ----------------------------------------------
	))
	; ----------------------------------------------

	
	; Vertikale Neigung des AT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(print "=========================================> Anteil Vert. Neigung")
		(print verschiebung_delta_v)
		(print verschiebung_delta_lr)
		(print "-----------------------------------------")
		
		(setq vscherl_at	(TrEnde.get TrgEnde vscherl))
		(print vscherl_at)
		
		(setq at_v_winkel_steg (Connect.get CastaData v-atrgewnkl_steg))
		(print at_v_winkel_steg)
		
		(setq h_ht (Traeger.get Htrg h)
					s_ht (Traeger.get Htrg s)
		)
		(print h_ht)
		(print s_ht)
		
		(setq vscherl_at_halb (* 0.5 vscherl_at))
		(setq h_ht_halb (* 0.5 h_ht))
		(setq s_ht_halb (* 0.5 s_ht))
		(print vscherl_at_halb)
		(print h_ht_halb)
		(print s_ht_halb)
		
		(setq anteil_v_neigung_at	(- vscherl_at_halb h_ht_halb))
		(print anteil_v_neigung_at)
		
		(if (<= at_v_winkel_steg 90.0)
			(setq at_v_wnkl (- 90.0 at_v_winkel_steg))
			(setq at_v_wnkl (- at_v_winkel_steg 90.0))
		)
		(setq tanATW (tan (/ (* PI at_v_wnkl) 180.0)))
		
		(setq s_ht_anteil (* s_ht_halb tanATW))
		(print s_ht_anteil)
		
		(print verschiebung_delta_v)
		(setq verschiebung_delta_v (- verschiebung_delta_v anteil_v_neigung_at))
		(print verschiebung_delta_v)
		
		(if (= (Connect.get CastaData amHtStegLinks) 1)
			(progn
				(if (= (Connect.get CastaData satr-lhtr) 1)
					(progn
						(if (<= at_v_winkel_steg 90.0) 	(setq verschiebung_delta_v (- verschiebung_delta_v s_ht_anteil)))
						(if (> at_v_winkel_steg 90.0) 	(setq verschiebung_delta_v (+ verschiebung_delta_v s_ht_anteil)))
					)
				)	
				(if (= (Connect.get CastaData satr-lhtr) -1)
					(progn
						(if (<= at_v_winkel_steg 90.0) 	(setq verschiebung_delta_v (+ verschiebung_delta_v s_ht_anteil)))
						(if (> at_v_winkel_steg 90.0) 	(setq verschiebung_delta_v (- verschiebung_delta_v s_ht_anteil)))
					)
				)	
			)
		)
		(if (= (Connect.get CastaData amHtStegRechts) 1)
			(progn
				(if (= (Connect.get CastaData satr-lhtr) 1)
					(progn
						(if (<= at_v_winkel_steg 90.0) 	(setq verschiebung_delta_v (+ verschiebung_delta_v s_ht_anteil)))
						(if (> at_v_winkel_steg 90.0) 	(setq verschiebung_delta_v (- verschiebung_delta_v s_ht_anteil)))
					)
				)	
				(if (= (Connect.get CastaData satr-lhtr) -1)
					(progn
						(if (<= at_v_winkel_steg 90.0) 	(setq verschiebung_delta_v (- verschiebung_delta_v s_ht_anteil)))
						(if (> at_v_winkel_steg 90.0) 	(setq verschiebung_delta_v (+ verschiebung_delta_v s_ht_anteil)))
					)
				)	
			)
		)
		(print verschiebung_delta_v)
		(print "<========================================= Anteil Vert. Neigung")
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	; Wenn HT und AT Vertikal-Richtung unterschiedlich ist
	; ----------------------------------------------
	(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq verschiebung_delta_v (+ verschiebung_delta_v h_ht)))
	
	
	
	; Besonderheiten Profile
	; ++++++++++++++++++++++++++++++++++++++++++++++
	(setq	s_at		(Traeger.get Tr_ID s)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	; U-Profil
	; ----------------------------------------------
	; LB in die Mitte setzen
	(if (= qsform_at "U") (progn
			; delta_lr Verschiebung berechnet bzgl. AT
			; ------------------------------------------
			(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq uProf_anpassung 0.0))  ;    (- (* 0.5 s_at))
			(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq uProf_anpassung 0.0)) 

;			(setq uProf_anpassung (- (* 1.0 s_at)))						
			(setq anteil_delta_lr_am_ht (* uProf_anpassung cosW))

			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_am_ht))
					)	
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
				)
			)

			
			(setq anteil_delta_v_am (* uProf_anpassung sinW))
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_delta_v_am))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_v (- verschiebung_delta_v anteil_delta_v_am))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_v (- verschiebung_delta_v anteil_delta_v_am))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_delta_v_am))
					)
				)
			)
	)) ; Ende U-Profil-Sonderbehandlung
	
	
	; Korregiert das Lochbild und die Kopfplatte bei schrgem Anschluss, damit die Schrauben
 	; eingesetzt werden knnen
 	; --> Asymmetrie
 	(korrBlech lchbBlech BlechID)
 	(korrLochbild lchbBlech BlechID)
 	; <-------------------------
	
	
	; Werte setzen
	; ----------------------------------------------
	(print "Werte:")
	(print verschiebung_delta_v)
	(print verschiebung_delta_lr)
	(Anbauteil.set	ht_lochbild_abtl	(delta_v 	verschiebung_delta_v)
						(delta_lr 	verschiebung_delta_lr)
						(winkel			abtl_winkel)
	)
	
	(if (= qsform_at "U")
		(Anbauteil.set at_lochbild_abtl (delta_lr uProf_anpassung))
	)
	
	; Master setzen
	; ----------------------------------------------
	(Anbauteil.set ht_lochbild_abtl (Master 1))
	(Anbauteil.set at_lochbild_abtl (Master 0))
	
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(Anbauteil.set ht_lochbild_abtl 	(SeitRicht -1))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(Anbauteil.set ht_lochbild_abtl 	(SeitRicht -1))
			)
		)
	)
	
	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lchbBlech)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
    	)
	    (if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1))
			
			(if (= qsform_at "U")	
				(Anbauteil.set dummy_abtl (delta_lr uProf_anpassung))
			)
		)
	)
	;===================================================================
	(print "------------------------------------------------------------")
)



; -------------------------------------------------------------------------
; Berechnet die Lochbilddaten an der Kopfplatte des AT
; -------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde BlechID)
	(print ">-----------------------------------------------------------")
	(Print "BERECHNE LOCHBILDDATEN")
	(print ">-----------------------------------------------------------")
	;Basiseinstellungen (evtl. weglassen und Gren in Abhngigkeit anderer Gren berechnen)
	(Lochbild.set Lchb_ID (Anz_S    4)
												(Guete   "4.6")
	)
	
	; Blechwerte holen
	(setq	hp_bl		(Blech.get BlechID hp)
		dp_bl		(Blech.get BlechID dp)
		bp_bl		(Blech.get BlechID bp)
		dok_bl		(Blech.get BlechID dok)
	)
	; AT-werte holen
	(setq	h_trg		(Traeger.get Tr_ID h)
		hc_trg		(Traeger.get Tr_ID hc)
		s_trg		(Traeger.get Tr_ID s)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	; HT-werte holen
	(setq	hc_htrg 	(Traeger.get Htrg hc)
		s_htrg		(Traeger.get Htrg s)
		qsform_ht	(Traeger.get Htrg qsform)
	)
	
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< dp_bl s_htrg)
		(setq min_bl dp_bl)
		(setq min_bl s_htrg)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	(print s_bez)
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq hp_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Blechhhe aus Lochbild
	
	
	
	; dxsKopf
	; ----------------------------------------------
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(setq dxskopf_ht (+ dp_bl (* 0.5 s_htrg)))
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(setq dxskopf_ht (* 0.5 s_htrg))
		)
	)
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)		(setq dxskopf_ht 0.0))
			(if (= (Connect.get CastaData amHtStegLinks) 1)			(setq dxskopf_ht dp_bl))
		)
	)
	; ----------------------------------------------
	
	; dok des Bleches 
	; ----------------------------------------------
	(print dok_bl)
	(if (= 1 2)	(progn
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(print zakl)
			(print hsteg)
			(if (/= zakl 0.0)
				(progn
					(if (/= hsteg 0.0)
						(progn
							(setq dok_bl (- h_trg (+ zakl hsteg)))
						)
						(progn
							(setq dok_bl 5)
						)
					)
				)
				(progn
					(if (/= hsteg 0.0)
						(progn
							(setq dok_bl (- h_trg hsteg))
						)
						(progn
							(print "Werte unverndert")
						)
					)
				)
			)
		)		
	)
	))
	(print dok_bl)
	
	
	; ndern der LB_ART am Trgerende bei U-Profilen
	; ----------------------------------------------
	(if (= qsform_at "U")
		(progn
			; Anschluss am HTEnde ?
			(if (= (Connect.get CastaData anHtLinkesEnde) 1)	
				(progn
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (LB_Art 2)))
					)
					(if (= (Connect.get CastaData linkesEnde) 1)
						(if (= (Connect.get CastaData satr-lhtr)  1)	(Lochbild.set Lchb_ID (LB_Art 2)))
					)
				)
			)	
			(if (= (Connect.get CastaData anHtRechtesEnde) 1)	
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(if (= (Connect.get CastaData satr-lhtr)  -1)	(Lochbild.set Lchb_ID (LB_Art 2)))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(if (= (Connect.get CastaData satr-lhtr)  -1)	(Lochbild.set Lchb_ID (LB_Art 2)))
					)
				)
			)	
		)
	)
	
	
	; Berechnung der e-Werte
	; ----------------------------------------------
	(if (> hp_bl hp_aus_e)
		(progn
			(setq e0 (+ (/ hp_bl 4.0) dok_bl))
			
			(setq e0rund (runde e0 auf 5.0))
			(setq e1 (/ hp_bl 2.0))
			(setq e1rund (runde e1 auf 5.0))
			
			(Lochbild.set Lchb_ID	(e0 e0rund)
						(e1 e1rund)
			)
			
			(if (= LB_DEBUG 1)
				(Lochbild.set Lchb_ID (e2 300))
			)
		)
		(progn
			(print hp_bl)
			(print dok_bl)
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq e0 (+ (/ hp_bl 2.0) dok_bl))
			
			(setq e0rund (runde e0 auf 5.0))
			
			(Lochbild.set Lchb_ID (e0 e0rund))
			
			(if (= LB_DEBUG 1)
				(Lochbild.set Lchb_ID (e1 300.0))
				(Lochbild.set Lchb_ID (e1   0.0))
			)
		)		
	)
	
	
	
	(calcUnterschied)
	
	; bei schrgen Anschlssen msste hier das Lochbild breiter gestaltet werden
	(setq w0 e1_blech_rund)

	(setq berechne_W0_neu 0)
	(setq bp_s (* 2.0 e1_blech_rund))
	(setq eTrg_hWinkel (TrEnde.get TrgEnde H_Winkel))
	(if (> eTrg_hWinkel 115.0) (setq berechne_W0_neu 1))
	(if (< eTrg_hWinkel  65.0) (setq berechne_W0_neu 1))
	(if (= berechne_W0_neu 1) (progn
		; (setq  e1_blech_rund (* 1.5 e1_blech_rund))
		(setq w0 (* 3.0 e1_blech_rund))
		(setq bp_s (+ w0 80.0))
	))
	
	
	; Werte setzen
	; ----------------------------------------------
	(Lochbild.set Lchb_ID 	(w0 		w0)
				(klemml 	(+ dp_bl s_htrg))
				(dxsKopf 	dxskopf_ht)
	)
	
	;Kopfplatte korrigieren
	(Blech.set BlechID (bp bp_s))
	
	
	; AT-Profil "U"
	; ----------------------------------------------
	(if (= qsform_at "U")
		(progn
			(setq	b_at 	(Traeger.get Tr_ID b)
				s_at	(Traeger.get Tr_ID s)
			)
			
			(if (= (Connect.get CastaData anHtLinkesEnde) 1)	
				(progn
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(setq delta_lr_ublech (* 0.5 b_at))
					
									(Blech.set BlechID 	(bp 			b_at)
																			(delta_lr delta_lr_ublech)
									)
									
									(setq w0 (+ (* 0.5 w0) s_at))
									(Lochbild.set Lchb_ID (w0 w0))
								)
							)
						)
					)
					(if (= (Connect.get CastaData linkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)
								(progn
									(setq delta_lr_ublech (* 0.5 b_at))
					
									(Blech.set BlechID 	(bp 			b_at)
																			(delta_lr delta_lr_ublech)
									)
									
									(setq w0 (+ (* 0.5 w0) s_at))
									(Lochbild.set Lchb_ID (w0 w0))
								)
							)
						)
					)
				)
			)
			(if (= (Connect.get CastaData anHtRechtesEnde) 1)	
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr) -1)
								(progn
									(setq delta_lr_ublech (* 0.5 b_at))
					
									(Blech.set BlechID 	(bp 			b_at)
																			(delta_lr delta_lr_ublech)
									)
									
									(setq w0 (+ (* 0.5 w0) s_at))
									(Lochbild.set Lchb_ID (w0 w0))
								)
							)
						)
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(progn
							
							(if (= (Connect.get CastaData satr-lhtr) -1)
								(progn
									(setq delta_lr_ublech (* 0.5 b_at))
					
									(Blech.set BlechID 	(bp 			b_at)
																			(delta_lr delta_lr_ublech)
									)
									
									(setq w0 (+ (* 0.5 w0) s_at))
									(Lochbild.set Lchb_ID (w0 w0))
								)
							)
						)
					)
				)
			)
			
		)
	)
	(print "<-----------------------------------------------------------")
)



(defun getLBArtUProf (Lchb_ID)

	(Lochbild.set Lchb_ID (LB_Art 2))
	
)


; -------------------------------------------------------------------------
; Korregiert das Blech und Lochbild bei einem schrgen Anschlu
; --> Asymmetrie
; -------------------------------------------------------------------------
(defun korrLochbild (Lchb_ID BlechID)
	(print "schrger Anschluss! -> korregiere Daten ...")
	
	(setq 	s_htrg 		(Traeger.get Htrg s)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq qsform_at	(Traeger.get Tr_ID qsform))
	
	
	(setq	dp_blech 	(Blech.get BlechID dp)
		bp_blech	(Blech.get BlechID bp)
	)
	
	; TODO
	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	; Schraubenlnge wird nicht richtig berechnet
	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	(setq schr_l		(Lochbild.get Lchb_ID laenge))
	(setq schr_l (+ schr_l 50)) ; Ersatzweise um 5 cm verlngert
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq afl_Winkel (Connect.get CastaData afl_hwinkel))
	(print afl_Winkel)
	
	(print schr_l)
	(setq tanW (tan (/ (* PI afl_Winkel) 180.0)))
	
	; minimaler Abstand der Schraube zum AT-Steg bei spitzem Winkel, 
	; damit die Schraube noch eingefgt werden kann.
	(setq min_Abst (/ schr_l tanW))
	(if (< min_Abst 0.0)
		(setq min_Abst (- min_Abst))
	)
	
	(setq w0 (Lochbild.get Lchb_ID w0))
	(print w0)
	
	(if (= qsform_at "U")
		(progn
			(setq w0 (* 0.5 w0))
			(print w0)
		)
	)
	
	
	; Abstand der Schraube von AT-Systemlinie bei geradem Anschluss (90).
	(setq ist_Abst (* 0.5 w0))
	
	(print min_Abst)
	(print ist_Abst)
	
	(setq delta_w_lb 0)
	(if (< ist_Abst min_Abst)
		(progn
			;Lochbild
			(setq verl_des_ist_Abst (- min_Abst ist_Abst))
			(print verl_des_ist_Abst)
			(setq verl_des_ist_Abst (runde verl_des_ist_Abst auf 5))
			(print verl_des_ist_Abst)
			(if (> afl_Winkel 90.0)
				(setq delta_w (- (* 0.5 verl_des_ist_Abst)))
				(setq delta_w (* 0.5 verl_des_ist_Abst))
			)
			(print delta_w)
			(setq delta_w_lb delta_w)
			
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq delta_w_lb (- delta_w_lb))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq delta_w_lb (- delta_w_lb))
					)
				)
			)
			(print delta_w_lb)
			
			(setq w0 (+ w0 verl_des_ist_Abst))
			(print w0)
			
			(if (= qsform_at "U")
				(progn
					(setq w0 (* 0.5 w0))
					(print w0)
				)
			)
			
			(Lochbild.set Lchb_ID  	(w0 			w0)
															(delta_w	delta_w_lb)
			)
			
		)
	)
	
	
	(print "Korrektur beendet!")
)

; -------------------------------------------------------------------------
; Korregiert das Blech bei einem schrgen Anschlu
; --> Asymmetrie
; -------------------------------------------------------------------------
(defun korrBlech (Lchb_ID BLECHID)
	(print "schrger Anschluss! -> korregiere Daten ...")
	
	(setq	s_htrg 		(Traeger.get Htrg s)
		delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq	dp_blech 	(Blech.get BlechID dp)
		bp_blech	(Blech.get BlechID bp)
	)
	
	(setq qsform_at (Traeger.get Tr_ID qsform))
	
	; TODO
	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	; Schraubenlnge wird nicht richtig berechnet
	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	(setq schr_l		(Lochbild.get Lchb_ID laenge))
	(setq schr_l (+ schr_l 50)) ; Ersatzweise um 5 cm verlngert
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq afl_Winkel (Connect.get CastaData afl_hwinkel))
	(print afl_Winkel)
	
	(print schr_l)
	(setq tanW (tan (/ (* PI afl_Winkel) 180.0)))
	
	; minimaler Abstand der Schraube zum AT-Steg bei spitzem Winkel, 
	; damit die Schraube noch eingefgt werden kann.
	(setq min_Abst (/ schr_l tanW))
	(if (< min_Abst 0.0)
		(setq min_Abst (- min_Abst))
	)
	
	(setq w0 (Lochbild.get Lchb_ID w0))
	(print w0)
	; Abstand der Schraube von AT-Systemlinie bei geradem Anschluss (90).
	(setq ist_Abst (* 0.5 w0))
	
	(print min_Abst)
	(print ist_Abst)
	
	(setq delta_w_lb 0)
	(if (< ist_Abst min_Abst)
		(progn
			(setq verl_des_ist_Abst (- min_Abst ist_Abst))
			(print verl_des_ist_Abst)
			(setq verl_des_ist_Abst (runde verl_des_ist_Abst auf 5))
			(print verl_des_ist_Abst)
			(if (> afl_Winkel 90.0)
				(setq delta_w (- (* 0.5 verl_des_ist_Abst)))
				(setq delta_w (* 0.5 verl_des_ist_Abst))
			)
			(print delta_w)
			(setq delta_w_lb delta_w)
			
			
			;Kopfplatte
			(setq bp_neu_blech (+ bp_blech verl_des_ist_Abst))
			(print bp_neu_blech)
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1) 	(setq blech_versch (- delta_w)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (setq blech_versch delta_w))
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)	(setq blech_versch delta_w))
					(if (= (Connect.get CastaData rechtesEnde) 1)	(setq blech_versch (- delta_w)))
				)
			)
			
			; rWinkel_AT sicherheitshabler nocheinmal abholen
			(setq 	rwinkel_at	(Traeger.get Tr_ID r_winkel))
			(if (= rwinkel_at 180.0)
				(setq blech_versch (- blech_versch))
			)
			; mark_jul_2015
			(print blech_versch)
			(Blech.set BlechID	(bp 		bp_neu_blech)
						(delta_lr 	blech_versch)
			)
		)
		
		
		
		
	)
)


; ---------------------------------------------------------------------------------
; Verkrzt die Breite der Kopfplatte einem U-Profil entsprechend
; ---------------------------------------------------------------------------------
(defun kuerzeBlechFuerUProf (BlechID)
	(setq b_at (Traeger.get Tr_ID b))
	(Blech.set BlechID (bp b_at))
)






(defun getExistingLochbild ()
; ---------------------------------------------------------------------
	(alertBox "
Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden.\n
Nehmen Sie nderungen ggf. manuell vor.\n
\n
Kontrollieren Sie bitte auch den Rotationswinkel der anschlieenden Trger!\n
Unterschiedliche Rotationswinkel fhren zu fehlerhaften Werkstattzeichnungen.
"  "NOTE_OppositeConnectionFound_RotAngle")
; ---------------------------------------------------------------------	
	(print "BERNEHME LOCHBILD")
	(setq lchbBlech (Connect.get CastaData steglchb_gegen))
	(Connect.storeAnschlObjs CastaData lchbBlech)

    ; - Eine etwas unbefriedigende Lsung, weil die wVersch in unterschiedliche Richtungen
    ;   luft. So ist zwar das erste Ergebnis korrekt, aber wenn man dann sich doch fr
    ;   ein asymmetrisches Lochbild entscheidet und die wVersch eintrgt, laufen die
    ;   Lochbilder auseinander. Deswegen Versuch mit SeitRicht
    (if (= 1 2) (progn	
	(setq delta_w (Lochbild.get lchbBlech delta_w))
	(if (/= delta_w 0) (progn
	     (alertBox "
Bei diesem Gegenanschluss liegt bereits ein asymmetrisches Lochbild vor.\nLochbild wird symmetrisch gestaltet.\n
\n
Bitte korrigieren Sie ggflls. die Kopfplatten an den Trgerenden der beiden Anschlsse!"
"NOTE_OppositeSideConnection_symmetrical_Holepattern"
)
	     (Lochbild.set lchbBlech (delta_w 0))
	))
    ))
	
	; Dicke der neu hinzugefgten, zweiten Kopfplatte
	(setq dp_kpl (Blech.get kpfpl dp))
	(print dp_kpl)
			
	; Klemmlnge und dxsKopf des vorh. Lochbildes		
	(setq klemml_alt 	(Lochbild.get lchbBlech klemml))
	(setq dxskopf_alt	(Lochbild.get lchbBlech dxsKopf))
	(print klemml_alt)
	(print dxskopf_alt)
			
	; Klemmlnge und dxsKopf des aktualisierten Lochbildes
	(setq klemml_neu 	(+ klemml_alt dp_kpl))
	(setq dxskopf_neu (+ dxskopf_alt dp_kpl))
	(print klemml_neu)
	(print dxskopf_neu)
	
	(setq d_schr (Lochbild.get lchbBlech sdurchm))
	(setq e1_blech (* d_schr 4.0))			
	(setq e1_blech_rund (runde e1_blech auf 5.0))
	(Blech.set kpfpl (bp (* 2.0 e1_blech_rund)))	
	
	
	(korrBlech lchbBlech kpfpl)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(Lochbild.set lchbBlech (klemml klemml_neu)
						(dxsKopf dxskopf_neu)
			)		
		)
	)		
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(Lochbild.set lchbBlech (klemml klemml_neu)
						;(dxsKopf dxskopf_neu)
			)		
		)
	)					
	(print "-------------------- - - - ------------------ - - - ------------------ - - - -----------------")
	
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(traeger.addabtl tr_id lchbBlech 0.0 0.0 _kpllochbildrechts_)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(traeger.addabtl tr_id lchbBlech 0.0 0.0 _kpllochbildlinks_)
	)
	
			
	(setq	delta_v_at 	(Traeger.get Tr_ID delta_v)
			delta_lr_at	(Traeger.get Tr_ID delta_lr)
			h_at		(Traeger.get Tr_ID h)
	)
			
	(setq	delta_v_ht	(Traeger.get Htrg delta_v)
			h_ht		(Traeger.get Htrg h)
	)
	
	(setq delta_v_gesamt (- (- (* 0.5 h_at) delta_v_at) (- (* 0.5 h_ht) delta_v_ht)))
	(print h_at) (print delta_v_at)
	(print h_ht) (print delta_v_ht)
	(print delta_v_gesamt)
	
	(setq ABTeilVorhanden (Traeger.get Htrg ABTeil lchbBlech))
	

	
	(if ABTeilVorhanden
		(progn
			(print "Anbauteil am Haupttrger gefunden.")
			; Vorbereitung Korrektur - Feb.2011 
			; Es gibt leider zwei verschiedene Steglochbildtypen
			; eines ist auf die Systemachse bezogen, das andere auf die OK des Trgers (hier des HT)
			; deswegen muss noch in einem Fall die halbe Hhe des HT bercksichtigt werden.
			(setq Steg_LB 	  131072)	; auf OK bezogen
			(setq Steg_LB_Sys 33554432)	; auf Achse bezogen (nur zur Verdeutlichung)

			(setq isType_1 (Anbauteil.get ABTeilVorhanden is_type Steg_LB))
			(setq isType_2 (Anbauteil.get ABTeilVorhanden is_type Steg_LB_Sys))
			(if (= isType_2 1) (AlertBox "Achtung - dieser Fall fhrt zu einem fehlerhaften Lochbild in der Kopfplatte"))

			(setq delta_v_vorhanden (Anbauteil.get ABTeilVorhanden delta_v))
			(print delta_v_vorhanden)
			
			(setq winkel_ht_lb_abtl (Anbauteil.get ABTeilVorhanden winkel))
			(print winkel_ht_lb_abtl)
			
			(setq LchbOrientierungGleich 0)
			(calc_HT_LchbWinkel)	; berechnet abtl_winkel
			(setq TestWinkel (- winkel_ht_lb_abtl abtl_winkel))
			(if (< TestWinkel 0.0) (setq TestWinkel (- TestWinkel)))
			(if (< TestWinkel 1.0) (setq LchbOrientierungGleich 1))

			(print "--------------------------------------- !!! -------------------------------------")
			(print ".") (print "neue Berechnung ...")
			(setq delta_v_gesamt 0.0)
			(if (= LchbOrientierungGleich 1) (progn
				(setq delta_v_Aktuell  0.0)
				(if (= (Connect.get CastaData vatr-vhtr) 1) (progn
					(print "Gleiche vertikale Richtung HT und AT")
					(setq delta_v_Aktuell (-  (- (* 0.5 h_ht) delta_v_ht) (- (* 0.5 h_at) delta_v_at))) ; delta_v_at delta_v_ht
					(setq delta_V_Diff (- delta_v_vorhanden delta_v_Aktuell))
					(setq delta_v_gesamt delta_V_Diff)
				))
				(if (= (Connect.get CastaData vatr-vhtr)-1) (progn
					(print "Entgegengesetzte vertikale Richtung HT und AT")
					(setq delta_v_Aktuell (+ (- (* 0.5 h_ht) delta_v_ht) (- (* 0.5 h_at) delta_v_at)))
					(setq delta_V_Diff (- delta_v_Aktuell delta_v_vorhanden))
					(setq delta_v_gesamt delta_V_Diff)
				))
			))
			(if (= LchbOrientierungGleich 0) (progn
				(AlertBox "Achtung!! Die Lochbilder laufen in entgegengesetzter Richtung.\nDas fhrt zu einem fehlerhaften Lochbild in der Kopfplatte")
			))
			
; 			--------------------------------------------
;	-	-	korrigiert Feb. 2011 - (AF)
;			verworfen Juni 2021
;			(print delta_v_vorhanden)
;			(setq delta_v_gesamt (+ (* 0.5 h_at) delta_v_vorhanden))
;			(setq delta_v_gesamt (+ delta_v_gesamt delta_v_ht))
;			(setq delta_v_gesamt (- delta_v_gesamt delta_v_at))

;			(print delta_v_gesamt)
;			(if (= isType_1 1) (setq delta_v_gesamt (- delta_v_gesamt (* 0.5 h_HT))))
;			Ende Korrektur
		)
	)
	
	(setq loch_at_abtl (Traeger.get Tr_ID Abteil lchbBlech))
		  
	;(setq winkel_at_loch_abtl 0.0)
	;(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq winkel_at_loch_abtl   0.0))
	(print "Delta-V des Lochbilds wird festgelegt auf:") (print delta_v_gesamt)
	
	(Anbauteil.set loch_at_abtl	(Master 	0)
		  			(delta_v 	delta_v_gesamt)
	)			

	; - Seitenrichtung
	;   Theoretisch kann einer der beiden Profile auf dem Kopf liegen - dann knnte es wieder
	;   anders herum sein - das wurde nicht getestet.
	(if (= 1 1) (progn	
	        
	        
	        (setq abtlLchb_HT (Traeger.get HTrg AbTeil lchbBlech))
	        (setq 	delta_LR_HT 	(Anbauteil.get abtlLchb_HT delta_LR)
	        	SeitRicht_HT	(Anbauteil.get abtlLchb_HT SeitRicht)
	        )
	        (if (= SeitRicht_HT 0) (setq SeitRicht_HT 1))

		(setq SeitRicht_AT 1)
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn					; OK - OK
			(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(setq SeitRicht_AT -1)
				(if (= SeitRicht_HT -1) (setq SeitRicht_AT 1))
			))
		))
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn					; OK - OK
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn
				(setq SeitRicht_AT 1)
				(if (= SeitRicht_HT -1) (setq SeitRicht_AT -1))
			))
		))
		(if (= (Connect.get CastaData amHtStegLinks) 1)	(progn					; OK - OK
			(if (= (Connect.get CastaData rechtesEnde) 1) (progn 
				(setq SeitRicht_AT 1)
				(if (= SeitRicht_HT 1) (setq SeitRicht_AT -1))
			))
		))
		(if (= (Connect.get CastaData amHtStegLinks) 1)	(progn					; OK - OK
			(if (= (Connect.get CastaData linkesEnde) 1) (progn
				(setq SeitRicht_AT -1)
				(if (= SeitRicht_HT 1) (setq SeitRicht_AT 1))
			))
		))
		(Anbauteil.set loch_at_abtl (SeitRicht SeitRicht_AT))
	        
	        (calc_dlr_Lochbild_HT)

		(setq delta_LR_AT 0.0)

		(if (= (Connect.get CastaData amhtstegrechts) 1) (setq delta_LR_AT (- delta_LR_HT verschiebung_delta_lr)))
		(if (= (Connect.get CastaData amhtsteglinks)  1) (setq delta_LR_AT (- verschiebung_delta_lr delta_LR_HT)))

		(if (= (Connect.get CastaData rechtesende) 1) (setq delta_LR_AT (- delta_LR_AT)))

		(if (= (Connect.get CastaData vatr-vhtr)-1) (setq delta_LR_AT (- delta_LR_AT)))

        (Anbauteil.set    loch_at_abtl (delta_LR    delta_LR_AT))
	))    


	;(if (= (Connect.get CastaData vatr-vhtr) -1)	(Anbauteil.set loch_at_abtl (switch_on _unterflansch_)))
	;(Blech.set kpfpl (bp (* 2 e1_blech_rund)))	

)

(defun calcUnterschied ()
	
	(setq	h_ht		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq	h_at		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- (* 1.0 delta_v_ht) h_ht_halb))	(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))			(print uKante_ht)
	(setq oKante_at	(- (* 1.0 delta_v_at) h_at_halb))	(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))			(print uKante_at)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(setq oKante_at_tmp oKante_at)
		(setq uKante_at_tmp uKante_at)
			
		(setq oKante_at (- uKante_at_tmp))
		(setq uKante_at (- oKante_at_tmp))
	))
		
	(setq diff_oben (- oKante_at oKante_ht))
	(print diff_oben)
	
)


(defun trimAtEndeUmKpl (AT_Ende BLECH_ID)
	(setq dp_kpl (Blech.get BLECH_ID dp))
	
	(TrEnde.ptrim AT_Ende dp_kpl)
)

; ----- ===================================================== ----- ======================================
(defun	calc_dlr_Lochbild_HT ()

	(setq	delta_V2 		(Traeger.get Tr_ID delta_v)
		hProf2   		(Traeger.get Tr_ID h)
		delta_lr_trg		(Traeger.get Tr_ID delta_lr)
		qsform_at 		(Traeger.get Tr_ID qsform)
		r_winkel_steg		(Connect.get CastaData r-atrgewnkl_steg)
	)

	(setq	diffWinkel 		0.0)
	(setq	verschiebung_delta_lr	0.0)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
		(if (= (Connect.get CastaData  linkesEnde) 1) (setq diffWinkel (+ (- r_winkel_steg 90.0))))
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq diffWinkel (- (- r_winkel_steg 90.0))))
	))
	(if (= (Connect.get CastaData amHtStegLinks) 1)	(progn
		(if (= (Connect.get CastaData linkesEnde) 1)  (setq diffWinkel (- (- r_winkel_steg 90.0))))
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq diffWinkel (+ (- r_winkel_steg 90.0))))
	))
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))

	(print "Anteil an delta_lr")
	(print delta_V2)
	(setq h_at_halb (* 0.5 hProf2))
	(print h_at_halb)
		
	(setq verschiebung_delta_lr	(* (- h_at_halb delta_V2) sinW))
	(print verschiebung_delta_lr)
		
		
	; ----------------------------------------------
	(print "========================================= Anteil delta_lr Verschiebung AT")
	(setq at_h_winkel_steg (Connect.get CastaData h-atrgewnkl_steg))
	(print at_h_winkel_steg)
		
	(setq sinAW (sin (/ (* PI at_h_winkel_steg) 180.0)))
	(setq cosAW (cos (/ (* PI at_h_winkel_steg) 180.0)))
	
	(setq verschiebung_delta_v 0.0)
	
	(if (= (Connect.get CastaData vatr-vhtr) 1) (progn	
		(print "in 	vatr-vhtr == 1")
		(print delta_lr_trg)
		(print sinAW)
		(if (/= sinAW 0.0)
			(setq anteil_delta_lr_at	(/ (* 1.0 delta_lr_trg) sinAW))
			(setq anteil_delta_lr_at	(* 1.0 delta_lr_trg))
		)
		; AF - 	eingefgt Juni 2009 - Roationswinkel bei seitlichen Verschiebungen wurde nicht
		;	bercksichtigt.
		(setq anteil_delta_lr_at (* cosW anteil_delta_lr_at))
		(print verschiebung_delta_lr)
		(print anteil_delta_lr_at)
				
		(if (= (Connect.get CastaData amHtStegLinks) 1)	(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))	
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
		))
				
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
		))
					
	))
		
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn		
		(print delta_lr_trg)
		(if (/= sinAW 0.0)
			(setq anteil_delta_lr_at	(/ (* 1.0 delta_lr_trg) sinAW))
			(setq anteil_delta_lr_at	(* 1.0 delta_lr_trg))
		)
		(print anteil_delta_lr_at)
		; AF - 	eingefgt Juni 2009 - Roationswinkel bei seitlichen Verschiebungen wurde nicht
		;	bercksichtigt.
		(setq anteil_delta_lr_at (* cosW anteil_delta_lr_at))
				
		(if (= (Connect.get CastaData amHtStegLinks) 1)	(progn
			(if (= (Connect.get CastaData linkesEnde)  1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))	
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
		))
				
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
		))
					
				
		(setq anteil_delta_v_at (* (* 1.0 delta_lr_trg) sinW))
		(print anteil_delta_v_at)
		(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
			(if (= (Connect.get CastaData rechtesEnde) 1) 	(setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
		))
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
		))
	))
		
	(print "<========================================= Anteil delta_lr Verschiebung AT")
	; ----------------------------------------------


        (setq BlechID kpfpl)

	; ----------------------------------------------
	(print "=========================================> Anteil Horiz. Neigung")
	(setq at_h_winkel_steg (Connect.get CastaData h-atrgewnkl_steg))
		
	(setq dp_kpl (Blech.get BlechID dp))
	(setq dp_kpl (* 1.0 dp_kpl))
		
	(setq s_ht (Traeger.get Htrg s))
		
	(print at_h_winkel_steg)
	(print dp_kpl)
	(print s_ht)

	; mark_jul_2015		
	(setq s_ht_halb_plus_dp_kpl (+ (* 0.5 s_ht) dp_kpl))
	; Wenn U-Profil als Haupttrger, dann s_HT anpassen.
	(setq QTyp_HT (Traeger.get HTrg QsForm))
	(if (= QTyp_HT "U") (progn
	    (if (= (Connect.get CastaData amHtStegrechts) 1) (setq s_ht_halb_plus_dp_kpl (+ s_ht dp_kpl)))
	    (if (= (Connect.get CastaData amHtSteglinks)  1) (setq s_ht_halb_plus_dp_kpl (+ 0.0  dp_kpl)))
	))
	
	
	(print s_ht_halb_plus_dp_kpl)
		
	(setq tanAFW (tan (/ (* PI at_h_winkel_steg) 180.0)))
	(print tanAFW)
		
	(setq anteil_h_neig_at (/ s_ht_halb_plus_dp_kpl tanAFW))
	(print anteil_h_neig_at)
		
	(if (= (Connect.get CastaData vatr-vhtr)  1) (progn
		(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_h_neig_at)))
		(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_h_neig_at)))
	))
	(if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_h_neig_at)))
		(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_h_neig_at)))
	))
	(print "<========================================= Anteil Horiz. Neigung")
	; ----------------------------------------------


	(if (= qsform_at "U") (progn
		; U-Profil-Sonderbehandlung
		; delta_lr Verschiebung berechnet bzgl. AT
		; ------------------------------------------
		(if (= (Connect.get CastaData vatr-vhtr)  1)	(setq uProf_anpassung 0.0))  ;    (- (* 0.5 s_at))
		(if (= (Connect.get CastaData vatr-vhtr) -1)	(setq uProf_anpassung 0.0)) 

		(setq anteil_delta_lr_am_ht (* uProf_anpassung cosW))
			
		(if (= (Connect.get CastaData amHtStegRechts) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_am_ht))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_am_ht))
			)
		))
		(if (= (Connect.get CastaData amHtStegLinks) 1) (progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_am_ht))
			)	
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_am_ht))
			)
		))

	)) ; Ende Sonderbehandlung U-Profil


)
; -----------------------------------------------