; $	G(31) HT	QT(IUK)		AF(S)		P(EZ)
; $	G(31) AT	QT(IUT)		AF(K)		P(E)
; $	G(31) AE	V(-)		H(-)		R(-)

; $		HT	QT(IU)		AF(S)		P(EZ)
; $ 	AT	QT(IUT)		AF(K)		P(E)
; $		AE	V(90)		H(90)		R(-)

; ------------------------------------------------
; externe Module einbinden
; ------------------------------------------------
(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
   (load "mod-lochbild")
)
; ------------------------------------------------

(defun init-connection ()

   (setq AnschlussErstellen 1)
   (setq qsform_Ht (Traeger.get HTrg qsform))
   (if (= qsform_Ht "U") (progn
	(print "U-Profil untersuchen")
        (if (= (Connect.get CastaData amHTstegLinks) 1) (progn
             (alertBox "Bitte das andere Fahnenblechmakro whlen,\ndas den Anschlusstrger nicht ausklinkt!" "ERR_ChooseMacroSimpleFinplate")
            (setq AnschlussErstellen 1)
        ))
   ))

   (if (= AnschlussErstellen 1) (progn

		(print "INITIALISIERE: uz_a_uzStegFahne.lsp");
		(print "================================================================================")
		
		; Debug-Informationen fr Lochbild anzeigen
		; ----------------------------------------------
		(setq LB_DEBUG 0)
			(print "*clear*")
		(Connect.showAttributes CastaData)
		
		(storeAblaengWhenCopied)
		; Zurechtschneiden der Trgerenden
		; ----------------------------------------------
		(init-traegerenden)
	  
		; Setzen der Verbindung
		; ----------------------------------------------
		(setConnection)

		; (print "*clear*")
	  
		(if (= 1 2) (progn
			 (setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil lchbAtrgSteg))
			 (setq dlr_Abtl_Lchb_AT (Anbauteil.get Abtl_Lchb_AT delta_lr))
		
			 (setq Abtl_Lchb_HT (Traeger.get HTrg ABTeil lchbAtrgSteg))
			 (setq dlr_Abtl_Lchb_HT (Anbauteil.get Abtl_Lchb_HT delta_lr))
			 (print dlr_Abtl_Lchb_AT)
			 (print dlr_Abtl_Lchb_HT)
		
		))
		(if (= 1 2) (progn
			(Lochbild.set lchbAtrgSteg (e "0 25 75 0 0 0"))
		))

		(if (= (Connect.get CastaData LinkesEnde) 1) (progn
		   (setq tLinks (Traeger.get Tr_ID links))
		   (TrEnde.ptrim tLinks 5.0)
		   (setq delta_L_Trg (TrEnde.get tLinks delta_L))
		   (print delta_L_Trg)
		))
		(if (= (Connect.get CastaData RechtesEnde) 1) (progn
		   (setq tRechts (Traeger.get Tr_ID rechts))
		   (TrEnde.ptrim tRechts 5.0)
		   (setq delta_L_Trg (TrEnde.get tRechts delta_L))
		   (print delta_L_Trg)
		))

		(if (= 1 2) (progn
			(setq dxSK_Test (Lochbild.get lchbAtrgSteg dxSKopf))
			(print dxSK_Test)
			
			(setq e0 (Lochbild.get  lchbAtrgSteg e0))
			(setq e0 (- e0 55))
			(Lochbild.set  lchbAtrgSteg (e "0 25 75  0 0 0") (w1 100))
			
			(Blech.set bFahnenbl (bp 100))
			
		))

        (korrigiereAblaengung)
    ))
)


; ----------------------------------------------------------------------------------------
; Erzeugt und setzt die Anbauteile der Verbindung
; ----------------------------------------------------------------------------------------
(defun setConnection ()

	(setq abstZumSteg 10) 
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  (setq bFahnenbl (blech.create))
  (setq lchbAtrgSteg (Lochbild.create))
  (Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg)
  
	(print "Fahnenblech erzeugt")
  (Blech.set bFahnenbl (dp 10) (hp 200) (bp 100) (dOK 0))
	(print "Default Blechdaten")
  (setq XPos (Connect.get CastaData XPos_HT))
  (print XPos)
	
	;(calcXPosFahne)
	
	; Berechnet den Winkel des Fahnenblech-Anbauteils
	; ----------------------------------------------
	(calcRotationFahne) ; -> abtl_fahne_winkel
	
	
  ; Anschlsse am Steg des Haupttrgers
  (if (= (Connect.get CastaData amHtStegLinks) 1) 
  	(progn
  		(print "Anschluss am Steg links")
  		(traeger.addabtl hTrg bFahnenbl XPos abtl_fahne_winkel _fahnenblech_steg_li_)
			
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn			
					(calcAndSetBlechdaten bFahnenbl TrLinks)
					(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrLinks 2)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					(calcAndSetBlechdaten bFahnenbl TrRechts)
					(setq trgLaenge (Traeger.get Tr_ID syslng))
					(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrRechts -2)
				)
			)
			
			
   	)
  )
  (if (= (Connect.get CastaData amHtStegRechts) 1) 
  	(progn
  		(print "Anschluss am Steg rechts")
			(traeger.addabtl hTrg bFahnenbl XPos abtl_fahne_winkel _fahnenblech_steg_re_)
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn			
					(calcAndSetBlechdaten bFahnenbl TrLinks)
					(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrLinks 2)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					(calcAndSetBlechdaten bFahnenbl TrRechts)
					(setq trgLaenge (Traeger.get Tr_ID syslng))
					(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrRechts -2)
			  )
			)
			
			
   	)
  )
  
	; Anbauteil des Fahnenbleches
	; ----------------------------------------------
	(setq abtl_fahne (Traeger.get Htrg AbTeil bFahnenbl))
	
	(calcPositionFahne abtl_fahne)
	;(berechneFahnenblechNeigung abtl_fahne)

  ; Lochbild HT
	(setq AbtlFahnenBl	(Traeger.get Htrg AbTeil bFahnenbl))
	
	(Traeger.addabtl Htrg lchbAtrgSteg XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)

  (setLochbild lchbAtrgSteg)
  
	  (if (= 2 3) (progn
		;; Testen - AF-20090610
		; (Lochbild.set lchbAtrgSteg (LB_Art   2))		; AF-20090512
		; (Lochbild.set lchbAtrgSteg (delta_w  50))		; AF-20090512
		(Lochbild.set lchbAtrgSteg (e    "0 30 100 0 0 0"))	; AF-20090512
		; (Lochbild.set lchbAtrgSteg (w    "23 40"))		; AF-20090512
	  ))
  
	
  ; CALLBACKS
	(Blech.set bFahnenbl (formFkt "cb_bFahnenbl"))
	
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Fahne am HT
; ----------------------------------------------------------------------------------------
(defun cb_bFahnenbl (zp)
	(print "in Callback-Funktion cb_bFahnenbl")
	(print zp)
;	(if _CopyAction_ (print "CopyAction - Kopieren wird ausgefhrt!"))

	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get bFahnenbl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get bFahnenbl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get lchbAtrgSteg Klemml))
	       (setq dxsKopf_alt	(Lochbild.get lchbAtrgSteg dxskopf))
	       (setq klemml_neu	(+ alteKlemml dpDiff))
	     
		(print alteKlemml)
		(print klemml_neu)
	       
		(if (= (Connect.get CastaData satr-lhtr)  1)
	      		(setq dxsKopf_neu dxsKopf_alt)
		)
		(if (= (Connect.get CastaData satr-lhtr) -1)
	      		(setq dxsKopf_neu (+ dxsKopf_alt dpDiff))
		)
	       
	        (Lochbild.set lchbAtrgSteg 	(klemml klemml_neu)
	       					(dxskopf dxskopf_neu)
		)
	       
	    
		(setq delta_lr_lasche_alt	(Blech.get bFahnenbl delta_lr))
	       
		(setq delta_lr_lasche_neu (+ delta_lr_lasche_alt (* 0.5 dpDiff)))
		(print delta_lr_lasche_neu)
		
		; Problem war, dass durch das Kopieren die seitliche Verschiebung
		; schon korrekt bernommen war. Also soll hier beim seitlichen
		; Verschieben diese nderung nicht nocheinmal durchgefhrt werden.
		(if _CopyAction_  (progn
			(print "nicht zurck kopieren - das muss genauer untersucht werden")
		   ; (setq delta_lr_lasche_neu delta_lr_lasche_alt)
		))
		
		(Blech.set bFahnenbl (delta_lr delta_lr_lasche_neu))
	       
	    ))
	))
)
; ====================================================================== 

; ----------------------------------------------------------------------------------------
; Whlt anhand des AT-Profils wie die Blechdaten berechnet werden
; ----------------------------------------------------------------------------------------
(defun calcAndSetBlechdaten (fahnenblech TrgEnde)
	(setq qsform_at (Traeger.get Tr_ID qsform))
	(if (= qsform_at "T") (setq qsform_at "I"))
	
	(if (= qsform_at "I")
		(calcAndSetBlechdaten_IProfil fahnenblech TrgEnde)
	)
	
	(if (= qsform_at "U")
		(calcAndSetBlechdaten_UProfil fahnenblech TrgEnde)
	)
)

; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech fr ein I-Profil
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten_IProfil (fahnenblech TrgEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN I-PROFIL")
	
	(setq hc_trg 				(Traeger.get Tr_ID hc)
				delta_v_trg 	(Traeger.get Tr_ID delta_v)
				delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
				rwnkl_trg			(Traeger.get Tr_ID r_winkel)
				hProf  				(Traeger.get Tr_ID h)
				tSteg 				(Traeger.get Tr_ID s)
				t_trg					(Traeger.get Tr_ID t)
				r_trg					(Traeger.get Tr_ID r)
	)
	(setq delta_v_htrg	(Traeger.get Htrg delta_v)
				qsform				(Traeger.get Htrg qsform)
	)
	
	(setq zAkl   (trEnde.get TrgEnde zakl)
	      hSteg  (trEnde.get TrgEnde hsteg)
	)
	
	(setq vwinkel_uz (Connect.get CastaData hpttrg_vwinkel))
	
	(if (< okAusr_htprof okAusr_anprof)
		(setq diff_dok (* 0.5 (- okAusr_htprof okAusr_anprof)))
		(setq diff_dok 0)
	)
	
	
	(setq hp hc_trg)
	
	(setq dp	(runde tSteg auf 5))
	(print dp)
	
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq diffWinkel (+ vwinkel_uz rwnkl_trg)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq diffWinkel (- vwinkel_uz rwnkl_trg )))
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)	(setq diffWinkel (- vwinkel_uz rwnkl_trg)))
			(if (= (Connect.get CastaData rechtesEnde) 1)	(setq diffWinkel (+ vwinkel_uz rwnkl_trg )))
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	; ------------------------ neu ------------------------ April 2018
	(setq sinW (sin (/ (* PI abtl_fahne_winkel) 180.0)))
	(setq cosW (cos (/ (* PI abtl_fahne_winkel) 180.0)))
	
	
	(setq dv (- (* delta_v_htrg sinW) delta_v_trg))

	(print "++++++++++++++++++++++++++++++++++++++++++++++++++++")
	(print hSteg)
	(print zAkl)
	
	(if (= 1 1) (progn
	(if (> zAkl 0) 
		(progn
			(if (> hSteg 0)
				(progn 															; Doppelausklinkung
				(setq dOK (- diff_dok);0;delta_v_trg 
							hp  hSteg 
				)
			  )
			  (progn															; nur obere Ausklinkung										
(debug on)
				(setq hRest (- hProf zAkl))
				(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg))))
				(setq dOK (+ (- dv) helpVar) 
							hp (- hRest t_trg r_trg)
				)
(debug on)
			  )	
	    )
	  ) ; progn
	  (progn
	    (if (> hSteg 0)
	    	(progn															; nur untere Ausklinkung
	    		(setq zAkl_u	(- hProf hsteg))
	      	(setq helpVar	(- zAkl_u (+ t_trg r_trg))) 
	      	(print helpVar)
	        (setq dOK (- (- dv) (* 0.5 helpVar))
	        			hp (- hSteg t_trg r_trg)
	        )			
	      )
	      (progn															; keine Ausklinkung
	        (setq dOK 0 hp hc_trg)		
	      )
	    )
	  ) ; progn
	)
))

	
;			(AlertBox cosW)
	
	(if (= rwnkl_trg 180.0) 
		(progn
			(setq delta_v_trg (- delta_v_trg))
			; (setq delta_lr_trg (- delta_lr_trg))
		)
	)
	
	(print tSteg)
	(print dp)
	
	(setq delta_lr_soll (* 0.5 (+ tSteg dp)))
		
	(print delta_lr_soll)
	(setq s_htrg (Traeger.get Htrg s))
	
	; Anteil delta_lr AT
	(if (= (Connect.get CastaData satr-lhtr-ex)  -1)	(setq delta_lr_trg (- delta_lr_trg)))
	(if (= (Connect.get CastaData satr-lhtr-ex)  0) (progn
		(if (= (Connect.get CastaData vatr-lhtr) -1)	(progn
			(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_lr_trg (- delta_lr_trg)))
		))
		(if (= (Connect.get CastaData vatr-lhtr)  1)	(progn
			(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_lr_trg (- delta_lr_trg)))
		))
	))
	
	; (AlertBox sinW)
	(setq delta_lr_soll (+ delta_lr_soll (* 1.0 delta_lr_trg)))
	
	; Blech in delta_lr
	(setq anteil_dlr_an_dvht (* delta_v_htrg cosW))
	
	(setq delta_lr_soll (- delta_lr_soll anteil_dlr_an_dvht))
	(print  cosW)
	; (setq  delta_lr_soll  -21.7)
	
	(if (< hp 40) (progn
		(setq dOK (+ dOK (* 0.5 (- 40.0 hp))))
		(setq hp 40)
	))

	
	; BLECHDATEN:
	; -----------
	(Blech.set fahnenblech 	(dp 				dp) 
							(hp 				hp) 
							(dok 				dOK) 
							(delta_lr 	delta_lr_soll)
	)
)

; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech fr ein U-Profil
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten_UProfil (fahnenblech TrgEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE FAHNENBLECH U-PROFIL")
	
	(setq hc_trg 				(Traeger.get Tr_ID hc)
				delta_v_trg 	(Traeger.get Tr_ID delta_v)
				delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
				rwnkl_trg			(Traeger.get Tr_ID r_winkel)
				hProf  				(Traeger.get Tr_ID h)
				tSteg 				(Traeger.get Tr_ID s)
				t_trg					(Traeger.get Tr_ID t)
				r_trg					(Traeger.get Tr_ID r)
	)
	(setq delta_v_htrg	(Traeger.get Htrg delta_v)
				qsform				(Traeger.get Htrg qsform)
	)
	
	(setq zAkl   (trEnde.get TrgEnde zakl)
	      hSteg  (trEnde.get TrgEnde hsteg)
	)
	(print "---------")
	(print zAkl)
	(print hSteg)
	(print hProf)
	(print "---------")
	(print hc_trg)
	(print delta_v_trg)
	(print delta_lr_trg)
	(setq hp hc_trg)
	
	(setq dp	(runde tSteg auf 5))
	
	(setq dv (- delta_v_htrg delta_v_trg))
	
(if (= 1 1) (progn
	(if (> zAkl 0) 
		(progn
	    (if (> hSteg 0)
	    	(progn 															; Doppelausklinkung
	        (setq dOK 0;delta_v_trg 
	        			hp (- hSteg 10)
	        )
	      )
	      (progn															; nur obere Ausklinkung										
	        (setq hRest (- hProf zAkl))
	      	(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg))))
	        (setq dOK (+ (- dv) helpVar) 
	        			hp (- hRest t_trg r_trg 10)
	        )
	      )													
	    )
	  ) ; progn
	  (progn
	    (if (> hSteg 0)
	    	(progn															; nur untere Ausklinkung
	    		(setq hRest (- hProf zAkl))
	      	(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg)))) 
	        (setq dOK (+ (- dv) helpVar)
	        			hp (- hSteg t_trg r_trg 10)
	        )			
	      )
	      (progn															; keine Ausklinkung
	        (setq dOK 0 hp hc_trg)		
	      )
	    )
	  ) ; progn
	)
))

	
	
	(if (= rwnkl_trg 180.0) 
		(progn
			(setq delta_v_trg (- delta_v_trg))
			(setq delta_lr_trg (- delta_lr_trg))
		)
	)
	
	
	(if (= (Connect.get CastaData amHTStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq delta_lr_soll (+ (* 0.5 dp) tSteg))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq delta_lr_soll (- (- (* 0.5 dp)) tSteg))
			)
		)
	)
	(if (= (Connect.get CastaData amHTStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq delta_lr_soll (- (- (* 0.5 dp)) tSteg))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq delta_lr_soll (+ (* 0.5 dp) tSteg ))
			)
		)
	)
			
	
	(print delta_lr_soll)
	(setq s_htrg (Traeger.get Htrg s))
	
	; Anteil delta_lr AT
	(if (= (Connect.get CastaData vatr-lhtr)  1)	
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)	
	(if (= (Connect.get CastaData vatr-lhtr) -1)	
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr)  0)
		(progn
			(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_lr_soll (+ delta_lr_soll delta_lr_trg)))
			(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_lr_soll (- delta_lr_soll delta_lr_trg)))
		)
	)
	
	; Anteil delta_v HT
	
	
	; Blech in delta_lr
	;(setq anteil_dlr_an_dvht (* delta_v_htrg sinW))
	
	;(setq delta_lr_soll (- delta_lr_soll anteil_dlr_an_dvht))
	
	(print delta_lr_soll)
	
	
	
	(print dok)
	; BLECHDATEN:
	; -----------
	; dp : Standardmig auf Dicke des Steges des Haupttrgers
	; hp : Standardmig auf hc des Anschlusstrgers
	(Blech.set fahnenblech 	(dp dp) 
													(hp hp) 
													(dok dOk) 
													(delta_lr delta_lr_soll)
	)
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------
; Berechnet die Lochbild Daten (wird hier dem AT hinzugefgt)
; ----------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde LbArt)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID	;(lb_art  LbArt)
												(Anz_S    2)
												(Guete   "4.6")
	)
	
	(setq	h_trg 		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		t_at		(Traeger.get Tr_ID t)
		r_at		(Traeger.get Tr_ID r)
	)
	
	(setq	s_htrg		(Traeger.get Htrg s)
		delta_lr_htrg	(Traeger.get Htrg delta_lr)
		delta_v_ht	(Traeger.get Htrg delta_v)
		qsform_ht	(Traeger.get Htrg	qsform)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l)
				trg_zakl		(TrEnde.get TrgEnde zakl)
	)
		
	; Schraubenbezeichnung
	(set_S_Bez Tr_ID Lchb_ID)
	
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	
	(print e_min)
	(print abstZumSteg)
	(print s_htrg)
	(setq abst_lchb_steg (+ abstZumSteg  e_min (* 0.5 s_htrg)))
	(print abst_lchb_steg)
	(print delta_lr_htrg)
	
	;(if (= (Connect.get CastaData amHtStegLinks) 1)
	;	(progn
	;		(setq w0 (- abst_lchb_steg delta_lr_htrg))
	;		(if (< delta_lr_htrg abst_lchb_steg)
	;			(setq w0_rund (runde w0 auf 5))
	;			(setq w0_rund (runde w0 ab 5))
	;		)
	;	)
	;)
	;(if (= (Connect.get CastaData amHtStegRechts) 1)
	;	(progn
	;		(setq w0 (+ abst_lchb_steg delta_lr_htrg))
	;		(if (< delta_lr_htrg abst_lchb_steg)
	;			(setq w0_rund (runde w0 ab 5))
	;			(setq w0_rund (runde w0 auf 5))
	;		)
	;	)
	;)
	(setq w0 abst_lchb_steg)
	(setq w0_rund (runde w0 auf 5))
	(print w0)
	(print w0_rund)
	
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq w0_rund (- w0_rund (* 0.5 s_htrg)))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq w0_rund (+ w0_rund (* 0.5 s_htrg)))
			)
		)
	)
	;(setq w0_rund (runde w0 auf 5))
	
	(setq hp_blech 	(Blech.get BlechID hp)
				dok_blech	(Blech.get BlechID dok)
	)
	(print hp_blech)
	(print dok_blech)
	
	(calcUnterschied)
		
	(print hsteg)
	(print zakl)
	(print diff_oben)
	; e0 berechnen
	
	(setq dxSKopf 0.0)
	
	(if (<= min_h hp_blech)
		(progn	
			(if (> zakl 0.0)
				(progn
					(setq e0 (+ (* 0.25 hp_blech) zakl))
				)
				(progn
					(setq e0 (+ (* 0.25 hp_blech) r_at t_at))
				)
			)	
			
			(print e0)
			(setq e1 (* 0.5 hp_blech))
			
			; Klemmlnge
			(setq dp_blech 	(Blech.get BlechID dp))
			(setq s_trg			(Traeger.get Tr_ID s))
			
			; Schraubenkopf
			(calcDxSKopf dp_blech s_trg)
			
			(print w0_rund)
			(Lochbild.set Lchb_ID (e0 		e0)
														(e1 		e1)
														(w0 		w0_rund)
														(klemml (+ dp_blech s_trg))
														(dxSKopf dxSKopf)
			)
			(setq testW0 (Lochbild.get Lchb_ID w0))
			(print testw0)
		)
		(progn
			(if (> zakl 0.0)
				(progn
					(setq e0 (+ (* 0.5 hp_blech) zakl))
				)
				(progn
					(setq e0 (+ (* 0.5 hp_blech) r_at t_at))
				)
			)	
			
			(print e0)
			
			
			; Klemmlnge
			(setq dp_blech 	(Blech.get BlechID dp))
			(setq s_trg			(Traeger.get Tr_ID s))
			
			; Schraubenkopf
			(calcDxSKopf dp_blech s_trg)
			
			(print w0_rund)
			(Lochbild.set Lchb_ID (e0 		e0)
														(e1 		0)
														(w0 		w0_rund)
														(klemml (+ dp_blech s_trg))
														(dxSKopf dxSKopf)
			)
			
			(setq testW0 (Lochbild.get Lchb_ID w0))
			(print testw0)
		)
	) 
	
	(print e_min)
	(print w0_rund)
	
	(if (= LB_DEBUG 1)
		(Lochbild.set Lchb_ID (e2 300))
	)
	; Korrigiere Fahnenblech
	(Blech.set BlechID (bp (+ (* 2.0 e_min_rund) abstZumSteg))) 
	
	
	
	
)


; ----------------------------------------------------------------------------------------
; Berechnet dxsKopf fr verschiedene Profile
; ----------------------------------------------------------------------------------------
(defun calcDxSKopf (DP_BLECH S_TRG)
	(print "------------------------------------------------------------")
	(print "BERECHNE DXSKOPF")
	
	; Querschnittsform holen
	(setq qsform_at (Traeger.get Tr_ID qsform))
	(if (= qsform_at "T") (setq qsform_at "I"))
	
	; I-PROFIL
	(if (= qsform_at "I")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde)	1)	(setq dxSKopf (* 0.5 S_TRG) ))
					(if (= (Connect.get CastaData RechtesEnde)	1)	(setq dxSKopf (+ (* 0.5 DP_BLECH) S_TRG)))
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde)	1)	(setq dxSKopf (+ (* 0.5 DP_BLECH) S_TRG)))
					(if (= (Connect.get CastaData RechtesEnde)	1)	(setq dxSKopf (* 0.5 S_TRG) ))
				)
			)
		)
	)
	
	; U-Profil
	(if (= qsform_at "U")
		(progn
			(setq dxSKopf 0)
		)
	)
	(print "------------------------------------------------------------")
)


; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	
	(setq h_ht				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_v_ht h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))							(print uKante_ht)
	(setq oKante_at	(- delta_v_at h_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))							(print uKante_at)
	
	
		
	(setq diff_oben (- oKante_at oKante_ht))
	
	
	
	(print diff_oben)
	
)



; ****************************************************************************************
; Berechnet die XPos des Fahnenbleches am HT
; ****************************************************************************************
(defun calcXPosFahne ()
	(print ">-------------------------------------------------------------------------------")
	(print  "BERECHNE XPOS DES FAHNENBLECHES") 
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht)
				vwinkel_uz	(Connect.get CastaData hpttrg_vwinkel)
	)
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr)
				rwinkel_at	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq delta_v_ht (Traeger.get Htrg delta_v))
	
	
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_uz rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_uz rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_uz rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_uz rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	(print cosW)
	
	(print delta_lr_at)
	
	(if (/= cosW 0.0)
		(setq anteil_delta_lr (/ delta_lr_at cosW))
		(setq anteil_delta_lr 0.0)
	)
	(print anteil_delta_lr)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq xPos (- xPos_ht anteil_delta_lr))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq xPos (+ xPos_ht anteil_delta_lr))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq xPos (+ xPos_ht anteil_delta_lr))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq xPos (- xPos_ht anteil_delta_lr))
			)
		)
	)
	
	; Anteil delta_v HT
	(setq anteil_delta_v_ht (* (* 1.0 delta_v_ht) tanW))
	(setq xPos (- xPos anteil_delta_v_ht))
	
	(print xPos)
	(print "<-------------------------------------------------------------------------------")
)



; ------------------------------------------------------------------------
; Passt die Lochbild-Anbauteile an.
; ------------------------------------------------------------------------
(defun setLochbild (LOCHB_ID)
	
	(setq h_ht				(Traeger.get Htrg h)
				s_ht				(Traeger.get Htrg s)
				b_ht				(Traeger.get Htrg b)
				delta_v_ht 	(Traeger.get Htrg delta_v)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				qsform_ht		(Traeger.get Htrg qsform)
	)
	
	(setq delta_v_at	(Traeger.get Tr_ID delta_v)
				h_at				(Traeger.get Tr_ID h)
				r_winkel_at	(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq xPos_ht 		(Connect.get CastaData xPos_ht)
				vwinkel_ht	(connect.get CastaData hpttrg_vwinkel)
				vwinkel_ht_neu	(connect.get CastaData  r-atrgewnkl_steg )
	)
	
	(setq lb_ht_abtl (Traeger.get Htrg Abteil LOCHB_ID))
	(setq lb_at_abtl (Traeger.get Tr_ID Abteil LOCHB_ID))
	
	; s_ht bei Rund- und Kastenprofilen ndern!!!
	(if (= qsform_ht "K")
		(setq s_ht b_ht)
	)
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_ht)
	(print r_winkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	; ------------------------------ neu ----------------------------- April 2018
	; der Einfachheit halber cosW weiterhin als Variable verwendet, obwohl sin eingesetzt wird.
	(setq cosW (sin (* PI (/ abtl_fahne_winkel 180.0))))
	
	; Anbauteil AT
	; ----------------------------------------------
	(setq e_diff (- (* 0.5 h_trg) (* 0.5 hp_blech)))
	
	(if (= (Connect.get CastaData amHtUnterFlansch) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 h_ht) delta_v_ht)))
	(if (= (Connect.get CastaData amHtOberFlansch) 1) 	(setq delta_lr_abtl_at (- (* 0.5 h_ht) delta_v_ht)))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1) 	(setq delta_lr_abtl_at (- (* 0.5 s_ht) delta_lr_ht)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 0.5 s_ht) delta_lr_ht)))
	
	(setq qsform_Ht (Traeger.get HTrg qsform))
	(if (= qsform_Ht "U") (progn
		(if (= (Connect.get CastaData amHtStegLinks)  1) 	(setq delta_lr_abtl_at (- (* 0.0 s_ht) delta_lr_ht)))
		(if (= (Connect.get CastaData amHtStegRechts) 1) 	(setq delta_lr_abtl_at (+ (* 1.0 s_ht) delta_lr_ht)))
	))
	
	(Anbauteil.set lb_at_abtl (delta_lr 	delta_lr_abtl_at))
	
	
	; Anbauteil HT
	; ----------------------------------------------
	(setq delta_v_abtl_ht 0.0)
	
	; Anteil delta_v AT 
	(setq anteil_delta_v_at delta_v_at)
	(print anteil_delta_v_at)
	(if (= (Connect.get CastaData vAtr-vHtr)  1) (progn
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))
		(setq delta_v_abtl_ht (- delta_v_abtl_ht (* 0.5 h_at)))
	))

	(print  delta_v_abtl_ht)
	(print  anteil_delta_v_at)
	(print   (* 0.5 h_at))
	
	(if (= (Connect.get CastaData vAtr-vHtr) -1) (progn
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht (* 0.5 h_at)))
	))
	(if (= (Connect.get CastaData vAtr-vHtr)  0) (progn
		(setq delta_v_abtl_ht (+ delta_v_abtl_ht anteil_delta_v_at))
		(setq delta_v_abtl_ht (- delta_v_abtl_ht (* 0.5 h_at)))
	))
	
	
	; Anteil delta_v HT
	(if (/= cosW  0.0)
		(setq anteil_dvHT_an_dv	(* (* 1.0 delta_v_ht) cosW))
		(setq anteil_dvHT_an_dv delta_v_ht)
	)
;	(setq cosW_Neu (sin (* PI (/ abtl_fahne_winkel 180.0))))
;	(if (/= cosW_Neu  0.0)
;		(setq anteil_dvHT_an_dv	(* (* 1.0 delta_v_ht) cosW_Neu))
;		(setq anteil_dvHT_an_dv delta_v_ht)
;	)


	
	(if (/= (Connect.get CastaData satr-lhtr-ex) 0) (progn
		(setq delta_v_abtl_ht (- delta_v_abtl_ht anteil_dvHT_an_dv))
	))
;	(if (= (Connect.get CastaData satr-lhtr-ex) 0) (progn
;		(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_v_ht))
;	))
	
	; (setq   delta_v_abtl_ht (-  delta_v_abtl_ht))

	(Anbauteil.set lb_ht_abtl (delta_v 	delta_v_abtl_ht))
	
	
	
	; Master setzen
	; ----------------------------------------------
	(Anbauteil.set lb_ht_abtl (Master 0))
	(Anbauteil.set lb_at_abtl (Master 1))
	
	
	(if (= (Connect.get CastaData linkesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
	(setq EV_EWinkel (TrEnde.get TrgEnde V_Winkel))
	(if (/= EV_EWinkel 90.0) (progn
		(print "setze Lochbildwinkel bei schrgem, Anschluss")
		(print EV_EWinkel)
		(setq VWinkel_Lchb (Anbauteil.get lb_at_abtl Winkel))
		(setq wnkl_for_Abtl (- EV_EWinkel 90.0))
		(Anbauteil.set lb_at_abtl (Winkel wnkl_for_Abtl))
		
		(setq dlr_Lchb (Anbauteil.get lb_at_abtl delta_LR))
		(setq dV_Lchb  (Anbauteil.get lb_at_abtl delta_V))
		
		(if (= (Connect.get CastaData rechtesEnde) 1) (setq wnkl_for_Abtl (- wnkl_for_Abtl)))
		
		(setq sinLchbWnkl (sin (/ (* PI wnkl_for_Abtl) 180.0)))
		(setq cosLchbWnkl (cos (/ (* PI wnkl_for_Abtl) 180.0)))
		(setq dV_Lchb (+ dV_Lchb (* dlr_Lchb sinLchbWnkl)))
		(Anbauteil.set lb_at_abtl (delta_V (- dV_Lchb)))
		(setq dlr_Lchb_Neu (* dlr_Lchb cosLchbWnkl))
		(Anbauteil.set lb_at_abtl (delta_LR dlr_Lchb_Neu))
	))

	
	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy LOCHB_ID)
						
	
	
			(if (= (connect.get CastaData amHtStegLinks) 1) 
				(Traeger.addabtl Htrg dummy XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
    	)
	    (if (= (connect.get CastaData amHtStegRechts) 1) 
				(Traeger.addabtl Htrg dummy XPos 180.0 _fahnblLochbild_ AbtlFahnenBl)
	    )
			
			(setq dummy_abtl (Traeger.get Htrg Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)
				;(delta_lr delta_lr_abtl_ht)
				(delta_v 	delta_v_abtl_ht)
			)
		)
	)
	;===================================================================
	
)

(defun calcRotationFahne ()

	; ---------------------------------------------------- neu --------------------------------------------	April 2018
	
		(setq vwinkel_ht	(Connect.get CastaData hpttrg_vwinkel))
		(print vwinkel_ht)

	
		(setq   abtl_fahne_winkel	0.0)
		(setq   rw_AT_Steg	(connect.get CastaData  r-atrgewnkl_steg))
		(print  rw_AT_Steg)

	(if (= (Connect.get CastaData amHtStegLinks ) 1) (progn
		(if (= (Connect.get CastaData linkesEnde) 1)		(setq abtl_fahne_winkel   rw_AT_Steg))
		(if (= (Connect.get CastaData rechtesEnde) 1)	(setq abtl_fahne_winkel (- 180.0  rw_AT_Steg)))
	))
	(if (= (Connect.get CastaData amHtStegRechts ) 1) (progn
		(if (= (Connect.get CastaData linkesEnde) 1) 	(setq abtl_fahne_winkel (- 180.0  rw_AT_Steg)))
		(if (= (Connect.get CastaData rechtesEnde) 1) 	(setq abtl_fahne_winkel   rw_AT_Steg))
	))

	; Sonderfall - Profile entgegengesetzte Vertikalverschiebung
	(if (= (Connect.get CastaData vAtr-vHtr) -1) 	(setq  abtl_fahne_winkel (- 180.0 abtl_fahne_winkel)))
	
	(print abtl_fahne_winkel)
	(print "<-------------------------------------------------------------------------------")
)







(defun calcPositionFahne (ABTL)
	(print ">-------------------------------------------------------------------------------")
	(print "BERECHNE DIE POSITION DES FAHNENBLECHES")
	
	(setq delta_v_ht	(Traeger.get Htrg delta_v))
	
	(setq vwinkel_uz (Connect.get CastaData hpttrg_vwinkel))
	
	(setq rwinkel_at	(Traeger.get Tr_ID r_winkel)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_ht rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_ht rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	
	(setq verschiebung_delta_v 0.0)
	(setq verschiebung_delta_lr 0.0)
	
	; HT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* delta_v_ht cosW)))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; AT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(if (= 1 2)	(progn
	; ----------------------------------------------
		(setq verschiebung_delta_v (+ verschiebung_delta_v (* delta_v_ht cosW)))
		
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	
	(setq dOK_Blech (Blech.get bFahnenbl dOK))
	(Blech.set  bFahnenbl (dOK 0))
	(setq  verschiebung_delta_v (+ verschiebung_delta_v dOK_Blech))

	; falls auf dem Kopf liegend, dann abziehen - zweimal, da schon addiert wurde.
    (if (= (Connect.get CastaData vatr-vhtr) -1) (progn
		(setq  verschiebung_delta_v (- verschiebung_delta_v dOK_Blech dOK_Blech))
	))

	; ----------------------------------------------
	; Kontrollen
	; ----------------------------------------------
	(print  verschiebung_delta_v)
	
	
	; Anbauteil Fahne Werte setzen
	(Anbauteil.set ABTL (delta_v 	verschiebung_delta_v))	
	(print "<-------------------------------------------------------------------------------")
)
; ----------------------------------------------------------------------------------------
; Berechnet die seitl. Neigung des Fahnenbleches
; ----------------------------------------------------------------------------------------
(defun berechneFahnenblechNeigung (ABTL)
	(print "BERECHNET DIE BLECHNEIGUNG")
	(print ">-----------------------------------------------------------")
	
	(setq horiz_winkel (Connect.get CastaData at_laengswinkel))
	(print horiz_winkel)
	
	
	;(Anbauteil.set ABTL (neigwnkl_d 45.0))
	
	(print "<-----------------------------------------------------------")
)
; ----------------------------------------------------------------------------------------
; Etwas mehr Abstand zwischen Steg und Trgerende bringen
; ----------------------------------------------------------------------------------------
(defun korrigiereAblaengung ()
    (if (= (Connect.get CastaData LinkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData RechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
    
    (setq at_DeltaL (TrEnde.get TrgEnde Delta_L))
    (setq nWert (runde at_DeltaL auf 5))
    (if (< (- nWert at_DeltaL) 1.0) (progn
        (setq at_DeltaL (+ 1.0 at_DeltaL))
        (setq nWert (runde at_DeltaL auf 5))
    ))
    (TrEnde.set TrgEnde (Delta_L nWert))
	
	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(if (>= dl_Vorhanden_Source nWert)  (TrEnde.set TrgEnde (Delta_L dl_Vorhanden_Source)))
	))
	
)
(defun storeAblaengWhenCopied ()
	(setq dl_Vorhanden_Source 0.0)
    (if (= (Connect.get CastaData LinkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData RechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))

	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(setq dl_Vorhanden_Source (trEnde.get TrgEnde delta_L))
	))

)
; ----------------------------------------------------------------------------------------
