(defun init-connection ()

  (print "in init-connection uz_an_uzSteg *neu*");

  (setq TrTest (traeger.create))
  (setq TrLi   (trende.create))

  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))

  (setq _links 1 _rechts 2)
  (setq bKpl_vorh        0)

  (if (= an_seite 22) (setq ept_HTrg _rechts ept_ATrg _rechts))
  (if (= an_seite 21) (setq ept_HTrg _links  ept_ATrg _rechts))
  (if (= an_seite 20) (setq ept_HTrg      0  ept_ATrg _rechts))
  (if (= an_seite 12) (setq ept_HTrg _rechts ept_ATrg _links))
  (if (= an_seite 11) (setq ept_HTrg _links  ept_ATrg _links))
  (if (= an_seite 10) (setq ept_HTrg      0  ept_ATrg _links))

; Gilt fr beide Seiten - Delta-V-Berechnung - Differenz der FlanschOK
; Einholen aller Profildaten
  (setq h_HtProf  (Traeger.get hTrg   h)
        h_AnProf  (Traeger.get Tr_ID  h)
	h_dOK     (traeger.get hTrg   delta_v)
	a_dOK     (traeger.get Tr_id  delta_v)
	hc_HtProf (Traeger.get hTrg   hc)
	hc_AnProf (Traeger.get Tr_ID  hc)
  )
; Berechnen der 4 Linien - TrgerOK, TrgerUK, obere Ausrundungslinie, untere Ausrundungslinie

   (setq zHProf (- h_dOK (* 0.5 h_HtProf))		; Oberkante der Profile (neg. nach oben)
         zAProf (- a_dOK (* 0.5 h_AnProf))
   )
   (setq zUK_HProf (+ zHProf h_HtProf)			; Unterkante der Profile (neg. nach oben)
         zUK_AProf (+ zAProf h_AnProf)
   )
   							; obere Ausrundung der Profile
   (setq okAusr_HtProf (+ zHProf (* 0.5 (- h_HtProf hc_HtProf)))
         okAusr_AnProf (+ zAProf (* 0.5 (- h_AnProf hc_AnProf)))
   )
   (setq ukAusr_HtProf (+ okAusr_HtProf hc_HtProf)	; untere Ausrundung der Profile
         ukAusr_AnProf (+ okAusr_AnProf hc_AnProf)
   )

;  Berechnung der oberen Ausklingungshhe
;  zAkl
;  Erfordlich, wenn OK des Anschlussprofils oberhalb der Ausrundungslinie des
;  Haupttrgerprofils liegt
   (if (<= zAProf okAusr_HtProf) 
     (progn
	(print "Oben ist eine Ausklinkung erforderlich")
   	(setq	zAkl1 (+  (- zAProf) okAusr_HtProf)
        	zAkl2 (+  (- zAProf) okAusr_AnProf)
   	)
   
   	(if (> zAkl1 zAkl2)
       		(setq zAkl zAkl1)
       		(setq zAkl zAkl2)
   	)
   	(if (< zAkl 0) (setq zAkl 0))		; Keine Ausklinkung erforderlich
     ); progn
     (progn
       (print "Oben ist keine Ausklinkung oben erforderlich")
       (setq zAkl 0)
     )
   ); if
   
;  Berechnung der unteren Ausklinkung
;  Ist diese Ausklinkung  unten erforderlich?
;  Nur dann, wenn UK Profil oberhalb der unteren Ausrundungslinie liegt
   (if (> zUK_AProf ukAusr_HtProf) 
   	(setq U_AKL_erforderlich 1)
   	(setq U_AKL_erforderlich 0)
   )   
   
   (setq hSteg 0)
   (if (= U_AKL_erforderlich 1) (progn
   	(print "Unten ist eine Ausklinkung erforderlich")
   	; die Hhen nach unten sind negativ. Deswegen den kleineren Wert suchen
   	(if (< ukAusr_HtProf ukAusr_AnProf) 
   		(setq ukRelevant ukAusr_HtProf)
   		(setq ukRelevant ukAusr_AnProf)
	)
	(setq untereAkl (- h_AnProf ukRelevant))
	(setq hSteg (- h_AnProf untereAkl (+ zAkl zAProf)))
      )
      (progn
   	(print "Unten ist keine Ausklinkung erforderlich!")
      )
   )

;  ------------- ab hier nun Setzen der Traegerinformationen
;  am Traegerende links, Ausklinkungen
;  und Kopfplatte   
   (if (= ept_ATrg _links) (progn
        ; h_winkel
	; (if (= ept_HTrg 0) (print "Anschluss zwischendurch - links"))
	(setq bProf (traeger.get hTrg b))
	(setq sProf (traeger.get hTrg s))

	(setq h_dOK (traeger.get hTrg  delta_v))			(print h_dOK)
	(setq a_dOK (traeger.get Tr_id delta_v))			(print a_dOK)
 
        (setq alter_hWinkel (TrEnde.get TrLinks h_Winkel))		(print alter_hWinkel)
        								(print hwnkl_aflch)

	; -- Profil-Ausklinkungsdaten
	(setq  delta_L (/ sProf 2.0)
	       xAKL    (/ bProf 2.0)
	)
	; WInkel bercksichtigen, da Ausklinkungsl-gen und delta_l in Trgerrichtung definiert ist
	(setq sinWkl (sin (/ (* PI hwnkl_aflch) 180.0)) 
	      cosWkl (cos (/ (* PI hwnkl_aflch) 180.0)) 
	)
	(if (/= sinWkl 0.0) (progn
	    (setq delta_L (/ delta_L sinWkl))
	    (setq xAKL    (/ xAKL    sinWkl))
	))


	(trende.set     TrLinks	(delta_l delta_L))
   	(if (> zAkl 0) (progn
	    (trende.set TrLinks
			(xakl  (runde_auf (+ xAKL 5) 5))
			(zakl  zAkl)
			(hsteg hSteg)
			(h_winkel hwnkl_aflch)
	    )
	))
	(if (> 	hSteg 0) (progn
	    (trende.set TrLinks
			(xakl  (runde_auf (+ xAKL 5) 5))
			(zakl  zAkl)
			(hsteg hSteg)
			(h_winkel hwnkl_aflch)
	    )
        ))

; ----	Hier nun die Kopfplatte einbauen
;	auch daran denken, dass der Anschluss neu erstellt wird. Dann 
;	Zuerst einmal die bestehenden Elemente entfernen - auch das Lochbild im Haupttrger
	(setq blKplLinks (blech.create))
	(calcAndSetBlechdaten blKplLinks TrLinks)
	(traeger.addabtl tr_id blKplLinks 0.0 0.0 _kopfplattelinks_)
	(setq bKpl_vorh  (blech.get   blKplLinks bp))


	(setq lchbKplLinks (lochbild.create))
	(calcAndSetLochbildDaten lchbKplLinks TrLinks blKplLinks)
	(traeger.addabtl tr_id lchbKplLinks 0.0 0.0 _kpllochbildlinks_)

	(setq	delta_V  (Traeger.get hTrg delta_v)
		hProf    (Traeger.get hTrg h)
		delta_V2 (Traeger.get Tr_ID delta_v)
		hProf2   (Traeger.get Tr_ID h)
		lbDOK    (- delta_V (/ hProf 2.0) (- (- (/ hProf2 2) delta_V2)))
	)
	(print lbDOK)
	(Lochbild.set lchbKplLinks (dvHTrg lbDOK))

	(traeger.addabtl hTrg lchbKplLinks xPos_HT 0.0 0)

    )); progn - if


    (if (= ept_ATrg _rechts)   (progn
        (print "Anschluss rechts");
	; (if (= ept_HTrg 0) (print "Anschluss zwischendurch - rechts"))

	(setq sProf (traeger.get hTrg s))
	(setq bProf (traeger.get hTrg b))

	(setq h_dOK (traeger.get hTrg  delta_v))			(print h_dOK)
	(setq a_dOK (traeger.get Tr_id delta_v))			(print a_dOK)
        								(print hwnkl_aflch)
	(setq hc    (Traeger.get hTrg hc))				(print hc)

	(setq  delta_L (/ sProf 2.0)
	       xAKL    (/ bProf 2.0)
	)

	(setq  delta_L (/ sProf 2.0))

	(trende.set     TrRechts	(delta_l delta_L))
   	(if (> zAkl 0) (progn
	    (trende.set TrRechts
			(xakl  (runde_auf (+ xAKL 5) 5))
			(zakl  zAkl)
			(hsteg hSteg)
			(h_winkel hwnkl_aflch)
	    )
	))
	(if (> 	hSteg 0) (progn
	    (trende.set TrRechts
			(xakl  (runde_auf (+ xAKL 5) 5))
			(zakl  zAkl)
			(hsteg hSteg)
			(h_winkel hwnkl_aflch)
	    )
        ))

; ----	Hier nun die Kopfplatte einbauen
;	auch daran denken, dass der Anschluss neu erstellt wird. Dann 
;	Zuerst einmal die bestehenden Elemente entfernen - auch das Lochbild im Haupttrger
	(setq blKplRechts (blech.create))
	(calcAndSetBlechdaten blKplRechts TrRechts)
	(traeger.addabtl tr_id blKplRechts 0.0 0.0 _kopfplatterechts_)
	(setq bKpl_vorh  (blech.get   blKplRechts bp))

	(setq lchbKplRechts (lochbild.create))
	(calcAndSetLochbildDaten lchbKplRechts TrRechts blKplRechts);
	(traeger.addabtl tr_id lchbKplRechts 0.0 0.0 _kpllochbildrechts_)
	
	(setq	delta_V (Traeger.get hTrg delta_v)
		hProf   (Traeger.get hTrg h)
		lbDOK   (- delta_V (/ hProf 2.0))
	)
	(print lbDOK)
	(Lochbild.set lchbKplRechts (dvHTrg lbDOK))

	
	(traeger.addabtl hTrg lchbKplRechts xPos_HT 0.0 0)
	
    )); progn - if


	
;	(setq dOK (trEnde.get TrRechts zakl)
;	      hp  (trEnde.get TrRechts hsteg)
;	)
;	(if (<= hp 0) (progn
;	     (setq hp 1000)
;	))
;	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
;	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
;	; wre auf jeden Fall eine sinnvolle Abhngigkeit
;	(Blech.set blKplRechts (dp 10) (hp hp) (bp 120) (dOK dOK))

	(if (= ept_HTrg _rechts) (progn
;	    (print "verlngere Haupttrger rechts")
	    (setq HTrRechts (Traeger.get hTrg rechts))
	    (korrTraegerEnde HTrRechts hTrg Tr_ID bKpl_vorh)
	))
	(if (= ept_HTrg _links) (progn
;	    (print "verlngere Haupttrger links")
	    (setq HTrLinks (Traeger.get hTrg links))
	    (korrTraegerEnde HTrLinks hTrg Tr_ID bKpl_vorh)
	))

  
)

(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)

   (print "----------------------------- In calcAndSetBlechdaten")

	(setq zAkl   (trEnde.get TrgEnde zakl)
	      hSteg  (trEnde.get TrgEnde hsteg)
	      hProf  (Traeger.get Tr_ID h)
	)
							(print "---------")
							(print zAkl)
							(print hSteg)
							(print hProf)
							(print "---------")
	(if (> zAkl 0) (progn
	    (if (> hSteg 0) 
	        (setq dOK zAkl hp hSteg)		; Doppelausklinkung
	        ;else
	        (setq dOK zAkl hp (- hProf zAkl 5))	; nur obere Ausklinkung
	    )
	  ) ; progn
	  (progn
	    (if (> hSteg 0) 
	        (setq dOK 5 hp hSteg)			; nur untere Ausklinkung
	        ;else
	        (setq dOK    5 hp (- hProf 10))		; keine Ausklinkung
	    )
	  ) ; progn
	)	
        (setq bp 120)
	      
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp 10) (hp hp) (bp bp) (dOK dOK))
	
	(TrEnde.pTrim TrgEnde 10)
)
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde KopfPl)
	(Lochbild.set Lchb_ID 
	        (Anz_S    4)
		(S_Bez   "M20")
		(Guete   "4.6")
		(e       "100 50 0 0 0 0")
		(w       "80  0")
		(klemml   55)
	)
	(Lochbild.anordnen Lchb_ID KopfPl " 2")
)

(defun korrTraegerEnde (TrgEnde hTrg Tr_ID bp)
	(setq deltaL (trEnde.get TrgEnde delta_l))
	(setq bProf (Traeger.get Tr_ID b))
	(if (> bp bProf) 
	    (setq bMassGeb bp)
	    (setq bMassGeb bProf)
	)
	(print bProf) (print bp) (print bMassGeb)
	; Bei U-Profilen muss noch die Lage analysiert werden
	; Beachten - deltaL ist negativ bei Verlngerungen und positiv bei 
	; Verkrzen. Deswgen hierfolgend den kleineren Wert untersuchen
	(if (>= deltaL 0) (progn
	    (setq deltaL (- (/ bMassGeb 2)))
	    (trEnde.set TrgEnde (delta_l deltaL))
	  )
	  ; else
	  (if (> deltaL (/ bMassGeb 2)) (progn
	    (setq deltaL (- (/ bMassGeb 2)))
	    (trEnde.set TrgEnde (delta_l deltaL))
	  ))
	)
)
; ====================================================================== 
