; $	HT	QT(IU)	AF(FS)	P(EZ)
; $	AT	QT(IU)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
   (load "mod-lochbild")
)

(defun init-connection ()

  (print "in init-connection uz_an_uzSteg *neu*");
	(init-traegerenden)
  
  (setq abstZumSteg 10) 
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  (setq bFahnenbl (blech.create))
  (setq lchbAtrgSteg (Lochbild.create))
  (Connect.storeAnschlObjs CastaData bFahnenbl lchbAtrgSteg)
  
	(print "Fahnenblech erzeugt")
  (Blech.set bFahnenbl (dp 10) (hp 200) (bp 100) (dOK 0))
	(print "Default Blechdaten")
  (setq XPos (Connect.get CastaData XPos_HT))
  (print XPos)
	;(setq w (blech.get bFahnenbl WInkel))
	;(print w)
	(calcXPosFahne)
  ; Anschlsse am Steg des Haupttrgers
  (if (= (Connect.get CastaData amHtStegLinks) 1) 
  	(progn
  		(print "Anschluss am Steg links")
  		(traeger.addabtl hTrg bFahnenbl XPos 90.0 _fahnenblech_steg_li_)
			
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn			
					(calcAndSetBlechdaten bFahnenbl TrLinks)
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrLinks 2)
					(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					(calcAndSetBlechdaten bFahnenbl TrRechts)
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrRechts -2)
					(setq trgLaenge (Traeger.get Tr_ID syslng))
					(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
				)
			)
			
			
   	)
  )
  (if (= (Connect.get CastaData amHtStegRechts) 1) 
  	(progn
  		(print "Anschluss am Steg rechts")
			(traeger.addabtl hTrg bFahnenbl XPos 90.0 _fahnenblech_steg_re_)
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn			
					(calcAndSetBlechdaten bFahnenbl TrLinks)
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrLinks 2)
					(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					(calcAndSetBlechdaten bFahnenbl TrRechts)
					(calcAndSetLochbildDaten lchbAtrgSteg bFahnenbl TrRechts -2)
					(setq trgLaenge (Traeger.get Tr_ID syslng))
			  	(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
			  )
			)
			
			
   	)
  )

  (createSteife)
)

; ====================================================================== 

; ----------------------------------------------------------------------------------------
; Whlt anhand des AT-Profils wie die Blechdaten berechnet werden
; ----------------------------------------------------------------------------------------
(defun calcAndSetBlechdaten (fahnenblech TrgEnde)
	(setq qsform_at (Traeger.get Tr_ID qsform))
	
	(if (= qsform_at "I")
		(calcAndSetBlechdaten_IProfil fahnenblech TrgEnde)
	)
	
	(if (= qsform_at "U")
		(calcAndSetBlechdaten_UProfil fahnenblech TrgEnde)
	)
)

; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech fr ein I-Profil
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten_IProfil (fahnenblech TrgEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE BLECHDATEN I-PROFIL")
	
	(setq hc_trg 				(Traeger.get Tr_ID hc)
				delta_v_trg 	(Traeger.get Tr_ID delta_v)
				delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
				rwnkl_trg			(Traeger.get Tr_ID r_winkel)
				hProf  				(Traeger.get Tr_ID h)
				tSteg 				(Traeger.get Tr_ID s)
				t_trg					(Traeger.get Tr_ID t)
				r_trg					(Traeger.get Tr_ID r)
	)
	(setq delta_v_htrg	(Traeger.get Htrg delta_v)
				qsform				(Traeger.get Htrg qsform)
	)
	
	(setq zAkl   (trEnde.get TrgEnde zakl)
	      hSteg  (trEnde.get TrgEnde hsteg)
	)
	
	(if (< okAusr_htprof okAusr_anprof)
		(setq diff_dok (* 0.5 (- okAusr_htprof okAusr_anprof)))
		(setq diff_dok 0)
	)
	
	(print "---------")
	(print zAkl)
	(print hSteg)
	(print hProf)
	(print "---------")
	(print hc_trg)
	(print delta_v_trg)
	(print delta_lr_trg)
	(setq hp hc_trg)
	
	(setq dp    (Blech.get  	bFahnenbl dp))
	
	(setq dv (- delta_v_htrg delta_v_trg))
	
	(if (= 1 1) (progn
	(if (> zAkl 0) 
		(progn
	    (if (> hSteg 0)
	    	(progn 															; Doppelausklinkung
	        (setq dOK (- diff_dok);0;delta_v_trg 
	        			hp  hSteg 
	        )
	      )
	      (progn															; nur obere Ausklinkung										
	        (setq hRest (- hProf zAkl))
	      	(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg))))
	        (setq dOK (+ (- dv) helpVar) 
	        			hp (- hRest t_trg r_trg)
	        )
	      )													
	    )
	  ) ; progn
	  (progn
	    (if (> hSteg 0)
	    	(progn															; nur untere Ausklinkung
	    		(setq zAkl_u	(- hProf hsteg))
	      	(setq helpVar	(- zAkl_u (+ t_trg r_trg))) 
	      	(print helpVar)
	        (setq dOK (- (- dv) (* 0.5 helpVar))
	        			hp (- hSteg t_trg r_trg)
	        )			
	      )
	      (progn															; keine Ausklinkung
	        (setq dOK 0 hp hc_trg)		
	      )
	    )
	  ) ; progn
	)
))

	
	
	(if (= rwnkl_trg 180.0) 
		(progn
			(setq delta_v_trg (- delta_v_trg))
			(setq delta_lr_trg (- delta_lr_trg))
		)
	)
	(setq delta_lr_soll (+ (* 0.5 (+ tSteg dp))))
	
	(if (= (Connect.get CastaData amHTStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq delta_lr_soll (* 0.5 (+ tSteg dp)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq delta_lr_soll (* 0.5 (+ tSteg dp)))
			)
		)
	)
	(if (= (Connect.get CastaData amHTStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq delta_lr_soll (* 0.5 (+ tSteg dp)))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq delta_lr_soll (* 0.5 (+ tSteg dp)))
			)
		)
	)
	
	(print delta_lr_soll)
	(setq s_htrg (Traeger.get Htrg s))
	
	
	
	(print dok)
	; BLECHDATEN:
	; -----------
	; dp : Standardmig auf Dicke des Steges des Haupttrgers
	; hp : Standardmig auf hc des Anschlusstrgers
	(Blech.set fahnenblech 	(dp 				s_htrg) 
													(hp 				hp) 
													(dok 				dOK) 
													(delta_lr 	delta_lr_soll)
	)
)

; ------------------------------------------------------------------------
; Erzeugt ein Fahnenblech fr ein U-Profil
; ------------------------------------------------------------------------
(defun calcAndSetBlechdaten_UProfil (fahnenblech TrgEnde)
	(print "------------------------------------------------------------")
	(print "BERECHNE FAHNENBLECH U-PROFIL")
	
	(setq hc_trg 				(Traeger.get Tr_ID hc)
				delta_v_trg 	(Traeger.get Tr_ID delta_v)
				delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
				rwnkl_trg			(Traeger.get Tr_ID r_winkel)
				hProf  				(Traeger.get Tr_ID h)
				tSteg 				(Traeger.get Tr_ID s)
				t_trg					(Traeger.get Tr_ID t)
				r_trg					(Traeger.get Tr_ID r)
	)
	(setq delta_v_htrg	(Traeger.get Htrg delta_v)
				qsform				(Traeger.get Htrg qsform)
	)
	
	(setq zAkl   (trEnde.get TrgEnde zakl)
	      hSteg  (trEnde.get TrgEnde hsteg)
	)
	(print "---------")
	(print zAkl)
	(print hSteg)
	(print hProf)
	(print "---------")
	(print hc_trg)
	(print delta_v_trg)
	(print delta_lr_trg)
	(setq hp hc_trg)
	
	(setq dp    (Blech.get  	bFahnenbl dp))
	
	(setq dv (- delta_v_htrg delta_v_trg))
	
	(if (= 1 1) (progn
	(if (> zAkl 0) 
		(progn
	    (if (> hSteg 0)
	    	(progn 															; Doppelausklinkung
	        (setq dOK 0;delta_v_trg 
	        			hp (- hSteg 10)
	        )
	      )
	      (progn															; nur obere Ausklinkung										
	        (setq hRest (- hProf zAkl))
	      	(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg))))
	        (setq dOK (+ (- dv) helpVar) 
	        			hp (- hRest t_trg r_trg 10)
	        )
	      )													
	    )
	  ) ; progn
	  (progn
	    (if (> hSteg 0)
	    	(progn															; nur untere Ausklinkung
	    		(setq hRest (- hProf zAkl))
	      	(setq helpVar	(* 0.5 (- zAkl (+ t_trg r_trg)))) 
	        (setq dOK (+ (- dv) helpVar)
	        			hp (- hSteg t_trg r_trg 10)
	        )			
	      )
	      (progn															; keine Ausklinkung
	        (setq dOK 0 hp hc_trg)		
	      )
	    )
	  ) ; progn
	)
))

	
	
	(if (= rwnkl_trg 180.0) 
		(progn
			(setq delta_v_trg (- delta_v_trg))
			(setq delta_lr_trg (- delta_lr_trg))
		)
	)
	(print tSteg)
	(print dp)
	(setq delta_lr_soll (+ tSteg (* 0.5 dp)))
	(if (= (Connect.get CastaData amHTStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq delta_lr_soll (+ (* 0.5 dp) tSteg))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq delta_lr_soll (- (- (* 0.5 dp)) tSteg))
			)
		)
	)
	(if (= (Connect.get CastaData amHTStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq delta_lr_soll (- (- (* 0.5 dp)) tSteg))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq delta_lr_soll (+ (* 0.5 dp) tSteg))
			)
		)
	)
	
	(print delta_lr_soll)
	(setq s_htrg (Traeger.get Htrg s))
	
	
	(print dok)
	; BLECHDATEN:
	; -----------
	; dp : Standardmig auf Dicke des Steges des Haupttrgers
	; hp : Standardmig auf hc des Anschlusstrgers
	(Blech.set fahnenblech (dp s_htrg) (hp hp) (dok dOk) (delta_lr delta_lr_soll))
	(print "------------------------------------------------------------")
)

; ----------------------------------------------------------------------------
; Berechnet die Lochbild Daten (wird hier dem AT hinzugefgt)
; ----------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID BlechID TrgEnde LbArt)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID	(lb_art  LbArt)
												(Anz_S    2)
												(Guete   "4.6")
												(e       "100 50 0 0 0 0")
												(w       "0  0")
												
	)
	
	(setq h_trg 			(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				t_at				(Traeger.get Tr_ID t)
				r_at				(Traeger.get Tr_ID r)
	)
	
	(setq s_htrg				(Traeger.get Htrg s)
				delta_lr_htrg	(Traeger.get Htrg delta_lr)
				delta_v_ht		(Traeger.get Htrg delta_v)
				qsform_ht			(Traeger.get Htrg	qsform)
	)
	
	(setq trg_delta_l (TrEnde.get TrgEnde delta_l)
				trg_zakl		(TrEnde.get TrgEnde zakl)
	)
		
	; Schraubenbezeichnung
	(set_S_Bez Tr_ID Lchb_ID)
	
	; min. Loch- u. Randabstnde
	(calcMinRandLochAbst Lchb_ID)
	
	
	(print e_min)
	(print abstZumSteg)
	(print s_htrg)
	(setq abst_lchb_steg (+ abstZumSteg e_min (* 0.5 s_htrg)))
	(print abst_lchb_steg)
	(print delta_lr_htrg)
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(setq w0 (- abst_lchb_steg delta_lr_htrg))
			(if (< delta_lr_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 auf 5))
				(setq w0_rund (runde w0 ab 5))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(setq w0 (+ abst_lchb_steg delta_lr_htrg))
			(if (< delta_lr_htrg abst_lchb_steg)
				(setq w0_rund (runde w0 ab 5))
				(setq w0_rund (runde w0 auf 5))
			)
		)
	)
	(print w0)
	(print w0_rund)
	
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq w0_rund (- w0_rund (* 0.5 s_htrg)))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq w0_rund (+ w0_rund (* 0.5 s_htrg)))
			)
		)
	)
	;(setq w0_rund (runde w0 auf 5))
	
	(setq hp_blech 	(Blech.get BlechID hp)
				dok_blech	(Blech.get BlechID dok)
	)
	(print hp_blech)
	(print dok_blech)
	
	(calcUnterschied)
		
	(print hsteg)
	(print zakl)
	(print diff_oben)
	; e0 berechnen
	
	(if (<= min_h hp_blech)
		(progn	
			(if (> zakl 0.0)
				(progn
					(setq e0 (+ (* 0.25 hp_blech) zakl))
				)
				(progn
					(setq e0 (+ (* 0.25 hp_blech) r_at t_at))
				)
			)	
			
			(print e0)
			(setq e1 (* 0.5 hp_blech))
			
			; Klemmlnge
			(setq dp_blech 	(Blech.get BlechID dp))
			(setq s_trg			(Traeger.get Tr_ID s))
			
			; Schraubenkopf
			(calcDxSKopf dp_blech s_trg)
			
			
			(Lochbild.set Lchb_ID (e0 		e0)
														(e1 		e1)
														(w0 		w0_rund)
														(klemml (+ dp_blech s_trg))
														(dxSKopf dxSKopf)
			)
		)
		(progn
			(if (> zakl 0.0)
				(progn
					(setq e0 (+ (* 0.5 hp_blech) zakl))
				)
				(progn
					(setq e0 (+ (* 0.5 hp_blech) r_at t_at))
				)
			)	
			
			(print e0)
			
			
			; Klemmlnge
			(setq dp_blech 	(Blech.get BlechID dp))
			(setq s_trg			(Traeger.get Tr_ID s))
			
			; Schraubenkopf
			(calcDxSKopf dp_blech s_trg)
			
			
			(Lochbild.set Lchb_ID (e0 		e0)
														(e1 		0)
														(w0 		w0_rund)
														(klemml (+ dp_blech s_trg))
														(dxSKopf dxSKopf)
			)
		)
	) 
	
	(print e_min)
	(print w0)
	
	
	; Korregiere Fahnenblech
	(Blech.set BlechID (bp (+ (* 2.0 e_min_rund) abstZumSteg))) 
)


; ----------------------------------------------------------------------------------------
; Berechnet dxsKopf fr verschiedene Profile
; ----------------------------------------------------------------------------------------
(defun calcDxSKopf (DP_BLECH S_TRG)
	(print "------------------------------------------------------------")
	(print "BERECHNE DXSKOPF")
	
	; Querschnittsform holen
	(setq qsform_at (Traeger.get Tr_ID qsform))
	
	; I-PROFIL
	(if (= qsform_at "I")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde) 1)
						(setq dxSKopf (* 0.5 s_trg))
					)
					(if (= (Connect.get CastaData RechtesEnde) 1)
						(setq dxSKopf (+ (* 0.5 s_trg) dp_blech))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData LinkesEnde) 1)
						(setq dxSKopf (+ (* 0.5 s_trg) dp_blech))	
					)
					(if (= (Connect.get CastaData RechtesEnde) 1)
						(setq dxSKopf (* 0.5 s_trg))
					)
				)
			)
		)
	)
	
	; U-Profil
	(if (= qsform_at "U")
		(progn
			(setq dxSKopf 0)
		)
	)
	(print "------------------------------------------------------------")
)


; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	
	(setq h_ht				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_v_ht h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))							(print uKante_ht)
	(setq oKante_at	(- delta_v_at h_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))							(print uKante_at)
	
	
		
	(setq diff_oben (- oKante_at oKante_ht))
	
	
	
	(print diff_oben)
	
)

(defun calcXPosFahne ()
	(setq xPos_ht (Connect.get CastaData xPos_ht))
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq xPos (- xPos_ht delta_lr_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq xPos (+ xPos_ht delta_lr_at))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq xPos (+ xPos_ht delta_lr_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq xPos (- xPos_ht delta_lr_at))
			)
		)
	)
	
)


(defun createSteife ()
	
	(setq steife (Blech.create))
	(Connect.storeAnschlObjs CastaData steife)
	
	(setq s_ht				(Traeger.get Htrg s))
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos 				(Connect.get CastaData xPos_ht)
			  at_lwinkel	(Connect.get CastaData at_laengswinkel)
	)
	
	
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_rechts_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_links_)
	)
	
	; xPos berechnen
		
	;Anteil delta_lr AT
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos delta_lr_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (- xPos delta_lr_at)))
	
	;Anteil AT Schrgstellung (Kopfplatte / HT-Steg)
	(setq tanW (tan (/ (* PI at_lwinkel) 180.0)))
	(setq anteil_schraege (/ (* s_ht 0.5) tanW))
	
	(if (> at_lwinkel 90.0)
		(setq at_lwinkel (- at_lwinkel 90.0))
	)
	
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos anteil_schraege)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (+ xPos anteil_schraege)))
	
	(setq AbtlSteife (traeger.get Htrg ABTeil steife))
	(Anbauteil.set  AbtlSteife (xpos xPos))
)