; $ G(23)	HT	QT(IU)		AF(S)		P(EZ)
; $ G(23)	AT	QT(T)		AF(K)		P(E)
; $ G(23)	AE	V(90)		H(90)		R(46-135)
; $ 		HT	QT(IU)		AF(S)		P(EZ)
; $ 		AT	QT(IUT)		AF(K)		P(E)
; $ 		AE	V(90)		H(90)		R(46-135)

(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
   (load "mod-connection")
   (load "mod-lochbild")
)

(defun init-connection ()
	
	(setq LB_DEBUG 0)
	
	(Connect.showAttributes CastaData)
	
  (print "BEGIN init-connection uz_an_uzStegMitWinkeln");
  (setq rwinkel_at (Traeger.get Tr_ID r_winkel))
  
  (setq anz_Anschl (Connect.get CastaData anz_weitere_Anschl))
  (print anz_Anschl)
  (if (> anz_Anschl 0)
  	(progn
  		;(checkForSteifen)
  	)
  )
  
  ;(if (/= rwinkel_at 0.0)
  ;	(print "Bitte setzen Sie den Rotationswinkel des Anschlusstrgers auf 0."   "Set_RotAngle_AT_To_Zero")
		(setConnection)
	;)
	
	
  (print "END init-connection uz_an_uzStegMitWinkeln");
)

(defun setConnection ()
	(print "IMPORT mod-endinit-uz-uzsteg")
	(storeAblaengWhenCopied)
	(init-traegerenden)
  (print "IMPORT ENDE")
  
  ; linkes und rechtes AT-Ende festlegen  
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  ; Anbauteile bereitstellen
  (setq winkel_blech	(Winkel.create))
	(setq lchbAtrgSteg (lochbild.create))
  (Connect.storeAnschlObjs CastaData winkel_blech lchbAtrgSteg)
  
  (setq test (Connect.get CastaData exist_steglchb))
  (print test)
  
  (if (= (Connect.get CastaData exist_steglchb) 1)
  	(progn
  		(setq lchbWnkl	(Connect.get CastaData steglchb_gegen))
  	)
  	(progn
			(setq lchbWnkl (lochbild.create))
		)
	)
  (Connect.storeAnschlObjs CastaData lchbWnkl)
  
  ; Winkeldicke festlegen
	(setq wnkl_dw 10)

	(if (= (Connect.get CastaData LinkesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData RechtesEnde) 1)	(setq AT_Ende (Traeger.get Tr_ID rechts)))
  
  
  ; Winkel erzeugen
	(createWinkel AT_Ende winkel_blech)
	
	
	(if (= (Connect.get CastaData exist_steglchb) 1)
  		(getExistingLochbild)
  		(progn
			(createLochbildAbtl AT_Ende winkel_blech)

			  (if (= 1 2) (progn
				;; Testen - AF-20090513
				(Lochbild.set lchbWnkl (LB_Art   2))		; AF-20090512
				(Lochbild.set lchbWnkl (delta_w  0))		; AF-20090512
				(Lochbild.set lchbWnkl (e    "0 30 100 0 0 0"))	; AF-20090512
				(Lochbild.set lchbWnkl (w    "23 40"))		; AF-20090512

;				(setq ht_lochbild_abtl (Traeger.get Htrg Abteil lchbWnkl))
;				(setq dummy_delta_lr (Anbauteil.get ht_lochbild_abtl delta_lr))
;				(print dummy_delta_lr)
	  		))

		)
	)	
	
	(if (= (Connect.get CastaData anz_weitere_anschl) 0)
		(if (= (Connect.get CastaData anschlZwHtEnden) 0)
			(korrHtEnde winkel_blech)
		)
	)
	
	; Ablngung korrigieren, weil hier auch Knirsch-Ablngungen vorkommen knnen
	; Bei Winkelanschlssen sollte hier ein Spalt bestehen bleiben
	(korrigiereAblaengung)

	
	; CALLBACKS
	(Winkel.set winkel_blech (formFkt "cb_winkel"))
	
	(setq lbTest (Lochbild.get lchbAtrgSteg dxskopf))
	(print lbtest)
)


; ========================================================================================
; CALLBACK-FUNKTIONEN
; ========================================================================================

; ----------------------------------------------------------------------------------------
; Callback fr Winkel am AT
; ----------------------------------------------------------------------------------------
(defun cb_winkel (zp)
	(print "in Callback-Funktion cb_winkel")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dwAlt (Winkel.get winkel_blech dw))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dwNeu (Winkel.get winkel_blech dw))
	    
	    (print dwAlt) (print dwNeu)
	    
	    (if (/= dwAlt dwNeu) (progn
			(setq dwDiff (- dwNeu dwAlt))
	       
			(setq alteKlemml (Lochbild.get lchbWnkl Klemml))
			(setq dxsKopf_alt	(Lochbild.get lchbWnkl dxSKopf))
	      	
	       
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq dxsKopf_neu (+ dxsKopf_alt dwDiff))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq dxsKopf_neu dxsKopf_alt)
			)
	             
			(print dxsKopf_alt)
			(print dxsKopf_neu)
	       
			(Lochbild.set lchbWnkl 	(Klemml (+ alteKlemml dwDiff))
	       							(dxSKopf	dxsKopf_neu)
			)
	       
			(if (= 2 3) (progn
				; soll zentral von VS behandelt werden, u.a. wegen einseitigen Winkeln
			   ; am AT-Steg
			   (setq alteKlemml_at 	(Lochbild.get lchbAtrgSteg Klemml))
			   (setq dxsKopf_alt_at	(Lochbild.get lchbAtrgSteg dxSKopf))
			   (setq s_ht						(Traeger.get Htrg s))
			   (print dxsKopf_alt_at)
			   
			   (setq dxsKopf_neu_at 0)
			   (if (= (Connect.get CastaData amHtStegLinks) 1) (setq dxsKopf_neu_at (+ dxsKopf_alt_at dwDiff)))
			   (if (= (Connect.get CastaData amHtStegRechts) 1) (setq dxsKopf_neu_at s_ht))
			   
			   (print dxsKopf_neu_at)
			   
			   (Lochbild.set lchbAtrgSteg 	(Klemml (+ alteKlemml_at (* 2.0 dwDiff)))
											(dxSKopf	dxsKopf_neu_at)
			   )
			))
	    ))
	))
)

; --------------------------------------------------------------------------
; Berechnet die Daten der Winkel
; --------------------------------------------------------------------------
(defun calcAndSetWinkeldaten (wnklAnbTeil TrgEnde)

  (print "----------------------------- In calcAndSetWinkeldaten")

	(setq zAkl     		(trEnde.get TrgEnde zakl)
				xAkl		 		(trEnde.get TrgEnde xakl)
	      hSteg    		(trEnde.get TrgEnde hsteg)
	)
	
	(setq bHtrg		 		(Traeger.get Htrg b)
	      delta_lr_ht	(Traeger.get Htrg delta_lr)
	      qsform_ht		(Traeger.get Htrg qsform)
	      delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq hProf    		(Traeger.get Tr_ID h)
	      sAnProf  		(Traeger.get Tr_ID s)
	      hcAnProf 		(Traeger.get Tr_ID hc)
	      bProf		 		(Traeger.get Tr_ID b)
	      t_at				(Traeger.get Tr_ID t)
	      r_at				(Traeger.get Tr_ID r)
	      delta_v_at	(Traeger.get Tr_ID delta_v)
	      qsform_at		(Traeger.get Tr_ID qsform)
	)
	
	
	; Vorbereitung zu Bestimmung der Winkelhhe
	; ------------------------------------------------------------------
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< wnkl_dw sAnProf)
		(setq min_bl wnkl_dw)
		(setq min_bl sAnProf)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set lchbAtrgSteg (S_Bez S_Bez))
	(Lochbild.set lchbWnkl     (S_Bez S_Bez))
	
	; default Rand- und Lochabstnde aus Schraubendurchmesser bestimmen
	(calcMinRandLochAbst lchbAtrgSteg)	; -> e_min_rund, e1_min_rund, min_h
	; ->
	(print min_h)
	(setq wnkLng min_h)
	(print wnkLng)
		
	; wenn die min. Winkelhhe fr 4 Schrauben grer als die verfgbare Steglnge am AT ist,
	; wird die Winkelhhe auf die verfgbare Steglnge am AT gesetzt.
	(if (> hcAnProf 40) (progn
		(if (> wnkLng hcAnProf) (setq wnkLng hcAnProf))
	))
	; ->
	(setq dOK (* 0.5 (- hProf wnkLng)))
		
		

	; Blechhhe und dok bei Ausklinkung
	(if (/= hsteg 0.0)							
		(progn
			(print "hsteg /= 0")
			(if (/= zakl 0.0)						; unten und oben
				(progn
					(print "zakl /= 0")
					(if (> wnkLng hsteg)
						(setq wnkLng hsteg)
					)
					;(setq dOK (* 0.5 (- hProf wnkLng)))
					(setq dOK (+ zakl (* 0.5 (- hsteg wnkLng))))
				)													; nur unten
				(progn
					(print "zakl = 0")
					(setq verf_steg_l (- hProf t_at r_at (- hProf hsteg)))
					(if (>= wnkLng verf_steg_l)
						(progn
							(setq wnkLng verf_steg_l)
							(setq dok (+ t_at r_at))
						)
						(progn
							(setq diff_vsl_wl (- verf_steg_l wnkLng))
							(setq dok (+ t_at r_at (* 0.5 diff_vsl_wl)))
						)
					)
				)
			)
		)
		(progn
			(print "hsteg = 0")
			(if (/= zakl 0.0)						; nur oben
				(progn
					(print "zakl /= 0")
					(setq verf_steg_l (- hProf t_at r_at zakl))
					(if (>= wnkLng verf_steg_l)
						(progn
							(setq wnkLng verf_steg_l)
							(setq dok zakl)
						)
						(progn
							(setq diff_vsl_wl (- verf_steg_l wnkLng))
							(setq dok (+ zakl (* 0.5 diff_vsl_wl)))
						)
					)
				)													; keine
				(progn
					(print "zakl = 0")
				)
			)
		)
	)
  	
	 	
	;(if (= qsform "U")
	;	(if (= (Connect.get CastaData amHtStegLinks) 1)
	;		(setq dOK    5 hp (- hProf 10))		; keine Ausklinkung
	;	)
	;)
	      
	;(setq wnkLng  hp)
	
	(setq t_HtProf (Traeger.get HTrg s))
	; muss jetzt noch berprft werden, ob es sich um ein U oder I-Profil handelt,
	; ggflls auch Kastenprofil - Rohre erst einmal nicht
	(setq t_HtProf_halb (* 0.5 t_HtProf))
	      
	; Berechnung der Schenkellngen
	;(setq slk_std (* 0.5 (- bProf sAnProf)))	; Teil am HT
	(setq slk_std (+ (* e_min_rund 2.0) wnkl_dw))
	;(setq sll_std (+ (* 0.5 bHtrg) 10))				; Teil am AT
	(setq sll_std (+ (* 2.0 e1_min_rund) wnkl_dw))
	
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Winkel.set wnklAnbTeil (wanz 	 	2)
				(l 	 	wnkLng)
				(sll 	 	sll_std)
				(slk 	 	slk_std)
				(dw 	 	wnkl_dw)
				(wabst 	 	sAnProf)
				(achsab		(+ t_HtProf_halb delta_lr_ht))
				(dok 	 	dOK)
				(delta_x 	0.0)
				(lage 	 	0)				; Aug-2022
				(schhoriz	100.000000)
	)

	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(Winkel.set wnklAnbTeil (achsab (+ t_HtProf delta_lr_ht)))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(Winkel.set wnklAnbTeil (achsab (- 0 delta_lr_ht)))
			)
		)
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(Winkel.set wnklAnbTeil (achsab (+ t_HtProf_halb delta_lr_ht)))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(Winkel.set wnklAnbTeil (achsab (- t_HtProf_halb delta_lr_ht)))
			)
		)
	)
	
)

; --------------------------------------------------------------------
; Berechnet die Lochbilddaten am Haupttrger
; --------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde WinkelID)
	
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN VERBINDUNG HT")
	;Basiseinstellungen (evtl. weglassen und Gren in Abhngigkeit anderer Gren berechnen)
	(Lochbild.set Lchb_ID (Anz_S    4)
												(Guete   "4.6")
												(e       "100 0 0 0 0 0")
												(w       "40  0")									
	)
	
	(setq Wnkl_L	(Winkel.get WinkelID l)
				slk_W		(Winkel.get WinkelID slk)
				dw_W		(Winkel.get WinkelID dw)
				dok_W		(Winkel.get WinkelID dok)
	)
	(setq h_trg				(Traeger.get Tr_ID h)
				hc_trg			(Traeger.get Tr_ID hc)
				s_trg				(Traeger.get Tr_ID s)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				qsform_at		(Traeger.get Tr_ID qsform)
	)
	(setq hc_htrg 		(Traeger.get Htrg hc)
				s_htrg  		(Traeger.get HTRG s)
				delta_v_ht	(traeger.get Htrg delta_v)
				h_ht				(Traeger.get Htrg h)
	)
	
	(print dok_W)
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq l_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	; berprfen, welches hc magebend ist
	(if (> hc_htrg hc_trg)
		(setq hc hc_trg)
		(setq hc hc_htrg)
	)
		
	
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	(if (> l_aus_e Wnkl_L)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq l_aus_e (* e_blech_rund 2.0))
			(setq VIER 0) 
		)
	)
	
	
	(setq w0 (+ (* 0.5 s_trg) (* (+ dw_W e_blech_rund) 2.0)))					; Randabstand
	(setq w0rund (runde w0 auf 5))
		
	
	(calcUnterschied)
	
	(setq diff (- l_aus_e Wnkl_L)) ; Differenz zwischen alter und neuer Winkelhhe
	(setq dok_w (- dok (* 0.5 diff) ))
	
	(print VIER)
	
	(print dok_w)
	(print l_aus_e)
	
	(if (= VIER 1)
		(progn
			(setq e0 (+ dok_w (* 0.25 l_aus_e)))
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			(Lochbild.set Lchb_ID (e0 e0) 
														(e1 e1_blech_rund)
														(w0 w0rund)								
			)
			(if (= LB_DEBUG 1)
				(Lochbild.set Lchb_ID (e2 300))
			)
		)
		(progn
			(setq e0 (+ dok_w (* 0.5 l_aus_e)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID	(e0 e0)
						(e1 0) 										
						(w0 w0rund)
			)
		)
	)
	
	(print e0)
	
	; dxsKopf
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(setq dxskopf_ht (+ dw_W (* 0.5 s_htrg)))
		)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(setq dxskopf_ht (* 0.5 s_htrg))
		)
	)
	
		
	;Winkellnge am AT korregieren
	;(Winkel.set WinkelID 	(slk (+ (* e_blech_rund 2.0) dw_W)))
		
	
	(Lochbild.set Lchb_ID 	(klemml (+ dw_W s_htrg))
				(dxsKopf	dxsKopf_ht)
	)
	
	(print "------------------------------------------------------------")
)

; --------------------------------------------------------------------
; Berechnet die Lochbilddaten am Anschlutrger
; --------------------------------------------------------------------
(defun calcAndSetLochbildDatenAtrgSteg (Lchb_ID TrgEnde WinkelID LbArt)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILD AM AT-STEG") 
;	Bei den w-Maen daran denken - werden nochmals durch 2 geteilt
;	
	(Lochbild.set Lchb_ID	(Lb_Art   LbArt)
	        		(Anz_S    4)
				(Guete   "4.6")
				(e       "100 50 0 0 0 0")
				(w       "60  140")
	)
		
	(setq Wnkl_L	(Winkel.get WinkelID l)
				dw_W		(Winkel.get WinkelID dw)
				dok_W		(Winkel.get WinkelID dok)
	)
	(setq h_trg				(Traeger.get Tr_ID h)
				l_trg		(Traeger.get Tr_ID l)
				hc_trg		(Traeger.get Tr_ID hc)
				s_trg		(Traeger.get Tr_ID s)
				delta_v_trg	(Traeger.get Tr_ID delta_v)
				delta_l_trg	(TrEnde.get TrgEnde delta_l)
				qsform_at	(Traeger.get Tr_ID qsform)
	)
	
	(if (= qsform_at "C") (setq qsform_at "U"))
	
	(setq delta_v_ht	(Traeger.get Htrg delta_v))
		
	
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq l_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	(print Wnkl_L)
	(print l_aus_e)
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	(if (> l_aus_e Wnkl_L)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq l_aus_e (* e_blech_rund 2.0))
			(if (< Wnkl_L l_aus_e)
				(setq l_aus_e Wnkl_L)
			)
			(setq VIER 0) 
		)
	)	
	
	(setq w0 (+ e_blech dw_W))					; Randabstand
	(setq w0rund (runde w0 auf 5))
	(setq w1 (+ e1_blech w0rund))				; Lochabstand
	(setq w1rund (runde w1 auf 5))
		
	 
	
	(setq diff (- l_aus_e Wnkl_L)) ; Differenz zwischen alter und neuer Winkelhhe
	(setq dok_wnkl (- dok (* 0.5 diff) ))
	;Winkellnge am AT korregieren
	;(Winkel.set WinkelID 	(sll (- (+ w1rund w0rund) dw_W))
												;(l l_aus_e)
												;(dok dok_wnkl)
	;)
	
	(print dok_wnkl)
	(print Wnkl_L)
	(print l_aus_e)
	 
	
	(if (= VIER 1)
		(progn
			(setq e0 (+ dok_wnkl (* 0.25 l_aus_e)))
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			(Lochbild.set Lchb_ID (e0 e0) 
														(e1 e1_blech_rund) 
														(w0 w0rund)
														(w1 w1rund)												
			)
		)
		(progn
			(setq e0 (+ dok_wnkl (* 0.5 l_aus_e)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0)
														(e1 0) 										
														(w0 w0rund)
														(w1 w1rund)
			)
		)
	)
	
	(print e0)
	
	
	;Klemmlnge
	(if (= qsform_at "U")
		(progn
			(setq dxskopf_at 0)
		)
		(progn
			(setq dxskopf_at 0)
		)
	)	
	(print dxskopf_at)
	(Lochbild.set Lchb_ID	(klemml (+ (* dw_W 2) s_trg))
				(dxSKopf dxskopf_at)
	) 
	
	(print "<-----------------------------------------------------------")
)


; -------------------------------------------------------------------------
; Erzeugt die Lochbilder
; -------------------------------------------------------------------------
(defun createLochbildAbtl (TrgEnde WinkelID)
	
	(setq	delta_V  		(Traeger.get hTrg delta_v)
		hProf    		(Traeger.get hTrg h)
		delta_lr_ht		(Traeger.get hTrg delta_lr)
		qsform_ht		(Traeger.get Htrg qsform)
	)
	
	(setq	delta_V2 		(Traeger.get Tr_ID delta_v)
		hProf2   		(Traeger.get Tr_ID h)
		delta_lr_trg		(Traeger.get Tr_ID delta_lr)	
		rwinkel_at		(Traeger.get Tr_ID r_winkel)
	)
	
	
	(setq	xPos_HT 		(Connect.get CastaData xPos_ht)
		vwinkel_uz		(Connect.get CastaData hpttrg_vwinkel)
	)
	(print xPos_HT)
	
	(setq abteil_winkel 0.0)
	
	(setq xPos xPos_HT)
	
	(if (= TrgEnde TrLinks)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildlinks_)
			;(if (= (Connect.get CastaData amHtStegRechts) 1)
				;(setq xPos (- xPos_HT delta_lr_trg))
			;)
			;(if (= (Connect.get CastaData amHtStegLinks) 1)
				;(setq xPos (+ xPos_HT delta_lr_trg))
			;)
			(traeger.addabtl hTrg lchbWnkl xPos abteil_winkel _steglochbild_)
			
			
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildrechts_)
			;(if (= (Connect.get CastaData amHtStegRechts) 1)
				;(setq xPos (+ xPos_HT delta_lr_trg))
			;)
			;(if (= (Connect.get CastaData amHtStegLinks) 1)
				;(setq xPos (- xPos_HT delta_lr_trg))
			;)
			(traeger.addabtl hTrg lchbWnkl xPos abteil_winkel _steglochbild_)
			
		)
	)

	(createLochbildAbtl_ATSteg TrgEnde WinkelID)

	; Berechnet die Lochbilddaten der Verbindung zum HT-Steg
	(calcAndSetLochbildDaten lchbWnkl TrgEnde WinkelID)
	

		
	(setq e0_lb (Lochbild.get lchbWnkl e0)
				e1_lb	(Lochbild.get lchbWnkl e1)
	)
	
	(print e0_lb)
	
	(setq e_diff (- (+ e0_lb e1_lb) (- hProf2 e0_lb)))
	
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(setq delta_v_lb_ht (+ (- diff_oben) e_diff))
		(setq delta_v_lb_ht	(- diff_oben))
	)
	
	(setq ht_lochbild_abtl (Traeger.get Htrg Abteil lchbWnkl))
	(setq at_lochbild_abtl (Traeger.get Tr_ID Abteil lchbWnkl))
	
	; Differnzwinkel zwischen HT-Neigung und AT-Rotation berechnen
	; ---------------------------------------------
	(print vwinkel_uz)
	(print rwinkel_at)
	(setq diffWinkel 0.0)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (+ vwinkel_uz rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (- vwinkel_uz rwinkel_at ))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq diffWinkel (- vwinkel_uz rwinkel_at))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq diffWinkel (+ vwinkel_uz rwinkel_at ))
			)
		)
	)
	(print diffWinkel)
	
	(setq sinW (sin (/ (* PI diffWinkel) 180.0)))
	(setq cosW (cos (/ (* PI diffWinkel) 180.0)))
	(setq tanW (tan (/ (* PI diffWinkel) 180.0)))
	
	; Positionierung des Anbauteil-Lochbildes am HT
	; ----------------------------------------------
	(setq verschiebung_delta_lr 0.0)
	(setq verschiebung_delta_v 0.0)
	
	; Winkel des Anbauteils
	; ----------------------------------------------
	(setq abtl_winkel 0.0)
	(setq abtl_winkel (- diffWinkel))
	
	
	; delta_v / delta_lr Anteile allein durch Rotation und delta_v AT
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Verschiebung delta_lr des Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn	
	; ----------------------------------------------
		(print "Anteil an delta_lr")
		(print delta_V2)
		(setq h_at_halb (* 0.5 hProf2))
		(print h_at_halb)
		
		(setq verschiebung_delta_lr	(* (- h_at_halb delta_V2) sinW))
		(print verschiebung_delta_lr)
	; ----------------------------------------------	
	))
	; ----------------------------------------------
	
	; Verschiebung delta_v des Anbauteils
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print "Anteil an delta_v")
		(setq h_ht_halb (* 0.5 hProf))
		(print h_ht_halb)
		
		(setq rest (- h_at_halb delta_V2))
		(print rest)
		
		(setq rest_delta_v (* rest cosW))
		
		(setq verschiebung_delta_v (- h_ht_halb rest_delta_v))
		(print verschiebung_delta_v)
	; ----------------------------------------------
	))
	; ----------------------------------------------

	
	; HT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_v Verschiebung HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print delta_V)
		(setq verschiebung_delta_v (- verschiebung_delta_v delta_V))
		
		(print verschiebung_delta_v)
		(print verschiebung_delta_lr)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; AT-Verschiebungen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil delta_lr Verschiebung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(print delta_lr_trg)
		(setq anteil_delta_lr_at	(* (* 1.0 delta_lr_trg) cosW))
		(print anteil_delta_lr_at)
		
		(if (= (Connect.get CastaData amHtStegLinks) 1)
			(progn
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))	
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
			)
		)
		
		(if (= (Connect.get CastaData amHtStegRechts) 1)
			(progn
				(if (= (Connect.get CastaData linkesEnde)  1)	(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_at)))
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_at)))
			)
		)
		
		(setq anteil_delta_v_at (* (* 1.0 delta_lr_trg) sinW))
		(print anteil_delta_v_at)
		(if (= (Connect.get CastaData amHtStegLinks) 1)
			(progn
				(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
				(if (= (Connect.get CastaData rechtesEnde) 1) (setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
			)
		)
		(if (= (Connect.get CastaData amHtStegRechts) 1)
			(progn
				(if (= (Connect.get CastaData linkesEnde) 1)	(setq verschiebung_delta_v	(- verschiebung_delta_v anteil_delta_v_at)))
				(if (= (Connect.get CastaData rechtesEnde) 1)	(setq verschiebung_delta_v	(+ verschiebung_delta_v anteil_delta_v_at)))
			)
		)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Besonderheiten Profile
	; ++++++++++++++++++++++++++++++++++++++++++++++
	(setq	s_at		(Traeger.get Tr_ID s)
		qsform_at	(Traeger.get Tr_ID qsform)
	)
	(if (= qsform_at "C")	(setq qsform_at "U"))

	
	; U-Profil
	; ----------------------------------------------
	; LB in die Mitte setzen
	(if (= qsform_at "U")
		(progn
			; delta_lr Verschiebung berechnet bzgl. AT
			; ------------------------------------------
			(setq uProf_anpassung (- (* 0.5 s_at)))
			
			(setq anteil_delta_lr_am_ht (* uProf_anpassung cosW))
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_lr (- verschiebung_delta_lr anteil_delta_lr_am_ht))
					)	
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_lr (+ verschiebung_delta_lr anteil_delta_lr_am_ht))
					)
				)
			)
			
			(setq anteil_delta_v_am (* uProf_anpassung sinW))
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_delta_v_am))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_v (- verschiebung_delta_v anteil_delta_v_am))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq verschiebung_delta_v (- verschiebung_delta_v anteil_delta_v_am))
					)
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq verschiebung_delta_v (+ verschiebung_delta_v anteil_delta_v_am))
					)
				)
			)
			
		)
	)
	
	
	
	
	; Werte setzen
	; ----------------------------------------------
	(print verschiebung_delta_v)
	(print verschiebung_delta_lr)
	(Anbauteil.set ht_lochbild_abtl 
				(delta_v 	verschiebung_delta_v)
				(delta_lr 	verschiebung_delta_lr)
				(winkel		abtl_winkel)
	)
	
	(if (= qsform_at "U")
		(Anbauteil.set at_lochbild_abtl (delta_lr uProf_anpassung))
	)
	
	; Master setzen
	; ----------------------------------------------
	(Anbauteil.set ht_lochbild_abtl (Master 1))
	(Anbauteil.set at_lochbild_abtl (Master 0))
	
	; neu - August 2024
	(setq changeSeiteRicht 0)
	(if (= (Connect.get CastaData linkesEnde)  1) (if (= (Connect.get CastaData amHTStegRechts) 1) (setq changeSeiteRicht 1)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (if (= (Connect.get CastaData amHTStegLinks)  1) (setq changeSeiteRicht 1)))
	(if (= (Connect.get CastaData exist_steglchb) 0) (progn
		(if (= changeSeiteRicht 1) (Anbauteil.set ht_lochbild_abtl (SeitRicht -1)))
	))

	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy lchbWnkl)
						
			(if (= (connect.get CastaData LinkesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildlinks_)
    	)
	    (if (= (connect.get CastaData RechtesEnde) 1) 
				(traeger.addabtl Tr_ID dummy 0.0 0.0 _kpllochbildrechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Tr_ID Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1))
			
			(if (= qsform_at "U")	
				(Anbauteil.set dummy_abtl (delta_lr uProf_anpassung))
			)
		)
	)
	;===================================================================
	(print "------------------------------------------------------------")
)


(defun createLochbildAbtl_ATSteg (TrgEnde WinkelID)
	(if (= TrgEnde TrLinks)
		(progn 
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde WinkelID 2)
			(Traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			(setq trgLaenge (Traeger.get Tr_ID syslng))
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde WinkelID -2)
			(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
		)
	)
)

; -------------------------------------------------------------------------
; Erzeugt die Winkel
; -------------------------------------------------------------------------
(defun createWinkel (TrgEnde WinkelID)
	;Erzeugung der Winkel
	(calcAndSetWinkeldaten WinkelID TrgEnde)
	(if (= TrgEnde TrLinks)
		(progn
			(traeger.addabtl tr_id WinkelID 0.0 0.0 _kopfplattelinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn
			(traeger.addabtl tr_id WinkelID 0.0 0.0 _kopfplatterechts_)
		)
	)
)

; -------------------------------------------------------------------------

; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	
	(setq h_ht				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_v_ht h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))							(print uKante_ht)
	(setq oKante_at	(- delta_v_at h_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))							(print uKante_at)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(setq oKante_at_tmp oKante_at)
			(setq uKante_at_tmp uKante_at)
			
			(setq oKante_at (- uKante_at_tmp))
			(setq uKante_at (- oKante_at_tmp))
		)
	)
		
	(setq diff_oben (- oKante_at oKante_ht))
	
	
	
	(print diff_oben)
	
)

(defun korrHtEnde (WINKELID)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(setq s_at 					(Traeger.get Tr_ID s)
				delta_lr_at		(Traeger.get Tr_ID delta_lr)
	)
	
	(setq slk_winkel (Winkel.get WINKELID slk))
	(print slk_winkel)
	
	(setq delta_l_htende (+ (+ slk_winkel (* 0.5 s_at)) delta_lr_at))
	
	(TrEnde.set HtEnde (delta_l (- delta_l_htende)))
)


(defun getExistingLochbild ()
	(alertBox "Auf der gegenberliegenden Seite ist bereits ein Anschluss vorhanden. Nehmen Sie nderungen ggf. manuell vor." "OppositeSideConnection_Found")
	(print "gegenberliegendes Lochbild holen")
	
	(setq	xPos_at 		(Connect.get CastaData xPos_at))
	(setq	delta_v_at		(Traeger.get Tr_ID delta_v))
	(setq	dp_wnkl 		(Winkel.get winkel_blech dw))
	(setq	klemml_alt 		(Lochbild.get lchbWnkl klemml)
			dxskopf_alt		(Lochbild.get lchbWnkl dxsKopf)
	)
	
			
	(setq klemml_neu 	(+ klemml_alt dp_wnkl))
	(setq dxskopf_neu (+ dxskopf_alt dp_wnkl))
	
			
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(Lochbild.set lchbWnkl (klemml klemml_neu))
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(Lochbild.set lchbWnkl 	(klemml klemml_neu)
															(dxsKopf dxskopf_neu)
			)
		)
	)		
	
	(print xPos_at)
				
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID rechts))
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildrechts_)
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(setq AT_Ende (Traeger.get Tr_ID links))
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildlinks_)
		)
	)
	
	
	(setq ht_lochbild_abtl (Traeger.get Htrg AbTeil lchbWnkl))
	(setq delta_v_abtl_lb_ht 	(Anbauteil.get ht_lochbild_abtl delta_v))
	(print delta_v_abtl_lb_ht)	
	
	(setq delta_v_abtl_at delta_v_abtl_lb_ht)
	(print delta_v_abtl_at)
	
	(calcUnterschied)
	
	; Anteil Unterschied HT u. AT
	(setq delta_v_abtl_at (+ delta_v_abtl_at (- diff_oben)))
	(print delta_v_abtl_at)
	
	(setq at_lochbild_abtl (Traeger.get Tr_ID Abteil lchbWnkl))
	(Anbauteil.set at_lochbild_abtl (Master 	0)
															(delta_v  delta_v_abtl_at)
		  												;(delta_lr 40); ??? funktioniert nicht
		  												
	)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(Anbauteil.set at_lochbild_abtl (switch_on _unterflansch_))
	)

	(setq changeSeiteRicht 0)
	(if (= (Connect.get CastaData linkesEnde)  1) (if (= (Connect.get CastaData amHTStegRechts) 1) (setq changeSeiteRicht 1)))
	(if (= (Connect.get CastaData rechtesEnde) 1) (if (= (Connect.get CastaData amHTStegLinks)  1) (setq changeSeiteRicht 1)))
	(if (= (Connect.get CastaData exist_steglchb) 1) (progn
		(setq htLchbSeitRicht (Anbauteil.get ht_lochbild_abtl SeitRicht))
		(if (>= htLchbSeitRicht  0) (if (= changeSeiteRicht 1) (Anbauteil.set at_lochbild_abtl (SeitRicht -1))))
		(if (=  htLchbSeitRicht -1) (if (= changeSeiteRicht 0) (Anbauteil.set at_lochbild_abtl (SeitRicht -1))))
	))
	
	(createLochbildAbtl_ATSteg AT_Ende winkel_blech)							
)


(defun korrigiereAblaengung ()
    (if (= (Connect.get CastaData LinkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData RechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))
    
    (setq at_DeltaL (TrEnde.get TrgEnde Delta_L))
    (setq nWert (runde at_DeltaL auf 5))
    (if (< (- nWert at_DeltaL) 2.5) (progn
        (setq at_DeltaL (+ 2.5 at_DeltaL))
        (setq nWert (runde at_DeltaL auf 5))
    ))
    (TrEnde.set TrgEnde (Delta_L nWert))
	
	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(if (>= dl_Vorhanden_Source nWert)  (TrEnde.set TrgEnde (Delta_L dl_Vorhanden_Source)))
	))

)

(defun storeAblaengWhenCopied ()
	(setq dl_Vorhanden_Source 0.0)
    (if (= (Connect.get CastaData LinkesEnde) 1)  (setq TrgEnde (Traeger.get Tr_ID links)))
    (if (= (Connect.get CastaData RechtesEnde) 1) (setq TrgEnde (Traeger.get Tr_ID rechts)))

	(if (= (Connect.get CastaData CopyMode) 1) (progn
		(setq dl_Vorhanden_Source (trEnde.get TrgEnde delta_L))
	))

)
; ----------------------------------------------------------------------------------------
