; $	HT	QT(IU)	AF(FS)	P(EZ)
; $	AT	QT(IU)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
)

(defun init-connection ()
	
  (print "BEGIN init-connection uz_an_uzStegMitWinkeln");
  (setq rwinkel_at (Traeger.get Tr_ID r_winkel))
  
  ;(if (/= rwinkel_at 0.0)
  ;	(print "Bitte setzen Sie den Rotationswinkel des Anschlusstrgers auf 0."   "Set_RotAngle_AT_To_Zero")
		(setConnection)
	;)
	

  (print "END init-connection uz_an_uzStegMitWinkeln");
)

(defun setConnection ()
	(print "IMPORT mod-endinit-uz-uzsteg")
	(init-traegerenden)
  (print "IMPORT ENDE")
  
  
  (if (= 1 1) (progn
  
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  (setq winkel	(Winkel.create))
  (Connect.storeAnschlObjs CastaData winkel)
  
  ; Anschlsse am Steg des Haupttrgers
  (if (= (Connect.get CastaData amHtStegLinks) 1) 
  	(progn
  		(print "Anschluss am Steg links")
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn
					(print "AT links")
					(createWinkel TrLinks winkel)
					(createLochbild TrLinks winkel)	
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					(print "AT rechts")
					(createWinkel TrRechts winkel)
					(createLochbild TrRechts winkel)
				)
			)
   	)
  )
  (if (= (Connect.get CastaData amHtStegRechts) 1) 
  	(progn
  		(print "Anschluss am Steg rechts")
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn
					(print "AT links")
					(createWinkel TrLinks winkel)
					(createLochbild TrLinks winkel)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					(print "AT rechts")
					(createWinkel TrRechts winkel)
					(createLochbild TrRechts winkel)
				)
			)
   	)
  )
  
))

	(createSteife)
	
	(if (= (Connect.get CastaData anschlZwHtEnden) 0)
		(korrHtEnde winkel)
	)
)
; --------------------------------------------------------------------------
; Berechnet die Daten der Winkel
; --------------------------------------------------------------------------
(defun calcAndSetWinkeldaten (wnklAnbTeil TrgEnde)

  (print "----------------------------- In calcAndSetWinkeldaten")

	(setq zAkl     		(trEnde.get TrgEnde zakl)
				xAkl		 		(trEnde.get TrgEnde xakl)
	      hSteg    		(trEnde.get TrgEnde hsteg)
	      bHtrg		 		(Traeger.get Htrg b)
	      delta_lr_ht	(Traeger.get Htrg delta_lr)
	      qsform_ht		(Traeger.get Htrg qsform)
	      delta_v_ht	(Traeger.get Htrg delta_v)
	      hProf    		(Traeger.get Tr_ID h)
	      sAnProf  		(Traeger.get Tr_ID s)
	      hcAnProf 		(Traeger.get Tr_ID hc)
	      bProf		 		(Traeger.get Tr_ID b)
	      t_at				(Traeger.get Tr_ID t)
	      r_at				(Traeger.get Tr_ID r)
	      delta_v_at	(Traeger.get Tr_ID delta_v)
	      qsform_at		(Traeger.get Tr_ID qsform)
	)
	
	(print "---------")
	(print zAkl)
	(print hSteg)
	(print hProf)
	(print hcAnProf)
	(print "---------")
		
	
	; Dok berechnen
	(if (> zAkl 0) 
		(progn
	    (if (> hSteg 0) 
	        (setq dOK zAkl 
	        			hp hSteg
	        )		; Doppelausklinkung
	        ;else
	        (setq dOK zAkl 
	        			hp (- hProf zAkl t_at r_at) )	; nur obere Ausklinkung
	    )
	  ) ; progn
	  (progn
	    (if (> hSteg 0) 
	        (setq dOK (+ t_at r_at) 
	        			hp (- hSteg t_at r_at))			; nur untere Ausklinkung
	        ;else
	        (setq dOK (+ t_at r_at)
	        			hp hcAnProf)		; keine Ausklinkung
	    )
	  ) ; progn
	)	
  	
	;(if (= qsform "U")
	;	(if (= (Connect.get CastaData amHtStegLinks) 1)
	;		(setq dOK    5 hp (- hProf 10))		; keine Ausklinkung
	;	)
	;)
	      
	(setq wnkLng  hp)
	
	(setq t_HtProf (Traeger.get HTrg s))
	; muss jetzt noch berprft werden, ob es sich um ein U oder I-Profil handelt,
	; ggflls auch Kastenprofil - Rohre erst einmal nicht
	(setq t_HtProf_halb (* 0.5 t_HtProf))
	      
	; Berechnung der Schenkellngen
	(setq slk_std (* 0.5 (- bProf sAnProf)))	; Teil am HT
	(setq sll_std (+ (* 0.5 bHtrg) 10))				; Teil am AT
	
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Winkel.set wnklAnbTeil (wanz 	 	2)
													(l 	 			wnkLng)
													(sll 	 		sll_std)
													(slk 	 		slk_std)
													(dw 	 		10)
													(wabst 	 	sAnProf)
													(achsab		(+ t_HtProf_halb delta_lr_ht))
													(dok 	 		dOK)
													(delta_x 	0.0)
													(lage 	 	1)
													(schhoriz	100.000000)
													
	)

	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(Winkel.set wnklAnbTeil (achsab (+ t_HtProf delta_lr_ht)))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(Winkel.set wnklAnbTeil (achsab (- 0 delta_lr_ht)))
			)
		)
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(Winkel.set wnklAnbTeil (achsab (+ t_HtProf_halb delta_lr_ht)))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(Winkel.set wnklAnbTeil (achsab (- t_HtProf_halb delta_lr_ht)))
			)
		)
	)
	;Trgerende auf einen glatten Wert krzen - derzeit mind. 10 mm Spaltma
	;(setq   delta_L (TrEnde.get TrgEnde delta_l))
	
	;(setq delta_L (runde delta_L auf 5))
	;(TrEnde.set TrgEnde (delta_L delta_L))
	;(print delta_L)(print "<-")
)

; --------------------------------------------------------------------
; Berechnet die Lochbilddaten am Haupttrger
; --------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID Lchb_ID_AT TrgEnde WinkelID)
	;Basiseinstellungen (evtl. weglassen und Gren in Abhngigkeit anderer Gren berechnen)
	(Lochbild.set Lchb_ID (Anz_S    4)
												(Guete   "4.6")
												(e       "100 0 0 0 0 0")
												(w       "40  0")									
	)
	
	(setq Wnkl_L	(Winkel.get WinkelID l)
				slk_W		(Winkel.get WinkelID slk)
				dw_W		(Winkel.get WinkelID dw)
				dok_W		(Winkel.get WinkelID dok)
	)
	(setq h_trg				(Traeger.get Tr_ID h)
				hc_trg			(Traeger.get Tr_ID hc)
				s_trg				(Traeger.get Tr_ID s)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	(setq hc_htrg 		(Traeger.get Htrg hc)
				s_htrg  		(Traeger.get HTRG s)
				delta_v_ht	(traeger.get Htrg delta_v)
				h_ht				(Traeger.get Htrg h)
	)
	
	; Schaube anhand der Anschlusstrgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq l_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	; berprfen, welches hc magebend ist
	(if (> hc_htrg hc_trg)
		(setq hc hc_trg)
		(setq hc hc_htrg)
	)
		
	
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	(if (> l_aus_e Wnkl_L)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq l_aus_e (* e_blech_rund 2.0))
			(setq VIER 0) 
		)
	)
	
	(print s_trg)
	(print dw_W)
	(print e_blech_rund)
	(setq w0 (+ (* 0.5 s_trg) (* (+ dw_W e_blech_rund) 2.0)))					; Randabstand
	(setq w0rund (runde w0 auf 5))
	(print w0rund)
	(print "-----")		
	
	(calcUnterschied)
	
	(if (= VIER 1)
		(progn
			;(setq e0 (Lochbild.get Lchb_ID_AT e0))
			;(if (= (Connect.get CastaData vatr-vhtr) -1)
			;	(setq e0 (+ (- h_trg e0) diff_unten))
			;	(setq e0 (+ e0 diff_oben))
			;)
			(setq e0 (+ dok_w (* 0.25 l_aus_e)))
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			(Lochbild.set Lchb_ID (e0 e0) 
														(e1 e1_blech_rund) 
														(w0 w0rund)								
			)
		)
		(progn
			;(setq e0 (Lochbild.get Lchb_ID_AT e0))
			;(if (= (Connect.get CastaData vatr-vhtr) -1)
			;	(setq e0 (+ (- h_trg e0) diff_oben))
			;	(setq e0 (+ e0 diff_oben))
			;)
			(setq e0 (+ dok_wnkl (* 0.5 l_aus_e)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0)
														(e1 0) 										
														(w0 w0rund)
			)
		)
	)
	
	;Winkellnge am AT korregieren
	(Winkel.set WinkelID 	(slk (+ (* e_blech_rund 2.0) dw_W)))
		
	;Klemmlnge
	(Lochbild.set Lchb_ID (klemml (+ dw_W s_htrg)))	
)

; --------------------------------------------------------------------
; Berechnet die Lochbilddaten am Anschlutrger
; --------------------------------------------------------------------
(defun calcAndSetLochbildDatenAtrgSteg (Lchb_ID TrgEnde WinkelID LbArt)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILD AM AT-STEG") 
;	Bei den w-Maen daran denken - werden nochmals durch 2 geteilt
;	
	(Lochbild.set Lchb_ID (Lb_Art   LbArt)
	        							(Anz_S    4)
												(Guete   "4.6")
												(e       "100 50 0 0 0 0")
												(w       "60  140")
	)
		
	(setq Wnkl_L	(Winkel.get WinkelID l)
				dw_W		(Winkel.get WinkelID dw)
				dok_W		(Winkel.get WinkelID dok)
	)
	(setq h_trg				(Traeger.get Tr_ID h)
				l_trg				(Traeger.get Tr_ID l)
				hc_trg			(Traeger.get Tr_ID hc)
				s_trg				(Traeger.get Tr_ID s)
				delta_v_trg	(Traeger.get Tr_ID delta_v)
				delta_l_trg	(TrEnde.get TrgEnde delta_l)
				qsform_at		(Traeger.get Tr_ID qsform)
	)
	
	(setq delta_v_ht	(Traeger.get Htrg delta_v))
		
	; Schaube anhand der Anschlusstrgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq l_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
	
	(print Wnkl_L)
	(print l_aus_e)
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	(if (> l_aus_e Wnkl_L)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq l_aus_e (* e_blech_rund 2.0))
			(if (< Wnkl_L l_aus_e)
				(setq l_aus_e Wnkl_L)
			)
			(setq VIER 0) 
		)
	)	
	
	(setq w0 (+ e_blech dw_W))					; Randabstand
	(setq w0rund (runde w0 auf 5))
	(setq w1 (+ e1_blech w0rund))				; Lochabstand
	(setq w1rund (runde w1 auf 5))
		
	 
	
	(setq diff (- l_aus_e Wnkl_L)) ; Differenz zwischen alter und neuer Winkelhhe
	(setq dok_wnkl (- dok (* 0.5 diff) ))
	;Winkellnge am AT korregieren
	(Winkel.set WinkelID 	(sll (- (+ w1rund w0rund) dw_W))
												(l l_aus_e)
												(dok dok_wnkl)
	)
	
	(print dok_wnkl)
	(print Wnkl_L)
	(print l_aus_e)
	 
	
	(if (= VIER 1)
		(progn
			(setq e0 (+ dok_wnkl (* 0.25 l_aus_e)))
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			(Lochbild.set Lchb_ID (e0 e0) 
														(e1 e1_blech_rund) 
														(w0 w0rund)
														(w1 w1rund)												
			)
		)
		(progn
			(setq e0 (+ dok_wnkl (* 0.5 l_aus_e)))
			(setq e0rund (runde e0 auf 5))
			(Lochbild.set Lchb_ID (e0 e0)
														(e1 0) 										
														(w0 w0rund)
														(w1 w1rund)
			)
		)
	)
	
	(if (= qsform_at "U")
		(progn
			(setq dxskopf_at dw_W)
		)
		(progn
			
		)
	)	
	
	
	;Klemmlnge
	(setq dxskopf_at 0)
	(Lochbild.set Lchb_ID (klemml (+ (* dw_W 2) s_trg))
												(dxSKopf 40)
	) 
	
	(print "<-----------------------------------------------------------")
)


; -------------------------------------------------------------------------
; Erzeugt die Lochbilder
; -------------------------------------------------------------------------
(defun createLochbild (TrgEnde Winkel)
	(print "------------------------------------------------------------")
	(print "ERZEUGE LOCHBILDER")
	(print "------------------------------------------------------------")
	(setq	delta_V  			(Traeger.get hTrg delta_v)
				hProf    			(Traeger.get hTrg h)
				delta_lr_ht		(Traeger.get hTrg delta_lr)
				delta_V2 			(Traeger.get Tr_ID delta_v)
				hProf2   			(Traeger.get Tr_ID h)
				delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
				qsform_ht			(Traeger.get Htrg qsform)				
	)
	
	(setq xPos_HT (Connect.get CastaData xPos_ht))
	(print xPos_HT)
	(setq lchbWnkl (lochbild.create))
	(Connect.storeAnschlObjs CastaData lchbWnkl)
	(setq lchbAtrgSteg (lochbild.create))
	(Connect.storeAnschlObjs CastaData lchbAtrgSteg)
	
	(setq abteil_winkel 0.0)
	
	(if (= TrgEnde TrLinks)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildlinks_)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPos (- xPos_HT delta_lr_trg))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq xPos (+ xPos_HT delta_lr_trg))
			)
			(traeger.addabtl hTrg lchbWnkl xPos abteil_winkel _steglochbild_)
			
			;am Anschlusstrger
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde Winkel 2)
			(traeger.addabtl tr_id lchbAtrgSteg 0.0 0.0 _WnklSteglochbildLinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id lchbWnkl 0.0 0.0 _kpllochbildrechts_)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPos (+ xPos_HT delta_lr_trg))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq xPos (- xPos_HT delta_lr_trg))
			)
			(print xPos)
			(traeger.addabtl hTrg lchbWnkl xPos abteil_winkel _steglochbild_)
			
			;am Anschlusstrger
			(setq trgLaenge (Traeger.get Tr_ID syslng))
			(calcAndSetLochbildDatenAtrgSteg lchbAtrgSteg TrgEnde Winkel -2)
			(traeger.addabtl tr_id lchbAtrgSteg trgLaenge 0.0 _WnklSteglochbildRechts_)
		)
	)

	(calcAndSetLochbildDaten lchbWnkl lchbAtrgSteg TrgEnde Winkel)
	
	; **AFKorrektur** ---------------------------------------------- Anfang nderungen
	; **neu Jan 2006** ----------------------
	; Verschieben der Schrauben in Schraubenachse
	(setq s_HProf (Traeger.get HTrg s)
	      dw      (Winkel.get Winkel dw)
	)
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData AmHtStegRechts) 1)
				(if (= TrgEnde TrRechts) 
	    		(setq dxSKopf 			0)
	    		(setq dxSKopf       0)
				)
			)
			(if (= (Connect.get CastaData AmHtStegLinks) 1)
				(if (= TrgEnde TrRechts) 
	    		(setq dxSKopf dw)
	    		(setq dxSKopf dw)
				)
			)
		)
		(progn
			(if (= (Connect.get CastaData AmHtStegRechts) 1)
				(if (= TrgEnde TrRechts) 
	    		(setq dxSKopf (- dw (* 0.5 s_HProf)))
	    		(setq dxSKopf       (* 0.5 s_HProf))
				)
			)
			(if (= (Connect.get CastaData AmHtStegLinks) 1)
				(if (= TrgEnde TrRechts) 
	    		(setq dxSKopf (+ dw (* 0.5 s_HProf)))
	    		(setq dxSKopf (+ dw (* 0.5 s_HProf)))
				)
			)
		)
	)
	
	(Lochbild.set lchbWnkl  (dxSKopf  dxSKopf))
	
	(setq e0_lb (Lochbild.get lchbWnkl e0)
				e1_lb	(Lochbild.get lchbWnkl e1)
	)
	(print e0_lb)
	(print e1_lb)
	(print hProf2)
	(print diff_oben)
	(setq e_diff (- (+ e0_lb e1_lb) (- hProf2 e0_lb)))
	(print e_diff)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(setq delta_v_lb_ht (+ (- diff_oben) e_diff))
		(setq delta_v_lb_ht	(- diff_oben))
	)
	(print delta_v_lb_ht)
	;(setq delta_v_lb_ht (- 20))
	
	(setq ht_lochbild_abtl (Traeger.get Htrg Abteil lchbWnkl))
	(Anbauteil.set ht_lochbild_abtl (delta_v (- delta_v_lb_ht)))
	; -------------------------------------------- Ende der nderungen
	;(Lochbild.set lchbAtrgSteg (dxSKopf 100.0))
	(print "------------------------------------------------------------")
)

; -------------------------------------------------------------------------
; Erzeugt die Winkel
; -------------------------------------------------------------------------
(defun createWinkel (TrgEnde Winkel)
	;Erzeugung der Winkel
	(calcAndSetWinkeldaten Winkel TrgEnde)
	(if (= TrgEnde TrLinks)
		(progn
			(traeger.addabtl tr_id Winkel 0.0 0.0 _kopfplattelinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn
			(traeger.addabtl tr_id Winkel 0.0 0.0 _kopfplatterechts_)
		)
	)
)

; -------------------------------------------------------------------------

; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	
	(setq h_ht				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_v_ht h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))							(print uKante_ht)
	(setq oKante_at	(- delta_v_at h_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))							(print uKante_at)
	
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(setq oKante_at_tmp oKante_at)
			(setq uKante_at_tmp uKante_at)
			
			(setq oKante_at (- uKante_at_tmp))
			(setq uKante_at (- oKante_at_tmp))
		)
	)
		
	(setq diff_oben (- oKante_at oKante_ht))
	
	
	
	(print diff_oben)
	
)

(defun korrHtEnde (WINKELID)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(setq s_at 					(Traeger.get Tr_ID s)
				delta_lr_at		(Traeger.get Tr_ID delta_lr)
	)
	
	(setq slk_winkel (Winkel.get WINKELID slk))
	(print slk_winkel)
	
	(setq delta_l_htende (+ (+ slk_winkel (* 0.5 s_at)) delta_lr_at))
	
	(TrEnde.set HtEnde (delta_l (- delta_l_htende)))
)

(defun createSteife ()
	
	(setq steife (Blech.create))
	(Connect.storeAnschlObjs CastaData steife)
	
	(setq s_ht				(Traeger.get Htrg s))
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos 				(Connect.get CastaData xPos_ht)
			  at_lwinkel	(Connect.get CastaData at_laengswinkel)
	)
	
	
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_rechts_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_links_)
	)
	
	; xPos berechnen
		
	;Anteil delta_lr AT
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos delta_lr_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (- xPos delta_lr_at)))
	
	;Anteil AT Schrgstellung (Kopfplatte / HT-Steg)
	(setq tanW (tan (/ (* PI at_lwinkel) 180.0)))
	(setq anteil_schraege (/ (* s_ht 0.5) tanW))
	
	(if (> at_lwinkel 90.0)
		(setq at_lwinkel (- at_lwinkel 90.0))
	)
	
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos anteil_schraege)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (+ xPos anteil_schraege)))
	
	(setq AbtlSteife (traeger.get Htrg ABTeil steife))
	(Anbauteil.set  AbtlSteife (xpos xPos))
)