; $	HT	QT(IU)	AF(FS)	P(EZ)
; $	AT	QT(IU)	AF(K)		P(E)
; $	AE	V(90)		H(90)		R(-)

(defun load-modules ()
   (load "mod-endinit-uz-uzsteg-ohneAuskl")
)

(defun init-connection ()
	
	(Connect.showAttributes CastaData)
  (print "BEGIN init-connection uz_an_uzStegMitWinkeln");
  ;(setq rwinkel_at (Traeger.get Tr_ID r_winkel))
  
  ;(if (/= (Connect.get CastaData vatr-vhtr) 1)
  ;	(print "Bitte setzen Sie den Rotationswinkel des Anschlusstrgers auf 0."   "Set_RotAngle_AT_To_Zero")
		(setConnection)
	;)
	

  (print "END init-connection uz_an_uzStegMitWinkeln");
)


; ----------------------------------------------------------------------------------------
; Erzeugt die Verbindung
; ----------------------------------------------------------------------------------------
(defun setConnection ()
	(print "IMPORT mod-endinit-uz-uzsteg")
	(init-traegerenden)
  (print "IMPORT ENDE")
  
	  
  (setq winkel	(Winkel.create))
  (setq lchbWnkl (lochbild.create))
	(setq lchbAtrgSteg (lochbild.create))
	(Connect.storeAnschlObjs CastaData winkel lchbWnkl lchbAtrgSteg)
  
  (calcUnterschied)
  
  (calcMin_E_Werte lchbWnkl lchbAtrgSteg)
  
  (calcWinkelUndLochbilder winkel lchbWnkl lchbAtrgSteg)
  
  (createSteife)
  
  (if (= (Connect.get CastaData anschlZwHtEnden) 0)
		(korrHtEnde winkel)
	)
)


; ----------------------------------------------------------------------------------------
; Erzeugt den Winkel und die Lochbilder
; ----------------------------------------------------------------------------------------
(defun calcWinkelUndLochbilder (WINKEL LBSTEG_HT LBSTEG_AT)
	(print "------------------------------------------------------------")
	(print "BERECHNE WINKEL UND LOCHBILDER")
	(print "------------------------------------------------------------")
	
	; allg. Daten
	; ------------------------------------------------------------------
	(setq s_ht					(Traeger.get Htrg s)
				hc_ht					(Traeger.get Htrg hc)
				delta_lr_ht		(Traeger.get Htrg delta_lr)
				qsform_ht			(Traeger.get Htrg qsform)
				r_ht					(Traeger.get Htrg r)
				t_ht					(Traeger.get Htrg t)
	)
	
	(setq hc_at					(Traeger.get Tr_ID hc)
				s_at					(Traeger.get Tr_ID s)
				r_at					(Traeger.get Tr_ID r)
				t_at					(Traeger.get Tr_ID t)
				delta_lr_at		(Traeger.get Tr_ID delta_lr)
				qsform_at			(Traeger.get Tr_ID qsform)
	)
	
	(setq xPos_ht				(Connect.get CastaData xPos_ht)
				xPos_at				(Connect.get CastaData xPos_at)
	)
	
	(setq dw_winkel	10); Dicke des Winkels
	
	
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Winkel
	; ------------------------------------------------------------------
	
	; Winkelhoehe
	
	; maximale Hhe des Winkels
	(if (< okAusr_ht okAusr_at)
		(progn
			(print "OK_HT < OK_AT")
			(if (< ukAusr_ht ukAusr_at)
				(progn 
					(print "UK_HT < UK_AT")
					(setq hp (- okAusr_at ukAusr_ht))
				)
				(progn
					(print "UK_HT >= UK_AT")
					(setq hp hc_at)
				)
			)
		)
		(progn
			(print "OK_HT >= OK_AT")
			(if (< ukAusr_ht ukAusr_at)
				(progn 
					(print "UK_HT < UK_AT")
					(setq hp hc_ht)
				)
				(progn
					(print "UK_HT >= UK_AT")
					(setq hp (- okAusr_ht ukAusr_at))
				)
			)
		)
	)
	
	(if (< hp 0.0)
		(setq hp (- hp))
	)
	(print hp)
	
	(setq abstand_zwischen_ausr hp)
	
	; min_h_winkel aus 'calcMin_E_Werte'
	(if (< hp min_h_winkel)
		(setq winkel_hoehe hp)
		(setq winkel_hoehe min_h_winkel)
	)
	(print winkel_hoehe)
	
	
	; Schenkellngen
	
	; Schenkellnge am HT-Steg
	(setq slk_winkel_ht (+ (* e_blech_rund 2.0) dw_winkel))
	(print slk_winkel_ht)
	
	; Schenkellnge am AT-Steg
	(setq sll_winkel_at (+ (- delta_l_trgEnde (* 0.5 s_ht)) (* 2.0 e1_blech_rund)))
	(print sll_winkel_at)
	
	; DOK des Winkels
	(if (< okAusr_ht okAusr_at)
		(progn
			(print "OK_HT < OK_AT")
			(if (< ukAusr_ht ukAusr_at)
				(progn 
					(print "UK_HT < UK_AT")
					(setq dok (- (+ r_at t_at (* 0.5 abstand_zwischen_ausr)) (* 0.5 winkel_hoehe)))	
				)
				(progn
					(print "UK_HT >= UK_AT")
					(setq dok (- (+ r_at t_at (* 0.5 abstand_zwischen_ausr)) (* 0.5 winkel_hoehe)))	
				)
			)
		)
		(progn
			(print "OK_HT >= OK_AT")
			(if (< ukAusr_ht ukAusr_at)
				(progn 
					(print "UK_HT < UK_AT")
					(if (< diff_oben 0.0) (setq diff_oben (- diff_oben)))
					(setq dok (- (+ r_ht t_ht (* 0.5 abstand_zwischen_ausr) diff_oben) (* 0.5 winkel_hoehe)))	
				)
				(progn
					(print "UK_HT >= UK_AT")
					(if (< diff_oben 0.0) (setq diff_oben (- diff_oben)))
					(setq dok (- (+ r_ht t_ht (* 0.5 abstand_zwischen_ausr) diff_oben) (* 0.5 winkel_hoehe)))	
				)
			)
		)
	)
	
	;delta_v HT
	;(setq dok (- dok delta_v_ht))
	;(setq dok 0)
  (print dok)
  
  ; Winkeldaten setzen
  (Winkel.set WINKEL 	(wanz 	 	2)
											(l 	 			winkel_hoehe)
											(sll 	 		sll_winkel_at)
											(slk 	 		slk_winkel_ht)
											(dw 	 		dw_winkel)
											(wabst 	 	s_at)
											(achsab		(+ (* 0.5 s_ht) delta_lr_ht))
											(dok 	 		dOK)
											(delta_x 	0.0)
											(lage 	 	1)
											(schhoriz	100.000000)
													
	)

	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(Winkel.set WINKEL (achsab (+ s_ht delta_lr_ht)))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(Winkel.set WINKEL (achsab (- 0 delta_lr_ht)))
			)
		)
		(progn
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(Winkel.set WINKEL (achsab (+ (* 0.5 s_ht) delta_lr_ht)))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(Winkel.set WINKEL (achsab (- (* 0.5 s_ht) delta_lr_ht)))
			)
		)
	)
	
	; Winkel hinzufgen
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(Traeger.addabtl tr_id WINKEL 0.0 0.0 _kopfplattelinks_)
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(Traeger.addabtl tr_id WINKEL 0.0 0.0 _kopfplatterechts_)
		)
	)
	
	
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Lochbild am AT-Steg
	; ------------------------------------------------------------------
	
	(Lochbild.set LBSTEG_AT (Anz_S    4)
													(Guete   "4.6")
	)
	
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	
	(if (< hp min_h_winkel)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set LBSTEG_AT (Anz_S 2))
			(setq VIER 0) 
		)
	)	
	
	
	(print delta_l_trgEnde)
	(print e_blech)
	
	(setq w0 (+ delta_l_trgEnde e_blech))		; Randabstand
	(print w0)
	;(setq w0rund (runde w0 auf 5))
	(setq w1 (+ e1_blech w0))
	(print e1_blech)
	(print w1)											; Lochabstand
	;(setq w1rund (runde w1 auf 5))
	
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq lbart  2)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq lbart -2)
	)
	
	(Lochbild.set LBSTEG_AT (lb_art		lbart))
	
	
	; dxSKopf
	(if (= qsform_at "U")
		(progn
			(print "U-PROFIL")
			(if (= (Connect.get CastaData AmHtStegRechts) 1)
				(progn
					(print "HT RECHTS")
					(setq dxSKopf 50.0)
				)
			)
			(if (= (Connect.get CastaData AmHtStegLinks) 1)
				(progn
					(print "HT Links")
					(setq dxSKopf dw_winkel)	
				)
			)
		)
		(progn
			(print "KEIN U-PROFIL")
			(if (= (Connect.get CastaData AmHtStegRechts) 1)
				(if (= (Connect.get CastaData rechtesEnde) 1)
	    		(setq dxSKopf (- dw_winkel (* 0.5 s_at)))
	    		(setq dxSKopf       (* 0.5 s_at))
				)
			)
			(if (= (Connect.get CastaData AmHtStegLinks) 1)
				(if (= (Connect.get CastaData rechtesEnde) 1)
	    		(setq dxSKopf (+ dw_winkel (* 0.5 s_at)))
	    		(setq dxSKopf (+ dw_winkel (* 0.5 s_at)))
				)
			)
		)
	)
	(print dxSKopf)
	(Lochbild.set LBSTEG_AT  (dxSKopf  10))	
	
	
	(if (= VIER 1)
		(progn
			(setq e0 (+ dok (* 0.25 winkel_hoehe)))
			(print e0)
			(setq e0rund (runde e0 auf 5))
			(print e0rund)
			
			(Lochbild.set LBSTEG_AT (e0 			e0rund) 
															(e1 			e1_blech_rund) 
															(w0 			w0)
															(w1 			w1)
															(klemml 	(+ (* dw_winkel 2.0) s_at))																							
			)
		)
		(progn
			(setq e0 (+ dok (* 0.5 winkel_hoehe)))
			(setq e0rund (runde e0 auf 5))
			
			(Lochbild.set LBSTEG_AT (e0 			e0rund)
															(e1 			0) 										
															(w0 			w0)
															(w1 			w1)
															(klemml 	(+ (* dw_winkel 2.0) s_at))							
			)
		)
	)
	
		
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(Traeger.addabtl tr_id LBSTEG_AT xPos_at 0.0 _WnklSteglochbildLinks_)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(Traeger.addabtl tr_id LBSTEG_AT xPos_at 0.0 _WnklSteglochbildRechts_)
	)
	
	; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	; Lochbild am HT-Steg
	; ------------------------------------------------------------------
	
	(Lochbild.set LBSTEG_HT (Anz_S    4)
												(Guete   "4.6")
												(e       "100 0 0 0 0 0")
												(w       "40  0")									
	)
	
	; Wenn die Soll-Winkelhhe grer als hc des Trgers ist, kann das Blech nicht mehr angeschlossen werden.
	; In diesem Fall wird die Anzahl der Schrauben auf 2 verringert.
	(setq VIER 1)
	
	(if (< hp min_h_winkel)
		(progn
			(print "ES WIRD AUF 2 SCHRAUBEN REDUZIERT")
			(Lochbild.set LBSTEG_HT (Anz_S 2))
			(setq VIER 0) 
		)
	)
	
	(setq w0 (+ (* 0.5 s_at) (* (+ dw_winkel e_blech_rund) 2.0)))					; Randabstand
	(setq w0rund (runde w0 auf 5))
	(print w0rund)
	(print "-----")	
	
	;(if (< diff_oben 0.0)
	;	(setq diff_oben (- diff_oben))
	;)
	(print diff_oben)
	(if (= VIER 1)
		(progn
			(setq e0 (Lochbild.get LBSTEG_AT e0))
			(print e0)
			(if (< oKante_ht oKante_at)
				(setq e0 (+ e0 diff_oben))
				(setq e0 (- e0 diff_oben))
			)
				
			(print e0)
			(Lochbild.set LBSTEG_HT (e0 e0) 
															(e1 e1_blech_rund) 
															(w0 w0rund)								
			)
		)
		(progn
			(setq e0 (Lochbild.get LBSTEG_AT e0))
			(print e0)
			(if (< oKante_ht oKante_at)
				(setq e0 (+ e0 diff_oben))
				(setq e0 (- e0 diff_oben))
			)
			(print e0)
			(Lochbild.set LBSTEG_HT (e0 e0)
															(e1 0) 										
															(w0 w0rund)
			)
		)
	)
	
	;Klemmlnge
	(Lochbild.set LBSTEG_HT (klemml (+ dw_winkel s_ht)))	
	
	;(if (= (Connect.get CastaData vatr-vhtr)  1)
	;	(setq abteil_winkel 0.0)
	;)
	;(if (= (Connect.get CastaData vatr-vhtr) -1)
	;	(setq abteil_winkel 180.0)
	;)
	
	(setq abteil_winkel 0.0)
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id LBSTEG_HT 0.0 0.0 _kpllochbildlinks_)
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPos (- xPos_HT delta_lr_at))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq xPos (+ xPos_HT delta_lr_at))
			)
			(traeger.addabtl hTrg LBSTEG_HT xPos abteil_winkel _steglochbild_)		
		)
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn 
			;am Haupttrger
			(traeger.addabtl tr_id LBSTEG_HT 0.0 0.0 _kpllochbildrechts_)
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPos (+ xPos_HT delta_lr_at))
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(setq xPos (- xPos_HT delta_lr_at))
			)
			(traeger.addabtl hTrg LBSTEG_HT xPos abteil_winkel _steglochbild_)
		)
	)

	
	
	(setq s_HProf (Traeger.get HTrg s)
	      ;dw      (Winkel.get Winkel dw)
	)
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData AmHtStegRechts) 1)
				(if (= (Connect.get CastaData rechtesEnde) 1)
	    		(setq dxSKopf 			0)
	    		(setq dxSKopf       0)
				)
			)
			(if (= (Connect.get CastaData AmHtStegLinks) 1)
				(if (= (Connect.get CastaData rechtesEnde) 1)
	    		(setq dxSKopf dw_winkel)
	    		(setq dxSKopf dw_winkel)
				)
			)
		)
		(progn
			(if (= (Connect.get CastaData AmHtStegRechts) 1)
				(if (= (Connect.get CastaData rechtesEnde) 1)
	    		(setq dxSKopf (- dw_winkel (* 0.5 s_HProf)))
	    		(setq dxSKopf       (* 0.5 s_HProf))
				)
			)
			(if (= (Connect.get CastaData AmHtStegLinks) 1)
				(if (= (Connect.get CastaData rechtesEnde) 1)
	    		(setq dxSKopf (+ dw_winkel (* 0.5 s_HProf)))
	    		(setq dxSKopf (+ dw_winkel (* 0.5 s_HProf)))
				)
			)
		)
	)
	
	(Lochbild.set LBSTEG_HT  (dxSKopf  dxSKopf))
	
	;(setq at_lochbild_abtl (Traeger.get Tr_ID Abteil lchbWnkl))
	;(Anbauteil.set at_lochbild_abtl (delta_v (- diff_oben)))
)




; -------------------------------------------------------------------------
; Berechnet Oberkanten der Trger
; -------------------------------------------------------------------------
(defun calcUnterschied ()
	
	(setq h_ht				(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				hc_ht				(Traeger.get Htrg hc)
	)
	(setq h_at				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				hc_at				(Traeger.get Tr_ID hc)
	)
	
	(setq h_ht_halb	(* 0.5 h_ht))
	(setq h_at_halb	(* 0.5 h_at))
	
	; Ober- / Unterkante der Trger
	(setq oKante_ht (- delta_v_ht h_ht_halb))				(print oKante_ht)
	(setq uKante_ht (+ oKante_ht h_ht))							(print uKante_ht)
	(setq oKante_at	(- delta_v_at h_at_halb))				(print oKante_at)
	(setq uKante_at (+ oKante_at h_at))							(print uKante_at)
	
	;(if (= (Connect.get CastaData vatr-vhtr) -1)
	;	(progn
	;		(setq oKante_at_tmp oKante_at)
	;		(setq uKante_at_tmp uKante_at)
			
	;		(setq oKante_at (- uKante_at_tmp))
	;		(setq uKante_at (- oKante_at_tmp))
	;	)
	;)
	
	(setq diff_oben (- oKante_at oKante_ht))
	(print diff_oben)
	
	
	; obere Ausrundung der Profile
  (setq okAusr_Ht (+ oKante_ht (* 0.5 (- h_ht hc_Ht)))
        okAusr_At (+ oKante_at (* 0.5 (- h_At hc_At)))
  )
  (print okAusr_Ht)
  (print okAusr_At)
  
  ; untere Ausrundung der Profile
  (setq ukAusr_Ht (+ okAusr_Ht hc_Ht)	
        ukAusr_At (+ okAusr_At hc_At)
  )
  (print ukAusr_Ht)
  (print ukAusr_At)
	
	
	
	; Maximal- / Minimalwerte ermitteln (okante / ukante)
	(if (<= oKante_ht oKante_at)
		(progn
			(setq max_oKante oKante_ht)
			(setq min_oKante oKante_at)
		)
		(progn
			(setq max_oKante oKante_at)
			(setq min_oKante oKante_ht)
		)
	)
	(if (>= uKante_ht uKante_at)
		(progn
			(setq max_uKante uKante_ht)
			(setq min_uKante uKante_at)
		)
		(progn
			(setq max_uKante uKante_at)
			(setq min_uKante uKante_ht)
		)
	)
	(print max_oKante)
	(print max_uKante)
	(print min_oKante)
	(print min_uKante)
		
	(setq maxDiff (- max_oKante max_uKante))
	(setq minDiff (- min_oKante min_uKante))
	(print maxDiff)
	(print minDiff)
	
	(if (< maxDiff 0.0)
		(setq maxDiff (- maxDiff))
	)
	(if (< minDiff 0.0)
		(setq minDiff (- minDiff))
	)
	(print maxDiff)
	(print minDiff)
	
	
	
)

; ----------------------------------------------------------------------------------------
; BERECHNET DIE MINIMALEN RAND- UND LOCHABSTNDE DER SCHRAUBEN
; ----------------------------------------------------------------------------------------
(defun calcMin_E_WERTE (LBSTEG_HT LBSTEG_AT)
	(print "------------------------------------------------------------")
	(print "BERECHNE MINIMALE E-WERTE")
	(print "------------------------------------------------------------")
	
	(setq h_trg		(Traeger.get Tr_ID h))
	
	; Schaube anhand der Anschlusstrgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	
	; Schraube setzen
	(Lochbild.set LBSTEG_HT (S_Bez S_Bez))
	(Lochbild.set LBSTEG_AT (S_Bez S_Bez))
	
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get LBSTEG_HT sdurchm))
	
	; Defaultwerte berechnen ...
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	; ... und runden
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	; min. Winkelhhe aus Lochbild
	(setq min_h_winkel (+ e1_blech_rund (* e_blech_rund 2.0))) 
)




(defun korrHtEnde (WINKELID)
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(setq s_at 					(Traeger.get Tr_ID s)
				delta_lr_at		(Traeger.get Tr_ID delta_lr)
	)
	
	(setq slk_winkel (Winkel.get WINKELID slk))
	(print slk_winkel)
	
	(setq delta_l_htende (+ (+ slk_winkel (* 0.5 s_at)) delta_lr_at))
	
	(TrEnde.set HtEnde (delta_l (- delta_l_htende)))
)

(defun createSteife ()
	
	(setq steife (Blech.create))
	(Connect.storeAnschlObjs CastaData steife)
	
	(setq s_ht				(Traeger.get Htrg s))
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos 				(Connect.get CastaData xPos_ht)
			  at_lwinkel	(Connect.get CastaData at_laengswinkel)
	)
	
	
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_rechts_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_links_)
	)
	
	; xPos berechnen
		
	;Anteil delta_lr AT
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos delta_lr_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (- xPos delta_lr_at)))
	
	;Anteil AT Schrgstellung (Kopfplatte / HT-Steg)
	(setq tanW (tan (/ (* PI at_lwinkel) 180.0)))
	(setq anteil_schraege (/ (* s_ht 0.5) tanW))
	
	(if (> at_lwinkel 90.0)
		(setq at_lwinkel (- at_lwinkel 90.0))
	)
	
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos anteil_schraege)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (+ xPos anteil_schraege)))
	
	(setq AbtlSteife (traeger.get Htrg ABTeil steife))
	(Anbauteil.set  AbtlSteife (xpos xPos))
)