; $	G(1) 	HT	 QT(IU)	 	AF(S)		P(EZ)
; $	G(1)	AT	 QT(IUKRS) 	AF(K)		P(E)
; $	G(1)	AE	 V(-)		H(-)		R(-)
; $	G(31)	HT	 QT(IUK)	AF(SK)		P(EZ)
; $ G(31)	AT	 QT(IUKRS) 	AF(K)		P(E)
; $	G(31)	AE	 V(-)		H(-)		R(-)
; $	G(23)	HT	 QT(IUK)	AF(SK)		P(EZ)
; $ G(23)	AT	 QT(FT) 	AF(K)		P(E)
; $	G(23)	AE	 V(-)		H(-)		R(-)
; $			HT	QT(IU)		AF(S)		P(EZ)
; $ 		AT	QT(IUKRSL)  AF(K)		P(E)
; $			AE	V(-)		H(-)		R(-)

(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
   (load "mod-connection")
   (load "mod-add-schweiss-querschn")
)

(defun init-connection ()
	
	(print "*clear*")
	(Connect.showAttributes CastaData)
;	(setq rwinkel (Traeger.get Tr_ID r_winkel))
;	(Traeger.set Tr_ID (r_Winkel (- rwinkel 10.0)))
		
	;(if (= rwinkel 0.0)
		(calcAnschluss)
	;	(print "Bitte setzen Sie die Rotation des Anschlusstrgers auf 0, da eine Berechnung der Verbindung sonst nicht mglich ist." "Set_AT_Rotation_to_0")
	;)
		
  
)


(defun calcAnschluss ()
	(print "BEGIN init-connection uz_an_uzSteg");
  (print "IMPORT mod-endinit-uz-uzsteg")
	(init-traegerenden)
  (print "IMPORT ENDE")

  ; Schweiprofil eintragen
   (SchweissProfil_Einsetzen_St)
  ; berprfung auf weitere Anschlsse
  (setq anzAnschl (Connect.get CastaData anz_weitere_Anschl))
  (if (> anzAnschl 0)
  	(progn
  		(setq b_at		(Traeger.get Tr_ID b))
  		
  		(setq xPos_ht (Connect.get CastaData xPos_ht))
  		
  		
  		(setq tol_bereich 0)
  		
  		(setq lGrenze (- xPos_ht (* 0.5 b_at) tol_bereich))
  		(setq rGrenze (+ xPos_ht (* 0.5 b_at) tol_bereich))
  		
  		(checkForSteifen lGrenze rGrenze) ; -> steifen_vorhanden (1/0)
  		
  		(if (= steifen_vorhanden 1)
  			(progn
  				(calcXPositionsAmHT lGrenze rGrenze)	; -> xPos_abtl_1, xPos_abtl_2, xPos_at_l, xPos_at_r
  				(print "TEST")
  				(calcAuskl xPos_at_l xPos_at_r xPos_abtl_1 xPos_abtl_2)
  			)
  		)
  		
  		
  	)
  )

(if (= 1 2)	(progn
	; Wenn der Anschluss an HT-Ende stattfindet
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			(if (= (Connect.get CastaData anhtlinkesEnde) 1)
				(progn
					(setq HTLinks 	(Traeger.get Htrg Links))
					(korrTraegerEnde HTLinks)
				)
			)
			(if (= (Connect.get CastaData anhtrechtesEnde) 1)
				(progn
					(setq HTRechts	(Traeger.get Htrg Rechts))
					(korrTraegerEnde HTRechts)
				)
			)			
		)
	)
))

	(setq SWN_Fuge 3)		; Spalt zum Zuschweien
					; hier jetzt noch aus den Defaults den Wert variabel gestalten
	(if (>= SWN_Fuge 0) 
		(korrAuskl_Anschweissen)		; wenn >= 0, dann Flanschkante anschweien
		(korrAtEnde abstandZumSteg)
	)
	; (korrAuskl abstandZumSteg)
	
  (print "END init-connection uz_an_uzSteg");
)

; ---------------------------------------------------------------------------------
; Korrigiert die Lnge der Ausklinkungen
; ---------------------------------------------------------------------------------
(defun korrAuskl (abstandZumSteg)

	(setq AtEnde nil)
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(if (objExist AtEnde) (progn
	    (setq xakl_now (TrEnde.get AtEnde xakl))
	    (print xakl_now)
	
	    (TrEnde.set AtEnde (xakl (+ xakl_now abstandZumSteg)))
	))
)
(defun korrAuskl_Anschweissen ()

	(setq AtEnde nil)
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))

	(setq	b_HT		(Traeger.get HTrg b)
			s_HT		(Traeger.get HTrg s)
			qsform_ht	(Traeger.get Htrg qsform)
	)

	(setq wFakt 1.0)
	(if (objExist AtEnde) (progn
		(setq	EWinkel_H	(TrEnde.get AtEnde H_Winkel))
		(if (> EWinkel_H 90.0) (setq EWinkel_H (- 180.0 EWinkel_H)))
		(if (> EWinkel_H 1.0) (if (< EWinkel_H 90.0) (progn
			(setq sinW (sin (/ (* PI EWinkel_H) 180.0)))
			(setq wFakt (/ 1.0 sinW))
		)))
	))
		
	
	(setq fakt 0.5)
	(if (= qsform_ht "U") (setq fakt 1.0))
	
    (setq Auskl_Einbauen 0)
	(if (objExist AtEnde) (setq Auskl_Einbauen 1))
	(if (= qsform_ht "U") (setq fakt 1.0))
	(if (= qsform_ht "K") (setq Auskl_Einbauen 0))
	
	(setq fakt (* fakt wFakt))
	
	(if (= Auskl_Einbauen 1) (progn
	    (setq xakl_now (TrEnde.get AtEnde xakl))
	    (print xakl_now)
	    (setq xAkl_New (- (* fakt b_HT) (* fakt s_HT)))		
	    (setq xAkl_New (+ xAkl_New SWN_Fuge))			; 3 mm Spiel zum Zuschweien
	
	    (TrEnde.set AtEnde (xakl xAkl_New))
	))
)
; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des AT
; ---------------------------------------------------------------------------------
(defun korrAtEnde (abst)
	; Abstnde zum Ht korrigieren
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq	s_ht		(Traeger.get Htrg s)
		b_ht		(Traeger.get Htrg b)
		qsform_ht	(Traeger.get Htrg qsform)
	)
	
	
	(setq toTrim (- abst))
	
	(TrEnde.ptrim AtEnde toTrim)
	
)

; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des HT, wenn Anschluss am HT-Ende
; ---------------------------------------------------------------------------------
(defun korrTraegerEnde (TrgEnde)
	(print "KORRIGIERE HT-ENDE ...")
	
	(setq qsform_ht (Traeger.get Htrg qsform))
	(setq qsform_at	(Traeger.get Tr_ID qsform))
	
	(setq afl_winkel (Connect.get CastaData afl_hwinkel))
	(print afl_winkel)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(if (= (Connect.get CastaData linkesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID links)))
	(if (= (Connect.get CastaData rechtesEnde) 1)	(setq AtEnde (Traeger.get Tr_ID rechts)))
	
	(setq hscherl_at (TrEnde.get AtEnde hscherl))
	
	(setq hscherl_halb (* 0.5 hscherl_at))
		
	(setq b_ht_halb (* 0.5 b_ht))
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	(print tanafl)
	
	(setq delta_l_ht 0.0)
	
	(if (= qsform_ht "I")
		(progn
			(if (= qsform_at "I")
				(progn
					(setq verl_1 (/ b_ht_halb tanafl))
					(print verl_1)
	
					(setq delta_l_ht 0.0)
					
					(setq delta_l_ht (- delta_l_ht hscherl_halb))
					(print delta_l_ht)
					
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq delta_l_ht (+ delta_l_ht verl_1)))
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq delta_l_ht (- delta_l_ht verl_1)))
					
					;(TrEnde.set TrgEnde (delta_l delta_l_ht))
				)
			)
			(if (= qsform_at "U")
				(progn
					(setq verl_2 (/ b_ht tanafl))
					(print verl_2) 
					
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht 0.0))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht (- hscherl_at)))
						)
					)
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht (- hscherl_at)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht 0.0))
						)
					)
					
					;(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq delta_l_ht (+ delta_l_ht verl_2)))
					;(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq delta_l_ht (- delta_l_ht verl_2)))
					
					;(TrEnde.set TrgEnde (delta_l delta_l_ht))
				)	
			)
		)
	)
	(if (= qsform_ht "U")
		(progn
			(if (= qsform_at "I")
				(progn
					(setq verl_1 (/ b_ht_halb tanafl))
					(print verl_1)
	
					(setq delta_l_ht 0.0)
					
					(setq delta_l_ht (- delta_l_ht hscherl_halb))
					(print delta_l_ht)
					
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)	(setq delta_l_ht (+ delta_l_ht verl_1)))
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)	(setq delta_l_ht (- delta_l_ht verl_1)))
					
					;(TrEnde.set TrgEnde (delta_l delta_l_ht))
				)
			)
			(if (= qsform_at "U")
				(progn
					
					(if (= (Connect.get CastaData anHtLinkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht 0.0))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht (- hscherl_at)))
						)
					)
					(if (= (Connect.get CastaData anHtRechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-lhtr)  1)	(setq delta_l_ht (- hscherl_at)))
							(if (= (Connect.get CastaData satr-lhtr) -1)	(setq delta_l_ht 0.0))
						)
					)
					
					;(TrEnde.set TrgEnde (delta_l delta_l_ht))
				)	
			)
		)
	)
	
	
	
	
	
	(TrEnde.set TrgEnde (delta_l delta_l_ht))
	(print "KORREKTUR FERTIG")
)
; ====================================================================== 

(defun SchweissProfil_Einsetzen ()


	; Anschlussdaten ...
	; X-Position
	(setq xPos_ht		(Connect.get CastaData xPos_ht))
	; Rotationswinkel des AT
	(setq rWinkel 0.0)
	(setq rWinkel_AT	(Connect.get CastaData r-atrgewnkl_steg ))
	(print rWinkel_AT)


	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (print "linkes Ende am HT-Steg-links"))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (print "linkes Ende am HT-Steg-rechts"))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (print "rechtes Ende am HT-Steg-links"))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (print "rechtes Ende am HT-Steg-rechts"))
	))
	(setq satr-lhtr-ex  (Connect.get CastaData satr-lhtr-ex))
	(setq vAtr-vHtr     (Connect.get CastaData vAtr-vHtr))
	(setq sAtr-vHtr     (Connect.get CastaData sAtr-vHtr))
	(print vAtr-vHtr)
	(print sAtr-vHtr)
	(print satr-lhtr-ex)


	(if (= (Connect.get CastaData linkesEnde)  1) (progn
            (if (= (Connect.get CastaData satr-lhtr-ex)    1) (progn
	        (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (-  90.0 rWinkel_AT)))		; OK
	        (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (+ 90.0 (- 180.0 rWinkel_AT))))
	    ))
            (if (= (Connect.get CastaData satr-lhtr-ex)   -1) (progn
	        (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (+  90.0 rWinkel_AT)))		; OK
	        (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (-  rWinkel_AT 90.0)))		; OK
	    ))
            (if (= (Connect.get CastaData satr-lhtr-ex)    0) (progn
	        (if (= (Connect.get CastaData amHtStegRechts)   1) (progn
        	        (if (= (Connect.get CastaData sAtr-vHtr)   -1) (setq rWinkel  90.0))
                	(if (= (Connect.get CastaData sAtr-vHtr)    1) (setq rWinkel -90.0))
		))
	        (if (= (Connect.get CastaData amHtStegLinks)   1) (progn
        	        (if (= (Connect.get CastaData sAtr-vHtr)    1) (setq rWinkel  90.0))
                	(if (= (Connect.get CastaData sAtr-vHtr)   -1) (setq rWinkel -90.0))
            	))
	    ))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
            (if (= (Connect.get CastaData satr-lhtr-ex)    1) (progn
	        (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (+ 90.0 (- 180.0 rWinkel_AT))))	; OK
	        (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (- 90.0 rWinkel_AT)))		; OK
	    ))
            (if (= (Connect.get CastaData satr-lhtr-ex)   -1) (progn
	        (if (= (Connect.get CastaData amHtStegLinks)   1) (setq rWinkel    (- rWinkel_AT 90.0)))		; OK
	        (if (= (Connect.get CastaData amHtStegRechts)  1) (setq rWinkel    (+ 90.0 rWinkel_AT)))		; OK
	    ))
            (if (= (Connect.get CastaData satr-lhtr-ex)    0) (progn
	        (if (= (Connect.get CastaData amHtStegRechts)   1) (progn
        	        (if (= (Connect.get CastaData sAtr-vHtr)   -1) (setq rWinkel -90.0))
                	(if (= (Connect.get CastaData sAtr-vHtr)    1) (setq rWinkel  90.0))
		))
	        (if (= (Connect.get CastaData amHtStegLinks)   1) (progn
        	        (if (= (Connect.get CastaData sAtr-vHtr)    1) (setq rWinkel -90.0))
                	(if (= (Connect.get CastaData sAtr-vHtr)   -1) (setq rWinkel  90.0))
            	))
	    ))
	))


	(setq rWinkel (- rWinkel))
;	(print rWinkel)

	(if (= (Connect.get CastaData amHtStegLinks)  1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel _steg_links_))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Traeger.addJoinProfil HTrg Tr_ID xPos_ht rWinkel _steg_rechts_))
	
	; Anbauteil ermitteln
	(setq abtl_Trg (Traeger.get HTrg abTeil Tr_ID))
	(if (= (Connect.get CastaData linkesEnde)     1) (Anbauteil.set abtl_Trg (addflag  _endelinks_)))
	(if (= (Connect.get CastaData rechtesEnde)    1) (Anbauteil.set abtl_Trg (addflag _enderechts_)))
	(if (= (Connect.get CastaData amHtStegLinks)  1) (Anbauteil.set abtl_Trg (addflag _steg_links_)))
	(if (= (Connect.get CastaData amHtStegRechts) 1) (Anbauteil.set abtl_Trg (addflag _steg_rechts_)))

	
	(setq	dv_HT 	(Traeger.get HTrg delta_V))
	(setq	dv_AT 	(Traeger.get Tr_ID delta_V)
		dlr_AT	(Traeger.get Tr_ID delta_LR)
	)

	(print rWinkel)
	(print "------------------------------------")
	(setq sinWnk  (sin (* PI (/ rWinkel 180.0))))
	(setq cosWnk  (cos (* PI (/ rWinkel 180.0))))


	(setq delta_V_Abtl (- dv_AT dv_HT))
	
	

	
	(setq delta_LR_Abtl 0.0)
	(if (= (Connect.get CastaData linkesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq delta_LR_Abtl    dlr_AT))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq delta_LR_Abtl (- dlr_AT)))
	))
	(if (= (Connect.get CastaData rechtesEnde)  1) (progn
	    (if (= (Connect.get CastaData amHtStegLinks)   1) (setq delta_LR_Abtl (- dlr_AT)))
	    (if (= (Connect.get CastaData amHtStegRechts)  1) (setq delta_LR_Abtl    dlr_AT))
	))

	(setq delta_V_Abtl_Set  (- (* cosWnk delta_V_Abtl)  (* sinWnk delta_LR_Abtl)))
	(setq delta_LR_Abtl_Set (+ (* cosWnk delta_LR_Abtl) (* sinWnk delta_V_Abtl)))

	(Anbauteil.set abtl_Trg (delta_V  delta_V_Abtl_Set))
	(Anbauteil.set abtl_Trg (delta_LR delta_LR_Abtl_Set))

)  	
