(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
)

(defun init-connection ()
	
	(setq rwinkel (Traeger.get Tr_ID r_winkel))
		
	;(if (= rwinkel 0.0)
		(calcAnschluss)
	;	(alertBox "Bitte setzen Sie die Rotation des Anschlusstrgers auf 0, da eine Berechnung der Verbindung sonst nicht mglich ist." "Set_AT_Rotation_to_0")
	;)
		
  
)


(defun calcAnschluss ()
	(print "BEGIN init-connection uz_an_uzSteg");
  (print "IMPORT mod-endinit-uz-uzsteg")
	(init-traegerenden)
  (print "IMPORT ENDE")
  
  
	; Wenn der Anschluss an HT-Ende stattfindet
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			(if (= (Connect.get CastaData anhtlinkesEnde) 1)
				(progn
					(setq HTLinks 	(Traeger.get Htrg Links))
					(korrTraegerEnde HTLinks)
				)
			)
			(if (= (Connect.get CastaData anhtrechtesEnde) 1)
				(progn
					(setq HTRechts	(Traeger.get Htrg Rechts))
					(korrTraegerEnde HTRechts)
				)
			)			
		)
	)
	
	(korrAtEnde)
	
	(createSteife)
  (print "END init-connection uz_an_uzSteg");
)

; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des AT
; ---------------------------------------------------------------------------------
(defun korrAtEnde ()
	; Abstnde zum Ht korrigieren
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq s_ht			(Traeger.get Htrg s)
				qsform_ht	(Traeger.get Htrg qsform)
	)
	
	
	(if (= qsform_ht "I")
		(TrEnde.set AtEnde (delta_l (* 0.5 s_ht)))
	)
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(TrEnde.set AtEnde (delta_l 0))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(TrEnde.set AtEnde (delta_l s_ht))
			)
		)
	)
	
)

; ---------------------------------------------------------------------------------
; Korrigiert das Traegerende des HT, wenn Anschluss am HT-Ende
; ---------------------------------------------------------------------------------
(defun korrTraegerEnde (TrgEnde)
	(print "KORREGIERE HT-ENDE ...")
	
	(setq afl_winkel (Connect.get CastaData afl_hwinkel))
	(print afl_winkel)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq hscherl_at (TrEnde.get AtEnde hscherl))
	
	(setq hscherl_halb (* 0.5 hscherl_at))
		
	(setq b_ht_halb (* 0.5 b_ht))
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	(print tanafl)
	(if (< tanAfl 0.0)	(setq tanAfl (- tanAfl)))
	(print tanafl)
	
	(setq verl_1 (/ b_ht_halb tanafl))
	(print verl_1)
	
	(setq delta_l_ht (+ verl_1 hscherl_halb))
	(print delta_l_ht)
	
	(TrEnde.set TrgEnde (delta_l (- delta_l_ht)))
	
	(print "KORREKTUR FERTIG")
)
; ====================================================================== 

(defun createSteife ()
	
	(setq steife (Blech.create))
	(Connect.storeAnschlObjs CastaData steife)
	
	(setq s_ht				(Traeger.get Htrg s))
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos 				(Connect.get CastaData xPos_ht)
			  at_lwinkel	(Connect.get CastaData at_laengswinkel)
	)
		
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_rechts_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_links_)
	)
	
	; xPos berechnen
		
	;Anteil delta_lr AT
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos delta_lr_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (- xPos delta_lr_at)))
	
	;Anteil AT Schrgstellung (Kopfplatte / HT-Steg)
	(setq tanW (tan (/ (* PI at_lwinkel) 180.0)))
	(setq anteil_schraege (/ (* s_ht 0.5) tanW))
	
	(if (> at_lwinkel 90.0)
		(setq at_lwinkel (- at_lwinkel 90.0))
	)
	
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos anteil_schraege)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (+ xPos anteil_schraege)))
	
	(setq AbtlSteife (traeger.get Htrg ABTeil steife))
	(Anbauteil.set  AbtlSteife (xpos xPos))
)
