(defun load-modules ()
   (load "mod-endinit-uz-uzsteg")
)

(defun init-connection ()
	
	(setq rwinkel (Traeger.get Tr_ID r_winkel))
		
	;(if (= rwinkel 0.0)
	;	(calcAnschluss)
	;	(alertBox "Bitte setzen Sie die Rotation des Anschlusstrgers auf 0, da eine Berechnung der Verbindung sonst nicht mglich ist." "Set_AT_Rotation_to_0")
	;)
	(calcAnschluss)	
  
)


(defun calcAnschluss ()
	(print "BEGIN init-connection uz_an_uzSteg");
  (print "IMPORT mod-endinit-uz-uzsteg")
	(init-traegerenden)
  (print "IMPORT ENDE")
  
  (connect.showAttributes CastaData)
  
  (setq TrLinks   (traeger.get tr_id links))
  (setq TrRechts  (traeger.get tr_id rechts))
  
  (setq kpfpl	(Blech.create))
  (Connect.storeAnschlObjs CastaData kpfpl)
  
  
  (if (= 1 1)
  	(progn
  ; Anschlsse am Steg des Haupttrgers
  (if (= (Connect.get CastaData amHtStegLinks) 1) 
  	(progn
  		(print "Anschluss am Steg links")
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn
					(print "AT links")
					(createKopfplatte TrLinks kpfpl)
					(createLochbild TrLinks kpfpl)	
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					(print "AT rechts")
					(createKopfplatte TrRechts kpfpl)
					(createLochbild TrRechts kpfpl)
				)
			)
   	)
  )
  (if (= (Connect.get CastaData amHtStegRechts) 1) 
  	(progn
  		(print "Anschluss am Steg rechts")
			(if (= (Connect.get CastaData LinkesEnde) 1)
				(progn
					(print "AT links")
					(createKopfplatte TrLinks kpfpl)
					(createLochbild TrLinks kpfpl)
				)
			)
			(if (= (Connect.get CastaData RechtesEnde) 1)
				(progn			
					(print "AT rechts")
					(createKopfplatte TrRechts kpfpl)
					(createLochbild TrRechts kpfpl)
				)
			)
   	)
  )
  
  ; Wenn der Anschluss an HT-Ende stattfindet
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			(if (= (Connect.get CastaData anhtlinkesEnde) 1)
				(progn
					(setq HTLinks 	(Traeger.get Htrg Links))
					(korrTraegerEnde HTLinks)
				)
			)
			(if (= (Connect.get CastaData anhtrechtesEnde) 1)
				(progn
					(setq HTRechts	(Traeger.get Htrg Rechts))
					(korrTraegerEnde HTRechts)
				)
			)			
		)
	)

))
	

	(createSteife kpfpl)
	
  (print "END init-connection uz_an_uzSteg");
)


; -------------------------------------------------------------------------
; Erzeugt die Kopfplatte
; -------------------------------------------------------------------------
(defun createKopfplatte (TrgEnde Kpfpl)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE DIE KOPFPLATTE")
	;Erzeugung der Kopfplatte
	(calcAndSetBlechdaten Kpfpl TrgEnde)
	(if (= TrgEnde TrLinks)
		(progn
			(traeger.addabtl tr_id Kpfpl 0.0 0.0 _kopfplattelinks_)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn
			(traeger.addabtl tr_id Kpfpl 0.0 0.0 _kopfplatterechts_)
		)
	)
	
		
	(print "<-----------------------------------------------------------")
)


; --------------------------------------------------------------------------
; Berechnet die Daten der Kopfplatte
; --------------------------------------------------------------------------
(defun calcAndSetBlechdaten (Kpfpl TrgEnde)

  (print ">-----------------------------------------------------------")
  (print "Berechne Kopfplattendaten")

	(setq zAkl   (trEnde.get TrgEnde zakl)
	      hSteg  (trEnde.get TrgEnde hsteg)
	      hProf  (Traeger.get Tr_ID h)
	      h_wnkl (trEnde.get TrgEnde hsteg)
	    	qsform (Traeger.get htrg qsform)
	)
	(print "---------")
	(print zAkl)
	(print hSteg)
	(print hProf)
	(print "---------")

	(if (= (Connect.get CastaData vatr-vhtr) 1)
		(progn
			(if (> zAkl 0) 
				(progn
			    (if (> hSteg 0) 
			        (setq dOK zAkl 
			        			hp 	hSteg)		; Doppelausklinkung
			        ;else
			        (setq dOK zAkl 
			        			hp 	(- hProf zAkl 5))	; nur obere Ausklinkung
			    )
			  ) ; progn
			  (progn
			    (if (> hSteg 0) 
			        (setq dOK 5 
			        			hp 	hSteg)			; nur untere Ausklinkung
			        ;else
			        (setq dOK   5 
			        			hp 		(- hProf 10))		; keine Ausklinkung
			    )
			  ) ; progn
			)	
		)
	)
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(if (> zAkl 0) 
				(progn
			    (if (> hSteg 0) 
			        (setq dOK zAkl 
			        			hp 	hSteg)		; Doppelausklinkung
			        ;else
			        (setq dOK zAkl 
			        			hp 	(- hProf zAkl 5))	; nur obere Ausklinkung
			    )
			  ) ; progn
			  (progn
			    (if (> hSteg 0) 
			        (setq dOK 5 
			        			hp 	(- hsteg 5))			; nur untere Ausklinkung
			        ;else
			        (setq dOK   5 
			        			hp 		(- hProf 10))		; keine Ausklinkung
			    )
			  ) ; progn
			)	
		)
	)
  (setq bp 120)
	
	;(if (= qsform "U")
	;	(if (= (Connect.get CastaData amHtStegLinks) 1)
	;		(setq dOK   5 
	;					hp 		(- hProf 10)
	;		)		; keine Ausklinkung
	;	)
	;)
	
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set Kpfpl (dp 10) (hp hp) (bp bp) (dOK dOK))
	
	(print "<-----------------------------------------------------------")
)

; -------------------------------------------------------------------------
; Erzeugt die Lochbilder
; -------------------------------------------------------------------------
(defun createLochbild (TrgEnde BlechID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE LOCHBILD")
	
	;Lochbild erzeugen und der Anschlussliste hinzufgen
	(setq lchbBlech (lochbild.create))
	(calcAndSetLochbildDaten lchbBlech TrgEnde BlechID)
	(Connect.storeAnschlObjs CastaData lchbBlech)
		
	; allg. Daten
	(setq xPos_ht	(Connect.get CastaData xPos_ht))	(print xPos_ht)
	
	(setq delta_lr_trg 	(Traeger.get Tr_ID delta_lr)
				delta_V2 			(Traeger.get Tr_ID delta_v)
				hProf2   			(Traeger.get Tr_ID h)
				rwinkel_at		(Traeger.get Tr_ID r_winkel)
	)

	(setq	delta_V  		(Traeger.get Htrg delta_v)
				hProf    		(Traeger.get Htrg h)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
				s_HProf 		(Traeger.get HTrg s)
				qsform_ht		(Traeger.get Htrg qsform)
	)
	
	(setq dp      		(Blech.get BlechID dp))
	
	(if (= (Connect.get CastaData vatr-vhtr) 1)
		(setq lbDOK    		(- delta_V (/ hProf 2.0) (- (- (/ hProf2 2) delta_V2))))
	)
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(setq lbDOK    		(- delta_V (/ hProf 2.0) (- (+ (/ hProf2 2) delta_V2))))
	)
			
	(print lbDOK)
	
	
	;(Lochbild.set lchbBlech (dvHTrg lbDOK))

	; dxSKopf berechnen
	(if (= (Connect.get CastaData amHtStegrechts) 1)	(setq dxSKopf (* 0.5 s_HProf)))
	(if (= (Connect.get CastaData amHtSteglinks) 1)		(setq dxSKopf (+ dp (* 0.5 s_HProf))))
	
	(if (= qsform_ht "U")
		(progn
			(if (= (Connect.get CastaData amHtStegrechts) 1)	(setq dxSKopf 0))
			(if (= (Connect.get CastaData amHtSteglinks) 1)		(setq dxSKopf dp ))
		)
	)
	
	; dxSKopf setzen
	(Lochbild.set lchbBlech  (dxSKopf  dxSKopf))
	
	
	; korregiere XPOS am HT des Lochbildes bei schrgem Anschluss
	(setq abst_1 (+ dp (* 0.5 s_HProf)))
	
	(setq hWnkl (Connect.get CastaData afl_hwinkel))
	(print hWnkl)
	
	(setq tanAFL (tan (/ (* PI hWnkl) 180.0)))
	(setq sinAFL (sin (/ (* PI hWnkl) 180.0)))
	(print tanafl)
	
	(setq xPosKorr_1 (/ abst_1 tanAFL))
	(print xPosKorr_1)
	
	(setq xPos_ht (+ xPos_ht xPosKorr_1))
	(print xPos_ht)
	; <-------------------------
	
	; Korregiere XPOS am HT des Lochbildes bei Verschiebung des HT in delta_lr
	(setq xPosKorr_2 (/ delta_lr_ht tanAFL))
	
	(print xPosKorr_2)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)	(setq xPos_ht (+ xPos_ht xPosKorr_2)))
	(if (= (Connect.get CastaData amHtStegLinks) 1)		(setq xPos_ht (- xPos_ht xPosKorr_2)))
	
	(print xPos_ht)
	; <-------------------------
	
	; Korregiere XPOS am HT des Lochbildes bei Verschiebung des AT in delta_lr
	(setq versch_aus_delta_lr_trg (/ delta_lr_trg sinAFL))
	(print versch_aus_delta_lr_trg)
	
	(if (= TrgEnde TrLinks)
		(progn
			(if (= (Connect.get CastaData amHtStegLinks) 1)	
				(setq xPos_ht (+ xPos_HT versch_aus_delta_lr_trg))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPos_ht (- xPos_HT versch_aus_delta_lr_trg))
			)
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			(if (= (Connect.get CastaData amHtStegLinks) 1)	
				(setq xPos_ht (- xPos_HT versch_aus_delta_lr_trg ))
			)
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(setq xPos_ht (+ xPos_HT versch_aus_delta_lr_trg ))
			)
		)
	)
	
	(print xPos_ht)
	
 	
 	; Korregiert das Lochbild und die Kopfplatte bei schrgem Anschluss, damit die Schrauben
 	; eingesetzt werden knnen
 	; --> Asymmetrie
 	(korrBlechAndLochbild lchbBlech BlechID)
 	; <-------------------------
 	
 	; gleicht die Verschiebung delta_w des HT mit der des AT ab.
 	(if (> hWnkl 90.0)
 		;(setq delta_w_korr_ht (* 2.0 delta_w_lb))
 		(setq delta_w_korr_ht 0)
 		(setq delta_w_korr_ht 0)
 	)
 	(print delta_w_korr_ht)
 	
 	(setq xPos_ht (- xPos_ht delta_w_korr_ht))
 	; <-------------------------
 	
 	(setq xPos xPos_ht)
 	
 	
	
 	
 	; Anbauteil LOCHBILD einfgen
 	; ---------------------------
	(if (= TrgEnde TrLinks)
		(progn
			(traeger.addabtl hTrg lchbBlech xPos 0.0 _steglochbild_)
			(traeger.addabtl tr_id lchbBlech 0.0 0.0 _kpllochbildlinks_)
			
		)
	)
	(if (= TrgEnde TrRechts)
		(progn 
			(traeger.addabtl hTrg lchbBlech xPos 0.0 _steglochbild_)
			(traeger.addabtl tr_id lchbBlech 0.0 0.0 _kpllochbildrechts_)
		)
	)
	
	
	
	(setq steg_abtl_at (Traeger.get Tr_ID Abteil lchbBlech))
	(Anbauteil.set steg_abtl_at 	(Master 0))
	
	(setq steg_abtl (Traeger.get Htrg Abteil lchbBlech))
	(Anbauteil.set steg_abtl 	(Master 1)
														(delta_v (- lbDOK))
														(SeitRicht 1)
	)
	
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(progn
			(if (= (Connect.get CastaData linkesEnde) 1)
				(Anbauteil.set steg_abtl 	(SeitRicht -1))
			)
		)
	)
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(progn
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(Anbauteil.set steg_abtl 	(SeitRicht -1))
			)
		)
	)
	
	(print "<-----------------------------------------------------------")
)

; -------------------------------------------------------------------------
; Berechnet die Lochbilddaten an der Kopfplatte des AT
; -------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde BlechID)
	(print "------------------------------------------------------------")
	(Print "BERECHNE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
	;Basiseinstellungen (evtl. weglassen und Gren in Abhngigkeit anderer Gren berechnen)
	(Lochbild.set Lchb_ID (Anz_S    4)
												(Guete   "4.6")
												(e       "100 0 0 0 0 0")
												(w       "40  0")
	)
	
	(setq hp_bl		(Blech.get BlechID hp)
				dp_bl		(Blech.get BlechID dp)
				dok_bl	(Blech.get BlechID dok)
	)
	(setq h_trg		(Traeger.get Tr_ID h)
				hc_trg	(Traeger.get Tr_ID hc)
				s_trg		(Traeger.get Tr_ID s)
	)
	(setq hc_htrg (Traeger.get Htrg hc)
				s_htrg	(Traeger.get Htrg s)
	)
	
	; Schaube anhand der Anschlusstrgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq hp_aus_e (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Blechhhe aus Lochbild
	
	(print dok_bl)
	(if (= (Connect.get CastaData vatr-vhtr) -1)
		(progn
			(print zakl)
			(print hsteg)
			(if (/= zakl 0.0)
				(progn
					(if (/= hsteg 0.0)
						(progn
							(setq dok_bl (- h_trg (+ zakl hsteg)))
						)
						(progn
							(setq dok_bl 5)
						)
					)
				)
				(progn
					(if (/= hsteg 0.0)
						(progn
							(setq dok_bl (- h_trg hsteg))
						)
						(progn
							(print "Werte unverndert")
						)
					)
				)
			)
		)		
	)
	(print dok_bl)
	
	(if (> hp_bl hp_aus_e)
		(progn
			(setq e0 (+ (/ hp_bl 4.0) dok_bl))
			(setq e0rund (runde e0 auf 5))
			(setq e1 (/ hp_bl 2.0))
			(setq e1rund (runde e1 auf 5))
			
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 e1rund)
			)
		)
		(progn
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq e0 (+ (/ hp_bl 2.0) dok_bl))
			(setq e0rund (runde e0 auf 5))
			
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0)
			)
		)		
	)
	
	(Lochbild.set Lchb_ID (w0 e1_blech_rund))
	(Lochbild.set Lchb_ID (klemml (+ dp_bl s_htrg)))
	;Kopfplatte korregieren
	(Blech.set BlechID (bp (* 2 e1_blech_rund)))
	(print "------------------------------------------------------------")
)

; -------------------------------------------------------------------------
; Korregiert das Blech und Lochbild bei einem schrgen Anschlu
; --> Asymmetrie
; -------------------------------------------------------------------------
(defun korrBlechAndLochbild (Lchb_ID BlechID)
	(print "schrger Anschluss! -> korregiere Daten ...")
	
	(setq s_htrg 			(Traeger.get Htrg s)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq dp_blech 		(Blech.get BlechID dp)
				bp_blech		(Blech.get BlechID bp)
	)
	
	; TODO
	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	; Schraubenlnge wird nicht richtig berechnet
	; !!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
	(setq schr_l		(Lochbild.get Lchb_ID laenge))
	(setq schr_l (+ schr_l 50)) ; Ersatzweise um 5 cm verlngert
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq Winkel (Connect.get CastaData afl_hwinkel))
	(print Winkel)
	
	(print schr_l)
	(setq tanW (tan (/ (* PI Winkel) 180.0)))
	
	; minimaler Abstand der Schraube zum AT-Steg bei spitzem Winkel, 
	; damit die Schraube noch eingefgt werden kann.
	(setq min_Abst (/ schr_l tanW))
	(if (< min_Abst 0.0)
		(setq min_Abst (- min_Abst))
	)
	
	(setq w0 (Lochbild.get Lchb_ID w0))
	(print w0)
	; Abstand der Schraube von AT-Systemlinie bei geradem Anschluss (90).
	(setq ist_Abst (* 0.5 w0))
	
	(print min_Abst)
	(print ist_Abst)
	
	(setq delta_w_lb 0)
	(if (< ist_Abst min_Abst)
		(progn
			;Lochbild
			(setq verl_des_ist_Abst (- min_Abst ist_Abst))
			(print verl_des_ist_Abst)
			(setq verl_des_ist_Abst (runde verl_des_ist_Abst auf 5))
			(print verl_des_ist_Abst)
			(if (> Winkel 90.0)
				(setq delta_w (- (* 0.5 verl_des_ist_Abst)))
				(setq delta_w (* 0.5 verl_des_ist_Abst))
			)
			(print delta_w)
			(setq delta_w_lb delta_w)
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)
						(setq delta_w_lb (- delta_w_lb))
					)
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(setq delta_w_lb (- delta_w_lb))
					)
				)
			)
			(print delta_w_lb)
			
			
			(Lochbild.set Lchb_ID  	(w0 			(+ w0 verl_des_ist_Abst))
															(delta_w	delta_w_lb)
			)
			
			
			;Kopfplatte
			(setq bp_neu_blech (+ bp_blech verl_des_ist_Abst))
			(print bp_neu_blech)
			
			(if (= (Connect.get CastaData amHtStegRechts) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1) 	(setq blech_versch (- delta_w)))
					(if (= (Connect.get CastaData rechtesEnde) 1) (setq blech_versch delta_w))
				)
			)
			(if (= (Connect.get CastaData amHtStegLinks) 1)
				(progn
					(if (= (Connect.get CastaData linkesEnde) 1)	(setq blech_versch delta_w))
					(if (= (Connect.get CastaData rechtesEnde) 1)	(setq blech_versch (- delta_w)))
				)
			)
			
			(if (= rwinkel_at 180.0)
				(setq blech_versch (- blech_versch))
			)
			
			(print blech_versch)
			(Blech.set BlechID (bp 				bp_neu_blech)
												 (delta_lr 	blech_versch)
			)
		)
	)
	
	
	;(Blech.set   BlechID (delta_lr (- bl_versch)))
	;(Lochbild.set Lchb_ID  (delta_w  100))
	(print "Korrektur beendet!")
)

; ---------------------------------------------------------------------------------
; Korregiert das Traegerende des HT, wenn Anschluss am HT-Ende
; ---------------------------------------------------------------------------------
(defun korrTraegerEnde (TrgEnde)
	(print "KORREGIERE HT-ENDE ...")
	
	(setq afl_winkel (Connect.get CastaData afl_hwinkel))
	(print afl_winkel)
	
	(setq b_ht	(Traeger.get Htrg b))
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr)) 
	
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq hscherl_at (TrEnde.get AtEnde hscherl))
	
	(setq hscherl_halb (* 0.5 hscherl_at))
		
	(setq b_ht_halb (* 0.5 b_ht))
	
	(setq tanAfl (tan (/ (* PI afl_winkel) 180.0)))
	(print tanafl)
	(if (< tanAfl 0.0)	(setq tanAfl (- tanAfl)))
	(print tanafl)
	
	(setq verl_1 (/ b_ht_halb tanafl))
	(print verl_1)
	
	(setq delta_l_ht (+ verl_1 hscherl_halb delta_lr_at))
	(print delta_l_ht)
	
	(TrEnde.set TrgEnde (delta_l (- delta_l_ht)))
	
	(print "KORREKTUR FERTIG")
)
; ====================================================================== 

(defun createSteife (KPL_Blech)
	
	(setq steife (Blech.create))
	(Connect.storeAnschlObjs CastaData steife)
	
	(setq s_ht				(Traeger.get Htrg s))
	
	(setq delta_lr_at (Traeger.get Tr_ID delta_lr))
	
	(setq xPos 				(Connect.get CastaData xPos_ht)
			  at_lwinkel	(Connect.get CastaData at_laengswinkel)
	)
	
	(setq dp_kpl			(Blech.get KPL_Blech dp))
	
	(if (= (Connect.get CastaData amHtStegLinks) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_rechts_)
	)
	(if (= (Connect.get CastaData amHtStegRechts) 1)
		(traeger.addabtl Htrg steife 0.0 0.0 _vollsteife_links_)
	)
	
	; xPos berechnen
		
	;Anteil delta_lr AT
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos delta_lr_at)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (- xPos delta_lr_at)))
	
	;Anteil AT Schrgstellung (Kopfplatte / HT-Steg)
	(setq tanW (tan (/ (* PI at_lwinkel) 180.0)))
	(setq anteil_schraege (/ (+ (* s_ht 0.5) dp_kpl) tanW))
	
	(if (> at_lwinkel 90.0)
		(setq at_lwinkel (- at_lwinkel 90.0))
	)
	
	(if (= (Connect.get CastaData satr-lhtr)  1) (setq xPos (+ xPos anteil_schraege)))
	(if (= (Connect.get CastaData satr-lhtr) -1) (setq xPos (+ xPos anteil_schraege)))
	
	(setq AbtlSteife (traeger.get Htrg ABTeil steife))
	(Anbauteil.set  AbtlSteife (xpos xPos))
)
