(defun calcConnection ()

		(setq LB_DEBUG 0)
    ;(init-traegerenden)
    (print "******************************************************************************")
    (print  "ut_auf_stzKopf: in init-connection")
    
    
		(if (= (connect.get CastaData LinkesEnde)  1)	(setq TrgEnde (Traeger.get Tr_ID links)))
		(if (= (connect.get CastaData RechtesEnde) 1) 	(setq TrgEnde (Traeger.get Tr_ID rechts)))
		
		(if (= (Connect.get CastaData anschlzwhtenden) 1)
			(progn
				(if (= (connect.get CastaData LinkesEnde) 1) 	(setq StzEnde (Traeger.get Tr_ID links)))
				(if (= (connect.get CastaData RechtesEnde) 1) (setq StzEnde (Traeger.get Tr_ID rechts)))
			)
		)
		(setq blKpl (blech.create))
    		(setq lochb	(lochbild.create))
		(Connect.storeAnschlObjs CastaData blKpl lochb) 
		(calcAndSetBlechdaten blKpl TrgEnde)
		(calcAndSetLochbildDaten lochb blKpl)
		(createFlanschLochb lochb blKpl)
		(AT_Lochbild_dlr_aus_dp lochb 0)
		(blech_fine_tunen  blKpl lochb)
		
		(setq AT_QForm (Traeger.get Tr_ID qsForm))
		(if (= AT_QForm "K") (anpassen_an_HT_QR_RR))
		; (Anpassen


	(Funktion_Kann_weg)

	(Ausrichten_Lochbild_an_HT_AT)
	
	;Steifen am Anschlusstrger standardmig auf Flanschdicke der Sttze
	(setq dp_aus_Flansch (Traeger.get Tr_ID t))
	
	(createSteifen dp_aus_Flansch)

;   (Connect.showattributes CastaData)	
 
;   (Lochbild.set lochb (e "0 30 100 0 0 0"))
;   (setq Abtl_Lchb (Traeger.get HTrg ABTeil lochb))
;   (setq xPos (Anbauteil.get Abtl_Lchb xPos))
 
)
; ====================================================================== 
(defun calcConnection_Multiple ()

		(setq LB_DEBUG 0)
    ;(init-traegerenden)
    (print "******************************************************************************")
    (print  "ut_auf_stzKopf: in init-connection")
    
		(setq ABTL_VORH 0)
		(if (= (connect.get CastaData LinkesEnde)  1) (progn
			(setq TrgEnde (Traeger.get Tr_ID links))
			(setq xPosKpl (TrEnde.get TrgEnde delta_L))
			(checkForKplAtPosition xPosKpl 10.0 Tr_ID)
		))

		(if (= (connect.get CastaData RechtesEnde) 1) (progn
			(setq TrgEnde (Traeger.get Tr_ID rechts))
			(setq trgLaenge (Traeger.get Tr_ID SysLng))
			(setq dlRechts (TrEnde.get TrgEnde delta_L))
			(setq xPosKpl (- trgLaenge dlRechts))
			(checkForKplAtPosition xPosKpl 10.0 Tr_ID)
		))
		
		(if (= (Connect.get CastaData anschlzwhtenden) 1)
			(progn
				(if (= (connect.get CastaData LinkesEnde) 1) 	(setq StzEnde (Traeger.get Tr_ID links)))
				(if (= (connect.get CastaData RechtesEnde) 1) (setq StzEnde (Traeger.get Tr_ID rechts)))
			)
		)
		(if (= ABTL_VORH 0) (progn
			(setq blKpl (blech.create))
			(setq lochb	(lochbild.create))
			(Connect.storeAnschlObjs CastaData blKpl lochb) 
		))
		(if (= ABTL_VORH 1) (progn
			(setq blKpl (Anbauteil.get abtlKpl objekt Blech))
			(setq lochb	(lochbild.create))
			(Connect.storeAnschlObjs CastaData lochb) 
		))
		
		(calcAndSetBlechdaten blKpl TrgEnde)
		(calcAndSetLochbildDaten lochb blKpl)
		(createFlanschLochb lochb blKpl)
		(AT_Lochbild_dlr_aus_dp lochb 0)
		
		(if (= ABTL_VORH 0) (progn
			(HalbBlech_fine_tunen  blKpl lochb)
		))
		(if (= ABTL_VORH 1) (progn
			(VollBlech_fine_tunen  blKpl lochb)
		))
		
		(setq AT_QForm (Traeger.get Tr_ID qsForm))
		(if (= AT_QForm "K") (anpassen_an_HT_QR_RR))
		; (Anpassen

	(Funktion_Kann_weg)

	(Ausrichten_Lochbild_an_HT_AT)
	
	;Steifen am Anschlusstrger standardmig auf Flanschdicke der Sttze
	(setq dp_aus_Flansch (Traeger.get Tr_ID t))
	
	(createSteifen dp_aus_Flansch)

;   (Connect.showattributes CastaData)	
   
;   (Lochbild.set lochb (e "0 30 100 0 0 0"))
;   (setq Abtl_Lchb (Traeger.get HTrg ABTeil lochb))
;   (setq xPos (Anbauteil.get Abtl_Lchb xPos))
 
)
; ====================================================================== 
; ====================================================================== 
; ----------------------------------------------------------------------
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)
	(print "----------------------------- In calcAndSetBlechdaten")
	
	(setq hProf 				(Traeger.get Tr_ID h)
				t_at				(Traeger.get Tr_ID t)
				b_at				(Traeger.get Tr_ID b)
				delta_lr_at		(Traeger.get Tr_ID delta_lr)
	)

	(setq b_ht				(Traeger.get Htrg b)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	
	(setq t_at_rund (runde t_at auf 10))
	
	(setq hp hProf)		; erstmal so voreinstellen
  (setq bp 120)
  (setq dp  t_at_rund)
  (setq dOK  5)

  ;(setq EWinkel (TrEnde.get TrgEnde V_Winkel))
  ;(print EWinkel)
	;(setq sinW (sin (* PI (/ EWinkel 180.0))))
	;(if (/= sinW 0) (setq hp (/ hp sinW)))
	
	(setq scherl_ht (TrEnde.get TrgEnde vscherl))
	(print scherl_ht)
	
	(setq hp scherl_ht)

  (setq hp (- hp (* 2.0 dOK)))	; wir erzeugen eine bndige Kopfplatte
	      
	; Blechbreite
	;(if (> b_at b_ht)
	;	(setq bp b_ht)
	;	(setq bp b_at)
	;)        
	(setq bp b_ht)
	
	
	; delta_lr
	(setq delta_lr_blech 0.0)
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_blech (- delta_lr_ht delta_lr_at)))
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_blech (- (- delta_lr_ht) delta_lr_at))) 
	
	; Anteil der horizontalen Neigung an delta_lr
	; ---------------------------------------------
	(setq h_uz 				(Traeger.get Htrg h)
				r_winkel_uz	(Traeger.get Htrg r_winkel)
	)
	(setq h_uz_halb (* 0.5 h_uz))
	
	(setq tanW (tan (/ (* PI r_winkel_uz) 180.0)))
	
	(setq anteil_uz (+ h_uz_halb dp))
	
	(setq anteil_neigung (* anteil_uz tanW))
	
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_blech (- delta_lr_blech anteil_neigung)))
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_blech (+ delta_lr_blech anteil_neigung)))
	
	; (setq dp  30)
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp 			dp) 
													(hp 			hp) 
													(bp 			bp) 
													(dOK 			dOK)
	)

  (setq htDeltaV (Traeger.get hTrg delta_V))

  (setq delta_L dp)
  (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
  (print delta_L)
  (TrEnde.pTrim TrgEnde dp)

	
)

; ----------------------------------------------------------------------
(defun calcAndSetBlechdaten_AT_Stz (blKopfplatte TrgEnde)

   (print  "----------------------------- In calcAndSetBlechdaten")

   (setq hProf (Traeger.get Htrg h))

	(setq hp hProf)		; erstmal so voreinstellen
        (setq bp 120)
        (setq dp  25)
        (setq dOK  5)

  (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
        							(print EWinkel)
	(setq sinW (sin (* PI (/ EWinkel 180.0))))
	(if (/= sinW 0) (setq hp (/ hp sinW)))

        (setq hp (- hp dOK 5))	; wir erzeugen eine bndige Kopfplatte
	      
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp dp) (hp hp) (bp bp) (dOK dOK))

    (setq htDeltaV (Traeger.get Tr_ID delta_V))

    (setq delta_L dp)
    (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
    								(print delta_L)
    (TrEnde.pTrim TrgEnde dp)

	
)



; ====================================================================== 
; Berechnet und erzeugt die Steifen 
; ====================================================================== 
; ----------------------------------------------------------------------
(defun createSteifen (dp)
	(print "--------------- in createSteifenAT")
	(setq hProf    	(Traeger.get  HTrg h)
	      sProf    	(Traeger.get  HTrg s)
	      bProf    	(Traeger.get  HTrg b)
	      dV       	(Traeger.get  HTrg delta_V)
	      delta_l  	(Traeger.get  HTrg delta_l)
	      sys_l    	(Traeger.get  HTrg syslng)
	      hStz     	(Traeger.get  Tr_ID  h)
	      fStz     	(Traeger.get  Tr_ID  t)
	      dvStz    	(Traeger.get  Tr_ID  delta_V)
	      rWnkl_trg	(Traeger.get Tr_ID r_winkel)
	      VWnkl    	(connect.get CastaData hpttrg_vwinkel)
	      VWnkl_trg (connect.get CastaData trg_vwinkel)
	)
	
;	(setq VATr-LHTr (Connect.get CastaData vatr-lhtr))
;	(if (= (Connect.get CastaData anHtlinkesEnde)  1) (if (= (Connect.get CastaData amHtUnterFlansch) 1) (setq dvStz (- dvStz))))
;	(if (= (Connect.get CastaData anHtrechtesEnde) 1) (if (= (Connect.get CastaData amHtOberFlansch)  1) (setq dvStz (- dvStz))))
	
	; ----------------------
	(setq xPosOben  0.0)	; Initialisierung
	(setq xPosUnten 0.0)	; Initialisierung
	
	(if (> VWnkl 180.0) (setq VWnkl (- VWnkl 360.0)))
	
	(setq v_wnkl_at (Connect.get CastaData trg_vwinkel))
	
	(print VWnkl)
	(print sys_l)
	;; ...................................  Orientierung ermitteln
	(setq UZ_HWinkel   (connect.get CastaData Trg_HWinkel)
	      Stz_RotaWnkl (Traeger.get Htrg  R_Winkel)
	      Stz_RotaWnkl (- 360.0 Stz_RotaWnkl)
	      Stz_RotaWnkl (- Stz_RotaWnkl 90.0)
	)
	(if (< Stz_RotaWnkl 0.0) (setq Stz_RotaWnkl (+ Stz_RotaWnkl 360.0)))
        (setq diffWinkel (- UZ_HWinkel Stz_RotaWnkl))
        
        (if (= diffWinkel -180.0) (setq dV (- dV)))
        (if (= diffWinkel  180.0) (setq dV (- dV)))
	;; ...................................  Orientierung bercksichtigt


	(setq cosAlfa (cos (/ (* PI VWnkl_trg) 180.0)))
	
	(if (/= cosAlfa 0.0) (setq dV (/ dV cosAlfa)))

	
  (setq xPos 0)
        
        
	

	(setq	xPos_H  (* (tan (/ (* VWnkl_trg PI) 180.0)) (* 0.5 hStz)))
	(setq	xPos_dp (* (tan (/ (* VWnkl_trg PI) 180.0)) dp))

	(setq VWnkl_1 (Connect.get CastaData afl_VWinkel))
	(setq VWnkl_1 (- VWnkl_1 90.0))

	(if (= (Connect.get CastaData rechtesEnde) 1) (if (= (Connect.get CastaData amHtOberflansch) 1) (setq dvStz (- dvStz))))
	(if (= (Connect.get CastaData linkesEnde)  1) (if (= (Connect.get CastaData amHtUnterflansch) 1) (setq dvStz (- dvStz))))

	(if (> v_wnkl_at 255.0) (if (< v_wnkl_at 285.0) (setq dvStz (- dvStz))))


	(setq	cosW_trg (cos (/ (* PI VWnkl_1) 180.0))
		tanW_trg (tan (/ (* PI VWnkl_1) 180.0))
	)

	(print cosW_trg)
	(print tanW_trg)
	
;	(setq cosW_trg (- cosW_trg))
		
	; ANSCHLUSS AN DEN ENDEN
	; ----------------------
	(if (= (Connect.get CastaData anschlzwHtEnden) 0)
		(progn
			(if (> v_wnkl_at 75.0)
				(progn
					(if (< v_wnkl_at 105.0)
						(progn
							(if (= (Connect.get CastaData anHtLinkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData satr-shtr) 1)
										(progn
											(setq xPosUnten (+ xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))			;OK
											(setq xPosOben  (- xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))	;OK
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(setq xPosUnten (+ xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))	;OK
											(setq xPosOben  (- xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))			;OK
										)
									)
								)
							)
							(if (= (Connect.get CastaData anHtRechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData satr-shtr) 1)
										(progn
											(setq xPosUnten (- sys_l (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))	;OK
					    						(setq xPosOben  (+ sys_l (/ (- (* 0.5 hstz) (* 0.5 dp))		cosW_trg) (/ dvStz cosW_trg))) 			;OK
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(setq xPosUnten (- sys_l (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))			;OK
					    						(setq xPosOben  (+ sys_l (/ (- (* 0.5 hstz) (* 0.5 dp))		cosW_trg) (- (/ dvStz cosW_trg)))) 	;OK
										)
									)
								)
							)
						)
					)
				)
			)
			(if (> v_wnkl_at 225.0)
				(progn
					(if (< v_wnkl_at 285.0)
						(progn
							(if (= (Connect.get CastaData anHtLinkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData satr-shtr) 1)
										(progn
											(setq xPosUnten (+ xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))
											(setq xPosOben  (- xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(setq xPosUnten (+ xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))
											(setq xPosOben  (- xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))
										)
									)
								)
							)
							(if (= (Connect.get CastaData anHtRechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData satr-shtr) 1)
										(progn
											(setq xPosUnten (- sys_l (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))
					    						(setq xPosOben  (+ sys_l (/ (- (* 0.5 hstz) (* 0.5 dp))		cosW_trg) (- (/ dvStz cosW_trg)))) 
										)
									)
									(if (= (Connect.get CastaData satr-shtr) -1)
										(progn
											(setq xPosUnten (- sys_l (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))
					    						(setq xPosOben  (+ sys_l (/ (- (* 0.5 hstz) (* 0.5 dp))		cosW_trg) (/ dvStz cosW_trg))) 
										)
									)
								)
							)
						)
					)
				)
			)	
			
		)
	)
	
	; ANSCHLUSS ZWISCHEN DEN ENDEN
	; ----------------------------
	(if (= (Connect.get CastaData anschlzwhtenden) 1)
		(progn
			(setq xPos (Connect.get CastaData xPos_ht))
			
			(if (= at_is_stz 1)
				(progn
					(setq	h_at 		(Traeger.get Tr_ID h)
						t_at		(Traeger.get Tr_ID t)
						delta_v_at	(Traeger.get Tr_ID delta_v)
					)
					
					(if (= (Connect.get CastaData amHtOberflansch) 1)
					    (setq delta_v_at (- delta_v_at))
					)
					
					
					(setq vwinkel_ht	(Connect.get CastaData hpttrg_vwinkel))
					(setq cosWHT (cos (/ (* PI vwinkel_ht) 180.0)))
					
					(setq xPosKorr (/ (* 0.5 (- h_at t_at)) cosWHT))
					
					(setq xPosUnten (+ xPos xPosKorr))
					(setq xPosOben	(- xPos xPosKorr))
							
					(if (= (Connect.get CastaData rechtesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-shtr) 1)
								(progn
									(setq xPosUnten (+ xPosUnten delta_v_at))
									(setq xPosOben	(+ xPosOben delta_v_at))
								)
							)
							(if (= (Connect.get CastaData satr-shtr) -1)
								(progn
									(setq xPosUnten (- xPosUnten delta_v_at))
									(setq xPosOben	(- xPosOben delta_v_at))
								)
							)
						)
					)
					(if (= (Connect.get CastaData linkesEnde) 1)
						(progn
							(if (= (Connect.get CastaData satr-shtr) 1)
								(progn
									(setq xPosUnten (- xPosUnten delta_v_at))
									(setq xPosOben	(- xPosOben delta_v_at))
								)
							)
							(if (= (Connect.get CastaData satr-shtr) -1)
								(progn
									(setq xPosUnten (+ xPosUnten delta_v_at))
									(setq xPosOben	(+ xPosOben delta_v_at))
								)
							)
						)
					)	
				)
			)
		)
	)
	; ANSCHLUSS ZWISCHEN DEN ENDEN
	; ----------------------------
	; ENDE
	
	; Anteil aus HT-delta_v
	(setq tanTrg (tan (/ (* PI VWnkl) 180.0)))
	(setq anteil_delta_v (* dV tanTrg))

   ; (AF) Sept 2009 - ergnzt
   (if (= (Connect.get CastaData rechtesEnde) 1) (if (= (Connect.get CastaData amHtOberflansch) 1) (setq anteil_delta_v (- anteil_delta_v))))
   (if (= (Connect.get CastaData linkesEnde)  1) (if (= (Connect.get CastaData amHtUnterflansch) 1) (setq anteil_delta_v (- anteil_delta_v))))
   (if (> v_wnkl_at 255.0) (if (< v_wnkl_at 285.0) (setq anteil_delta_v (- anteil_delta_v))))
;	(setq anteil_delta_v (- anteil_delta_v))
	
	(setq xPosOben (- xPosOben anteil_delta_v))
	(setq xPosUnten (- xPosUnten anteil_delta_v))
	
	
	
	
	(print VWnkl_trg)
	(print xPosOben)
	(print xPosUnten)
	
	(setq bp (/ (- bProf sProf) 2))
	(setq qType (Traeger.get HTrg QsForm))
	(if (= qType "U") (setq bp (* bp 2)))
	
	; Sept 2009 - neue Berechnung VWnkl, da fr den Fall am Oberflansch
	; ansonsten keine eindeutige Lsung existierte (AF)
	(setq VWnkl (Connect.get CastaData afl_VWinkel))
	(setq VWnkl (- VWnkl 90.0))
	(if (= (Connect.get CastaData amHtOberflansch) 1)	(setq VWnkl (- VWnkl)))
	
	
	; Auf Steifen am HT prfen
	(checkForSteifeAtPosition xPosOben 60 Htrg)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosOben 60 Htrg)
	)
	
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeOben (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeOben)
			(Blech.set blSteifeOben (dp dp) 
						(hp hprof) 
						(bp bp) 
			)
			(traeger.addabtl Htrg blSteifeOben 0.0 0.0 _vollsteife_beids_)
			(setq AbtlSteife_1 (traeger.get Htrg ABTeil blSteifeOben))

			(Anbauteil.set  AbtlSteife_1 	(xpos xPosOben) 
							(winkel (- VWnkl))
			)
		)
	)
	
	(checkForSteifeAtPosition xPosUnten 60 Htrg)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosUnten 60 Htrg)
	)
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeUnten (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeUnten)
			(Blech.set blSteifeUnten 	(dp dp) 
							(hp hprof) 
							(bp bp) 
			)
			(traeger.addabtl Htrg blSteifeUnten 0.0 0.0 _vollsteife_beids_)
			(setq AbtlSteife_2 (traeger.get Htrg ABTeil blSteifeUnten))
			(Anbauteil.set  AbtlSteife_2 	(xpos   xPosUnten) 
							(winkel (- VWnkl))
			)
		)
	)
	

	;(Anbauteil.set  AbtlSteife_1 (xpos xPosOben))
	
	;(if (/= VWnkl 0.0) (progn
	 ;   (print "*** Anbauteil setze Winkel: ") (print VWnkl)
	  ;  (if (= (connect.get CastaData amHtUnterFlansch) 1) (progn
	   ;     (print "****** amHtUnterFlansch ") (print VWnkl)
	    ;    (Anbauteil.set  AbtlSteife_1 (Winkel (- VWnkl)))
	     ;   (Anbauteil.set  AbtlSteife_2 (Winkel (- VWnkl)))
	    ;))
	    ;(if (= (connect.get CastaData amHtOberFlansch) 1) (progn
	    ;    (print "****** amHtOberFlansch ") (print VWnkl)
	    ;    (Anbauteil.set  AbtlSteife_1 (Winkel VWnkl))
	     ;   (Anbauteil.set  AbtlSteife_2 (Winkel VWnkl))
	    ;))
	    ;(if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
	    ;    (print "****** anHtRechtesEnde ") (print VWnkl)
            ;    (setq xPosOben  (- xPosOben  xPos_H))
	;(Anbauteil.set  AbtlSteife_1 (xpos xPosOben))
	;	(Anbauteil.set  AbtlSteife_2 (xpos xPosUnten))
	 ;   ))
	;))

	(Traeger.updvollstf Htrg)
)

; ------------------------------------------------------------------
; Berechnet die Daten des Lochbildes
; ------------------------------------------------------------------
(defun calcAndSetLochbilddaten (Lchb_ID BlechID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(Guete   "4.6")
		(e       "60 60 0 0 0 0")
		(w       "80  0")
	)
	
	; allg. Daten holen
	(setq h_trg (Traeger.get Tr_ID h)
				s_trg (Traeger.get Tr_ID s)
				t_trg (Traeger.get Tr_ID t)
				r_trg (Traeger.get Tr_ID r)
	)
	
	(setq t_htrg 	(Traeger.get Htrg t)
				s_htrg	(Traeger.get Htrg s)
				r_htrg	(Traeger.get Htrg r)
				b_htrg	(Traeger.get Htrg b)
	)
	
	(setq akt_hp 		(Blech.get BlechID hp)
				akt_bp		(Blech.get BlechID bp)
				akt_dok		(Blech.get BlechID dok)
				dp_blech	(Blech.get BlechID dp)
	)
	
	(if (= (Connect.get CastaData LinkesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData RechtesEnde) 1)
		(setq AtEnde (Traeger.get Tr_ID rechts))
	)
	
	(setq h_scherl_at (TrEnde.get AtEnde vscherl)
				v_winkel_at	(TrEnde.get AtEnde v_winkel)
	)
	(print v_winkel_at)
	
	(if (> v_winkel_at 90.0)
		(setq v_winkel_at (- 180 v_winkel_at))
	)
	(print v_winkel_at)
	
	(setq tanV_stz (tan (/ (* PI v_winkel_at) 180.0)))
	(setq sinV_stz (sin (/ (* PI v_winkel_at) 180.0)))
	(print tanV_stz)
	(print sinV_stz)
	
	
	; Schraube anhand der Trgerhhe auswhlen
	(if (< h_trg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	(Lochbild.set Lchb_ID	(S_Bez 		S_Bez)
				(klemml 	(+ t_htrg dp_blech))
	)
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	; min. Rand- und Lochabstnde (default-Werte)
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	; min. Blechhhe aus Lochbild fr zwei Schraubenlagen
	(setq min_hp (+ e1_blech_rund (* e_blech_rund 2.0))) 
	
	
	(setq anteil_e0_aus_neigung (/ dp_blech tanV_stz))
	(print anteil_e0_aus_neigung)
	
    (if (= 1 1) (progn
	; e0 so berechnen, dass die Schraube eingefhrt werden kann
	; ------------------------------------------------------------------
	(setq schr_l (Lochbild.get Lchb_ID laenge))
	(print schr_l)
	
	(setq min_einbau (/ schr_l tanV_stz))
	(print min_einbau)
	
	(setq anteil_stz_flansch (/ t_trg sinV_stz))
	(print anteil_stz_flansch)
	
	(setq anteil_aus_dschr (runde d_schr auf 10))
	(print anteil_aus_dschr)
	
	(setq e0_fuer_einbau (+ anteil_e0_aus_neigung anteil_stz_flansch min_einbau anteil_aus_dschr))
	(print e0_fuer_einbau)
	
	(setq default_e0 (+ (* h_scherl_at 0.25) anteil_e0_aus_neigung))
	(print default_e0)
	
	(setq e0_gew 0)
	
	; Prfen, welches e0 benutzt werden soll
	(if (>= e0_fuer_einbau default_e0)
		(setq e0_gew e0_fuer_einbau)
		(setq e0_gew default_e0)
	)
	
	(print akt_hp)
	(setq e1_gew (- akt_hp (* 2.0 e0_gew))) 
	(print e1_gew)
    ))
	
	(if (< e1_gew e1_blech_rund)
		(progn
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq e0_gew (+ (* h_scherl_at 0.5) anteil_e0_aus_neigung))
			(setq e1_gew 0)
		)
	)
	
	
	
	
	(print akt_hp)
	; entscheiden, ob eine oder zwei Schraubenlagen eingefgt werden
	(if (> akt_hp min_hp)
		(progn
			(setq e0 e0_gew)
			(setq e0rund (runde e0 ab 5))
			(setq e1 e1_gew)
			(setq e1rund (runde e1 auf 5))
			(print e0)
			(print e0rund)
			(print e1rund)
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 e1rund)
			)
		)
		(progn
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq e0 e0_gew)
			(setq e0rund (runde e0 auf 5))
			
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0)
			)
		)		
	)
	
	;(Lochbild.set Lchb_ID (e0 1.0))
	
	
	;(setq abst_e_aus_at (+ (* r_htrg 2.0) s_htrg d_schr))
	(setq abst_e_aus_ht (+ (* 0.5 b_htrg) r_htrg (* 0.5 s_htrg)))
	
	(if (>= e1_blech_rund abst_e_aus_ht)
		(setq w0 e1_blech_rund)
		(setq w0 abst_e_aus_ht)
	)
	(setq w0rund (runde w0 auf 5))
	
	(print e1_blech_rund)
	(print dp_blech)
	(Lochbild.set Lchb_ID	
				(w0 			w0rund)
				;(klemml 	(+ t_htrg dp_blech))
				(dxSKopf  dp_blech)
	)
		
	(if (= LB_DEBUG 1)	(Lochbild.set Lchb_ID (e2 400.0)))
		
	;(setq min_bp_blech (* 2 w0rund))
	
	;(if (< akt_bp min_bp_blech)
	;	(Blech.set BlechID (bp min_bp_blech))
	;)
	(print "<-----------------------------------------------------------")
)




(defun	createFlanschLochb (Lchb_ID Blech_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGT FLANSCHLOCHBILD")
	(setq 	h_trg 		(Traeger.get Tr_ID h)
		delta_v_at	(Traeger.get Tr_ID delta_v)
		rwinkel_stz	(Traeger.get Tr_ID r_winkel)
	)
	
	(setq 	sysl 		(Traeger.get Htrg syslng)
		h_htrg		(Traeger.get Htrg h)
		delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq dp_blech		(Blech.get Blech_ID dp))
	(print dp_blech)
	
	; Art des Flanschlochbildes
	(if (= (Connect.get CastaData amHtOberflansch) 1)
		(setq flansch _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amHtUnterflansch) 1)
		(setq flansch _flanschlochbild_uf_)
	)
	
	(if (= (Connect.get CastaData anschlzwhtenden) 0)
		(progn
			; HT-Ende bestimmen
			(if (= (Connect.get CastaData anHtlinkesEnde) 1)
				(setq HtEnde (Traeger.get Htrg links))
			)
			(if (= (Connect.get CastaData anHtrechtesEnde) 1)
				(setq HtEnde (Traeger.get Htrg rechts))
			)
			
			; AT-Ende bestimmen
			(if (= (Connect.get CastaData linkesEnde) 1)
				(setq TrgEnde (Traeger.get Tr_ID links))
			)
			(if (= (Connect.get CastaData rechtesEnde) 1)
				(setq TrgEnde (Traeger.get Tr_ID rechts))
			)
			
			; HT-ENDE Daten
			(setq v_scherl_ht (TrEnde.get HtEnde vscherl)
						v_winkel_ht	(TrEnde.get HtEnde v_winkel)
			)
			
			; AT-ENDE Daten
			(setq v_scherl_at (TrEnde.get TrgEnde vscherl) 
						v_winkel_at	(TrEnde.get TrgEnde v_winkel)
			)
		)
	)
	
	

	(calcFlanschLochbild Lchb_ID Blech_ID)


	
	
	(if (= (connect.get CastaData LinkesEnde) 1) (progn
		(print "LINKS")
		(traeger.addabtl Tr_ID blKpl 0.0 0.0 _kopfplattelinks_)
		(traeger.addabtl Tr_ID lochb 0.0 0.0 _kpllochbildlinks_)
	))
	(if (= (connect.get CastaData RechtesEnde) 1) (progn
		(print "RECHTS")
		(traeger.addabtl Tr_ID blKpl 0.0 0.0 _kopfplatterechts_)
		(traeger.addabtl Tr_ID lochb 0.0 0.0 _kpllochbildrechts_)
	))
	
	(setq abtl_lb_ht (Traeger.get Htrg Abteil Lchb_ID))
	(setq abtl_lb_at (Traeger.get Tr_ID Abteil Lchb_ID))
			
	;(if (= (Connect.get CastaData amAtUnterflansch) 1)
	;	(Anbauteil.set abtl_lb_at (switch_on _unterflansch_))
	;)		
			
	; delta_lr Verschiebung 
	; --------------------------
	(setq delta_lr_abtl_at 0.0)
	(setq delta_lr_ht (* 1.0 delta_lr_ht))
	(setq delta_lr_at (* 1.0 delta_lr_at))
	
	; Anteil der horizontalen Neigung an delta_lr
	; ---------------------------------------------
	(setq	h_uz 		(Traeger.get Htrg h)
				r_winkel_uz	(Traeger.get Htrg r_winkel)
				dv_uz		(Traeger.get Htrg Delta_V)
	)
	(setq h_uz_halb (* 0.5 h_uz))

	(setq cosW (cos (/ (* PI r_winkel_uz) 180.0)))
	(setq tanW (tan (/ (* PI r_winkel_uz) 180.0)))

	(setq  delta_lr_at (/ delta_lr_at cosW))
	(if (= (Connect.get CastaData satr-shtr)  -1)	(setq delta_lr_abtl_at (+ (- delta_lr_ht) (- delta_lr_at))))
	(if (= (Connect.get CastaData satr-shtr)   1)	(setq delta_lr_abtl_at (+ delta_lr_ht (- delta_lr_at))))
	
	

	(setq dp 0.0)													; dp spter bercksichtigen
	(setq anteil_uz (+ h_uz_halb  dp dv_uz))
	
	(setq anteil_neigung (* anteil_uz tanW))
	
	; (setq delta_lr_abtl_at (/  delta_lr_abtl_at cosW))
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_at (+ delta_lr_abtl_at anteil_neigung)))
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_at (- delta_lr_abtl_at anteil_neigung)))
	
	; Vorzeichen gewechselt - Juli 2018
	(setq  delta_lr_abtl_at (- delta_lr_abtl_at))
	
	(Anbauteil.set abtl_lb_ht 	(Master 1))
	(Anbauteil.set abtl_lb_at	(Master 0)
					(delta_lr delta_lr_abtl_at)
	)
	
	(if (= LB_DEBUG 1)
		(progn
			; TEST
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy Lchb_ID)
			
			(if (= (connect.get CastaData LinkesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (connect.get CastaData RechtesEnde) 1) (traeger.addabtl Tr_ID lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq abtl_lb_at_dummy (Traeger.get Tr_ID Abteil lbdummy))
			(Anbauteil.set abtl_lb_at_dummy (Master 1)
																			(delta_lr delta_lr_abtl_at)
			)
			; TESTENDE
		)
	)
	
	(print "ENDE FLANSCHLOCHBILD")
	(print "------------------------------------------------------------")
)





(defun calcFlanschLochbild (Lchb_ID Blech_ID)
	(setq xPos_HT (Connect.get CastaData xPos_ht))
	(print xPos_HT)
			
	(setq	e0 	(Lochbild.get Lchb_ID e0)
		e1	(Lochbild.get Lchb_ID e1)
	)
	(print e0)
	(print e1)
			
			
			
(if (= 1 2)	(progn		
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn		
					(setq xPos_HT (- xPos_HT e0))
					(setq xPos_HT (- xPos_HT (* 0.5 e1)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn		
					(setq xPos_HT (- xPos_HT e0))
					(setq xPos_HT (- xPos_HT (* 0.5 e1)))
				)
			)
		)
	)		
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)
				(progn		
					(setq xPos_HT (+ xPos_HT e0))
					(setq xPos_HT (+ xPos_HT (* 0.5 e1)))
				)
			)
			(if (= (Connect.get CastaData satr-shtr) -1)
				(progn		
					(setq xPos_HT (+ xPos_HT e0))
					(setq xPos_HT (+ xPos_HT (* 0.5 e1)))
				)
			)
		)
	)		
))

   (if (= 1 1)	(progn			
	; Anteil Neigung HT		
	(setq v_wnkl_ht (Connect.get CastaData hpttrg_vwinkel))
	(print v_wnkl_ht)
					

	(setq v_wnkl_ht (Connect.get CastaData afl_VWinkel))
	(setq v_wnkl_ht (- v_wnkl_ht 90.0))
;	(if (= (Connect.get CastaData amHtUnterflansch) 1)	(setq v_wnkl_ht (- v_wnkl_ht)))
					
	(setq tanVW	(tan (/ (* PI v_wnkl_ht) 180.0)))
	(print tanVW)

					
	(if (= (Connect.get CastaData amHtUnterflansch) 1) (progn
		(setq anteil_ht_neigung (* (+ (* 0.5 h_htrg) delta_v_ht) tanVW))
;		(setq xPos_HT (- xPos_HT anteil_ht_neigung))
	))
	(if (= (Connect.get CastaData amHtOberflansch) 1)  (progn
		(setq anteil_ht_neigung (* (- (* 0.5 h_htrg) delta_v_ht) tanVW))
;		(setq xPos_HT (+ xPos_HT anteil_ht_neigung))
	))
	(print anteil_ht_neigung)
	(print xPos_HT)		
   ))
			
   (if (= 1 1)	(progn		
	; Anteil Schrge des AT
	(setq vscherl_stz (TrEnde.get TrgEnde vscherl))
	(setq vscherl_stz_halb (* 0.5 vscherl_stz))
			
	; Sept 2009 (AF) neu eingefgt, damit auch Anschlsse am Unterflansch klappen
	(setq VATr-LHTr (Connect.get CastaData vatr-lhtr))
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq xPos_HT (- xPos_HT  vscherl_stz_halb anteil_ht_neigung)))
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq xPos_HT (- xPos_HT  (- vscherl_stz_halb) anteil_ht_neigung)))

   ))
	
    (if (= 1 2)	(progn			
	; Anteil der Kopfplatte
	(setq v_wnkl_ht (Connect.get CastaData hpttrg_vwinkel))
	(print v_wnkl_ht)
					
	(setq tanVW	(tan (/ (* PI v_wnkl_ht) 180.0)))
	(print tanVW)
	
	(setq anteil_kpl (* dp_blech tanVW))
	(print anteil_kpl)
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_HT (- xPos_HT anteil_kpl)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_HT (- xPos_HT anteil_kpl)))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_HT (+ xPos_HT anteil_kpl)))
			(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_HT (+ xPos_HT anteil_kpl)))
		)
	)
    ))

    (if (= 1 1)	(progn		
	; Anteil delta_V AT
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (print "rechtesEnde satr-shtr =  1"))
			(if (= (Connect.get CastaData satr-shtr) -1) (print "rechtesEnde satr-shtr = -1"))
		)
	)
	(if (= (Connect.get CastaData linkesEnde) 1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (print "linkesEnde satr-shtr =  1"))
			(if (= (Connect.get CastaData satr-shtr) -1) (print "linkesEnde satr-shtr = -1"))
		)
	)

;	(Connect.showAttributes CastaData)

	(print delta_v_at)
	(print xPos_HT)

;	(if (= (Connect.get CastaData rechtesEnde) 1)
;		(progn
;			(if (= (Connect.get CastaData satr-shtr) 1)
;				(setq xPos_HT (+ xPos_HT delta_v_at))
;			)
;			(if (= (Connect.get CastaData satr-shtr) -1)
;				(setq xPos_HT (- xPos_HT delta_v_at))
;			)
;		)
;	)
;	(if (= (Connect.get CastaData linkesEnde) 1)
;		(progn
;			(if (= (Connect.get CastaData satr-shtr) 1)
;				(setq xPos_HT (- xPos_HT delta_v_at))
;			)
;			(if (= (Connect.get CastaData satr-shtr) -1)
;				(setq xPos_HT (+ xPos_HT delta_v_at))
;			)
;		)
;	)
	
	(setq AFlWinkel (Connect.get CastaData AFl_vWinkel))
	(setq cos_aflW (cos (* PI (/ (- AFlWinkel 90.0) 180.0))))
	(setq dvAnteil delta_v_at)
	(if (/= cos_aflW 0.0) (setq dvAnteil (/ dvAnteil cos_aflW)))
	
	(print ".")
	(print delta_v_at)
	(print dvAnteil)
	(print ".")
	
	(if (= (Connect.get CastaData vatr-lhtr)  1) (setq xPos_HT (+ xPos_HT dvAnteil)))
	(if (= (Connect.get CastaData vatr-lhtr) -1) (setq xPos_HT (- xPos_HT dvAnteil)))

	(print "nach Einfluss aus dv des AT ...")
	(print xPos_HT)
    ))										

					
	; Winkel Anbauteil
	(if (= (Connect.get CastaData vatr-lhtr)  1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq abtl_winkel   0.0))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq abtl_winkel   0.0))
		)
	)
	(if (= (Connect.get CastaData vatr-lhtr) -1)
		(progn
			(if (= (Connect.get CastaData satr-shtr)  1) (setq abtl_winkel 180.0))
			(if (= (Connect.get CastaData satr-shtr) -1) (setq abtl_winkel 180.0))
		)
	)		
	(traeger.addabtl Htrg Lchb_ID xPos_HT abtl_winkel flansch)
)




(defun calcAnEnden (Lchb_ID Blech_ID)
	(setq v_wnkl_ht (Connect.get CastaData hpttrg_vwinkel))
			(setq v_wnkl_at (Connect.get CastaData trg_vwinkel))
			
			(setq tanVW	(tan (/ (* PI v_wnkl_ht) 180.0)))
			(setq cosVW	(cos (/ (* PI v_wnkl_ht) 180.0)))
			
						
			
			
			; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			; XPOS ANBAUTEIL AM AT
			; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			(setq xPos_HT (Connect.get CastaData xPos_ht))
			
			; Neigung
			; -----------------
			(setq abst_syslAT_efp_lb (* 0.5 v_scherl_at))
			(print abst_syslAT_efp_lb)
			
			(print v_winkel_at)
								
			(setq v_endwinkel_ht (- 180.0 v_winkel_ht))
			
			
			(setq tanVW_at (tan (/ (* PI v_endwinkel_ht) 180.0)))
			(print tanVW_at)
			(if (= (Connect.get CastaData anHtlinkesEnde) 1)
				(progn
					(if (< tanVW_at 0.0)
						(setq tanVW_at (- tanVW_at))
					)
				)
			)
			
			(setq delta_xPos_aus_neigung_ht (/ (* 0.5 h_htrg) tanVW_at))
			(print delta_xPos_aus_neigung_ht)
			
			(setq diff_efp_ht_at (- abst_syslAT_efp_lb delta_xPos_aus_neigung_ht))
			(print diff_efp_ht_at)
			
			(if (= (Connect.get CastaData anHtlinkesEnde) 1)
				(setq xPos_HT (+ xPos_HT diff_efp_ht_at))
			)
			(if (= (Connect.get CastaData anHtrechtesEnde) 1)
				(setq xPos_HT (- xPos_HT diff_efp_ht_at))
			)
			
			; Einfluss delta_v Verschiebung AT
			; ---------------------------------
			(setq anteil_delta_v (/ delta_v_at cosVW))
			(print anteil_delta_v)
			
			; Sttze von unten nach oben (pos. z-Richtung)
			(if (> v_wnkl_at 75.0)
				(progn
					(if (< v_wnkl_at 105.0)
						(progn
							(if (= (Connect.get CastaData anHtlinkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_HT (+ xPos_HT anteil_delta_v)))	;OK
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_HT (- xPos_HT anteil_delta_v)))	;OK
								)
							)
							(if (= (Connect.get CastaData anHtrechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_HT (+ xPos_HT anteil_delta_v)))	;OK
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_HT (- xPos_HT anteil_delta_v)))	;OK
								)
							)
						)
					)
				)
			)
			
			; Sttze von oben nach unten (neg. z-Richtung)
			(if (> v_wnkl_at 225.0)
				(progn
					(if (< v_wnkl_at 285.0)
						(progn
							(if (= (Connect.get CastaData anHtlinkesEnde) 1)
								(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_HT (- xPos_HT anteil_delta_v)))
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_HT (+ xPos_HT anteil_delta_v)))
								)
							)
							(if (= (Connect.get CastaData anHtrechtesEnde) 1)
								(progn
									(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_HT (- xPos_HT anteil_delta_v)))
									(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_HT (+ xPos_HT anteil_delta_v)))
								)
							)
						)
					)
				)
			)
			
			; Einfluss delta_v Verschiebung AT
			; ---------------------------------
			(setq anteil_ht_delta (* delta_v_ht tanVW))
			(print anteil_ht_delta)
			
			(setq xPos_HT (- xPos_HT anteil_ht_delta))
			
			
			; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			; WINKEL ANBAUTEIL
			; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			(if (= (Connect.get CastaData anHtlinkesEnde) 1)	(setq abtl_winkel 180.0))
			(if (= (Connect.get CastaData anHtrechtesEnde) 1)	(setq abtl_winkel   0.0))
				
			
			(traeger.addabtl Htrg Lchb_ID xPos_HT abtl_winkel flansch)
)

(defun anpassen_an_HT_QR_RR ()

   (setq h_AT (Traeger.get Tr_ID h))

	(setq		dOK_Kpl (Blech.get  blKpl dOK)
					hp_Kpl    (Blech.get  blKpl hp)
	)
	(setq  dOK_Kpl (- dOK_Kpl (* 0.25 h_AT)))
	(setq  hp_Kpl (+ hp_Kpl (* 0.5 h_AT)))
	(Blech.set blKpl (dOK dOK_Kpl) (hp hp_Kpl))
	
	(setq  sd (Lochbild.get lochb sDurchm))
	
	(setq	e0 (+ dOK_Kpl (* 2 sd))
				e1  (- hp_Kpl (* 4 sd))
	)
	(Lochbild.set lochb (e0 e0) (e1 e1))
	
	(if  (= (Connect.get CastaData anschlzwhtenden) 0) (progn
		(if (= (Connect.get CastaData anhtlinkesende) 1) (progn
			(setq TrgEnde (Traeger.get HTrg links))
			(setq dl (TrEnde.get  TrgEnde delta_L ))
			(setq dl (- dl  (* 0.25 h_AT)))
			(TrEnde.set TrgEnde (Delta_L dl))
		))
		(if (= (Connect.get CastaData anhtrechtesende ) 1) (progn
			(setq TrgEnde (Traeger.get HTrg rechts))
			(setq dl (TrEnde.get  TrgEnde delta_L ))
			(setq dl (- dl  (* 0.25 h_AT)))
			(TrEnde.set TrgEnde (Delta_L dl))
		))
	))

)

(defun  AT_Lochbild_dlr_aus_dp (Lchb_ID dp)
	(setq rWnkl (Connect.get CastaData r-atrgewnkl_kopf))
	
	(if (/= rWnkl 180.0) (progn
		(if (= dp 0) (setq dp (Blech.get  blKpl dp)))
		
		(setq dp (* 1.0 dp))
		(setq bl_Wnkl  0.0)
		(if (< rWnkl 180.0) (setq bl_Wnkl    rWnkl))
		(if (> rWnkl 180.0) (setq bl_Wnkl (- 180.0 rWnkl)))
	
		
		(setq tanW (tan (/ (* PI  bl_Wnkl) 180.0)))
		
		(setq dlr_Bl (* tanW dp))
		(print  dlr_Bl)
		(setq Abtl_Lchb_AT (Traeger.get Tr_ID ABTeil Lchb_ID))
		(setq dlr_Lchb (Anbauteil.get Abtl_Lchb_AT delta_LR))
		(print  dlr_Lchb)
		(setq  dlr_Lchb (+ dlr_Lchb dlr_Bl))
		(Anbauteil.set Abtl_Lchb_AT (delta_LR  dlr_Lchb))
	))

)
(defun blech_fine_tunen  (bl_Kopfplatte lb_KplLochbild)
	(setq abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  lb_KplLochbild))
	(setq dlr_Lchb_AT (Anbauteil.get  abtl_Lchb_AT delta_LR))
	(setq dlr_Lchb_AT (- dlr_Lchb_AT))
	
	(Blech.set  bl_Kopfplatte (delta_LR dlr_Lchb_AT))
)

(defun HalbBlech_fine_tunen  (bl_Kopfplatte lb_KplLochbild)
	(setq abtl_Lchb_HT (Traeger.get HTrg ABTeil  lb_KplLochbild))
	(setq abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  lb_KplLochbild))
	(setq dlr_Lchb_AT (Anbauteil.get  abtl_Lchb_AT delta_LR))
	(setq dlr_Lchb_AT (- dlr_Lchb_AT))

	(setq dlr_HT (Traeger.get HTrg  delta_LR))
	(setq dlr_AT (Traeger.get Tr_ID delta_LR))
	(setq b_HT (Traeger.get HTrg b))
	(setq b_AT (Traeger.get Tr_ID b))

	(if (= (Connect.get CastaData satr-shtr) -1) (progn
		(print  "satr-shtr -1")
		(setq dlr_Lchb_AT (+ (* -0.25 b_AT) (- dlr_HT)))
		(Lochbild.set lb_KplLochbild (LB_Art -2))
	))
	(if (= (Connect.get CastaData satr-shtr)  1) (progn
		(print "satr-shtr 1")
		(setq dlr_Lchb_AT (+ (* 0.25 b_AT)    dlr_HT))
		(Lochbild.set lb_KplLochbild (LB_Art 2))
	))
	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData amHtOberflansch) 1) (Anbauteil.set abtl_Lchb_HT (SeitRicht  -1)))
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (Anbauteil.set abtl_Lchb_HT (SeitRicht  1)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData amHtOberflansch) 1) (Anbauteil.set abtl_Lchb_HT (SeitRicht  1)))
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (Anbauteil.set abtl_Lchb_HT (SeitRicht -1)))
	))
	
;	(Lochbild.set lb_KplLochbild (e "50 30 70 0 0 0"))
	
	(setq bp_Neu (+ (* 0.5 b_AT) dlr_HT))
	(Blech.set  bl_Kopfplatte (delta_LR dlr_Lchb_AT) (bp bp_Neu))
)
(defun VollBlech_fine_tunen  (bl_Kopfplatte lb_KplLochbild)
	(setq abtl_Lchb_HT (Traeger.get HTrg ABTeil  lb_KplLochbild))
	(setq abtl_Lchb_AT (Traeger.get Tr_ID ABTeil  lb_KplLochbild))
	(setq dlr_Lchb_AT (Anbauteil.get  abtl_Lchb_AT delta_LR))
	(setq dlr_Lchb_AT (- dlr_Lchb_AT))

	(setq 	b_HT 	(Traeger.get HTrg b)
			dlr_HT	(Traeger.get HTrg delta_LR)
	)
	(setq b_AT (Traeger.get Tr_ID b))
	
	(Blech.set  bl_Kopfplatte 
		(bp (+ b_AT dlr_HT dlr_HT))						; msste noch genauer angepasst werden
		(delta_LR 0.0)
	)

	(if (= (Connect.get CastaData satr-shtr) -1) (progn
		(Lochbild.set lb_KplLochbild (LB_Art -2))
	))
	(if (= (Connect.get CastaData satr-shtr) 1) (progn
		(Lochbild.set lb_KplLochbild (LB_Art 2))
	))

	
	(if (= (Connect.get CastaData linkesEnde) 1) (progn
		(if (= (Connect.get CastaData amHtOberflansch) 1)  (Anbauteil.set abtl_Lchb_HT (SeitRicht -1)))
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (Anbauteil.set abtl_Lchb_HT (SeitRicht 1)))
	))
	(if (= (Connect.get CastaData rechtesEnde) 1) (progn
		(if (= (Connect.get CastaData amHtOberflansch) 1)  (Anbauteil.set abtl_Lchb_HT (SeitRicht  1)))
		(if (= (Connect.get CastaData amHtUnterflansch) 1) (Anbauteil.set abtl_Lchb_HT (SeitRicht -1)))
	))
	
;	(Lochbild.set lb_KplLochbild (e "50 50 100 0 0 0"))
	
)


(defun Funktion_Kann_weg ( )

  (if (= 1 2) (progn
    (setq abteil (Traeger.get Tr_ID ABTeil lochb))
    (if (= (Connect.get CastaData anHtRechtesEnde) 1)			; (anHtRechtesEnde) vorher
  	(progn
		(if (= (Connect.get CastaData amATUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
		(if (= (Connect.get CastaData amATOberflansch)  1)	(Anbauteil.set abteil (SeitRicht  1)))
	)
    )
    (if (= (Connect.get CastaData anHtLinkesEnde) 1)			; (anHtLinkesEnde vorher)
  	(progn
		(if (= (Connect.get CastaData amATUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
		(if (= (Connect.get CastaData amATOberflansch)  1)	(Anbauteil.set abteil (SeitRicht -1)))
	)
    )
   ))
				
   (if (= 1 2) (progn
     (setq abteil (Traeger.get HTrg ABTeil lochb))
     (if (= (Connect.get CastaData anHtRechtesEnde) 1)
  	(progn
		(if (= (Connect.get CastaData amATUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
		(if (= (Connect.get CastaData amATOberflansch)  1)	(Anbauteil.set abteil (SeitRicht -1)))
	)
     )
     (if (= (Connect.get CastaData anHtLinkesEnde) 1)
  	(progn
		(if (= (Connect.get CastaData amATUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
		(if (= (Connect.get CastaData amATOberflansch)  1)	(Anbauteil.set abteil (SeitRicht  1)))
	)
     )
   ))

   (if (= 1 2) (progn
	   (if (= (Connect.get CastaData amHTOberflansch)  1)	(progn
	     (setq abteil (Traeger.get Tr_ID ABTeil lochb))
	     (setq sRicht (Anbauteil.get abteil SeitRicht))
	     (Anbauteil.set abteil (SeitRicht  (- sRicht)))
	   ))
   ))
   (print "*clear*")
   (if (= 1 2) (progn
          (setq abteil_HT (Traeger.get HTrg  ABTeil lochb))
          (setq abteil_AT (Traeger.get Tr_ID ABTeil lochb))
          (if (= (Connect.get CastaData linkesEnde)  1)	(progn
              (print "Linkes Ende!")
	      (if (= (Connect.get CastaData sATr-sHTr) -1)	(Anbauteil.set abteil_AT (SeitRicht -1)))

	      (if (= (Connect.get CastaData amHtUnterFlansch)  1)	(progn
	           (if (= (Connect.get CastaData sATr-sHTr) -1)	(Anbauteil.set abteil_HT (SeitRicht -1)))
	      ))
	      (if (= (Connect.get CastaData amHtOberFlansch)  1)	(progn
	          (if (= (Connect.get CastaData sATr-sHTr)   1)	(Anbauteil.set abteil_HT (SeitRicht -1)))
	      ))
	  ))
          (if (= (Connect.get CastaData rechtesEnde)  1)	(progn
	      (if (= (Connect.get CastaData sATr-sHTr) -1)	(Anbauteil.set abteil_AT (SeitRicht -1)))

	      (if (= (Connect.get CastaData amHtUnterFlansch)  1)	(progn
	           (if (= (Connect.get CastaData sATr-sHTr)  1)	(Anbauteil.set abteil_HT (SeitRicht -1)))
	      ))
	      (if (= (Connect.get CastaData amHtOberFlansch)  1)	(progn
	          (if (= (Connect.get CastaData sATr-sHTr) -1)	(Anbauteil.set abteil_HT (SeitRicht -1)))
	      ))
	  ))
    ))
)

(defun Ausrichten_Lochbild_an_HT_AT ( )
	(print "Ausrichten_Lochbild_an_HT_AT")
    (if (= 3 3) (progn
        (setq abteil_HT (Traeger.get HTrg  ABTeil lochb))
        (setq abteil_AT (Traeger.get Tr_ID ABTeil lochb))
    	
		(Anbauteil.set abteil_AT (SeitRicht 0))
			(Anbauteil.set abteil_HT (SeitRicht 0))

		(if (= (Connect.get CastaData linkesEnde)   1)	(progn
		  (if (= (Connect.get CastaData sAtr-sHtr) -1)	(progn
			(if (= (Connect.get CastaData vAtr-lHtr) -1)	(progn
				(Anbauteil.set abteil_HT (SeitRicht -1))
			))
		  ))
		  (if (= (Connect.get CastaData sAtr-sHtr)    1)	(progn
			(if (= (Connect.get CastaData vAtr-lHtr)  1)	(progn
			  (if (= (Connect.get CastaData amHtOberFlansch)  1)	(progn
				(Anbauteil.set abteil_HT (SeitRicht -1))
			  ))
			))
		  ))
		))
		(if (= (Connect.get CastaData rechtesEnde)   1)	(progn
		  (if (= (Connect.get CastaData sAtr-sHtr)   1)	(progn
			(if (= (Connect.get CastaData vAtr-lHtr) 1)	(progn
				(print  "rechts - 1")
			  (Anbauteil.set abteil_HT (SeitRicht  -1))
			))
		  ))
		  (if (= (Connect.get CastaData sAtr-sHtr)   -1)	(progn
			(if (= (Connect.get CastaData vAtr-lHtr) -1)	(progn
				(print "rechts - 2")
			  (Anbauteil.set abteil_HT (SeitRicht -1))
			))
		  ))
		))

    ))
)
