(defun calcConnection ()

		; Anzeigen beider Lochbilder
		(setq LB_DEBUG 0)
		
    ;(init-traegerenden)
    
    (print "uz_auf_HtStzKopf: in init-connection")

    (connect.showattributes CastaData)

    (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
        (setq StzEnde (Traeger.get HTrg links))
    ))
    (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
        (setq StzEnde (Traeger.get HTrg rechts))
    ))

	(setq blKpl (blech.create))
    (setq lochb	(lochbild.create))
    (Connect.storeAnschlObjs CastaData blKpl lochb)
     
    (calcAndSetBlechdaten blKpl StzEnde)
    
    (calcAndSetLochbildDaten lochb blKpl)
    
    (createFlanschLochb lochb blKpl)

;   (Lochbild.set lochb (LB_Art   2))			; AF-20090511
;   (Lochbild.set lochb (delta_w 50))			; AF-20090511
;   (Lochbild.set lochb (e    "70 30 100 0 0 0"))	; AF-20090511
    (LochbildAusrichtung_am_HT)

	;Steifen am Anschlusstrger standardmig auf Flanschdicke des Haupttrgers
	(setq dp_aus_Flansch (Traeger.get Htrg t))
		
	(createSteifenAT dp_aus_Flansch)
 
)
; ====================================================================== 
(defun calcConnection_Multiple ()

		; Anzeigen beider Lochbilder
		(setq LB_DEBUG 0)
		
    ;(init-traegerenden)
    
    (print "uz_auf_HtStzKopf: in init-connection")

    (connect.showattributes CastaData)

    (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
        (setq StzEnde (Traeger.get HTrg links))
    ))
    (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
        (setq StzEnde (Traeger.get HTrg rechts))
    ))

	(setq blKpl (blech.create))
    (setq lochb	(lochbild.create))
    (Connect.storeAnschlObjs CastaData blKpl lochb)
     
    (calcAndSetBlechdaten blKpl StzEnde)
    
    (calcAndSetLochbildDaten lochb blKpl)
    
    (createFlanschLochb lochb blKpl)

;   (Lochbild.set lochb (LB_Art   2))			; AF-20090511
;   (Lochbild.set lochb (delta_w 50))			; AF-20090511
;   (Lochbild.set lochb (e    "70 30 100 0 0 0"))	; AF-20090511
    (LochbildAusrichtung_am_HT)

	;Steifen am Anschlusstrger standardmig auf Flanschdicke des Haupttrgers
	(setq dp_aus_Flansch (Traeger.get Htrg t))
		
	(createSteifenAT dp_aus_Flansch)
 
)


; ====================================================================== 
; Berechnet die Blechdaten der Kopfplatte des Haupttrgers
; ====================================================================== 
; ----------------------------------------------------------------------
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)

   (print "----------------------------- In calcAndSetBlechdaten")

  (setq hProf 			(Traeger.get Htrg h)
				t_ht				(Traeger.get Htrg t)
				b_ht				(Traeger.get Htrg b)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	(setq b_at				(Traeger.get Tr_ID b)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq t_ht_rund (runde t_ht auf 10))
	
	(setq hp hProf)		; erstmal so voreinstellen
  (setq bp 120)
  (setq dp  t_ht_rund)
  (setq dOK  5)

  (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
        							
	(setq sinW (sin (* PI (/ EWinkel 180.0))))
	(if (/= sinW 0) (setq hp (/ hp sinW)))

  (setq hp (- hp dOK 5))	; wir erzeugen eine bndige Kopfplatte
	
	(print b_at)
	(print b_ht)
	
	; Blechbreite
	(if (>= b_ht b_at)
		(setq bp b_at)
		(setq bp b_ht)
	)    
	
	; delta_lr
	(setq delta_lr_blech 0.0)
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_blech (- delta_lr_at delta_lr_ht)))
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_blech (- (- delta_lr_at) delta_lr_ht))) 
	
	
	 
	(Blech.set blKopfplatte (dp 			dp) 
													(hp 			hp) 
													(bp 			bp) 
													(dOK 			dOK)
													(delta_lr	delta_lr_blech)
	)

  (setq htDeltaV (Traeger.get hTrg delta_V))

  (setq delta_L dp)
  (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
    								(print delta_L)
  (TrEnde.pTrim TrgEnde dp)

	
)
; ====================================================================== 
; Berechnet und erzeugt die Steifen des Anschlusstrgers 
; ====================================================================== 
; ----------------------------------------------------------------------
(defun createSteifenAT (dp)
	(print "--------------- in createSteifenAT")
	(setq hProf    	(Traeger.get  Tr_Id h)
	      sProf    	(Traeger.get  Tr_Id s)
	      bProf    	(Traeger.get  Tr_ID b)
	      dV       	(Traeger.get  Tr_Id delta_V)
	      delta_l  	(Traeger.get  Tr_ID delta_l)
	      sys_l    	(Traeger.get  Tr_ID syslng)
	      hStz     	(Traeger.get  HTrg  h)
	      fStz     	(Traeger.get  HTrg  t)
	      dvStz    	(Traeger.get  HTrg  delta_V)
	      rWnkl_htrg	(Traeger.get HTrg r_winkel)
	      VWnkl    	(connect.get CastaData hpttrg_vwinkel)
	      VWnkl_trg (connect.get CastaData trg_vwinkel)
	)
	
	(print sys_l)
	(print VWnkl_trg)
	
	;; ...................................  Orientierung ermitteln
	(setq UZ_HWinkel   (connect.get CastaData HptTrg_HWinkel)
	      Stz_RotaWnkl (Traeger.get Tr_ID  R_Winkel)
	      Stz_RotaWnkl (- 360.0 Stz_RotaWnkl)
	      Stz_RotaWnkl (- Stz_RotaWnkl 90.0)
	)
	(if (< Stz_RotaWnkl 0.0) (setq Stz_RotaWnkl (+ Stz_RotaWnkl 360.0)))
        (setq diffWinkel (- UZ_HWinkel Stz_RotaWnkl))
        
        (if (= diffWinkel -180.0) (setq dV (- dV)))
        (if (= diffWinkel  180.0) (setq dV (- dV)))
	;; ...................................  Orientierung bercksichtigt


	(setq cosAlfa (cos (/ (* PI VWnkl) 180.0)))
	
	(if (/= cosAlfa 0.0) (setq dV (/ dV cosAlfa)))

	
 	(setq xPos 0)
       
  ; Orientierung der Sttze ermitteln
  (if (> VWnkl 75.0)
  	(progn
  		(if (< VWnkl 105.0)
  			(progn
  				(setq orientation 1) 	; von unten -> oben
  			)
  		)
  	)
  )
  (if (> VWnkl 225.0)
  	(progn
  		(if (< VWnkl 285.0)
  			(progn
  				(setq orientation 0)	; von oben -> unten
  			)
  		)
  	)
  )      
  ;<--------------------------

	(setq xPos_H  (* (tan (/ (* VWnkl PI) 180.0)) (* 0.5 hStz)))
	(setq xPos_dp (* (tan (/ (* VWnkl PI) 180.0)) dp))

	(setq cosW_trg (cos (/ (* PI VWnkl_trg) 180.0))
				tanW_trg (tan (/ (* PI VWnkl_trg) 180.0))
	)
	
	; ANSCHLUSS AN DEN ENDEN
	; ----------------------
	(if (= (Connect.get CastaData anschlzwatEnden) 0)
		(progn
			(if (> VWnkl_trg 180.0)
				(setq VWnkl_trg	(- 360.0 VWnkl_trg))
				(setq VWnkl_trg	(- VWnkl_trg))
			)
			
			(if (= (connect.get CastaData linkesende) 1)
			  (progn
			  	(print "AT LINKS")
			    (print dvstz)
			    ;(setq VWnkl_trg	(- 360.0 VWnkl_trg))
			    ;(setq VWnkl_trg	(- VWnkl_trg))
			    (if (= orientation 1)
			    	(progn
					    (if (= (Connect.get CastaData satr-shtr) 1)
					  		(progn
					    		(setq xPosUnten (+ xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))			;OK
					    		(setq xPosOben  (- xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg)))) ;OK
					  		)
					  	)
					  	(if (= (Connect.get CastaData satr-shtr) -1)
					  		(progn
					    		(setq xPosUnten (+ xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))	;OK
					    		(setq xPosOben  (- xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))			;OK
					  		)
					  	)
					  )
					)
					(if (= orientation 0)
			    	(progn
					    (if (= (Connect.get CastaData satr-shtr) 1)
					  		(progn
					    		(setq xPosUnten (+ xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))	;OK
					    		(setq xPosOben  (- xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg))) 		;OK
					  		)
					  	)
					  	(if (= (Connect.get CastaData satr-shtr) -1)
					  		(progn
					    		(setq xPosUnten (+ xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))			;OK
					    		(setq xPosOben  (- xPos (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))	;OK
					  		)
					  	)
					  )
					)
			    
			  )
			)
			
			(if (= (connect.get CastaData rechtesende) 1)
				(progn
					(print "AT RECHTS")
					;(setq VWnkl_trg	(- 360.0 VWnkl_trg))
					;(setq VWnkl_trg	(- VWnkl_trg))
					(if (= orientation 1)
			    	(progn
							(if (= (Connect.get CastaData satr-shtr) 1)
					  		(progn
					    		(setq xPosUnten (- sys_l (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))	;OK
					    		(setq xPosOben  (+ sys_l (/ (- (* 0.5 hstz) (* 0.5 dp))		cosW_trg) (/ dvStz cosW_trg))) 			;OK
					  		)
					  	)
					  	(if (= (Connect.get CastaData satr-shtr) -1)
					  		(progn
					    		(setq xPosUnten (- sys_l (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))			;OK
					    		(setq xPosOben  (+ sys_l (/ (- (* 0.5 hstz) (* 0.5 dp))		cosW_trg) (- (/ dvStz cosW_trg)))) 	;OK
					  		)
					  	)
					  )
					)
					(if (= orientation 0)
			    	(progn
							(if (= (Connect.get CastaData satr-shtr) 1)
					  		(progn
					    		(setq xPosUnten (- sys_l (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))			;OK
					    		(setq xPosOben  (+ sys_l (/ (- (* 0.5 hstz) (* 0.5 dp))		cosW_trg) (- (/ dvStz cosW_trg)))) 	;OK
					  		)
					  	)
					  	(if (= (Connect.get CastaData satr-shtr) -1)
					  		(progn
					    		(setq xPosUnten (- sys_l (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))	;OK
					    		(setq xPosOben  (+ sys_l (/ (- (* 0.5 hstz) (* 0.5 dp))		cosW_trg) (/ dvStz cosW_trg))) 			;OK
					  		)
					  	)
					  )
					)
			  )
			)
		)
	)
	
	
	; ANSCHLUSS ZWISCHEN DEN ENDEN
	; ----------------------------
	(if (= (Connect.get CastaData anschlzwatEnden) 1)
		(progn
			(setq xPos_at (Connect.get CastaData xPos_at))
			
			;(setq VWnkl_trg	(- VWnkl_trg))
			(if (> VWnkl_trg 180.0)
				(setq VWnkl_trg	(- 360.0 VWnkl_trg))
				(setq VWnkl_trg	(- VWnkl_trg))
			)
			
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-shtr) -1)
						(progn
							(setq xPosUnten (+ xPos_at (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))
							(setq xPosOben  (- xPos_at (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg)))) 
						)
					)
					(if (= (Connect.get CastaData satr-shtr)  1)
						(progn
							(setq xPosUnten (+ xPos_at (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg)))) 
							(setq xPosOben  (- xPos_at (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg))) 
						)
					)
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-shtr) -1)
						(progn
							(setq xPosUnten (+ xPos_at (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg)))) 
							(setq xPosOben  (- xPos_at (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))  
						)
					)
					(if (= (Connect.get CastaData satr-shtr)  1)
						(progn
							(setq xPosUnten (+ xPos_at (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (/ dvStz cosW_trg)))
							(setq xPosOben  (- xPos_at (/ (- (* 0.5 hstz) (* 0.5 fstz)) cosW_trg) (- (/ dvStz cosW_trg))))
						)
					)
				)
			)
		)
	)
	
	
	; Anteil aus AT-delta_v
	(setq tanTrg (tan (/ (* PI VWnkl_trg) 180.0)))
	(setq anteil_delta_v (* dV tanTrg))
	
	(setq xPosOben (+ xPosOben anteil_delta_v))
	(setq xPosUnten (+ xPosUnten anteil_delta_v))
	
	
	(setq bp (/ (- bProf sProf) 2))
	
	(if (= (Connect.get CastaData amATOberflansch) 1)
		(setq VWnkl_trg (- VWnkl_trg))
	)
	
	
	(print VWnkl_trg)
	
	(checkForSteifeAtPosition xPosOben 60 Tr_ID)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosOben 60 Tr_ID)
	)
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeOben (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeOben)
			(Blech.set blSteifeOben (dp dp) 
															(hp hprof) 
															(bp bp) 
			)
			(traeger.addabtl Tr_ID blSteifeOben 0.0 0.0 _vollsteife_beids_)
			(setq AbtlSteife_1 (traeger.get Tr_ID ABTeil blSteifeOben))
			(Anbauteil.set  AbtlSteife_1 	(xpos xPosOben) 
																		(winkel VWnkl_trg)
			)
		)
	)
	
	(checkForSteifeAtPosition xPosUnten 60 Tr_ID)
	(if (= ABTL_VORH 0)
		(checkForKplAtPosition xPosUnten 60 Tr_ID)
	)
	(if (= ABTL_VORH 0)
		(progn
			(setq blSteifeUnten (blech.create))
			(Connect.storeAnschlObjs CastaData blSteifeUnten)
			(Blech.set blSteifeUnten 	(dp dp) 
																(hp hprof) 
																(bp bp) 
			)
			(traeger.addabtl Tr_ID blSteifeUnten 0.0 0.0 _vollsteife_beids_)
			(setq AbtlSteife_2 (traeger.get Tr_ID ABTeil blSteifeUnten))
			(Anbauteil.set  AbtlSteife_2 	(xpos   xPosUnten) 
																		(winkel VWnkl_trg)
			)
		)
	)
	

	(Traeger.updvollstf Tr_ID)

)

; ------------------------------------------------------------------
; Berechnet die Daten des Lochbildes
; ------------------------------------------------------------------
(defun calcAndSetLochbilddaten (Lchb_ID BlechID)
	(print ">-----------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(Guete   "4.6")
		(e       "60 60 0 0 0 0")
		(w       "80  0")
	)
	
	(setq h_htrg (Traeger.get Htrg h)
				s_htrg (Traeger.get Htrg s)
				t_htrg (Traeger.get Htrg t)
	)
	
	(setq t_trg (Traeger.get Tr_ID t)
				s_trg	(Traeger.get Tr_ID s)
				r_trg	(Traeger.get Tr_ID r)
				b_trg	(Traeger.get Tr_ID b)
	)
	
	(setq akt_hp 		(Blech.get BlechID hp)
				akt_dok		(Blech.get BlechID dok)
				dp_blech	(Blech.get BlechID dp)
				akt_bp    (Blech.get BlechID bp)
	)
	
	(if (= (Connect.get CastaData anHtLinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtRechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	(setq h_scherl_ht (TrEnde.get HtEnde vscherl)
				v_winkel_ht	(TrEnde.get HtEnde v_winkel)
	)
	(print v_winkel_ht)
	
	
	
	(if (> v_winkel_ht 90.0)
		(setq v_winkel_ht (- 180 v_winkel_ht))
	)
	(print v_winkel_ht)
	
	(setq tanV_stz (tan (/ (* PI v_winkel_ht) 180.0)))
	(setq sinV_stz (sin (/ (* PI v_winkel_ht) 180.0)))
	(print tanV_stz)
	(print sinV_stz)
	
	; Schaube anhand der Trgerhhe auswhlen
	(if (< h_htrg 300)
		(setq S_Bez "M16")
		(setq S_Bez "M20")
	)
	
	(Lochbild.set Lchb_ID (S_Bez 		S_Bez)
												(klemml 	(+ t_trg dp_blech))
	)
	
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq min_hp (+ e1_blech_rund (* e_blech_rund 2.0))) 
	
		
	(setq anteil_e0_aus_neigung (/ dp_blech tanV_stz))
	(print anteil_e0_aus_neigung)
	
	(if (= 1 1) (progn
	; e0 so berechnen, dass die Schraube eingefhrt werden kann
	; ------------------------------------------------------------------
	(setq schr_l (Lochbild.get Lchb_ID laenge))
	(print schr_l)
	
	(setq min_einbau (/ schr_l tanV_stz))
	(print min_einbau)
	
	(setq anteil_stz_flansch (/ t_htrg sinV_stz))
	(print anteil_stz_flansch)
	
	(setq anteil_aus_dschr (runde d_schr auf 10))
	(print anteil_aus_dschr)
	
	
	(setq e0_fuer_einbau (+ anteil_e0_aus_neigung anteil_stz_flansch min_einbau anteil_aus_dschr))
	(print e0_fuer_einbau)
	
	(setq default_e0 (+ (* h_scherl_ht 0.25) anteil_e0_aus_neigung))
	(print default_e0)
	
	(setq e0_gew 0)
	
	; Prfen, welches e0 benutzt werden soll
	(if (>= e0_fuer_einbau default_e0)
		(setq e0_gew e0_fuer_einbau)
		(setq e0_gew default_e0)
	)
	
	(print akt_hp)
	(setq e1_gew (- akt_hp (* 2.0 e0_gew))) 
	(print e1_gew)
	))
	
	(if (< e1_gew e1_blech_rund)
		(progn
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq e0_gew (+ (* h_scherl_ht 0.5) anteil_e0_aus_neigung))
			(setq e1_gew 0)
		)
	)
	
	
	(if (> akt_hp min_hp)
		(progn
			(setq e0 e0_gew)
			(setq e0rund (runde e0 auf 5))
			(setq e1 e1_gew)
			(setq e1rund (runde e1 auf 5))
			(print e1rund)
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 e1rund)
														;(e2 400)
			)
		)
		(progn
			(Lochbild.set Lchb_ID (Anz_S 2))
			(setq e0 e0_gew)
			(setq e0rund (runde e0 auf 5))
			
			(Lochbild.set Lchb_ID (e0 e0rund)
														(e1 0)
			)
		)		
	)
	(print e0rund)
	
	;(setq abst_e_aus_at (+ (* r_trg 2.0) s_trg d_schr))
	(setq abst_e_aus_at (+ (* 0.5 b_trg) r_trg (* 0.5 s_trg)))
	(print abst_e_aus_at)
	(print e1_blech_rund)
	
	(if (>= e1_blech_rund abst_e_aus_at)
		(setq w0 e1_blech_rund)
		(setq w0 abst_e_aus_at)
	)
	(setq w0rund (runde w0 auf 5))
	
	(print e1_blech_rund)
	(print dp_blech)
	(Lochbild.set Lchb_ID	(w0 			w0rund)
												;(klemml 	(+ t_trg dp_blech))
												(dxSKopf  dp_blech)
	)
		
	;(setq min_bp_blech (* 2 w0rund))
	
	;(if (< akt_bp min_bp_blech)
	;	(Blech.set BlechID (bp min_bp_blech))
	;)
	(print "<-----------------------------------------------------------")
)

; ----------------------------------------------------------------------------------------
; ERZEUGT DAS LOCHBILD UND BESTIMMT DIE XPOS
; ----------------------------------------------------------------------------------------
(defun	createFlanschLochb (Lchb_ID Blech_ID)
	(print "------------------------------------------------------------")
	(print "ERZEUGT FLANSCHLOCHBILD")
	
	; HT-Daten
	(setq h_htrg 			(Traeger.get Htrg h)
				delta_v_ht	(Traeger.get Htrg delta_v)
				rwinkel_stz	(Traeger.get Htrg r_winkel)
				delta_lr_ht	(Traeger.get Htrg delta_lr)
	)
	; AT-Daten
	(setq sysl 				(Traeger.get Tr_ID syslng)
				h_trg				(Traeger.get Tr_ID h)
				delta_v_at	(Traeger.get Tr_ID delta_v)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
	)
	
	(setq at_hwinkel_glob (Connect.get CastaData trg_hwinkel))
	
	; Blech-Daten
	(setq dp_blech 		(Blech.get BLECH_ID dp))
	
	
	(setq flansch 0)	; nur zur Sicherheit und spteren Abfrage ...
	; Art des Flanschlochbildes
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(setq flansch _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(setq flansch _flanschlochbild_uf_)
	)
	; Notlsung - sollte in den Binaries geklrt werden
	(if (= flansch 0) (progn
	   (if (= (Connect.get CastaData anhtlinkesende) 1) (progn
	       (if (= (Connect.get CastaData vatr-lhtr) -1) (setq flansch _flanschlochbild_of_))
	       (if (= (Connect.get CastaData vatr-lhtr)  1) (setq flansch _flanschlochbild_uf_))
	   ))
	   (if (= (Connect.get CastaData anhtrechtesende) 1) (progn
	       (if (= (Connect.get CastaData vatr-lhtr)  1) (setq flansch _flanschlochbild_of_))
	       (if (= (Connect.get CastaData vatr-lhtr) -1) (setq flansch _flanschlochbild_uf_))
	   ))
	   (if (= flansch _flanschlochbild_uf_) (alertBox "Konnte den Flansch am Anschlusstrger nicht ermitteln.\nSetze Unterflansch ein!" "Flange_not_found_at_AT"))
	   (if (= flansch _flanschlochbild_of_) (alertBox "Konnte den Flansch am Anschlusstrger nicht ermitteln.\nSetze Oberflansch ein!" "Flange_not_found_at_AT"))
	))			
	
	; HT-Ende bestimmen
	(if (= (Connect.get CastaData anHtlinkesEnde) 1)
		(setq HtEnde (Traeger.get Htrg links))
	)
	(if (= (Connect.get CastaData anHtrechtesEnde) 1)
		(setq HtEnde (Traeger.get Htrg rechts))
	)
	
	; AT-Ende bestimmen
	(if (= (Connect.get CastaData linkesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID links))
	)
	(if (= (Connect.get CastaData rechtesEnde) 1)
		(setq TrgEnde (Traeger.get Tr_ID rechts))
	)
	
	; HT-ENDE Daten
	(setq v_scherl_ht (TrEnde.get HtEnde vscherl)
				v_winkel_ht	(TrEnde.get HtEnde v_winkel)
	)
	
	; AT-ENDE Daten
	(setq v_winkel_at	(TrEnde.get TrgEnde v_winkel))
	
	
	(calcFlanschLochild Lchb_ID Blech_ID)
	
	
	
	(if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
		(traeger.addabtl HTrg blKpl 0.0 0.0 _kopfplattelinks_)
		(traeger.addabtl Htrg Lchb_ID 0.0 0.0 _kpllochbildlinks_)
   ))
   (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
		(traeger.addabtl HTrg blKpl 0.0 0.0 _kopfplatterechts_)
		(traeger.addabtl Htrg Lchb_ID 0.0 0.0 _kpllochbildrechts_)
   ))
			
	(setq abtl_lb_ht (Traeger.get Htrg Abteil Lchb_ID))
	(setq abtl_lb_at (Traeger.get Tr_ID Abteil Lchb_ID))
			
	; delta_lr Verschiebung 
	; --------------------------
	(setq delta_lr_abtl_ht 0)
	(if (= (Connect.get CastaData satr-shtr)  1)	(setq delta_lr_abtl_ht (+ (- delta_lr_at) delta_lr_ht)))	
	(if (= (Connect.get CastaData satr-shtr) -1)	(setq delta_lr_abtl_ht (+ delta_lr_at delta_lr_ht)))
	
	(Anbauteil.set abtl_lb_ht (Master 0)
														(delta_lr delta_lr_abtl_ht)
	)
	
	(Anbauteil.set abtl_lb_at (Master 1))
		
	
	(if (= LB_DEBUG 1)
		(progn
			; TEST
			(setq lbdummy (Lochbild.create))
			(Lochbild.copy lbdummy Lchb_ID)
			
			(if (= (connect.get CastaData anHtLinkesEnde) 1) (traeger.addabtl Htrg lbdummy 0.0 0.0 _kpllochbildlinks_))
			(if (= (connect.get CastaData anHtRechtesEnde) 1) (traeger.addabtl Htrg lbdummy 0.0 0.0 _kpllochbildrechts_))
			
			(setq abtl_lb_ht_dummy (Traeger.get Htrg Abteil lbdummy))
			(Anbauteil.set abtl_lb_ht_dummy (Master 1)
																			(delta_lr delta_lr_abtl_ht)
			)
			; TESTENDE
		)
	)
	
	(print "ENDE FLANSCHLOCHBILD")
	(print "------------------------------------------------------------")
)



(defun calcFlanschLochild (Lchb_ID Blech_ID)
			(print "BERECHNE FLANSCHLOCHBILD") 
			(setq v_wnkl_ht (Connect.get CastaData hpttrg_vwinkel))
			(setq v_wnkl_at (Connect.get CastaData trg_vwinkel))
			(print v_wnkl_at)
			
			(setq tanVW	(tan (/ (* PI v_wnkl_at) 180.0)))
			(setq cosVW	(cos (/ (* PI v_wnkl_at) 180.0)))
			(print tanVW)
						
			; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			; Winkel des Anbauteils am AT (Riegel)
			; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1) (setq abtl_winkel 180.0))
					(if (= (Connect.get CastaData satr-shtr) -1) (setq abtl_winkel   0.0))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1) (setq abtl_winkel   0.0))
					(if (= (Connect.get CastaData satr-shtr) -1) (setq abtl_winkel 180.0))
				)
			)
						
						
			; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			; XPOS ANBAUTEIL AM AT (Riegel)
			; ++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
			(setq xPos_AT (Connect.get CastaData xPos_at))
			(print xPos_AT)
			
			
			; Positionierung des Anbauteils am Riegel (AT) zum Lochbild der Sttze (HT)
			; --------------------------------------------------------------
			; Anteil Neigung AT	(Verschiebung von xPos_AT auf Systemlinie der Stz)						
			(print "Anteil AT Neigung")
			
			(setq anteil_at_neigung (* (* 0.5 h_trg) tanVW))
				
			(print anteil_at_neigung)
							
			(setq xPos_AT (- xPos_AT anteil_at_neigung))
			
			(print xPos_AT)		
			
(if (= 1 1)	(progn								
			; Anteil Schrge des HT (an Oberflansch der Stz ausrichten) 
			(print "Anteil Schrge des HT")
			(setq vscherl_stz (TrEnde.get HTEnde vscherl))
			(print vscherl_stz)
			(setq vscherl_stz_halb (* 0.5 vscherl_stz))
			(print vscherl_stz_halb)	
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_AT (+ xPos_AT vscherl_stz_halb)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_AT (- xPos_AT vscherl_stz_halb)))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1)	(setq xPos_AT (- xPos_AT vscherl_stz_halb)))
					(if (= (Connect.get CastaData satr-shtr) -1)	(setq xPos_AT (+ xPos_AT vscherl_stz_halb)))
				)
			)	
			
			(print xPos_AT)
))
			

			
(if (= 1 1)	(progn			
			; Einfluss delta_v Verschiebung HT
			; ---------------------------------
			(setq anteil_delta_v (/ delta_v_ht cosVW))
			(print anteil_delta_v)
			(print v_wnkl_ht)
			
			(if (= (Connect.get CastaData vatr-lhtr)  1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1) (setq xPos_AT (- xPos_AT anteil_delta_v)))
					(if (= (Connect.get CastaData satr-shtr) -1) (setq xPos_AT (+ xPos_AT anteil_delta_v)))
				)
			)
			(if (= (Connect.get CastaData vatr-lhtr) -1)
				(progn
					(if (= (Connect.get CastaData satr-shtr)  1) (setq xPos_AT (+ xPos_AT anteil_delta_v)))
					(if (= (Connect.get CastaData satr-shtr) -1) (setq xPos_AT (- xPos_AT anteil_delta_v)))
				)
			)
))			
			
(if (= 1 1)	(progn		
			; Einfluss delta_v Verschiebung AT
			; ---------------------------------
			(setq anteil_at_delta (* delta_v_at tanVW))
			(print anteil_at_delta)
			
			(setq xPos_AT (- xPos_AT anteil_at_delta))
))			
			
			
			
		
			(print xPos_AT)
			(traeger.addabtl Tr_ID Lchb_ID xPos_AT abtl_winkel flansch)
	
	; ANSCHLUSS ZWISCHEN ENDEN
	; ------------------------
	; ENDE
)
(defun LochbildAusrichtung_am_HT ( )

  (if (= 1 1) (progn
    (setq abteil (Traeger.get HTrg ABTeil lochb))
    (if (= (Connect.get CastaData rechtesEnde) 1)			; (anHtRechtesEnde) vorher
  	(progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
		(if (= (Connect.get CastaData amHTOberflansch)  1)	(Anbauteil.set abteil (SeitRicht  1)))
	)
    )
    (if (= (Connect.get CastaData linkesEnde) 1)			; (anHtLinkesEnde vorher)
  	(progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
		(if (= (Connect.get CastaData amHTOberflansch)  1)	(Anbauteil.set abteil (SeitRicht -1)))
	)
    )
   ))
   (if (= 1 1) (progn
     (setq abteil (Traeger.get Tr_ID ABTeil lochb))
     (if (= (Connect.get CastaData rechtesEnde) 1)
  	(progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht  1)))
		(if (= (Connect.get CastaData amHTOberflansch)  1)	(Anbauteil.set abteil (SeitRicht -1)))
	)
     )
     (if (= (Connect.get CastaData linkesEnde) 1)
  	(progn
		(if (= (Connect.get CastaData amHTUnterflansch) 1)	(Anbauteil.set abteil (SeitRicht -1)))
		(if (= (Connect.get CastaData amHTOberflansch)  1)	(Anbauteil.set abteil (SeitRicht  1)))
	)
     )
   ))

   (if (= (Connect.get CastaData amATOberflansch)  1)	(progn
     (setq abteil (Traeger.get HTrg ABTeil lochb))
     (setq sRicht (Anbauteil.get abteil SeitRicht))
     (Anbauteil.set abteil (SeitRicht  (- sRicht)))
   ))
)
