; $ HT	QT(IUKRL)	AF(S)		P(EZ)
; $ AT	QT(IU)		AF(F)		P(E)
; $ AE	V(-)			H(90)			R(-)

(defun load-modules ()
   (load "mod-endinit-uz_auf_stzKopf_ortho")
   (load "mod-lochbild")
)

(defun init-connection ()

		; Lochbild Test ein- / ausschalten
		(setq LB_DEBUG 0)
		
    (init-traegerenden)
    
    (print "BERECHNE ANSCHLUSS ...")
    
    ; Sttzenende ermitteln
    ; --------------------------------------------
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) (progn
        (setq Stz_Ende (Traeger.get Htrg links))
    ))
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) (progn
        (setq Stz_Ende (Traeger.get Htrg rechts))
    ))
    
    
    (setq blKpl (blech.create))
    (setq kplLochbild (Lochbild.create))
    (Connect.storeAnschlObjs CastaData blKpl kplLochbild)
    
    ; Kopfplatte berechnen
    ; --------------------------------------------
    (calcAndSetBlechdaten blKpl Stz_Ende)
    
    ; Anbauteil (Kopfplatte) der Sttze hinzufgen
    ; --------------------------------------------
    (if (= (Connect.get CastaData anHtLinkesEnde) 1) (Traeger.addabtl Htrg blKpl 0.0 0.0 _kopfplattelinks_))
    (if (= (Connect.get CastaData anHtRechtesEnde) 1) (Traeger.addabtl Htrg blKpl 0.0 0.0 _kopfplatterechts_))
    
    
    ; Lochbild-Daten berechnen
    ; --------------------------------------------
    (calcAndSetLochbildDaten kplLochbild Stz_Ende blKpl)	
    
    ; Anbauteil (Lochbild Sttze) hinzufgen
    ; --------------------------------------------
    (if (= (Connect.get CastaData anHtLinkesEnde) 1)	(traeger.addabtl Htrg kplLochbild 0.0 0.0 _kpllochbildlinks_))
    (if (= (Connect.get CastaData anHtRechtesEnde) 1)	(traeger.addabtl Htrg kplLochbild 0.0 0.0 _kpllochbildrechts_))
    
    ; Anbauteil (Lochbild Riegel) erzeugen, hinzufgen und ausrichten
    ; --------------------------------------------
    (createLochbild kplLochbild blKpl)


    (if (= (connect.get CastaData anHtLinkesEnde) 1) (progn
        (if (= (connect.get CastaData amAtOberflansch) 1) (progn
;            (print "Setze Seitenrichtung")
            (setq abtlFlLochb (Traeger.get Htrg ABTeil kplLochbild))
            (if abtlFlLochb  (Anbauteil.set  abtlFlLochb (SeitRicht -1)))
        ))
    ))		
    (if (= (connect.get CastaData anHtRechtesEnde) 1) (progn
        (if (= (connect.get CastaData amAtUnterflansch) 1) (progn
;            (print "Setze Seitenrichtung")
            (setq abtlFlLochb (Traeger.get Htrg ABTeil kplLochbild))
            (if abtlFlLochb  (Anbauteil.set  abtlFlLochb (SeitRicht -1)))
        ))
    ))		


    (if (= 1 2) (progn
       (Lochbild.set kplLochbild (LB_Art 2) (w0 80) (e0 0) (e1 50) (e2 120))
       (setq abtlFlLochb_HT (Traeger.get Htrg  ABTeil kplLochbild))
       (setq abtlFlLochb_AT (Traeger.get Tr_ID ABTeil kplLochbild))
    
       (Anbauteil.set abtlFlLochb_HT (Master 0))
       (Anbauteil.set abtlFlLochb_AT (Master 1))
       
       (setq Seit_Richt_AT (Anbauteil.get abtlFlLochb_AT SeitRicht))
       (setq Seit_Richt_HT (Anbauteil.get abtlFlLochb_HT SeitRicht))
    ))


		; ******************************************
	  ; TEST FR MEHRFACHANSCHLUSS (FLANSCHSEITE)
	  ; ******************************************
	  (setq anzAnschl (Connect.get CastaData anz_weitere_anschl))
	  (print anzAnschl)
	  
	  (if (/= anzAnschl 0)
	  	(progn
	  		(alertBox "An dem Knoten ist bereits ein Anschluss vorhanden. Fgen Sie ggf. Anbauteile manuell ein oder nderen Sie die Reihenfolge der Anschlsse."    "ERR_OrderOfConnections")
	  	)
	  	(progn
	  		(createSteife)
	  	)
	  )
	  
	  ; CALLBACK
	  ; --------------------------------------------
 		(Blech.set blKpl (formFkt "cb_KplBlech"))
 
)


; ----------------------------------------------------------------------------------------
; CALLBACK-FUNKTIONEN
; ----------------------------------------------------------------------------------------
(defun cb_KplBlech (zp)
	(print "in Callback-Funktion cb_KplBlech")
	(print zp)
	;; Bei zp == 0 den alten Zustand merken. Es brauchen
	;; lediglich die Werte gemerkt werden, die andere Objekte
	;; beeinflussen
	(if (= zp 0) (progn
	    (setq dpAlt (Blech.get blKpl dp))
	))
	;; Wenn zp == 1, dann auf genderte Werte berprfen
	;; Die nderungen knnen auch in einer Funktion erfolgen.
	;; Nur MUSS diese Funktion in derselben Datei gespeichert sein
	;; (nicht in externen Moduln), weil diese Datei mit den Callbacks
	;; eingeladen wird.
	(if (= zp 1) (progn
	    (setq dpNeu (Blech.get blKpl dp))
	    
	    (print dpAlt) (print dpNeu)
	    
	    (if (/= dpAlt dpNeu) (progn
	       (setq dpDiff (- dpNeu dpAlt))
	       (setq alteKlemml (Lochbild.get kplLochbild Klemml))
	       (setq altesDxS		(Lochbild.get kplLochbild dxsKopf))
	       
	       (Lochbild.set kplLochbild 	(Klemml (+ alteKlemml dpDiff))
	       														(DxSKopf (+ altesDxS dpDiff))
	       )
	    ))
	))
)





; ====================================================================== 
; ====================================================================== 
; ----------------------------------------------------------------------
(defun calcAndSetBlechdaten (blKopfplatte TrgEnde)

  (print "----------------------------- In calcAndSetBlechdaten")

  (setq h_ht 	(Traeger.get Htrg h)
  			t_ht	(Traeger.get Htrg t)
  			b_ht	(Traeger.get Htrg b)
	)
	
	(setq t_at	(Traeger.get Tr_ID t))
	
	(setq hscherl_ht	(TrEnde.get TrgEnde hscherl))
	
	(setq hp h_ht)		; erstmal so voreinstellen
  (setq bp 120)
  (setq dOK  5)

	; Blechdicke
	; ----------------------------------------------
	(setq t_ht_rund (runde t_ht auf 10))
	(setq dp t_ht_rund)
	
	; Schraubenbezeichnung aus min. Blechdicke ("mod-lochbild")
	(if (< dp t_at)
		(setq min_bl dp)
		(setq min_bl t_at)
	)
	(calcSchraube min_bl) 	; -> S_Bez
	(print s_bez)
	; Schraubenbezeichnung den Lochbildern zuweisen
	(Lochbild.set kplLochbild (S_Bez S_Bez))
	
	
	
  (setq EWinkel (TrEnde.get TrgEnde V_Winkel))
  (print EWinkel)
	(setq sinW (sin (* PI (/ EWinkel 180.0))))
	(if (/= sinW 0) (setq hp (/ hp sinW)))

  (setq hp (- hp dOK 5))	; wir erzeugen eine bndige Kopfplatte
	      
	; Kopfplattenbreite
	; --------------------------
	(setq bp hscherl_ht)
	
	
	; man msste die erforderliche Breite ber den Schraubendurchmesser ausrechnen
	; und der Schraubendurchmesser richtet sich nach der Hhe des Profils
	; wre auf jeden Fall eine sinnvolle Abhngigkeit
	(Blech.set blKopfplatte (dp dp) 
													(hp hp) 
													(bp bp) 
													(dOK dOK)
	)

  (setq atDeltaV (Traeger.get Tr_ID delta_V))

  (setq delta_L dp)
  (if (> vwnkl_aflch 180) (setq delta_L (- delta_L)))
  (print delta_L)
    
  (TrEnde.pTrim TrgEnde dp)

	
)


; ----------------------------------------------------------------------------------------
; Berechnet die Lochbilddaten
; ----------------------------------------------------------------------------------------
(defun calcAndSetLochbildDaten (Lchb_ID TrgEnde BlechID)
	(print "------------------------------------------------------------")
	(print "BERECHNE LOCHBILDDATEN")
	(Lochbild.set Lchb_ID 
		(Guete   "4.6")
		(e       "60 0 0 0 0 0")
		(w       "80  0")
	)
	
	; allg. Daten
	; ----------------------------------------------
	(setq h_trg (Traeger.get Tr_ID h)
				s_trg (Traeger.get Tr_ID s)
				b_trg	(Traeger.get Tr_ID b)
				r_trg (Traeger.get Tr_ID r)
				t_trg	(Traeger.get Tr_ID t)
	)
	
	(setq t_htrg 			(Traeger.get Htrg t)
				h_htrg			(Traeger.get Htrg h)
				s_htrg			(Traeger.get Htrg s)
				r_htrg			(Traeger.get Htrg r)
				b_ht				(Traeger.get Htrg b) 
				delta_l_ht	(Traeger.get Htrg delta_l)
	)
	
	(setq h_trg_halb	(* h_trg 0.5))
	
	(setq akt_hp 		(Blech.get BlechID hp)
				akt_dok		(Blech.get BlechID dok)
				dp_blech	(Blech.get BlechID dp)
	)
	
	(if (< dp_blech t_trg)
		(setq min_blech dp_blech)
		(setq min_blech t_trg)
	)
	(print min_blech)

	; Schraubengre ermitteln und setzen
	(calcSchraube min_blech)
	(Lochbild.set Lchb_ID (S_Bez S_Bez))
	(print S_Bez)
	 
	; Den entsprechenden Durchmesser holen
	(setq d_schr (Lochbild.get Lchb_ID sdurchm))
	
	(setq e_blech (* d_schr 2.0))				; Randabstand
	(setq e1_blech (* d_schr 4.0))			; Lochabstand
	
	(setq e_blech_rund (runde e_blech auf 5))
	(setq e1_blech_rund (runde e1_blech auf 5))
	
	(setq min_hp (+ e1_blech_rund (* e_blech_rund 2.0))) ; min. Winkelhhe aus Lochbild
		
	(print akt_dok)
	
	
	(if (< akt_hp b_trg)
		(progn
			(setq e0 (* akt_hp 0.25))		
			(setq e1 (* akt_hp 0.5))
		)
		(progn
			(setq diff (- h_htrg b_trg))
			(setq diff_halb (* 0.5 diff))
			
			(setq ant_at (* 0.25 (- b_trg s_trg (* 2.0 r_trg))))
			
			(setq e0 (+ diff_halb ant_at))
			(setq e1 (+ s_trg (* 2.0 r_trg) (* 2.0 ant_at)))
		)
	)

	(setq e0rund (runde e0 auf 5))					
	(setq e1rund (runde e1 auf 5))
			
	(Lochbild.set Lchb_ID (e0 e0)
												(e1 e1)
												;(e2 200)
	)
	
	(if (= LB_DEBUG 1)
			(Lochbild.set Lchb_ID (e2 400))
	)
	
	; w0
	; --------------------------
	(setq w0 (+ (* 0.5 b_ht) r_htrg (* 0.5 s_htrg)))
	;(setq w0 (+ s_htrg (* 0.5 r_htrg) e1_blech_rund))
	(setq w0 (runde w0 auf 5))
	
	;(Lochbild.set Lchb_ID (w0 e1_blech_rund))
	(Lochbild.set Lchb_ID (w0 w0))
	
	(Lochbild.set Lchb_ID (klemml 	(+ t_trg dp_blech))
			      						(dxSKopf  dp_blech)
			      						
			      						
	)
		
	;(Blech.set BlechID (bp (+ (* 2 e_blech_rund) w0)))
	
	(print "ENDE LOCHBILDDATEN")
	(print "------------------------------------------------------------")
)


; ----------------------------------------------------------------------------------------
; Erzeugt das Lochbild
; ----------------------------------------------------------------------------------------
(defun createLochbild (Lchb_ID BlechID)
	(print ">-----------------------------------------------------------")
	(print "ERZEUGE FLANSCHLOCHBILD")
	(setq xPos_at 		(Connect.get CastaData xPos_at)
				vwinkel_at	(Connect.get CastaData trg_vwinkel)
	)
	
	(setq h_at				(Traeger.get Tr_ID h)
				delta_lr_at	(Traeger.get Tr_ID delta_lr)
				delta_v_at	(Traeger.get Tr_ID delta_v)
	)
	
	(setq h_ht				(Traeger.get Htrg h))
	
	(setq delta_lr_ht	(Traeger.get Htrg delta_lr)
				delta_v_ht	(Traeger.get Htrg delta_v)
	)
	
	(setq e0 (Lochbild.get Lchb_ID e0)
				e1 (Lochbild.get Lchb_ID e1)
	)
	
	(setq tanW (tan (/ (* PI vwinkel_at) 180.0)))
	(setq cosW (cos (/ (* PI vwinkel_at) 180.0)))
	
	(if (= (Connect.get CastaData amAtOberflansch) 1)
		(setq Flansch _flanschlochbild_of_)
	)
	(if (= (Connect.get CastaData amAtUnterflansch) 1)
		(setq Flansch _flanschlochbild_uf_)
	)
	
	
	; **********************************************
	; Anbauteil AT (Riegel)
	; **********************************************
	
	; Anbauteilwinkel HT
	; ----------------------------------------------
	(if (= (Connect.get CastaData satr-vhtr)  1)	(setq winkel_abtl_at 270.0))
	(if (= (Connect.get CastaData satr-vhtr) -1)	(setq winkel_abtl_at  90.0))
	
	; Verschiebung aus Neigung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ---------------------------------------------- 
		(setq dp_kpl	(Blech.get BlechID dp))
		(setq h_at_halb (* 0.5 h_at))
		(setq anteil_at_neigung (* (+ h_at_halb dp_kpl) tanW))
		(print anteil_at_neigung)
		(setq xPos_at (- xPos_at anteil_at_neigung))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; delta_lr Verschiebung HT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq anteil_delta_lr_ht (/ (* 1.0 delta_lr_ht) cosW))
		
		(if (= (Connect.get CastaData vatr-lhtr) -1)
			(progn
				(if (= (Connect.get CastaData satr-vhtr)  1)	(setq xPos_at (- xPos_at anteil_delta_lr_ht)))
				(if (= (Connect.get CastaData satr-vhtr) -1)	(setq xPos_at (+ xPos_at anteil_delta_lr_ht)))
			)
		)
		(if (= (Connect.get CastaData vatr-lhtr)  1)
			(progn
				(if (= (Connect.get CastaData satr-vhtr)  1)	(setq xPos_at (+ xPos_at anteil_delta_lr_ht)))
				(if (= (Connect.get CastaData satr-vhtr) -1)	(setq xPos_at (- xPos_at anteil_delta_lr_ht)))
			)
		)
		(print xPos_at)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; delta_v Verschiebung AT
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq anteil_delta_v_at (* delta_v_at tanW))
		(setq xPos_at (- xpos_at anteil_delta_v_at))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	; Anbauteil hinzufgen
	; ----------------------------------------------
	(Traeger.addabtl Tr_ID Lchb_ID xPos_at winkel_abtl_at Flansch)
	
	
	; Lochbild des AT an LB-Position des HT anpassen
	(setq delta_v_abtl_at (- (* 0.5 h_ht)))
	
	



	; **********************************************
	; Anbauteil HT (Riegel)
	; **********************************************
	(setq delta_v_abtl_ht 0.0)

	; Anteil der delta_lr Verschiebung des Riegels (AT) an der delta_v Verschiebung Anbauteil LB Sttze (HT)
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_v_abtl_ht (+ delta_v_abtl_ht delta_lr_at)))
		(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_lr_at)))
	; ----------------------------------------------
	))
	; ----------------------------------------------	
	
	; Anteil der delta_v Verschiebung der Sttze (HT) an der delta_v Verschiebung Anbauteil LB Sttze (HT)
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(if (= (Connect.get CastaData satr-vhtr)  1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_ht)))
		(if (= (Connect.get CastaData satr-vhtr) -1)	(setq delta_v_abtl_ht (- delta_v_abtl_ht delta_v_ht)))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	


	
	
	; Master setzen
	; ----------------------------------------------
	(setq HT_ABTeil (Traeger.get Htrg AbTeil Lchb_ID))
	(Anbauteil.set HT_ABTeil 	(Master    	0)
				 										(delta_v 		delta_v_abtl_ht)
				 										
	)
	(setq AT_ABTeil (Traeger.get Tr_ID AbTeil Lchb_ID))
	(Anbauteil.set AT_ABTeil 	;(winkel  0.0)
				 										(Master      1)
				 										(delta_v delta_v_abtl_at)
	)
	

	; LOCHBILD-TEST
	;===================================================================
	(if (= LB_DEBUG 1)
		(progn
			(setq dummy (Lochbild.create))
			(Lochbild.copy dummy Lchb_ID)
						
			(if (= (connect.get CastaData anHtLinkesEnde) 1) 
				(traeger.addabtl Htrg dummy 0.0 0.0 _kpllochbildlinks_)
    	)
	    (if (= (connect.get CastaData anHtRechtesEnde) 1) 
				(traeger.addabtl Htrg dummy 0.0 0.0 _kpllochbildrechts_)
	    )
			
			(setq dummy_abtl (Traeger.get Htrg Abteil dummy))
			(Anbauteil.set dummy_abtl (Master 1)	
																(delta_v delta_v_abtl_ht)
			)
		)
	)
	;===================================================================

	(print "<-----------------------------------------------------------")
)


(defun createSteife ()
	(print ">-------------------------------------------------------------------------------")
	(print "ERZEUGE STEIFE IM UNTERZUG")
	
	(setq blSteife (Blech.create))
	(Connect.storeAnschlObjs CastaData blSteife)
	
	(setq delta_v_at (Traeger.get Tr_ID delta_v))
	
	(setq xPos_at 		(Connect.get CastaData xPos_at)
				vwinkel_at 	(Connect.get CastaData trg_vwinkel)
	)
	
	(setq tanW (tan (/ (* PI vwinkel_at) 180.0)))
	(setq cosW (cos (/ (* PI vwinkel_at) 180.0)))
	
	
	
	; xPos der Steife am Unterzug berechnen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	
	; Anteil der delta_v Verschiebung des UZ (AT)
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq anteil_delta_v_at (* delta_v_at tanW))
		(setq xPos_at (- xpos_at anteil_delta_v_at))
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	; Anteil der delta_lr Verschiebung der Sttze (HT)
	; ----------------------------------------------
	(if (= 1 1)	(progn
	; ----------------------------------------------
		(setq anteil_delta_lr_ht (/ (* 1.0 delta_lr_ht) cosW))
		
		(if (= (Connect.get CastaData vatr-lhtr) -1)
			(progn
				(if (= (Connect.get CastaData satr-vhtr)  1)	(setq xPos_at (- xPos_at anteil_delta_lr_ht)))
				(if (= (Connect.get CastaData satr-vhtr) -1)	(setq xPos_at (+ xPos_at anteil_delta_lr_ht)))
			)
		)
		(if (= (Connect.get CastaData vatr-lhtr)  1)
			(progn
				(if (= (Connect.get CastaData satr-vhtr)  1)	(setq xPos_at (+ xPos_at anteil_delta_lr_ht)))
				(if (= (Connect.get CastaData satr-vhtr) -1)	(setq xPos_at (- xPos_at anteil_delta_lr_ht)))
			)
		)
		(print xPos_at)
	; ----------------------------------------------
	))
	; ----------------------------------------------
	
	
	
	
	
	; Winkel der Steife 
	; ++++++++++++++++++++++++++++++++++++++++++++++
	(print vwinkel_at)
	
	(if (> vwinkel_at 180.0)	
		(setq winkel_steife (- 360.0 vwinkel_at))
		(setq winkel_steife (- vwinkel_at))
	)
	
	
	; Steife hinzufgen
	; ++++++++++++++++++++++++++++++++++++++++++++++
	(Traeger.addabtl Tr_ID blSteife xPos_at winkel_steife _vollsteife_beids_)
	
	(print "<-------------------------------------------------------------------------------")
)